<?php
/**
 * The template for displaying Comments.
 */

/**
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
    return;
}
?>
<div id="comments">
    <?php
    if (comments_open() && !have_comments()) :
        ?>
        <h2 id="comments-title">
            <?php
            esc_html_e('نظری ثبت نشده است', 'escapezoom-v1');
            ?>
        </h2>
    <?php
    endif;

    if (have_comments()) :
        ?>
        <h2 id="comments-title">
            <?php
            $comments_number = get_comments_number();
            if ('1' === $comments_number) {
                printf(_x('پاسخ به &ldquo;%s&rdquo;', 'عنوان نظر', 'escapezoom-v1'), get_the_title());
            } else {
                printf(
                /* translators: 1: number of comments, 2: post title */
                    _nx(
                        '%1$s نظر;',
                        '%1$s نظر',
                        $comments_number,
                        'comments title',
                        'escapezoom-v1'
                    ),
                    number_format_i18n($comments_number),
                    get_the_title()
                );
            }
            ?>
        </h2>
        <?php
        if (get_comment_pages_count() > 1 && get_option('page_comments')) :
            ?>
            <nav id="comment-nav-above">
                <h1 class="assistive-text"><?php esc_html_e('صفحه نظرات', 'escapezoom-v1'); ?></h1>
                <div class="nav-previous"><?php previous_comments_link(__('&larr; نظرات قدیمی', 'escapezoom-v1')); ?></div>
                <div class="nav-next"><?php next_comments_link(__('نظرات جدیدتر &rarr;', 'escapezoom-v1')); ?></div>
            </nav>
        <?php
        endif;
        ?>
        <ol class="commentlist">
            <?php
            /**
             * Loop through and list the comments. Tell wp_list_comments()
             * to use theme_comment() to format the comments.
             * If you want to overload this in a child theme then you can
             * define theme_comment() and that will be used instead.
             * See theme_comment() in my-theme/functions.php for more.
             */
            wp_list_comments(array('callback' => 'escapezoom_v1_comment'));
            ?>
        </ol>
        <?php
        if (get_comment_pages_count() > 1 && get_option('page_comments')) : ?>
            <nav id="comment-nav-below">
                <h1 class="assistive-text"><?php esc_html_e('نظرات', 'escapezoom-v1'); ?></h1>
                <div class="nav-previous"><?php previous_comments_link(__('نظرات قدیمی تر', 'escapezoom-v1')); ?></div>
                <div class="nav-next"><?php next_comments_link(__('نظرات جدیدتر', 'escapezoom-v1')); ?></div>
            </nav>
        <?php
        endif;

    /**
     * If there are no comments and comments are closed, let's leave a little note, shall we?
     * But we don't want the note on pages or post types that do not support comments.
     */
    elseif (!comments_open() && !is_page() && post_type_supports(get_post_type(), 'comments')) :
        ?>
        <h2 id="comments-title" class="nocomments"><?php esc_html_e('نظرات بسته شده است.', 'escapezoom-v1'); ?></h2>
    <?php endif;

    comment_form(); ?>
    <!--   <script src="https://www.google.com/recaptcha/api.js"></script>-->
    <!--<script src="https://escapezoom.ir/ezemoji/lc_emoji_picker.min.js" type="text/javascript"></script>-->
    <script>
        function onSubmit(token) {
            document.getElementById("commentform").submit();
        }

        const button = document.getElementById("submit");

        button.setAttribute("data-sitekey", "6LdP9aIoAAAAACttQ7qy8mPF1eJxucJ9mSNIBCgJ");
        button.setAttribute("class", "g-recaptcha submit");
    </script>
    <style>
        .grecaptcha-badge {
            margin-bottom: 60px
        }
    </style>
    <script type="text/javascript">
        new lc_emoji_picker('textarea, input', {

            picker_trigger:
                '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve"><g><g><path d="M437.02,74.98C388.667,26.629,324.38,0,256,0S123.333,26.629,74.98,74.98C26.629,123.333,0,187.62,0,256s26.629,132.668,74.98,181.02C123.333,485.371,187.62,512,256,512s132.667-26.629,181.02-74.98C485.371,388.668,512,324.38,512,256S485.371,123.333,437.02,74.98z M256,472c-119.103,0-216-96.897-216-216S136.897,40,256,40s216,96.897,216,216S375.103,472,256,472z"/></g></g><g><g><path d="M368.993,285.776c-0.072,0.214-7.298,21.626-25.02,42.393C321.419,354.599,292.628,368,258.4,368c-34.475,0-64.195-13.561-88.333-40.303c-18.92-20.962-27.272-42.54-27.33-42.691l-37.475,13.99c0.42,1.122,10.533,27.792,34.013,54.273C171.022,389.074,212.215,408,258.4,408c46.412,0,86.904-19.076,117.099-55.166c22.318-26.675,31.165-53.55,31.531-54.681L368.993,285.776z"/></g></g><g><g><circle cx="168" cy="180.12" r="32"/></g></g><g><g><circle cx="344" cy="180.12" r="32"/></g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',

            trigger_position: {
                top: '5px',
                left: '5px',
            },
            trigger_size: {
                height: '22px',
                width: '22px',
            },

            target_r_padding: 27,

            emoji_json_url: 'https://escapezoom.ir/ezemoji/emoji-list.min.json',

            labels: [
                'اضافه کردن',
                'جستجو',
                'بدون نتیجه',
            ],

            selection_callback: null,
        });
    </script>

    <script>
        let comment = document.getElementById("comment");
        comment.addEventListener("input", function (g) {
            comment.setCustomValidity('');
        });
        comment.addEventListener("invalid", function (g) {
            comment.setCustomValidity('لطفا نظر خود را وارد نمایید.');
        });
    </script>


    <script>
        jQuery('document').ready(function ($) {
            var commentform = $('#commentform');
            commentform.append('<div id="comment-status"></div>');
            var statusdiv = $('#comment-status');

            commentform.submit(function () {
                var formdata = commentform.serialize();
                formdata += '&email=user@escapezoom.ir'

                // statusdiv.html('<p>در حال ثبت نظر...</p>');

                var formurl = commentform.attr('action');

                $.ajax({
                    type: 'post',
                    url: formurl,
                    data: formdata,
                    beforeSend: function () {
                        commentform.find("input[type='submit']")
                            .val("در حال ثبت دیدگاه")
                            .attr("disabled", true)
                            .css("opacity", .5)
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        statusdiv.html('<p class="ajax-error text-danger" >دیدگاه شما ثبت شده است ، امکان ثبت مجدد شما در این زمان وجود ندارد</p>');

                        commentform.find("input[type='submit']")
                            .val("فرستادن دیدگاه")
                            .removeAttr("disabled")
                            .css("opacity", 1)
                    },
                    success: function (data, textStatus) {
                        if (data == "success" || textStatus == "success") {
                            statusdiv.html('<p class="ajax-success text-success" >با تشکر از شما ، نظر شما با موفقیت ثبت شد و پس از تایید نمایش داده خواهد شد.</p>');
                        } else {
                            statusdiv.html('<p class="ajax-error text-danger" >لطفا تا ثبت نظر بعدی کمی صبر نمایید.</p>');
                            commentform.find('textarea[name=comment]').val('');
                        }

                        commentform.find("input[type='submit']")
                            .val("فرستادن دیدگاه")
                            .removeAttr("disabled")
                            .css("opacity", 1)
                    },
                });
                return false;
            });
        });
    </script>

    <script>
        let author = document.getElementById("author");
        author.addEventListener("input", function (e) {
            author.setCustomValidity('');
        });
        author.addEventListener("invalid", function (e) {
            author.setCustomValidity('لطفا نام خود را وارد نمایید.');
        });
    </script>
    <script>
        let email = document.getElementById("email");
        email.addEventListener("input", function (f) {
            email.setCustomValidity('');
        });
        email.addEventListener("invalid", function (f) {
            email.setCustomValidity('لطفا ایمیل خود را وارد نمایید.');
        });
    </script>
    <style>
        .commentlist > li.comment {
            border: 1px solid #CCC;
            padding: 20px !important;
            border-radius: 8px;
        }

        .commentlist > li.comment .comment-author .fn {
            background: #f96f0c;
            color: #FFF;
            display: inline-flex;
            padding: 4px 12px;
            border-radius: 7px;
            position: relative;
        }

        .commentlist > li.comment .comment-author .fn:before {
            content: '';
            position: absolute;
            border-right: 8px solid #f96f0c;
            border-top: 8px solid #f96f0c;
            bottom: -8px;
            border-left: 8px solid transparent;
            border-bottom: 8px solid transparent;
            right: 8px;
        }
        #respond #email-notes {
            display: block;
            font-size: 12px;
            color: #e10b3b;
            display: none;
        }
        .commentlist > li.comment .comment-author .esmtime:hover {
            color: #FFF;
        }

        .commentlist > li.comment .comment-respond {
            margin-top: 40px;
        }

        .commentlist > li.comment .comment-reply-link {
            background: #FFF;
            color: #f96f0c;
            font-size: 14px;
        }

        .cld-like-dislike-wrap {
            display: flex;
            margin-bottom: 0;
            gap: 12px;
        }

        .cld-like-dislike-wrap > div {
            margin-inline: 0;
        }

        #comments .comment-form {
            display: flex;
            flex-direction: column;
            gap: 12px;

        .logged-in-as a:first-child {
            background: transparent;
            padding: 0;
            border: none;
            color: #f96f0c
        }
        }

        #comments .comment-form .comment-form-author,
        #comments .comment-form .comment-form-comment {
            position: relative;
            margin-top: 26px;
            margin-bottom: 0;

        label {
            position: absolute;
            border: 1px solid #CCC;
            padding: 2px 8px;
            border-radius: 4px;
            background: #FFF;
            top: -16px;
            right: 10px;
        }

        input, textarea {
            width: 100%;
            padding: 12px;
            padding-top: 16px;
            border: 1px solid #CCC;
            border-radius: 5px;
        }
        }
    </style>
</div>