<?php
/**
 * The template for displaying content in the index.php template.
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'col-sm-12' ); ?>>
    <div class="container">
	    <div class="row catrow">
			    <div class="col-sm-6 caimg">
				<?php
						echo '<div class="post-thumbnail">' . get_the_post_thumbnail( get_the_ID(), 'large' ) . '</div>';
				?>
				</div>
				
				<div class="col-sm-6 cadet">
                <h3 class="catit">
                <a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'escapezoom-v1' ), the_title_attribute( array( 'echo' => false ) ) ); ?>" rel="bookmark"><?php the_title(); ?></a>
                </h3>
			<?php
				if ( 'post' === get_post_type() ) :
			?>
				<div class="cameta">
				    <span class="aname">
					<?php
				    	printf( get_the_author() );
						?>
				    </span>
				    
				    <span class="acmcountsp">
				    <?php
						$num_comments = get_comments_number();
						if ( comments_open() && $num_comments >= 1 ) :
							echo ' <a href="' . esc_url( get_comments_link() ) . '" class="acmcount" title="' . esc_attr( sprintf( _n( '%s Comment', '%s Comments', $num_comments, 'escapezoom-v1' ), $num_comments ) ) . '">' . $num_comments . '<i class="icofont-speech-comments"></i></a>';
						endif;
					?>
					</span>
				</div>
				<div class="cacontent">
					<?php the_excerpt() ?>
				</div>
				<a href="<?php the_permalink(); ?>" class="btn btn-outline-secondary authmore">
				    <i class="icofont-hand-drawn-left"></i>
				    <?php esc_html_e( 'ادامه مطلب', 'escapezoom-v1' ); ?>
                </a>
				
			<?php
				endif;
			?>
        </div>  
        </div>
				<?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . esc_html__( 'صفحات:', 'escapezoom-v1' ) . '</span>', 'بعدی' => '</div>' ) ); ?>
	</div>
</article>
