<?php
/**
 * The template for displaying content in the single.php template.
 *
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">
        <div class="tposth">
			<?php the_post_thumbnail( 'full' ); ?>
        </div>
        <h1 class="entry-title"><?php the_title(); ?></h1>
		<?php
		if ( 'post' === get_post_type() ) :
			?>
            <div class="postinfobox" style="padding: 15px;">
                <div class="entry-meta" style="margin-top: unset !important;">
                    <div class="cpadet">
						<?php escapezoom_v1_article_posted_2(); ?>
                    </div>
                    <div class="cpadet">
						<?php
						$author_id      = get_the_author_meta( 'ID' );
						$author_link    = get_author_posts_url( $author_id );
						$author_avatar  = get_avatar( $author_id );
						$author_display = get_the_author( $author_id );

						?>
                        <span class="by-author">
                            <span class="sep">
                                    نویسنده:
                            </span>
                            <span class="author-meta vcard">
                                <a class="url fn n" href="<?php echo $author_link ?>" title="مشاهده تمام مقالات"
                                   rel="author">
                                <?php echo $author_avatar ?><?php echo $author_display ?>
                                </a>
                            </span>
                        </span>
						<?php
						$rw_author        = get_field( "rewrite_author" );
						$rw_author_id     = get_field( 'rewrite_author' )['ID'];
						$rw_author_avatar = get_avatar( $rw_author_id );
						if ( $rw_author ): ?>
                            <span class="sep">
                                بازنویس:
                        </span>
                            <span class="author-meta vcard">
                        <a class="url fn n" href="<?php echo get_author_posts_url( $rw_author_id ) ?>"
                           title="مشاهده تمام مقالات" rel="author">
                            <?php echo $rw_author_avatar ?>
                            <?php echo $rw_author['display_name']; ?>
                        </a>
                        </span>
						<?php endif; ?>
                    </div>
                </div><!-- /.entry-meta -->
                <!-- post View -->
                <div class="cpviw">
			    <span class="cpviwtit">
			    بازدید:
				</span>
					<?php if ( function_exists( 'the_views' ) ) { ?>
						<?php
						if ( current_user_can( 'manage_options' ) ) {
							$viewcpfake  = (int) get_post_meta( $post->ID, 'views', true );
							$viewcpfaket = $viewcpfake * 11;
							echo $viewcpfaket;
							?>
                            <div class="realvw">
        			    <span class="cpviwtit">
                        بازدید واقعی:
                        </span>
								<?php
								$viewcp = get_post_meta( $post->ID, 'views', true );
								echo $viewcp;
								?>
                            </div>
							<?php
						} else {
							$viewcpfake  = get_post_meta( $post->ID, 'views', true );
							$viewcpfaket = $viewcpfake * 11;
							echo $viewcpfaket;
						}
					} ?>
                </div>
            </div>
		<?php
		endif;
		?>
    </header><!-- /.entry-header -->
    <div class="entry-content">

        <div class="espert">
	        <span class="espertit">
	            مقدمه
	        </span>
			<?php
			the_excerpt()
			?>
        </div>

		<?php
		class TOC {
			static function check( $content ) {
				$out = [];

				$pattern = '/<h[2-6].*?[^>]*?>(.*?)<\/h[2-6].*?[^>]*?>/is';

				if ( preg_match_all( $pattern, $content, $matches, PREG_SET_ORDER ) ) {
					$out = $matches;
				}

				return $out;
			}

			static function init( $content ) {
				if ( ! is_singular() ) {
					return $content;
				}

				$items = self::check( $content );

				if ( ! empty( $items ) ) {
					$out = '<div class="toc">';

					$out .= "<h4>فهرست مطالب</h4>";

					$out .= "<ul class='parent start'>";

					foreach ( $items as $key => $item ) {
						$out .= "<li><a href='#" . substr( md5( $key ), 0, 8 ) . "'>" . $item[1] . "</a></li>";
					}

					$out .= "</ul>";

					$out .= '</div>';

					foreach ( $items as $key => $item ) {
						$tag = substr( $item[0], 1, 2 );
						$new = '<' . $tag . ' class="wp-block-heading" id="' . substr( md5( $key ), 0, 8 ) . '">' . $item[1] . '</' . $tag . '>';
						$content = str_replace( $item[0], $new, $content );
					}

					$content = $out . $content;
				}

				return $content;
			}
		}

		add_filter( 'the_content', [ 'TOC', 'init' ] );

		the_content();

		wp_link_pages( array(
			'before' => '<div class="page-link"><span>' . esc_html__( 'Pages:', 'escapezoom-v1' ) . '</span>',
			'after'  => '</div>'
		) );
		?>
    </div><!-- /.entry-content -->

	<?php
	get_template_part( 'author', 'bio' );
	edit_post_link( __( 'Edit', 'escapezoom-v1' ), '<span class="edit-link">', '</span>' );
	?>

    <footer class="entry-meta">
        <div class="cprvw">
            <span>به این مقاله امتیاز دهید</span>
            <div class="cprwsm">
				<?php
				echo do_shortcode( '[ratemypost]' );
				?>
				<?php
				$rating_count = get_field( "rating_counter" );
				if ( $rating_count ):

					?>
                    <script>
                        document.getElementById('ratingf').innerHTML = "<?php echo $rating_count; ?>";
                    </script>
				<?php endif; ?>
            </div>
        </div>
        <hr>
        <span class="scpt">
                در شبکه های اجتماعی به اشتراک بگذارید :
            </span>
        <div class="social-buttons">
            <a href="http://www.instagram.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink() ) ?>"
               target="_blank" class="social-button social-button--instagram" aria-label="instagram">
                <i class="fab fa-instagram"></i>
            </a>
            <a href="http://www.twitter.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink() ) ?>"
               target="_blank" class="social-button social-button--twitter" aria-label="twitter">
                <i class="fab fa-twitter"></i>
            </a>
            <a href="http://www.youtube.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink() ) ?>"
               target="_blank" class="social-button social-button--youtube" aria-label="youtube">
                <i class="fab fa-youtube"></i>
            </a>
        </div>
        <hr>

    </footer><!-- /.entry-meta -->
</article><!-- /#post-<?php the_ID(); ?> -->
