<?php
/**
 *
 * This is the template that displays all of the <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"> section and everything up until <div id="content">
 *
 */
global $zardkooh_options, $wp, $current_user;

if ( isset( $zardkooh_options['favicon'] ) && strlen( $zardkooh_options['favicon']['url'] ) > 0 ) {
    $favicon_href = $zardkooh_options['favicon']['url'];
} else {
    $favicon_href = get_template_directory_uri().'/assets/images/favicon.png';
}

if ( isset( $zardkooh_options['logo'] ) && strlen( $zardkooh_options['logo']['url'] ) > 0 ) {
    $logo_href		= $zardkooh_options['logo']['url'];
    $logo_width		= $zardkooh_options['logo']['width'];
    $logo_height	= $zardkooh_options['logo']['height'];
} else {
    $logo_href		= get_template_directory_uri().'/assets/images/logo.svg';
    $logo_width		= 119;
    $logo_height	= 33;
}

$wishlist_count = 0;
$user_wishlist = get_user_meta( $current_user->ID, 'zardkooh_wishlist', true);
if ( is_array($user_wishlist) && !empty($user_wishlist) ) {
    $wishlist_count = count($user_wishlist);
}

$user_name = ( $current_user->first_name ) ? $current_user->first_name .' '.$current_user->last_name : $current_user->display_name;

$cart_count = WC()->cart->get_cart_contents_count();

$header_diff = false;
if ( isset( $zardkooh_options['header_diff'] ) && $zardkooh_options['header_diff'] == 'one' && !is_page_template('template-categories.php') && !zardkooh_is_mobile() ) {
    $header_diff = true;
} ?>

<html <?php language_attributes(); ?> class="no-js no-svg" id="ezHtml">
<head>

    <!-- Google Tag Manager -->
    <script>(function (w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start':
                    new Date().getTime(), event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-WBCCS78');</script>
    <!-- End Google Tag Manager -->
    
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php
    // noIndex ParkDomain
    if($_SERVER['SERVER_NAME'] == 'escapezoom.co' || $_SERVER['SERVER_NAME'] == 'www.escapezoom.co'){
        echo '<meta name="googlebot" content="noindex">';
        add_filter( 'wp_robots', function( $robots ) {
            $robots['noindex'] = true;
            $robots['nofollow'] = true;
            return $robots;
        });
    }else {
        add_filter( 'wp_robots', function( $robots ) {
            $robots['index'] = true;
            $robots['follow'] = true;
            return $robots;
        });
    }
    ?>
    <?php
    if ( is_page( '408' ) && is_paged() ) { 
        echo'
        <link rel="canonical" href="https://escapezoom.ir/" />
        <script type="application/ld+json">
            {
            "@context": "http://schema.org/",
            "@type": "WebSite",
            "url": "https://escapezoom.ir/",
            "potentialAction": {
            "@type": "SearchAction",
            "target": "https://escapezoom.ir/shop/?s={search_term_string}",
            "query-input": "required name=search_term_string"
            }
            }
        </script>
        ';
    }
    ?>
    <?php 
    $iPhone  = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
    $iPad    = stripos($_SERVER['HTTP_USER_AGENT'],"iPad"); ?>
    
    <link rel="stylesheet" type="text/css" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/fonts/icofont/icofont.min.css">
    <link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/blogstyle.css?ver=1.105">
    <meta name="google-site-verification" content="g6d4w2ZCOX7Felr9o7yANiH3Zq4A-9IOYzCei4N5KhA" />

    <script>
        !function (t, e, n) {
            t.yektanetAnalyticsObject = n, t[n] = t[n] || function () {
                t[n].q.push(arguments)
            }, t[n].q = t[n].q || [];
            var a = new Date,
                r = a.getFullYear().toString() + "0" + a.getMonth() + "0" + a.getDate() + "0" + a.getHours(),
                c = e.getElementsByTagName("script")[0], s = e.createElement("script");
            s.id = "ua-script-U8CPiSAN";
            s.dataset.analyticsobject = n;
            s.async = 1;
            s.type = "text/javascript";
            s.src = "https://cdn.yektanet.com/rg_woebegone/scripts_v3/U8CPiSAN/rg.complete.js?v=" + r, c.parentNode.insertBefore(s, c)
        }(window, document, "yektanet");
    </script>
    
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBCCS78" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

<!-- Blog Header ( D.W Other Pages !important) -->
<header>
    <?php if( wp_is_mobile()){ ?>
        <nav class="navbar navbar-light mobile-show">
            <div class="container mt-3">
                <div class="row w-100 m-0">
                    <div class="mobile-top-col-center text-center col-12">
                        <a class="navbar-brand" href="https://escapezoom.ir/"><img src="https://escapezoom.ir/wp-content/uploads/2021/11/logo-new.png" class="img-fluid  mx-auto d-block" alt="اسکیپ زوم"></a>
                    </div>
                </div>
                <div class="row w-100  m-0" id="mobile-icons-top">


                    <div class="mobile-top-col-right col-2 iconmnav">
                        <img src="https://escapezoom.ir/wp-content/themes/escapezoom-v1/img/burger-menu.png" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" class="mx-auto d-block hamber-3bar">
                    </div>

                    <div class="mobile-top-col-left col-10 mblogs">
                        <form id="searchform" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <input type="text" class="search-field" name="s" placeholder="جستجو مقالات ..." value="<?php echo get_search_query(); ?>" />
                        </form>
                    </div>
                </div>
                <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
                    <div class="offcanvas-header">
                        <i class="icon-delecte-2 text-dark nav-link item-tmm" data-bs-dismiss="offcanvas" aria-label="Close"></i>



                    </div>
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-start flex-grow-1 pe-3 ">
                            <li class="nav-item">
                                <a class="nav-link active" aria-current="page" href="https://escapezoom.ir/blog">
                                    مجله اسکیپ زوم
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" aria-current="page" href="#">
                                    صفحه اصلی
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" aria-current="page" href="#">
                                    اتاق فرار
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" aria-current="page" href="#">
                                    سرگرمی های خاص
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" aria-current="page" href="#">
                                    مقالات ترسناک
                                </a>
                            </li>
                        </ul>
                        <a class="nav-link item-tmm text-light mt-3 contactbtn" href="https://escapezoom.ir/contact-us/" role="button"> <i class="icon-call-big"></i> تماس با ما</a>

                    </div>
                </div>
            </div>
        </nav>
        <div class="collapse" id="searcharia">
            <div class="card card-body rounded-0">
                <?php if (wp_is_mobile()): ?>
                    <?php   //echo do_shortcode('[top_search_view]');?>
                    <form id="searchform" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <input type="text" class="search-field" name="s" placeholder="جستجو مقالات ..." value="<?php echo get_search_query(); ?>" />
                    </form>

                <?php endif ?>

            </div>
        </div>

    <?php } else { ?>
    <!-- Header Desktop Version ES 1.1 -->
    <div id="header">
        <div class="container">
            <div class="row ">
                <div class="col-md-2 text-right">
                    <a class="navbar-brand brandes" href="https://escapezoom.ir/"><img src="https://escapezoom.ir/wp-content/uploads/2021/11/logo-new.png" class="img-fluid  mx-auto d-block" alt="اسکیپ زوم"></a>

                </div>
                <div class="col-md-6 hidden-xs">
                    <nav class="navbar navbar-expand-lg mt-2">
                        <div class="container">
                            <ul class="navbar-nav ms-auto blognvd">
                                <li class="nav-item">
                                    <a class="nav-link active" aria-current="page" href="#">
                                        مجله اسکیپ زوم
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" aria-current="page" href="#">
                                        صفحه اصلی
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" aria-current="page" href="#">
                                        اتاق فرار
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" aria-current="page" href="#">
                                        سرگرمی های خاص
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" aria-current="page" href="#">
                                        مقالات ترسناک
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </nav>


                </div>

                <div class="col-md-4">
                    <div class="blog-topSearch">
                        <form id="searchform" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <input type="text" class="search-field" name="s" placeholder="جستجو مقالات ..." value="<?php echo get_search_query(); ?>" />
                        </form>
                    </div>
                </div>

            </div>


        </div><!-- /.container -->
    </div><!-- /#header -->
    <!--<div class="text-center">-->
    <!--<a href="<?php echo $home_url; ?>winter30/">-->
    <!--<img src="<?php echo $home_url; ?>wp-content/themes/escapezoom-v1/img/winter.jpg" class="img-fluid" alt="...">-->
    <!--</a>-->
    <!--</div>-->
</header>
<!-- Header Desktop Version ES 1.1 -->
<?php } ?>

<!-- Blog Header ( D.W Other Pages !important) -->