<?php

## define
define('Theme_URL', get_template_directory_uri() . '/');
define('Theme_PATH', get_template_directory() . DIRECTORY_SEPARATOR);
define('Theme_ASSET_URL', Theme_URL . 'assets' . DIRECTORY_SEPARATOR);
define('BASEURL', site_url());

/* =======================================================
    remove default styles and scripts wordpress [start]
========================================================= */

// REMOVE WP EMOJI
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');

remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');

// REMOVE CLASSIC THEME STYLES
remove_action('wp_enqueue_scripts', 'wp_enqueue_classic_theme_styles');

// REMOVE GENERATOR
remove_action('wp_head', 'wp_generator');

add_action('wp_dashboard_setup', function () {
    global $wp_meta_boxes;

    // حذف ویجت‌های هسته وردپرس
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
    unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_site_health']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
    unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);

    // حذف ویجت‌های پلاگین‌ها
    foreach ($wp_meta_boxes['dashboard'] as $position) {
        foreach ($position as $priority) {
            foreach ($priority as $id => $widget) {
                if (strpos($id, 'yoast') !== false || strpos($id, 'elementor') !== false || strpos($id, 'jetpack') !== false || strpos($id, 'rank_math') !== false) {
                    unset($wp_meta_boxes['dashboard'][$widget['context']][$widget['priority']][$id]);
                }
            }
        }
    }
});


add_filter( 'heartbeat_send', '__return_false' );
add_filter( 'heartbeat_tick', '__return_false' );

add_action( 'init', function() {
    if ( is_admin() ) {
        wp_deregister_script('heartbeat');
    }
});

## include init
/*require_once Theme_PATH . "/vendor/autoload.php";
require_once Theme_PATH . "/vendor/CMB2/cmb2-init.php";*/

include get_template_directory() . '/inc/wallet/wallet.php';
// include get_template_directory() . '/inc/functions-ahmadreza.php';
include get_template_directory() . '/inc/saeed-codes.php';
include get_template_directory() . '/template/admin/admin-settings.php';

function add_link_theme_scripts()
{
    global $wp;

    wp_enqueue_style('main-css');
    wp_enqueue_script('main-js');

    if (is_page('checkout')) {
        wp_enqueue_script('login-js');
    }
    if (is_page('maps') || is_page('contact-us') || $wp->query_vars['ticket']) {
        wp_enqueue_style('map-css');
        wp_enqueue_style('map-GeoapifyAddressSearch-css');
        wp_enqueue_style('map-a11y-light-css');
        wp_enqueue_script('map-js');
        wp_enqueue_script('map-GeoapifyAddressSearch-js');
        wp_enqueue_script('map-a11y-light-js');
    }

    if (is_product()) {
        wp_enqueue_script('single-product-js');
        wp_enqueue_style('map-css');
        wp_enqueue_script('map-js');
        wp_enqueue_script('swiper-js');
    }

    if (is_single() and ! is_product()) {
        wp_enqueue_script('single-post-js');
    }

    if (is_page('panel')) {
        wp_enqueue_script('swiper-js');
    }

}


add_action('wp_enqueue_scripts', 'add_link_theme_scripts');


add_action('wp_enqueue_scripts', function () {
    //	$version = '1.0.93.3';
    $version = time();

    // Register Style
    wp_register_style('swiper-css', Theme_URL . 'assets/vendor/swiper/swiper-bundle.min.css', [], '11.2.1');
    wp_register_style('main-css', Theme_URL . 'assets/css/main.css', ['swiper-css'], $version);
    wp_register_style('map-css', Theme_URL . 'assets/vendor/leaflet/leaflet.css', [], '1.9.4');
    wp_register_style('map-GeoapifyAddressSearch-css', Theme_URL . 'assets/vendor/leaflet/L.Control.GeoapifyAddressSearch.css', ['map-css'], $version);
    wp_register_style('map-a11y-light-css', Theme_URL . 'assets/vendor/leaflet/a11y-light.min.css', ['map-css'], $version);
    wp_register_style('map-css', Theme_URL . 'assets/vendor/leaflet/leaflet.css', [], '1.9.4');
    wp_enqueue_style('panel-css', Theme_URL . 'assets/css/panel.css', [], $version);
    wp_enqueue_style('custom-styles-css', Theme_URL . 'assets/css/custom-styles.css', [], $version);
    wp_register_style('lightbox-css', Theme_URL . 'assets/vendor/lightbox/css/lightbox.css', [], '2.11.6');

    // Register Script
    wp_register_script('embla-js', Theme_URL . 'assets/vendor/embla/embla-carousel.umd.js', [], $version, true);
    wp_register_script('embla-autoplay-js', Theme_URL . 'assets/vendor/embla/embla-carousel-autoplay.umd.js', [], $version, true);
    wp_register_script('embla-class-names-js', Theme_URL . 'assets/vendor/embla/embla-carousel-class-names.umd.js', [], $version, true);
    wp_register_script('embla-fade-js', Theme_URL . 'assets/vendor/embla/embla-carousel-fade.umd.js', [], $version, true);
    wp_register_script('embla-scroll-js', Theme_URL . 'assets/vendor/embla/embla-carousel-auto-scroll.umd.js', [], $version, true);
    wp_register_script('swiper-js', Theme_URL . 'assets/vendor/swiper/swiper-bundle.min.js', [], '11.2.1', true);
    wp_register_script('sweetalert-js', Theme_URL . 'assets/vendor/sweetalert2/sweetalert2@11.js', [], '11.15.10', true);
    wp_register_script('lightbox-js', Theme_URL . 'assets/vendor/lightbox/js/lightbox.js', [], '2.11.5', true);
    wp_register_script('main-js', Theme_URL . 'assets/js/main.js', [
        'jquery',
        'sweetalert-js',
        'embla-js',
        'embla-autoplay-js',
        'embla-class-names-js',
        'embla-fade-js',
        'embla-scroll-js',
        'swiper-js'
    ], $version, true);
    wp_register_script('checkout-js', Theme_URL . 'assets/js/theme/front/checkout.js', ['main-js'], $version, true);
    wp_register_script('single-post-js', Theme_URL . 'assets/js/theme/front/single-post.js', ['main-js'], $version, true);
    wp_register_script('single-product-js', Theme_URL . 'assets/js/theme/front/single-product.js', ['main-js'], $version, true);
    wp_localize_script('single-product-js', 'ProductJsObject', [
        'admin_ajax'       => admin_url('admin-ajax.php'),
        'nonce'            => wp_create_nonce('v2-ajax-nonce'),
        'product_id'       => get_the_ID(),
        'product_type'     => get_the_terms(get_the_ID(), 'product_cat')[0]->name,
        'reservation_ajax' => site_url('/web-service/reservation.php'),
    ]);

    wp_localize_script('single-post-js', 'PostJsObject', [
        'admin_ajax' => admin_url('admin-ajax.php'),
        'nonce'      => wp_create_nonce('v2-ajax-nonce'),
        'post_id'    => get_the_ID(),
    ]);
    wp_register_script('map-js', Theme_URL . 'assets/vendor/leaflet/leaflet.js', [], '1.9.4', false);
    wp_register_script('map-GeoapifyAddressSearch-js', Theme_URL . 'assets/vendor/leaflet/L.Control.GeoapifyAddressSearch.js', ['map-js'], '1.9.4', false);
    wp_register_script('map-a11y-light-js', Theme_URL . 'assets/vendor/leaflet/highlight.min.js', ['map-js'], '1.9.4', false);
});

// add Style & Script
function plugin_enqueue_custom()
{
    wp_enqueue_style('admin-css', Theme_URL . 'assets/css/admin.css', [], '1.0.0', 'all');
}

add_action('admin_enqueue_scripts', 'plugin_enqueue_custom');

/*function enqueue_ajax_script() {
    #insert-comment
    wp_enqueue_script('ajax-comment', get_template_directory_uri() . '/assets/js/ajax/comment.js', array('jquery'), null, true);
    wp_localize_script('ajax-comment', 'ajaxurl', admin_url('admin-ajax.php'));
    #comment-vote
    wp_enqueue_script('ajax-comment-vote', get_template_directory_uri() . '/assets/js/ajax/comment-vote.js', array('jquery'), null, true);
    wp_localize_script('ajax-comment-vote', 'ajaxurl', admin_url('admin-ajax.php'));
    #profile-edit
    wp_enqueue_script('ajax-profile', get_template_directory_uri() . '/assets/js/ajax/profile.js', array('jquery'), null, true);
    wp_localize_script('ajax-profile', 'ajaxurl', admin_url('admin-ajax.php'));
    #login
    wp_localize_script('login-js', 'ajaxurl', admin_url('admin-ajax.php'));
}
add_action('wp_enqueue_scripts', 'enqueue_ajax_script');*/

/* =======================================================
    remove default styles and scripts wordpress [start]
========================================================= */

// REMOVE WP EMOJI
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');

remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');

// REMOVE CLASSIC THEME STYLES
remove_action('wp_enqueue_scripts', 'wp_enqueue_classic_theme_styles');

// REMOVE GENERATOR
remove_action('wp_head', 'wp_generator');


add_action('wp_ajax_get_category_link', 'get_category_link_function');
add_action('wp_ajax_nopriv_get_category_link', 'get_category_link_function');

function get_category_link_function()
{
    if (isset($_POST['category_id'])) {
        $category_id = intval($_POST['category_id']);
        $link        = get_category_link($category_id);
        echo $link;
    } else {
        echo 'Invalid category ID';
    }
    wp_die(); // این خط برای اتمام درخواست AJAX ضروری است
}
/* =======================================================
    remove default styles and scripts wordpress [start]
========================================================= */

// REMOVE WP EMOJI
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');

remove_action('admin_print_scripts', 'print_emoji_detection_script');
remove_action('admin_print_styles', 'print_emoji_styles');

// REMOVE CLASSIC THEME STYLES
remove_action('wp_enqueue_scripts', 'wp_enqueue_classic_theme_styles');

// REMOVE GENERATOR
remove_action('wp_head', 'wp_generator');

/* =======================================================
    Woocommerce Func
========================================================= */
add_theme_support('woocommerce');
// WC Unset Checkout Field
/*add_filter( 'woocommerce_checkout_fields', 'unrequire_checkout_fields' );
function unrequire_checkout_fields( $fields ) {
    $fields['billing']['billing_company']['required']   = false;
    #$fields['billing']['billing_city']['required']      = false;
    $fields['billing']['billing_postcode']['required']  = false;
    #$fields['billing']['billing_phone']['required']  = false;
    #$fields['billing']['billing_email']['required']  = false;
    $fields['billing']['billing_country']['required']   = false;
    #$fields['billing']['billing_state']['required']     = false;
    #$fields['billing']['billing_address_1']['required'] = false;
    $fields['billing']['billing_address_2']['required'] = false;
    $fields['shipping']['shipping_company']['required']   = false;
    $fields['shipping']['shipping_city']['required']      = false;
    $fields['shipping']['shipping_postcode']['required']  = false;
    $fields['shipping']['shipping_phone']['required']  = false;
    $fields['shipping']['shipping_email']['required']  = false;
    $fields['shipping']['shipping_country']['required']   = false;
    $fields['shipping']['shipping_state']['required']     = false;
    $fields['shipping']['shipping_address_1']['required'] = false;
    $fields['shipping']['shipping_address_2']['required'] = false;
    return $fields;
}
add_filter('woocommerce_checkout_fields','remove_checkout_fields');
function remove_checkout_fields($fields){
    #unset($fields['billing']['billing_first_name']);
    unset($fields['billing']['billing_company']);
    #unset($fields['billing']['billing_last_name']);
    #unset($fields['billing']['billing_email']);
    #unset($fields['billing']['billing_phone']);
    #unset($fields['billing']['billing_address_1']);
    unset($fields['billing']['billing_address_2']);
    #unset($fields['billing']['billing_city']);
    #unset($fields['billing']['billing_postcode']);
    unset($fields['billing']['billing_country']);
    #unset($fields['billing']['billing_state']);
    unset($fields['shipping']['shipping_first_name']);
    unset($fields['shipping']['shipping_company']);
    unset($fields['shipping']['shipping_last_name']);
    unset($fields['shipping']['shipping_email']);
    unset($fields['shipping']['shipping_phone']);
    unset($fields['shipping']['shipping_address_1']);
    unset($fields['shipping']['shipping_address_2']);
    unset($fields['shipping']['shipping_city']);
    unset($fields['shipping']['shipping_postcode']);
    unset($fields['shipping']['shipping_country']);
    unset($fields['shipping']['shipping_state']);
    return $fields;
}*/

/*add_filter( 'wc_add_to_cart_message', 'remove_add_to_cart_message' );
function remove_add_to_cart_message() {
    return;
}
remove_action('woocommerce_before_checkout_form','woocommerce_checkout_login_form');
add_action( 'template_redirect', 'order_recevied_redirect_theme' );
function order_recevied_redirect_theme(): void
{
    global $wp;
    if ( is_checkout() && !empty( $wp->query_vars['order-received'] ) ) {
        WC()->cart->empty_cart();
        wp_redirect( home_url('/').'order-received?order=thankyou');
        exit;
    }
}*/
/* =======================================================
    include file [start]
========================================================= */

include_once Theme_PATH . "app/init.php";
include_once Theme_PATH . "aref-jan/init.php";
include_once Theme_PATH . "saeed/init.php";
include_once Theme_PATH . "ahmadreza/init.php";
/*
include_once Theme_PATH . "template/include/theme.php";
include_once Theme_PATH . "template/posts/init.php";
include_once Theme_PATH . "template/pages-metabox/metabox.php";
include_once Theme_PATH . "template/options/init.php";
*/

/* =======================================================
    Dependency Func
========================================================= */
function add_avif_upload_mime_types($mimes)
{
    $mimes['avif'] = 'image/avif';

    return $mimes;
}


