<!DOCTYPE html>
<html <?php language_attributes(); ?> dir="rtl">
<head>

    <?php
    if ($_SERVER['SERVER_NAME'] == 'escapezoom.co' || $_SERVER['SERVER_NAME'] == 'www.escapezoom.co') { ?>

        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                    new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-MK2B3ZFF');</script>
        <!-- End Google Tag Manager -->

    <?php
    } else { ?>

        <!-- Google Tag Manager -->
        <script>(function (w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start':
                        new Date().getTime(), event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s), dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer', 'GTM-WBCCS78');</script>
        <!-- End Google Tag Manager -->

    <?php
    } ?>

    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php
    // noIndex ParkDomain
    if ($_SERVER['SERVER_NAME'] == 'escapezoom.co' || $_SERVER['SERVER_NAME'] == 'www.escapezoom.co') {
        echo '<meta name="googlebot" content="noindex">';
        add_filter('wp_robots', function ($robots) {
            $robots['noindex'] = true;
            $robots['nofollow'] = true;
            return $robots;
        });
        echo '<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script><link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/> <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script> <script> const swiperDefaultSlider = new Swiper(".topescaperoom", { slidesPerView: "auto", spaceBetween: 10, freeMode: true, }); </script>';
    } else {
        add_filter('wp_robots', function ($robots) {
            $robots['index'] = true;
            $robots['follow'] = true;
            return $robots;
        });
    }
    ?>
    <?php
    if (is_page('408') && is_paged()) {
        echo '
        <link rel="canonical" href="https://escapezoom.ir/" />
        <script type="application/ld+json">
            {
            "@context": "http://schema.org/",
            "@type": "WebSite",
            "url": "https://escapezoom.ir/",
            "potentialAction": {
            "@type": "SearchAction",
            "target": "https://escapezoom.ir/shop/?s={search_term_string}",
            "query-input": "required name=search_term_string"
            }
            }
        </script>
        ';
    }

    if ($_SERVER['SERVER_NAME'] == 'escapezoom.co' || $_SERVER['SERVER_NAME'] == 'www.escapezoom.co') { ?>

        <script>
            !function (t, e, n) {
                t.yektanetAnalyticsObject = n, t[n] = t[n] || function () {
                    t[n].q.push(arguments)
                }, t[n].q = t[n].q || [];
                var a = new Date,
                    r = a.getFullYear().toString() + "0" + a.getMonth() + "0" + a.getDate() + "0" + a.getHours(),
                    c = e.getElementsByTagName("script")[0], s = e.createElement("script");
                s.id = "ua-script-kziWIhHH";
                s.dataset.analyticsobject = n;
                s.async = 1;
                s.type = "text/javascript";
                s.src = "https://cdn.yektanet.com/rg_woebegone/scripts_v3/kziWIhHH/rg.complete.js?v=" + r, c.parentNode.insertBefore(s, c)
            }(window, document, "yektanet");
        </script>

    <?php
    } else { ?>

<!--        <script>-->
<!--            !function (t, e, n) {-->
<!--                t.yektanetAnalyticsObject = n, t[n] = t[n] || function () {-->
<!--                    t[n].q.push(arguments)-->
<!--                }, t[n].q = t[n].q || [];-->
<!--                var a = new Date,-->
<!--                    r = a.getFullYear().toString() + "0" + a.getMonth() + "0" + a.getDate() + "0" + a.getHours(),-->
<!--                    c = e.getElementsByTagName("script")[0], s = e.createElement("script");-->
<!--                s.id = "ua-script-U8CPiSAN";-->
<!--                s.dataset.analyticsobject = n;-->
<!--                s.async = 1;-->
<!--                s.type = "text/javascript";-->
<!--                s.src = "https://cdn.yektanet.com/rg_woebegone/scripts_v3/U8CPiSAN/rg.complete.js?v=" + r, c.parentNode.insertBefore(s, c)-->
<!--            }(window, document, "yektanet");-->
<!--        </script>-->

    <?php
    } ?>

    <?php wp_head(); ?>

    <script type="text/javascript" src="https://gate.dezhino.com/v2/9027345849.js"></script>

    <link rel="stylesheet"
          href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/fonts/icofont/icofont.min.css">

</head>

<?php
$navbar_scheme = get_theme_mod('navbar_scheme', 'navbar-light bg-light'); // Get custom meta-value.
$navbar_position = get_theme_mod('navbar_position', 'static'); // Get custom meta-value.

$search_enabled = get_theme_mod('search_enabled', '0'); // Get custom meta-value.
?>

<body <?php body_class(); ?>>


<?php
if ($_SERVER['SERVER_NAME'] == 'escapezoom.co' || $_SERVER['SERVER_NAME'] == 'www.escapezoom.co') { ?>

    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MK2B3ZFF" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

<?php
} else { ?>
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBCCS78" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->

<?php
} ?>


<?php wp_body_open(); ?>

<a href="#main" class="visually-hidden-focusable"><?php esc_html_e('Skip to main content', 'escapezoom-v1'); ?></a>

<div id="wrapper">

    <?php get_template_part('es', 'headeres'); ?>


    <main id="main" <?php if (isset($navbar_position) && 'fixed_top' === $navbar_position) : echo ' style=""'; elseif (isset($navbar_position) && 'fixed_bottom' === $navbar_position) : echo ' style="padding-bottom: 100px;"'; endif; ?>>
        <?php
        // If Single or Archive (Category, Tag, Author or a Date based page).
        if (is_archive()) :

        else :
        ?>
        <div class="container">

            <?php
            endif;
            ?>
