<?php
if ( ! defined( 'ABSPATH' ) ) { exit;}
/*
Plugin Name: Ni WooCommerce Admin Order Columns
Description: Ni WooCommerce Admin Order Columns add the order product columns in admin order list.
Author: anzia
Version: 1.5.0
Author URI: http://naziinfotech.com/
Plugin URI: https://wordpress.org/plugins/ni-woocommerce-admin-order-columns/
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/agpl-3.0.html
Requires at least: 4.7
Tested up to: 6.2
WC requires at least: 3.0.0
WC tested up to: 7.6.1
Last Updated Date: 05-May-2023
Requires PHP: 7.0
*/
class Ni_WooCommerce_Admin_Order_Columns{
    public function __construct(){
        $ni_order_columns_init = new Ni_Order_Columns_Init();
        add_action( 'before_woocommerce_init',  array(&$this,'before_woocommerce_init') );
    }
    function before_woocommerce_init(){
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, false );
        }
    }
}

$obj = new Ni_WooCommerce_Admin_Order_Columns();

class Ni_Order_Columns_Init{
    function __construct(){
        add_filter('manage_edit-shop_order_columns', array(&$this,'ni_add_custom_column'), 11);
        add_action( 'manage_shop_order_posts_custom_column' ,  array(&$this,'ni_add_custom_column_content'), 11, 2 );
    }
    function ni_add_custom_column($columns){
        $new_columns = array();

        foreach ( $columns as $column_name => $column_info ) {
            $new_columns[ $column_name ] = $column_info;
            if ( 'order_total' === $column_name ) {
                $new_columns['order_products'] = __( 'Order Product', 'niwaoc' );
                $new_columns['customer_ip_address'] = __( 'IP Address', 'niwaoc' );
                $new_columns['payment_method_title'] = __( 'Payment Method Title', 'niwaoc' );
                $new_columns['tax_total'] = __( 'Tax Total', 'niwaoc' );

            }
        }
        return $new_columns;
    }
    function ni_add_custom_column_content($column){
        global $post, $the_order;
        if ( empty( $the_order ) || $the_order->get_id() !== $post->ID ) {
            $the_order = wc_get_order( $post->ID );
        }
        switch ( $column ) {
            case 'order_products' :
                $order_items = $the_order->get_items();

                $admin_url =  admin_url("post.php")."?post=niproductid&action=edit";

                $prodct_name = '';
                $prodct_names = array();
                foreach( $order_items as $product ) {

                    $product_id = isset( $product['product_id'])?$product['product_id']:0;
                    //$woo_product = wc_get_product( $product_id );
                    //$product_sku =   $woo_product->get_sku();





                    $product_sku =   get_post_meta($product_id,'_sku',true);


                    $product_name =  isset( $product['name'])?$product['name']:'';
                    $product_qty =  isset( $product['qty'])?$product['qty']:'';
                    //print_r($product);
                    //$prodct_name[] = $product['name'].$product['qty'];


                    if ($product_sku  != ''){
                        $prodct_names[] =  '<a target="_blank" href="'.  str_replace ("niproductid", $product_id,$admin_url) .'">'.$product_name.'</a>' . ' ('. $product_sku  .')' .' x '. $product_qty;
                    }else{
                        $prodct_names[] =  '<a target="_blank" href="'.  str_replace ("niproductid", $product_id,$admin_url) .'">'.$product_name.'</a>' .' x '. $product_qty;
                    }

                }

                echo $product_list = implode( ', ', $prodct_names );
                break;
            case 'customer_ip_address' :
                echo get_post_meta(  $post->ID,"_customer_ip_address",true );
                break;
            case 'payment_method_title' :
                echo get_post_meta(  $post->ID,"_payment_method_title",true );
                break;
            case 'tax_total' :
                echo wc_price($the_order->get_total_tax());
                break;
        }

    }
}

?>
