<?php
/**
 * Plugin Name: ezoom
 * Description: ezoom has it all: drag and drop shorcode and more. Get started now!
 * Plugin URI: http://escapezoom.ir/
 * Author: hs90w
 * Version: 0.0.13
 * Author URI: https://hs90w.ir
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly 

require_once dirname( __FILE__ ) . '/shortcodes/ez-product.php';
require_once dirname( __FILE__ ) . '/shortcodes/ez-shomare.php';
require_once dirname( __FILE__ ) . '/shortcodes/home1401.php';

require_once dirname( __FILE__ ) . '/shortcodes/ez-brands-show.php';
require_once dirname( __FILE__ ) . '/shortcodes/ez-search.php';
require_once dirname( __FILE__ ) . '/shortcodes/ez-home-room-footer.php';
require_once dirname( __FILE__ ) . '/shortcodes/top-sale.php';
require_once dirname( __FILE__ ) . '/shortcodes/new-sale.php';
require_once dirname( __FILE__ ) . '/shortcodes/special-slider.php';



require_once dirname( __FILE__ ) . '/coupon/coupon.php';


require_once dirname( __FILE__ ) . '/slider.php';
require_once dirname( __FILE__ ) . '/sms-comment.php';
require_once dirname( __FILE__ ) . '/sort.php';


/**
 * Sets the product default price to 10. Only works once, if the price is not specified.
 *
 * @param int    $post_id
 * @param object $post
 */
function set_product_default_price( $post_id, $post ) {
    $product     = wc_get_product( $post_id );
    $already_set = get_post_meta( $post_id, '_set_default_price', true );
    $price       = $product->get_price();

    if ( 'yes' !== $already_set && empty( $price ) ) {
        $product->set_regular_price( '1' );
        $product->save();

        update_post_meta( $post_id, '_set_default_price', 'yes' );
    }
}
add_action( 'woocommerce_process_product_meta', 'set_product_default_price', 999, 2 );






/**
 * Remove product data tabs
 */
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {

    unset( $tabs['images'] );      	// Remove the description tab
    unset( $tabs['reviews'] ); 			// Remove the reviews tab
    unset( $tabs['additional_information'] );  	// Remove the additional information tab

    return $tabs;
}









add_filter('woocommerce_get_breadcrumb', 'woocommerce_breadcrumbs_remove_text', 10);
function woocommerce_breadcrumbs_remove_text($crumbs) {

    // Check if we are in a product tag archive page
    if (is_product_tag()) {

        // Point to the last element of the breadcrumbs array, specifically the breadcrumb we are going to edit
        end($crumbs);

        // Get the text to edit (array key number 0)
        $last    = $crumbs[key($crumbs)][0];

        // Perform a regular expression to keep only what's between quotes (&ldquo; and &rdquo;)
        $replace = preg_replace('/[\s\S]+\&ldquo;([\s\S]+)\&rdquo;/', '$1', $last);

        // Register the new text to the breadcrumb array
        $crumbs[key($crumbs)][0] = $replace;

        // Reset the array pointer
        reset($crumbs);
    }

    // Return the filtered breadcrumbs array
    return $crumbs;
}



// Create Shortcode spoil
// Shortcode: [spoil]Content[/spoil]
function create_spoil_shortcode($atts, $content = null) {
    add_filter( 'comment_text', 'do_shortcode' );

    $atts = shortcode_atts(
        array(
        ),
        $atts,
        'spoil'
    );

    $i= strlen("$content");
    $show ='<span class="blour">';
    while($x <= $i) {

        $show.= "x";
        $x++;
    }
    $show .='</span>';
    return  $show;
}
add_shortcode( 'spoil', 'create_spoil_shortcode' );


add_filter ('get_comment_text','wpse334485_filter_shortcodes',10,3);
function wpse334485_filter_shortcodes ($comment_text, $comment, $args) {
    $comment_text = do_shortcode ($comment_text);
    return do_shortcode ($comment_text);
}




function dump($var, $return = false){
    if (is_array($var)){
        $out = print_r($var, true);
    } else if (is_object($var)) {
        $out = var_export($var, true);
    } else {
        $out = $var;
    }

    if ($return){
        return "\n<pre style='direction: ltr'>$out</pre>\n";
    } else {
        echo "\n<pre style='direction: ltr'>$out</pre>\n";
    }
}




// Register Custom Post Type
function jobs_post_type() {

    $labels = array(
        'name'                  => 'استخدام',
        'singular_name'         => 'jobs',
        'add_new_item'          => 'افزودن اسخدامی جدید',
        'add_new'               => 'افزودن اسخدامی',
        'new_item'              => 'استخدامی جدید',

    );
    $args = array(
        'label'                 => 'jobs',
        'description'           => 'Post Type Description',
        'labels'                => $labels,
        'supports'              => array( 'title', 'custom-fields' ),
        'taxonomies'            => array( 'post_tag' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => true,
        'publicly_queryable'    => true,
        'rewrite'               => false, 'map_meta_cap'          => true,
        'capabilities'          => [
            'edit_post'          => 'edit_job',
            'edit_posts'         => 'edit_jobs',
            'edit_others_posts'  => 'edit_other_jobs',
            'publish_posts'      => 'publish_jobs',
            'read_post'          => 'read_job',
            'read_private_posts' => 'read_private_jobs',
            'delete_post'        => 'delete_job',
            'create_posts'       => false,
        ],
    );
    register_post_type( 'jobs', $args );
}
add_action( 'init', 'jobs_post_type', 0 );







// Create Shortcode estekhdami
// Shortcode: [estekhdami]
function create_estekhdami_shortcode() {


    $args = array(
        'post_type'              => array( 'jobs' ),
        'orderby' => 'date',
        'order' => 'DESC',
        'date_query' => array(
            array(
                'after' => '-45 days',
            ),
        ),



    );

// The Query
    $the_query = new WP_Query( $args );

// The Loop
    if ( $the_query->have_posts() ) {

        $out_estekhdam= '<h2 class="gamemaster-title">آخرین آگهی های استخدام</h2>
                <div class="row">';

        while ( $the_query->have_posts() ) {
            $the_query->the_post();

            $thumbnail_id = absint( yith_wcbr_get_term_meta( get_field( "job_brand" ), 'thumbnail_id', true ) );

            $b_name = absint( yith_wcbr_get_term_meta( get_field( "job_brand" ), 'name', true ) );

            $img = absint( yith_wcbr_get_term_meta( $product_brand->term_id, 'thumbnail_id', true ) );
            $img = wp_get_attachment_image_src($thumbnail_id, 'full');
            $img=$img[0];

            $term = get_term( get_field( "job_brand" ) );

            $out_estekhdam.= '  <div class="col-xs-12 col-md-4 esbox">
					   <div class="job-card">
					   
						  <h2>'.get_the_title().'</h2>
						  <span class="esdate">'.get_the_date('d M Y').'</span>
						  <p class="esdesc">'.get_field( "job_desc" ).'
						  </p>
						  <div class="card-ftes">
						  <div class="card-call" >    <span><img src="https://escapezoom.ir/wp-content/uploads/2021/02/whatsapp-v5.png">&nbsp&nbsp</span><a href="https://wa.me/98'.get_field( "job_tamas" ).'" >0'.get_field( "job_tamas" ).' </a></div>
						  <a href="https://escapezoom.ir/product-brands/'.$term->slug.'" class="job-brand"  ><span>
						  
						  '.$term->name.'
						  </span><img class="" src="'.$img.'"></a>
						  </div>
					   </div>
					</div>
';


        }
        $out_estekhdam.= '
    
    
    <div class="col-xs-12 col-md-4 ">
					   <div class="job-card">
						  
						  <a href="https://escapezoom.ir/ads-job/"   target= "_blank" ><img class="img-fluid" src="https://escapezoom.ir/wp-content/uploads/2021/02/ads-emp.jpg" style=" height: 208px; "></a>
					   </div>
					</div>
					
					
					
					
    </div>';
    }

    /* Restore original Post Data */
    wp_reset_postdata();



    return $out_estekhdam;
}
add_shortcode( 'estekhdami', 'create_estekhdami_shortcode' );























function calculatePercentage($oldFigure, $newFigure)
{
    $percentChange = (($oldFigure - $newFigure) / $oldFigure) * 100;
    return round(abs($percentChange));
}



























// Redirect user after login.

add_action( 'woocommerce_login_form_end', 'hs_referrer' );

function hs_referrer() {
    if ( ! wc_get_raw_referer() ) return;
    echo '<input type="hidden" name="redirect" value="' . wp_validate_redirect( wc_get_raw_referer(), wc_get_page_permalink( 'myaccount' ) ) . '" />';
}





/**
 * Dequeue Google Fonts based on URL.
 */
function drgf_dequeueu_fonts() {
    global $wp_styles;

    if ( ! ( $wp_styles instanceof WP_Styles ) ) {
        return;
    }

    $allowed = apply_filters(
        'drgf_exceptions',
        [ 'olympus-google-fonts' ]
    );

    foreach ( $wp_styles->registered as $style ) {
        $handle = $style->handle;
        $src    = $style->src;
        $gfonts = strpos( $src, 'fonts.googleapis' );

        if ( false !== $gfonts ) {
            if ( ! array_key_exists( $handle, array_flip( $allowed ) ) ) {
                wp_dequeue_style( $handle );
            }
        }
    }
    // Dequeue Google Fonts loaded by Revolution Slider.
    remove_action( 'wp_footer', array( 'RevSliderFront', 'load_google_fonts' ) );

    // Dequeue the Jupiter theme font loader.
    wp_dequeue_script( 'mk-webfontloader' );

}
add_action( 'wp_enqueue_scripts', 'drgf_dequeueu_fonts', 9999 );
add_action( 'wp_print_styles', 'drgf_dequeueu_fonts', 9999 );

/**
 * Dequeue Google Fonts loaded by Elementor.
 */
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );

/**
 * Dequeue Google Fonts loaded by Beaver Builder.
 */
add_filter(
    'fl_builder_google_fonts_pre_enqueue',
    function( $fonts ) {
        return array();
    }
);

/**
 * Dequeue Google Fonts loaded by JupiterX theme.
 */
add_filter(
    'jupiterx_register_fonts',
    function( $fonts ) {
        return array();
    },
    99999
);

/**
 * Dequeue Google Fonts loaded by the Hustle plugin.
 */
add_filter( 'hustle_load_google_fonts', '__return_false' );

/**
 * Dequeue Google Fonts loaded by the Hustle plugin.
 */
add_filter( 'mailpoet_display_custom_fonts', '__return_false' );

/**
 * Dequeue Google Fonts loaded by the Apollo13 Themes Framework.
 */
if ( ! function_exists( 'apollo13framework_get_web_fonts_dynamic' ) ) {
    function apollo13framework_get_web_fonts_dynamic() {
        return;
    }
}

if ( ! function_exists( 'apollo13framework_get_web_fonts_static' ) ) {
    function apollo13framework_get_web_fonts_static() {
        return;
    }
}


// Enqueue own styles
function enqueue_custom_styles_ez() {

    if(!is_product()){
        wp_enqueue_style( 'all-ez', 'https://escapezoom.ir/wp-content/themes/escapezoom-v1/inc/plugin/ezoom/css/all.css?v=1.6', array(), false, 'all' );

        wp_enqueue_style( 'home-ez', 'https://escapezoom.ir/wp-content/themes/escapezoom-v1/inc/plugin/ezoom/css/home2.css', array(), false, 'all' );
    }

}
add_action( 'wp_enqueue_scripts', 'enqueue_custom_styles_ez' );



add_action( 'init', 'ez_user_role' );
function ez_user_role()
{

    add_role(
        'compiler',
        __( 'مجموعه دار' ),
        array(
            'read'         => true,  // true allows this capability
            'edit_posts'   => false,
        )
    );
}

add_action( 'init', 'ez_user_role_poshtiban' );
function ez_user_role_poshtiban()
{

    add_role(
        'poshtiban',
        __( 'پشتیبان' ),
        array(
            'read'         => true,  // true allows this capability
            'edit_posts'   => false,
        )
    );
}



function check__user(){
    $current_user = wp_get_current_user();
    $m=  $current_user->roles[0];
    return $m;
}
add_action( 'init', 'check__user' );




function ez_custom_add_coupons_accept_endpoint() {
    add_rewrite_endpoint( 'coupons-accept', EP_ROOT | EP_PAGES );
}

add_action( 'init', 'ez_custom_add_coupons_accept_endpoint' );


/**
 * 2. Add new query var
 */

function ez_custom_coupons_accept_query_vars( $vars ) {
    $vars[] = 'coupons-accept';
    return $vars;
}

add_filter( 'woocommerce_get_query_vars', 'ez_custom_coupons_accept_query_vars', 0 );


/**
 * 3. Insert the new endpoint into the My Account menu
 */

function ez_custom_add_coupons_accept_link_my_account( $items ) {
    $items['coupons-accept'] = 'ابطال کد تخفیف';
    if(check__user()=='administrator'||check__user()=='compiler'){
        return $items;
    }
}

add_filter( 'woocommerce_account_menu_items', 'ez_custom_add_coupons_accept_link_my_account' );


/**
 * 4. Add content to the new endpoint
 */

function ez_custom_coupons_accept_content() {

    if(check__user()=='administrator'||check__user()=='compiler'){?>

        <style>
            .ez-panel-box{
                display: flex;
                flex-wrap: <?php echo (wp_is_mobile() ? 'wrap' : 'nowrap'); ?>;
                background-color: #fff;
            }

            .ez-panel-box > div {
                background-color: #f1f1f1;
                width: <?php echo (wp_is_mobile() ? '100%' : '33.33333%'); ?>;
                margin: 10px;
                text-align: center;
                line-height: 45px;
                color:#fff;
                padding:30px;
                font-size: 1em;
            }
            .ez-panel-num{font-size:1em;}

            .alert-success {
                color: #3c763d;
                background-color: #dff0d8;
                border-color: #d6e9c6;
                padding: 15px;
                margin-bottom: 20px;
                border: 1px solid transparent;
                border-radius: 4px;
                margin-top:50px;
            }


        </style>







        <?php
// the query

        $args = array(

            'post_type' => 'product',

            'meta_query' => array(

                array(
                    'key' => 'user_ebtal',
                    'value' => get_current_user_id(),
                    'compare' => 'IN'
                )

            )

        );


        $the_query = new WP_Query( $args ); ?>

        <?php if ( $the_query->have_posts() ) : ?>

            <!-- pagination here -->

            <!-- the loop -->
            <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                <div class="account-headline mt-5">
                    <span><?php the_title(); ?></span>
                </div>


                <div class="ez-panel-box">




                    <div style="background: #88c0d0;">
                        <span>مجموعه کدها فروش رفته</span> <br> <span class="ez-panel-num">
                     <span style="font-size:3em;" class="Count">  <?php echo get_post_meta( get_the_ID(), 'all_sale', true );?></span>

               عدد</span>
                    </div>



                    <div style="background: #c47c90;">
                        <span>کدهای باطل نشده</span> <br> <span class="ez-panel-num">
                <span style="font-size:3em;" class="Count">  <?php echo get_post_meta( get_the_ID(), 'tedad_not_ebtal', true );?></span>

               عدد</span>

                    </div>




                    <div style="background: #a3be8c;">
                        <span>کدهای باطل شده</span> <br> <span class="ez-panel-num">
      <span style="font-size:3em;" class="Count">  <?php echo get_post_meta( get_the_ID(), 'tedad_sale', true );?></span>
               عدد</span>
                    </div>

                </div>







            <?php endwhile; ?>
            <!-- end of the loop -->

            <!-- pagination here -->

            <?php wp_reset_postdata(); ?>

        <?php else : ?>
            <p>هنوز اتاق فراری برای شما اختصاص داده نشده است.</p>
        <?php endif; ?>




        <?php
        if ($_GET['code_ebtal']&&is_numeric($_GET['code_ebtal'])) {
            $order = wc_get_order( $mycode_ID );

            $mycode_ID=$_GET['code_ebtal'];
            $order_code = get_field( 'order_code',$mycode_ID );
            $get_id_room= explode("-",$order_code);
            $post_id= $get_id_room[1];
            $user_ebtal = get_field( 'user_ebtal', $post_id );

            $get_name_room=get_the_title($post_id);
            if(get_current_user_id()==$user_ebtal){
                $order = wc_get_order( $mycode_ID );

                $items = $order->get_items();
                foreach( $order->get_items() as $item_id => $item ){
                    $quantity = $item->get_quantity();

                }

                if ($order->get_status()=="processing") {


                    echo "<div class='alert-success'>
            <p style='font-size: 1.2em; font-weight: 800; margin-bottom: 10px;'>
کد تخفیف باطل و امتیاز آن به بازی شما اضافه شد.
</p>
                     <ul class='pr-3'>
                        <li>نام اتاق فرار: $get_name_room</li>
                        <li>کد تخفیف:  <span style='font-family: tahoma!important;padding: 0 12px;'> $order_code </span></li>
                        <li>تعداد رزروی: <span class='Count'>$quantity</span></li>
                    </ul>
            </div>";
                    $order->set_status('completed');
                    $order->save();

                    $new_tedad_sale=get_field('tedad_sale',$post_id);
                    $new_tedad_sale=$new_tedad_sale+$quantity;

                    $new_tedad_not_ebtal=get_field('tedad_not_ebtal',$post_id);
                    $new_tedad_not_ebtal=$new_tedad_not_ebtal-$quantity;
                    if($new_tedad_not_ebtal<0){$new_tedad_not_ebtal=0;}

                    update_field( 'tedad_sale', "$new_tedad_sale", $post_id );
                    update_field( 'tedad_not_ebtal', "$new_tedad_not_ebtal", $post_id );

                }

                elseif($order->get_status()=="completed"){
                    echo "<div class='alert-success'>
            <p style='font-size: 1.2em; font-weight: 800; margin-bottom: 10px;'>
کد شما قبلا ابطال شده است.
</p>
                     
            </div>";

                }
                else{
                    echo "<div class='alert-success'>
            <p style='font-size: 1.2em; font-weight: 800; margin-bottom: 10px;'>
این کد قابل استفاده نیست
</p>
                     
            </div>";
                }



            }



        }

        ?>



        <form >
            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                <label for="code_ebtal">چهار رقم آخر کد تخفیف را وارد کنید.</label>
                <input type="text" class="woocommerce-Input  input-text" name="code_ebtal" id="code_ebtal" autocomplete="off" >
            </p>


            <p>
                <button type="submit" class="woocommerce-Button button" name="ebtal_btn" >
                    ابطال کد
                </button>
            </p>

        </form>


        <script type="text/javascript">
            jQuery(document).ready(function($) {


                $('.Count').each(function () {
                    $(this).prop('Counter',0).animate({
                        Counter: $(this).text()
                    }, {
                        duration: 2000,
                        easing: 'swing',
                        step: function (now) {
                            $(this).text(Math.ceil(now));
                        }
                    });
                });

            });

        </script>







    <?php }else{
        echo '<p>شما به این بخش سایت دسترسی ندارید.</p>';
    }

}

/**
 * @important-note	"add_action" must follow 'woocommerce_account_{your-endpoint-slug}_endpoint' format
 */
add_action( 'woocommerce_account_coupons-accept_endpoint', 'ez_custom_coupons_accept_content' );




add_action('admin_head', 'my_custom_color_order');

function my_custom_color_order() {
    echo '<style>
  td.customer_ip_address.column-customer_ip_address {
    color: darkgreen;
}
mark.order-status.status-partially-paid.tips {
    background-color: orangered;
    color: #fff;
}
  </style>';
}




function create_commentlink_shortcode() {
    $id_link=htmlspecialchars($_GET['cpid']);
    if($id_link>1){
        $clink=get_permalink($id_link)."/#modal_zn-one";
        header("Location: $clink");
        exit;

    }
}
add_shortcode( 'comment_link', 'create_commentlink_shortcode' );





//کامنتچی
function creat_commentchi_role() {
    add_role(
        'commentchi', //  System name of the role.
        __( 'کامنتچی'  ), // Display name of the role.
        array(
            'read'  => true,
            'delete_posts'  =>false,
            'delete_published_posts' => false,
            'edit_posts'   => false,
            'publish_posts' => true,
            'upload_files'  => true,
            'edit_pages'  => true,
            'edit_published_pages'  =>  true,
            'publish_pages'  => true,
            'delete_published_pages' => false, // This user will NOT be able to  delete published pages.
        )
    );
}

add_action( 'init', 'creat_commentchi_role' );





add_filter ( 'auth_cookie_expiration', 'wpdev_login_session' );

function wpdev_login_session( $expire ) { // Set login session limit in seconds
    return 63072000;
    // return MONTH_IN_SECONDS;
    // return DAY_IN_SECONDS;
    // return HOUR_IN_SECONDS;
}

function ez_sendpayamak($phone___number,$msg__text, $number = "90006491") {

    ini_set("soap.wsdl_cache_enabled", "0");

    try {
        $client = new SoapClient('http://api.payamak-panel.com/post/send.asmx?wsdl', array('encoding'=>'UTF-8'));

        $parameters['username'] = "xescape";
        $parameters['password'] = "2kkh7Gm36%#X91h";
        $parameters['from']     = $number;
//        $parameters['from']     = get_current_user_id() == 3325 && $number == '2191307900' ? 8 : $number;
        $parameters['to']       = array("$phone___number");
        $parameters['text']     = "$msg__text";
        $parameters['isflash']  = true;
        $parameters['udh']      = "";
        $parameters['recId']    = array(0);
        $parameters['status']   = 0x0;

        $status = $client->GetCredit( array("username"=>"wsdemo", "password"=>"wsdemo"))->GetCreditResult;
        $status .= $client->SendSms($parameters)->SendSmsResult;

        return $status;

    } catch (SoapFault $ex) {
        $status_err = $ex->faultstring;
        return  $status;
    }
}