<?php

/************************************************************************************************************/
add_shortcode('home_advertise_middle', 'home_advertise_middle_func');
function home_advertise_middle_func() {
    ?>
    <style>
        .advertise-middle {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 8px;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        @media (max-width: 768px){
            .advertise-middle {
                grid-template-columns: repeat(1, 1fr);
            }
            .middle-left-adv {
                display: none;
            }
        }
    </style>
    <section>
        <div class="advertise-middle">
            <div class="middle-right-adv adv-banner">
                <a href="<?= $home_url; ?>city/سینما-ترس/" class="desktop-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/10/slider-D-new.jpg" alt="سینما ترس - اسکیپ زوم" style="width: 100% !important;"></a>
                <a href="<?= $home_url; ?>city/سینما-ترس/" class="mobile-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/10/slider-D-sm-new.jpg" alt="سینما ترس - اسکیپ زوم" style="width: 100% !important;"></a>
            </div>
            <div class="middle-left-adv adv-banner"><a href="<?= $home_url; ?>type/%d9%85%d8%b9%d9%85%d8%a7%db%8c%db%8c/"><img src="<?= get_template_directory_uri() . '/img/slider-E-2-4.jpg' ?>" alt="" style="width: 100% !important;"></a></div>
        </div>
    </section>
<?php }
/************************************************************************************************************/
add_shortcode('home_advertise_middle_bottom', 'home_advertise_middle_bottom_func');
function home_advertise_middle_bottom_func() {
    ?>
    <style>

        @media (min-width: 768px){

            .middle-left-adv-bottom {
                display: none;
            }
        }
    </style>
    <section>
        <div class="advertise-middle_bottom">
            <div class="middle-left-adv-bottom adv-banner">
                <a href="<?= $home_url; ?>type/%d9%85%d8%b9%d9%85%d8%a7%db%8c%db%8c/"><img src="<?= get_template_directory_uri() . '/img/slider-E-2-sm.jpg' ?>" alt="" style="width: 100% !important;"></a>
            </div>
        </div>
    </section>
<?php }
/************************************************************************************************************/
add_shortcode('home_advertise_top', 'home_advertise_top_func');
function home_advertise_top_func() {
    ?>
    <style>
        .advertise-top {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 8px;
            justify-content: space-between;
            margin-bottom: 30px;

        }
        .advertise-top > div {
            height: 100%;
            width: 100%;
        }
        .adv-banner {
            width: 100%;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 2px 2px 2px 0px #bfbfbf;
        }
        .adv-banner > a {
            height: 100%;
            width:100%;
        }
        .adv-banner > a > img {
            max-width: 100%;
            width: 100% !important;
            height: 100%;
            object-fit: cover;
            transition: all 1s ease;
        }
        .adv-banner > a > img:hover {
            transform: scale(1.05);
            filter: brightness(1.05);
        }
        .right-adv  {
            grid-column: span 2;
            width: 100%;
        }
        .left-adv {
            display: flex;
            flex-direction: column;
            gap: 8px;
            width: 100%;
        }
        @media (max-width: 968px) {
            .advertise-top {
                grid-template-columns: repeat(5, 1fr);
            }
            .right-adv  {
                grid-column: span 3;
            }
            .left-adv  {
                grid-column: span 2;
            }
            .adv-banner {
                border-radius: 15px;
            }
        }
        @media (max-width: 568px) {
            .adv-banner {
                border-radius: 10px;
            }
            .advertise-top {
                grid-template-columns: repeat(2, 1fr);
            }
            .left-adv {
                flex-direction: row;
                justify-content: space-between;
                grid-column: span 2;
            }
            .right-adv  {
                grid-column: span 2;
            }
        }
        .desktop-image-banner {
            display: none;
        }
        @media (min-width: 768px){
            .desktop-image-banner {
                display: unset !important;
            }
            .mobile-image-banner {
                display: none;
            }
        }
    </style>
    <section>
        <div class="advertise-top">
            <div class="right-adv adv-banner">
                <a href="https://escapezoom.ir/city/%d8%a7%d8%aa%d8%a7%d9%82-%d9%81%d8%b1%d8%a7%d8%b1/" class="desktop-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/09/Frame-6-1.webp" alt="" style="object-position: right; width: 100% !important;"></a>
                <a href="https://escapezoom.ir/city/%d8%a7%d8%aa%d8%a7%d9%82-%d9%81%d8%b1%d8%a7%d8%b1/" class="mobile-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/09/Iran-escapexoom.ir-mobile.webp" alt="" style="object-position: right; width: 100% !important;"></a>
            </div>
            <div class="left-adv">
                <div class="adv-banner">
                    <!--<a href="<?= $home_url; ?>city/کرج/" class="desktop-image-banner"><img src="<?= get_template_directory_uri() . '/img/slider-B-5.jpg' ?>" alt="" style="width: 100% !important;"></a>-->
                    <!--<a href="<?= $home_url; ?>city/کرج/" class="mobile-image-banner"><img src="<?= get_template_directory_uri() . '/img/slider-B-3-Mobile.jpg' ?>" alt="" style="width: 100% !important;"></a>-->
                    <a href="<?= $home_url; ?>blog/اسکیپ-زوم-در-جهش-کاپ/" class="desktop-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/10/olampic-lg.png" alt="" style="width: 100% !important;"></a>
                    <a href="<?= $home_url; ?>blog/اسکیپ-زوم-در-جهش-کاپ/" class="mobile-image-banner"><img src="http://escapezoom.ir/wp-content/uploads/2024/10/olampic-sm.png" alt="" style="width: 100% !important;"></a>
                </div>
                <div class="adv-banner">
                    <a href="https://instagram.com/escapezoom.ir" class="desktop-image-banner"><img src="<?= get_template_directory_uri() . '/img/slider-C-3-2.jpg' ?>" alt="" style="width: 100% !important;"></a>
                    <a href="https://instagram.com/escapezoom.ir" class="mobile-image-banner"><img src="<?= get_template_directory_uri() . '/img/slider-C-3-sm.jpg' ?>" alt="" style="width: 100% !important;"></a>
                </div>
            </div>
        </div>
    </section>
    <?php
}
/************************************************************************************************************/
add_shortcode('home_blog_section', 'home_blog_section_func');
function home_blog_section_func() { ?>
    <style>
        .blog-section {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            grid-template-rows: repeat(4, 130px);
            gap: 8px;
            background: #ececec;
            padding: 4px;
        }
        .blog-item {
            position: relative;
        }
        .blog-item .blog-title > a {
            text-decoration: none;
            color: white;
            line-height: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            display: -webkit-box;
            font-weight: 600;
        }
        .blog-category {
            display: none;
        }
        .blog-expert {
            display: none;
        }
        .blog-footer {
            display: none;
        }
        .blog-item > a.blog-image {
            display: block;
            width: 100%;
            height: 100%;
        }
        .blog-item > a.blog-image > img {
            max-width: 100%;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .blog-item:nth-child(1){
            grid-row: 2 span;
        }
        .blog-item:nth-child(5){
            grid-row: 2 span;
        }
        .blog-item:nth-child(3){
            grid-row: 4 span;
            background: white;
        }
        .blog-item:nth-child(1) .blog-title, .blog-item:nth-child(5) .blog-title {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: #0000009f;
            padding:16px;
        }

        .blog-item:nth-child(1) .blog-title a, .blog-item:nth-child(5) .blog-title a {
            font-size: 14.5px;
            transition: all .5s ease;
        }
        .blog-item:nth-child(1) .blog-title a:hover, .blog-item:nth-child(5) .blog-title a:hover {
            color: #f3a88d;

        }
        .blog-item:nth-child(2),.blog-item:nth-child(4), .blog-item:nth-child(6), .blog-item:nth-child(7) {
            display: flex;
            background: white;
        }
        .blog-item:nth-child(2) .blog-image,.blog-item:nth-child(4) .blog-image, .blog-item:nth-child(6) .blog-image, .blog-item:nth-child(7) .blog-image {
            width: 200px;
            height: 100px;
        }
        .blog-item:nth-child(2) .blog-title > a,.blog-item:nth-child(4) .blog-title > a, .blog-item:nth-child(6) .blog-title > a, .blog-item:nth-child(7) .blog-title > a {
            color: #000;
            width: 100%;
            margin-right: 10px;
            margin-top: 5px;
            font-weight: 600;
        }
        .blog-item:nth-child(2) .blog-footer,.blog-item:nth-child(4) .blog-footer, .blog-item:nth-child(6) .blog-footer, .blog-item:nth-child(7) .blog-footer {
            display: flex;
            position: absolute;
            justify-content: center;
            background-color: white;
            bottom: 0;
            left: 0;
            right: 0;
            border-top: 1px solid #dadada;
            padding-top: 10px;
            padding-bottom: 5px;
            gap: 32px;
        }
        .blog-item:nth-child(2) .blog-footer > div > svg,.blog-item:nth-child(4) .blog-footer > div > svg, .blog-item:nth-child(6) .blog-footer > div > svg, .blog-item:nth-child(7) .blog-footer > div > svg {
            width: 13px;
            height: 13px;
            color: #979797;
        }
        .blog-item:nth-child(2) .blog-title,.blog-item:nth-child(4) .blog-title, .blog-item:nth-child(6) .blog-title, .blog-item:nth-child(7) .blog-title {
            width: 100%;
        }
        .blog-item:nth-child(2) .blog-title a,.blog-item:nth-child(4) .blog-title a, .blog-item:nth-child(6) .blog-title a, .blog-item:nth-child(7) .blog-title a{
            font-size: 13.5px;
            transition: all .5s ease;
        }
        .blog-item:nth-child(2) .blog-title a:hover,.blog-item:nth-child(4) .blog-title a:hover, .blog-item:nth-child(6) .blog-title a:hover, .blog-item:nth-child(7) .blog-title a:hover{
            color: #ee5a24;
        }
        .blog-item:nth-child(2) .blog-footer > div > span.blog-author,.blog-item:nth-child(4) .blog-footer > div > span.blog-author, .blog-item:nth-child(6) .blog-footer > div > span.blog-author, .blog-item:nth-child(7) .blog-footer > div > span.blog-author {
            font-size: 11px;
            color: #979797;
        }
        .blog-item:nth-child(2) .blog-footer > div > span.blog-calendar,.blog-item:nth-child(4) .blog-footer > div > span.blog-calendar, .blog-item:nth-child(6) .blog-footer > div > span.blog-calendar, .blog-item:nth-child(7) .blog-footer > div > span.blog-calendar {
            font-size: 11px;
            color: #979797;
        }
        .blog-item:nth-child(2) .blog-footer > div,.blog-item:nth-child(4) .blog-footer > div, .blog-item:nth-child(6) .blog-footer > div , .blog-item:nth-child(7) .blog-footer > div {
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .blog-item:nth-child(3) > .blog-image{
            height: 55%;
        }
        .blog-item:nth-child(3) > .blog-category{
            display: block;
            padding: 0px 16px;
            color: #ee5a24;
            margin-top: 10px;
            font-size: 16px;
            font-weight: 600;
        }
        .blog-item:nth-child(3) > .blog-category > a{
            color: #ee5a24;
        }

        .blog-item:nth-child(3) > .blog-title {
            padding: 0 16px;
            margin: 10px 0;
        }
        .blog-item:nth-child(3) > .blog-title > a{
            color: #2e2e2e;
            line-height: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            display: -webkit-box;
            font-weight: 600;
            font-size: 20px;
            transition: all .5s ease;
        }
        .blog-item:nth-child(3) > .blog-title > a:hover {
            color: #ee5a24;
        }
        .blog-item:nth-child(3) > .blog-expert {
            display: block;
        }
        .blog-item:nth-child(3) > .blog-expert > p{
            color: #3d3d3d;
            line-height: 2;
            overflow: hidden;
            text-overflow: ellipsis;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            display: -webkit-box;
            font-size: 16px;
            padding: 0 16px;
        }
        @media (max-width: 1240px) {
            .blog-section {
                display: grid;
                grid-template-columns: repeat(2, 1fr);
                grid-template-rows: repeat(6, 130px);
                gap: 8px;
                background: #ececec;
                padding: 4px;
            }
            .blog-item:nth-child(1){
                order: 1;
            }
            .blog-item:nth-child(5){
                order: 2;
            }
            .blog-item:nth-child(3){
                order: 3;
                grid-row: 2 span;
                grid-column: 2 span;

            }
            .blog-item:nth-child(3) .blog-image {
                width: 48%;
                height: 100%;
            }
            .blog-item:nth-child(3) .blog-expert > p {
                width: 48%;
                color: #3d3d3d;
                line-height: 2;
                overflow: hidden;
                text-overflow: ellipsis;
                -webkit-line-clamp: 6;
                -webkit-box-orient: vertical;
                display: -webkit-box;
                font-size: 16px;
                padding: 0 16px;
                position: absolute;
                top: 15px;
                left: 0;

            }
            .blog-item:nth-child(3) .blog-category {
                position: absolute;
                z-index: 1;
                top: 10px;
                right: 10px;
                background: white;
                padding: 4px;
            }
            .blog-item:nth-child(3) .blog-title {
                position: absolute;
                bottom: -10px;
                z-index: 1;
                width: 45%;
                padding:16px;
            }
            .blog-item:nth-child(3) .blog-title a {
                color: white;
            }
            .blog-item:nth-child(2), .blog-item:nth-child(4), .blog-item:nth-child(6), .blog-item:nth-child(7){
                order: 4;
            }
        }
        @media (max-width: 768px) {
            .blog-item:nth-child(2), .blog-item:nth-child(4), .blog-item:nth-child(6), .blog-item:nth-child(7){
                order: 4;
                grid-column: 2 span;
            }
        }
        @media (max-width: 568px) {
            .blog-section {
                display: none;
            }
            .blog-item-mobile {
                background: white;
                position: relative;
                border: 1px solid #eeeeee;
                min-width: 350px;
                height: 200px;
            }
            .blog-item-mobile > a.blog-image-mobile {
                display: block;
            }
            .blog-item-mobile > a.blog-image-mobile > img {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .blog-category-mobile {
                background-color: #f96f0c;
                padding: 4px 8px;
                border-radius: 8px;
                position: absolute;
                top: 6px;
                right: 6px;

            }
            .blog-category-mobile > a {
                color: white;
                font-weight: 600;
            }
            .blog-title-mobile {
                padding: 0px 16px;
            }
            .blog-title-mobile > a {
                line-height: 2;
                margin: 2px 6px;
                padding: 2px 4px;
                overflow: hidden;
                text-overflow: ellipsis;
                -webkit-line-clamp: 1;
                -webkit-box-orient: vertical;
                display: -webkit-box;
                text-decoration: none;
                font-weight: 600;
                color: #e2e2e2;
                background: #000000be;
                position: absolute;
                z-index: 1;
                bottom: 10px;
                left: 0;
                right: 0;
                width: fit-content;
                border-radius: 5px;
            }
        }
        .wrapper-title {
            margin-top: 25px;
            margin-bottom: 15px;

        }
        .section-title {
            font-size: 22px;
            font-weight: 600;
            color: #595959;
        }
        @media (min-width: 568px) {
            .blog-section-mobile {
                display: none;
            }
        }

    </style>
    <div class="wrapper-title"><div class="section-title">خواندنی ها</div></div>
    <section class="blog-section">
        <?php
        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 7
        );
        $the_query = new WP_Query( $args );
        if ( $the_query->have_posts() ) :
            while ( $the_query->have_posts() ) :
                $the_query->the_post();
                ?>
                <div class="blog-item">
                    <a href="<?php the_permalink(); ?>" class="blog-image"><img src="<?= get_the_post_thumbnail_url() ?>" alt="<?php the_title() ?>" style="width:100% !important;"></a>
                    <span class="blog-category"><?php the_category(" , ") ?></span>
                    <div class="blog-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title() ?></a>
                    </div>
                    <div class="blog-expert"><?php the_excerpt() ?></div>
                    <div class="blog-footer">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                            </svg>
                            <span class="blog-author"><?php the_author() ?></span>
                        </div>
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z" />
                            </svg>

                            <span class="blog-calendar"><?php the_date() ?></span>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php else : ?>
            <p>متاسفانه محتوایی یافت نشد</p>
        <?php endif; ?>
    </section>
    <section class="blog-section-mobile">
        <div class="swiper blogSwiper" style="height: 200px !important;">
            <div class="swiper-wrapper">
                <?php
                $args = array(
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'posts_per_page' => 7
                );
                $the_query = new WP_Query( $args );
                if ( $the_query->have_posts() ) :
                    while ( $the_query->have_posts() ) :
                        $the_query->the_post();
                        ?>
                        <div class="swiper-slide blog-item-mobile">
                            <a href="<?php the_permalink(); ?>" class="blog-image-mobile"><img src="<?= get_the_post_thumbnail_url() ?>" alt="<?php the_title() ?>"></a>
                            <span class="blog-category-mobile"><?php the_category(" , ") ?></span>
                            <div class="blog-title-mobile">
                                <a href="<?php the_permalink(); ?>"><?php the_title() ?></a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                <?php else : ?>
                    <p>متاسفانه محتوایی یافت نشد</p>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <script>
        var swiper = new Swiper(".blogSwiper", {
            effect: "coverflow",
            grabCursor: true,
            centeredSlides: true,
            loop: true,
            slidesPerView: "auto",
            coverflowEffect: {
                rotate: 50,
                stretch: 0,
                depth: 100,
                modifier: 1,
                slideShadows: true,
            },
            autoplay: {
                delay: 2500,
                disableOnInteraction: false,
            },

        });
    </script>
<?php }
/********************************************************************************/
add_shortcode('test_best_rooms', 'test_best_rooms_func');
function test_best_rooms_func() {
    $posts_per_page = 20;
    $args = [
        'image_type'        => 'url',
        'limit'             => $posts_per_page,
        'page'              => 1,
        'max_num_pages'     => true,
        "format"            => 'html_slider2',
        'is_mobile'         => wp_is_mobile(),
        'sort_type'         => 'trend',
        'only_ads'          => false,
        'show_more'         => 0,
        'badge_ads'         => false,
        'random'            => true
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_trends", {

                <!--                --><?php //if ( wp_is_mobile() ) : ?>
//                slidesPerView: 2.5,
//
//                <?php //else : ?>
//                slidesPerView: 7.5,
//
//                <?php //endif; ?>

                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#trends_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "type": "sort_products_get",
                    "data": {
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        'max_num_pages' : true,
                        "format"        : 'html_slider2',
                        "is_mobile"     : 0,
                        'sort_type'     : 'trend',
                        'only_ads'      : 0,
                        'show_more'     : 0,
                        'badge_ads'     : 0,
                        'random'        : 1,
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                    }
                },
                dataType: "json",
                success: function(data) {
                    setTimeout(function() {
                        $('#trends_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#trends_wrapper .swiper-wrapper');
                        $('#trends_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 25);
                },
            });
        });
    </script>

    <div id="trends_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">
        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">

                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title"> اتاق فرارهای تِرند ایران</div>

                <?php else : ?>
                    <div class="section-title"> اتاق فرارهای تِرند ایران</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_trends" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <style>
        .trends-section-title {
            background: linear-gradient(45deg, #ff0000, #ffff00, #ff00f3, #66ff00, #16bffd, #a90077);
            background-size: 400%;
            font-size: 3em;
            font-family: 'Morabba-Bold';
            color: white;
            padding: 10px;
            -webkit-background-clip: text;
            -webkit-text-stroke: 5px transparent;
            animation: animate 10s linear infinite;
        }
        @keyframes animate {
            0% {
                background-position: 0%;
            }

            100% {
                background-position: 400%;
            }
        }
        @font-face {
            font-family: 'Morabba-Bold';
            src: url(<?= get_template_directory_uri() . '/fonts/Morabba-Bold.woff2' ?>);
        }
        .slider-single-content__title {
            margin-bottom: unset !important;
        }
        .shop-page-header-sort {
            margin-top: -4px !important;
        }
        @media (max-width: 767.98px) {
            margin-top: 15px !important;
        }
        @media (max-width: 767.98px) {
            #others_wrapper .slider-single-content {
                margin-top: unset !important;
            }
            .section-title {
                margin-top: 15px;
            }
            .shop-page-header-sort {
                margin-top: 5px !important;
            }
        }
        .swiper-pagination {
            margin-top: 5px !important;
        }

        .load-more {
            display: none;
            margin-top: 300px;
        }
        .img-arc-mobile {
            height: auto;
            width: 100%;
            max-width: 80px!important;
        }
        .swiper-initialized{
            height: 282px !important;
        }
        .swiper-slide {
            width: 12.5617284% !important;
            margin-left: 10px;
        }
        @media only screen and (max-width: 600px) {
            .swiper-slide {
                width: 38.5645933% !important;
                margin-left: 10px;
            }
        }
        .arc-box-mobile {
            border: 1px solid #eee;
            margin: 10px;
            width: 100%;
            border-radius: 3px position: relative;
        }
        .arc-mobile-footer {
            margin-top: -13px;
        }
        .arc-mobile-loc,.arc-mobile-price,.arc-mobile-nafar,.arc-mobile-time {
            font-size: 10px;
            font-weight: 400;
            text-align: center;
        }
        .arc-mobile-title {
            font-size: 1em !important;
            margin-right: -7px;
            font-weight: 800;
        }
        @media only screen and (max-width: 600px){
            span.special-escapezooms {
                right: 120px !important;
                bottom: 0 !important;
            }}
        h5 {
            font-size: 14px;
            padding: 10px;
        }
        .arc-mobile-btn {
            font-size: 10px;
            height: 25px;
            width: calc(100% - 29px);
            margin-left: 30px!important;
        }
        /*.swiper-wrapper {*/
        /*    height: auto!important;*/
        /*}*/
        a.btn.btn-light.m-2 {
            width: 59px;
        }
        @media only screen and (max-width: 600px) {
            span.shakes {
                right: 63px;
                margin-top: 86px;
            }
        }
        .zardkooh-shop-sort-by {
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: justify;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }
        .shop-page-header-sort {
            max-width: 414px;
            float: left;
            opacity: 1 !important;
            z-index: 99;
            display: flex;
            justify-content: flex-end;
            list-style: none;
            background-color: #fff;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border-radius: 10px;
            padding: 0;
            overflow: hidden;
            align-items: center;
            height: 30px;
        }
        .shop-page-header-sort li a.is-active {
            background-color: #ee5a24;
            color: #fff;
        }
        .shop-page-header-sort li a:last-child {
            border-left: none;
        }
        .shop-page-header-sort li a {
            color: #929ba6;
            padding: 10px;
            border-left: 1px solid #e6eaf0;
        }
        .is-active {
            display: block!important;
        }
        #ez_cat_filter_wrapper {
            background: #fff;
            padding: 0;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border: 1px solid #eee;
            border-radius: 8px;
        }
        button#ez_cat_filter_submit {
            display: block;
            margin: 30px auto 10px;
            background: #ee5a24;
            color: #fff;
            width: 80%;
        }
        .ez_cat_filter_item_city_list, .ez_cat_filter_item_tag_list {
            appearance: auto;
        }
        .ez_cat_filter_item {
            position: relative;
            margin: 5px;
            background: #f3f3f3;
            padding: 10px;
            border-radius: 8px;
        }
        .ez_cat_filter_item_slider_min {
            position: absolute;
            top: 80px;
            right: 5px;
            font-size: 13px;
        }
        .ez_cat_filter_item_slider_max {
            position: absolute;
            top: 80px;
            left: 5px;
            font-size: 13px;
        }
        .noUi-pips.noUi-pips-horizontal {
            display: none;
        }
        .ez_cat_filter_item_schedule_days_item {
            background: #fff;
            color: #323232;
            border-radius: 50%;
            width: 50px;
            display: flex;
            height: 50px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: 1px solid #ee5a24;
        }
        #ez_cat_filter_item_schedule_days {
            display: flex;
            justify-content: space-between;
            margin: 20px 0;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            position: relative;
            display: none;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            justify-content: space-between;
        }
        .ez_cat_filter_item_schedule_days_item.is-active {
            background: #ee5a24;
            display: flex !important;
            color: #fff;
        }
        .noUi-target {
            margin: 20px 10px 20px 10px;
        }
        .ez_cat_filter_item_title {
            font-weight: bold;
            margin-bottom: 10px;
            display: block;
            font-size: 15px;
            color: #343434;
        }
        .ez_cat_filter_item_body {
            color: #000;
        }
        #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_min, #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_max {
            top: 30px;
        }
        #ez_cat_filter_item_count {
            width: 140px;
        }
        #ez_cat_filter_item_level {
            width: 100%;
        }
        .ez_cat_filter_item_city_list_item *, .ez_cat_filter_item_tag_list_item * {
            cursor: pointer;
        }
        #ez_cat_filter_title {
            padding: 10px;
            display: block;
            color: #fff;
            font-size: 21px;
            background: #ee5a24;
            text-align: center;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
        }
        #ez_cat_filter_item_price_max_title {
            position: absolute;
            top: 32px;
            left: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_price_min_title {
            position: absolute;
            top: 32px;
            right: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_duration {
            width: 190px;
        }
        #ez_cat_filter_item_age {
            width: 190px;
        }
        .ez_cat_filter_item_schedule_slider_input {
            font-size: 18px !important;
            border: 1px solid #cacaca !important;
            width: 50px;
            height: 35px;
            margin: 0 4px;
            display: block;
            text-align: left;
            padding: 6px 0px 0px 5px !important;
            border-radius: 6px !important;
        }
        .ez_cat_filter_item_schedule_slider_input_wrapper {
            display: flex;
            position: relative;
        }
        .ez_cat_filter_item_schedule_slider_input_up_arrow {
            position: absolute;
            rotate: 90deg;
            right: 51px;
            font-size: 14px;
            top: -8px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_up_arrow {
            top: -2px;
        }
        .ez_cat_filter_item_schedule_slider_input:disabled {
            color: #363636 !important;
        }
        .ez_cat_filter_item_schedule_slider_input_down_arrow {
            position: absolute;
            rotate: -90deg;
            right: 47px;
            font-size: 14px;
            top: 21px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_down_arrow {
            top: 16px;
        }
        .ez_cat_filter_item_schedule_slider_input_title {
            display: flex;
            align-items: center;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_line {
            position: absolute;
            left: 38px;
            border-bottom: 1px solid #cacaca;
            width: 15px;
            top: 17px;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_border {
            position: absolute;
            left: 21px;
            border-top: 1px solid #cacaca;
            width: 34px;
            top: 17px;
            rotate: 90deg;
        }
        .ez_2clmns {
            display: grid;
            grid-auto-flow: dense;
            grid-template-columns: 50% 50%;
        }
        #ez_cat_filter_wrapper select {
            border: 1px solid #cacaca;
            border-radius: 6px;
            height: 30px;
        }
        .ez_cat_filter_item_city_list_item, .ez_cat_filter_item_tag_list_item {
            text-align: right;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_wrapper {
            width: 58px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow {
            right: 4px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow {
            right: 0px;
        }
        .woocommerce ul.products.columns-3 li.product, .woocommerce-page ul.products.columns-3 li.product {
            width: 13.5%;
        }
        #ez_cat_filter_item_schedule_today_slider_wrapper {
            display: flex;
        }
        .noUi-connect {
            background: #f96f0c;
        }
    </style>

    <?php
}
/********************************************************************************/
add_shortcode('trends_best_rooms', 'trends_best_rooms_func');
function trends_best_rooms_func() {
    $posts_per_page = 20;
    $args = [
        'image_type'        => 'url',
        'limit'             => $posts_per_page,
        'page'              => 1,
        'max_num_pages'     => true,
        "format"            => 'html_slider',
        'is_mobile'         => wp_is_mobile(),
        'sort_type'         => 'trend',
        'only_ads'          => false,
        'show_more'         => 0,
        'badge_ads'         => false,
        'random'            => true
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_trends", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#trends_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "type": "sort_products_get",
                    "data": {
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        'max_num_pages' : true,
                        "format"        : 'html_slider',
                        "is_mobile"     : 0,
                        'sort_type'     : 'trend',
                        'only_ads'      : 0,
                        'show_more'     : 0,
                        'badge_ads'     : 0,
                        'random'        : 1,
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                    }
                },
                dataType: "json",
                success: function(data) {
                    setTimeout(function() {
                        $('#trends_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#trends_wrapper .swiper-wrapper');
                        $('#trends_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 25);
                },
            });
        });
    </script>

    <div id="trends_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">
        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">

                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title"> اتاق فرارهای تِرند ایران</div>

                <?php else : ?>
                    <div class="section-title"> اتاق فرارهای تِرند ایران</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_trends" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <style>
        .trends-section-title {
            background: linear-gradient(45deg, #ff0000, #ffff00, #ff00f3, #66ff00, #16bffd, #a90077);
            background-size: 400%;
            font-size: 3em;
            font-family: 'Morabba-Bold';
            color: white;
            padding: 10px;
            -webkit-background-clip: text;
            -webkit-text-stroke: 5px transparent;
            animation: animate 10s linear infinite;
        }
        @keyframes animate {
            0% {
                background-position: 0%;
            }

            100% {
                background-position: 400%;
            }
        }
        @font-face {
            font-family: 'Morabba-Bold';
            src: url(<?= get_template_directory_uri() . '/fonts/Morabba-Bold.woff2' ?>);
        }
        .slider-single-content__title {
            margin-bottom: unset !important;
        }
        .shop-page-header-sort {
            margin-top: -4px !important;
        }
        @media (max-width: 767.98px) {
            margin-top: 15px !important;
        }
        @media (max-width: 767.98px) {
            #others_wrapper .slider-single-content {
                margin-top: unset !important;
            }
            .section-title {
                margin-top: 15px;
            }
            .shop-page-header-sort {
                margin-top: 5px !important;
            }
        }
        .swiper-pagination {
            margin-top: 5px !important;
        }

        .load-more {
            display: none;
            margin-top: 300px;
        }
        .img-arc-mobile {
            height: auto;
            width: 100%;
            max-width: 80px!important;
        }
        .swiper-initialized{
            height: 282px !important;
        }
        .swiper-slide {
            width: 12.5617284% !important;
            margin-left: 10px;
        }
        @media only screen and (max-width: 600px) {
            .swiper-slide {
                width: 38.5645933% !important;
                margin-left: 10px;
            }
        }
        .arc-box-mobile {
            border: 1px solid #eee;
            margin: 10px;
            width: 100%;
            border-radius: 3px position: relative;
        }
        .arc-mobile-footer {
            margin-top: -13px;
        }
        .arc-mobile-loc,.arc-mobile-price,.arc-mobile-nafar,.arc-mobile-time {
            font-size: 10px;
            font-weight: 400;
            text-align: center;
        }
        .arc-mobile-title {
            font-size: 1em !important;
            margin-right: -7px;
            font-weight: 800;
        }
        @media only screen and (max-width: 600px){
            span.special-escapezooms {
                right: 120px !important;
                bottom: 0 !important;
            }}
        h5 {
            font-size: 14px;
            padding: 10px;
        }
        .arc-mobile-btn {
            font-size: 10px;
            height: 25px;
            width: calc(100% - 29px);
            margin-left: 30px!important;
        }
        /*.swiper-wrapper {*/
        /*    height: auto!important;*/
        /*}*/
        a.btn.btn-light.m-2 {
            width: 59px;
        }
        @media only screen and (max-width: 600px) {
            span.shakes {
                right: 63px;
                margin-top: 86px;
            }
        }
        .zardkooh-shop-sort-by {
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: justify;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }
        .shop-page-header-sort {
            max-width: 414px;
            float: left;
            opacity: 1 !important;
            z-index: 99;
            display: flex;
            justify-content: flex-end;
            list-style: none;
            background-color: #fff;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border-radius: 10px;
            padding: 0;
            overflow: hidden;
            align-items: center;
            height: 30px;
        }
        .shop-page-header-sort li a.is-active {
            background-color: #ee5a24;
            color: #fff;
        }
        .shop-page-header-sort li a:last-child {
            border-left: none;
        }
        .shop-page-header-sort li a {
            color: #929ba6;
            padding: 10px;
            border-left: 1px solid #e6eaf0;
        }
        .is-active {
            display: block!important;
        }
        #ez_cat_filter_wrapper {
            background: #fff;
            padding: 0;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border: 1px solid #eee;
            border-radius: 8px;
        }
        button#ez_cat_filter_submit {
            display: block;
            margin: 30px auto 10px;
            background: #ee5a24;
            color: #fff;
            width: 80%;
        }
        .ez_cat_filter_item_city_list, .ez_cat_filter_item_tag_list {
            appearance: auto;
        }
        .ez_cat_filter_item {
            position: relative;
            margin: 5px;
            background: #f3f3f3;
            padding: 10px;
            border-radius: 8px;
        }
        .ez_cat_filter_item_slider_min {
            position: absolute;
            top: 80px;
            right: 5px;
            font-size: 13px;
        }
        .ez_cat_filter_item_slider_max {
            position: absolute;
            top: 80px;
            left: 5px;
            font-size: 13px;
        }
        .noUi-pips.noUi-pips-horizontal {
            display: none;
        }
        .ez_cat_filter_item_schedule_days_item {
            background: #fff;
            color: #323232;
            border-radius: 50%;
            width: 50px;
            display: flex;
            height: 50px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: 1px solid #ee5a24;
        }
        #ez_cat_filter_item_schedule_days {
            display: flex;
            justify-content: space-between;
            margin: 20px 0;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            position: relative;
            display: none;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            justify-content: space-between;
        }
        .ez_cat_filter_item_schedule_days_item.is-active {
            background: #ee5a24;
            display: flex !important;
            color: #fff;
        }
        .noUi-target {
            margin: 20px 10px 20px 10px;
        }
        .ez_cat_filter_item_title {
            font-weight: bold;
            margin-bottom: 10px;
            display: block;
            font-size: 15px;
            color: #343434;
        }
        .ez_cat_filter_item_body {
            color: #000;
        }
        #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_min, #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_max {
            top: 30px;
        }
        #ez_cat_filter_item_count {
            width: 140px;
        }
        #ez_cat_filter_item_level {
            width: 100%;
        }
        .ez_cat_filter_item_city_list_item *, .ez_cat_filter_item_tag_list_item * {
            cursor: pointer;
        }
        #ez_cat_filter_title {
            padding: 10px;
            display: block;
            color: #fff;
            font-size: 21px;
            background: #ee5a24;
            text-align: center;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
        }
        #ez_cat_filter_item_price_max_title {
            position: absolute;
            top: 32px;
            left: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_price_min_title {
            position: absolute;
            top: 32px;
            right: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_duration {
            width: 190px;
        }
        #ez_cat_filter_item_age {
            width: 190px;
        }
        .ez_cat_filter_item_schedule_slider_input {
            font-size: 18px !important;
            border: 1px solid #cacaca !important;
            width: 50px;
            height: 35px;
            margin: 0 4px;
            display: block;
            text-align: left;
            padding: 6px 0px 0px 5px !important;
            border-radius: 6px !important;
        }
        .ez_cat_filter_item_schedule_slider_input_wrapper {
            display: flex;
            position: relative;
        }
        .ez_cat_filter_item_schedule_slider_input_up_arrow {
            position: absolute;
            rotate: 90deg;
            right: 51px;
            font-size: 14px;
            top: -8px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_up_arrow {
            top: -2px;
        }
        .ez_cat_filter_item_schedule_slider_input:disabled {
            color: #363636 !important;
        }
        .ez_cat_filter_item_schedule_slider_input_down_arrow {
            position: absolute;
            rotate: -90deg;
            right: 47px;
            font-size: 14px;
            top: 21px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_down_arrow {
            top: 16px;
        }
        .ez_cat_filter_item_schedule_slider_input_title {
            display: flex;
            align-items: center;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_line {
            position: absolute;
            left: 38px;
            border-bottom: 1px solid #cacaca;
            width: 15px;
            top: 17px;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_border {
            position: absolute;
            left: 21px;
            border-top: 1px solid #cacaca;
            width: 34px;
            top: 17px;
            rotate: 90deg;
        }
        .ez_2clmns {
            display: grid;
            grid-auto-flow: dense;
            grid-template-columns: 50% 50%;
        }
        #ez_cat_filter_wrapper select {
            border: 1px solid #cacaca;
            border-radius: 6px;
            height: 30px;
        }
        .ez_cat_filter_item_city_list_item, .ez_cat_filter_item_tag_list_item {
            text-align: right;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_wrapper {
            width: 58px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow {
            right: 4px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow {
            right: 0px;
        }
        .woocommerce ul.products.columns-3 li.product, .woocommerce-page ul.products.columns-3 li.product {
            width: 13.5%;
        }
        #ez_cat_filter_item_schedule_today_slider_wrapper {
            display: flex;
        }
        .noUi-connect {
            background: #f96f0c;
        }
        .elite_rooms_wrapper .topescaperoom {
            padding-bottom: 10px;
        }
    </style>

    <?php
}
/********************************************************************************/
add_shortcode('special_discounts', 'special_discounts_func');
function special_discounts_func() {
    $posts_per_page = 100;

    $args = [
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'show_more'     => 0,
        'only_events'   => true,
        'event_type'    => "discount",
        'random'        => true,
        'badge_ads'     => false,
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products;

    if ($products): ?>
        <div id="adsx_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2; background: #f3f3f3; padding: 10px; border: 1px solid #e3e2e2; border-radius: 8px; margin: 20px 0; min-height: 400px;">
            <div style="margin-bottom: 30px;display: flex;align-items: center;justify-content: space-between;" class="event-products-header">
                <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;">
                   <span style="filter: drop-shadow(0px 1px 2px rgba(0, 0, 0, 0.25));transform: rotate(180deg); position: relative;width: 41px;height: 41px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 32 32" fill="none" style="position: absolute;left: 0;top: 0;transform:translate(6px,8px);z-index: 1;">
                          <path fill-rule="evenodd" clip-rule="evenodd" d="M26.4221 10.7605C26.6894 10.5553 26.863 10.2506 26.9047 9.91351C26.9464 9.57639 26.8527 9.23442 26.6443 8.96281L24.4212 6.06587C24.2105 5.80088 23.9059 5.628 23.5729 5.58446C23.2399 5.54092 22.9051 5.63021 22.6407 5.83309C22.3764 6.03598 22.2035 6.33622 22.1594 6.66917C22.1153 7.00211 22.2035 7.34111 22.405 7.61316L23.8422 9.48602L22.2937 10.6744L20.8565 8.80152C20.6458 8.53653 20.3412 8.36365 20.0081 8.32011C19.6751 8.27657 19.3404 8.36586 19.076 8.56874C18.8116 8.77162 18.6388 9.07187 18.5947 9.40482C18.5506 9.73776 18.6388 10.0768 18.8402 10.3488L20.2775 12.2217L12.4009 18.2647C11.4146 17.4875 10.1852 17.0939 8.94331 17.1577C7.70138 17.2215 6.53213 17.7383 5.65473 18.6112C4.77733 19.4842 4.25203 20.6533 4.17729 21.8995C4.10255 23.1457 4.48351 24.3834 5.24874 25.3806C6.01398 26.3777 7.11097 27.0659 8.33407 27.3161C9.55717 27.5663 10.8224 27.3614 11.8926 26.7397C12.9628 26.118 13.7645 25.1223 14.1475 23.9391C14.5304 22.756 14.4682 21.4666 13.9727 20.3128L26.4221 10.7605ZM8.96694 24.8287C9.63992 24.9226 10.3184 24.7448 10.8533 24.3344C11.3881 23.9239 11.7354 23.3145 11.8187 22.6401C11.9021 21.9658 11.7147 21.2817 11.2978 20.7384C10.8809 20.1951 10.2686 19.8371 9.59559 19.7432C8.92261 19.6493 8.24408 19.8271 7.70927 20.2375C7.17445 20.6479 6.82716 21.2573 6.7438 21.9317C6.66044 22.6061 6.84783 23.2902 7.26475 23.8334C7.68167 24.3767 8.29396 24.7347 8.96694 24.8287Z" fill="#ffffff"/>
                          <circle cx="9.8806" cy="6.0847" r="3.08665" fill="#ffffff"/>
                          <circle cx="26.9128" cy="24.9719" r="3.08665" fill="#ffffff"/>
                        </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none" style="position: absolute;left: 0;right: 0;bottom: 0;top: 0;">
                          <path d="M39.9221 24.4033C38.5688 22.0621 38.5698 19.1755 39.9241 16.8349C40.1873 16.3796 40.2589 15.8384 40.1231 15.3304C39.9874 14.8223 39.6554 14.389 39.2002 14.1256C36.8624 12.7744 35.412 10.2729 35.412 7.57269C35.412 7.04668 35.2031 6.54221 34.8311 6.17026C34.4592 5.79831 33.9547 5.58935 33.4287 5.58935C30.7297 5.58935 28.2299 4.14009 26.8797 1.80317C26.6168 1.34766 26.1837 1.01521 25.6758 0.878932C25.4241 0.811502 25.1617 0.794312 24.9034 0.828342C24.6451 0.862373 24.396 0.946958 24.1704 1.07727C21.8268 2.43191 18.9372 2.43084 16.594 1.07528C16.1385 0.812288 15.5972 0.741017 15.0891 0.877149C14.581 1.01328 14.1478 1.34567 13.8848 1.80118C12.5341 4.13795 10.0328 5.58935 7.33381 5.58935C6.80779 5.58935 6.30332 5.79831 5.93137 6.17026C5.55942 6.54221 5.35046 7.04668 5.35046 7.57269C5.35046 10.2717 3.89903 12.773 1.56227 14.1236C1.33663 14.254 1.13889 14.4276 0.980369 14.6345C0.821848 14.8414 0.705651 15.0774 0.63842 15.3292C0.571188 15.581 0.554242 15.8436 0.588547 16.1019C0.622853 16.3603 0.70774 16.6093 0.838354 16.8349C2.19289 19.1758 2.19289 22.0623 0.838354 24.4033C0.57653 24.859 0.505493 25.3997 0.64073 25.9076C0.775967 26.4155 1.10651 26.8493 1.56029 27.1145C3.89705 28.4652 5.34848 30.9664 5.34848 33.6654C5.34848 34.1915 5.55744 34.6959 5.92939 35.0679C6.30134 35.4398 6.80581 35.6488 7.33183 35.6488C10.0321 35.6488 12.5335 37.0991 13.8848 39.437C14.0604 39.7371 14.3111 39.9864 14.6122 40.1603C14.9134 40.3341 15.2546 40.4266 15.6024 40.4286C15.9475 40.4286 16.2906 40.3374 16.596 40.1609C18.9372 38.8062 21.8267 38.8073 24.1684 40.1609C24.6237 40.424 25.1649 40.4956 25.6729 40.3598C26.181 40.2241 26.6143 39.8921 26.8777 39.437C28.2274 37.0998 30.7278 35.6488 33.4267 35.6488C33.9527 35.6488 34.4572 35.4398 34.8291 35.0679C35.2011 34.6959 35.41 34.1915 35.41 33.6654C35.41 30.9664 36.8615 28.4652 39.1982 27.1145C39.4239 26.9841 39.6216 26.8105 39.7801 26.6036C39.9386 26.3968 40.0548 26.1607 40.1221 25.9089C40.1893 25.6571 40.2063 25.3945 40.172 25.1362C40.1376 24.8778 40.0528 24.6288 39.9221 24.4033Z" fill="url(#paint0_linear_279_28)"/>
                          <defs>
                            <linearGradient id="paint0_linear_279_28" x1="30" y1="22" x2="46.5" y2="67.5" gradientUnits="userSpaceOnUse">
                              <stop stop-color="#F21543"/>
                              <stop offset="1" stop-color="#8C0C27"/>
                            </linearGradient>
                          </defs>
                        </svg>
                    </span>
                    <span style="font-weight: 800">پیشنهادهای داغ هفته</span>
                </h2>
                <div style="display: flex; align-items: center;justify-content: space-between; gap: 4px; direction: ltr; margin-left: 10px" class="timestamp-box">
                    <div class="timer-box-container days-expire-count">
                        <div class="box-time-character">0</div>
                        <?php
                        $today = intval(date('w'));
                        function convertNum($num){
                            if($num >=1 && $num <= 7){
                                return 7 - $num;
                            }
                            return null;
                        }
                        ?>
                        <div class="box-time-character"><?= convertNum($today); ?></div>
                    </div>
                    <span>:</span>
                    <div class="timer-box-container hours-expire-count">
                        <div class="box-time-character">0</div>
                        <div class="box-time-character">0</div>
                    </div>
                    <span>:</span>
                    <div class="timer-box-container minutes-expire-count">
                        <div class="box-time-character">0</div>
                        <div class="box-time-character">0</div>
                    </div>
                    <span>:</span>
                    <div class="timer-box-container seconds-expire-count">
                        <div class="box-time-character">0</div>
                        <div class="box-time-character">0</div>
                    </div>
                </div>
            </div>

            <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex; height: 360px !important;">
                <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

        <style>
            .timer-box-container {
                display: flex;
                gap: 2px;
            }
            .box-time-character {
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-size: 20px;
                font-weight: 900;
                border-radius: 6px;
                text-shadow: 0px 4px 4px rgba(0, 0, 0, 0.25);
                width: 30px;
                height: 30px;
                background: linear-gradient(161deg, #F21543 65.74%, #8C0C27 167.69%);
                box-shadow: 0px 4px 4px 0px rgba(0, 0, 0, 0.25);
            }
            @media screen and (max-width: 768px) {
                .event-products-header {
                    flex-direction: column;
                    gap: 10px;
                    align-items: stretch;
                }
            }
        </style>
        <script>
            jQuery(document).ready(function ($) {

                if ( location.hostname == 'escapezoom.co' ) {
                    $('.topescaperoom').each(function(i, obj) {
                        $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                        $(obj).html($res);
                    });
                }

                var swiper = new Swiper("#swiper_adsx", {
                    slidesPerView: "auto",
                    spaceBetween: 10,
                    loop: false,
                    paginationClickable: true,
                    freeMode: true,
                });

                var is_mobile = $('#product_list_is_mobile').val();

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "async": false,
                        "type": "sort_products_get",
                        "data": {
                            'image_type'    : 'url',
                            "limit"         : 100,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : is_mobile,
                            'sort_type'     : 'recent',
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'only_events'   : 1,
                            'event_type'    : "discount",
                            'random'        : 1,
                            'badge_ads'     : 0,
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        setTimeout(function() {
                            $('#adsx_wrapper .swiper-wrapper').empty();
                            $(data.products).appendTo('#adsx_wrapper .swiper-wrapper');
                            $('#adsx_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 1);
                    },
                });
            });

            // var swiper = new Swiper("#swiper_adsx", {
            //     slidesPerView: "auto",
            //     spaceBetween: 10,
            //     loop: false,
            //     paginationClickable: true,
            //     freeMode: true,
            // });
            let todayNum = `<?php echo date('w'); ?>`
            function convertNumber(num) {
                if (num >= 1 && num <= 7) {
                    return 7 - num;
                }
                return null;
            }
            $(this).find('.days-expire-count .box-time-character').eq(1).text(convertNumber(todayNum));
            function getValue(d, timePart) {
                var val = 0
                switch (timePart) {
                    case "hours":
                        val = 23 - parseInt(d.getHours());
                        break;
                    case "minutes":
                        val = 59 - parseInt(d.getMinutes())
                        break;
                    case "seconds":
                        val = 59 - parseInt(d.getSeconds())
                        break;
                    case "milliseconds":
                        val = 999 - parseInt(d.getMilliseconds())
                        break;
                    default:
                        break;
                }
                return val.toString().padStart(2, '0');
            }
            function init() {
                setInterval(function () {
                    let d = new Date();
                    let h = getValue(d, "hours");
                    let m = getValue(d, "minutes");
                    let s = getValue(d, "seconds");
                    $('.timestamp-box').each(function (){
                        let hourString = String(h).padStart(2, '0');
                        let minuteString = String(m).padStart(2, '0');
                        let secondString = String(s).padStart(2, '0');
                        $(this).find('.hours-expire-count .box-time-character').eq(0).text(hourString.charAt(0)); // دهگان ساعت
                        $(this).find('.hours-expire-count .box-time-character').eq(1).text(hourString.charAt(1)); // یکان ساعت
                        $(this).find('.minutes-expire-count .box-time-character').eq(0).text(minuteString.charAt(0)); // دهگان دقیقه
                        $(this).find('.minutes-expire-count .box-time-character').eq(1).text(minuteString.charAt(1)); // یکان دقیقه
                        $(this).find('.seconds-expire-count .box-time-character').eq(0).text(secondString.charAt(0)); // دهگان روز
                        $(this).find('.seconds-expire-count .box-time-character').eq(1).text(secondString.charAt(1)); // یکان روز
                    })
                }, 1000);
            }
            init()
        </script>
    <?php
    endif;
}
/********************************************************************************/
add_shortcode('alborz_best_rooms', 'alborz_best_rooms_func');
function alborz_best_rooms_func() {
    $posts_per_page = 15;
    $params = [
        'city_id' => [162],
    ];

    $show_more_url = get_term_link(162);

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'show_more'     => true,
        'show_more_url' => $show_more_url,
        'random'        => false,
    ];
    $data = json_decode ( ez_webservice( array('type' => 'sort' . '_products_get', 'data' => $args) ) );
    $products = $data->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_alborz", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#alborz_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            $('body').on('click', '#alborz_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#alborz_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');

                $('#alborz_wrapper .swiper-wrapper').empty();
                $('#alborz_wrapper #swiper_alborz .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                var params = {
                    'city_id' : '162'.split(','),
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : 0,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'show_more'     : true,
                            'show_more_url' : '<?php echo $show_more_url ?>',
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $('#alborz_wrapper .swiper-wrapper').css('display', 'none');

                        $(data.products).appendTo('#alborz_wrapper .swiper-wrapper');

                        setTimeout(function() {
                            $('#alborz_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 25);

                        $('#alborz_wrapper #swiper_alborz').css('width', '200%');
                        setTimeout(function() {
                            $('#alborz_wrapper #swiper_alborz').css('width', '200%');
                        }, 10);
                        setTimeout(function() {
                            $('#alborz_wrapper #swiper_alborz').css('width', '100%');
                        }, 10);
                        setTimeout(function() {
                            $('#alborz_wrapper #swiper_alborz .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                            $('#alborz_wrapper #swiper_alborz .swiper-wrapper .swiper-slide:last-child').removeClass("swiper-slide-active");
                        }, 50);
                    },
                });
            });
        });
    </script>

    <div id="alborz_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

        <div class="shop-page-header">
            <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                    <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب</a></li>
                    <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش</a></li>
                    <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدید</a></li>
                </ul>

            </section>
        </div>

        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">
                <div class=" swiper-pagination nav1"></div>
                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title">البرز</div>
                <?php else : ?>
                    <div class="section-title">البرز</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_alborz" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <style>
        .load-more {
            display: none;
            margin-top: 300px;
        }
        .img-arc-mobile {
            height: auto;
            width: 100%;
            max-width: 80px!important;
        }
        .swiper-initialized{
            height: 282px !important;
        }
        .swiper-slide {
            width: 12.5617284% !important;
            margin-left: 10px;
        }
        @media only screen and (max-width: 600px) {
            .swiper-slide {
                width: 38.5645933% !important;
                margin-left: 10px;
            }
        }
        .arc-box-mobile {
            border: 1px solid #eee;
            margin: 10px;
            width: 100%;
            border-radius: 3px position: relative;
        }
        .arc-mobile-footer {
            margin-top: -13px;
        }
        .arc-mobile-loc,.arc-mobile-price,.arc-mobile-nafar,.arc-mobile-time {
            font-size: 10px;
            font-weight: 400;
            text-align: center;
        }
        .arc-mobile-title {
            font-size: 1em !important;
            margin-right: -7px;
            font-weight: 800;
        }
        @media only screen and (max-width: 600px){
            span.special-escapezooms {
                right: 120px !important;
                bottom: 0 !important;
            }}
        h5 {
            font-size: 14px;
            padding: 10px;
        }
        .arc-mobile-btn {
            font-size: 10px;
            height: 25px;
            width: calc(100% - 29px);
            margin-left: 30px!important;
        }
        /*.swiper-wrapper {*/
        /*    height: auto!important;*/
        /*}*/
        a.btn.btn-light.m-2 {
            width: 59px;
        }
        @media only screen and (max-width: 600px) {
            span.shakes {
                right: 63px;
                margin-top: 86px;
            }
        }
        .zardkooh-shop-sort-by {
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: justify;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }
        .shop-page-header-sort {
            max-width: 414px;
            float: left;
            opacity: 1 !important;
            z-index: 99;
            display: flex;
            justify-content: flex-end;
            list-style: none;
            background-color: #fff;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border-radius: 10px;
            padding: 0;
            overflow: hidden;
            align-items: center;
            height: 30px;
        }
        .shop-page-header-sort li a.is-active {
            background-color: #ee5a24;
            color: #fff;
        }
        .shop-page-header-sort li a:last-child {
            border-left: none;
        }
        .shop-page-header-sort li a {
            color: #929ba6;
            padding: 10px;
            border-left: 1px solid #e6eaf0;
        }
        .is-active {
            display: block!important;
        }
        #ez_cat_filter_wrapper {
            background: #fff;
            padding: 0;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border: 1px solid #eee;
            border-radius: 8px;
        }
        button#ez_cat_filter_submit {
            display: block;
            margin: 30px auto 10px;
            background: #ee5a24;
            color: #fff;
            width: 80%;
        }
        .ez_cat_filter_item_city_list, .ez_cat_filter_item_tag_list {
            appearance: auto;
        }
        .ez_cat_filter_item {
            position: relative;
            margin: 5px;
            background: #f3f3f3;
            padding: 10px;
            border-radius: 8px;
        }
        .ez_cat_filter_item_slider_min {
            position: absolute;
            top: 80px;
            right: 5px;
            font-size: 13px;
        }
        .ez_cat_filter_item_slider_max {
            position: absolute;
            top: 80px;
            left: 5px;
            font-size: 13px;
        }
        .noUi-pips.noUi-pips-horizontal {
            display: none;
        }
        .ez_cat_filter_item_schedule_days_item {
            background: #fff;
            color: #323232;
            border-radius: 50%;
            width: 50px;
            display: flex;
            height: 50px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: 1px solid #ee5a24;
        }
        #ez_cat_filter_item_schedule_days {
            display: flex;
            justify-content: space-between;
            margin: 20px 0;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            position: relative;
            display: none;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            justify-content: space-between;
        }
        .ez_cat_filter_item_schedule_days_item.is-active {
            background: #ee5a24;
            display: flex !important;
            color: #fff;
        }
        .noUi-target {
            margin: 20px 10px 20px 10px;
        }
        .ez_cat_filter_item_title {
            font-weight: bold;
            margin-bottom: 10px;
            display: block;
            font-size: 15px;
            color: #343434;
        }
        .ez_cat_filter_item_body {
            color: #000;
        }
        #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_min, #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_max {
            top: 30px;
        }
        #ez_cat_filter_item_count {
            width: 140px;
        }
        #ez_cat_filter_item_level {
            width: 100%;
        }
        .ez_cat_filter_item_city_list_item *, .ez_cat_filter_item_tag_list_item * {
            cursor: pointer;
        }
        #ez_cat_filter_title {
            padding: 10px;
            display: block;
            color: #fff;
            font-size: 21px;
            background: #ee5a24;
            text-align: center;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
        }
        #ez_cat_filter_item_price_max_title {
            position: absolute;
            top: 32px;
            left: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_price_min_title {
            position: absolute;
            top: 32px;
            right: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_duration {
            width: 190px;
        }
        #ez_cat_filter_item_age {
            width: 190px;
        }
        .ez_cat_filter_item_schedule_slider_input {
            font-size: 18px !important;
            border: 1px solid #cacaca !important;
            width: 50px;
            height: 35px;
            margin: 0 4px;
            display: block;
            text-align: left;
            padding: 6px 0px 0px 5px !important;
            border-radius: 6px !important;
        }
        .ez_cat_filter_item_schedule_slider_input_wrapper {
            display: flex;
            position: relative;
        }
        .ez_cat_filter_item_schedule_slider_input_up_arrow {
            position: absolute;
            rotate: 90deg;
            right: 51px;
            font-size: 14px;
            top: -8px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_up_arrow {
            top: -2px;
        }
        .ez_cat_filter_item_schedule_slider_input:disabled {
            color: #363636 !important;
        }
        .ez_cat_filter_item_schedule_slider_input_down_arrow {
            position: absolute;
            rotate: -90deg;
            right: 47px;
            font-size: 14px;
            top: 21px;
            font-weight: bold;
            cursor: pointer;
            width: 20px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_down_arrow {
            top: 16px;
        }
        .ez_cat_filter_item_schedule_slider_input_title {
            display: flex;
            align-items: center;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_line {
            position: absolute;
            left: 38px;
            border-bottom: 1px solid #cacaca;
            width: 15px;
            top: 17px;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_border {
            position: absolute;
            left: 21px;
            border-top: 1px solid #cacaca;
            width: 34px;
            top: 17px;
            rotate: 90deg;
        }
        .ez_2clmns {
            display: grid;
            grid-auto-flow: dense;
            grid-template-columns: 50% 50%;
        }
        #ez_cat_filter_wrapper select {
            border: 1px solid #cacaca;
            border-radius: 6px;
            height: 30px;
        }
        .ez_cat_filter_item_city_list_item, .ez_cat_filter_item_tag_list_item {
            text-align: right;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_wrapper {
            width: 58px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow {
            right: 4px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow {
            right: 0px;
        }
        .woocommerce ul.products.columns-3 li.product, .woocommerce-page ul.products.columns-3 li.product {
            width: 13.5%;
        }
        #ez_cat_filter_item_schedule_today_slider_wrapper {
            display: flex;
        }
        .noUi-connect {
            background: #f96f0c;
        }
    </style>
    <?php
}
/************************************************************************************************************/
add_shortcode('tehran_best_rooms', 'tehran_best_rooms_func');
function tehran_best_rooms_func() {
    $posts_per_page = 15;
    $params = [
        'city_id' => [15],
    ];

    $show_more_url = get_term_link(15);

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'show_more'     => true,
        'show_more_url' => $show_more_url,
        'random'        => false,
    ];
    $data = json_decode ( ez_webservice( array('type' => 'sort' . '_products_get', 'data' => $args) ) );
    $products = $data->products; ?>

    <script>
        jQuery(document).ready(function ($) {
            var swiper = new Swiper("#swiper_tehran", {

                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#tehran_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            $('body').on('click', '#tehran_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#tehran_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');
                $('#tehran_wrapper .swiper-wrapper').empty();
                $('#tehran_wrapper #swiper_tehran .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                var params = {
                    'city_id' : '15'.split(','),
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : 0,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'show_more'     : true,
                            'show_more_url' : '<?php echo $show_more_url ?>',
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $(data.products).appendTo('#tehran_wrapper .swiper-wrapper');

                        $('#tehran_wrapper .swiper-wrapper').css('display', 'none');

                        setTimeout(function() {
                            $('#tehran_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 25);

                        $('#tehran_wrapper #swiper_tehran').css('width', '200%');
                        setTimeout(function() {
                            $('#tehran_wrapper #swiper_tehran').css('width', '200%');
                        }, 30);
                        setTimeout(function() {
                            $('#tehran_wrapper #swiper_tehran').css('width', '100%');
                        }, 30);
                        setTimeout(function() {
                            $('#tehran_wrapper #swiper_tehran .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                            $('#tehran_wrapper #swiper_tehran .swiper-wrapper .swiper-slide:last-child').removeClass("swiper-slide-active");
                        }, 50);
                    },
                });
            });
        });
    </script>

    <div id="tehran_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

        <div class="shop-page-header">
            <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                    <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب</a></li>
                    <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش</a></li>
                    <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدید</a></li>
                </ul>

            </section>
        </div>

        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">
                <div class=" swiper-pagination nav1"></div>
                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title">تهران</div>
                <?php else : ?>
                    <div class="section-title">تهران</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_tehran" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <?php
}
/************************************************************************************************************/
add_shortcode('esfehan_best_rooms', 'esfehan_best_rooms_func');
function esfehan_best_rooms_func() {
    $posts_per_page = 15;
    $params = [
        'city_id' => [122],
    ];

    $show_more_url = get_term_link(122);

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'show_more'     => true,
        'show_more_url' => $show_more_url,
        'random'        => false,
    ];
    $data = json_decode ( ez_webservice( array('type' => 'sort' . '_products_get', 'data' => $args) ) );
    $products = $data->products; ?>

    <script>
        jQuery(document).ready(function ($) {
            var swiper = new Swiper("#swiper_esfehan", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#esfehan_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            $('body').on('click', '#esfehan_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#esfehan_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');

                $('#esfehan_wrapper .swiper-wrapper').empty();
                $('#esfehan_wrapper #swiper_esfehan .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                var params = {
                    'city_id' : '122'.split(','),
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : 0,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'show_more'     : true,
                            'show_more_url' : '<?php echo $show_more_url ?>',
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $(data.products).appendTo('#esfehan_wrapper .swiper-wrapper');

                        $('#esfehan_wrapper .swiper-wrapper').css('display', 'none');

                        setTimeout(function() {
                            $('#esfehan_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 50);

                        $('#esfehan_wrapper #swiper_esfehan').css('width', '200%');
                        setTimeout(function() {
                            $('#esfehan_wrapper #swiper_esfehan').css('width', '200%');
                        }, 10);
                        setTimeout(function() {
                            $('#esfehan_wrapper #swiper_esfehan').css('width', '100%');
                        }, 10);
                        setTimeout(function() {
                            $('#esfehan_wrapper #swiper_esfehan .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                            $('#esfehan_wrapper #swiper_esfehan .swiper-wrapper .swiper-slide:last-child').removeClass("swiper-slide-active");
                        }, 50);
                    },
                });
            });
        });
    </script>

    <div id="esfehan_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

        <div class="shop-page-header">
            <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                    <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب</a></li>
                    <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش</a></li>
                    <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدید</a></li>
                </ul>

            </section>
        </div>

        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">
                <div class=" swiper-pagination nav1"></div>
                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title">اصفهان</div>
                <?php else : ?>
                    <div class="section-title">اصفهان</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_esfehan" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <?php
}
/************************************************************************************************************/
add_shortcode('others_best_rooms', 'mashad_best_rooms_func');
function mashad_best_rooms_func() {
    $posts_per_page = 15;
    $params = [
        'city_id' => [121],
    ];

    $show_more_url = get_term_link(121);

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'show_more'     => true,
        'show_more_url' => $show_more_url,
        'random'        => false,
    ];
    $data = json_decode ( ez_webservice( array('type' => 'sort' . '_products_get', 'data' => $args) ) );
    $products = $data->products; ?>

    <script>
        jQuery(document).ready(function ($) {
            var swiper = new Swiper("#swiper_others", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#others_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            $('body').on('click', '#others_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#others_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');

                $('#others_wrapper .swiper-wrapper').empty();
                $('#others_wrapper #swiper_others .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                var params = {
                    'city_id' : '121'.split(','),
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : 0,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'show_more'     : 1,
                            'show_more_url' : '<?php echo $show_more_url ?>',
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $(data.products).appendTo('#others_wrapper .swiper-wrapper');

                        $('#others_wrapper .swiper-wrapper').css('display', 'none');

                        setTimeout(function() {
                            $('#others_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 25);

                        $('#others_wrapper #swiper_others').css('width', '200%');
                        setTimeout(function() {
                            $('#others_wrapper #swiper_others').css('width', '200%');
                        }, 10);
                        setTimeout(function() {
                            $('#others_wrapper #swiper_others').css('width', '100%');
                        }, 10);
                        setTimeout(function() {
                            $('#others_wrapper #swiper_others .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                            $('#others_wrapper #swiper_others .swiper-wrapper .swiper-slide:last-child').removeClass("swiper-slide-active");
                        }, 50);
                    },
                });
            });
        });
    </script>

    <div id="others_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

        <div class="shop-page-header">
            <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                    <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب</a></li>
                    <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش</a></li>
                    <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدید</a></li>
                </ul>

            </section>
        </div>

        <section class="slider-single-content">
            <div class="slider-single-content__title slidertitleh2">
                <div class=" swiper-pagination nav1"></div>
                <?php if (wp_is_mobile()) : ?>
                    <div class="section-title">مشهد</div>
                <?php else : ?>
                    <div class="section-title">مشهد</div>
                <?php endif; ?>
            </div>
        </section>

        <div dir="rtl" id="swiper_others" data-id="1" class="swiper topescaperoom">
            <div class="swiper-wrapper">
                <?php echo $products; ?>
            </div>
        </div>
    </div>

    <?php
}