<?php
/*
Plugin Name: zoomNazar
Description: پلاگین اختصاصی کامنت مشابه یکی از سایت های معاند اسکیپ زوم
Version: 1.7.2
*/

//define('PLUGIN_DIR_ZN', plugin_dir_path(__FILE__));
//define('PLUGIN_URL_ZN', plugin_dir_url(__FILE__));
/****************************************************************************************************************************************/
// Enqueue own styles
add_action('wp_enqueue_scripts', 'enqueue_zoomnazar_styles');
function enqueue_zoomnazar_styles() {
    wp_enqueue_style('zoomnazar_styles', get_template_directory_uri() . '/inc/plugin/zoomnazar/zn-style.css', array(), false, 'all');
}
/****************************************************************************************************************************************/
add_action('init', 'nazar_js');
function nazar_js() {
    wp_register_script('ezb2', get_template_directory_uri() . '/inc/plugin/zoomnazar/zn-script.js', array('jquery'), '2.9', true);
    wp_enqueue_script('ezb2');

    $val_params = array(
        'ezb2_ajaxurl'  => admin_url('admin-ajax.php'),
        'ezb2_userid'   => get_current_user_ID(),
    );
    wp_localize_script('ezb2', 'ezb2', $val_params);
}
/****************************************************************************************************************************************/
add_action('wp_head', 'javascript_variables');
function javascript_variables() { ?>
    <script type="text/javascript">
        var ajax_url    = '<?php echo admin_url("admin-ajax.php"); ?>';
        var ajax_nonce  = '<?php echo wp_create_nonce("secure_nonce_name"); ?>';
    </script>
<?php
}
/****************************************************************************************************************************************/
add_shortcode('zoomnazar_shortcode', 'create_zoomnazarshortcode_shortcode'); // Shortcode: [zoomnazar_shortcode id="22"]
function create_zoomnazarshortcode_shortcode($atts) {

    $atts = shortcode_atts(
        array (
            'id' => '22',
        ),
        $atts,
        'zoomnazar_shortcode'
    );

    $id = $atts['id'];
    ob_start(); ?>

    <div class="wrap_zn">
        <a href="#modal_zn-one" class="btn_zn btn_zn-big">ارسال کامنت!</a>
    </div>

    <input type="hidden" id="zr_cm_tk" value="<?php echo isset($_GET['set_cm']) && !empty($_GET['set_cm']) ? $_GET['set_cm'] : '' ?>">

    <!-- modal_zn -->
    <div class="modal_zn" id="modal_zn-one" aria-hidden="true">
        <div class="modal_zn-dialog">
            <div class="modal_zn-header">
                <h2>ثبت کامنت برای اتاق فرار <?php echo get_the_title(get_the_ID());  ?></h2>
                <a href="#" class="btn_zn-close" aria-hidden="true">×</a>
            </div>
            <div class="modal_zn-body">

                <?php
                $randd = rand(1000, 9999); ?>

                <script>
                    jQuery(document).ready(function ($) {
                        $("body").on("keyup", '#f1_message', function(){
                            if ( parseInt($(this).val().length) < 5 ) {
                                $("#single_product_cm_min_layer_disable").css('display', 'block');
                                $('#single_product_cm_min_msg').css('display', 'block');
                                $('#f1_message').css('border-color', 'red');

                            } else{
                                $("#znform_submit").prop("disabled", false);
                                $('#single_product_cm_min_msg').hide();
                                $('#single_product_cm_min_layer_disable').hide();
                                $('#f1_message').css('border-color', '#eef1f5');
                            }
                        });
                    });
                </script>


                <form class="znform1>" id="znform1" name="zoomnazar" method="post" action="">
                    <input name="f1_name" id="f1_name" type="text" class="feedback-input zn_hide" placeholder="نام"/>
                    <textarea style="border-color: red" <?php if (!wp_is_mobile()): ?>rows="6"<?php endif ?>  name="f1_message" id="f1_message" class="feedback-input" minlength="5" placeholder="کامنت"></textarea>
                    <span id="single_product_cm_min_msg" style="font-size: 12px;display: block;color: red;margin: -20px 0 30px 0;">کامنت شما باید حداقل 5 کاراکتر باشد.</span>

                    <?php
                    $terms = get_the_terms(get_the_ID(), 'product_cat');
                    foreach ( $terms as $term ) 
                        if ( $term->parent != 0 )
                            $product_type = get_term( $term->parent )->name;

                    if ( $product_type == 'اتاق فرار' ) : ?>

                        <div class="feedback">
                            <span>طراحی دکور</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-5" value="100">
                                <label for="rating_zn_1-5"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-4" value="80">
                                <label for="rating_zn_1-4"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-3" value="60">
                                <label for="rating_zn_1-3"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-2" value="40">
                                <label for="rating_zn_1-2"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-1" value="20">
                                <label for="rating_zn_1-1"></label>
                            </div>
                        </div>

                        <div class="feedback">
                            <span>کیفیت معما</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_2" class="rating_zn_2" id="rating_zn_2-5" value="100">
                                <label for="rating_zn_2-5"></label>
                                <input type="radio" name="rating_zn_2" class="rating_zn_2" id="rating_zn_2-4" value="80">
                                <label for="rating_zn_2-4"></label>
                                <input type="radio" name="rating_zn_2" class="rating_zn_2" id="rating_zn_2-3" value="60">
                                <label for="rating_zn_2-3"></label>
                                <input type="radio" name="rating_zn_2" class="rating_zn_2" id="rating_zn_2-2" value="40">
                                <label for="rating_zn_2-2"></label>
                                <input type="radio" name="rating_zn_2" class="rating_zn_2" id="rating_zn_2-1" value="20">
                                <label for="rating_zn_2-1"></label>
                            </div>
                        </div>

                        <div class="feedback">
                            <span>تازگی و خلاقیت</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_3" class="rating_zn_3" id="rating_zn_3-5" value="100">
                                <label for="rating_zn_3-5"></label>
                                <input type="radio" name="rating_zn_3" class="rating_zn_3" id="rating_zn_3-4" value="80">
                                <label for="rating_zn_3-4"></label>
                                <input type="radio" name="rating_zn_3" class="rating_zn_3" id="rating_zn_3-3" value="60">
                                <label for="rating_zn_3-3"></label>
                                <input type="radio" name="rating_zn_3" class="rating_zn_3" id="rating_zn_3-2" value="40">
                                <label for="rating_zn_3-2"></label>
                                <input type="radio" name="rating_zn_3" class="rating_zn_3" id="rating_zn_3-1" value="20">
                                <label for="rating_zn_3-1"></label>
                            </div>
                        </div>

                        <div class="feedback">
                            <span>بازیگردانی و اکت</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_4" class="rating_zn_4" id="rating_zn_4-5" value="100">
                                <label for="rating_zn_4-5"></label>
                                <input type="radio" name="rating_zn_4" class="rating_zn_4" id="rating_zn_4-4" value="80">
                                <label for="rating_zn_4-4"></label>
                                <input type="radio" name="rating_zn_4" class="rating_zn_4" id="rating_zn_4-3" value="60">
                                <label for="rating_zn_4-3"></label>
                                <input type="radio" name="rating_zn_4" class="rating_zn_4" id="rating_zn_4-2" value="40">
                                <label for="rating_zn_4-2"></label>
                                <input type="radio" name="rating_zn_4" class="rating_zn_4" id="rating_zn_4-1" value="20">
                                <label for="rating_zn_4-1"></label>
                            </div>
                        </div>

                        <div class="feedback">
                            <span>برخورد پرسنل</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_5" class="rating_zn_5" id="rating_zn_5-5" value="100">
                                <label for="rating_zn_5-5"></label>
                                <input type="radio" name="rating_zn_5" class="rating_zn_5" id="rating_zn_5-4" value="80">
                                <label for="rating_zn_5-4"></label>
                                <input type="radio" name="rating_zn_5" class="rating_zn_5" id="rating_zn_5-3" value="60">
                                <label for="rating_zn_5-3"></label>
                                <input type="radio" name="rating_zn_5" class="rating_zn_5" id="rating_zn_5-2" value="40">
                                <label for="rating_zn_5-2"></label>
                                <input type="radio" name="rating_zn_5" class="rating_zn_5" id="rating_zn_5-1" value="20">
                                <label for="rating_zn_5-1"></label>
                            </div>
                        </div>

                    <?php
                    else: ?>

                        <div class="feedback">
                            <span>امتیاز</span>
                            <div class="rating_zn">
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-5" value="100">
                                <label for="rating_zn_1-5"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-4" value="80">
                                <label for="rating_zn_1-4"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-3" value="60">
                                <label for="rating_zn_1-3"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-2" value="40">
                                <label for="rating_zn_1-2"></label>
                                <input type="radio" name="rating_zn_1" class="rating_zn_1" id="rating_zn_1-1" value="20">
                                <label for="rating_zn_1-1"></label>
                            </div>
                        </div>

                    <?php
                    endif; ?>

                    <p style="display: none;color:red; color: #a60000; text-align: center; background: rgb(255 0 0 / 20%); margin-bottom: 10px; border-radius: 5px; padding:10px 5px;" id="rate_plz" class="error_msg">لطفا به بازی امتیاز دهید.</p>

                    <input type="submit" class="znform_submit" value="ارسال" data-type="<?php echo $product_type ?>" />
                    <span id="single_product_cm_min_layer_disable" style="background: #ffffff3d;width: 318px;display: block;height: 46px;position: absolute;bottom: 50px;"></span>
                </form>

                <form class="znform2" id="znform2" name="znform1" style="display:none;" method="post" action="">
                    <input type="text" class="zn_hide" name="f2_name" id="f2_name" value="">
                    <textarea name="f2_message" class="zn_hide" id="f2_message"></textarea>
                    <input type="text" name="f2_rate1" class="zn_hide" id="f2_rate1" value="">
                    <input type="text" name="f2_rate2" class="zn_hide" id="f2_rate2" value="">
                    <input type="text" name="f2_rate3" class="zn_hide" id="f2_rate3" value="">
                    <input type="text" name="f2_rate4" class="zn_hide" id="f2_rate4" value="">
                    <input type="text" name="f2_rate5" class="zn_hide" id="f2_rate5" value="">
                    <input type="text" id="f2_rand" class="zn_hide" name="f2_rand" value="<?php echo $randd; ?>">
                    <input type="number" id="f2_mobile" class="feedback-input f2_mobile" align="left" name="f2_mobile" placeholder="مثل 09012345673" maxlength="11">
                    <input type="submit" class="zoomnaz_phone_submit" id="f2_submit" value="ارسال کد تایید"/>
                </form>

                <form class="znform3" id="znform3" name="znform3" style="display:none;" method="post" action="">
                    <input type="text" name="f3_roomid" id="f3_roomid" class="zn_hide" value="<?php the_ID() ?>">
                    <input type="text" name="f3_name" id="f3_name" class="zn_hide" value="">
                    <textarea name="f3_message" id="f3_message" class="zn_hide"></textarea>
                    <input type="text" name="f3_rate1" id="f3_rate1" class="zn_hide" value="">
                    <input type="text" name="f3_rate2" id="f3_rate2" class="zn_hide" value="">
                    <input type="text" name="f3_rate3" id="f3_rate3" class="zn_hide" value="">
                    <input type="text" name="f3_rate4" id="f3_rate4" class="zn_hide" value="">
                    <input type="text" name="f3_rate5" id="f3_rate5" class="zn_hide" value="">
                    <input type="text" id="f3_rand" name="f3_rand" class="zn_hide" value="<?php echo $randd; ?>">
                    <input type="text" id="f3_mobile" class="f3_mobile zn_hide" align="left" name="f3_mobile" placeholder="مثل 09012345673" maxlength="11" value="">
                    <input id="f3_randCheck" class="verifyCode f3_randCheck" align="center" name="f3_randCheck" oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" type="number" maxlength="4" value='' tabindex="1">
                    <input type="submit" class="zoomnaz_phone_submit send_code" id="f3_submit" value="تایید کد" data-type="<?php echo $product_type ?>" />
                    <p style="display: none;color:red; color: #a60000; text-align: center; background: rgb(255 0 0 / 20%); margin-bottom: 10px; border-radius: 5px; padding:10px 5px;" id="error_cmnt" class="error_msg"></p>
                </form>

                <form class="znform4" id="znform4" name="znform4" style="display:none;" method="post" action="">
                    <p style="display: none;color:red; color: #a60000; text-align: center; background: rgb(255 0 0 / 20%); margin-bottom: 10px; border-radius: 5px; padding:10px 5px;" id="error_cmnt" class="error_msg"></p>

                    <div class="success-comment" style="display: none;">
                        <span><img draggable="false" role="img" class="emoji" alt="✔️" src="https://s.w.org/images/core/emoji/13.1.0/svg/2714.svg"></span>
                    </div>
                    <p class="success-comment-text" style="display: none;"></p>
                    <input type="text" name="f4_roomid" id="f4_roomid" value="" class="zn_hide">
                    <textarea name="f4_message" id="f4_message" class="zn_hide"></textarea>
                    <input type="text" name="f4_rate1" id="f4_rate1" class="zn_hide" value="">
                    <input type="text" name="f4_rate2" id="f4_rate2" class="zn_hide" value="">
                    <input type="text" name="f4_rate3" id="f4_rate3" class="zn_hide" value="">
                    <input type="text" name="f4_rate4" id="f4_rate4" class="zn_hide" value="">
                    <input type="text" name="f4_rate5" id="f4_rate5" class="zn_hide" value="">
                    <input type="text" id="f4_rand" name="f4_rand" class="zn_hide" value="<?php echo $randd; ?>">
                    <input type="text" id="f4_mobile" class="zn_hide" align="left" class="zn_hide" name="f4_mobile" placeholder="مثل 09012345673" maxlength="11" value="">

                </form>

                <p><img class="zn_loader" src="https://escapezoom.ir/wp-content/themes/escapezoom-v1/inc/plugin/zoomnazar/loading.gif" id="znloading"></p>

                <p id="out"></p>
            </div>
        </div>
    </div>
    <!-- /modal_zn -->

    <?php
    $output_string = ob_get_contents();
    ob_end_clean();
    return $output_string;
}
/****************************************************************************************************************************************/
add_action('wp_ajax_zn_f1', 'zn_f1'); // This is for authenticated users
add_action('wp_ajax_nopriv_zn_f1', 'zn_f1'); // This is for unauthenticated users.
function zn_f1() {

    die();
}
/****************************************************************************************************************************************/
add_action('wp_ajax_zn_f2', 'zn_f2'); // This is for authenticated users
add_action('wp_ajax_nopriv_zn_f2', 'zn_f2'); // This is for unauthenticated users.
function zn_f2() {

    $token          = htmlspecialchars($_POST['cm_token']);
    $f2_roomid      = htmlspecialchars($_POST['f2_roomid']);
    $randd          = htmlspecialchars($_POST['f2_rand']);
    $user_mobile    = substr(htmlspecialchars($_POST['f2_mobile']), 1, 10);
    $user           = wp_get_current_user();

    $comments_blacklist = get_post_meta($f2_roomid, 'comments_blacklist', true);
    $comments_blacklist = empty( $comments_blacklist ) ? [] : $comments_blacklist;


    if (in_array('commentchi', (array)$user->roles)) { ?>

        <style>
            input#f3_rand {
                display: block !important;
            }
        </style>

        <?php
    } else {

        if ( !empty( $token ) ) { // this user found this comment page via the url he received

            $order_id       = base64_url_decode(substr($token, 7));
            $players_phone  = get_post_meta($order_id, 'players_phone', true);
            if( !in_array ( $user_mobile , (array)$comments_blacklist ) ) {
                if ( in_array ( $user_mobile, (array)$players_phone ) || in_array ( '+98' . $user_mobile, (array)$players_phone ) ) {

                    $comment_text = "کد تایید: $randd \n\n اسکیپ زوم";
                    /*=========================================================*/
                    $sms2player = ez_sendpayamak($user_mobile, $comment_text, '90006491');
                    /*=========================================================*/
                    if ($sms2player != "01")
                        ez_sendpayamak($user_mobile, $comment_text);

                    wp_send_json_success(true);

                } else
                    wp_send_json_error('شماره در لیست رزروی ها نیست! لطفاً شماره خود را که پیامک دعوت به نظرسنجی را دریافت نموده اید، وارد کنید..');

            } else
                wp_send_json_error('متاسفیم! شما قبلا با این شماره برای این اتاق فرار کامنت ثبت کرده اید.');

            exit();

        } else { //  this user tries submit a comment via "send a comment" button (without the specific url)

            $order_ids_obj = ez_cm_get_order_id($f2_roomid, $user_mobile);

            if ( empty( $order_ids_obj ) )
                $order_ids_obj = ez_cm_get_order_id($f2_roomid, '98' . $user_mobile);

            if ( !empty( $order_ids_obj ) )
                foreach ( $order_ids_obj as $order_id_obj ) {

                    $order_id       = $order_id_obj->order_id;
                    $players_phone  = get_post_meta($order_id, 'players_phone', true);

                    if( !in_array ( $user_mobile , (array)$comments_blacklist ) ) {
                        
                        if ( in_array ( $user_mobile, (array)$players_phone ) || in_array ( '+98' . $user_mobile, (array)$players_phone ) ) {

                            $comment_text = "کد تایید: $randd \n\n اسکیپ زوم";
                            /*=========================================================*/
                            $sms2player = ez_sendpayamak($user_mobile, $comment_text, '90006491');
                            /*=========================================================*/
                            if ($sms2player != "01")
                                ez_sendpayamak($user_mobile, $comment_text);

                            wp_send_json_success(true);
                        }

                    } else
                        wp_send_json_error('متاسفیم! شما قبلا با این شماره برای این اتاق فرار کامنت ثبت کرده اید.');
                }

            else
                wp_send_json_error('شماره در لیست رزروی ها نیست! لطفاً شماره خود را که پیامک دعوت به نظرسنجی را دریافت نموده اید، وارد کنید!');
        }
    }

    wp_send_json_success(true);
}
/****************************************************************************************************************************************/
add_action('wp_ajax_zn_f3', 'zn_f3'); // This is for authenticated users
add_action('wp_ajax_nopriv_zn_f3', 'zn_f3'); // This is for unauthenticated users.
function zn_f3() {
    die();
}
/****************************************************************************************************************************************/
add_action('wp_ajax_zn_f4', 'zn_f4'); // This is for authenticated users
add_action('wp_ajax_nopriv_zn_f4', 'zn_f4'); // This is for unauthenticated users.
function zn_f4() {

    if (get_current_user_id() == 3325 || 1) {

        $token      = htmlspecialchars($_POST['cm_token']);
        $f3_roomid  = htmlspecialchars($_POST['f3_roomid']);
        $f3_message = htmlspecialchars($_POST['f3_message']);
        $f3_rate1   = isset($_POST['f3_rate1']) ? (int)$_POST['f3_rate1'] : 0;
        $f3_rate2   = isset($_POST['f3_rate2']) ? (int)$_POST['f3_rate2'] : 0;
        $f3_rate3   = isset($_POST['f3_rate3']) ? (int)$_POST['f3_rate3'] : 0;
        $f3_rate4   = isset($_POST['f3_rate4']) ? (int)$_POST['f3_rate4'] : 0;
        $f3_rate5   = isset($_POST['f3_rate5']) ? (int)$_POST['f3_rate5'] : 0;
        $f3_mobile  = htmlspecialchars($_POST['f3_mobile']);
        $f3_mobile  = substr($f3_mobile, 1, 10);

        $order_id       = base64_url_decode(substr($token, 7));
        $saved_token    = get_post_meta($order_id, 'comment_token', true);

        $rate_average = (( $f3_rate1 + $f3_rate2 + $f3_rate3 + $f3_rate4 + $f3_rate5 ) / 5) / 20;

        $comment_rating = array(
            1098 => $f3_rate1,
            1097 => $f3_rate2,
            1096 => $f3_rate3,
            1095 => $f3_rate4,
            1094 => $f3_rate5,
        );

        $com_meta = array(
            "comment_rating"    => $comment_rating,
            "comment_offer"     => $f3_roomid,
            "rating"            => $rate_average,
        );

        $words = array("آشغال", "اشغال", "کیر", "کیری", "کص", "کس کش", "کص کش", "خایه", "تخم", "مادر", "ننه", "جنده", "حروم",
            "سگ", "ریدم", "قحبه", "گایید", "خواهر", "کون", "کصخل", "کسخل", "کسده", "بیضه", "کثافت", "لجن", "بیشرف", "شرف", "افتضاح",
            "شاش", "چرت و پرت", "بدترین",
        );
        $swear_flag = false;
        foreach($words as $word) {
            if ( substr_count($f3_message, $word) > 0 ) {
                $swear_flag = true;
                break;
            }
        }

        if ( !empty( $token ) ) { // this user found this comment page via the url he received

            if ($token == $saved_token && !empty($token) && !empty($saved_token)) {

                $exp_time = get_post_meta($order_id, 'comment_token_exp', true);
                if ( $exp_time > time() || 1 ) {

                    $com_data = array(
                        'comment_post_ID'   => "$f3_roomid",
                        'comment_author'    => "$f3_mobile",
                        'comment_content'   => "$f3_message",
                        'comment_author_IP' => $_SERVER['REMOTE_ADDR'],
                        'comment_agent'     => $_SERVER['HTTP_USER_AGENT'],
                        'comment_type'      => 'review',
                        'comment_meta'      => $com_meta,
                        'comment_date'      => date('Y-m-d H:i:s'),
                        'comment_date_gmt'  => date('Y-m-d H:i:s'),
                        'comment_approved'  => $swear_flag ? 0 : 1,
                    );

                    $comment_id = wp_insert_comment($com_data);

                    // update room rate
                    $temp = get_post_meta($f3_roomid, 'product_rates', true);
                    $product_rates = !empty($temp) ? $temp : [1098 => 0, 1097 => 0, 1096 => 0, 1095 => 0, 1094 => 0];
                    $product_rates[1098] += $comment_rating[1098];
                    $product_rates[1097] += $comment_rating[1097];
                    $product_rates[1096] += $comment_rating[1096];
                    $product_rates[1095] += $comment_rating[1095];
                    $product_rates[1094] += $comment_rating[1094];
                    update_post_meta($f3_roomid, 'product_rates', $product_rates);

                    // update comments_count
                    $temp2  = get_post_meta($f3_roomid, 'comments_count_new', true);
                    $temp2  = !empty($temp2) ? $temp2 : 0;
                    update_post_meta($f3_roomid, 'comments_count_new', ++$temp2);

                    // black list
                    $temp1 = get_post_meta($f3_roomid, 'comments_blacklist', true);
                    $comments_blacklist = !empty($temp1) ? $temp1 : [];
                    $comments_blacklist[] = $f3_mobile;
                    update_post_meta($f3_roomid, 'comments_blacklist', $comments_blacklist);

                    $success_msg = !$swear_flag ? 'با تشکر، کامنت شما ثبت گردید و هم اکنون قابل مشاهده است.' : 'با تشکر، کامنت شما ثبت گردید و بعد از تایید مدیریت در سایت درج خواهد شد.';

                    wp_send_json_success($success_msg);

                } else
                    wp_send_json_error('پوزش! فرصت شما برای نوشتن نظر به پایان رسیده است!');
            } else
                wp_send_json_error('لینکی که توسط آن به این صفحه آمده اید اشتباه است و نظر شما ثبت نشد!');

        } else { //  this user tries submit a comment via "send a comment" button (without the specific url)

            $com_data = array(
                'comment_post_ID'   => "$f3_roomid",
                'comment_author'    => "$f3_mobile",
                'comment_content'   => "$f3_message",
                'comment_author_IP' => $_SERVER['REMOTE_ADDR'],
                'comment_agent'     => $_SERVER['HTTP_USER_AGENT'],
                'comment_type'      => 'review',
                'comment_meta'      => $com_meta,
                'comment_date'      => date('Y-m-d H:i:s'),
                'comment_date_gmt'  => date('Y-m-d H:i:s'),
                'comment_approved'  => $swear_flag ? 0 : 1,
            );

            $comment_id = wp_insert_comment($com_data);

            // update room rate
            $temp = get_post_meta($f3_roomid, 'product_rates', true);
            $product_rates = !empty($temp) ? $temp : [1098 => 0, 1097 => 0, 1096 => 0, 1095 => 0, 1094 => 0];
            $product_rates[1098] += $comment_rating[1098];
            $product_rates[1097] += $comment_rating[1097];
            $product_rates[1096] += $comment_rating[1096];
            $product_rates[1095] += $comment_rating[1095];
            $product_rates[1094] += $comment_rating[1094];
            update_post_meta($f3_roomid, 'product_rates', $product_rates);

            // update comments_count
            $temp2 = get_post_meta($f3_roomid, 'comments_count_new', true);
            update_post_meta($f3_roomid, 'comments_count_new', ++$temp2);

            // black list
            $temp1 = get_post_meta($f3_roomid, 'comments_blacklist', true);
            $comments_blacklist = !empty($temp1) ? $temp1 : [];
            $comments_blacklist[] = $f3_mobile;
            update_post_meta($f3_roomid, 'comments_blacklist', $comments_blacklist);

            $success_msg = !$swear_flag ? 'با تشکر، کامنت شما ثبت گردید و هم اکنون قابل مشاهده است.' : 'با تشکر، کامنت شما ثبت گردید و بعد از تایید مدیریت در سایت درج خواهد شد.';

            wp_send_json_success($success_msg);
        }
    }

    $f3_roomid  = htmlspecialchars($_POST['f3_roomid']);
    $f3_message = htmlspecialchars($_POST['f3_message']);
    $f3_rate1   = htmlspecialchars($_POST['f3_rate1']);
    $f3_rate2   = htmlspecialchars($_POST['f3_rate2']);
    $f3_rate3   = htmlspecialchars($_POST['f3_rate3']);
    $f3_rate4   = htmlspecialchars($_POST['f3_rate4']);
    $f3_rate5   = htmlspecialchars($_POST['f3_rate5']);
    $f3_mobile  = htmlspecialchars($_POST['f3_mobile']);
    $f3_mobile  = substr($f3_mobile, 1, 10);

    $rate_average = (($f3_rate1 + $f3_rate2 + $f3_rate3 + $f3_rate4 + $f3_rate5) / 5) / 20;

    $comment_rating = array(
        1098 => $f3_rate1,
        1097 => $f3_rate2,
        1096 => $f3_rate3,
        1095 => $f3_rate4,
        1094 => $f3_rate5,
    );

    $com_meta = array(
        "comment_rating"    => $comment_rating,
        "comment_offer"     => "$f3_roomid",
        "rating"            => "$rate_average",
    );
    $agent = $_SERVER['HTTP_USER_AGENT'];

    $com_data = array(
        'comment_post_ID'   => "$f3_roomid",
        'comment_author'    => "$f3_mobile",
        'comment_content'   => "$f3_message",
        'comment_author_IP' => $_SERVER['REMOTE_ADDR'],
        'comment_agent'     => $agent,
        'comment_type'      => 'review',
        'comment_meta'      => $com_meta,
        'comment_date'      => date('Y-m-d H:i:s'),
        'comment_date_gmt'  => date('Y-m-d H:i:s'),
        'comment_approved'  => 0,
    );

    $comment_id = wp_insert_comment($com_data);

    wp_send_json_success($comment_id);
}
/****************************************************************************************************************************************/
