<?php
defined( 'ABSPATH' ) || exit; // Exit if accessed directly.
date_default_timezone_set("Asia/Tehran");

function zr_user_check(){
    $user_ebtal     = get_post_meta( get_the_ID(), 'user_ebtal', true );
    $sans_manager   = get_post_meta( get_the_ID(), 'sans_manager', true );
    $c_user         = get_current_user_id();

    if($c_user == 0)
        return 'mehman';

    elseif( current_user_can('poshtiban') )
        return 'poshtiban';

    elseif ($c_user == $user_ebtal)
        return 'compiler';

    elseif ($c_user == $sans_manager)
        return 'sans_manager';

    elseif( current_user_can('administrator') )
        return 'admin';

    elseif( current_user_can('shop_manager') )
        return 'shop_manager';

    elseif( current_user_can('shopist') )
        return 'shopist';

    elseif( current_user_can('contentist') )
        return 'contentist';

    else
        return 'mehman';
}
/***********************************************************************************************************************/
function zr_dump($var, $return = false){
    if (is_array($var)){
        $out = print_r($var, true);
    } else if (is_object($var)) {
        $out = var_export($var, true);
    } else {
        $out = $var;
    }

    if ($return){
        return "\n<pre style='direction: ltr!important;text-align: left!important;'>$out</pre>\n";
    } else {
        echo "\n<pre style='direction: ltr!important;text-align: left!important;'>$out</pre>\n";
    }
}
/***********************************************************************************************************************/
function zr_hoursToMinutes($hours){
    $minutes = 0;
    if (strpos($hours, ':') !== false)
    {
        // Split hours and minutes.
        list($hours, $minutes) = explode(':', $hours);
    }
    return $hours * 60 + $minutes;
}
/***********************************************************************************************************************/
// Transform minutes like "105" into hours like "1:45".
function zr_minutesToHours($minutes) {
    $hours = (int)($minutes / 60);
    $minutes -= $hours * 60;
    return sprintf("%d:%02.0f", $hours, $minutes);
}
/***********************************************************************************************************************/
function zr_is_timestamp($timestamp) {
    if (strtotime(date('d-m-Y H:i:s', $timestamp)) === (int)$timestamp)
        return $timestamp;

    return false;
}
/***********************************************************************************************************************/
function is_timestamp($timestamp) {
    if (strtotime(date('d-m-Y H:i:s', $timestamp)) === (int)$timestamp)
        return $timestamp;

    return false;
}
/***********************************************************************************************************************/
function zr_get_todaytimestamp() {
    return strtotime(date('Y-m-d ') . ' ' . 'Asia/Tehran');
}
/***********************************************************************************************************************/
function zr_get_todayName(){
    $current_date= date('l ');

    $today_Name= strtotime($current_date. ' '. 'Asia/Tehran');
    $today_Name=jdate('l',$today_Name);
    return $today_Name;
}
/***********************************************************************************************************************/
function zr_get_CurrentTime(){
    $current_Time= date('H:i');
    return $current_Time;
}
/***********************************************************************************************************************/
function zr_get_slider_days(){
    include_once( ZR_PLUGIN . 'zr-view-days.php' );
}
/***********************************************************************************************************************/
function zr_get_price($showmode = '', $service_id = '', $cDay = '', $firstTimeTs = '', $Get_date = ''){

    if ( have_rows('off_days_rep',"$service_id") ) :

        // Loop through rows.
        $active_time_from   = '';
        $active_time_to     = '';
        $off_day            = '';
        $out                = '';

        while( have_rows('off_days_rep',"$service_id") ) : the_row();

            $off_day            = get_sub_field('off_day',"$service_id");
            $active_time_from   = get_sub_field('active_time_from',"$service_id");
            $active_time_to     = get_sub_field('active_time_to',"$service_id");

            // Load sub field value.
            if ( $off_day == $cDay )
                $out = strtotime($Get_date . ' ' . $active_time_from) . ' , ' . strtotime($Get_date . ' ' . $active_time_to);

        endwhile;

        return  $out;
    endif;
}
/***********************************************************************************************************************/
add_action('init', 'register_my_session');
function register_my_session() {
    if( !session_id() )
        @session_start();
}
/***********************************************************************************************************************/
add_action( 'woocommerce_thankyou', 'zoom_book_thankyou' );
function zoom_book_thankyou() {
    global $wpdb, $wp;

    $get_id = $_SERVER['REQUEST_URI'];
    $get_id = explode("/", $get_id);
    $get_id = $get_id[3];
    $get_id = htmlspecialchars($get_id);
    $order  = wc_get_order( $get_id );

    $order_method = get_post_meta($get_id, 'order_method', true);

    if ( $order_method == 'api' ) {

        foreach ( $order->get_items() as $item )
            $product_id = $item['product_id'];

        $customer_id   = get_post_meta($get_id, '_customer_user', true);
        $book          = get_post_meta($get_id, 'sans_time', true);
        $c_time        = time();

    } else {
        $customer_id   = $_SESSION['user_id'];
        $product_id    = $_SESSION['product_id'];
        $book          = $_SESSION['book'];
        $c_time        = $_SESSION['c_time'];
    }

    if ( get_post_meta($get_id, 'seen_tnx_page', true) && $order_method != 'api' ) { // prevent refresh the thankyou page each time

        if ( get_current_user_id() != 3325 ) {
            wp_redirect('https://escapezoom.ir/thankyouco');
            exit;
        }

    } else add_post_meta($get_id, 'seen_tnx_page', time());

//    if( $book == "" || $book == 0 )
//        ez_sendpayamak("9353316152", "خطای 11 برای سفارش $get_id");

    $total_amount = (int)$order->get_total();

    if ( !$total_amount ) {

        foreach ( $order->get_items() as $item )
            $room_id = $item['product_id'];

        echo '<style>section.woocommerce-customer-details { display: none; } #content > div > div > div > section.woocommerce-checkout-alert > div.woocommerce-checkout-alert-content > p ,div#tpbr_topbar{ display: none!important; }.coupon-frame,h4.tac { display: none!important; }</style>';
        echo '<h2 class="tac" style=" font-size: 1.3em; " id="err_reserve">خطا: سانس شما رزرو نشد لطفا مجددا تلاش بفرمایید <br><a href="' . get_permalink($room_id) . '">بازگشت به صفحه بازی ' . get_the_title($room_id) . '</a></h2>';

        exit;
    }

    if ( 0 ) {
        echo '<style>/*! tailwindcss v3.4.1 | MIT License | https://tailwindcss.com*/*,:after,:before{box-sizing:border-box;border:0 solid #e5e7eb}:after,:before{--tw-content:""}:host,html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;-o-tab-size:4;tab-size:4;font-family:ui-sans-serif,system-ui,sans-serif,Apple Color Emoji,Segoe UI Emoji,Segoe UI Symbol,Noto Color Emoji;font-feature-settings:normal;font-variation-settings:normal;-webkit-tap-highlight-color:transparent}body{margin:0;line-height:inherit}hr{height:0;color:inherit;border-top-width:1px}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,pre,samp{font-family:ui-monospace,SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-feature-settings:normal;font-variation-settings:normal;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:initial}sub{bottom:-.25em}sup{top:-.5em}table{text-indent:0;border-color:inherit;border-collapse:collapse}button,input,optgroup,select,textarea{font-family:inherit;font-feature-settings:inherit;font-variation-settings:inherit;font-size:100%;font-weight:inherit;line-height:inherit;color:inherit;margin:0;padding:0}button,select{text-transform:none}[type=button],[type=reset],[type=submit],button{-webkit-appearance:button;background-color:initial;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:initial}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dd,dl,figure,h1,h2,h3,h4,h5,h6,hr,p,pre{margin:0}fieldset{margin:0}fieldset,legend{padding:0}menu,ol,ul{list-style:none;margin:0;padding:0}dialog{padding:0}textarea{resize:vertical}input::-moz-placeholder,textarea::-moz-placeholder{opacity:1;color:#9ca3af}input::placeholder,textarea::placeholder{opacity:1;color:#9ca3af}[role=button],button{cursor:pointer}:disabled{cursor:default}audio,canvas,embed,iframe,img,object,svg,video{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}[hidden]{display:none}*,::backdrop,:after,:before{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:#3b82f680;--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: }.container{width:100%;margin-right:auto;margin-left:auto;padding-right:1rem;padding-left:1rem}@media (min-width:480px){.container{max-width:480px}}@media (min-width:640px){.container{max-width:640px}}@media (min-width:768px){.container{max-width:768px}}@media (min-width:1024px){.container{max-width:1024px;padding-right:.625rem;padding-left:.625rem}}@media (min-width:1280px){.container{max-width:1280px}}@media (min-width:1400px){.container{max-width:1400px}}.pointer-events-none{pointer-events:none}.visible{visibility:visible}.static{position:static}.fixed{position:fixed}.absolute{position:absolute}.relative{position:relative}.sticky{position:sticky}.-bottom-6{bottom:-1.5rem}.right-2{right:.5rem}.top-0{top:0}.top-1\/2{top:50%}.z-40{z-index:40}.my-10{margin-top:2.5rem;margin-bottom:2.5rem}.my-6{margin-top:1.5rem;margin-bottom:1.5rem}.mx-auto{margin-left:auto;margin-right:auto}.mt-1{margin-top:.25rem}.mt-4{margin-top:1rem}.mt-5{margin-top:1.25rem}.mt-1\.5{margin-top:.375rem}.mt-2{margin-top:.5rem}.block{display:block}.inline-block{display:inline-block}.inline{display:inline}.table{display:table}.grid{display:grid}.contents{display:contents}.hidden{display:none}.h-12{height:3rem}.h-36{height:9rem}.h-full{height:100%}.w-full{width:100%}.w-fit{width:-moz-fit-content;width:fit-content}.-translate-y-1\/2{--tw-translate-y:-50%;transform:translate(var(--tw-translate-x),var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y))}.resize{resize:both}.grid-cols-1{grid-template-columns:repeat(1,minmax(0,1fr))}.gap-4{gap:1rem}.space-y-2>:not([hidden])~:not([hidden]){--tw-space-y-reverse:0;margin-top:calc(.5rem*(1 - var(--tw-space-y-reverse)));margin-bottom:calc(.5rem*var(--tw-space-y-reverse))}.space-y-4>:not([hidden])~:not([hidden]){--tw-space-y-reverse:0;margin-top:calc(1rem*(1 - var(--tw-space-y-reverse)));margin-bottom:calc(1rem*var(--tw-space-y-reverse))}.rounded-md{border-radius:.375rem}.rounded-xl{border-radius:.75rem}.rounded-lg{border-radius:.5rem}.border{border-width:1px}.border-border-1{--tw-border-opacity:1;border-color:rgb(218 218 218/var(--tw-border-opacity))}.border-red-500{--tw-border-opacity:1;border-color:rgb(239 68 68/var(--tw-border-opacity))}.border-\[\#FD7013\]{--tw-border-opacity:1;border-color:rgb(253 112 19/var(--tw-border-opacity))}.bg-\[\#F6F6F6\]{--tw-bg-opacity:1;background-color:rgb(246 246 246/var(--tw-bg-opacity))}.bg-secondary-2{--tw-bg-opacity:1;background-color:rgb(11 44 59/var(--tw-bg-opacity))}.bg-transparent{background-color:initial}.bg-white{--tw-bg-opacity:1;background-color:rgb(255 255 255/var(--tw-bg-opacity))}.bg-\[\#00B350\]{--tw-bg-opacity:1;background-color:rgb(0 179 80/var(--tw-bg-opacity))}.bg-\[\#00A048\]{--tw-bg-opacity:1;background-color:rgb(0 160 72/var(--tw-bg-opacity))}.bg-\[\#FD7013\]{--tw-bg-opacity:1;background-color:rgb(253 112 19/var(--tw-bg-opacity))}.p-2{padding:.5rem}.p-2\.5{padding:.625rem}.px-16{padding-left:4rem;padding-right:4rem}.px-2{padding-left:.5rem;padding-right:.5rem}.px-8{padding-left:2rem;padding-right:2rem}.py-14{padding-top:3.5rem;padding-bottom:3.5rem}.py-2{padding-top:.5rem;padding-bottom:.5rem}.py-2\.5{padding-top:.625rem;padding-bottom:.625rem}.px-3{padding-left:.75rem;padding-right:.75rem}.px-3\.5{padding-left:.875rem;padding-right:.875rem}.text-center{text-align:center}.text-3xl{font-size:1.875rem;line-height:1.7}.text-lg{font-size:1.125rem;line-height:1.7}.text-xs{font-size:.75rem;line-height:1.7}.text-2xl{font-size:1.5rem;line-height:1.7}.font-black{font-weight:900}.font-bold{font-weight:700}.font-medium{font-weight:500}.text-\[\#0B2C3B\]{--tw-text-opacity:1;color:rgb(11 44 59/var(--tw-text-opacity))}.text-\[\#AAAAAA\]{--tw-text-opacity:1;color:rgb(170 170 170/var(--tw-text-opacity))}.text-black\/50{color:#00000080}.text-red-500{--tw-text-opacity:1;color:rgb(239 68 68/var(--tw-text-opacity))}.text-red-600{--tw-text-opacity:1;color:rgb(220 38 38/var(--tw-text-opacity))}.text-white{--tw-text-opacity:1;color:rgb(255 255 255/var(--tw-text-opacity))}.text-\[\#FD7013\]{--tw-text-opacity:1;color:rgb(253 112 19/var(--tw-text-opacity))}.blur{--tw-blur:blur(8px)}.blur,.filter{filter:var(--tw-blur) var(--tw-brightness) var(--tw-contrast) var(--tw-grayscale) var(--tw-hue-rotate) var(--tw-invert) var(--tw-saturate) var(--tw-sepia) var(--tw-drop-shadow)}.transition{transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,-webkit-backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter;transition-property:color,background-color,border-color,text-decoration-color,fill,stroke,opacity,box-shadow,transform,filter,backdrop-filter,-webkit-backdrop-filter;transition-timing-function:cubic-bezier(.4,0,.2,1);transition-duration:.15s}input.username-input{height:2.5rem;width:100%;border-radius:.5rem;border-width:1px;--tw-border-opacity:1;border-color:rgb(218 218 218/var(--tw-border-opacity));--tw-bg-opacity:1;background-color:rgb(246 246 246/var(--tw-bg-opacity));padding:.25rem .75rem}input.username-input:focus{outline-width:1px;outline-color:#158eff4d}input.otp-code-input{height:2.5rem;width:2.5rem;border-radius:.5rem;border-width:1px;--tw-border-opacity:1;border-color:rgb(218 218 218/var(--tw-border-opacity));--tw-bg-opacity:1;background-color:rgb(246 246 246/var(--tw-bg-opacity));text-align:center}input.otp-code-input:focus{outline-width:1px;outline-color:#158eff4d}input.otp-code-input::-webkit-inner-spin-button,input.otp-code-input::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}input.otp-code-input{-moz-appearance:textfield}input.username-input.error{--tw-border-opacity:1;border-color:rgb(255 109 1/var(--tw-border-opacity))}input.username-input.error:focus{outline-width:0}input.username-input.success{--tw-border-opacity:1;border-color:rgb(34 197 94/var(--tw-border-opacity))}input.username-input.success:focus{outline-width:0}p.login-form-error{margin-top:.25rem;font-size:.75rem;line-height:1.7;--tw-text-opacity:1;color:rgb(255 109 1/var(--tw-text-opacity))}a.panel-list-menu>span.icon-box{position:relative;display:block;height:1.125rem;width:1.125rem}a.panel-list-menu[data-badge]>span.icon-box:after{position:absolute;top:-3px;left:-2px;height:.375rem;width:.375rem;border-radius:9999px;--tw-bg-opacity:1;background-color:rgb(255 51 0/var(--tw-bg-opacity));--tw-content:"";content:var(--tw-content)}input[type=number]::-webkit-inner-spin-button,input[type=number]::-webkit-outer-spin-button{-webkit-appearance:none;margin:0}.wallet-table table{width:100%;border-collapse:collapse}.wallet-table table td,.wallet-table table th{padding:18px 15px;border-bottom:1px solid #ddd;text-align:right;font-size:16px}.wallet-table table th{color:#888;font-size:14px;font-weight:600}.wallet-table table td{font-weight:600;color:#020202}.wallet-table table td[data-status=success]{color:#039c47}.wallet-table table td[data-status=failed]{color:#f30}.wallet-table table tbody tr:last-child td{border-bottom:unset}@media (max-width:768px){.wallet-table table thead{display:none}.wallet-table table,.wallet-table table tbody,.wallet-table table td,.wallet-table table tr{display:block;width:100%}.wallet-table table tr{background-color:#fff;border-radius:12px;border:1px solid #dadada}.wallet-table table tbody tr{display:flex;flex-wrap:wrap;margin-bottom:15px}.wallet-table table tbody tr td{width:50%;position:relative;font-size:small}.wallet-table table tbody tr td:nth-child(2){order:1;width:100%;border-bottom:1px solid #ddd;margin-bottom:20px}.wallet-table table tbody tr td:first-child{order:2}.wallet-table table tbody tr td:nth-child(4){order:3}.wallet-table table tbody tr td:nth-child(3){order:4}.wallet-table table tbody tr td:nth-child(5){order:5}.wallet-table table td:nth-child(2){padding-right:40%;text-align:right}.wallet-table table td:nth-child(2):before{top:unset}.wallet-table table td:before{content:attr(data-label);position:absolute;right:0;width:100%;padding-right:15px;font-size:small;font-weight:500;text-align:right;color:#888;top:-10px}.wallet-table table td,.wallet-table table th{border-bottom:unset}}p#offerCode-message{position:absolute;font-size:.75rem;line-height:1.7;font-weight:600}p[data-offerCode=error]{--tw-text-opacity:1;color:rgb(239 68 68/var(--tw-text-opacity))}p[data-offerCode=success]{--tw-text-opacity:1;color:rgb(0 179 80/var(--tw-text-opacity))}input#order-off-code[readonly]{color:#888}button#order-off-code-btn[data-btn-status=submit-code]{--tw-bg-opacity:1;background-color:rgb(0 179 80/var(--tw-bg-opacity))}button#order-off-code-btn[data-btn-status=edit-code]{--tw-bg-opacity:1;background-color:rgb(253 112 19/var(--tw-bg-opacity))}.hover\:bg-\[\#00A048\]:hover{--tw-bg-opacity:1;background-color:rgb(0 160 72/var(--tw-bg-opacity))}.hover\:bg-\[\#FD7013\]:hover{--tw-bg-opacity:1;background-color:rgb(253 112 19/var(--tw-bg-opacity))}.hover\:text-white:hover{--tw-text-opacity:1;color:rgb(255 255 255/var(--tw-text-opacity))}.focus\:outline-0:focus{outline-width:0}.peer:-moz-placeholder-shown~.peer-placeholder-shown\:block{display:block}.peer:placeholder-shown~.peer-placeholder-shown\:block{display:block}.peer:-moz-placeholder-shown~.peer-placeholder-shown\:\!hidden{display:none!important}.peer:placeholder-shown~.peer-placeholder-shown\:\!hidden{display:none!important}.peer:invalid~.peer-invalid\:block{display:block}.has-\[input\:invalid\]\:border-\[\#FD7013\]:has(input:invalid){--tw-border-opacity:1;border-color:rgb(253 112 19/var(--tw-border-opacity))}.has-\[input\:-moz-placeholder-shown\]\:\!border-border-1:has(input:-moz-placeholder-shown){--tw-border-opacity:1!important;border-color:rgb(218 218 218/var(--tw-border-opacity))!important}.has-\[input\:placeholder-shown\]\:\!border-border-1:has(input:placeholder-shown){--tw-border-opacity:1!important;border-color:rgb(218 218 218/var(--tw-border-opacity))!important}.has-\[input\:valid\]\:border-green-500:has(input:valid){--tw-border-opacity:1;border-color:rgb(34 197 94/var(--tw-border-opacity))}.child\:space-x-2>*>:not([hidden])~:not([hidden]){--tw-space-x-reverse:0;margin-right:calc(.5rem*var(--tw-space-x-reverse));margin-left:calc(.5rem*(1 - var(--tw-space-x-reverse)))}.child\:space-x-reverse>*>:not([hidden])~:not([hidden]){--tw-space-x-reverse:1}@media (min-width:1024px){.lg\:hidden{display:none}.lg\:grid-cols-2{grid-template-columns:repeat(2,minmax(0,1fr))}} section.woocommerce-customer-details { display: none; } #content > div > div > div > section.woocommerce-checkout-alert > div.woocommerce-checkout-alert-content > p ,div#tpbr_topbar{ display: none!important; }.coupon-frame,h4.tac { display: none!important; }</style>'; ?>

        <section class="bg-white rounded-xl py-14 px-8 text-center">
            <div class="w-fit mx-auto"><svg xmlns="http://www.w3.org/2000/svg" width="88" height="88" viewBox="0 0 88 88" fill="none"><path d="M42.5259 71.8056L42.5278 71.8036L80.2254 32.3752C80.2611 32.3378 80.2962 32.2998 80.3307 32.2612C82.4337 29.9039 83.5503 26.8234 83.4983 23.6749C83.4463 20.5262 82.2283 17.484 80.0445 15.1998L80.0443 15.1997C77.8544 12.9093 74.8574 11.5595 71.6723 11.5019C68.4867 11.4444 65.4426 12.6856 63.1739 14.8999C63.1367 14.9361 63.1002 14.973 63.0644 15.0105L33.9473 45.4645L24.9356 36.039C24.8998 36.0015 24.8633 35.9646 24.8261 35.9284C22.5574 33.7141 19.5133 32.4729 16.3277 32.5304C13.1426 32.588 10.1456 33.9378 7.95565 36.2282L7.95549 36.2283C5.77169 38.5125 4.55374 41.5547 4.50174 44.7034C4.44974 47.8519 5.56627 50.9324 7.66934 53.2897C7.70378 53.3283 7.73888 53.3663 7.77462 53.4037L25.3668 71.8036L25.3688 71.8056C27.6091 74.1459 30.6901 75.5 33.9473 75.5C37.2046 75.5 40.2856 74.1459 42.5259 71.8056Z" fill="url(#paint0_linear_951_1419)" stroke="url(#paint1_linear_951_1419)" stroke-width="9" stroke-linecap="round" stroke-linejoin="round"/><defs><linearGradient id="paint0_linear_951_1419" x1="117.889" y1="6.83333" x2="36.3764" y2="64.763" gradientUnits="userSpaceOnUse"><stop stop-color="#00B350"/><stop offset="1" stop-color="#94FDC3"/></linearGradient><linearGradient id="paint1_linear_951_1419" x1="44" y1="16" x2="44" y2="71" gradientUnits="userSpaceOnUse"><stop stop-color="#00B350"/><stop offset="1" stop-color="#6ADA9C"/></linearGradient></defs></svg></div>
            <h2 class="font-black text-2xl text-[#0B2C3B] mt-4">سانس شما با موفقیت رزرو شد</h2>
            <p class="font-medium text-lg text-[#0B2C3B] mt-2">اوقات خوشی رو برای شما آرزومندیم</p>





    <?php
    } else {
        echo '<style>section.woocommerce-customer-details { display: none; } #content > div > div > div > section.woocommerce-checkout-alert > div.woocommerce-checkout-alert-content > p ,div#tpbr_topbar{ display: none!important; }.coupon-frame,h4.tac { display: none!important; }</style>';
        echo '<h2 class="tac" style=" font-size: 1.3em; "> سانس شما رزرو شد. اوقات خوشی رو برای شما آرزومندیم  </h2>';
    }

    $data = [
        "single_value"  => true,
        "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `room_id` = {$product_id} AND `booking_time` LIKE {$book}",
    ];
    $row_check_tadakhol = (array)json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $data) ));

    if ( $row_check_tadakhol ) {
        session_destroy();

        $order->update_status( 'conflict' );

//        $msg = "تداخل تایم $book بازی $product_id سفارش $get_id" . "\n اسکیپ زوم";
//        $pn  = "9013181881"; // mohandes
//
//        ez_sendpayamak($pn, $msg);
//        ez_sendpayamak("9353316152", $msg);
        header("Location: https://escapezoom.ir/oops-wrong/?order_id=" . base64_url_encode(base64_url_encode($get_id)));
        exit;
    }

    $zb_date    = jdate('l j F', $book);
    $zb___time  = jdate('H:i', $book);
    $zb__name   = get_the_title($product_id);

    $pish_per_person    = get_post_meta( $product_id, 'pish_pardakht_per_person', true );
    $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;

    $day_type   = get_day_type($book);
    $sanses     = get_sanses($product_id);
    foreach ( $sanses[$day_type] as $sans )
        if ( date("H:i", $book) == $sans['time'] )
            $asli = $sans['off_price'] ? : $sans['price'];

    if ( get_post_meta($product_id, 'special_discount_enable', true) )
        if ( get_post_meta($product_id, 'special_discount_date', true) > time() )
            $asli = (int)$asli * ( 1 - get_post_meta($product_id, 'special_discount_percentage', true) / 100);

    $zb_pish = $pish_per_person * (int)$asli;

    $phone = ltrim($order->get_billing_phone(), '0');

    $zb_user_ebtal  = get_post_meta($product_id, 'user_ebtal', TRUE);
    $zb_manager     = get_post_meta($product_id, 'sans_manager', TRUE);

    $phone_no       =  $phone;
    $persian        = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $english        = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    $phone_no       = str_replace($persian, $english, $phone_no);
    $phone_no       = preg_replace('/^\+?98|\|98|\D/', '', ($phone_no));
    $phone_no       = ltrim($phone_no, '0');
    $phone_number   = $phone_no;

    if ( $order_method == 'api' ) {
        $zb_date    = jdate('l j F',$book);
        $zb___time  = jdate('H:i',$book);

    } else {
        if ( $_SESSION['book'] ) {
            $book       = htmlspecialchars($_SESSION['book']);
            $zb_date    = jdate('l j F',$book);
            $zb___time  = jdate('H:i',$book);
        }
    }

    $token          = get_post_meta($get_id, 'comment_token', true);
    $url            = "escapezoom.ir/cm=$token";
    $players_phone  = get_post_meta($get_id, 'players_phone', true);

    foreach ( $order->get_items() as $item ) {
        $room_name  = $item->get_name();
        $room_id    = $item['product_id'];
    }

    $product_type = ez_get_product_meta($room_id)->product_type;

    date_default_timezone_set("Asia/Tehran");
    $sms_c_d                = strtotime("+90 minutes", $book);
    $sms_c_myDate           = date("Y-m-d", $sms_c_d);
    $sms_c_my_time          = date('H:i:s', $sms_c_d);
    $sms_c_my_date_and_time = $sms_c_myDate . "T" . $sms_c_my_time;

    ini_set("soap.wsdl_cache_enabled", "0");
//    $sms_client = new SoapClient('http://api.payamak-panel.com/post/schedule.asmx?wsdl', array('encoding'=>'UTF-8'));

    foreach($players_phone as $player_phone) { // send sms to players

        $parameters['username']         = "xescape";
        $parameters['password']         = "2kkh7Gm36%#X91h";
        $parameters['to']               = is_array($player_phone) ? ltrim( $player_phone['phone'], '0' ) : ltrim( $player_phone, '0' );
        $parameters['from']             = "90006491";
        $parameters['text']             = "کاربر گرامی، $product_type $room_name چطور بود؟ اینجا نظرتو بگو: \n$url\n اسکیپ‌زوم؛ مرجع $product_type";
        $parameters['isflash']          = false;
        $parameters['scheduleDateTime'] = "$sms_c_my_date_and_time";
        $parameters['period']           = "Once";

//        if( $room_id > 1 )
//            $sms_client->AddSchedule($parameters)->AddScheduleResult;

        ez_cm_add_phone( $room_id, $get_id, $player_phone );
    }

    if ($room_id > 0) {

        $player_name    = $order->get_billing_first_name() . " " . $order->get_billing_last_name();
        $player_phone   = $order->get_billing_phone();
        $total_amount   = $order->get_total();

        foreach ($order->get_items() as $item)
            $item_quantity = $item->get_quantity();

        $query = "INSERT INTO `wp_zb_booking_history` (`booking_id`, `customer_id`, `wc_order_id`, `status`, `room_id`, `booking_time`, `booked_time`, `name`, `phone`, `quantity`) 
                    VALUES (NULL, {$customer_id}, {$get_id}, 1, {$product_id}, {$book}, {$c_time}, '{$player_name}', {$player_phone}, {$item_quantity});";
        $data = [
            'query'         => $query,
            'single_value'  => false
        ];
        $res = ez_reservation(array('type' => 'query_execution', 'data' => $data));

//        add_post_meta($get_id, 'query_response', [$query, $res]);

//        $query = "INSERT INTO `wp_zb_booking_history_today` (`booking_id`, `customer_id`, `wc_order_id`, `status`, `room_id`, `booking_time`, `booked_time`, `name`, `phone`, `quantity`)
//                    VALUES (NULL, {$customer_id}, {$get_id}, 1, {$product_id}, {$book}, {$c_time}, '{$player_name}', {$player_phone}, {$item_quantity});";
//        $data = [
//            'query'         => $query,
//            'single_value'  => false
//        ];
//        ez_reservation(array('type' => 'query_execution', 'data' => $data));

        /*=========================================================*/
        // SMS 1 - FARA PAYAMAK : Reserve Done Message (PLAYER)

        $zb_user_ebtal  = get_userdata($zb_user_ebtal)->user_login;
        $zb_manager     = get_userdata($zb_manager)->user_login;

        add_post_meta($get_id, 'code_otagh', $product_id);

        $user_info__e   = get_field('user_ebtal', $product_id);
        $room_phone     = get_field('room_phone', $product_id);

        if(get_user_meta( $user_info__e, 'digits_phone_no' , true ))
            $zb_user_ebtal = get_user_meta( $user_info__e, 'digits_phone_no' , true );

        $zb_fname   = $order->get_billing_first_name();
        $zb_lname   = $order->get_billing_last_name();
        $fullname   = $zb_fname ." ". $zb_lname;
        $zb_qty     = $item_quantity;
        $room_name  = get_the_title($product_id);

        $wpdb->insert( 'wp_zb_orderinfo', array( 'room_name' =>"$room_name", 'product_id' => "$product_id", 'qty_order' => "$zb_qty", 'date_order' => "$book", ), array('%s', '%s', '%s', '%s') );

        $zb_date_and_time   = $zb_date . " " . $zb___time;
//        $sms2player__text   = "$zb_fname گرامی رزرو سانس $zb_date_and_time از $product_type $zb__name با موفقیت انجام شد.\n\n شماره تماس مجموعه:  $room_phone\n شماره پیگیری: $get_id";

        if ( get_post_meta($product_id, 'user_ebtal', TRUE) == 3346 || 1 || 1 ) {
            $get_id_persian = englishToPersian($get_id);
            $sms2player__text = "سلام $zb_fname\، رزرو \"$zb__name\" برای $zb_date\، ساعت $zb___time\، انجام شد.   
            
تماس: $room_phone  
شماره پیگیری: $get_id_persian  

اسکیپ‌زوم؛ مرجع $product_type ایران";

            $sms2player__text =  nl2br($sms2player__text);
        } else {
            $sms2player__text   = "$zb_fname گرامی رزرو سانس $zb_date_and_time از $product_type $zb__name با موفقیت انجام شد.\n\n شماره تماس مجموعه:  $room_phone\n شماره پیگیری: $get_id";
        }

        if ( $total_amount )
            add_to_sms_queue ($phone_number, $sms2player__text, $get_id, 'user');

        /*=========================================================*/
        // SMS 1 - FARA PAYAMAK : Reserve Done Message (OWNER)

//        $zb_pish        = substr($zb_pish, 0, -3);
//        $phone_number_0 = 0 . $phone_number;
//        $sms2maj__text  = "$zb__name برای $zb_date_and_time به تعداد $zb_qty نفر به نام $fullname $phone_number_0 با $zb_pish هزار تومان پیش پرداخت رزرو شد.";


        if ( get_post_meta($product_id, 'user_ebtal', TRUE) == 3346 || 1 ) {

            $zb_qty_persian = englishToPersian($zb_qty);
            $zb_pish        = englishToPersian(substr($zb_pish, 0, -3));
            $phone_number_0 = 0 . $phone_number;

            $sms2maj__text = "$zb__name $zb_date\، ساعت $zb___time\، به تعداد $zb_qty_persian نفر، به نام $fullname رزرو شد.
            
تماس: $phone_number_0  
پیش‌پرداخت: $zb_pish هزارتومان

اسکیپ‌زوم؛ مرجع $product_type ایران";

            $sms2maj__text =  nl2br($sms2maj__text);
        } else {
            $zb_pish        = substr($zb_pish, 0, -3);
            $phone_number_0 = 0 . $phone_number;
            $sms2maj__text  = "$zb__name برای $zb_date_and_time به تعداد $zb_qty نفر به نام $fullname $phone_number_0 با $zb_pish هزار تومان پیش پرداخت رزرو شد.";
        }

        if ( $total_amount )
            add_to_sms_queue ($zb_user_ebtal, $sms2maj__text, $get_id, 'owner');

        /*=========================================================*/
        // SMS 1 - FARA PAYAMAK : Reserve Done Message (MANAGER)

        if ( $total_amount && $zb_manager )
            add_to_sms_queue ($zb_manager, $sms2maj__text, $get_id, 'manager');

        /*=========================================================*/
        // SMS 1 - FARA PAYAMAK : Reserve Done Message (OWNER2)

        $payamak_2 = get_field('payamak_2', $product_id);

        if($payamak_2) {
            $sms2maj2__text = "$zb__name برای $zb_date_and_time به تعداد $zb_qty نفر به نام $fullname $phone_number_0 با $zb_pish هزار تومان پیش پرداخت رزرو شد";

            if ( $total_amount )
                add_to_sms_queue ($payamak_2, $sms2maj2__text, $get_id, 'owner2');

        } //end $payamak_2

        /*=========================================================*/
        // TELEGRAM : Reserve Done Message (OWNER)

        //start  telegram
        $owner_id           = get_post_meta($product_id, 'user_ebtal', true);
        $chat_id            = get_user_meta($owner_id, 'chat_id', true);
        $sans_manager_id    = get_post_meta($product_id, 'sans_manager', true);
        $manager_chat_id    = get_user_meta($sans_manager_id, 'chat_id', true);

        if ( $chat_id ) {
            $txt_msg_maj    = "$zb__name برای $zb_date_and_time به تعداد $zb_qty نفر به نام $fullname $phone_number_0 با $zb_pish هزار تومان پیش پرداخت رزرو شد";
            $txt_msg_maj    = str_replace(" ","%20","$txt_msg_maj");
            $txt_msg_maj    = urlencode($txt_msg_maj);

            $hash = base64_encode($chat_id);
            if ( $total_amount ) {
                $ch = curl_init("https://impec.ir/?chat_id=$hash&message=$txt_msg_maj");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_exec($ch);
                curl_close($ch);
            }

            $hash = base64_encode($manager_chat_id);
            if ( $total_amount ) {
                $ch = curl_init("https://impec.ir/?chat_id=$hash&message=$txt_msg_maj");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_exec($ch);
                curl_close($ch);
            }
        }
    } //end if product_id
    /*****************************************************/

    unset($_SESSION['product_id']);

    $data = [
        "single_value"  => true,
        "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = {$get_id} ORDER BY `booking_id` DESC",
    ];
    $row2 = (array)json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $data) ));

    if ( 0 ) { ?>

            <div class="my-6 space-y-4 font-medium text-black/50 child:space-x-2 child:space-x-reverse">
                <div><span>شماره رزرو:</span><span><?php echo $get_id;?></span></div>
                <div><?php echo jdate('l j F', $row2['booking_time']); ?></div>
                <div><span>ساعت</span><span><?php echo jdate('H:i', $row2['booking_time']);?></span></div>
                <div>اتاق فرار <?php echo get_the_title($row2['room_id']);?></div>
            </div>
            <a href="#" class="bg-[#00B350] hover:bg-[#00A048] rounded-lg text-white font-bold py-2.5 px-16 transition block w-fit mx-auto">مشاهده بلیط</a>
            <a href="#" class="hover:bg-[#FD7013] hover:text-white border border-[#FD7013] rounded-lg text-[#FD7013] font-bold py-2.5 px-3.5 transition block w-fit mx-auto mt-4">اشتراک گزاری با هم تیمی‌ها</a>
        </section>

    <?php
    } else { ?>

        <p style=" display: block; text-align: center; margin: 0 auto; border-top: 1px #ddd dashed; width: 100%; padding-top: 10px; margin-top: 10px;    font-size: .9em; ">شماره رزرو: <?php echo $get_id;?>
            <br>
            روز <?php echo jdate('l j F', $row2['booking_time']); ?> ساعت <?php echo jdate('H:i', $row2['booking_time']);?>
            <br>  اتاق فرار
            <?php echo get_the_title($row2['room_id']);?>
            <br> <?php $room_phone= get_post_meta( $row2['room_id'], 'room_phone', true );?>
            <a style="padding: 0 10px; background: #fb7d2d; color: #fff; display: inline-block; border-radius: 5px; margin: 9px 0;" target='_blank' href="<?php echo 'tel:+98' . $room_phone;?>">
                تماس با پشتیبان
                <span style=" display: inline-block; width: 100%; font-size: 1.5em; "><?php echo $room_phone;?></span>
            </a>

            <?php $room_address= get_post_meta( $row2['room_id'], 'room_address', true );?> <br>

            <?php if ($room_address): ?>
                <span style="font-size: large; margin-top: 7px; display: block;"> <?php echo $room_address;?></span>
            <?php
            endif; ?>

            <br> <br>

            <?php
            $actual_link = get_the_permalink($row2['room_id'])."?view=reserved#ezcontent"; ?>

            <a id="wa-share" href="whatsapp://send?text=سلام از سایت اسکیپ زوم این رو رزرو کردم سر ساعت باید اونجا باشیم <?php echo $actual_link;?>" rel="nofollow" style="
            padding: 0 7px 0 0;
            color: #fff;
            border-top-right-radius: 7px;
            border-bottom-right-radius: 7px;
            border-top-left-radius: 12px;
        "><img alt="حرکت به سمت " src="https://escapezoom.ir/wp-content/uploads/2021/11/wa-tr.png" style="
            border-radius: 5px;
            margin-right: 0px;
            margin-top: 3px;
            border: 1px solid #00cb4b;
        "> </a>
        </p>


    <?php
    }


    ?>





<?php
}
/***********************************************************************************************************************/
add_action( 'init', 'bz_add_my_bookonline_endpoint' );
function bz_add_my_bookonline_endpoint() {
    add_rewrite_endpoint( 'my-bookonline', EP_ROOT | EP_PAGES );
}
/*======================================*/
// 2. Add new query var
add_filter( 'query_vars', 'bz_my_bookonline_query_vars', 0 );
function bz_my_bookonline_query_vars( $vars ) {
    $vars[] = 'my-bookonline';
    return $vars;
}
/*======================================*/
// 3. Insert the new endpoint into the My Account menu
// add_filter( 'woocommerce_account_menu_items', 'bz_add_my_bookonline_link_my_account' );
function bz_add_my_bookonline_link_my_account( $items ) {
    $items['my-bookonline'] = 'سانس های رزرو شده';
    return $items;
}
/*======================================*/
// 4. Add content to the new tab
add_action( 'woocommerce_account_my-bookonline_endpoint', 'bz_my_bookonline_content' );
function bz_my_bookonline_content() {
    echo '<h3>لیست رزرو های اتاق فرار ما</h3>';
    ?>


    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css">

    <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script type="text/javascript">

        $(document).ready(function() {
            $('#zb').DataTable( {
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'
                }
                ,
                dom: 'Bfrtip',
                buttons: [
                    'excel'
                ]
            } );
        } );

    </script>
    <table id="zb" class="display" style="width:100%">
        <thead>
        <tr>
            <th>شماره سفارش&nbsp;</th>
            <th>عنوان بازی&nbsp;</th>
            <th>نام رزرو کننده</th>
            <th>شماره تماس</th>
            <th>سانس رزروی</th>
            <th>مبلغ پرداختی</th>
            <th>تعداد نفرات</th>

        </tr>
        </thead>
        <tbody>

        <?php
        $get_current_user_id=get_current_user_id();
        $args = array (
            'post_type' => 'shop_order',
            'post_status' => 'any',
            'posts_per_page' => -1,
            'meta_key'      => 'id_operator',
            'meta_value'    => "$get_current_user_id"
        );
        $the_query = new WP_Query( $args );
        ?>
        <?php if ( $the_query->have_posts() ) : ?>

            <!-- pagination here -->

            <!-- the loop -->
            <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>

                <tr>
                    <?php $orderID=get_the_id();
                    $code_otagh = get_field( "code_otagh", get_the_id() );//book_day
                    $book_day = get_field( "book_day", get_the_id() );
                    $book_time = get_field( "book_time", get_the_id() );


                    $order = wc_get_order( $orderID );
                    $fname=$order->get_billing_first_name();
                    $lname=$order->get_billing_last_name();
                    $phone=$order->get_billing_phone();



                    foreach ( $order->get_items() as $item_id => $item ) {
                        $quantity = $item->get_quantity();
                        $subtotal = $item->get_subtotal();
                        $total = $item->get_total();
                    }




                    ?>
                    <td><?php the_id();?></td>
                    <td><?php echo get_the_title("$code_otagh");?></td>
                    <td><?=$fname.' '.$lname;?></td>
                    <td><?=$phone;?></td>
                    <td ><?=$book_day.' '.$book_time?></td>
                    <td>100,000 تومان</td>
                    <td><?=$quantity?> نفر</td>
                </tr>


            <?php endwhile; ?>
            <!-- end of the loop -->

            <!-- pagination here -->

            <?php wp_reset_postdata(); ?>

        <?php else : ?>
            <p><?php _e( 'هنوز رزروی صورت نگرفته است.' ); ?></p>
        <?php endif; ?>


        </tbody>
        <tfoot>
        <tr>
            <th>شماره سفارش&nbsp;</th>
            <th>عنوان بازی&nbsp;</th>
            <th>نام رزرو کننده</th>
            <th>شماره تماس</th>
            <th>مبلغ پرداختی</th>
            <th>تعداد نفرات</th>
            <th>سانس رزروی</th>

        </tr>

        </tfoot>
    </table>

    <?php

}