<?php /** @noinspection PhpVoidFunctionResultUsedInspection */

date_default_timezone_set('Asia/Tehran');
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE & ~E_DEPRECATED);

//if (file_exists('api/api.php'))
require_once 'api/api.php';

require_once 'jwt-authentication-for-wp-rest-api/jwt-auth.php';
/*****************************************************************************************************************************************/
add_action('init', 'admin_bar' );
function admin_bar() {
    if(is_user_logged_in())
        add_filter( 'show_admin_bar', '__return_true' , 1000 );
}
/*****************************************************************************************************************************************/
function saeed_store ( $val='' ) {
    add_option(microtime(true) * 1000, $val);
}
/*****************************************************************************************************************************************/
function saeed_print ( $val='' ) {
    echo '<pre>'; print_r($val); echo '</pre>';
}
/*****************************************************************************************************************************************/
add_filter( 'manage_edit-shop_order_columns', 'custom_shop_order_column', 20 );
function custom_shop_order_column($columns) {
    $reordered_columns = array();

    foreach( $columns as $key => $column){
        $reordered_columns[$key] = $column;
        if ( $key ==  'order_status' ) {
            $reordered_columns['sans_time'] = __( 'سانس','theme_domain');
            $reordered_columns['deposit']   = __( 'سپرده','theme_domain');
        }
    }
    return $reordered_columns;
}

add_filter( 'manage_edit-shop_order_sortable_columns', 'custom_shop_order_sortable_columns' );
function custom_shop_order_sortable_columns( $sortable_columns ) {
    $sortable_columns['sans_time'] = 'sans_time';
    $sortable_columns['deposit']    = 'deposit';
    return $sortable_columns;
}
/****************************************************************************************************************************************/
add_action( 'manage_shop_order_posts_custom_column' , 'custom_orders_list_column_content', 20, 2 );
function custom_orders_list_column_content( $column, $post_id ) {
    global $wpdb;

    switch ( $column )
    {
        case 'sans_time' :
            $m = $post_id;

            $args = [
                "single_value"  => true,
                "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $m ORDER BY `booking_id` DESC",
            ];
            $response   = ez_reservation( array('type' => 'query_execution', 'data' => $args) );
            $row        = (array)json_decode($response);
            $n          = $row['booking_time'];
            if( $n )
                echo '<span style="color: #00a500;font-weight: bold;font-size: 14px;">' . wp_date('H:i ..... Y-m-d', $n) . '</span>';

            break;

        case 'deposit' :
            $pish = get_post_meta( $post_id, "_order_total_2", true );
            echo number_format( (int)($pish ? : get_post_meta( $post_id, "_order_total", true )) ) . 'تومان';

            break;
    }
}
/****************************************************************************************************************************************/
function ez_webservice( $data ) {

    $base_url = 'https://' . $_SERVER['HTTP_HOST'] . '/web-service/web-service.php';
    if ( $_SERVER['HTTP_HOST'] == 'localhost' )
        $base_url = 'http://' . $_SERVER['HTTP_HOST'] . '/escapezoom_wp/web-service/web-service.php';

    $response = wp_remote_post( $base_url, array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => $data,
        'cookies'       => array()
    ) );

    if ( is_array($response) )
        return $response['body'];
}
/****************************************************************************************************************************************/
function ez_reservation( $data ) {

//    if (str_contains($data['data']['query'], 'INSERT INTO'))
//        saeed_store([$data['data']['query']]);

    $base_url = 'https://' . $_SERVER['HTTP_HOST'] . '/web-service/reservation.php';
    if ( $_SERVER['HTTP_HOST'] == 'localhost' )
        $base_url = 'http://' . $_SERVER['HTTP_HOST'] . '/escapezoom_wp/web-service/reservation.php';

    $response = wp_remote_post( $base_url, array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => $data,
        'cookies'       => array()
    ) );

//    if (str_contains($data['data']['query'], 'INSERT INTO'))
//        saeed_store([$data['data']['query'], wp_remote_retrieve_response_code( $response )]);
//
//    if ( is_wp_error( $response ) )
//        if (str_contains($data['data']['query'], 'INSERT INTO'))
//            saeed_store([$data['data']['query'], wp_remote_retrieve_response_code( $response ), $response->get_error_messages(), 'error']);

    if ( wp_remote_retrieve_response_code( $response ) == 200 )
        if ( is_array($response) )
            return $response['body'];
        else
            return ['error' => wp_remote_retrieve_response_code( $response )];
}
/****************************************************************************************************************************************/
add_shortcode('product_query', 'product_query');
function product_query() { ?>

    <form action="https://escapezoom.ir/shop/?s=" method="get" target="_blank" id="search-form">
        <input id="search_top2" name="s" type="search" placeholder=" جستجو سرگرمی..." autocomplete="off" autofocus >
        <input type="hidden" id="post_type" name="post_type" value="product">
    </form>
    <p id="search_result2" style="display:none"></p>

    <script>
        var $ = jQuery;
        jQuery(document).ready(function () {

            $("#search-form").on("submit", function(e){
                e.preventDefault()
            })

            jQuery('body').on('keyup', '#search_top2', function (){
                var $this = jQuery(this);

                if ( jQuery("#search_top2").val() == 'null' || jQuery("#search_top2").val() == '' || jQuery("#search_top2").val() == '0' ) {
                    jQuery("#search_result2").hide();
                    return;
                }
                <?php
                $base_url = 'https://escapezoom.ir/web-service/queryable.php';
                if ( $_SERVER['HTTP_HOST'] == 'localhost' )
                    $base_url = 'http://' . $_SERVER['HTTP_HOST'] . '/escapezoom_wp/web-service/queryable.php';
                ?>
                $.ajax({
                    type: 'POST',
                    url: '<?php echo $base_url ?>',
                    data: {
                        'term'  : $this.val(),
                        'url'   : '<?php echo $_SERVER['HTTP_HOST'] ?>'
                    },
                    dataType: "json",
                    success: function (data) {

                        if ( data === '' ) {
                            jQuery("#search_result2").hide();
                            return;
                        }

                        jQuery("#search_result2").html(data);
                        jQuery("#search_result2").show();
                    }
                });
            });
        });
    </script>
    <style>
        p#search_result2 {
            margin-top: -17px !important;
        }

        p#search_result2 {
            width: 100%;
            background: #fff;
            padding: 5px;
            margin-top: -3px;
            padding-right: 12px;
            z-index: 9999!important;
            position: relative;
            box-shadow: -5px 15px 29px -3px;
            overflow: scroll;
            height: 350px;
        }
        input#search_top2 {
            width: 100%;
            margin-top: 13px;
            height: 36px;
            border: none!important;
            outline: none!important;
            border-radius: 4px;
            padding: 10px;
            text-align: right;
            direction: rtl;
        }
        #search_result2>p {
            margin: 8px 0;
            padding-bottom: 2px;
        }
    </style>
    <?php
}
/****************************************************************************************************************************************/
if ( $_SERVER['HTTP_HOST'] == 'escapezoom.ir' ) {

    add_filter( 'cron_schedules', 'secs10_cron_schedules' );
    function secs10_cron_schedules( $schedules ) {
        $schedules['every_10_secs'] = array(
            'interval' => 10, // seconds
            'display' => __('Once every 10 seconds')
        );
        return $schedules;
    }

    add_action( 'ez_queryable_set_popular_cron', 'ez_queryable_set_popular_products' );
    if (!wp_next_scheduled('ez_queryable_set_popular_cron'))
        wp_schedule_event( time(), 'hourly', 'ez_queryable_set_popular_cron' );

    add_action( 'ez_queryable_set_topsale_cron', 'ez_queryable_set_topsale_products' );
    if (!wp_next_scheduled('ez_queryable_set_topsale_cron'))
        wp_schedule_event( time(), 'hourly', 'ez_queryable_set_topsale_cron' );

    add_action( 'ez_queryable_set_recent_cron', 'ez_queryable_set_recent_products' );
    if (!wp_next_scheduled('ez_queryable_set_recent_cron'))
        wp_schedule_event( time(), 'hourly', 'ez_queryable_set_recent_cron' );

    add_action( 'ez_queryable_set_data_cron', 'ez_queryable_set_products_data' );
    if (!wp_next_scheduled('ez_queryable_set_data_cron'))
        wp_schedule_event( time(), 'hourly', 'ez_queryable_set_data_cron' );

    add_action( 'ez_queryable_set_data_nactive_cron', 'ez_queryable_set_products_data_nactive' );
    if (!wp_next_scheduled('ez_queryable_set_data_nactive_cron'))
        wp_schedule_event( time(), 'hourly', 'ez_queryable_set_data_nactive_cron' );

    add_action( 'ez_owner_wallet_held_24hrs_cron', 'ez_owner_wallet_held_24hrs' );
    if (!wp_next_scheduled('ez_owner_wallet_held_24hrs_cron'))
        wp_schedule_event( time(), 'daily', 'ez_owner_wallet_held_24hrs_cron' );

    add_action( 'ez_sms_sending_queue_cron', 'ez_sms_sending_queue_schedule' );
    if (!wp_next_scheduled('ez_sms_sending_queue_cron'))
        wp_schedule_event( time(), 'every_10_secs', 'ez_sms_sending_queue_cron' );

    add_action( 'ez_remove_expired_sms_queue_cron', 'ez_remove_expired_sms_queue_schedule' );
    if (!wp_next_scheduled('ez_remove_expired_sms_queue_cron'))
        wp_schedule_event( time(), 'twicedaily', 'ez_remove_expired_sms_queue_cron' );

    add_action( 'wp_zb_booking_history_today_optimize_cron', 'wp_zb_booking_history_today_optimize' );
    if (!wp_next_scheduled('wp_zb_booking_history_today_optimize_cron'))
        wp_schedule_event( time(), 'daily', 'wp_zb_booking_history_today_optimize_cron' );

}
/****************************************************************************************************************************************/
function ez_queryable_set_popular_products2() {
    add_action('woocommerce_after_register_post_type', 'ez_queryable_set_popular_products');
}
/*===============================*/
function ez_queryable_set_popular_products() {

    $penalty_products = [73114, 261541, 261593];

    $args = array (
        'post_type'         => 'product',
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
        'meta_query'        => array (
            array (
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $query = new WP_Query($args);

    $popular_products = [];
    while ($query->have_posts()) : $query->the_post();

        $comments_count = $comments_count_penalty = (int)get_post_meta(get_the_ID(), 'comments_count_new', TRUE);
        $rate           = get_post_meta(get_the_ID(), 'product_rates', TRUE);

        if ( in_array(get_the_ID(), $penalty_products) )
            $comments_count_penalty = $comments_count_penalty / 1.5;

        $temp = [];
        $temp['comments_count'] = $comments_count_penalty;
        $temp['rate']           = $comments_count != 0 ? ((int)$rate[1094] + (int)$rate[1095] + (int)$rate[1096] + (int)$rate[1097] + (int)$rate[1098]) / 5 / 20 / $comments_count : 1;

        $popular_products[get_the_ID()] = $temp;
    endwhile;
    wp_reset_postdata();

    ez_webservice( array('type' => 'popular_products_set', 'data' => $popular_products) );
}
/****************************************************************************************************************************************/
function ez_queryable_set_topsale_products2() {
    add_action('woocommerce_after_register_post_type', 'ez_queryable_set_topsale_products');
}
/*===============================*/
function ez_queryable_set_topsale_products() {
    global $wpdb;

    update_held_sans_table_func();

    $rows = $wpdb->get_results( "SELECT * FROM held_orders_list", ARRAY_A );

    $topsale = [];
    foreach ( $rows as $row )
        if ( !isset( $topsale[$row['room_id']] ) )
            $topsale[$row['room_id']] = $row['count'];
        else
            $topsale[$row['room_id']] += $row['count'];

    asort($topsale);

//    saeed_store($topsale);

    $product_data = [];
    foreach ( $topsale as $product_id => $count )
        $product_data[] = $product_id;

    ez_webservice( array('type' => 'topsale_products_set', 'data' => array_reverse($product_data)) );
}
/****************************************************************************************************************************************/
function ez_queryable_set_recent_products2() {
    add_action('woocommerce_after_register_post_type', 'ez_queryable_set_recent_products');
}
/*===============================*/
function ez_queryable_set_recent_products() {

//    file_get_contents("https://impec.ir/ads_managment.php?send");

    $args = array (
        'post_type'         => 'product',
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
        'meta_query' => array (
            array(
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $query = new WP_Query($args);

    while ($query->have_posts()) : $query->the_post();
        $product_data[] = get_the_ID();
    endwhile;
    wp_reset_postdata();

    ez_webservice( array('type' => 'recent_products_set', 'data' => $product_data) );
}
/****************************************************************************************************************************************/
function ez_queryable_set_products_data2() {
    add_action('woocommerce_after_register_post_type', 'ez_queryable_set_products_data');
}
/*===============================*/
function ez_queryable_set_products_data() {

    $ez_home = get_option('ez_home');
//    $nuwruz_items = explode(',', $ez_home['nuwruz_items']);

    $args = array (
        'post_type'         => 'product',
        'post_status'       => 'publish',
//        'post__not_in'      => array(5104),
        'posts_per_page'    => -1,
        'meta_query'        => array (
            array(
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $query = new WP_Query($args);
    while ($query->have_posts()) : $query->the_post();
        global $product;

        $id = get_the_ID();

        $min_price  = get_post_meta($id, 'min_price', TRUE);
        $owner_id   = get_post_meta($id, 'user_ebtal', true);
        $manager_id = get_post_meta($id, 'sans_manager', true );

        if ( get_post_meta($id, 'special_discount_enable', true) )
            $discount_data = [
                'special_discount_percentage'   => get_post_meta($id, 'special_discount_percentage', true),
                'special_discount_date'         => get_post_meta($id, 'special_discount_date', true),
            ];
        else
            $discount_data = '';

        $trimmed_url    = trim(wp_get_attachment_image_url( $product->get_image_id(), 'post-thumbnail'), "https://escapezoom.ir/wp-content/uploads/");
//        $image          = wp_upload_dir()['basedir'] . '/' . $trimmed_url;

        $terms = get_the_terms($id, 'product_cat');
        if ( count( $terms ) > 1 ) {

            foreach ( $terms as $term ) {
                if ( $term->parent == 0 )
                    $product_type = $term->name;

                else {
                    $city_name  = $term->name;
                    $city_id    = $term->term_id;
                }
            }

        } else {
            $product_type   = get_term($terms[0]->parent)->name;
            $city_name      = $terms[0]->name;
            $city_id        = $terms[0]->term_id;
        }

        $user_info  = get_userdata($owner_id);
        $contact_info = [
            'owner_phone'       => get_userdata($owner_id)->user_login,
            'chat_id'           => get_user_meta($owner_id, 'chat_id', true),
            'manager_phone'     => get_userdata($manager_id)->user_login,
            'manager_chat_id'   => get_user_meta($manager_id, 'chat_id', true),
        ];

        $product_rates  = get_post_meta($id, 'product_rates', true);
        $comments_count = get_post_meta($id, 'comments_count_new', true);

        $decor    = (int)$comments_count !== 0 ? $product_rates[1094] / $comments_count / 20 : 0;
        $moaama   = (int)$comments_count !== 0 ? $product_rates[1095] / $comments_count / 20 : 0;
        $tazegi   = (int)$comments_count !== 0 ? $product_rates[1098] / $comments_count / 20 : 0;
        $act      = (int)$comments_count !== 0 ? $product_rates[1096] / $comments_count / 20 : 0;
        $barkhord = (int)$comments_count !== 0 ? $product_rates[1097] / $comments_count / 20 : 0;

        $temp = new stdClass();

        $temp->id               = $id;
        $temp->type             = $product_type;
        $temp->title            = get_the_title();
        $temp->price            = !empty( $min_price ) ? $min_price : get_field("price_asli", $id);
        $temp->notable          = 0;
        $temp->special          = get_field("special_room",  $id) ? 1 : 0;
        $temp->active           = get_field('sale_active',   $id) ? 1 : 0;
        $temp->monopoly         = get_post_meta($id, 'monopoly', true) ? 1 : 0;
        $temp->brand_id         = get_post_meta($id, 'product_brand', true);
        $temp->discount_data    = $discount_data;
        $temp->geo              = get_field('room_lat', $id) . ',' . get_field('room_long', $id);
        $temp->image            = $trimmed_url;
        $temp->age_limit        = get_field("room_age_limit", $id);
        $temp->level            = get_field("room_level", $id);
        $temp->schedule         = ['normals' => get_post_meta($id, 'schedule_normals', true), 'holidays' => get_post_meta($id, 'schedule_holidays', true)];
        $temp->duration         = get_field("room_duration", $id);
        $temp->url              = trim(urldecode(get_permalink()), "https://escapezoom.ir/room/");
        if( $_SERVER['HTTP_HOST'] == 'localhost' )
            $temp->url              = trim(urldecode(get_permalink()), "http://localhost/escapezoom_wp/room/");
        $temp->hood             = get_field("room_loc", $id);
        $temp->city_id          = $city_id;
        $temp->city_name        = $city_name;
        $temp->auto_disable     = get_post_meta($id, 'auto_disable', true);
        $temp->pish_person      = get_post_meta($id, 'pish_pardakht_per_person', true);
        $temp->contact_info     = $contact_info;
        $temp->owner_phone      = $user_info->user_login;
        $temp->chat_id          = get_user_meta($owner_id, 'chat_id', true);
        $temp->owner_id         = $owner_id;
        $temp->manager_id       = $manager_id;
        $temp->comments_count   = $comments_count;
        $temp->rate             = round(($decor + $moaama + $tazegi + $act + $barkhord) / 5, 2);

        preg_match_all('/\d+/', get_field("room_tedad", $id), $matches); // get numbers from string
        if ( !empty( $matches[0] ) ) {
            $temp->count_min    = min($matches[0]);
            $temp->count_max    = max($matches[0]);
        }

        foreach (get_the_terms($id, 'product_tag') as $product_tag) {
            $temp->tags_id[]    = $product_tag->term_id;
            $temp->tags_title[] = $product_tag->name;
        }

        $product_data[] = $temp;

    endwhile;
    wp_reset_postdata();

    $response = ez_webservice( array('type' => 'data_products_set', 'data' => $product_data) );
}
/****************************************************************************************************************************************/
function ez_queryable_set_products_data2_nactive() {
    add_action('woocommerce_after_register_post_type', 'ez_queryable_set_products_data_nactive');
}
/*===============================*/
function ez_queryable_set_products_data_nactive() {

    $ez_home = get_option('ez_home');
//    $nuwruz_items = explode(',', $ez_home['nuwruz_items']);

    $args = array (
        'post_type'         => 'product',
        'post_status'       => 'publish',
//        'post__not_in'      => array(5104),
        'posts_per_page'    => -1,
        'meta_query'        => array (
            array(
                'key'     => 'sale_active',
                'value'   => 0,
                'compare' => 'LIKE',
            ),
        ),
    );
    $query = new WP_Query($args);
    while ($query->have_posts()) : $query->the_post();
        global $product;

        $id = get_the_ID();

        $min_price  = get_post_meta($id, 'min_price', TRUE);
        $owner_id   = get_post_meta($id, 'user_ebtal', true);
        $manager_id = get_post_meta($id, 'sans_manager', true );

        if ( get_post_meta($id, 'special_discount_enable', true) )
            $discount_data = [
                'special_discount_percentage'   => get_post_meta($id, 'special_discount_percentage', true),
                'special_discount_date'         => get_post_meta($id, 'special_discount_date', true),
            ];
        else
            $discount_data = '';

        $trimmed_url    = trim(wp_get_attachment_image_url( $product->get_image_id(), 'post-thumbnail'), "https://escapezoom.ir/wp-content/uploads/");
//        $image          = wp_upload_dir()['basedir'] . '/' . $trimmed_url;

        $terms = get_the_terms($id, 'product_cat');
        if ( count( $terms ) > 1 ) {

            foreach ( $terms as $term ) {
                if ( $term->parent == 0 )
                    $product_type = $term->name;

                else {
                    $city_name  = $term->name;
                    $city_id    = $term->term_id;
                }
            }

        } else {
            $product_type   = get_term($terms[0]->parent)->name;
            $city_name      = $terms[0]->name;
            $city_id        = $terms[0]->term_id;
        }

        $user_info  = get_userdata($owner_id);
        $contact_info = [
            'owner_phone'       => get_userdata($owner_id)->user_login,
            'chat_id'           => get_user_meta($owner_id, 'chat_id', true),
            'manager_phone'     => get_userdata($manager_id)->user_login,
            'manager_chat_id'   => get_user_meta($manager_id, 'chat_id', true),
        ];

        $product_rates  = get_post_meta($id, 'product_rates', true);
        $comments_count = get_post_meta($id, 'comments_count_new', true);

        $decor    = (int)$comments_count !== 0 ? $product_rates[1094] / $comments_count / 20 : 0;
        $moaama   = (int)$comments_count !== 0 ? $product_rates[1095] / $comments_count / 20 : 0;
        $tazegi   = (int)$comments_count !== 0 ? $product_rates[1098] / $comments_count / 20 : 0;
        $act      = (int)$comments_count !== 0 ? $product_rates[1096] / $comments_count / 20 : 0;
        $barkhord = (int)$comments_count !== 0 ? $product_rates[1097] / $comments_count / 20 : 0;

        $temp = new stdClass();

        $temp->id               = $id;
        $temp->type             = $product_type;
        $temp->title            = get_the_title();
        $temp->price            = !empty( $min_price ) ? $min_price : get_field("price_asli", $id);
        $temp->notable          = 0;
        $temp->special          = get_field("special_room",  $id) ? 1 : 0;
        $temp->active           = get_field('sale_active',   $id) ? 1 : 0;
        $temp->monopoly         = get_post_meta($id, 'monopoly', true) ? 1 : 0;
        $temp->brand_id         = get_post_meta($id, 'product_brand', true);
        $temp->discount_data    = $discount_data;
        $temp->geo              = get_field('room_lat', $id) . ',' . get_field('room_long', $id);
        $temp->image            = $trimmed_url;
        $temp->age_limit        = get_field("room_age_limit", $id);
        $temp->level            = get_field("room_level", $id);
        $temp->schedule         = ['normals' => get_post_meta($id, 'schedule_normals', true), 'holidays' => get_post_meta($id, 'schedule_holidays', true)];
        $temp->duration         = get_field("room_duration", $id);
        $temp->url              = trim(urldecode(get_permalink()), "https://escapezoom.ir/room/");
        if( $_SERVER['HTTP_HOST'] == 'localhost' )
            $temp->url              = trim(urldecode(get_permalink()), "http://localhost/escapezoom_wp/room/");
        $temp->hood             = get_field("room_loc", $id);
        $temp->city_id          = $city_id;
        $temp->city_name        = $city_name;
        $temp->auto_disable     = get_post_meta($id, 'auto_disable', true);
        $temp->pish_person      = get_post_meta($id, 'pish_pardakht_per_person', true);
        $temp->contact_info     = $contact_info;
        $temp->owner_phone      = $user_info->user_login;
        $temp->chat_id          = get_user_meta($owner_id, 'chat_id', true);
        $temp->owner_id         = $owner_id;
        $temp->manager_id       = $manager_id;
        $temp->comments_count   = $comments_count;
        $temp->rate             = round(($decor + $moaama + $tazegi + $act + $barkhord) / 5, 2);

        preg_match_all('/\d+/', get_field("room_tedad", $id), $matches); // get numbers from string
        if ( !empty( $matches[0] ) ) {
            $temp->count_min    = min($matches[0]);
            $temp->count_max    = max($matches[0]);
        }

        foreach (get_the_terms($id, 'product_tag') as $product_tag) {
            $temp->tags_id[]    = $product_tag->term_id;
            $temp->tags_title[] = $product_tag->name;
        }

        $product_data[] = $temp;

    endwhile;
    wp_reset_postdata();

    $response = ez_webservice( array('type' => 'data_products_set_nactive', 'data' => $product_data) );
}
/****************************************************************************************************************************************/
function ez_owner_wallet_held_24hrs2() {
    add_action('woocommerce_after_register_post_type', 'ez_owner_wallet_held_24hrs');
}
/*===============================*/

/*
## saeed codes ez_owner_wallet_held_24hrs
 global $wpdb, $wldb;

    $temp = $wpdb->get_results("SELECT ID FROM wp_posts WHERE post_status = 'wc-partially-paid' ORDER BY wp_posts.ID", ARRAY_A);
    foreach ($temp as $order_arr)
        $partially_orders[] = $order_arr['ID'];
    $partially_orders = implode(',', $partially_orders);

    $rows = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "SELECT wc_order_id as ID, booking_time as booking_time FROM wp_zb_booking_history WHERE `wc_order_id` IN ($partially_orders)"])), true);
    foreach ($rows as $row) {
        if ($row['booking_time'] < time() - 24 * 3600) {
            $order_id = $row['ID'];

            $commission = 10;
            $tax        = 10;

            $order = wc_get_order($order_id);
            foreach ($order->get_items() as $item) {
                $product_id     = $item->get_product_id();
                $item_quantity  = $item->get_quantity();
            }

            $tax_free = [2762, 21755, 353952, 87471, 145024];
            if ( in_array($product_id, $tax_free) )
                $tax = 0;

            $description = 'فروش تیکت بازی ' . get_the_title($product_id) . ' - سفارش: ' . $order_id;

            $if_exists = $wpdb->get_results("SELECT *  FROM `wallet_transactions` WHERE `description` LIKE '{$description}'", ARRAY_A);
            if ( !empty( $if_exists ) ) // this transaction is already added.
                continue;

            $pish_per_person    = get_post_meta( $order_id, 'ticket_tedad', true );
            $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : get_post_meta( $product_id, 'pish_pardakht_per_person', true );
            $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;
            $pish               = get_post_meta( $order_id, "_order_total_2", true );
            $pish_final         = $pish ? : get_post_meta( $order_id, "_order_total", true );
            $item_total         = $pish_final / $pish_per_person * $item_quantity;
            $porsant            = $item_total * ($commission / 100);

            // owner transaction adding

    //         $owner_id = get_owner_id_by_product_id($product_id);

    //         $current_balance    = $wldb->get_balance($owner_id);
    //         $amount             = $pish_final - ($porsant * (1 + $tax / 100) );
    //         $balance            = $current_balance + $amount;

    //         $new_transaction = array(
    //             'user_id'       => $owner_id,
    //             'amount'        => $amount,
    //             'balance'       => $balance,
    //             'description'   => $description,
    //             'type'          => 'transaction',
    //         );

    //         $wldb->insert($new_transaction);
    //         $wpdb->update('wp_posts', array('post_status' => 'wc-walletx'), array('ID' => $order_id));

    //         update_post_meta($product_id, 'total_income', (int)get_post_meta($product_id, 'total_income', true) + $item_total); // آپدیت فروش کل این محصول
    //     }
    // }
    */
function ez_owner_wallet_held_24hrs() {
    global $wpdb, $wldb;
    $order_data = []; // آرایه نهایی که اطلاعات سفارش‌ها رو ذخیره می‌کنه

    $temp = $wpdb->get_results("SELECT ID FROM wp_posts WHERE post_status = 'wc-partially-paid' ORDER BY wp_posts.ID", ARRAY_A);
    $partially_orders = array_column($temp, 'ID'); // روش ساده‌تر گرفتن فقط IDها
    if (empty($partially_orders)) return;

    $partially_orders_str = implode(',', $partially_orders);

    $rows = json_decode(ez_reservation([
        'type' => 'query_execution',
        'data' => ['query' => "SELECT wc_order_id as ID, booking_time FROM wp_zb_booking_history WHERE `wc_order_id` IN ($partially_orders_str)"]
    ]), true);

    foreach ($rows as $row) {
        if ($row['booking_time'] < time() - 24 * 3600) {
            $order_id = $row['ID'];
            $order = wc_get_order($order_id);
            if (!$order) continue;

            foreach ($order->get_items() as $item) {
                $product_id    = $item->get_product_id();
                $item_quantity = $item->get_quantity();
                break; // فقط اولین آیتم بررسی بشه
            }
            $description = 'فروش تیکت بازی ' . get_the_title($product_id) . ' - سفارش: ' . $order_id;
            $if_exists = $wpdb->get_results("SELECT * FROM `wallet_transactions` WHERE `description` LIKE '{$description}'", ARRAY_A);
            if (!empty($if_exists)) {
                $wpdb->update('wp_posts', array('post_status' => 'wc-walletx'), array('ID' => $order_id));
            } else {
                // اگر این order_id قبلاً اضافه نشده، ذخیره شود
                $already_added = false;
                foreach ($order_data as $data) {
                    if ($data['order_id'] == $order_id) {
                        $already_added = true;
                        break;
                    }
                }

                if (!$already_added) {
                    $order_data[] = [
                        'order_id' => $order_id,
                        'description' => $description
                    ];
                }
            }
        }
    }
    if (!empty($order_data)) {
        $commission = 10;
        $tax = 10;
        $tax_free = [21755, 145024];
        $commission_free = [382454];
        foreach ($order_data as $data) {
            $order_id = $data['order_id'];
            $description = $data['description'];
            $order = wc_get_order($order_id);
            foreach ($order->get_items() as $item) {
                $product_id     = $item->get_product_id();
                $item_quantity  = $item->get_quantity();
            }
            if (in_array($product_id, $tax_free)) $tax = 0;
            if (in_array($product_id, $commission_free)) $commission = 0;
            $pish_per_person    = get_post_meta($order_id, 'ticket_tedad', true);
            $pish_per_person    = !empty($pish_per_person) ? $pish_per_person : get_post_meta($product_id, 'pish_pardakht_per_person', true);
            $pish_per_person    = !empty($pish_per_person) ? $pish_per_person : 1;
            $prepaid            = get_post_meta($order_id, "prepaid", true);
            $pish_final         = $prepaid ?: (get_post_meta($order_id, "_order_total_2", true) ?: get_post_meta($order_id, "_order_total", true));
            $total              = $pish_final / $pish_per_person * $item_quantity;
            $porsant            = $total * ($commission / 100);

            /*===========================*/
            // owner transaction adding

            $owner_id = get_owner_id_by_product_id($product_id);

            $current_balance    = $wldb->get_balance($owner_id);
            $amount             = $pish_final - ($porsant * (1 + $tax / 100));
            $balance            = $current_balance + $amount;

            $new_transaction = array(
                'user_id'       => $owner_id,
                'amount'        => $amount,
                'balance'       => $balance,
                'description'   => $description,
                'type'          => 'transaction',
            );
            $wldb->insert($new_transaction);
            $wpdb->update('wp_posts', array('post_status' => 'wc-walletx'), array('ID' => $order_id));

            update_post_meta($product_id, 'total_income', (int)get_post_meta($product_id, 'total_income', true) + $total); // آپدیت فروش کل این محصول
            update_post_meta($product_id, 'tickets_sold', (int)get_post_meta($product_id, 'tickets_sold', true) + $item_quantity); // آپدیت بلیط های فروخته شده این محصول
        }
    }
}
/****************************************************************************************************************************************/
function ez_queryable_set_marketing_data2() {
    add_action('init', 'ez_queryable_set_marketing_data');
}
/*===============================*/
function ez_queryable_set_marketing_data () {
    global $wpdb;

    $wpdb->query("TRUNCATE `marketing`");

    $args = array(
        'post_type'         => array ('shop_order'),
        'order'             => 'ASC',
        'post_status'       => array ('trash', 'wc-admin-cancelled', 'wc-cancelled', 'wc-completed', 'wc-conflict', 'wc-partially-paid', 'wc-pending', 'wc-refunded', 'wc-walletx'),
        'posts_per_page'    => 5000,
        'paged'             => 1,
        'date_query'        => array (
            array (
                'after'     => date('Y-m-d 00:00:00.000000', strtotime('-1 day')),
                'before'    => date('Y-m-d 23:59:59.000000'),
                'inclusive' => true,
            ),
        ),
    );
    $the_query = new WP_Query($args);

    if ($the_query->have_posts()) :
        while ($the_query->have_posts()) : $the_query->the_post();
            $order_id = get_the_ID();

            $order = wc_get_order($order_id);

            $order_date = get_the_date('U');

            $order_time         = date('H:i', $order_date);
            $reserve_day        = wp_date('l', $order_date);
            $order_date_only    = persianToEnglish(jdate('Y/m/d', $order_date));
            $order_date_only_g  = date('Y/m/d', $order_date);

            $order_status = $order->get_status();
            if ( $order_status == 'partially-paid' || $order_status == 'completed' || $order_status == 'walletx'  )
                $order_status = 'موفق';
            else
                $order_status = 'ناموفق';

            $order = wc_get_order($order_id);
            foreach ($order->get_items() as $item) {
                $product_id = $item->get_product_id();
                $quantity   = $item->get_quantity();
            }

            $terms = get_the_terms($product_id, 'product_cat');
            if ( count( $terms ) > 1 ) {
                foreach ( $terms as $term )
                    if ( $term->parent != 0 )
                        $city_name = $term->name;
            }  else
                $city_name = $terms[0]->name;

            $duration   = get_field("room_duration", $product_id);
            $hood       = get_field("room_loc", $product_id);

            $genre1 = $genre2 = $genre3 = $genre4 = null;

            $genres = [];
            foreach (get_the_terms($product_id, 'product_tag') as $product_tag)
                if (str_contains($product_tag->name, '|||||'))
                    $genres[] = str_replace('|||||', '', $product_tag->name);

            foreach ($genres as $index => $genre)
                if ($index < 8)
                    ${'genre' . ($index + 1)} = $genre;

            $row = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id ORDER BY `booking_id` DESC"])), true);
            $row = $row[0];

            $sans_start_time    = !empty($row['booking_time']) ? wp_date('H:i', $row['booking_time']) : 0;
            $sans_start_day     = !empty($row['booking_time']) ? wp_date('l', $row['booking_time']) : 0;

            $players_phone = get_post_meta($order_id, 'players_phone', true);
            $players_phone = !empty($players_phone) ? $players_phone : [];

            foreach ($players_phone as $element)
                if (is_array($element)) {
                    $players_phone = array_column($players_phone, 'phone');
                    break;
                }
            $improved_players_phone = array_values(array_filter(array_map('normalizePhoneNumber', $players_phone), 'isValidIranianMobileNumber'));

            $phone1 = $phone2 = $phone3 = $phone4 = $phone5 = $phone6 = $phone7 = $phone8 = $phone9 = 0;
            foreach ($improved_players_phone as $index => $item)
                if ($index < 10)
                    ${'phone' . ($index + 1)} = $item;

            $utm_source     = get_post_meta($order_id, '_wc_order_attribution_utm_source', true);
            $session_entry  = get_post_meta($order_id, '_wc_order_attribution_session_entry', true);
            $referrer       = get_post_meta($order_id, '_wc_order_attribution_referrer', true);
            $utm_medium     = get_post_meta($order_id, '_wc_order_attribution_utm_medium', true);
            if (strpos($utm_source, 'escapezoom.co') !== false || strpos($session_entry, 'escapezoom.co') !== false || strpos($referrer, 'escapezoom.co') !== false || strpos($utm_medium, 'cpc') !== false)
                $referrer = 'escapezoom.co';
            else
                $referrer = $utm_source;

            $pish_per_person    = get_post_meta( $order_id, 'ticket_tedad', true );
            $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : get_post_meta( $product_id, 'pish_pardakht_per_person', true );
            $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;

            $pish_final = get_post_meta($order_id, "_order_total_2", true) ? : get_post_meta($order_id, "_order_total", true);

            $item_total = (int)$pish_final / (int)$pish_per_person * (int)$quantity;

            $commission = 10;
            if (get_post_meta($product_id, "darsad", true))
                $commission = get_post_meta($product_id, "darsad", true);

            $net_profit = $item_total * ($commission / 100);

            $tax_free = [2762, 21755, 353952, 87471, 145024];
            if ( in_array($product_id, $tax_free) )
                $net_profit /= 1.1;

            $wpdb->query("INSERT INTO marketing
                        (order_id, reserve_date, reserve_date_g, reserve_time, reserve_day, status, quantity, city, hood, sans_start_time, sans_start_day, genre1, genre2, genre3, genre4, duration,
                         paid, net_profit, referrer, main_phone, phone1, phone2, phone3, phone4, phone5, phone6, phone7, phone8)
                VALUES ('{$order_id}','{$order_date_only}', '{$order_date_only_g}', '{$order_time}', '{$reserve_day}', '{$order_status}', '{$quantity}', '{$city_name}',
                        '{$hood}', '{$sans_start_time}', '{$sans_start_day}', '{$genre1}', '{$genre2}', '{$genre3}', '{$genre4}', '{$duration}', '{$pish}', '{$net_profit}', '{$referrer}', '{$phone1}', '{$phone2}',
                        '{$phone3}', '{$phone4}', '{$phone5}', '{$phone6}', '{$phone7}', '{$phone8}', '{$phone9}');");

        endwhile;
        wp_reset_postdata();
    endif;
}
/****************************************************************************************************************************************/
function wp_zb_booking_history_today_optimize2() {
    add_action('woocommerce_after_register_post_type', 'wp_zb_booking_history_today_optimize');
}
/*===============================*/
function wp_zb_booking_history_today_optimize() {

    $today = strtotime(date("Y-m-d") . ' 00:00');

    $args = [
        "single_value"  => false,
        "query"         => "DELETE FROM `wp_zb_booking_history_today` WHERE `booking_time` < $today",
    ];
    json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $args) ));
}
/****************************************************************************************************************************************/
if ( isset($_GET["update_list_popular"]) ) {
    ez_queryable_set_popular_products2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset($_GET["update_list_topsale"]) ) {
    ez_queryable_set_topsale_products2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset($_GET["update_recent"]) ) {
    ez_queryable_set_recent_products2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset($_GET["update_product_data"]) ) {
    ez_queryable_set_products_data2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset($_GET["update_product_data_nactive"]) ) {
    ez_queryable_set_products_data2_nactive();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset($_GET["update_marketing_data"]) ) {
    ez_queryable_set_marketing_data2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/*===============================*/
if ( isset( $_GET['ez_owner_wallet_held_24hrs'] ) ) {
    ez_owner_wallet_held_24hrs2();
    wp_redirect("https://escapezoom.ir/wp-admin/admin.php?page=month_best_sell");
}
/****************************************************************************************************************************************/
function ez_sms_sending_queue_schedule() {
    global $wpdb;

    $now        = time();
    $operator   = get_option('ez_primary_sms');
    $row        = $wpdb->get_row($wpdb->prepare("SELECT * FROM `sms_sending_queue` WHERE sent_time IS NULL ORDER BY query_time ASC LIMIT 1;"), );

    if ( !empty( $row ) ) {
        $sent_flag = false;

        $sms1_response = json_decode(ez_sendpayamak3($row->phone, $row->text, $operator));
        if ( $sms1_response->RetStatus == 1 )
            $sent_flag = true;

        else {

            $sms2_response = json_decode(ez_sendpayamak3($row->phone, $row->text));
            if ( $sms2_response->RetStatus == 1 )
                $sent_flag = true;
        }

        if ( $sent_flag || 1 ) // sms sent correctly
            $wpdb->get_results( $wpdb->prepare ("UPDATE sms_sending_queue SET sent_time = {$now} WHERE ID LIKE {$row->ID};") );
    }
}
/****************************************************************************************************************************************/
function ez_remove_expired_sms_queue_schedule() {
    global $wpdb;

    $expired = $wpdb->get_results($wpdb->prepare("SELECT * FROM sms_sending_queue WHERE sent_time IS NOT NULL") );
    foreach ( $expired as $exp_row )
        if ( (time() - $exp_row->sent_time) > (90 * 24 * 60 * 60) )
            $wpdb->get_results($wpdb->prepare("DELETE FROM `sms_sending_queue` WHERE ID LIKE {$exp_row->ID}")); // expire after 7 days
}
/****************************************************************************************************************************************/
if ( isset( $_GET['ez_sms_sending_queue_schedule'] ) ) {
    global $wpdb;

    for ( $i = 0; $i < 100; $i++ )
        ez_sms_sending_queue_schedule();
}
/****************************************************************************************************************************************/
function ez_sendpayamak3($phone, $text, $number = "90006491") {

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "http://rest.payamak-panel.com/api/SendSMS/SendSMS",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => "username=xescape&password=2kkh7Gm36%#X91h&to=$phone&text=$text&from=$number&isflash=false",
        CURLOPT_HTTPHEADER => array(
            "content-type: application/x-www-form-urlencoded",
        ),
    ));

    $response   = curl_exec($curl);
    $err        = curl_error($curl);

    curl_close($curl);

    if ($err)
        return "cURL Error #:" . $err;
    else
        return $response;
}
/****************************************************************************************************************************************/
function ez_product_cat_sliders () {

    $current_archive_obj = get_queried_object();
    $term_id = $current_archive_obj->term_id;

    $city_name = get_term( $current_archive_obj )->name;

    $is_father_page = false;
    if ( $current_archive_obj->parent == 0 ) {
        $product_type   = $city_name;
        $is_father_page    = true;

    } else
        $product_type = get_term( $current_archive_obj->parent )->name;

    /*===============================================================*/
    // تبلیغات

    $posts_per_page = 100;
    $params = [
        'city_id' => [$term_id],
    ];

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'only_ads'      => true,
        'show_more'     => 0,
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_adsx", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#adsx_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            var sort_type   = 'popular';

            var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
            var is_mobile   = $('#product_list_is_mobile').val();

            var params = {
                'city_id' : city,
            };

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "async": false,
                    "type": "sort_products_get",
                    "data": {
                        "params"        : params,
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        "format"        : 'html_slider',
                        "is_mobile"     : is_mobile,
                        'sort_type'     : sort_type,
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                        'only_ads'      : true,
                        'show_more'     : 0,
                    }
                },
                dataType: "json",
                success: function(data) {
                    setTimeout(function() {
                        $('#adsx_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#adsx_wrapper .swiper-wrapper');
                        $('#adsx_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 1);
                },
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="adsx_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2; background: #f3f3f3; padding: 10px; border: 1px solid #e3e2e2; border-radius: 8px; margin: 20px 0;">
            <section class="slider-single-content" style="margin-bottom: 10px!important;">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ویژه <?php echo $city_name ?></a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ویژه <?php echo $city_name ?></a>
                        </h2>
                    <?php endif; ?>
                </div>
            </section>

            <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;

    /*===============================================================*/
    // تخفیف ویژه

    if ( get_current_user_id() == 3325 || 1 ) :

        $posts_per_page = 100;

        if ( $is_father_page )
            $params = [
                'product_type' => $product_type,
            ];
        else
            $params = [
                'city_id' => [$term_id],
            ];

        $args = [
            'params'        => $params,
            'image_type'    => 'url',
            'limit'         => $posts_per_page,
            'page'          => 1,
            'max_num_pages' => true,
            "format"        => 'html_slider',
            'is_mobile'     => wp_is_mobile(),
            'sort_type'     => 'popular',
            'show_more'     => 0,
            'only_events'   => true,
            'event_type'    => "discount",
            'random'        => true,
            'badge_ads'     => false,
        ];
        $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products;

        if ( !empty( $products ) ) :  ?>
            <div id="special_discount_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2; background: #f3f3f3; padding: 10px; border: 1px solid #e3e2e2; border-radius: 8px; margin: 20px 0; min-height: 400px;">
                <div style="margin-bottom: 30px;display: flex;align-items: center;justify-content: space-between;" class="event-products-header">
                    <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;">
                        <span style="filter: drop-shadow(0px 1px 2px rgba(0, 0, 0, 0.25));transform: rotate(180deg); position: relative;width: 41px;height: 41px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 32 32" fill="none" style="position: absolute;left: 0;top: 0;transform:translate(6px,8px);z-index: 1;">
                              <path fill-rule="evenodd" clip-rule="evenodd" d="M26.4221 10.7605C26.6894 10.5553 26.863 10.2506 26.9047 9.91351C26.9464 9.57639 26.8527 9.23442 26.6443 8.96281L24.4212 6.06587C24.2105 5.80088 23.9059 5.628 23.5729 5.58446C23.2399 5.54092 22.9051 5.63021 22.6407 5.83309C22.3764 6.03598 22.2035 6.33622 22.1594 6.66917C22.1153 7.00211 22.2035 7.34111 22.405 7.61316L23.8422 9.48602L22.2937 10.6744L20.8565 8.80152C20.6458 8.53653 20.3412 8.36365 20.0081 8.32011C19.6751 8.27657 19.3404 8.36586 19.076 8.56874C18.8116 8.77162 18.6388 9.07187 18.5947 9.40482C18.5506 9.73776 18.6388 10.0768 18.8402 10.3488L20.2775 12.2217L12.4009 18.2647C11.4146 17.4875 10.1852 17.0939 8.94331 17.1577C7.70138 17.2215 6.53213 17.7383 5.65473 18.6112C4.77733 19.4842 4.25203 20.6533 4.17729 21.8995C4.10255 23.1457 4.48351 24.3834 5.24874 25.3806C6.01398 26.3777 7.11097 27.0659 8.33407 27.3161C9.55717 27.5663 10.8224 27.3614 11.8926 26.7397C12.9628 26.118 13.7645 25.1223 14.1475 23.9391C14.5304 22.756 14.4682 21.4666 13.9727 20.3128L26.4221 10.7605ZM8.96694 24.8287C9.63992 24.9226 10.3184 24.7448 10.8533 24.3344C11.3881 23.9239 11.7354 23.3145 11.8187 22.6401C11.9021 21.9658 11.7147 21.2817 11.2978 20.7384C10.8809 20.1951 10.2686 19.8371 9.59559 19.7432C8.92261 19.6493 8.24408 19.8271 7.70927 20.2375C7.17445 20.6479 6.82716 21.2573 6.7438 21.9317C6.66044 22.6061 6.84783 23.2902 7.26475 23.8334C7.68167 24.3767 8.29396 24.7347 8.96694 24.8287Z" fill="#ffffff"/>
                              <circle cx="9.8806" cy="6.0847" r="3.08665" fill="#ffffff"/>
                              <circle cx="26.9128" cy="24.9719" r="3.08665" fill="#ffffff"/>
                            </svg>
                            <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none" style="position: absolute;left: 0;right: 0;bottom: 0;top: 0;">
                              <path d="M39.9221 24.4033C38.5688 22.0621 38.5698 19.1755 39.9241 16.8349C40.1873 16.3796 40.2589 15.8384 40.1231 15.3304C39.9874 14.8223 39.6554 14.389 39.2002 14.1256C36.8624 12.7744 35.412 10.2729 35.412 7.57269C35.412 7.04668 35.2031 6.54221 34.8311 6.17026C34.4592 5.79831 33.9547 5.58935 33.4287 5.58935C30.7297 5.58935 28.2299 4.14009 26.8797 1.80317C26.6168 1.34766 26.1837 1.01521 25.6758 0.878932C25.4241 0.811502 25.1617 0.794312 24.9034 0.828342C24.6451 0.862373 24.396 0.946958 24.1704 1.07727C21.8268 2.43191 18.9372 2.43084 16.594 1.07528C16.1385 0.812288 15.5972 0.741017 15.0891 0.877149C14.581 1.01328 14.1478 1.34567 13.8848 1.80118C12.5341 4.13795 10.0328 5.58935 7.33381 5.58935C6.80779 5.58935 6.30332 5.79831 5.93137 6.17026C5.55942 6.54221 5.35046 7.04668 5.35046 7.57269C5.35046 10.2717 3.89903 12.773 1.56227 14.1236C1.33663 14.254 1.13889 14.4276 0.980369 14.6345C0.821848 14.8414 0.705651 15.0774 0.63842 15.3292C0.571188 15.581 0.554242 15.8436 0.588547 16.1019C0.622853 16.3603 0.70774 16.6093 0.838354 16.8349C2.19289 19.1758 2.19289 22.0623 0.838354 24.4033C0.57653 24.859 0.505493 25.3997 0.64073 25.9076C0.775967 26.4155 1.10651 26.8493 1.56029 27.1145C3.89705 28.4652 5.34848 30.9664 5.34848 33.6654C5.34848 34.1915 5.55744 34.6959 5.92939 35.0679C6.30134 35.4398 6.80581 35.6488 7.33183 35.6488C10.0321 35.6488 12.5335 37.0991 13.8848 39.437C14.0604 39.7371 14.3111 39.9864 14.6122 40.1603C14.9134 40.3341 15.2546 40.4266 15.6024 40.4286C15.9475 40.4286 16.2906 40.3374 16.596 40.1609C18.9372 38.8062 21.8267 38.8073 24.1684 40.1609C24.6237 40.424 25.1649 40.4956 25.6729 40.3598C26.181 40.2241 26.6143 39.8921 26.8777 39.437C28.2274 37.0998 30.7278 35.6488 33.4267 35.6488C33.9527 35.6488 34.4572 35.4398 34.8291 35.0679C35.2011 34.6959 35.41 34.1915 35.41 33.6654C35.41 30.9664 36.8615 28.4652 39.1982 27.1145C39.4239 26.9841 39.6216 26.8105 39.7801 26.6036C39.9386 26.3968 40.0548 26.1607 40.1221 25.9089C40.1893 25.6571 40.2063 25.3945 40.172 25.1362C40.1376 24.8778 40.0528 24.6288 39.9221 24.4033Z" fill="url(#paint0_linear_279_28)"/>
                              <defs>
                                <linearGradient id="paint0_linear_279_28" x1="30" y1="22" x2="46.5" y2="67.5" gradientUnits="userSpaceOnUse">
                                  <stop stop-color="#F21543"/>
                                  <stop offset="1" stop-color="#8C0C27"/>
                                </linearGradient>
                              </defs>
                            </svg>
                        </span>
                        <span style="color: #242424;font-weight: bold;font-size: 17px;">پیشنهادهای داغ هفته <?php echo $city_name ?></span>
                    </h2>
                    <div style="display: flex; align-items: center;justify-content: space-between; gap: 4px; direction: ltr; margin-left: 10px" class="timestamp-box">
                        <div class="timer-box-container days-expire-count">
                            <div class="box-time-character">0</div>
                            <?php
                            $today = intval(date('w'));
                            function convertNum($num){
                                if($num >=1 && $num <= 7){
                                    return 7 - $num;
                                }
                                return null;
                            }
                            ?>
                            <div class="box-time-character"><?= convertNum($today); ?></div>
                        </div>
                        <span>:</span>
                        <div class="timer-box-container hours-expire-count">
                            <div class="box-time-character">0</div>
                            <div class="box-time-character">0</div>
                        </div>
                        <span>:</span>
                        <div class="timer-box-container minutes-expire-count">
                            <div class="box-time-character">0</div>
                            <div class="box-time-character">0</div>
                        </div>
                        <span>:</span>
                        <div class="timer-box-container seconds-expire-count">
                            <div class="box-time-character">0</div>
                            <div class="box-time-character">0</div>
                        </div>
                    </div>
                </div>

                <div dir="rtl" id="swiper_special_discount" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                    <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                        <?php echo $products; ?>
                    </div>
                </div>
            </div>
        <?php
        endif; ?>

        <style>
            .timer-box-container {
                display: flex;
                gap: 2px;
            }
            .box-time-character {
                display: flex;
                align-items: center;
                justify-content: center;
                color: white;
                font-size: 20px;
                font-weight: 900;
                border-radius: 6px;
                text-shadow: 0px 4px 4px rgba(0, 0, 0, 0.25);
                width: 30px;
                height: 30px;
                background: linear-gradient(161deg, #F21543 65.74%, #8C0C27 167.69%);
                box-shadow: 0px 4px 4px 0px rgba(0, 0, 0, 0.25);
            }
            @media screen and (max-width: 768px) {
                .event-products-header {
                    flex-direction: column;
                    gap: 10px;
                    align-items: stretch;
                }
            }
        </style>

        <script>
            jQuery(document).ready(function ($) {

                if ( location.hostname == 'escapezoom.co' ) {
                    $('.topescaperoom').each(function(i, obj) {
                        $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                        $(obj).html($res);
                    });
                }

                new Swiper("#swiper_special_discount", {
                    slidesPerView: "auto",
                    spaceBetween: 10,
                    loop: false,
                    paginationClickable: true,
                    freeMode: true,
                    pagination: {
                        el: "#special_discount_wrapper .nav1",
                        clickable: true,
                    }
                });

                var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
                var is_mobile   = $('#product_list_is_mobile').val();

                var params = {
                    'city_id' : city,
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "async": false,
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : 100,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : is_mobile,
                            'sort_type'     : 'popular',
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'only_events'   : 1,
                            'event_type'    : "discount",
                            'random'        : 1,
                            'badge_ads'     : 0,
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        setTimeout(function() {
                            $('#special_discount_wrapper .swiper-wrapper').empty();
                            $(data.products).appendTo('#special_discount_wrapper .swiper-wrapper');
                            $('#special_discount_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 1);
                    },
                });
            });

            let todayNum = `<?php echo date('w'); ?>`
            function convertNumber(num) {
                if (num >= 1 && num <= 7) {
                    return 7 - num;
                }
                return null;
            }

            function getValue(d, timePart) {
                var val = 0
                switch (timePart) {
                    case "hours":
                        val = 23 - parseInt(d.getHours());
                        break;
                    case "minutes":
                        val = 59 - parseInt(d.getMinutes())
                        break;
                    case "seconds":
                        val = 59 - parseInt(d.getSeconds())
                        break;
                    case "milliseconds":
                        val = 999 - parseInt(d.getMilliseconds())
                        break;
                    default:
                        break;
                }
                return val.toString().padStart(2, '0');
            }
            function init() {
                setInterval(function () {
                    let d = new Date();
                    let h = getValue(d, "hours");
                    let m = getValue(d, "minutes");
                    let s = getValue(d, "seconds");
                    let ms = getValue(d, "milliseconds");
                    $('.timestamp-box').each(function (){
                        let hourString = String(h).padStart(2, '0');
                        let minuteString = String(m).padStart(2, '0');
                        let secondString = String(s).padStart(2, '0');
                        let milliSecondString = String(ms).padStart(2, '0');
                        $(this).find('.hours-expire-count .box-time-character').eq(0).text(hourString.charAt(0)); // دهگان ساعت
                        $(this).find('.hours-expire-count .box-time-character').eq(1).text(hourString.charAt(1)); // یکان ساعت
                        $(this).find('.minutes-expire-count .box-time-character').eq(0).text(minuteString.charAt(0)); // دهگان دقیقه
                        $(this).find('.minutes-expire-count .box-time-character').eq(1).text(minuteString.charAt(1)); // یکان دقیقه
                        $(this).find('.seconds-expire-count .box-time-character').eq(0).text(secondString.charAt(0)); // دهگان روز
                        $(this).find('.seconds-expire-count .box-time-character').eq(1).text(secondString.charAt(1)); // یکان روز
                        $(this).find('.milliseconds-expire-count .box-time-character').eq(0).text(milliSecondString.charAt(0)); // هزارگان روز
                        $(this).find('.milliseconds-expire-count .box-time-character').eq(1).text(milliSecondString.charAt(1)); // دهگان روز
                        $(this).find('.milliseconds-expire-count .box-time-character').eq(2).text(milliSecondString.charAt(2)); // یکان روز
                    })
                }, 1);
            }
            init()
        </script>

    <?php
    endif;

    /*===============================================================*/
    // زوم کلاب

    $params = [
        'city_id'   => [$term_id],
        'monopoly'  => 1,
    ];

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'exclude_ads'   => false,
        'unpin_ads'     => true,
        'badge_ads'     => false,
        'show_more'     => 0,
        'random'        => true
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_monopoly", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#monopoly_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page = <?php echo $posts_per_page ?>;

            var is_mobile   = $('#product_list_is_mobile').val();

            var params = {
                'city_id' : city,
                'monopoly': 1
            };

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "type": "sort_products_get",
                    "data": {
                        "params"        : params,
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        "format"        : 'html_slider',
                        "is_mobile"     : is_mobile,
                        'sort_type'     : 'popular',
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                        'exclude_ads'   : 0,
                        'unpin_ads'     : 1,
                        'badge_ads'     : 0,
                        'show_more'     : 0,
                        'random'        : 1,
                    }
                },
                dataType: "json",
                success: function(data) {

                    setTimeout(function() {
                        $('#monopoly_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#monopoly_wrapper .swiper-wrapper');
                        $('#monopoly_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 1);

                },
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="monopoly_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">
            <section class="slider-single-content">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"> زوم کلاب <?php echo $city_name ?></a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"> زوم کلاب <?php echo $city_name ?></a>
                        </h2>
                    <?php endif; ?>
                </div>
            </section>
            <div dir="rtl" id="swiper_monopoly" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                <div class="swiper-wrapper">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;

    /*===============================================================*/
    // ترسناک

    if ( $product_type != 'اتاق فرار' )
        return;

    $params = [
        'city_id'   => [$term_id],
        'tag'       => [124],
    ];

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'exclude_ads'   => false,
        'unpin_ads'     => true,
        'badge_ads'     => false,
        'show_more'     => 0,
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            setTimeout(function() {
                $('#swiper_horror .swiper-wrapper').attr( "style", "transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;" );
                $('#swiper_horror .swiper-wrapper .swiper-slide').removeClass("swiper-slide-active");
            }, 50);

            var swiper = new Swiper("#swiper_horror", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#horror_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page = <?php echo $posts_per_page ?>;

            setTimeout(function() {
                $('#horror_wrapper #product_popular_sort_btn').trigger('click');
            }, 1);

            $('body').on('click', '#horror_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#horror_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');

                $('#horror_wrapper .swiper-wrapper').empty();

                var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
                var is_mobile   = $('#product_list_is_mobile').val();

                var params = {
                    'city_id' : city,
                    'tag'     : '124'.split(',')
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : is_mobile,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'exclude_ads'   : 0,
                            'unpin_ads'     : 1,
                            'badge_ads'     : 0,
                            'show_more'     : 0,
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $('#horror_wrapper .swiper-wrapper').css('display', 'none');

                        $(data.products).appendTo('#horror_wrapper .swiper-wrapper');

                        setTimeout(function() {
                            $('#horror_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 25);

                    },
                });
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="horror_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

            <section class="slider-single-content">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ترسناک <?php echo $city_name ?></a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ترسناک <?php echo $city_name ?></a>
                        </h2>
                    <?php endif; ?>
                </div>
            </section>

            <div class="shop-page-header">
                <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                    <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                        <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب ترین</a></li>
                        <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش ترین</a></li>
                        <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدیدترین</a></li>
                    </ul>

                </section>
            </div>

            <div dir="rtl" id="swiper_horror" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                <div class="swiper-wrapper">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;

    /*===============================================================*/
    // غیر ترسناک

    $params = [
        'city_id'   => [$term_id],
        'tag'       => -124,
    ];

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_slider',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'exclude_ads'   => false,
        'unpin_ads'     => true,
        'badge_ads'     => false,
        'show_more'     => 0,
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_non_horror", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#non_horror_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;

            setTimeout(function() {
                $('#non_horror_wrapper #product_popular_sort_btn').trigger('click');
            }, 1);

            $('body').on('click', '#non_horror_wrapper .shop-page-header-sort .orderby-item', function () {

                var $this       = $(this);
                var sort_type   = $this.data('id');

                $('#non_horror_wrapper .shop-page-header-sort .orderby-item').removeClass('is-active');
                $('#product_list_cur_page_num').val(2);
                $('#product_list_data_sort_type').val(sort_type);
                $this.addClass('is-active');

                $('#non_horror_wrapper .swiper-wrapper').empty();

                var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
                var is_mobile   = $('#product_list_is_mobile').val();

                var params = {
                    'city_id' : city,
                    'tag'     : '-124'
                };

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_slider',
                            "is_mobile"     : is_mobile,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'exclude_ads'   : 0,
                            'unpin_ads'     : 1,
                            'badge_ads'     : 0,
                            'show_more'     : 0,
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $('#non_horror_wrapper .swiper-wrapper').css('display', 'none');

                        $(data.products).appendTo('#non_horror_wrapper .swiper-wrapper');

                        setTimeout(function() {
                            $('#non_horror_wrapper .swiper-wrapper').css('display', 'flex');
                        }, 25);

                    },
                });
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="non_horror_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

            <div class="shop-page-header">
                <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">

                    <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                        <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب ترین</a></li>
                        <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش ترین</a></li>
                        <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدیدترین</a></li>
                    </ul>

                </section>
            </div>

            <section class="slider-single-content">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های غیرترسناک و هیجانی <?php echo $city_name ?></a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های غیرترسناک و هیجانی <?php echo $city_name ?></a>
                        </h2>                <?php endif; ?>
                </div>
            </section>

            <div dir="rtl" id="swiper_non_horror" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                <div class="swiper-wrapper">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;

    /*===============================================================*/
    // ترند

    $posts_per_page = 100;
    $params = [
        'city_id' => [$term_id],
    ];

    $args = [
        'params'        => $params,
        'image_type'        => 'url',
        'limit'             => $posts_per_page,
        'page'              => 1,
        'max_num_pages'     => true,
        "format"            => 'html_slider',
        'is_mobile'         => wp_is_mobile(),
        'sort_type'         => 'trend',
        'only_ads'          => false,
        'show_more'         => 0,
        'badge_ads'         => false,
        'random'            => true
    ];
    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_adsx", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#trends_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;

            var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
            var is_mobile   = $('#product_list_is_mobile').val();

            var params = {
                'city_id' : city,
            };

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "async": false,
                    "type": "sort_products_get",
                    "data": {
                        "params"        : params,
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        "format"        : 'html_slider',
                        "is_mobile"     : is_mobile,
                        'max_num_pages' : true,
                        'sort_type'     : 'trend',
                        'only_ads'      : 0,
                        'show_more'     : 0,
                        'badge_ads'     : 0,
                        'random'        : 1,
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                    }
                },
                dataType: "json",
                success: function(data) {
                    setTimeout(function() {
                        $('#trends_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#trends_wrapper .swiper-wrapper');
                        $('#trends_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 1);
                },
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="trends_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

            <section class="slider-single-content">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ترند <?php echo $city_name ?></a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:"><?php echo $product_type ?>های ترند <?php echo $city_name ?></a>
                        </h2>
                    <?php endif; ?>
                </div>
            </section>

            <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
                <div class="swiper-wrapper">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;

}
/****************************************************************************************************************************************/
function elite_rooms_of_tehran_func3($state) {

    $current_archive_obj = get_queried_object();
    $term_id    = $current_archive_obj->term_id;
    $term_type  = $current_archive_obj->taxonomy;

    $posts_per_page = 45;
    $type           = 'popular';

    if ( $term_type == 'product_tag' ) {
        $params = [
            'tag' => [$term_id],
        ];

    } else {

        if ( $current_archive_obj->parent == 0 ) {
            $params = [
                'product_type' => $current_archive_obj->name,
            ];

        } else {
            $params = [
                'city_id' => [$term_id],
            ];
        }
    }

    $args = [
        'params'        => $params,
        'image_type'    => 'url',
        'limit'         => $posts_per_page,
        'page'          => 1,
        'max_num_pages' => true,
        "format"        => 'html_cat',
        'is_mobile'     => wp_is_mobile(),
        'sort_type'     => 'popular',
        'unpin_ads'     => $state == 'complete' ? false : true,
        'badge_ads'     => $state == 'complete' ? true : false,
        'random'        => $state == 'complete' ? false : true,
        'random_memory' => '',
        'show_more'     => 0,
    ];

    $data = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) );

    $products = $data->products; ?>

    <script>document.body.classList.add("woocommerce");</script>
    <style>
        .load-more {
            display: none;
            margin-top: 300px;
        }
        .img-arc-mobile {
            height: auto;
            width: 100%;
            max-width: 80px!important;
        }
        .arc-box-mobile {
            border: 1px solid #eee;
            margin: 10px 0 10px;
            width: 100%;
            border-radius: 3px position: relative;
        }
        .arc-mobile-btn {
            font-size: 10px;
            height: 25px;
            width: calc(100% - 29px);
            margin-left: 30px!important;
        }
        .arc-mobile-footer {
            margin-top: -13px;
        }
        .arc-mobile-loc,.arc-mobile-price,.arc-mobile-nafar,.arc-mobile-time {
            font-size: 10px;
            font-weight: 400;
            text-align: center;
        }
        .arc-mobile-title {
            font-size: 1em !important;
            margin-right: -7px;
            font-weight: 800;
        }
        h5 {
            font-size: 14px;
            padding: 10px;
        }
        .swiper-wrapper {
            height: auto!important;
        }
        #non_slider_wrapperx li {
            padding: 10px;
            font-size: 13px;
            background: #e9e9e9;
            /*width: 100%;*/
            text-align: center;
            display: inline-block;
        }
        a.btn.btn-light.m-2 {
            width: 59px;
        }
        @media only screen and (min-width: 0px) and (max-width: 594px) {
            .media-body .arc-mobile-btn {
                width: 100% !important;
                white-space: nowrap !important;
                margin-left: 0 !important;
            }
            #non_slider_wrapperx li {
                width: 100%;
            }
        }
        @media only screen and (max-width: 600px) {
            span.special-escapezooms {
                margin-top: 85px;
                right: 63px;
            }
            span.shakes {
                right: 63px;
                margin-top: 86px;
            }
        }
        .zardkooh-shop-sort-by {
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: justify;
            justify-content: space-between;
            align-items: center;
            width: 100%;
        }
        .shop-page-header-sort {
            max-width: 414px;
            float: left;
            opacity: 1 !important;
            z-index: 99;
            display: flex;
            justify-content: flex-end;
            list-style: none;
            background-color: #fff;
            box-shadow: none;
            border-radius: 10px;
            padding: 0;
            overflow: hidden;
            align-items: center;
            height: 30px;
            margin-top: 5px;
            border: 1px solid #d5d5d5;
        }
        .shop-page-header-sort li a.is-active {
            background-color: #ee5a24;
            color: #fff;
        }
        .shop-page-header-sort li a:last-child {
            border-left: none;
        }
        .shop-page-header-sort li a {
            color: #606060;
            padding: 10px;
            border: 1px solid #d5d5d5;
        }
        .shop-page-header-sort {
            /*left: 5px;*/
            /*top: 10px;*/
        }
        .woocommerce ul.products {
            margin: 45px 0 1em;
        }
        .is-active {
            display: block!important;
        }
        #ez_cat_filter_wrapper {
            background: #fff;
            padding: 0;
            box-shadow: 0 2px 1px rgb(82 99 116 / 13%);
            border: 1px solid #eee;
            border-radius: 8px;
        }
        button#ez_cat_filter_submit {
            display: block;
            margin: 30px auto 10px;
            background: #ee5a24;
            color: #fff;
            width: 80%;
        }
        .ez_cat_filter_item_city_list, .ez_cat_filter_item_tag_list {
            appearance: auto;
        }
        .ez_cat_filter_item {
            position: relative;
            margin: 5px;
            border-radius: 8px;
        }
        .ez_cat_filter_item_slider_min {
            position: absolute;
            top: 32px;
            right: 5px;
            font-size: 13px;
        }
        .ez_cat_filter_item_slider_max {
            position: absolute;
            top: 32px;
            left: 5px;
            font-size: 13px;
        }
        .noUi-pips.noUi-pips-horizontal {
            display: none;
        }
        .ez_cat_filter_item_schedule_days_item {
            background: #fff;
            color: #323232;
            border-radius: 8px;
            width: 90px;
            display: flex;
            height: 40px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: 1px solid #80ffbe;
            transition: 0.5s;
        }
        .ez_cat_filter_item_schedule_days_item:hover {
            background: #90ffc6;
            transition: 0.5s;
        }
        #ez_cat_filter_item_schedule_days {
            display: flex;
            justify-content: space-between;
            margin: 20px 5px;
        }
        .ez_cat_filter_item_schedule_slider_wrapper {
            position: relative;
            display: none;
            justify-content: space-between;
            margin: 20px 5px 20px 0px;
        }
        .ez_cat_filter_item_schedule_days_item.is-active {
            background: #18ab60;
            display: flex !important;
            color: #fff;
        }
        .noUi-target {
            margin: 20px 10px 20px 10px;
        }
        .ez_cat_filter_item_title {
            display: block;
            font-size: 15px;
            color: #343434;
        }
        div#product_filter_item_accordion_wrapper .accordion-body {
            background: #ffffff;
        }
        .ez_cat_filter_item_body {
            color: #000;
        }
        #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_min, #ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_slider_max {
            top: 30px;
        }
        #ez_cat_filter_item_count {
            width: 90px;
        }
        #ez_cat_filter_item_level {
            width: 100%;
        }
        .ez_cat_filter_item_city_list_item *, .ez_cat_filter_item_tag_list_item * {
            cursor: pointer;
        }
        #ez_cat_filter_title {
            padding: 10px;
            display: block;
            color: #fff;
            font-size: 21px;
            background: #ee5a24;
            text-align: center;
            border-radius: 8px 8px 0 0;
            font-weight: bold;
        }
        #ez_cat_filter_item_price_max_title {
            position: absolute;
            top: -30px;
            left: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_price_min_title {
            position: absolute;
            top: -30px;
            right: 5px;
            font-size: 12px;
        }
        #ez_cat_filter_item_duration {
            width: 190px;
        }
        #ez_cat_filter_item_age {
            width: 190px;
        }
        .ez_cat_filter_item_schedule_slider_input {
            font-size: 18px !important;
            border: 1px solid #cacaca !important;
            width: 80px;
            height: 35px;
            margin: 0 4px;
            display: block;
            text-align: left;
            padding: 5px 0px 0px 29px!important;
            border-radius: 6px !important;
        }
        .ez_cat_filter_item_schedule_slider_input_wrapper {
            display: flex;
            position: relative;
        }
        .ez_cat_filter_item_schedule_slider_input_up_arrow {
            position: absolute;
            left: 4px;
            top: 0;
            cursor: pointer;
            font-size: 25px;
            padding: 1px 4px 0px 7px;
            height: 34px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_up_arrow {
            top: -2px;
        }
        .ez_cat_filter_item_schedule_slider_input:disabled {
            color: #363636 !important;
        }
        .ez_cat_filter_item_schedule_slider_input_down_arrow {
            position: absolute;
            right: 58px;
            font-size: 25px;
            top: 2px;
            cursor: pointer;
            padding: 0px 7px 0px 9px;
            height: 34px;
        }
        .remodal .ez_cat_filter_item_schedule_slider_input_down_arrow {
            top: 16px;
        }
        .ez_cat_filter_item_schedule_slider_input_title {
            display: flex;
            align-items: center;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_line {
            position: absolute;
            right: 65px;
            border-top: 1px solid #cacaca;
            width: 34px;
            top: 17px;
            rotate: 90deg;
        }
        .ez_cat_filter_item_schedule_slider_input_arrow_border {
            position: absolute;
            left: 10px;
            border-top: 1px solid #cacaca;
            width: 34px;
            top: 17px;
            rotate: 90deg;
        }
        .ez_2clmns {
            display: grid;
            grid-auto-flow: dense;
            grid-template-columns: 33% 33% 33%;
        }
        #ez_cat_filter_wrapper select {
            border: 1px solid #cacaca;
            border-radius: 6px;
            height: 30px;
        }
        .ez_cat_filter_item_city_list_item, .ez_cat_filter_item_tag_list_item {
            text-align: right;
            padding: 2px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_wrapper {
            /*width: 58px;*/
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow {
            left: 23px;
        }
        #ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow {
            right: 5px;
        }
        .woocommerce ul.products.columns-3 li.product, .woocommerce-page ul.products.columns-3 li.product {
            width: 15.5%;
        }
        #ez_cat_filter_item_schedule_today_slider_wrapper, #ez_cat_filter_item_schedule_count_slider_wrapper {
            display: flex;
        }
        .noUi-connect {
            background: #f96f0c;
        }
        #zardkooh-woo-ajax-navigation-sort-by {
            position: relative;
        }
        .swiper-pagination.nav1.swiper-pagination-clickable.swiper-pagination-bullets.swiper-pagination-horizontal {
            display: none;
        }
        .swiper-initialized{
            height: 282px !important;
        }
        .swiper-slide {
            margin-left: 10px;
        }
        @media only screen and (max-width: 600px) {
            .swiper-slide {
                margin-left: 10px;
            }
            .slider-single-content__title h2 img {
                width: 25px !important;
            }
        }
        @media only screen and (max-width: 600px){
            span.special-escapezooms {
                right: 120px !important;
                bottom: 0 !important;
            }
        }
        .filteresnewm.fade .modal-dialog {
            transform: translate3d(0, 40vh, 0) !important;
        }
        #product_filter_item_accordion_wrapper {
            margin: 5px;
        }
        #product_filter_item_accordion_wrapper .accordion-button:after {
            margin: 0 auto 0 0;
        }
        #product_filter_item_accordion_wrapper .accordion-body {
            padding: 1px 0;
        }
        #ez_cat_filter_item_schedule_count_slider_wrapper .ez_cat_filter_item_schedule_slider_input_arrow_line {
            right: 11px;
        }
        #ez_cat_filter_item_schedule_count_slider_wrapper .ez_cat_filter_item_schedule_slider_input_arrow_border {
            left: 29px;
        }
        #ez_cat_filter_item_price_wrapper .ez_cat_filter_item_body {
            margin: 40px 10px;
        }
        .accordion-item:first-of-type .accordion-button {
            background: #f3f3f3;
            border: 1px solid #e3e3e3;
            padding: 10px;
        }
        .slider-single-content__title h2 a {
            color: #242424;
            font-weight: bold;
        }
        .slider-single-content__title h2 img {
            width: 25px;
            margin: 0px 0 0 10px;
        }
        .slider-single-content__title {
            margin-bottom: 20px;
        }

        #nuwruz_wrapper {
            background: #60bb00;
            padding: 20px 10px 0px 10px;
            border: 1px solid #e3e2e2;
            border-radius: 8px;
            margin: 20px 0;
        }
        .shop-page-header-sort li:first-child a {
            border-right: none;
        }
        #single_product_sansyab_top_desc {
            text-align: justify;
            font-size: 14px;
            background: #f3f3f3;
            padding: 20px;
            border: 1px solid #e3e2e2;
            border-radius: 8px;
            margin: 20px 0;
        }
        #ez_cat_filter_item_schedule_days_wrapper span.ez_cat_filter_item_title {
            background: #f3f3f3;
            border: 2px solid #e3e3e3;
            padding: 10px;
            border-radius: 10px;
        }
        .ez-tag-title, .shakes-title {
            font-size: 17px!important;
            color: #242424;
            font-weight: bold;
        }
        .shop-page-header {
            position: absolute;
            width: 100%;
            top: 0;
            left: 0;
        }
        #product_list_resultof_sansyab{
            padding: 0px 30px 0 0;
        }
        #non_slider_wrapperx.shop-page-header {
            position: relative;
        }
        #non_slider_wrapperx .shop-page-header-sort {
            height: 30px;
        }
        .filternav {
            background: #f3f3f3;
        }
        @media only screen and (min-width: 0px) and (max-width:594px) {
            .shop-page-header-sort {
                margin-top:50px !important;
            }
            .elite_rooms_wrapper .slider-single-content {
                margin-bottom:50px;
            }
            .filternav ,.filternav a{
                font-size:15px;
            }
            #product_list_resultof_sansyab{
                padding: 0px;
            }
            #non_slider_wrapperx .shop-page-header-sort {
                height: auto;
            }
            .rb-left{
                line-height:8px;
            }
            .box-rooms img{
                height:100% !important;
            }
        }
    </style>

    <?php
    if ( $state == 'complete' ) : ?>

        <style>
            #non_slider_wrapperx .shop-page-header-sort {
                height: 30px;
            }
            .shop-page-header-sort {
                margin-top: 0 !important;
            }
            #non_slider_wrapperx li {
                width: auto;
            }
        </style>

        <div class="shop-page-header" id="non_slider_wrapperx">
            <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">
                <div class="sort-by-title"><?php //echo _e( 'Sort By', 'zardkooh' ); ?></div>

                <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                    <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item is-active" href="javascript:" data-id="default" >محبوب ترین</a></li>
                    <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش ترین</a></li>
                    <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدیدترین</a></li>
                </ul>

            </section>
        </div>

    <?php
    else :
        if (wp_is_mobile()) { ?>

            <div class="filternav" style="">
                <div class="row">
                    <div class="col-sm-6 col-6">
                        <a class="btn" data-bs-toggle="modal" data-bs-target="#advanced-filter-mobile" style="font-size: 13px;">فیلتر</a>
                        <a class="btn" data-bs-toggle="modal" data-bs-target="#sortfilteres" style="margin: 0 0 0 0;font-size: 13px;padding: 6px 10px;">مرتب سازی</a>
                    </div>
                    <div class="col-sm-6 col-6">
                        <div class="form-check form-switch">
                            <!-- SansDar Haye Emrooz -->
                            <input class="form-check-input" type="checkbox" role="switch" id="ez_cat_filter_item_schedule_today_only_toggle" style="margin-top: 0;width: 3em;height: 1.5em;">
                            <label class="form-check-label" for="flexSwitchCheckDefault" style="font-size: 11px;margin-left: 5px;">سانس دارهای امروز</label>
                        </div>

                    </div>
                </div>
            </div>

            <div class="sansyabnewm modal fade" id="filteresnew" data-bs-backdrop="filter" data-bs-keyboard="false" tabindex="-1" aria-labelledby="filteresnewlabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <!-- sansyab -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- Sort Options -->
            <div class="filteresnewm modal fade" id="sortfilteres" data-bs-backdrop="sort" data-bs-keyboard="false" tabindex="-1" aria-labelledby="sortfiltereslabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="shop-page-header" id="non_slider_wrapperx">
                                <ul class="form-select shop-page-header-sort" size="3" aria-label="size 3 select example" style="height: auto;display: flex;justify-content: center;flex-direction: column;">
                                    <li id="product_popular_sort_btn" data-id="popular" class="orderby-item">محبوب ترین</li>
                                    <li id="product_topsale_sort_btn" data-id="topsale" class="orderby-item">پرفروش ترین</li>
                                    <li id="product_recent_sort_btn" data-id="recent" class="orderby-item">جدیدترین</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        } else { ?>

            <div class="shop-page-header" id="non_slider_wrapperx">
                <section id="zardkooh-woo-ajax-navigation-sort-by" class="zardkooh-shop-sort-by yith-wcan-sort-by">
                    <div class="sort-by-title"><?php //echo _e( 'Sort By', 'zardkooh' ); ?></div>

                    <ul class="shop-page-header-sort" style="max-width: 414px; float: left; opacity: 1 !important;">
                        <li><a id="product_popular_sort_btn" data-id="popular" class="orderby-item" href="javascript:" data-id="default" >محبوب ترین</a></li>
                        <li><a id="product_topsale_sort_btn" data-id="topsale" class="orderby-item" href="javascript:" >پرفروش ترین</a></li>
                        <li><a id="product_recent_sort_btn" data-id="recent" class="orderby-item" href="javascript:" data-id="date" d>جدیدترین</a></li>
                    </ul>

                </section>
            </div>

            <?php
        }
    endif;

    if (wp_is_mobile()) { ?>
        <div class="shop-filters">

            <?php
            if ( $state == 'complete' ) : ?>
                <button type="button" class="btn btn-primary filtermob" data-bs-toggle="modal" data-bs-target="#advanced-filter-mobile" style="background: #ee5a24;color: #fff;font-size: 20px;padding: 5px;">سانس یاب</button>
            <?php
            endif; ?>

            <!-- Modal -->
            <div class="modal fade" id="advanced-filter-mobile" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-fullscreen">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="بستن"></button>
                        </div>
                        <div class="modal-body">
                            <?php
                            get_template_part('inc/template/categories_filters', ''); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    } ?>

    <ul class="products shop-page-items columns-<?php echo esc_attr( wc_get_loop_prop( 'columns' ) ); ?>" >
        <?php echo $products; ?>
    </ul>

    <input type="hidden" id="product_list_data_sort_type" value="<?php echo $type ?>">
    <input type="hidden" id="product_list_data_query_type" value="<?php echo $term_type == 'product_tag' ? 'tag' : 'cat' ?>">
    <input type="hidden" id="product_list_data_query_id" value="<?php echo $term_id ?>">
    <input type="hidden" id="product_list_cur_page_num" value="2">
    <input type="hidden" id="product_list_max_num_pages" value="<?php echo $data->max_num_pages; ?>">
    <input type="hidden" id="product_list_is_mobile" value="<?php echo wp_is_mobile() ? 1 : 0; ?>">
    <input type="hidden" id="posts_per_page" value="<?php echo $posts_per_page; ?>">

    <input type="hidden" id="product_list_filter_product_type" value="<?php if ( $term_type == 'product_cat' ) { echo $current_archive_obj->parent == 0 ? $current_archive_obj->name : -1; } else {echo -1;} ?>">
    <input type="hidden" id="product_list_filter_city_list" value="<?php echo $term_type == 'product_tag' ? -1 : $term_id ?>">
    <input type="hidden" id="product_list_filter_tag_list" value="<?php echo $term_type == 'product_tag' ? $term_id : -1 ?>">
    <input type="hidden" id="product_list_filter_count" value="-1">
    <input type="hidden" id="product_list_filter_level" value="-1">
    <input type="hidden" id="product_list_filter_age" value="-1">
    <input type="hidden" id="product_list_filter_duration" value="-1">
    <input type="hidden" id="product_list_filter_price_min" value="-1">
    <input type="hidden" id="product_list_filter_price_max" value="-1">
    <input type="hidden" id="product_list_filter_schedule_min" value="-1">
    <input type="hidden" id="product_list_filter_schedule_max" value="-1">

    <div class="loader load-more"></div>
    <span id="scroll_end"></span>

    <input type="hidden" id="product_list_memory_for_random_purposes" value="<?php echo $state == 'complete' ? -1 : implode(',', (array)$data->products_id);  ?>">
    <input type="hidden" id="product_list_type_of_request" value="<?php echo $state; ?>">

    <script>
        jQuery(document).ready(function($) {

            !function(a){"function"==typeof define&&define.amd?define([],a):"object"==typeof exports?module.exports=a():window.noUiSlider=a()}(function(){"use strict";function a(a,b){var c=document.createElement("div");return j(c,b),a.appendChild(c),c}function b(a){return a.filter(function(a){return!this[a]&&(this[a]=!0)},{})}function c(a,b){return Math.round(a/b)*b}function d(a,b){var c=a.getBoundingClientRect(),d=a.ownerDocument,e=d.documentElement,f=m();return/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(f.x=0),b?c.top+f.y-e.clientTop:c.left+f.x-e.clientLeft}function e(a){return"number"==typeof a&&!isNaN(a)&&isFinite(a)}function f(a,b,c){c>0&&(j(a,b),setTimeout(function(){k(a,b)},c))}function g(a){return Math.max(Math.min(a,100),0)}function h(a){return Array.isArray(a)?a:[a]}function i(a){a=String(a);var b=a.split(".");return b.length>1?b[1].length:0}function j(a,b){a.classList?a.classList.add(b):a.className+=" "+b}function k(a,b){a.classList?a.classList.remove(b):a.className=a.className.replace(new RegExp("(^|\\b)"+b.split(" ").join("|")+"(\\b|$)","gi")," ")}function l(a,b){return a.classList?a.classList.contains(b):new RegExp("\\b"+b+"\\b").test(a.className)}function m(){var a=void 0!==window.pageXOffset,b="CSS1Compat"===(document.compatMode||""),c=a?window.pageXOffset:b?document.documentElement.scrollLeft:document.body.scrollLeft,d=a?window.pageYOffset:b?document.documentElement.scrollTop:document.body.scrollTop;return{x:c,y:d}}function n(){return window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"}}function o(a,b){return 100/(b-a)}function p(a,b){return 100*b/(a[1]-a[0])}function q(a,b){return p(a,a[0]<0?b+Math.abs(a[0]):b-a[0])}function r(a,b){return b*(a[1]-a[0])/100+a[0]}function s(a,b){for(var c=1;a>=b[c];)c+=1;return c}function t(a,b,c){if(c>=a.slice(-1)[0])return 100;var d,e,f,g,h=s(c,a);return d=a[h-1],e=a[h],f=b[h-1],g=b[h],f+q([d,e],c)/o(f,g)}function u(a,b,c){if(c>=100)return a.slice(-1)[0];var d,e,f,g,h=s(c,b);return d=a[h-1],e=a[h],f=b[h-1],g=b[h],r([d,e],(c-f)*o(f,g))}function v(a,b,d,e){if(100===e)return e;var f,g,h=s(e,a);return d?(f=a[h-1],g=a[h],e-f>(g-f)/2?g:f):b[h-1]?a[h-1]+c(e-a[h-1],b[h-1]):e}function w(a,b,c){var d;if("number"==typeof b&&(b=[b]),"[object Array]"!==Object.prototype.toString.call(b))throw new Error("noUiSlider: 'range' contains invalid value.");if(d="min"===a?0:"max"===a?100:parseFloat(a),!e(d)||!e(b[0]))throw new Error("noUiSlider: 'range' value isn't numeric.");c.xPct.push(d),c.xVal.push(b[0]),d?c.xSteps.push(!isNaN(b[1])&&b[1]):isNaN(b[1])||(c.xSteps[0]=b[1]),c.xHighestCompleteStep.push(0)}function x(a,b,c){if(!b)return!0;c.xSteps[a]=p([c.xVal[a],c.xVal[a+1]],b)/o(c.xPct[a],c.xPct[a+1]);var d=(c.xVal[a+1]-c.xVal[a])/c.xNumSteps[a],e=Math.ceil(Number(d.toFixed(3))-1),f=c.xVal[a]+c.xNumSteps[a]*e;c.xHighestCompleteStep[a]=f}function y(a,b,c,d){this.xPct=[],this.xVal=[],this.xSteps=[d||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=b,this.direction=c;var e,f=[];for(e in a)a.hasOwnProperty(e)&&f.push([a[e],e]);for(f.length&&"object"==typeof f[0][0]?f.sort(function(a,b){return a[0][0]-b[0][0]}):f.sort(function(a,b){return a[0]-b[0]}),e=0;e<f.length;e++)w(f[e][1],f[e][0],this);for(this.xNumSteps=this.xSteps.slice(0),e=0;e<this.xNumSteps.length;e++)x(e,this.xNumSteps[e],this)}function z(a,b){if(!e(b))throw new Error("noUiSlider: 'step' is not numeric.");a.singleStep=b}function A(a,b){if("object"!=typeof b||Array.isArray(b))throw new Error("noUiSlider: 'range' is not an object.");if(void 0===b.min||void 0===b.max)throw new Error("noUiSlider: Missing 'min' or 'max' in 'range'.");if(b.min===b.max)throw new Error("noUiSlider: 'range' 'min' and 'max' cannot be equal.");a.spectrum=new y(b,a.snap,a.dir,a.singleStep)}function B(a,b){if(b=h(b),!Array.isArray(b)||!b.length)throw new Error("noUiSlider: 'start' option is incorrect.");a.handles=b.length,a.start=b}function C(a,b){if(a.snap=b,"boolean"!=typeof b)throw new Error("noUiSlider: 'snap' option must be a boolean.")}function D(a,b){if(a.animate=b,"boolean"!=typeof b)throw new Error("noUiSlider: 'animate' option must be a boolean.")}function E(a,b){if(a.animationDuration=b,"number"!=typeof b)throw new Error("noUiSlider: 'animationDuration' option must be a number.")}function F(a,b){var c,d=[!1];if(b===!0||b===!1){for(c=1;c<a.handles;c++)d.push(b);d.push(!1)}else{if(!Array.isArray(b)||!b.length||b.length!==a.handles+1)throw new Error("noUiSlider: 'connect' option doesn't match handle count.");d=b}a.connect=d}function G(a,b){switch(b){case"horizontal":a.ort=0;break;case"vertical":a.ort=1;break;default:throw new Error("noUiSlider: 'orientation' option is invalid.")}}function H(a,b){if(!e(b))throw new Error("noUiSlider: 'margin' option must be numeric.");if(0!==b&&(a.margin=a.spectrum.getMargin(b),!a.margin))throw new Error("noUiSlider: 'margin' option is only ticketinged on linear sliders.")}function I(a,b){if(!e(b))throw new Error("noUiSlider: 'limit' option must be numeric.");if(a.limit=a.spectrum.getMargin(b),!a.limit||a.handles<2)throw new Error("noUiSlider: 'limit' option is only supported on linear sliders with 2 or more handles.")}function J(a,b){switch(b){case"ltr":a.dir=0;break;case"rtl":a.dir=1;break;default:throw new Error("noUiSlider: 'direction' option was not recognized.")}}function K(a,b){if("string"!=typeof b)throw new Error("noUiSlider: 'behaviour' must be a string containing options.");var c=b.indexOf("tap")>=0,d=b.indexOf("drag")>=0,e=b.indexOf("fixed")>=0,f=b.indexOf("snap")>=0,g=b.indexOf("hover")>=0;if(e){if(2!==a.handles)throw new Error("noUiSlider: 'fixed' behaviour must be used with 2 handles");H(a,a.start[1]-a.start[0])}a.events={tap:c||f,drag:d,fixed:e,snap:f,hover:g}}function L(a,b){if(b!==!1)if(b===!0){a.tooltips=[];for(var c=0;c<a.handles;c++)a.tooltips.push(!0)}else{if(a.tooltips=h(b),a.tooltips.length!==a.handles)throw new Error("noUiSlider: must pass a formatter for all handles.");a.tooltips.forEach(function(a){if("boolean"!=typeof a&&("object"!=typeof a||"function"!=typeof a.to))throw new Error("noUiSlider: 'tooltips' must be passed a formatter or 'false'.")})}}function M(a,b){if(a.format=b,"function"==typeof b.to&&"function"==typeof b.from)return!0;throw new Error("noUiSlider: 'format' requires 'to' and 'from' methods.")}function N(a,b){if(void 0!==b&&"string"!=typeof b&&b!==!1)throw new Error("noUiSlider: 'cssPrefix' must be a string or `false`.");a.cssPrefix=b}function O(a,b){if(void 0!==b&&"object"!=typeof b)throw new Error("noUiSlider: 'cssClasses' must be an object.");if("string"==typeof a.cssPrefix){a.cssClasses={};for(var c in b)b.hasOwnProperty(c)&&(a.cssClasses[c]=a.cssPrefix+b[c])}else a.cssClasses=b}function P(a,b){if(b!==!0&&b!==!1)throw new Error("noUiSlider: 'useRequestAnimationFrame' option should be true (default) or false.");a.useRequestAnimationFrame=b}function Q(a){var b,c={margin:0,limit:0,animate:!0,animationDuration:300,format:T};b={step:{r:!1,t:z},start:{r:!0,t:B},connect:{r:!0,t:F},direction:{r:!0,t:J},snap:{r:!1,t:C},animate:{r:!1,t:D},animationDuration:{r:!1,t:E},range:{r:!0,t:A},orientation:{r:!1,t:G},margin:{r:!1,t:H},limit:{r:!1,t:I},behaviour:{r:!0,t:K},format:{r:!1,t:M},tooltips:{r:!1,t:L},cssPrefix:{r:!1,t:N},cssClasses:{r:!1,t:O},useRequestAnimationFrame:{r:!1,t:P}};var d={connect:!1,direction:"ltr",behaviour:"tap",orientation:"horizontal",cssPrefix:"noUi-",cssClasses:{target:"target",base:"base",origin:"origin",handle:"handle",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",ltr:"ltr",rtl:"rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"},useRequestAnimationFrame:!0};Object.keys(b).forEach(function(e){if(void 0===a[e]&&void 0===d[e]){if(b[e].r)throw new Error("noUiSlider: '"+e+"' is required.");return!0}b[e].t(c,void 0===a[e]?d[e]:a[e])}),c.pips=a.pips;var e=[["left","top"],["right","bottom"]];return c.style=e[c.dir][c.ort],c.styleOposite=e[c.dir?0:1][c.ort],c}function R(c,e,i){function o(b,c){var d=a(b,e.cssClasses.origin),f=a(d,e.cssClasses.handle);return f.setAttribute("data-handle",c),d}function p(b,c){return!!c&&a(b,e.cssClasses.connect)}function q(a,b){ba=[],ca=[],ca.push(p(b,a[0]));for(var c=0;c<e.handles;c++)ba.push(o(b,c)),ha[c]=c,ca.push(p(b,a[c+1]))}function r(b){j(b,e.cssClasses.target),0===e.dir?j(b,e.cssClasses.ltr):j(b,e.cssClasses.rtl),0===e.ort?j(b,e.cssClasses.horizontal):j(b,e.cssClasses.vertical),aa=a(b,e.cssClasses.base)}function s(b,c){return!!e.tooltips[c]&&a(b.firstChild,e.cssClasses.tooltip)}function t(){var a=ba.map(s);Z("update",function(b,c,d){if(a[c]){var f=b[c];e.tooltips[c]!==!0&&(f=e.tooltips[c].to(d[c])),a[c].innerHTML=f}})}function u(a,b,c){if("range"===a||"steps"===a)return ia.xVal;if("count"===a){var d,e=100/(b-1),f=0;for(b=[];(d=f++*e)<=100;)b.push(d);a="positions"}return"positions"===a?b.map(function(a){return ia.fromStepping(c?ia.getStep(a):a)}):"values"===a?c?b.map(function(a){return ia.fromStepping(ia.getStep(ia.toStepping(a)))}):b:void 0}function v(a,c,d){function e(a,b){return(a+b).toFixed(7)/1}var f={},g=ia.xVal[0],h=ia.xVal[ia.xVal.length-1],i=!1,j=!1,k=0;return d=b(d.slice().sort(function(a,b){return a-b})),d[0]!==g&&(d.unshift(g),i=!0),d[d.length-1]!==h&&(d.push(h),j=!0),d.forEach(function(b,g){var h,l,m,n,o,p,q,r,s,t,u=b,v=d[g+1];if("steps"===c&&(h=ia.xNumSteps[g]),h||(h=v-u),u!==!1&&void 0!==v)for(h=Math.max(h,1e-7),l=u;l<=v;l=e(l,h)){for(n=ia.toStepping(l),o=n-k,r=o/a,s=Math.round(r),t=o/s,m=1;m<=s;m+=1)p=k+m*t,f[p.toFixed(5)]=["x",0];q=d.indexOf(l)>-1?1:"steps"===c?2:0,!g&&i&&(q=0),l===v&&j||(f[n.toFixed(5)]=[l,q]),k=n}}),f}function w(a,b,c){function d(a,b){var c=b===e.cssClasses.value,d=c?m:n,f=c?k:l;return b+" "+d[e.ort]+" "+f[a]}function f(a,b,c){return'class="'+d(c[1],b)+'" style="'+e.style+": "+a+'%"'}function g(a,d){d[1]=d[1]&&b?b(d[0],d[1]):d[1],i+="<div "+f(a,e.cssClasses.marker,d)+"></div>",d[1]&&(i+="<div "+f(a,e.cssClasses.value,d)+">"+c.to(d[0])+"</div>")}var h=document.createElement("div"),i="",k=[e.cssClasses.valueNormal,e.cssClasses.valueLarge,e.cssClasses.valueSub],l=[e.cssClasses.markerNormal,e.cssClasses.markerLarge,e.cssClasses.markerSub],m=[e.cssClasses.valueHorizontal,e.cssClasses.valueVertical],n=[e.cssClasses.markerHorizontal,e.cssClasses.markerVertical];return j(h,e.cssClasses.pips),j(h,0===e.ort?e.cssClasses.pipsHorizontal:e.cssClasses.pipsVertical),Object.keys(a).forEach(function(b){g(b,a[b])}),h.innerHTML=i,h}function x(a){var b=a.mode,c=a.density||1,d=a.filter||!1,e=a.values||!1,f=a.stepped||!1,g=u(b,e,f),h=v(c,b,g),i=a.format||{to:Math.round};return fa.appendChild(w(h,d,i))}function y(){var a=aa.getBoundingClientRect(),b="offset"+["Width","Height"][e.ort];return 0===e.ort?a.width||aa[b]:a.height||aa[b]}function z(a,b,c,d){var f=function(b){return!fa.hasAttribute("disabled")&&(!l(fa,e.cssClasses.tap)&&(b=A(b,d.pageOffset),!(a===ea.start&&void 0!==b.buttons&&b.buttons>1)&&((!d.hover||!b.buttons)&&(b.calcPoint=b.points[e.ort],void c(b,d)))))},g=[];return a.split(" ").forEach(function(a){b.addEventListener(a,f,!1),g.push([a,f])}),g}function A(a,b){a.preventDefault();var c,d,e=0===a.type.indexOf("touch"),f=0===a.type.indexOf("mouse"),g=0===a.type.indexOf("pointer"),h=a;if(0===a.type.indexOf("MSPointer")&&(g=!0),e){if(h.touches.length>1)return!1;c=a.changedTouches[0].pageX,d=a.changedTouches[0].pageY}return b=b||m(),(f||g)&&(c=a.clientX+b.x,d=a.clientY+b.y),h.pageOffset=b,h.points=[c,d],h.cursor=f||g,h}function B(a){var b=a-d(aa,e.ort),c=100*b/y();return e.dir?100-c:c}function C(a){var b=100,c=!1;return ba.forEach(function(d,e){if(!d.hasAttribute("disabled")){var f=Math.abs(ga[e]-a);f<b&&(c=e,b=f)}}),c}function D(a,b,c,d){var e=c.slice(),f=[!a,a],g=[a,!a];d=d.slice(),a&&d.reverse(),d.length>1?d.forEach(function(a,c){var d=M(e,a,e[a]+b,f[c],g[c]);d===!1?b=0:(b=d-e[a],e[a]=d)}):f=g=[!0];var h=!1;d.forEach(function(a,d){h=R(a,c[a]+b,f[d],g[d])||h}),h&&d.forEach(function(a){E("update",a),E("slide",a)})}function E(a,b,c){Object.keys(ka).forEach(function(d){var f=d.split(".")[0];a===f&&ka[d].forEach(function(a){a.call(da,ja.map(e.format.to),b,ja.slice(),c||!1,ga.slice())})})}function F(a,b){"mouseout"===a.type&&"HTML"===a.target.nodeName&&null===a.relatedTarget&&H(a,b)}function G(a,b){if(navigator.appVersion.indexOf("MSIE 9")===-1&&0===a.buttons&&0!==b.buttonsProperty)return H(a,b);var c=(e.dir?-1:1)*(a.calcPoint-b.startCalcPoint),d=100*c/b.baseSize;D(c>0,d,b.locations,b.handleNumbers)}function H(a,b){var c=aa.querySelector("."+e.cssClasses.active);null!==c&&k(c,e.cssClasses.active),a.cursor&&(document.body.style.cursor="",document.body.removeEventListener("selectstart",document.body.noUiListener)),document.documentElement.noUiListeners.forEach(function(a){document.documentElement.removeEventListener(a[0],a[1])}),k(fa,e.cssClasses.drag),P(),b.handleNumbers.forEach(function(a){E("set",a),E("change",a),E("end",a)})}function I(a,b){if(1===b.handleNumbers.length){var c=ba[b.handleNumbers[0]];if(c.hasAttribute("disabled"))return!1;j(c.children[0],e.cssClasses.active)}a.preventDefault(),a.stopPropagation();var d=z(ea.move,document.documentElement,G,{startCalcPoint:a.calcPoint,baseSize:y(),pageOffset:a.pageOffset,handleNumbers:b.handleNumbers,buttonsProperty:a.buttons,locations:ga.slice()}),f=z(ea.end,document.documentElement,H,{handleNumbers:b.handleNumbers}),g=z("mouseout",document.documentElement,F,{handleNumbers:b.handleNumbers});if(document.documentElement.noUiListeners=d.concat(f,g),a.cursor){document.body.style.cursor=getComputedStyle(a.target).cursor,ba.length>1&&j(fa,e.cssClasses.drag);var h=function(){return!1};document.body.noUiListener=h,document.body.addEventListener("selectstart",h,!1)}b.handleNumbers.forEach(function(a){E("start",a)})}function J(a){a.stopPropagation();var b=B(a.calcPoint),c=C(b);return c!==!1&&(e.events.snap||f(fa,e.cssClasses.tap,e.animationDuration),R(c,b,!0,!0),P(),E("slide",c,!0),E("set",c,!0),E("change",c,!0),E("update",c,!0),void(e.events.snap&&I(a,{handleNumbers:[c]})))}function K(a){var b=B(a.calcPoint),c=ia.getStep(b),d=ia.fromStepping(c);Object.keys(ka).forEach(function(a){"hover"===a.split(".")[0]&&ka[a].forEach(function(a){a.call(da,d)})})}function L(a){a.fixed||ba.forEach(function(a,b){z(ea.start,a.children[0],I,{handleNumbers:[b]})}),a.tap&&z(ea.start,aa,J,{}),a.hover&&z(ea.move,aa,K,{hover:!0}),a.drag&&ca.forEach(function(b,c){if(b!==!1&&0!==c&&c!==ca.length-1){var d=ba[c-1],f=ba[c],g=[b];j(b,e.cssClasses.draggable),a.fixed&&(g.push(d.children[0]),g.push(f.children[0])),g.forEach(function(a){z(ea.start,a,I,{handles:[d,f],handleNumbers:[c-1,c]})})}})}function M(a,b,c,d,f){return ba.length>1&&(d&&b>0&&(c=Math.max(c,a[b-1]+e.margin)),f&&b<ba.length-1&&(c=Math.min(c,a[b+1]-e.margin))),ba.length>1&&e.limit&&(d&&b>0&&(c=Math.min(c,a[b-1]+e.limit)),f&&b<ba.length-1&&(c=Math.max(c,a[b+1]-e.limit))),c=ia.getStep(c),c=g(c),c!==a[b]&&c}function N(a){return a+"%"}function O(a,b){ga[a]=b,ja[a]=ia.fromStepping(b);var c=function(){ba[a].style[e.style]=N(b),S(a),S(a+1)};window.requestAnimationFrame&&e.useRequestAnimationFrame?window.requestAnimationFrame(c):c()}function P(){ha.forEach(function(a){var b=ga[a]>50?-1:1,c=3+(ba.length+b*a);ba[a].childNodes[0].style.zIndex=c})}function R(a,b,c,d){return b=M(ga,a,b,c,d),b!==!1&&(O(a,b),!0)}function S(a){if(ca[a]){var b=0,c=100;0!==a&&(b=ga[a-1]),a!==ca.length-1&&(c=ga[a]),ca[a].style[e.style]=N(b),ca[a].style[e.styleOposite]=N(100-c)}}function T(a,b){null!==a&&a!==!1&&("number"==typeof a&&(a=String(a)),a=e.format.from(a),a===!1||isNaN(a)||R(b,ia.toStepping(a),!1,!1))}function U(a,b){var c=h(a),d=void 0===ga[0];b=void 0===b||!!b,c.forEach(T),e.animate&&!d&&f(fa,e.cssClasses.tap,e.animationDuration),ha.forEach(function(a){R(a,ga[a],!0,!1)}),P(),ha.forEach(function(a){E("update",a),null!==c[a]&&b&&E("set",a)})}function V(a){U(e.start,a)}function W(){var a=ja.map(e.format.to);return 1===a.length?a[0]:a}function X(){for(var a in e.cssClasses)e.cssClasses.hasOwnProperty(a)&&k(fa,e.cssClasses[a]);for(;fa.firstChild;)fa.removeChild(fa.firstChild);delete fa.noUiSlider}function Y(){return ga.map(function(a,b){var c=ia.getNearbySteps(a),d=ja[b],e=c.thisStep.step,f=null;e!==!1&&d+e>c.stepAfter.startValue&&(e=c.stepAfter.startValue-d),f=d>c.thisStep.startValue?c.thisStep.step:c.stepBefore.step!==!1&&d-c.stepBefore.highestStep,100===a?e=null:0===a&&(f=null);var g=ia.countStepDecimals();return null!==e&&e!==!1&&(e=Number(e.toFixed(g))),null!==f&&f!==!1&&(f=Number(f.toFixed(g))),[f,e]})}function Z(a,b){ka[a]=ka[a]||[],ka[a].push(b),"update"===a.split(".")[0]&&ba.forEach(function(a,b){E("update",b)})}function $(a){var b=a&&a.split(".")[0],c=b&&a.substring(b.length);Object.keys(ka).forEach(function(a){var d=a.split(".")[0],e=a.substring(d.length);b&&b!==d||c&&c!==e||delete ka[a]})}function _(a,b){var c=W(),d=["margin","limit","range","animate","snap","step","format"];d.forEach(function(b){void 0!==a[b]&&(i[b]=a[b])});var f=Q(i);d.forEach(function(b){void 0!==a[b]&&(e[b]=f[b])}),f.spectrum.direction=ia.direction,ia=f.spectrum,e.margin=f.margin,e.limit=f.limit,ga=[],U(a.start||c,b)}var aa,ba,ca,da,ea=n(),fa=c,ga=[],ha=[],ia=e.spectrum,ja=[],ka={};if(fa.noUiSlider)throw new Error("Slider was already initialized.");return r(fa),q(e.connect,aa),da={destroy:X,steps:Y,on:Z,off:$,get:W,set:U,reset:V,__moveHandles:function(a,b,c){D(a,b,ga,c)},options:i,updateOptions:_,target:fa,pips:x},L(e.events),U(e.start),e.pips&&x(e.pips),e.tooltips&&t(),da}function S(a,b){if(!a.nodeName)throw new Error("noUiSlider.create requires a single element.");var c=Q(b,a),d=R(a,c,b);return a.noUiSlider=d,d}y.prototype.getMargin=function(a){var b=this.xNumSteps[0];if(b&&a%b)throw new Error("noUiSlider: 'limit' and 'margin' must be divisible by step.");return 2===this.xPct.length&&p(this.xVal,a)},y.prototype.toStepping=function(a){return a=t(this.xVal,this.xPct,a)},y.prototype.fromStepping=function(a){return u(this.xVal,this.xPct,a)},y.prototype.getStep=function(a){return a=v(this.xPct,this.xSteps,this.snap,a)},y.prototype.getNearbySteps=function(a){var b=s(a,this.xPct);return{stepBefore:{startValue:this.xVal[b-2],step:this.xNumSteps[b-2],highestStep:this.xHighestCompleteStep[b-2]},thisStep:{startValue:this.xVal[b-1],step:this.xNumSteps[b-1],highestStep:this.xHighestCompleteStep[b-1]},stepAfter:{startValue:this.xVal[b-0],step:this.xNumSteps[b-0],highestStep:this.xHighestCompleteStep[b-0]}}},y.prototype.countStepDecimals=function(){var a=this.xNumSteps.map(i);return Math.max.apply(null,a)},y.prototype.convert=function(a){return this.getStep(this.toStepping(a))};var T={to:function(a){return void 0!==a&&a.toFixed(2)},from:Number};return{create:S}});
            !function(e){"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?module.exports=e():window.wNumb=e()}(function(){"use strict";var o=["decimals","thousand","mark","prefix","suffix","encoder","decoder","negativeBefore","negative","edit","undo"];function w(e){return e.split("").reverse().join("")}function h(e,t){return e.substring(0,t.length)===t}function f(e,t,n){if((e[t]||e[n])&&e[t]===e[n])throw new Error(t)}function x(e){return"number"==typeof e&&isFinite(e)}function n(e,t,n,r,i,o,f,u,s,c,a,p){var d,l,h,g=p,v="",m="";return o&&(p=o(p)),!!x(p)&&(!1!==e&&0===parseFloat(p.toFixed(e))&&(p=0),p<0&&(d=!0,p=Math.abs(p)),!1!==e&&(p=function(e,t){return e=e.toString().split("e"),(+((e=(e=Math.round(+(e[0]+"e"+(e[1]?+e[1]+t:t)))).toString().split("e"))[0]+"e"+(e[1]?e[1]-t:-t))).toFixed(t)}(p,e)),-1!==(p=p.toString()).indexOf(".")?(h=(l=p.split("."))[0],n&&(v=n+l[1])):h=p,t&&(h=w((h=w(h).match(/.{1,3}/g)).join(w(t)))),d&&u&&(m+=u),r&&(m+=r),d&&s&&(m+=s),m+=h,m+=v,i&&(m+=i),c&&(m=c(m,g)),m)}function r(e,t,n,r,i,o,f,u,s,c,a,p){var d,l="";return a&&(p=a(p)),!(!p||"string"!=typeof p)&&(u&&h(p,u)&&(p=p.replace(u,""),d=!0),r&&h(p,r)&&(p=p.replace(r,"")),s&&h(p,s)&&(p=p.replace(s,""),d=!0),i&&function(e,t){return e.slice(-1*t.length)===t}(p,i)&&(p=p.slice(0,-1*i.length)),t&&(p=p.split(t).join("")),n&&(p=p.replace(n,".")),d&&(l+="-"),""!==(l=(l+=p).replace(/[^0-9\.\-.]/g,""))&&(l=Number(l),f&&(l=f(l)),!!x(l)&&l))}function i(e,t,n){var r,i=[];for(r=0;r<o.length;r+=1)i.push(e[o[r]]);return i.push(n),t.apply("",i)}return function e(t){if(!(this instanceof e))return new e(t);"object"==typeof t&&(t=function(e){var t,n,r,i={};for(void 0===e.suffix&&(e.suffix=e.postfix),t=0;t<o.length;t+=1)if(void 0===(r=e[n=o[t]]))"negative"!==n||i.negativeBefore?"mark"===n&&"."!==i.thousand?i[n]=".":i[n]=!1:i[n]="-";else if("decimals"===n){if(!(0<=r&&r<8))throw new Error(n);i[n]=r}else if("encoder"===n||"decoder"===n||"edit"===n||"undo"===n){if("function"!=typeof r)throw new Error(n);i[n]=r}else{if("string"!=typeof r)throw new Error(n);i[n]=r}return f(i,"mark","thousand"),f(i,"prefix","negative"),f(i,"prefix","negativeBefore"),i}(t),this.to=function(e){return i(t,n,e)},this.from=function(e){return i(t,r,e)})}});
            /**********************************************************/

            if ( location.hostname == 'escapezoom.co' ) {
                $res = $('.shop-page-items').html().replace(/escapezoom.ir/g, "escapezoom.co");
                $('.shop-page-items').html($res);
            }

            if ( $('#ez_cat_filter_item_schedule_today_min').length )
                $('#ez_cat_filter_item_schedule_today_min').val((new Date()).getHours());

            var max_num_pages   = parseInt( $('#product_list_max_num_pages').val() );
            var is_mobile       = $('#product_list_is_mobile').val();
            var posts_per_page  = <?php echo $posts_per_page ?>;
            var list_type       = $('#product_list_type_of_request').val();

            var ajax_processing = false;
            $(window).on('scroll', function() {

                if ( !$('#scroll_end').length ) return;

                var current_page_num    = parseInt( $('#product_list_cur_page_num').val() );
                var sort_type           = $('#product_list_data_sort_type').val();

                if ( current_page_num > max_num_pages ) return false;

                if ( isScrolledIntoView( $('#scroll_end') ) && !ajax_processing ) {

                    ajax_processing = true;

                    var product_type    = $('#product_list_filter_product_type').val();
                    var city            = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
                    var tag             = $('#product_list_filter_tag_list').val()  == -1 ? -1 : $('#product_list_filter_tag_list').val().split(',');
                    var count           = $('#product_list_filter_count').val();
                    var level           = $('#product_list_filter_level').val();
                    var age             = $('#product_list_filter_age').val();
                    var duration        = $('#product_list_filter_duration').val();
                    var price_min       = $('#product_list_filter_price_min').val();
                    var price_max       = $('#product_list_filter_price_max').val();
                    var schedule_min    = $('#product_list_filter_schedule_min').val();
                    var schedule_max    = $('#product_list_filter_schedule_max').val();

                    var params = {
                        'product_type'  : product_type,
                        'city_id'       : product_type == -1 ? city : -1,
                        'tag'           : tag,
                        'count'         : count,
                        'level'         : level,
                        'age'           : age,
                        'duration'      : duration,
                        'price'         : price_min     == -1 ? -1  : [price_min, price_max],
                        'schedule'      : schedule_min  == -1 ? -1 : [schedule_min, schedule_max],
                    };

                    var unpin_ads       = 0;
                    var badge_ads       = 1;
                    var random          = 0;
                    var random_memory   = 0;

                    if ( list_type != 'complete' ) {

                        unpin_ads   = 1;
                        badge_ads   = 0;

                        var memory_list = $('#product_list_memory_for_random_purposes').val(); // if this is empty means random mode is not enable anymore

                        if ( memory_list != -1 ) {
                            random          = 1;
                            random_memory   = memory_list;

                        } else {
                            random          = 0;
                            random_memory   = '';
                        }
                    }

                    $.ajax({
                        type: 'POST',
                        url: 'https://' + location.hostname + '/web-service/web-service.php',
                        data: {
                            "type": "sort_products_get",
                            "data": {
                                "params"        : params,
                                'image_type'    : 'url',
                                "limit"         : posts_per_page,
                                "page"          : current_page_num,
                                "format"        : 'html_cat',
                                "is_mobile"     : is_mobile,
                                'sort_type'     : sort_type,
                                'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                                'unpin_ads'     : unpin_ads,
                                'badge_ads'     : badge_ads,
                                'random'        : random,
                                'random_memory' : random_memory,
                                'show_more'     : 0,
                            }
                        },
                        dataType: "json",
                        success: function(data) {
                            $('#product_list_cur_page_num').val(++current_page_num);

                            $(data.products).appendTo('ul.shop-page-items');

                            var memory_list = $('#product_list_memory_for_random_purposes').val();
                            if ( memory_list != -1 )
                                $('#product_list_memory_for_random_purposes').val(data.products_id.join(",") + ',' + memory_list);

                            ajax_processing = false;
                        },
                    });
                }
            });
            /**********************************************************/
            $('body').on('click', '#non_slider_wrapperx .orderby-item', function (e, triggered){

                var $this       = $(this);
                var sort_type   = 'popular';

                $('#product_list_memory_for_random_purposes').val('');

                // if user clicked on one of the sort buttons the button will be active, so we won't show random display anymore.
                // this element get trigger only by 2 buttons: "only today's sanses" toggle & "result display" button of sansyab
                if ( !triggered || $($this).closest('.shop-page-header-sort').find('.orderby-item.is-active').length !== 0  ) {
                    sort_type = $this.data('id');

                    $('#product_list_memory_for_random_purposes').val(-1); //destruction of random mode
                    $('.shop-page-header-sort .orderby-item').removeClass('is-active');
                    $('#product_list_data_sort_type').val(sort_type);
                    $this.addClass('is-active');
                }

                $('#product_list_cur_page_num').val(2);

                $('.load-more').show();

                var product_type    = $('#product_list_filter_product_type').val();
                var city            = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
                var tag             = $('#product_list_filter_tag_list').val()  == -1 ? -1 : $('#product_list_filter_tag_list').val().split(',');
                var count           = $('#product_list_filter_count').val();
                var level           = $('#product_list_filter_level').val();
                var age             = $('#product_list_filter_age').val();
                var duration        = $('#product_list_filter_duration').val();
                var price_min       = $('#product_list_filter_price_min').val();
                var price_max       = $('#product_list_filter_price_max').val();
                var schedule_min    = $('#product_list_filter_schedule_min').val();
                var schedule_max    = $('#product_list_filter_schedule_max').val();

                var params = {
                    'product_type'  : product_type,
                    'city_id'       : product_type == -1 ? city : -1,
                    'tag'           : tag,
                    'count'         : count,
                    'level'         : level,
                    'age'           : age,
                    'duration'      : duration,
                    'price'         : price_min     == -1 ? -1 : [price_min, price_max],
                    'schedule'      : schedule_min  == -1 ? -1 : [schedule_min, schedule_max],
                };

                var unpin_ads   = 0;
                var badge_ads   = 1;
                var random      = 0;

                if ( list_type != 'complete' ) {

                    unpin_ads = 1;
                    badge_ads = 0;

                    var memory_list = $('#product_list_memory_for_random_purposes').val(); // if this is empty means random mode is disable.
                    if ( memory_list != -1 )
                        random = 1;
                    else
                        random = 0;
                }

                $.ajax({
                    type: 'POST',
                    url: 'https://' + location.hostname + '/web-service/web-service.php',
                    data: {
                        "type": "sort_products_get",
                        "data": {
                            "params"        : params,
                            'image_type'    : 'url',
                            "limit"         : posts_per_page,
                            "page"          : 1,
                            "format"        : 'html_cat',
                            "is_mobile"     : is_mobile,
                            'sort_type'     : sort_type,
                            'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                            'unpin_ads'     : unpin_ads,
                            'badge_ads'     : badge_ads,
                            'random'        : random,
                            'random_memory' : '',
                            'show_more'     : 0,
                        }
                    },
                    dataType: "json",
                    success: function(data) {
                        $('.load-more').hide();
                        $('ul.shop-page-items').empty();

                        if ( random && !(typeof data.products_id === "undefined") )
                            $('#product_list_memory_for_random_purposes').val(data.products_id.join(","));

                        $(data.products).appendTo('ul.shop-page-items');
                    },
                });
            });
            /**********************************************************/
            $('body').on('click', '#ez_cat_filter_submit', function () {

                if ( $('#non_slider_wrapperx .shop-page-header-sort').find('.orderby-item.is-active').length )
                    $('#non_slider_wrapperx .shop-page-header-sort').find('.orderby-item.is-active').trigger('click', true);
                else
                    $('#non_slider_wrapperx .shop-page-header-sort').find('.orderby-item[data-id=popular]').trigger('click', true);

                if ($( "#advanced-filter-mobile" ).hasClass("show"))
                    $('#ez_cat_filter_item_schedule_today_only_toggle').closest('.form-switch').remove();
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_count', function () {

                if ( $(this).val() == 'همه' )
                    $('#product_list_filter_count').val( -1 );

                else
                    $('#product_list_filter_count').val( $(this).val() );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_level', function () {
                $('#product_list_filter_level').val( $(this).val() );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_duration', function () {
                $('#product_list_filter_duration').val( $(this).val() );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_today_min', function () {

                var d       = new Date();
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_min').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_today_max', function () {

                var d       = new Date();
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_max').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_tomorrow_min', function () {

                var d       = new Date();
                d.setDate(d.getDate() + 1);
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_min').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_tomorrow_max', function () {

                var d       = new Date();
                d.setDate(d.getDate() + 1);
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_max').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_overmorrow_min', function () {

                var d       = new Date();
                d.setDate(d.getDate() + 2);
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_min').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_overmorrow_max', function () {

                var d       = new Date();
                d.setDate(d.getDate() + 2);
                var month   = d.getMonth() + 1;
                var day     = d.getDate();
                var output  = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $(this).val() + ':00';

                $('#product_list_filter_schedule_max').val(Math.floor(new Date(output).getTime() / 1000));
            });
            /**********************************************************/
            $('body').on('click', '#ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow', function () {

                var $this   = $(this);
                var cur_val = parseInt($this.siblings('.ez_cat_filter_item_schedule_slider_input').val());

                if ( $('#ez_cat_filter_item_schedule_days').find('.ez_cat_filter_item_schedule_days_item.is-active').length === 0  ) {
                    $('#ez_cat_filter_item_schedule_days_today').click();
                }

                if ( cur_val < 24 ) {
                    $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( cur_val + 1 ).trigger('change');
                }

                $('#ez_cat_filter_submit').click();

            });
            /**********************************************************/
            $('body').on('click', '#ez_cat_filter_item_schedule_days_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow', function () {

                var $this   = $(this);
                var cur_val = parseInt($this.siblings('.ez_cat_filter_item_schedule_slider_input').val());

                if ( cur_val > (new Date()).getHours() )
                    $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( cur_val - 1 ).trigger('change');

                $('#ez_cat_filter_submit').click();

            });
            /**********************************************************/
            $('body').on('click', '#ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_up_arrow', function () {

                var $this   = $(this);
                var cur_val = $this.siblings('.ez_cat_filter_item_schedule_slider_input').val();

                if ( cur_val == 'همه' ) {
                    $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( 1 ).trigger('change');

                } else {

                    cur_val = parseInt(cur_val);

                    if ( cur_val < 16 ) {
                        $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( cur_val + 1 ).trigger('change');
                    }
                }
            });
            /**********************************************************/
            $('body').on('click', '#ez_cat_filter_item_count_wrapper .ez_cat_filter_item_schedule_slider_input_down_arrow', function () {

                var $this   = $(this);
                var cur_val = parseInt($this.siblings('.ez_cat_filter_item_schedule_slider_input').val());

                if ( cur_val > 1 ) {
                    $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( cur_val - 1 ).trigger('change');
                } else {
                    $this.siblings('.ez_cat_filter_item_schedule_slider_input').val( 'همه' ).trigger('change');
                }
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_age', function () {
                $('#product_list_filter_age').val( $(this).val() );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            cities = [];
            $('body').on('change', '.ez_cat_filter_item_city_list', function () {

                if(this.checked) {
                    cities.push($(this).val());
                } else {
                    var index = cities.indexOf($(this).val());
                    if (index !== -1)
                        cities.splice(index, 1);
                }

                $('#product_list_filter_city_list').val( cities.join(",") == '' ? -1 : cities.join(",") );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            tags = [];
            $('body').on('change', '.ez_cat_filter_item_tag_list', function () {

                if(this.checked) {
                    tags.push($(this).val());
                } else {
                    var index = tags.indexOf($(this).val());
                    if (index !== -1)
                        tags.splice(index, 1);
                }

                $('#product_list_filter_tag_list').val( tags.join(",") == '' ? -1 : tags.join(",") );

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            function ez_cat_filter_item_price () {
                var $slider = $('#ez_cat_filter_item_price_slider').get(0);
                var gap     = 10000;
                var minVal  = 50000;
                var maxVal  = 350000;

                if ($slider ) {
                    noUiSlider.create($slider, {
                        start: [minVal, maxVal],
                        connect: true,
                        step: gap,
                        direction: 'rtl',
                        range: {
                            'min': minVal,
                            'max': maxVal
                        },
                        pips: {
                            mode: 'range',
                            density: gap
                        },
                        format: wNumb({
                            decimals: 0,
                            thousand: '،'
                        }),
                        ariaFormat: wNumb({
                            decimals: 0,
                            thousand: '،'
                        }),
                    });
                    $slider.noUiSlider.on('update', function (values, handle) {
                        var value = values[handle];

                        if (handle){
                            $('#ez_cat_filter_item_price_max').text(value);
                            $('#product_list_filter_price_max').val(value.split('،').join(''));
                        }
                        else {
                            $('#ez_cat_filter_item_price_min').text(value);
                            $('#product_list_filter_price_min').val(value.split('،').join(''));
                        }

                        $('.noUi-value-large').text(minVal);
                        $('.noUi-value-large:last-child').text(maxVal);

                        $('#ez_cat_filter_submit').click();
                    });
                }
            } ez_cat_filter_item_price();
            /**********************************************************/
            $('body').on('click', '.ez_cat_filter_item_schedule_days_item', function () {

                var $day = $(this).attr('id').split('ez_cat_filter_item_schedule_days_')[1];

                $('.ez_cat_filter_item_schedule_slider_wrapper').css('display', 'none');
                $('#ez_cat_filter_item_schedule_count_slider_wrapper').css('display', 'flex');
                $('.ez_cat_filter_item_schedule_days_item').removeClass('is-active');

                $('#ez_cat_filter_item_schedule_' + $day + '_slider_wrapper').css('display', 'flex');
                $(this).addClass('is-active');

                var $plus = 0;
                if ( $day == 'today' ) $plus = 0;
                if ( $day == 'tomorrow' ) $plus = 1;
                if ( $day == 'overmorrow' ) $plus = 2;

                var d = new Date();
                d.setDate(d.getDate() + $plus);
                var month       = d.getMonth() + 1;
                var day         = d.getDate();
                var date_min    = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $('#ez_cat_filter_item_schedule_' + $day + '_min').val() + ':00';
                var date_max    = d.getFullYear() + '/' + (month < 10 ? '0' : '') + month + '/' + (day < 10 ? '0' : '') + day + ' ' + $('#ez_cat_filter_item_schedule_' + $day + '_max').val() + ':00';

                $('#product_list_filter_schedule_min').val(Math.floor(new Date(date_min).getTime() / 1000));
                $('#product_list_filter_schedule_max').val(Math.floor(new Date(date_max).getTime() / 1000));

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            $('body').on('change', '#ez_cat_filter_item_schedule_today_only_toggle', function () {

                if($("#ez_cat_filter_item_schedule_today_only_toggle").prop('checked') == true) {
                    $('#ez_cat_filter_item_schedule_days_today').click();

                } else {
                    $('#product_list_filter_schedule_min').val(-1);
                    $('#product_list_filter_schedule_max').val(-1);
                }

                $('#ez_cat_filter_submit').click();
            });
            /**********************************************************/
            $('body').on('click', '#non_slider_wrapperx .orderby-item', function () {
                $('#sortfilteres').modal('hide');
            });
            /**********************************************************/
            $('body').on('click', '#product_list_mobile_get_res_btn', function () {
                $('#ez_cat_filter_wrapper .btn-close').click();
            });
        });
        /**********************************************************/
        function isScrolledIntoView(elem) {
            var docViewTop = $(window).scrollTop();
            var docViewBottom = docViewTop + $(window).height();
            var elemTop = $(elem).offset().top - 100;
            var elemBottom = elemTop + $(elem).height();

            return ( elemBottom <= docViewBottom );
        }
    </script>

    <?php
}
/****************************************************************************************************************************************/
function get_deactivated_rooms() {

    $current_archive_obj = get_queried_object();
    $term_id = $current_archive_obj->term_id;

    if ( $current_archive_obj->parent == 0 )
        $product_type = get_term( $current_archive_obj )->name;
    else
        $product_type = get_term( $current_archive_obj->parent )->name;

    $posts_per_page = 100;
    $params = [
        'city_id' => [$term_id],
    ];

    $args = [
        'params'            => $params,
        'image_type'        => 'url',
        'limit'             => $posts_per_page,
        'page'              => 1,
        'max_num_pages'     => true,
        "format"            => 'html_slider',
        'is_mobile'         => wp_is_mobile(),
        'sort_type'         => 'recent',
        'deactivate'        => true,
        'only_ads'          => false,
        'show_more'         => 0,
        'badge_ads'         => false,
        'random'            => true
    ];
    $data = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) );
    $products = $data->products; ?>

    <script>
        jQuery(document).ready(function ($) {

            if ( location.hostname == 'escapezoom.co' ) {
                $('.topescaperoom').each(function(i, obj) {
                    $res = $(obj).html().replace(/escapezoom.ir/g, "escapezoom.co");
                    $(obj).html($res);
                });
            }

            var swiper = new Swiper("#swiper_adsx", {

                <?php if ( wp_is_mobile() ) : ?>
                slidesPerView: 2.5,

                <?php else : ?>
                slidesPerView: 7.5,

                <?php endif; ?>

                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
                pagination: {
                    el: "#deactivated_wrapper .nav1",
                    clickable: true,
                }
            });

            var posts_per_page  = <?php echo $posts_per_page ?>;
            var sort_type   = 'popular';

            var city        = $('#product_list_filter_city_list').val() == -1 ? -1 : $('#product_list_filter_city_list').val().split(',');
            var is_mobile   = $('#product_list_is_mobile').val();

            var params = {
                'city_id' : city,
            };

            $.ajax({
                type: 'POST',
                url: 'https://' + location.hostname + '/web-service/web-service.php',
                data: {
                    "async": false,
                    "type": "sort_products_get",
                    "data": {
                        "params"        : params,
                        'image_type'    : 'url',
                        "limit"         : posts_per_page,
                        "page"          : 1,
                        "format"        : 'html_slider',
                        "is_mobile"     : is_mobile,
                        'max_num_pages' : true,
                        'sort_type'     : 'recent',
                        'deactivate'    : true,
                        'only_ads'      : 0,
                        'show_more'     : 0,
                        'badge_ads'     : 0,
                        'random'        : 1,
                        'url'           : '<?php echo $_SERVER['HTTP_HOST'] ?>',
                    }
                },
                dataType: "json",
                success: function(data) {
                    setTimeout(function() {
                        $('#deactivated_wrapper .swiper-wrapper').empty();
                        $(data.products).appendTo('#deactivated_wrapper .swiper-wrapper');
                        $('#deactivated_wrapper .swiper-wrapper').css('display', 'flex');
                    }, 1);
                },
            });
        });
    </script>

    <?php
    if ( !empty( $products ) ) : ?>

        <div id="deactivated_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2;">

            <section class="slider-single-content">
                <div class="slider-single-content__title slidertitleh2">
                    <div class=" swiper-pagination nav1"></div>
                    <?php if (wp_is_mobile()) : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:;">رزرو غیرفعال</a>
                        </h2>
                    <?php else : ?>
                        <h2>
                            <img style="width: 25px!important;" src="http://escapezoom.ir/wp-content/uploads/2023/08/escapezoom_tiny_logo.png">
                            <a href="javascript:;">رزرو غیرفعال</a>
                        </h2>
                    <?php endif; ?>
                </div>
            </section>

            <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom">
                <div class="swiper-wrapper">
                    <?php echo $products; ?>
                </div>
            </div>
        </div>

    <?php
    endif;
}
/****************************************************************************************************************************************/
add_action('wp', 'comment_privacy_system_token_verify_redirect');
function comment_privacy_system_token_verify_redirect() {

    $term = substr($_SERVER['REQUEST_URI'], 1);

    if ( isset( $_GET['cm'] ) && !empty( $_GET['cm'] ) ) {
        $token = $_GET['cm'];

        $order_id       = base64_url_decode(substr($token, 7));
        $saved_token    = get_post_meta($order_id, 'comment_token', true);

        if ( $token == $saved_token ) {
            $exp_time = get_post_meta($order_id, 'comment_token_exp', true);

            if ( $exp_time > time() || 1 ) {
                $product_id = get_post_meta($order_id, 'code_otagh', true);
                wp_redirect( "https://escapezoom.ir/?p=$product_id&set_cm=$token#modal_zn-one" );

            } else { ?>

                <script>alert('پوزش! فرصت شما برای نوشتن نظر به پایان رسیده است!')</script>
                <?php
            }
        }

    } else if ( str_starts_with($term, 'cm=') ) {

        $token = substr($term, 3);

        $order_id       = base64_url_decode(substr($token, 7));
        $saved_token    = get_post_meta($order_id, 'comment_token', true);

        if ( $token == $saved_token ) {

            $exp_time = get_post_meta($order_id, 'comment_token_exp', true);

            if ( $exp_time > time() || 1 ) {
                $product_id = get_post_meta($order_id, 'code_otagh', true);
                wp_redirect( "https://escapezoom.ir/?p=$product_id&set_cm=$token#modal_zn-one" );

            } else { ?>

                <script>alert('پوزش! فرصت شما برای نوشتن نظر به پایان رسیده است!')</script>
                <?php
            }
        }

    }
}
/****************************************************************************************************************************************/
add_action('add_meta_boxes', 'rating_in_details_admin_metabox');
function rating_in_details_admin_metabox() {
    add_meta_box('cld-count-info1', 'karen', 'rating_in_details_admin_html', 'comment', 'normal');
}
/******************/
function rating_in_details_admin_html($comment) {
    $comment_id = $comment->comment_ID;

    $product_rates = get_comment_meta($comment_id, "comment_rating", true);

    defined('ABSPATH') or die('No script kiddies please!!');
    wp_nonce_field('cld_metabox_nonce1', 'cld_metabox_nonce1_field'); ?>

    <div class="cld-field-wrap">
        <label>فضاسازی</label>
        <div class="cld-field">
            <select name="fazasazi">
                <?php
                for ( $i = 1; $i <= 5; $i++ ) : ?>
                    <option <?php echo $product_rates[1094] / 20 == $i ? 'selected="selected"' : ''; ?> value="<?php echo $i ?>"><?php echo $i ?></option>
                <?php
                endfor;?>
            </select>
        </div>
    </div>

    <div class="cld-field-wrap">
        <label>کیفیت معما</label>
        <div class="cld-field">
            <select name="moama">
                <?php
                for ( $i = 1; $i <= 5; $i++ ) : ?>
                    <option <?php echo $product_rates[1095] / 20 == $i ? 'selected="selected"' : ''; ?> value="<?php echo $i ?>"><?php echo $i ?></option>
                <?php
                endfor;?>
            </select>
        </div>
    </div>

    <div class="cld-field-wrap">
        <label>تازگی و خلاقیت</label>
        <div class="cld-field">
            <select name="tazegi">
                <?php
                for ( $i = 1; $i <= 5; $i++ ) : ?>
                    <option <?php echo $product_rates[1098] / 20 == $i ? 'selected="selected"' : ''; ?> value="<?php echo $i ?>"><?php echo $i ?></option>
                <?php
                endfor;?>
            </select>
        </div>
    </div>

    <div class="cld-field-wrap">
        <label>بازیگردانی و اکت</label>
        <div class="cld-field">
            <select name="act">
                <?php
                for ( $i = 1; $i <= 5; $i++ ) : ?>
                    <option <?php echo $product_rates[1096] / 20 == $i ? 'selected="selected"' : ''; ?> value="<?php echo $i ?>"><?php echo $i ?></option>
                <?php
                endfor;?>
            </select>
        </div>
    </div>

    <div class="cld-field-wrap">
        <label>برخورد پرسنل</label>
        <div class="cld-field">
            <select name="personel">
                <?php
                for ( $i = 1; $i <= 5; $i++ ) : ?>
                    <option <?php echo $product_rates[1097] / 20 == $i ? 'selected="selected"' : ''; ?> value="<?php echo $i ?>"><?php echo $i ?></option>
                <?php
                endfor;?>
            </select>
        </div>
    </div>

    <?php
}
/******************/
add_action('edit_comment', 'saving_rating_in_details_admin');
function saving_rating_in_details_admin($comment_id) {
    $nonce_name     = isset($_POST['cld_metabox_nonce1_field']) ? $_POST['cld_metabox_nonce1_field'] : '';
    $nonce_action   = 'cld_metabox_nonce1';

    if (!wp_verify_nonce($nonce_name, $nonce_action))
        return;

    if (isset($_POST['fazasazi'], $_POST['moama'])) {

        update_comment_meta($comment_id, 'comment_rating', [
            '1094' => $_POST['fazasazi'] * 20,
            '1095' => $_POST['moama'] * 20,
            '1098' => $_POST['tazegi'] * 20,
            '1096' => $_POST['act'] * 20,
            '1097' => $_POST['personel'] * 20,
        ]);

        return $comment_id;
    } else
        return $comment_id;
}
/****************************************************************************************************************************************/
function randString($length) {
    $char = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $char = str_shuffle($char);
    for($i = 0, $rand = '', $l = strlen($char) - 1; $i < $length; $i ++) {
        $rand .= $char[random_int(0, $l)];
    }
    return $rand;
}
/****************************************************************************************************************************************/
function base64_url_encode($input) {
    return strtr(base64_encode($input), '+/=', '._-');
}
/****************************************************************************************************************************************/
function base64_url_decode($input) {
    return base64_decode(strtr($input, '._-', '+/='));
}
/****************************************************************************************************************************************/
add_filter( 'woocommerce_checkout_fields', function($fields) {
    if ( is_checkout() ) {
        if ( isset( $_GET['quantity'] ) ) {
            $quantity = $_GET['quantity'];

            $quantity_org = $quantity + 1;
            $counter = $quantity_org - $quantity + 1;

            while ( $quantity - 1 && $counter <= 4 ) {
                $counter = $quantity_org - $quantity + 1;

                $fields['billing']['billing_heading_name'] = array(
                    'type'      => 'heading',
                    'label'     => 'پیشنهاد می کنیم شماره سایر اعضاء تیم را نیز وارد کنید تا امکان درج بازخورد و امتیاز دهی به اتاق فرار را داشته باشند. ما پیامک تبلیغاتی ارسال نمیکنیم',
                );

                $fields['billing']["players_phone_$counter"] = array(
                    'type'          => 'tel',
                    'label'         => "تلفن نفر شماره $counter تیم",
                    'placeholder'   => "لطفا موبایل نفر شماره $counter تیم را وارد کنید..",
                    'required'      => false,
                    'class'         => array('checkout_players_phone_field'),
                    'clear'         => true,
                    'maxlength'     => "11"
                );

                $quantity--;
            }
        }
    }

    return $fields;
});
/****************************************************************************************************************************************/
add_filter( 'woocommerce_form_field_heading','sc_woocommerce_form_field_heading', 10, 4 );
function sc_woocommerce_form_field_heading($field, $key, $args, $value) {
    $output = '<h3 class="form-row chkout_players_phone_desc">'.__( $args['label'], 'woocommerce' ).'</h3>';
    echo $output;
}
/****************************************************************************************************************************************/
add_action( 'woocommerce_checkout_update_order_meta', 'send_sms_comment_url');
function send_sms_comment_url( $order_id ) {

    $players_phone      = [];
    $players_phone[]    = $_POST['billing_phone'];

    foreach($_POST as $key => $post)
        if ( str_contains($key, 'players_phone') )
            if ( !empty( sanitize_text_field( $_POST[$key] ) ) )
                $players_phone[] = sanitize_text_field( $_POST[$key] );

    $improved_players_phone = [];
    foreach ( $players_phone as $player_phone ) {

        $persian        = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english        = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        $player_phone   = str_replace($persian, $english, $player_phone);
        $player_phone   = preg_replace('/^\+?98|\|98|\D/', '', ($player_phone));
        $player_phone   = ltrim($player_phone, '0');

        $improved_players_phone[] = '0' . $player_phone;
    }

    add_post_meta($order_id, 'players_phone', $improved_players_phone);
    add_post_meta($order_id, 'comment_token', randString(7) . base64_url_encode($order_id));
}
/****************************************************************************************************************************************/
//add_action('admin_menu', 'owner_comment_report_menu');
function owner_comment_report_menu() {
    $notification_count = 2; // <- here you should get correct count of forms submitted since last visit

    add_menu_page(
        'ریپورت نظرات',
        $notification_count ? sprintf('ریپورت نظرات<span class="awaiting-mod">%d</span>', $notification_count) : 'ریپورت نظرات',
        'administrator',
        'owner-comment-report',
        'owner_comment_report_page_handler'
    );
}
/****************************************************************************************************************************************/
add_action('wp', 'save_owner_comment_report_message');
function save_owner_comment_report_message() {
    if ( isset( $_POST['cm_report_subject'] ) && !empty( $_POST['cm_report_subject'] ) && isset( $_POST['cm_report_text'] ) && !empty( $_POST['cm_report_text'] ) ) {

        if ( isset( $_POST['cm_id'] ) && isset( $_POST['cm_roomid'] ) )

            $comment_id = htmlspecialchars( $_POST['cm_id'] );
        $subject    = htmlspecialchars( $_POST['cm_report_subject'] );
        $content    = htmlspecialchars( $_POST['cm_report_text'] );

        add_comment_meta( $comment_id, 'owner_report', [$subject, $content], true );
    }
}
/****************************************************************************************************************************************/
function vpn_turn_off_msg () {
//    $details = json_decode(file_get_contents("http://ip-api.com/json/{$_SERVER['REMOTE_ADDR']}"));
//    if ( $details->country != 'Iran' ) : ?>
    <!--        <div id="turn_off_vpnx" style="background: #8b0000;padding: 10px;color: #fff;text-align: center;font-weight: bold;">کاربر گرامی جهت لود سریعتر سایت لطفاً VPN خود را خاموش کنید.</div>-->
    <!--    --><?php
//    endif;
}
/****************************************************************************************************************************************/
if ( isset($_GET['utm_source']) && $_GET['utm_source'] == 'co' ) {
    session_start();
    $_SESSION["co_referrer"] = true;
}
/****************************************************************************************************************************************/
add_shortcode('thankyouco', 'thankyouco');
function thankyouco () { ?>

    <div class="woocommerce-order">
        <section class="woocommerce-checkout-alert">
            <div class="woocommerce-checkout-alert-icon success"><i></i></div>
        </section>

        <section class="woocommerce-checkout-details">
            <div class="woocommerce-checkout-details-title">
                <div class="woocommerce-checkout-details-row">
                    <style> .woocommerce-checkout-details-col-table {
                            display: none;
                        }
                        .coupon-frame {
                            display: flex;
                            justify-content: center;
                            width: 100%;
                            flex-wrap: wrap;
                        }
                        .coupon-code {
                            background-color: #ffffff;
                            width: 150px;
                            margin: 10px;
                            text-align: center;
                            line-height: 40px;
                            font-family: sans-serif;
                        }
                        .coupon-code > img {
                            border-bottom: 3px dashed #eee;
                        }
                        section.woocommerce-customer-details {
                            display: none;
                        }
                        #content > div > div > div > section.woocommerce-checkout-alert > div.woocommerce-checkout-alert-content > p, div#tpbr_topbar {
                            display: none !important;
                        }
                        .coupon-frame, h4.tac {
                            display: none !important;
                        }
                    </style>
                    <h2 class="tac" style=" font-size: 1.3em; ">سانس شما رزرو شد. اوقات خوشی رو برای شما آرزومندیم.<br>

                        نام اتاق فرار رزرو شده بهمراه ساعت و تاریخ آن برای شما پیامک شده است.

                        جهت دریافت آدرس دقیق، می توانید با شماره تلفنی که برای شما پیامک شده است  تماس بگیرید.</h2>

                    </p>
                </div>
            </div>
        </section>
    </div>
    <?php
}
/****************************************************************************************************************************************/
// partial paid
add_action('woocommerce_review_order_after_order_total', 'ez_review_order_prices_table');
function ez_review_order_prices_table($order) {

    $product_id = 0;
    $quantity   = 0;
    foreach ( WC()->cart->get_cart_contents() as $cart_item ) {
        $product_id = $cart_item['product_id'];
        $quantity   = $cart_item['quantity'];
    }

    $pish_per_person    = get_post_meta( $product_id, 'pish_pardakht_per_person', true );
    $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;
    $asli               = '';

    $day_type   = get_day_type($_SESSION['book']);
    $sanses     = get_sanses($product_id);

    foreach ( $sanses[$day_type] as $sans )
        if ( date("H:i", $_SESSION['book']) == $sans['time'] )
            $asli = $sans['off_price'] ? : $sans['price'];

    if ( get_post_meta($product_id, 'special_discount_enable', true) )
        if ( get_post_meta($product_id, 'special_discount_date', true) > time() )
            $asli = (int)$asli * ( 1 - get_post_meta($product_id, 'special_discount_percentage', true) / 100); ?>

    <tr class="order-paid">
        <th>کل مبلغ</th>
        <td data-title="کل مبلغ">
            <strong><?php echo wc_price((int)$asli * $quantity); ?></strong>
        </td>
    </tr>

    <tr class="order-remaining">
        <th>مانده پرداخت بصورت حضوری</th>
        <td data-title="مانده پرداخت بصورت حضوری">
            <strong><?php echo wc_price((int)$asli * $quantity - $pish_per_person * (int)$asli); ?></strong>
        </td>
    </tr>

    <?php
}
/*=====================================================================*/
add_filter('woocommerce_calculated_total', 'ez_final_payment_amount', 10, 2); // مبلغ پیش پرداخت(آنلاین)
function ez_final_payment_amount( $total, $cart ) {

    if ( isset( $_SESSION['book'] ) ) {

        $product_id = 0;
        foreach (WC()->cart->get_cart_contents() as $cart_item)
            $product_id = $cart_item['product_id'];

        $pish_per_person    = get_post_meta( $product_id, 'pish_pardakht_per_person', true );
        $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;
        $asli               = '';

        $day_type   = get_day_type($_SESSION['book']);
        $sanses     = get_sanses($product_id);

        foreach ( $sanses[$day_type] as $sans )
            if ( date("H:i", $_SESSION['book']) == $sans['time'] )
                $asli = $sans['off_price'] ? : $sans['price'];

        if ( get_post_meta($product_id, 'special_discount_enable', true) )
            if ( get_post_meta($product_id, 'special_discount_date', true) > time() )
                $asli = (int)$asli * ( 1 - get_post_meta($product_id, 'special_discount_percentage', true) / 100);

        $final_amount = $pish_per_person * (int)$asli;

        if ( ! empty( WC()->cart->get_coupons() ) ) {
            foreach ( WC()->cart->get_coupons() as $code => $coupon ) {
                $discount_amount = WC()->cart->get_coupon_discount_amount( $code );
                $final_amount -= $discount_amount;
                saeed_store([WC()->cart, $cart]);

            }
        }

        return max( $final_amount, 0 );
    }

    $coupon_amount = reset($cart->coupon_discount_totals); // به دست آوردن مقدار کد تخفیف

    $pre_paid = WC()->session->get('prepaid') - $coupon_amount;

    if ($pre_paid < 0)
        $pre_paid = 0;

    return $pre_paid; // مبلغی که از سمت سرویس api به اینجا پاس داده شده را به عنوان مبلغ نهایی برای پرداخت ست کن
}
/******************************/
if ( get_current_user_id() == 3325 || 1 ) {

//    add_filter( 'woocommerce_product_get_price', 'get_products_price_from_custom_meta', 10, 2 );
//    add_filter( 'woocommerce_product_get_regular_price', 'get_products_price_from_custom_meta', 10, 2 );
    function get_products_price_from_custom_meta( $price, $product ) {
        $product_id = $product->get_id();

        if ( WC()->session == null )
            return $price;

        $sans_time = WC()->session->get('sans_time');

        foreach ( get_sanses($product_id)[get_day_type($sans_time)] as $sans )
            if ( date("H:i", $sans_time) == $sans['time'] )
                $asli = $sans['off_price'] ? : $sans['price'];

        return (int)$asli;
    }

//    add_filter( 'woocommerce_product_get_sale_price', 'get_products_saleprice_from_custom_meta', 10, 2 );
    function get_products_saleprice_from_custom_meta( $price, $product ) {
        if ( $product->get_id() == 5104 ) {
            return 40;
        }

        return $price;
    }
}
/******************************/
add_action( 'woocommerce_payment_complete', 'my_change_status_function' );
function my_change_status_function( $order_id ) {

    $order = wc_get_order( $order_id );
    $order->update_status( 'wc-partially-paid' );

    add_post_meta($order_id, '_order_total_2', get_post_meta($order_id, '_order_total', true)); // use this as an element which is not gonna change

    $product_id = '';
    foreach ($order->get_items() as $product )
        $product_id = $product['product_id'];

    $pish_per_person    = get_post_meta( $product_id, 'pish_pardakht_per_person', true );
    $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;
    add_post_meta($order_id, 'ticket_tedad', $pish_per_person); // use this for accounting to store original value
}
/****************************************************************************************************************************************/
// comment phones list helper function
function ez_cm_add_phone ($product_id, $order_id, $phone) {
    global $wpdb;

    $wpdb->insert( 'comment_phones_list', array('product_id' => $product_id, 'order_id' => $order_id, 'phone' => $phone));

    return $wpdb->insert_id ? true : false;
}
/********************************************************************************************************************************/
function ez_cm_get_order_id ( $product_id, $phone ) {
    global $wpdb;

    $res = $wpdb->get_results( $wpdb->prepare("SELECT * FROM comment_phones_list WHERE product_id Like " . "'" . $product_id . "' AND phone LIKE " . "'" . $phone . "'"));

    return $res;
}
/****************************************************************************************************************************************/
add_filter( 'wc_order_is_editable', 'wc_make_processing_orders_editable', 99, 2 );
function wc_make_processing_orders_editable( $is_editable, $order ) {
    return true;
}
/****************************************************************************************************************************************/
add_filter( 'wpseo_canonical', '__return_false' );
/****************************************************************************************************************************************/
add_action( 'woocommerce_before_calculate_totals', 'controle_before_place_order' );
function controle_before_place_order() {
    if ( is_checkout() ) :

        if ( isset( $_GET['book'] ) || !empty( $_GET['book'] )  ) {

            $_SESSION['book']       = htmlspecialchars($_GET['book']);
            $_SESSION['quantity']   = htmlspecialchars($_GET['quantity']);
            $_SESSION['product_id'] = htmlspecialchars($_GET['add-to-cart']);;
            $_SESSION['user_id']    = get_current_user_id();
            $_SESSION['c_time']     = time();
        }

    endif;
}
/****************************************************************************************************************************************/
function ez_add_booking_lock ($product_id, $booking_time) {
    global $wpdb;

    $wpdb->insert( 'booking_lock_schedule', array(
        'product_id'    => $product_id,
        'booking_time'  => $booking_time,
        'lock_time'     => time(),
    ));

    return $wpdb->insert_id ? true : false;
}
/********************************************************************************************************************************/
function ez_remove_booking_lock ( $product_id, $booking_time ) {
    global $wpdb;

    $wpdb->get_results( $wpdb->prepare (
        "DELETE FROM booking_lock_schedule WHERE product_id Like " . "'" . $product_id . "' AND booking_time Like " . "'" . $booking_time . "'"
    ) );
}
/********************************************************************************************************************************/
function ez_get_booking_lock ( $product_id ) {
    global $wpdb;

    $res = $wpdb->get_results( $wpdb->prepare(
        "SELECT * FROM booking_lock_schedule WHERE product_id LIKE " . "'" . $product_id . "'"
    ));

    return $res;
}
/****************************************************************************************************************************************/
add_action( 'woocommerce_checkout_order_processed', 'detect_zibal_payment_method_for_lock' );
function detect_zibal_payment_method_for_lock( $order_id ) {

    $order = wc_get_order( $order_id );

    $product_id = '';
    foreach ($order->get_items() as $product )
        $product_id = $product['product_id'];

    $payment_method = $order->get_payment_method_title();
    if ( $payment_method == 'پرداخت امن آنلاین' || $payment_method == 'پرداخت اینترنتی' || $payment_method == 'پرداخت آنلاین' )
        ez_reservation( array('type' => 'add_sans_lock', 'data' => array('product_id' => $product_id, 'booking_time' => $_SESSION['book'])) );
}
/****************************************************************************************************************************************/
add_action( 'wp', 'visit_single_room_unlock_booking' );
function visit_single_room_unlock_booking() {

    if ( get_post_type() == 'product' ) {
        $product_id = get_the_ID();
        $bookings   = ez_get_booking_lock($product_id);

        foreach ( $bookings as $booking ) {
            if ( $booking->booking_time < time() || $booking->lock_time + (60 * 5) < time() ) { // if 5 mins has finished
                ez_remove_booking_lock( $product_id, $booking->booking_time );
            }
        }
    }
}
/****************************************************************************************************************************************/
add_action( 'wp', 'tracking_back_btn_in_checkout_page' );
function tracking_back_btn_in_checkout_page() {

    if ( is_checkout() ) { ?>

        <script>
            // add parameter to url for detecting if the user pressed back btn
            window.addEventListener( "pageshow", function ( e ) {
                if ( e.persisted || ( typeof window.performance != "undefined" && window.performance.navigation.type === 2 ) ) {
                    var url = window.location.href;
                    if (url.indexOf('?') > -1)
                        url += '&back=1'
                    else
                        url += '?back=1'

                    window.location.href = url;
                }
            });
        </script>

        <?php
        if ( isset( $_GET['back'] ) && !empty( $_GET['back'] ) ) {
            ez_reservation( array('type' => 'remove_sans_lock', 'data' => array('product_id' => $_GET['add-to-cart'], 'booking_time' => $_GET['book'])) );
//            ez_remove_booking_lock( $_GET['add-to-cart'], $_GET['book'] );
        }
    }
}
/****************************************************************************************************************************************/
//add_action( 'wp_footer', 'checkout_place_order_script' );
function checkout_place_order_script() {
    if( is_checkout() && ! is_wc_endpoint_url() ): ?>

        <script>
            var $ = jQuery;
            jQuery(document).ready(function () {
                var fc          = 'form.checkout';
                var pl          = 'button[type="submit"][name="woocommerce_checkout_place_order"]';
                var ajax_url    = needs_localize.ajaxurl;
                var nonce       = needs_localize.security;

                $(fc).on( 'submit', pl, function(e){
                    e.preventDefault(); // Disable "Place Order" button

                    $.ajax({
                        type    : 'POST',
                        url     : ajax_url,
                        data    : {
                            'action'                : 'ez_site_ajax_handler',
                            'nonce'                 : nonce,
                            '_checkout_sessions_'   : true,
                            'book'                  : <?php echo htmlspecialchars($_GET['book']); ?>,
                            'quantity'              : <?php echo htmlspecialchars($_GET['quantity']); ?>,
                            'product_id'            : <?php echo htmlspecialchars($_GET['add-to-cart']); ?>,
                            'user_id'               : <?php echo get_current_user_id(); ?>,
                            'c_time'                : <?php echo time(); ?>,
                        },
                        dataType: "json",
                        success: function(data) {
                            $('body').trigger('update_checkout');
                        },
                    });
                });
            });
        </script>
    <?php
    endif;
}
/****************************************************************************************************************************************/
add_action('woocommerce_after_checkout_validation', 'conflict_before_place_order_validation');
function conflict_before_place_order_validation() {

    $booking_details = json_decode(str_replace('\\', '', $_POST['booking_details']));
    $booking_details = json_decode(json_encode($booking_details), true);

    if ( isset( $booking_details['book'] ) || !empty( $booking_details['book'] )  ) { // ensure if the session has correct data and not empty
        $_SESSION['book']       = htmlspecialchars($booking_details['book']);
        $_SESSION['quantity']   = htmlspecialchars($booking_details['quantity']);
        $_SESSION['product_id'] = htmlspecialchars($booking_details['add-to-cart']);;
    }

    /*======================*/

    $product_id = '';
    foreach ( WC()->cart->get_cart_contents() as $cart_item )
        $product_id = $cart_item['product_id'];

    $bookings_objs = json_decode(ez_reservation( array('type' => 'get_sans_lock', 'data' => array('product_id' => $product_id)) ));

    $bookings = [];
    if ( !empty( $bookings_objs ) )
        foreach ( $bookings_objs as $booking )
            $bookings[] = $booking->booking_time;

    if ( in_array($_SESSION['book'], (array)$bookings) )
        wc_add_notice( 'سانسی که قصد رزرو آن را دارید توسط شخص دیگری در حال رزرو می باشد.', 'error');

    /*======================*/

    $phone = $_POST['billing_phone'];

    wc_clear_notices();

    if ( strlen($phone) != 11 )
        wc_add_notice( 'شماره موبایل باید 11 رقم باشد!', 'error');

    if ( !str_starts_with($phone, '09') )
        wc_add_notice( 'شماره موبایل صحیح وارد کنید، برای مثال: 09122222222', 'error');

    if( !is_numeric( $phone ) )
        wc_add_notice( 'شماره موبایل صحیح وارد کنید، برای مثال: 09122222222', 'error');
}
/****************************************************************************************************************************************/
function ez_refund ( $track_id ) {

    $refund_msg = 'بابت استرداد';

    $res = wp_remote_post( 'https://api.zibal.ir/v1/wallet/refund', array (
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array('Authorization' => 'Bearer 453addf8358f4140ac087308f14c6d45'),
        'body'          => array('trackId' => $track_id, 'description' => $refund_msg, "wageMode" => 2),
        'cookies'       => array()
    ) );

    return $res;
}
/****************************************************************************************************************************************/
add_shortcode('order_conflict_oops_page', 'order_conflict_oops_page'); // tadakhol
function order_conflict_oops_page () {
    do_action('order_conflict_happened', base64_url_decode( base64_url_decode( $_GET['order_id'] ) ));
}
/****************************************************************************************************************************************/
add_action('order_conflict_happened', 'order_conflict_handling', 10, 1);
function order_conflict_handling ($order_id) {

    $res = ez_refund( get_post_meta($order_id, '_transaction_id', true) );
    $obj = json_decode($res['body']);

    if ( $obj->status == 1 && $obj->result == 1 ) {

        $amount         = number_format( (int)(substr($obj->data->amount, 0, -1)) );
        $predictedTime  = explode( 'T', $obj->data->predictedTime );

        $date = jdate('l j F', strtotime($predictedTime[0]));
        $time = jdate('H:i', strtotime($predictedTime[1]));

        $txt = "کاربر گرامی مبلغ $amount تومان تا حداکثر ساعت $time روز $date به حسابتان برمیگردد.\nاسکیپ زوم";
        add_to_sms_queue (substr(get_post_meta($order_id, '_billing_phone', true), 1), $txt, $order_id, 'refund'); ?>

        <div id="ez_refund_msg_header_img"><img src="http://escapezoom.ir/wp-content/uploads/2023/12/refund_page.png"></div>

        <div id="ez_refund_msg_header">اوه! با اینکه پرداخت شما انجام شد اما یکی سریع تر از تو بود و زودتر این سانس رو رزرو کرد!</div>

        <div id="ez_refund_msg_wrapper">اما نگران نباش! مبلغ <?php echo $amount; ?> تومان تا حداکثر ساعت <?php echo $time; ?> روز <?php echo $date; ?> به حسابت برمیگرده.</div>

        <div id="ez_refund_msg_agency_phone">
            <p>اگه سوالی داری با شماره زیر تماس بگیر:</p>
            <p><a href="tel:+982191307900" style="color: #ffffff;background: #f96f0c;padding: 5px;border-radius: 8px;text-align: center;width: 160px;">02191307900</a></p>
        </div>

        <?php
    } elseif ( $obj->result == 10 ) { ?>
        <div id="ez_refund_msg_wrapper">مبلغ برای شما مسترد شده است. لطفا صبور باشید.</div>
        <?php
    } ?>

    <style>
        #ez_refund_msg_header {
            line-height: 2;
            font-size: 18px;
            margin: 15px 0;
            text-align: center;
        }
        #ez_refund_msg_header_img {
            text-align: center;
        }
        #ez_refund_msg_header_img img{
            border-radius: 8px;
        }
        #ez_refund_msg_wrapper {
            text-align: center;
            font-weight: bold;
            background: #f96f0c;
            padding: 20px;
            border-radius: 8px;
            color: #fff;
            font-size: 16px;
            text-align: justify;
            line-height: 37px;
            text-align: center;
        }
        #post-30102 .entry-title {
            display: none;
        }
        #ez_refund_msg_agency_phone {
            background: #e3e3e3;
            margin: 10px 0;
            border-radius: 8px;
            padding: 20px 10px 0;
            border: 1px solid #c9c9c9;
            text-align: center;
        }
    </style>

    <?php
}
/****************************************************************************************************************************************/
add_action( 'wp_ajax_ez_site_ajax_handler',        'ez_site_ajax_handler_callback' );
add_action( 'wp_ajax_nopriv_ez_site_ajax_handler', 'ez_site_ajax_handler_callback' );
function ez_site_ajax_handler_callback() {
    global $wpdb;

    $user_id = get_current_user_id();
    //=====================/
    if (!wp_verify_nonce($_POST['nonce'], 'ajax-nonce'))
        wp_send_json('');
    //=====================/
    if (isset($_POST["_checkout_sessions_"])) :

        if ( isset( $_POST['book'] ) || !empty( $_POST['book'] )  ) {

            $_SESSION['book']       = $_POST['book'];
            $_SESSION['quantity']   = $_POST['quantity'];
            $_SESSION['product_id'] = $_POST['product_id'];
            $_SESSION['user_id']    = $_POST['user_id'];
            $_SESSION['c_time']     = $_POST['c_time'];

            wp_send_json(true);
        }

        wp_send_json(false);

    endif;
    //=====================/
    if (isset($_POST["_product_comment_ajax_"])) :
        ob_start();

        $product_id     = $_POST['product_id'];
        $post_per_page  = $_POST['limit'];
        $page           = (int)$_POST['page'];

        $args = array (
            'post__in'  => $product_id,
            'number'    => $post_per_page,
            'offset'    => ($page - 1) * $post_per_page,
        );

        $comments_query = new WP_Comment_Query;
        $comments       = $comments_query->query($args);

        if ($comments) {
            foreach ($comments as $comment) {
                $c_author   = $comment->comment_author;
                $comment_id = $comment->comment_ID;

                $cld_like_count     = get_comment_meta($comment_id, "cld_like_count", true);
                $cld_dislike_count  = get_comment_meta($comment_id, "cld_dislike_count", true);
                $cm_rating          = get_comment_meta($comment_id, "rating", true);
                $comment_rating     = get_comment_meta($comment_id, "comment_rating", true);

                if ( !is_array($comment_rating) ) {
                    $comment_rating = str_replace("}", "", $comment_rating);
                    $comment_rating = explode('i:', $comment_rating);
                    array_shift($comment_rating);

                    $arr = [];
                    foreach ( $comment_rating as $elm ) {
                        $elm = explode(';s:', $elm);
                        $arr[$elm[0]] = (int) filter_var(explode(':', $elm[1])[1], FILTER_SANITIZE_NUMBER_INT);
                    }
                    $comment_rating = $arr;
                }

                $likefinal = (int)$cld_like_count - (int)$cld_dislike_count;

                if ($comment->comment_parent == 0 || $comment->comment_parent == "0" || 1)
                    if ($comment->comment_approved == 1): ?>
                        <?php if ($comment->comment_parent == 0 || 1): ?>
                            <li class="listing-item"
                                data-status="<?php echo $comment->comment_parent; ?>"
                                data-cm-id="<?php echo $comment_id; ?>"
                                data-cm-score="<?php if ($_GET['commentby'] == 'date' || $_GET['commentby'] == ''): ?> <?php echo $comment_id; ?> <?php else: ?> <?php echo $likefinal; ?>.<?php echo $cld_dislike_count; ?> <?php endif ?>">

                                <?php
                                switch ($cm_rating) {
                                    case 3:
                                        echo "<i class='face-icon face-icon-normal desktop-show'></i>";
                                        break;

                                    case  2:
                                        echo "<i class='face-icon face-icon-sad desktop-show'></i>";
                                        break;

                                    case  1:
                                        echo "<i class='face-icon face-icon-sad desktop-show'></i>";
                                        break;

                                    default:
                                        echo "<i class='face-icon face-icon-smile desktop-show'></i>";
                                        break;
                                }
                                ?>
                                <span class="fw-bold comment_details_wrapper"><?php if (is_numeric($c_author)) {
                                        $phone_mask = substr("$c_author", 3, 5);
                                        echo '<span class="d-block ltr tar">' . str_replace("$phone_mask", "×××××", "$c_author") . '</span>';
                                        echo '<span class="comment_date_x">[' . wp_date('Y-m-d', strtotime($comment->comment_date)) . ']</span>';
                                    } elseif ($c_author == "" || $c_author == null) {
                                        echo '<span class="d-block ltr tar">کاربر ' . $comment->comment_ID . '</span>';
                                    } else {
                                        echo '<span class="d-block rtl tar">' . $c_author . '</span>';
                                    } ?></span>
                                <p><?php comment_text($comment_id); ?></p>
                                <?php //comments_like_dislike($comment_id);

                                $user_ebtal     = get_post_meta($product_id, 'user_ebtal', true);
                                $owner_report   = get_comment_meta($comment_id, 'owner_report');

                                if ($user_ebtal): ?>

                                    <?php
                                    if (get_current_user_id() == $user_ebtal): ?>
                                        <p class="reply-p">
                                            <?php
                                            if ( empty($owner_report) ) : // the owner hasn't reported this comment yet. so he still can report it.?>

                                                <!--                                                                        <button class="btn btn-secondary btn-sm" type="button"-->
                                                <!--                                                                                data-bs-toggle="collapse"-->
                                                <!--                                                                                data-bs-target="#commentReport---><?//= $comment_id; ?><!--">-->
                                                <!--                                                                            گزارش-->
                                                <!--                                                                        </button>-->

                                            <?php
                                            endif; ?>

                                            <button class="btn btn-primary btn-sm" type="button"
                                                    data-bs-toggle="collapse"
                                                    data-bs-target="#commentReplay-<?= $comment_id; ?>"
                                                    aria-expanded="false"
                                                    aria-controls="commentReplay-<?= $comment_id; ?>">
                                                پاسخ
                                            </button>
                                        </p>

                                        <div class="collapse" id="commentReplay-<?= $comment_id; ?>">
                                            <form action="https://escapezoom.ir/comment-reply/"
                                                  method="post" enctype="multipart/form-data">
                                                <input type="hidden" id="cm_parent" name="cm_parent"
                                                       value="<?= $comment_id; ?>">
                                                <input type="hidden" id="cm_roomid" name="cm_roomid"
                                                       value="<?php echo $product_id; ?>">

                                                <textarea class="textarea-review" name="w3review"
                                                          rows="4" cols="50"></textarea>
                                                <div class="new-comment-form-col new-comment-form-col-submit submit-reply">
                                                    <button name="submit" id="wp-submit"
                                                            class="btn-default submit-reply"
                                                            type="submit">ارسال پاسخ
                                                    </button>
                                                </div>
                                            </form>
                                        </div>

                                        <div class="collapse" id="commentReport-<?= $comment_id; ?>">
                                            <form action="" method="post" enctype="multipart/form-data">
                                                <input type="hidden" id="cm_parent" name="cm_id" value="<?= $comment_id; ?>">
                                                <input type="hidden" id="cm_roomid" name="cm_roomid" value="<?php echo$product_id; ?>">

                                                <select name="cm_report_subject">
                                                    <option name="4545">4545</option>
                                                    <option name="4646">4646</option>
                                                    <option name="4747">4747</option>
                                                    <option name="4848">4848</option>
                                                </select>

                                                <textarea class="textarea-review" name="cm_report_text" rows="4" cols="50"></textarea>
                                                <div class="new-comment-form-col new-comment-form-col-submit submit-reply">
                                                    <button name="submit" id="wp-submit" class="btn-default submit-reply" type="submit">ارسال گزارش</button>
                                                </div>
                                            </form>
                                        </div>

                                    <?php endif ?>

                                    <?php
                                    $replies = array(
                                        'status' => 'approve',
                                        'number' => '1',
                                        'parent' => $comment_id
                                    );


                                    $replies_comments = get_comments($replies);
                                    if ($replies_comments): ?>

                                        <ul class="comment-replay-ul">

                                            <?php foreach ($replies_comments as $replie_comment): ?>
                                                <?php
                                                $mm2 = $replie_comment->user_id;
                                                $user__crInfo = get_userdata($mm2);
                                                $user_cr_name = $user__crInfo->display_name;
                                                ?>
                                                <li>
                                                    <p class="py-3 tar"><span class="fw-bold">پاسخ <?= $user_cr_name; ?>:</span>
                                                        <span><?php echo $replie_comment->comment_content; ?></span>
                                                    </p>
                                                </li>
                                            <?php endforeach ?>
                                        </ul>
                                    <?php endif ?>
                                <?php endif ?>
                            </li>
                        <?php endif ?>
                    <?php endif ?>
            <?php }
        }

        $res = ob_get_clean();

        wp_send_json($res);
    endif;
    //=====================/
    if (isset($_POST["_load_plp_days_"])) :
        ob_start();
        $product_id     = $_POST['product_id'];
        $wp_is_mobile   = $_POST['wp_is_mobile']; ?>


        <div data-time="<?php echo zr_get_todaytimestamp(); ?>" data-ezservice="<?php echo $product_id; ?>"
             class="day-itemx active-day">
            <?php
            if ($wp_is_mobile): ?>

                <a class="day-num-view" data-time="<?php echo zr_get_todaytimestamp(); ?>" data-ezservice="<?php echo $product_id; ?>" href="#">
                    <p class="month-name-view">
                        <span class='frist-day-view today'>امروز</span>
                    </p>
                </a>

            <?php
            else: ?>

                <a class="day-num-view " data-time="<?php echo zr_get_todaytimestamp(); ?>"  data-ezservice="<?php echo $product_id; ?>" href="#">
                    <span class='frist-day-view today'>امروز</span>
                </a>

            <?php
            endif ?>
        </div>

        <?php
        $x = 1;
        while ($x <= 21) {

            if ($x == 1)
                $get_d = zr_get_todaytimestamp();;

            if ($x != 1) { ?>

                <div data-time="<?php echo $get_d; ?>" data-ezservice="<?php echo $product_id; ?>"
                     class="day-itemx d-<?php echo $x; ?>">
                    <?php
                    if ($wp_is_mobile): ?>
                        <a class="day-num-view" href="#" data-ezservice="<?php echo $product_id; ?>" data-time="<?php echo $get_d; ?>">
                            <p class="month-name-view">
                                <span class='frist-day-view'><?php echo jdate('j', $get_d) ?></span>
                                <span class='mobile-m-view'><?= jdate('l', $get_d) ?></span>
                            </p>
                        </a>

                    <?php
                    else: ?>
                        <a class="day-num-view" data-time="<?php echo $get_d; ?>" data-ezservice="<?php echo $product_id; ?>" href="#">
                            <span class='frist-day-view'><?= jdate('l', $get_d) ?></span>
                            <p class="month-name-view"><?= jdate('j', $get_d) ?></p>
                            <small class="day-name-view"><?= jdate('F', $get_d) ?></small>
                        </a>
                    <?php
                    endif ?>
                </div>
            <?php }
            $get_d = $get_d + 86400;
            $x++;
        }

        $res = ob_get_clean();

        wp_send_json($res);

    endif;
    //=====================/
    if ( isset($_POST["_new_msg_"]) && isset($_POST["msg_content"]) && isset($_POST["ticket_id"]) ) :

        $ticket_id      = $_POST['ticket_id'];
        $msg            = $_POST['msg_content'];
        $user_type      = $_POST['user_type'];
//        $admin_name     = isset ($_POST['admin_name']) ? $_POST['admin_name'] : '';
//        $uploadedfile   = $_FILES['file'];

        // if there is no message neither text or media
        if ( empty($msg) && empty($uploadedfile) ) return;

        // if requested ticket is not belong to the current user
        if ( $user_type && !ticket_verify($ticket_id, $user_id) ) return;

        $messages = get_post_meta($ticket_id, 'messages', true);

        if ( !empty($msg) ) {
            $messages[] = [
                'body'          => $msg,
                'user_type'     => 'admin',
                'date'          => time(),
                'attachment'    => time(),
            ];
        }

        // upload the file and get the uploaded url
//        if ( !empty($uploadedfile) ) {
//
//            if ( in_array( $uploadedfile['type'], ["image/jpg", "image/jpeg", "application/pdf"] ) === -1 || $uploadedfile['size'] > 2000000 ) return;
//
//            if (!function_exists('wp_handle_upload'))
//                require_once(ABSPATH . 'wp-admin/includes/file.php');
//
//            add_filter( 'upload_dir', 'change_default_upload_dir_for_ticketing_files' );
//            $movefile = wp_handle_upload($uploadedfile, array('test_form' => false, 'unique_filename_callback' => 'customers_ticketing_files_folder'));
//            remove_filter( 'upload_dir', 'change_default_upload_dir_for_ticketing_files' );
//
//            if ($movefile && !isset($movefile['error'])) {
//                $uploadedfile = $movefile['url'];
//            } else {
//                wp_send_json_error($movefile['error']);
//            }
//
//            $temp = new stdClass();
//            $temp->content  = $uploadedfile;
//            $temp->type     = $user_type;
//            $temp->time     = current_time("H:i");
//
//            $messages[] = $temp;
//        }

        update_post_meta($ticket_id, 'messages', $messages);
        update_post_meta($ticket_id, 'respond_user_role', 'admin');
        update_post_meta($ticket_id, 'admin_seen', 0);
        update_post_meta($ticket_id, 'ticket_closed', 0);

        wp_update_post(array(
            'ID'            =>  $ticket_id,
            'post_status'   =>  'publish'
        ));

        add_post_meta($ticket_id, 'user_seen', 1, true);

        wp_send_json_success(true);

    endif;
    //=====================/
    if ( isset($_POST["_ticket_closed_"]) && isset($_POST["ticket_closing_state"]) && isset($_POST["ticket_id"]) ) :
        update_post_meta($_POST["ticket_id"], 'ticket_closed', $_POST["ticket_closing_state"] == 'true' ? 1 : 0);
    endif;
    //=====================/
    if ( isset($_POST["_supporting_control_"]) && isset($_POST["order_id"]) && isset($_POST["status"]) ) :

        $order_id   = $_POST['order_id'];
        $status     = $_POST['status'];

        $order = wc_get_order( $order_id );

        if ( !$order )
            return;

        $username = (wp_get_current_user())->user_login;

        $order->update_status( $status, "کاربر $username : " );
    endif;
    //=====================/
    if ( isset($_POST["_supporting_change_quantity_"]) && isset($_POST["order_id"]) && isset($_POST["new_quantity"]) ) :

        $order_id       = $_POST['order_id'];
        $new_quantity   = $_POST['new_quantity'];

        $order = wc_get_order( $order_id );

        if ( !$order )
            return;

        foreach ($order->get_items() as $item) {
            $old_quantity = $item->get_quantity();

            $item->set_quantity($new_quantity);
            $item->save();
            break;
        }

        $username = (wp_get_current_user())->user_login;

        $order->add_order_note( 'کاربر ' . $username . ' تعداد را از ' . $old_quantity . ' به ' . $new_quantity . ' تغییر داد.' );

        $order->calculate_totals();

    endif;
    //=====================/
    if ( isset($_POST["_supporting_happycall_"]) && isset($_POST["order_id"]) && isset($_POST["state"]) ) :

        $order_id   = $_POST['order_id'];
        $state      = $_POST['state'];

        if ( $state === 'true' )
            update_post_meta($order_id, 'supporting_happycall', 1);
        else
            update_post_meta($order_id, 'supporting_happycall', 0);

    endif;
    //=====================/
    //=====================/
    //=====================/
}
/****************************************************************************************************************************************/
function get_user_role($user_id) {
    return (get_userdata($user_id)->roles)[0];
}
/****************************************************************************************************************************************/
function zardkooh_get_product_img () {}
/****************************************************************************************************************************************/
add_action('woocommerce_order_status_changed', 'if_order_status_changed', 10, 3);
function if_order_status_changed($order_id, $old_status, $new_status) {

    $order = wc_get_order( $order_id );
    foreach ( $order->get_items() as $item ) {
        $room_name  = $item->get_name();
        $room_id    = $item['product_id'];
    }

    if ( $new_status == 'refunded' ) {

        $args = [
            "single_value"  => true,
            "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id",
        ];
        $response = ez_reservation( array('type' => 'query_execution', 'data' => $args) );
        $row = (array)json_decode($response);

        ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "DELETE FROM `wp_zb_booking_history` WHERE wc_order_id LIKE {$order_id}"]));

        $t1             = jstrftime(' %H:%M روز %Y/%m/%e' , $row['booking_time'] );
        $player_phone   = ltrim($order->get_billing_phone(), '0');
        $player_name    = $order->get_billing_first_name();

        $owner_id           = get_post_meta( $room_id, 'user_ebtal', true );
        $owner_phone        = get_userdata( $owner_id )->user_login;
        $chat_id            = get_user_meta( $owner_id, 'chat_id', true );

        $manager_id         = get_post_meta( $room_id, 'sans_manager', true );
        $manager_phone      = get_userdata( $manager_id )->user_login;
        $manager_chat_id    = get_user_meta( $manager_id, 'chat_id', true );

        ez_sendpayamak($player_phone, "$player_name گرامی سانس  $t1 اتاق فرار $room_name کنسل گردید.", '2191307900');
        ez_sendpayamak($owner_phone, "همکار گرامی، سانس$t1 بازی $room_name کنسل و برای فروش مجدد باز شد.", '2191307900');

        if ( $manager_phone && $manager_phone != $owner_phone )
            ez_sendpayamak($manager_phone, "همکار گرامی، سانس$t1 بازی $room_name کنسل و برای فروش مجدد باز شد.", '2191307900');

        if ( $chat_id ) {
            $txt_msg_maj    = "همکار گرامی، سانس$t1 بازی $room_name کنسل و برای فروش مجدد باز شد.";
            $txt_msg_maj    = str_replace(" ", "%20", $txt_msg_maj);
            $txt_msg_maj    = urlencode($txt_msg_maj);

            $hash = base64_encode($chat_id);
            file_get_contents("https://impec.ir/?chat_id=$hash&message=$txt_msg_maj");

            $hash = base64_encode($manager_chat_id);
            file_get_contents("https://impec.ir/?chat_id=$hash&message=$txt_msg_maj");
        }
    }
}
/****************************************************************************************************************************************/
add_action('admin_menu', 'held_status_accounting_management');
function held_status_accounting_management() {
    global $wldb;

    add_menu_page(
        'اسکیپ زوم',
        'اسکیپ زوم',
        'manage_options',
        'ez_main_menu',
        'ez_main_menu_callback_function',
        get_template_directory_uri() . '/img/admin-icon.png',
        2
    );
    add_submenu_page(
        'ez_main_menu',
        'ویرایش صفحه اصلی',
        'ویرایش صفحه اصلی',
        'manage_options',
        'ez_main_menu'
    );

    add_submenu_page(
        'ez_main_menu',
        'مدیریت برگزار شده ها',
        'مدیریت برگزار شده ها',
        'manage_options',
        'held_status_accounting_management',
        'held_status_accounting_management_ui_func',
    );
    add_submenu_page(
        'ez_main_menu',
        'تقویم اسکیپ زوم',
        'تقویم اسکیپ زوم',
        'manage_options',
        'ez_calendar',
        'ez_calendar_ui_func',
    );

    $capability = 'manage_options';
    if ( get_current_user_id() == 6289 )
        $capability = 'edit_posts';

    add_submenu_page(
        'ez_main_menu',
        'آپدیت داده ها',
        'آپدیت داده ها',
        $capability,
        'month_best_sell',
        function () {
            include get_template_directory() . "/inc/month_best_sell.php";
        },
    );

    $notification_count = count( $wldb->get( array( 'type' => 'withdraw', 'status' => 'در حال پردازش' ), 500 ) );
    add_menu_page(
        'تسویه حساب ها',
        $notification_count ? sprintf('تسویه حساب ها<span class="update-plugins" style="background-color:#d63638;color:white">%d</span>', $notification_count) : 'تسویه حساب ها',
        'manage_ez_withdrawal',
        'ez_withdrawal',
        'ez_withdrawal_ui_func',
        get_template_directory_uri() . '/img/admin-icon.png',
        3
    );
    add_submenu_page(
        'ez_withdrawal',
        'در انتظار پرداخت',
        'در انتظار پرداخت',
        'manage_ez_withdrawal',
        'ez_withdrawal'
    );
    add_submenu_page(
        'ez_withdrawal',
        'پرداخت شده ها',
        'پرداخت شده ها',
        'manage_ez_withdrawal',
        'ez_withdrawal_paid',
        'ez_withdrawal_paid_ui_func',
    );
    add_submenu_page(
        'ez_withdrawal',
        'رد شده ها',
        'رد شده ها',
        'manage_ez_withdrawal',
        'ez_withdrawal_rejected',
        'ez_withdrawal_rejected_ui_func',
    );
}
/****************************************************************************************************************************************/
function held_status_accounting_management_ui_func () { ?>

    <a class="held_status_accounting_management_ui_func" href="<?php echo home_url('/wp-admin/admin.php?page=held_status_accounting_management&bulk_change_partially_to_held_after_4hrs=تهران') ?>">به روزرسانی برگزار شده ها (تهران)</a>
    <a class="held_status_accounting_management_ui_func" href="<?php echo home_url('/wp-admin/admin.php?page=held_status_accounting_management&bulk_change_partially_to_held_after_4hrs=کرج') ?>">به روزرسانی برگزار شده ها(البرز)</a>
    <a class="held_status_accounting_management_ui_func" href="<?php echo home_url('/wp-admin/admin.php?page=held_status_accounting_management&bulk_change_partially_to_held_after_4hrs=دیگر') ?>">به روزرسانی برگزار شده ها (دیگرشهرها)</a>
    <a class="held_status_accounting_management_ui_func" href="<?php echo home_url('/wp-admin/admin.php?page=held_status_accounting_management&convert_all_held_to_completed') ?>" id="convert_all_held_to_completed">تبدیل برگزار شده ها به تکمیل شده</a>

    <style>
        .held_status_accounting_management_ui_func {
            background: #ff7517;
            color: #fff;
            padding: 10px;
            border-radius: 8px;
            text-decoration: none;
        }
    </style>

    <script>
        jQuery(document).ready(function($) {
            $('body').on('click', '#convert_all_held_to_completed', function () {

                if ( $(this).val() != "-1" ) {

                    if ( confirm('مطمئن هستید؟') ) {

                    } else {
                        return false;
                    }
                }
            });
        });
    </script>

    <?php
    global $wpdb;

    if ( current_user_can('administrator') ) {
        if ( isset($_GET["bulk_change_partially_to_held_after_4hrs"]) ) {
            $requested = $_GET["bulk_change_partially_to_held_after_4hrs"];

            $partially_orders = [];
            $temp = $wpdb->get_results( "SELECT wp_posts.ID FROM wp_posts WHERE post_status = 'wc-partially-paid' ORDER BY wp_posts.ID", ARRAY_A );
            foreach ( $temp as $order_arr )
                $partially_orders[] = $order_arr['ID'];
            $partially_orders = implode(',', $partially_orders);

            $rows = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "SELECT wc_order_id as ID, booking_time as booking_time FROM wp_zb_booking_history WHERE `wc_order_id` IN ($partially_orders)"])), true);

            foreach ( $rows as $row ) {
                if ( $row['booking_time'] < time() - 4 * 3600 ) {
                    $order_id = $row['ID'];

                    $order = wc_get_order($order_id);
                    foreach ($order->get_items() as $item)
                        $product_id = $item->get_product_id();

                    $city_name  = get_the_terms($product_id, 'product_cat')[0]->name;
                    if ( $requested == 'کرج' || $requested == 'تهران' ) {
                        if ( $city_name == $requested )
                            $wpdb->update('wp_posts', array('post_status' => 'wc-held'), array('ID' => $order_id));

                    } elseif ( $requested == 'دیگر' ) {
                        if ( !($city_name == 'کرج' || $city_name == 'تهران') )
                            $wpdb->update('wp_posts', array('post_status' => 'wc-held'), array('ID' => $order_id));
                    }
                }
            }
        }

        if ( isset($_GET["convert_all_held_to_completed"]) )
            $wpdb->update('wp_posts', array('post_status' => 'wc-completed'), array('post_status' => 'wc-held'));
    }
}
/****************************************************************************************************************************************/
function ez_calendar_ui_func () {

    if ( isset($_POST['ez_holidays']) && isset($_POST['ez_closed_days']) ) {
        $calendar_data = ['holidays' => $_POST['ez_holidays'], 'closed_days' => $_POST['ez_closed_days']];

        update_option('ez_calendar', $calendar_data);
        ez_webservice( array('type' => 'ez_calendar', 'data' => $calendar_data) );
    }

    $ez_calendar_url    = get_theme_file_uri( 'assets/ez_calendar');
    $ez_calendar        = get_option('ez_calendar'); ?>

    <meta charset='utf-8'/>
    <link href='<?php echo $ez_calendar_url ?>/css/fonts.css' rel='stylesheet'/>
    <link href='<?php echo $ez_calendar_url ?>/css/fullcalendar.css' rel='stylesheet'/>
    <link href='<?php echo $ez_calendar_url ?>/css/fullcalendar.print.min.css' rel='stylesheet' media='print'/>
    <script src='<?php echo $ez_calendar_url ?>/js/moment.min.js'></script>
    <script src='<?php echo $ez_calendar_url ?>/js/moment-jalaali.js'></script>
    <script src='<?php echo $ez_calendar_url ?>/js/jquery.min.js'></script>
    <script src='<?php echo $ez_calendar_url ?>/js/jquery-ui.min.js'></script>
    <script src='<?php echo $ez_calendar_url ?>/js/fullcalendar.min.js'></script>
    <script src='<?php echo $ez_calendar_url ?>/js/fa.js'></script>

    <script>
        $(document).ready(function () {
            eventList = [];

            var $holidays       = $('#ez_holidays').val().split(',');
            var $closed_days    = $('#ez_closed_days').val().split(',');

            jQuery.each($holidays, function(index, item) {
                var event_day = $.datepicker.formatDate('yy-M-dd', new Date(new Date(item * 1000)));

                newEvent = {
                    title   : 'تعطیل است!',
                    el_id   : 'ez_holiday',
                    start   : event_day,
                    el_time : item,
                };
                eventList.push(newEvent);
            });

            jQuery.each($closed_days, function(index, item) {
                var event_day = $.datepicker.formatDate('yy-M-dd', new Date(new Date(item * 1000)));

                newEvent = {
                    title: 'غیرفعال است!',
                    el_id: 'ez_closed',
                    start: event_day,
                    el_time: item,
                };
                eventList.push(newEvent);
            });
            /****************************************************************************/
            $('#external-events .fc-event').each(function () {

                $(this).data('event', {
                    title: $.trim($(this).text()),
                    stick: true,
                    el_id: $(this).attr('id'),
                    el_time: '',
                });

                $(this).draggable({
                    zIndex: 999,
                    revert: true,
                    revertDuration: 100,
                });
            });
            /****************************************************************************/
            var calendar = $('#ez_reservation_calendar').fullCalendar({
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'year'
                },
                locale: 'fa',
                isJalaali: true,
                isRTL: true,
                editable: false,
                droppable: true,
                displayEventTime: false,
                drop: function (date, jsEvent, ui, resourceId) {

                    var event_time = Math.floor(new Date(toEnglishNumber(date.format())).getTime() / 1000);

                    $('#ez_reservation_temp').val(event_time);

                    if ( $(this).attr('id') == 'ez_closed' )
                        $('#ez_closed_days').val($('#ez_closed_days').val() + ',' + event_time);

                    if ( $(this).attr('id') == 'ez_holiday' )
                        $('#ez_holidays').val($('#ez_holidays').val() + ',' + event_time);
                },
                eventRender: function (eventObj, $el) {

                    if ( eventObj.el_time === '' ) {
                        setTimeout(function() {
                            eventObj.el_time = $('#ez_reservation_temp').val();
                            $('#ez_reservation_temp').val('');
                        }, 1);
                    }

                    $($el).addClass(eventObj.el_id);
                    $($el).find('.fc-resizer').remove();
                },
                eventOverlap: function(stillEvent, movingEvent) {
                    return false;
                },
                eventClick: function(calEvent, jsEvent, view) {

                    var $holidays = $('#ez_holidays').val().split(',');
                    $holidays = jQuery.grep($holidays, function(value) {return value != calEvent.el_time;});
                    $holidays = jQuery.grep($holidays, function(value) {return value != '';});
                    $('#ez_holidays').val($holidays.join());

                    var $holidays = $('#ez_closed_days').val().split(',');
                    $holidays = jQuery.grep($holidays, function(value) {return value != calEvent.el_time;});
                    $holidays = jQuery.grep($holidays, function(value) {return value != ''; }); // تمیزکاری
                    $('#ez_closed_days').val($holidays.join());

                    $('#ez_reservation_calendar').fullCalendar('removeEvents', calEvent._id);
                },
                events: eventList,
            });
            /****************************************************************************/
        });
        /****************************************************************************/
        function toEnglishNumber(strNum) {
            var pn = ["۰", "۱", "۲", "۳", "۴", "۵", "۶", "۷", "۸", "۹"];
            var en = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];

            var cache = strNum;
            for (var i = 0; i < 10; i++)
                cache = cache.replace(new RegExp(pn[i], 'g'), en[i]);

            return cache;
        }
    </script>
    <style>
        .fc-unthemed td.fc-today {
            background: #ffef99;
        }
        #external-events {
            float: right;
            width: 150px;
            padding: 0 10px;
            border: 1px solid #cfcfcf;
            background: #f7f7f7;
            text-align: right;
        }
        #external-events h4 {
            font-size: 16px;
            margin-top: 0;
            padding-top: 1em;
        }
        #external-events .fc-event {
            padding: 3px 3px 1px 3px;
            margin: 10px 0;
            cursor: pointer;
        }
        #external-events p {
            margin: 1.5em 0;
            font-size: 11px;
            color: #666;
        }
        #external-events p input {
            margin: 0;
            vertical-align: middle;
        }
        #ez_reservation_calendar {
            float: left;
            width: 900px;
        }
        .fc-event {
            background: #a70000;
            border: none;
            text-align: center;
            direction: rtl;
            cursor: not-allowed;
        }
        .ez_closed {
            background: #666666;
        }
        #ez_reservation_submit_btn {
            display: flex;
            margin: 10px 0;
            background: #ff8100;
            border: none;
            padding: 7px 20px;
            border-radius: 8px;
            color: #fff;
            text-align: center;
            font-size: 15px;
            font-weight: bold;
            float: left;
            text-shadow: 0 1px 1px rgba(255, 255, 255, 0.75);
            cursor: pointer;
        }
    </style>

    <div id='wrap'>

        <form method="post">
            <input type="hidden" id="ez_holidays" name="ez_holidays" value="<?php echo implode(',',  (array)$ez_calendar['holidays']) ?>">
            <input type="hidden" id="ez_closed_days" name="ez_closed_days" value="<?php echo implode(',',  (array)$ez_calendar['closed_days']) ?>">
            <input type="submit" value="ذخیره" id="ez_reservation_submit_btn">
        </form>

        <input type="hidden" id="ez_reservation_temp">

        <div id='external-events'>
            <h4>مناسبت ها</h4>
            <div class='fc-event ez_holiday' id='ez_holiday' >تعطیل است!</div>
            <div class='fc-event ez_closed' id='ez_closed'>غیرفعال است!</div>
        </div>

        <div id='ez_reservation_calendar'></div>

        <div style='clear:both'></div>
    </div>

    <?php
}
/****************************************************************************************************************************************/
function ez_withdrawal_ui_func () {
    global $wpdb, $wldb;

    if ( $_GET['page'] == 'ez_withdrawal' && isset( $_GET['transaction_id'] ) ) {
        $transaction_id = $_GET['transaction_id'];

        $transaction = $wldb->get( array( 'ID' => $transaction_id ), -1, true );

        $actions = unserialize( $transaction->actions );
        $actions = empty($actions) ? [] : $actions;

        if ( $_GET['function'] == 'refuse' ) {

            $actions[] = [
                'action'    => 'رد شده',
                'time'      => time()
            ];

            $update_transaction = array (
                'status'    => 'رد شده',
                'actions'   => serialize( $actions ),
            );
            $wldb->update($update_transaction, $transaction_id);

            $transaction = $wldb->get( array( 'ID' => $transaction_id ), -1, true );

            $user_id            = $transaction->user_id;
            $current_balance    = $wldb->get_balance($user_id);
            $amount             = $transaction->amount * (-1);
            $balance            = $current_balance + $amount;
            $description        = 'رد درخواست تسویه حساب';

            $new_transaction = array (
                'user_id'       => $user_id,
                'amount'        => $amount,
                'balance'       => $balance,
                'description'   => $description,
                'type'          => 'transaction',
            );
            $wldb->insert($new_transaction);

            wp_redirect( admin_url(sprintf('admin.php?page=%s', $_GET['page'])) );

        } elseif ( isset( $_GET['user_id'] ) && isset( $_GET['for'] ) && $_GET['function'] == 'approve' ) {

            $transaction_id = $_GET['transaction_id'];
            $user_id        = $_GET['user_id'];
            $for            = 'بابت ' . preg_replace('/\x{200C}/u', ' ', str_replace(['(', ')'], '', $_GET['for']));
            $for            = strlen($for) < 50 ? $for : substr($for, 0, 50);
            $for            = preg_replace('/[^\PC\s]/u', '', $for);

            $transaction = $wldb->get( array( 'ID' => $transaction_id ), -1, true );

            if ( $transaction->status != 'در حال پردازش' )
                die('این تراکنش در انتظار پرداخت نیست. احتمالا قبلا پرداخت شده است. بیشتر بررسی کنید');

            $transaction_amount = $transaction->amount * -10;
            $shaba_owner_name   = get_the_author_meta('withdrawal_owner_name', $user_id);
            $shaba              = get_the_author_meta('withdrawal_owner_shaba', $user_id);
            $payment_number     = preg_match('/^IR\d{2}0560.{18}$/', $shaba) ? "" : $transaction_id;

            saeed_print([
                'shaba'             => $shaba,
                'transaction_id'    => $transaction_id,
                'owner_name'        => $shaba_owner_name,
                'amount'            => $transaction_amount,
                'for'               => $for,
                'payment_number'    => $payment_number
            ]);

//            if ( $transaction_id == 201780 )
//                die();

            /*-----------------------------------------------------------------------------*/
            // Create Token

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://b2bapi.sb24.ir:8443/api/v1/auth/token',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{
                    "client_id": "0d34b26b-59f6-4e65-bf67-070979585fec",
                    "client_secret": "fc5f3038-f972-408b-81cd-9c5e20ab15e4",
                    "scope": ""
                }',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json'
                ),
            ));
            $response = json_decode(curl_exec($curl));
            curl_close($curl);

            if (!isset($response->status) && !isset($response->statusCode)) {
                echo json_encode(['error' => 'No status or statusCode found']);
                die();
            }

            $status = isset($response->statusCode) ? $response->statusCode : $response->status;
            if ($status != 200) {
                echo json_encode(['error' => $response->title, 'status' => $status]);
                die();
            }

            $token = $response->result->access_token;

            /*-----------------------------------------------------------------------------*/
            // Create Order Folder

            $track_id = microtime(true);

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://b2bapi.sb24.ir:8443/api/v1/b2bapi/payments',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{
                    "trackingId": ' . $track_id . ',
                    "name": "تسویه اتاق فرار",
                    "description": "برداشت از کیف پول",
                    "sourceIban": "IR780560082681004088035001",
                    "amount": ' . $transaction_amount . ',
                    "NumberOfTransactions": 1
                }',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                ),
            ));
            $response = json_decode(curl_exec($curl));
            curl_close($curl);

            if (!isset($response->status) && !isset($response->statusCode)) {
                echo json_encode(['error3' => 'No status or statusCode found']);
                die();
            }

            $status = isset($response->statusCode) ? $response->statusCode : $response->status;
            if ($status != 201) {
                echo json_encode(['error1' => $response->title, 'status' => $status]);
                die();
            }

            $saman_order_id = $response->result->id;

            /*-----------------------------------------------------------------------------*/
            // Create Sub-Transactions and Put Them To The Created Folder

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://b2bapi.sb24.ir:8443/api/v1/b2bapi/payments/' . $saman_order_id . '/transactions',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode([
                    "transactions" => [
                        [
                            "trackingId"                => $transaction_id,
                            "destinationIban"           => $shaba,
                            "destinationAccountOwner"   => $shaba_owner_name,
                            "description"               => $for,
                            "amount"                    => $transaction_amount,
                            "paymentNumber"             => $payment_number,
                            "reasonCode"                => "POSA"
                        ]
                    ]
                ]),
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                ),
            ));
            $response = json_decode(curl_exec($curl));
            curl_close($curl);

            if (!isset($response->status) && !isset($response->statusCode)) {
                echo json_encode(['error5' => 'No status or statusCode found']);
                die();
            }

            $status = isset($response->statusCode) ? $response->statusCode : $response->status;
            if ($status != 201) {
                saeed_print($response);
                die();
            }

            /*-----------------------------------------------------------------------------*/
            // Confirm Order

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://b2bapi.sb24.ir:8443/api/v1/b2bapi/payments/' . $saman_order_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PUT',
                CURLOPT_POSTFIELDS => '{
                    "status": "confirmed"
                }',
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $token
                ),
            ));
            $response = json_decode(curl_exec($curl));
            curl_close($curl);

            if (!isset($response->status) && !isset($response->statusCode)) {
                echo json_encode(['error7' => 'No status or statusCode found']);
                die();
            }

            $status = isset($response->statusCode) ? $response->statusCode : $response->status;
            if ($status != 202) {
                echo json_encode(['error3' => $response->title, 'status' => $status]);
                die();
            }

            /*-----------------------------------------------------------------------------*/

            $actions[] = [
                'action'    => 'انجام شد',
                'time'      => time()
            ];

            $update_transaction = array (
                'status'    => 'انجام شد',
                'actions'   => serialize( $actions ),
            );
            $wldb->update($update_transaction, $transaction_id);

            wp_redirect( admin_url(sprintf('admin.php?page=%s', $_GET['page'])) );
        }
    } ?>

    <script>
        jQuery(document).ready(function($) {
            $('body').on('click', '.admin_withdraw_request_approve', function () {
                if ( $(this).val() != "-1" )
                    if ( !confirm('تایید شود؟') )
                        return false;
            });
            $('body').on('click', '.admin_withdraw_request_refuse', function () {
                if ( $(this).val() != "-1" )
                    if ( !confirm('رد شود؟') )
                        return false;
            });
        });
    </script>

    <div id="tav_wallet_admin_main_wrapper">
        <div id="tav_wallet_admin_main_transaction_table_wrapper">

            <?php
            $transactions = $wldb->get( array( 'type' => 'withdraw', 'status' => 'در حال پردازش' ), 500 );
            if ( !empty($transactions) ) : ?>

                <table id="tav_wallet_table">
                    <tr>
                        <th>ردیف</th>
                        <th>برند</th>
                        <th>آی دی کاربر</th>
                        <th>شماره تراکنش</th>
                        <th>زمان درخواست</th>
                        <th>موجودی قبلی</th>
                        <th style="background: #ffa700;">مبلغ درخواستی</th>
                        <th>موجودی فعلی</th>
                        <th>بابت</th>
                        <th>مبدا</th>
                        <th>عملیات</th>
                    </tr>

                    <?php
                    foreach ( $transactions as $key => $trans ) :
                        $user_products = $wpdb->get_results( "SELECT *  FROM `wp_postmeta` WHERE `meta_key` LIKE 'user_ebtal' AND `meta_value` LIKE {$trans->user_id}", ARRAY_A );

                        $active_products = [];
                        foreach ( $user_products as $user_product ) {
                            $product_id = $user_product['post_id'];

                            $is_active = get_post_meta($product_id, 'sale_active', true);
                            $post_type = get_post_type($product_id);

                            if ( $is_active && $post_type == 'product' ) {
                                $active_products[]      = wc_get_product($product_id)->get_name();
                                $active_products_id[$trans->ID][]   = $product_id;
                            }

                            $brand_data = get_the_terms($active_products_id[$trans->ID][0], 'yith_product_brand')[0];
                            $brand_names[$trans->ID] = $brand_data->name;
                        } ?>

                        <tr transaction-data="<?php echo $trans->ID?>">
                            <td><?php echo $key + 1 ?></td>
                            <td><?php echo $brand_names[$trans->ID] ?></td>
                            <td><?php echo $trans->user_id ?></td>
                            <td><?php echo $trans->ID ?></td>
                            <td><?php echo parsidate('j M | H:i', $trans->created_at, 'fa') ?></td>
                            <td><?php echo number_format( $trans->balance - $trans->amount ) ?></td>
                            <td><?php echo number_format( abs($trans->amount) ) ?></td>
                            <td><?php echo number_format( $trans->balance ) ?></td>
                            <td><?php echo implode(' __ ', $active_products) ?></td>
                            <td><?php echo !$trans->origin ? 'نامشخص' : ($trans->origin == 2 ? 'اپ' : 'وب') ?></td>
                            <!--                            <td>-->
                            <!--                                <a href="?page=ez_withdrawal&transaction_id=--><?php //echo $trans->ID ?><!--&function=refuse" class="admin_withdraw_request_refuse">رد کردن</a>-->
                            <!--                                <a href="?page=ez_withdrawal&transaction_id=--><?php //echo $trans->ID ?><!--&function=approve"class="admin_withdraw_request_approve">تایید</a>-->
                            <!--                            </td>-->
                            <td>
                                <a href="?page=ez_withdrawal&transaction_id=<?php echo $trans->ID ?>&function=refuse" class="admin_withdraw_request_refuse">رد کردن</a>
                                <a href="?page=ez_withdrawal&transaction_id=<?php echo $trans->ID ?>&user_id=<?php echo $trans->user_id ?>&for=<?php echo implode(' __ ', $active_products) ?>&function=approve" class="admin_withdraw_request_approve">تایید</a>
                            </td>
                        </tr>

                    <?php
                    endforeach; ?>
                </table>

            <?php
            else: ?>
                <p id="tav_wallet_no_transactions"><?php echo 'هیچ درخواست تسویه حسابی نداریم!' ?></p>
            <?php
            endif; ?>

        </div>
    </div>

    <style>
        .admin_withdraw_request_approve {
            background: #089500;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            color: #fff;
            text-decoration: none;
        }
        .admin_withdraw_request_refuse {
            background: #950100;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            margin: 0 0px;
            color: #fff;
            text-decoration: none;
        }
        #tav_wallet_table tr td:nth-child(7) {
            background: #ffe9a9;
            font-size: 15px;
            font-weight: bold;
        }
    </style>

    <?php
}
/****************************************************************************************************************************************/
function ez_withdrawal_paid_ui_func () {
    global $wpdb, $wldb; ?>

    <div id="tav_wallet_admin_main_wrapper">
        <div id="tav_wallet_admin_main_transaction_table_wrapper">

            <?php
            $max_page_num   = 100;
            $page_num       = isset($_GET['page_num']) ? $_GET['page_num'] : 1;

            $transactions = $wldb->get( array( 'type' => 'withdraw', 'status' => 'انجام شد' ), $max_page_num, false, $page_num );
            if ( !empty($transactions) ) : ?>

                <table id="tav_wallet_table">
                    <tr>
                        <th>ردیف</th>
                        <th>برند</th>
                        <th>آی دی کاربر</th>
                        <th>شماره تراکنش</th>
                        <th>زمان درخواست</th>
                        <th style="background: #ffa700;">مبلغ پرداخت شده</th>
                        <th>بابت</th>
                    </tr>

                    <?php
                    foreach ( $transactions as $key => $trans ) :
                        $user_products = $wpdb->get_results( "SELECT *  FROM `wp_postmeta` WHERE `meta_key` LIKE 'user_ebtal' AND `meta_value` LIKE {$trans->user_id}", ARRAY_A );

                        $active_products = [];
                        foreach ( $user_products as $user_product ) {
                            $product_id = $user_product['post_id'];

                            $is_active = get_post_meta($product_id, 'sale_active', true);
                            $post_type = get_post_type($product_id);

                            if ( $is_active && $post_type == 'product' ) {
                                $active_products[]      = wc_get_product($product_id)->get_name();
                                $active_products_id[$trans->ID][]   = $product_id;
                            }

                            $brand_data = get_the_terms($active_products_id[$trans->ID][0], 'yith_product_brand')[0];
                            $brand_names[$trans->ID] = $brand_data->name;
                        } ?>

                        <tr transaction-data="<?php echo $trans->ID?>">
                            <td><?php echo $key + 1 ?></td>
                            <td><?php echo $brand_names[$trans->ID] ?></td>
                            <td><?php echo $trans->user_id ?></td>
                            <td><?php echo $trans->ID ?></td>
                            <td><?php echo parsidate('j M | H:i', $trans->created_at, 'fa') ?></td>
                            <td><?php echo number_format( abs($trans->amount) ) ?></td>
                            <td><?php echo implode(' __ ', $active_products) ?></td>
                        </tr>

                    <?php
                    endforeach; ?>
                </table>

                <?php
                $current_page   = max(1, min($page_num, $max_page_num));
                $adjacent_pages = 2; ?>

                <div class="pagination">
                    <?php
                    if ($current_page > 1) : ?>
                        <a href="<?php echo home_url('/wp-admin/admin.php?page=ez_withdrawal_paid') ?>&page_num=<?php echo $current_page - 1; ?>" class="prev">قبلی</a>
                    <?php endif; ?>

                    <?php
                    for ($i = 1; $i <= $max_page_num; $i++):

                        if ($i == $current_page): ?>
                            <span class="page-number current"><?php echo $i; ?></span>
                        <?php
                        elseif ($i <= $adjacent_pages || $i > $max_page_num - $adjacent_pages || ($i >= $current_page - $adjacent_pages && $i <= $current_page + $adjacent_pages)): ?>
                            <a href="<?php echo home_url('/wp-admin/admin.php?page=ez_withdrawal_paid') ?>&page_num=<?php echo $i; ?>" class="page-number"><?php echo $i; ?></a>
                        <?php
                        elseif ($i == $adjacent_pages + 1 || $i == $max_page_num - $adjacent_pages) : ?>
                            <span class="dots">...</span>
                        <?php
                        endif; ?>
                    <?php
                    endfor; ?>

                    <?php
                    if ($current_page < $max_page_num): ?>
                        <a href="<?php echo home_url('/wp-admin/admin.php?page=ez_withdrawal_paid') ?>&page_num=<?php echo $current_page + 1; ?>" class="next">بعدی</a>
                    <?php
                    endif; ?>
                </div>

            <?php
            else: ?>
                <p id="tav_wallet_no_transactions"><?php echo 'هیچ درخواست تسویه حسابی نداریم!' ?></p>
            <?php
            endif; ?>

        </div>
    </div>

    <style>
        .admin_withdraw_request_approve {
            background: #089500;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            color: #fff;
            text-decoration: none;
        }
        .admin_withdraw_request_refuse {
            background: #950100;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            margin: 0 0px;
            color: #fff;
            text-decoration: none;
        }
        #tav_wallet_table tr td:nth-child(5) {
            background: #ffe9a9;
            font-size: 15px;
            font-weight: bold;
        }
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .pagination a {
            text-decoration: none;
            color: #f97316;
            padding: 8px 12px;
            border: 1px solid #f97316;
            border-radius: 5px;
            margin: 0 5px;
            transition: background-color 0.3s, color 0.3s;
        }
        .pagination a:hover {
            background-color: #f97316;
            color: #fff;
        }
        .pagination .dots {
            padding: 8px 12px;
        }
        .pagination .prev, .pagination .next {
            font-weight: bold;
        }
        .pagination .current {
            font-weight: bold;
            color: #fff;
            background-color: #f97316;
            padding: 8px 12px;
            border-radius: 5px;
            margin: 0 5px;
        }
        .pagination {
            width: 100%;
            margin-top: 50px;
        }
    </style>

    <?php
}
/****************************************************************************************************************************************/
function ez_withdrawal_rejected_ui_func () {
    global $wpdb, $wldb; ?>

    <div id="tav_wallet_admin_main_wrapper">
        <div id="tav_wallet_admin_main_transaction_table_wrapper">

            <?php
            $transactions = $wldb->get( array( 'type' => 'withdraw', 'status' => 'رد شده' ), 500 );
            if ( !empty($transactions) ) : ?>

                <table id="tav_wallet_table">
                    <tr>
                        <th>ردیف</th>
                        <th>برند</th>
                        <th>آی دی کاربر</th>
                        <th>شماره تراکنش</th>
                        <th>زمان درخواست</th>
                        <th style="background: #ffa700;">مبلغ پرداخت شده</th>
                        <th>بابت</th>
                    </tr>

                    <?php
                    foreach ( $transactions as $key => $trans ) :
                        $user_products = $wpdb->get_results( "SELECT *  FROM `wp_postmeta` WHERE `meta_key` LIKE 'user_ebtal' AND `meta_value` LIKE {$trans->user_id}", ARRAY_A );

                        $active_products = [];
                        foreach ( $user_products as $user_product ) {
                            $product_id = $user_product['post_id'];

                            $is_active = get_post_meta($product_id, 'sale_active', true);
                            $post_type = get_post_type($product_id);

                            if ( $is_active && $post_type == 'product' ) {
                                $active_products[]      = wc_get_product($product_id)->get_name();
                                $active_products_id[$trans->ID][]   = $product_id;
                            }

                            $brand_data = get_the_terms($active_products_id[$trans->ID][0], 'yith_product_brand')[0];
                            $brand_names[$trans->ID] = $brand_data->name;
                        } ?>

                        <tr transaction-data="<?php echo $trans->ID?>">
                            <td><?php echo $key + 1 ?></td>
                            <td><?php echo $brand_names[$trans->ID] ?></td>
                            <td><?php echo $trans->user_id ?></td>
                            <td><?php echo $trans->ID ?></td>
                            <td><?php echo parsidate('j M | H:i', $trans->created_at, 'fa') ?></td>
                            <td><?php echo number_format( abs($trans->amount) ) ?></td>
                            <td><?php echo implode(' __ ', $active_products) ?></td>
                        </tr>

                    <?php
                    endforeach; ?>
                </table>

            <?php
            else: ?>
                <p id="tav_wallet_no_transactions"><?php echo 'هیچ درخواست تسویه حسابی نداریم!' ?></p>
            <?php
            endif; ?>

        </div>
    </div>

    <style>
        .admin_withdraw_request_approve {
            background: #089500;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            color: #fff;
            text-decoration: none;
        }
        .admin_withdraw_request_refuse {
            background: #950100;
            padding: 4px 10px;
            border-radius: 8px;
            cursor: pointer;
            margin: 0 0px;
            color: #fff;
            text-decoration: none;
        }
        #tav_wallet_table tr td:nth-child(6) {
            background: #ffe9a9;
            font-size: 15px;
            font-weight: bold;
        }
    </style>

    <?php
}
/****************************************************************************************************************************************/
add_action('wp', function() {
    $term = substr($_SERVER['REQUEST_URI'], 1);

    if ( is_numeric( explode('/', $term)[0] ) )
        wp_redirect(get_permalink($term));
});
/****************************************************************************************************************************************/
add_action('admin_init', function() {

    if (defined('DOING_AJAX') && DOING_AJAX) return;

    $user = wp_get_current_user();
    foreach ($user->roles as $role) {

        if( $role == 'shopist' ) { ?>

            <style>
                .subsubsub .poshtiban {
                    display: inline-block!important;
                }
            </style>

            <?php
        }

        if( $role == 'shopist' || $role == 'contentist' || $role == 'editor' ) {

            if($_SERVER['SCRIPT_URL'] != "/wp-admin/upload.php") : ?>
                <style>
                    li#toplevel_page_persian-wc, #menu-tools, #menu-settings, #toplevel_page_edit-post_type-acf-field-group, #toplevel_page_wpseo_workouts, #toplevel_page_held_status_accounting_management, #toplevel_page_month_best_sell, #toplevel_page_litespeed, #toplevel_page_ez-slider, #toplevel_page_rate-my-post, #toplevel_page_acf-options-poshtibanan,
                    .subsubsub .all, .subsubsub .editor, .subsubsub .author, .subsubsub .customer, .subsubsub .poshtiban, .subsubsub .shopist, .subsubsub .contentist, .subsubsub .accounting
                    {
                        display: none;
                    }
                </style>

            <?php
            endif;

            if($_SERVER['REQUEST_URI'] == "/wp-admin/users.php")
                wp_redirect(home_url("wp-admin/users.php?role=compiler"));
        }

        if( $role == 'accounting' ) { ?>
            <style>
                li#toplevel_page_persian-wc, #menu-tools, #menu-settings, #toplevel_page_edit-post_type-acf-field-group,
                #toplevel_page_wpseo_workouts, #toplevel_page_held_status_accounting_management, #toplevel_page_month_best_sell,
                #toplevel_page_litespeed, #toplevel_page_ez-slider, #toplevel_page_rate-my-post, #toplevel_page_acf-options-poshtibanan,#menu-posts,
                #toplevel_page_yith_plugin_panel, #menu-comments, #menu-appearance, #toplevel_page_woocommerce-marketing, #toplevel_page_woocommerce .wp-submenu.wp-submenu-wrap li, #toplevel_page_Ez_Wallet ul,
                #toplevel_page_woo-wallet ul
                {
                    display: none;
                }
                #toplevel_page_woocommerce .wp-submenu.wp-submenu-wrap li:nth-child(3)
                {
                    display: block;
                }
            </style>
            <?php
        }
    }
    return false;
});
/****************************************************************************************************************************************/
//add_action('single_schedule_changed', 'single_schedule_changed', 10, 3);
function single_schedule_changed ($product_id, $booking_time, $state) {
    ez_webservice( array('type' => 'single_schedule_products_set', 'data' => array('product_id' => $product_id, 'booking' => $booking_time, 'state' => $state)) ); // آپدیت کردن زمان سانس ها
}
/****************************************************************************************************************************************/
function update_held_sans_table_func () {
    global $wpdb;

    $penalty_products = [73114, 261541, 261593];

    $partially_orders = [];
    $temp = $wpdb->get_results( "SELECT wp_posts.ID FROM wp_posts WHERE post_status = 'wc-partially-paid' OR post_status = 'wc-held' OR post_status = 'wc-completed'", ARRAY_A );
    foreach ( $temp as $order_arr )
        $partially_orders[] = $order_arr['ID'];
    $partially_orders = implode(',', $partially_orders);

    $rows = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "SELECT wc_order_id as ID, booking_time as booking_time FROM wp_zb_booking_history WHERE `wc_order_id` IN ($partially_orders)"])), true);

    foreach ( $rows as $row ) {

        if ( $row['booking_time'] < time() - 4 * 3600 && time() - 30 * 24 * 3600 < $row['booking_time']  ) {

            $order_id = $row['ID'];

            $duplicate_check = $wpdb->get_results( "SELECT * FROM held_orders_list WHERE order_id LIKE '" . $order_id . "'", ARRAY_A );

            if ( count($duplicate_check) < 1 ) {

                $order = wc_get_order($order_id);
                foreach ($order->get_items() as $item) {
                    $product_id = $item->get_product_id();
                    $quantity = $item->get_quantity();

                    if ( in_array($product_id, $penalty_products) )
                        $quantity = $quantity / 1.5;
                }

                $wpdb->insert( 'held_orders_list', array(
                    'room_id'   => $product_id,
                    'order_id'  => $order_id,
                    'count'     => $quantity,
                    'held_time' => $row['booking_time']
                ));
            }
        }
    }

    $wpdb->get_results( "DELETE FROM held_orders_list WHERE held_time < UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 30 DAY))");
}
/****************************************************************************************************************************************/
function ez_get_user_ip() {
    $headers = array ('HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'HTTP_VIA', 'HTTP_X_COMING_FROM', 'HTTP_COMING_FROM', 'HTTP_CLIENT_IP' );

    foreach ( $headers as $header ) {
        if (isset ( $_SERVER [$header]  )) {

            if (($pos = strpos ( $_SERVER [$header], ',' )) != false) {
                $ip = substr ( $_SERVER [$header], 0, $pos );
            } else {
                $ip = $_SERVER [$header];
            }
            $ipnum = ip2long ( $ip );
            if ($ipnum !== - 1 && $ipnum !== false && (long2ip ( $ipnum ) === $ip)) {
                if (($ipnum - 184549375) && // Not in 10.0.0.0/8
                    ($ipnum  - 1407188993) && // Not in 172.16.0.0/12
                    ($ipnum  - 1062666241)) // Not in 192.168.0.0/16
                    if (($pos = strpos ( $_SERVER [$header], ',' )) != false) {
                        $ip = substr ( $_SERVER [$header], 0, $pos );
                    } else {
                        $ip = $_SERVER [$header];
                    }
                return $ip;
            }
        }

    }
    return $_SERVER ['REMOTE_ADDR'];
}
/****************************************************************************************************************************************/
add_action('trash_comment', 'ez_remove_product_comment' );
function ez_remove_product_comment( $comment_id ){

    $comment    = get_comment( $comment_id );
    $f3_roomid  = $comment->comment_post_ID;
    $approved   = $comment->comment_approved;

    if ( $approved ) {

        // update room rate
        $temp = get_post_meta($f3_roomid, 'product_rates', true);
        $comment_rating = get_comment_meta($comment_id, "comment_rating", true);

        $temp[1098] -= (int)$comment_rating[1098];
        $temp[1097] -= (int)$comment_rating[1097];
        $temp[1096] -= (int)$comment_rating[1096];
        $temp[1095] -= (int)$comment_rating[1095];
        $temp[1094] -= (int)$comment_rating[1094];
        update_post_meta($f3_roomid, 'product_rates', $temp);

        // update comments_count
        $temp2 = get_post_meta($f3_roomid, 'comments_count_new', true);
        update_post_meta($f3_roomid, 'comments_count_new', --$temp2);
    }
}
/****************************************************************************************************************************************/
add_action('transition_comment_status', 'my_approve_comment_callback', 10, 3);
function my_approve_comment_callback($new_status, $old_status, $comment) { // if a unapproved comment was approved
    if($old_status != $new_status) {
        if($new_status == 'approved') {

            $comment_id = $comment->comment_ID;
            $f3_roomid  = $comment->comment_post_ID;

            // update room rate
            $temp           = get_post_meta($f3_roomid, 'product_rates', true);
            $product_rates  = !empty($temp) ? $temp : [1098 => 0, 1097 => 0, 1096 => 0, 1095 => 0, 1094 => 0];
            $comment_rating = get_comment_meta($comment_id, "comment_rating", true);

            $product_rates[1098] += (int)$comment_rating[1098];
            $product_rates[1097] += (int)$comment_rating[1097];
            $product_rates[1096] += (int)$comment_rating[1096];
            $product_rates[1095] += (int)$comment_rating[1095];
            $product_rates[1094] += (int)$comment_rating[1094];
            update_post_meta($f3_roomid, 'product_rates', $product_rates);

            // update comments_count
            $temp2  = get_post_meta($f3_roomid, 'comments_count_new', true);
            $temp2  = !empty($temp2) ? $temp2 : 0;
            update_post_meta($f3_roomid, 'comments_count_new', ++$temp2);
        }
    }
}
/****************************************************************************************************************************************/
add_action('product_tag_edit_form_fields', 'add_fields_to_product_tag', 10, 1);
function add_fields_to_product_tag($term) {

    $term_id = $term->term_id;

    $args = array (
        'post_type'         => 'product',
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
        'meta_query' => array (
            array (
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $query = new WP_Query($args); ?>

    <script>
        !function(n){"function"==typeof define&&define.amd?define(["jquery"],n):"object"==typeof module&&module.exports?module.exports=function(e,t){return void 0===t&&(t="undefined"!=typeof window?require("jquery"):require("jquery")(e)),n(t),t}:n(jQuery)}(function(t){var e,n,s,p,r,o,h,f,g,m,y,v,i,a,_,s=((u=t&&t.fn&&t.fn.select2&&t.fn.select2.amd?t.fn.select2.amd:u)&&u.requirejs||(u?n=u:u={},g={},m={},y={},v={},i=Object.prototype.hasOwnProperty,a=[].slice,_=/\.js$/,h=function(e,t){var n,s,i=c(e),r=i[0],t=t[1];return e=i[1],r&&(n=x(r=l(r,t))),r?e=n&&n.normalize?n.normalize(e,(s=t,function(e){return l(e,s)})):l(e,t):(r=(i=c(e=l(e,t)))[0],e=i[1],r&&(n=x(r))),{f:r?r+"!"+e:e,n:e,pr:r,p:n}},f={require:function(e){return w(e)},exports:function(e){var t=g[e];return void 0!==t?t:g[e]={}},module:function(e){return{id:e,uri:"",exports:g[e],config:(t=e,function(){return y&&y.config&&y.config[t]||{}})};var t}},r=function(e,t,n,s){var i,r,o,a,l,c=[],u=typeof n,d=A(s=s||e);if("undefined"==u||"function"==u){for(t=!t.length&&n.length?["require","exports","module"]:t,a=0;a<t.length;a+=1)if("require"===(r=(o=h(t[a],d)).f))c[a]=f.require(e);else if("exports"===r)c[a]=f.exports(e),l=!0;else if("module"===r)i=c[a]=f.module(e);else if(b(g,r)||b(m,r)||b(v,r))c[a]=x(r);else{if(!o.p)throw new Error(e+" missing "+r);o.p.load(o.n,w(s,!0),function(t){return function(e){g[t]=e}}(r),{}),c[a]=g[r]}u=n?n.apply(g[e],c):void 0,e&&(i&&i.exports!==p&&i.exports!==g[e]?g[e]=i.exports:u===p&&l||(g[e]=u))}else e&&(g[e]=n)},e=n=o=function(e,t,n,s,i){if("string"==typeof e)return f[e]?f[e](t):x(h(e,A(t)).f);if(!e.splice){if((y=e).deps&&o(y.deps,y.callback),!t)return;t.splice?(e=t,t=n,n=null):e=p}return t=t||function(){},"function"==typeof n&&(n=s,s=i),s?r(p,e,t,n):setTimeout(function(){r(p,e,t,n)},4),o},o.config=function(e){return o(e)},e._defined=g,(s=function(e,t,n){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(n=t,t=[]),b(g,e)||b(m,e)||(m[e]=[e,t,n])}).amd={jQuery:!0},u.requirejs=e,u.require=n,u.define=s),u.define("almond",function(){}),u.define("jquery",[],function(){var e=t||$;return null==e&&console&&console.error&&console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."),e}),u.define("select2/utils",["jquery"],function(r){var s={};function c(e){var t,n=e.prototype,s=[];for(t in n)"function"==typeof n[t]&&"constructor"!==t&&s.push(t);return s}s.Extend=function(e,t){var n,s={}.hasOwnProperty;function i(){this.constructor=e}for(n in t)s.call(t,n)&&(e[n]=t[n]);return i.prototype=t.prototype,e.prototype=new i,e.__super__=t.prototype,e},s.Decorate=function(s,i){var e=c(i),t=c(s);function r(){var e=Array.prototype.unshift,t=i.prototype.constructor.length,n=s.prototype.constructor;0<t&&(e.call(arguments,s.prototype.constructor),n=i.prototype.constructor),n.apply(this,arguments)}i.displayName=s.displayName,r.prototype=new function(){this.constructor=r};for(var n=0;n<t.length;n++){var o=t[n];r.prototype[o]=s.prototype[o]}for(var a=0;a<e.length;a++){var l=e[a];r.prototype[l]=function(e){var t=function(){};e in r.prototype&&(t=r.prototype[e]);var n=i.prototype[e];return function(){return Array.prototype.unshift.call(arguments,t),n.apply(this,arguments)}}(l)}return r};function e(){this.listeners={}}e.prototype.on=function(e,t){this.listeners=this.listeners||{},e in this.listeners?this.listeners[e].push(t):this.listeners[e]=[t]},e.prototype.trigger=function(e){var t=Array.prototype.slice,n=t.call(arguments,1);this.listeners=this.listeners||{},0===(n=null==n?[]:n).length&&n.push({}),(n[0]._type=e)in this.listeners&&this.invoke(this.listeners[e],t.call(arguments,1)),"*"in this.listeners&&this.invoke(this.listeners["*"],arguments)},e.prototype.invoke=function(e,t){for(var n=0,s=e.length;n<s;n++)e[n].apply(this,t)},s.Observable=e,s.generateChars=function(e){for(var t="",n=0;n<e;n++)t+=Math.floor(36*Math.random()).toString(36);return t},s.bind=function(e,t){return function(){e.apply(t,arguments)}},s._convertData=function(e){for(var t in e){var n=t.split("-"),s=e;if(1!==n.length){for(var i=0;i<n.length;i++){var r=n[i];(r=r.substring(0,1).toLowerCase()+r.substring(1))in s||(s[r]={}),i==n.length-1&&(s[r]=e[t]),s=s[r]}delete e[t]}}return e},s.hasScroll=function(e,t){var n=r(t),s=t.style.overflowX,i=t.style.overflowY;return(s!==i||"hidden"!==i&&"visible"!==i)&&("scroll"===s||"scroll"===i||(n.innerHeight()<t.scrollHeight||n.innerWidth()<t.scrollWidth))},s.escapeMarkup=function(e){var t={"\\":"&#92;","&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#47;"};return"string"!=typeof e?e:String(e).replace(/[&<>"'\/\\]/g,function(e){return t[e]})},s.__cache={};var n=0;return s.GetUniqueElementId=function(e){var t=e.getAttribute("data-select2-id");return null!=t||(t=e.id?"select2-data-"+e.id:"select2-data-"+(++n).toString()+"-"+s.generateChars(4),e.setAttribute("data-select2-id",t)),t},s.StoreData=function(e,t,n){e=s.GetUniqueElementId(e);s.__cache[e]||(s.__cache[e]={}),s.__cache[e][t]=n},s.GetData=function(e,t){var n=s.GetUniqueElementId(e);return t?s.__cache[n]&&null!=s.__cache[n][t]?s.__cache[n][t]:r(e).data(t):s.__cache[n]},s.RemoveData=function(e){var t=s.GetUniqueElementId(e);null!=s.__cache[t]&&delete s.__cache[t],e.removeAttribute("data-select2-id")},s.copyNonInternalCssClasses=function(e,t){var n=(n=e.getAttribute("class").trim().split(/\s+/)).filter(function(e){return 0===e.indexOf("select2-")}),t=(t=t.getAttribute("class").trim().split(/\s+/)).filter(function(e){return 0!==e.indexOf("select2-")}),t=n.concat(t);e.setAttribute("class",t.join(" "))},s}),u.define("select2/results",["jquery","./utils"],function(d,p){function s(e,t,n){this.$element=e,this.data=n,this.options=t,s.__super__.constructor.call(this)}return p.Extend(s,p.Observable),s.prototype.render=function(){var e=d('<ul class="select2-results__options" role="listbox"></ul>');return this.options.get("multiple")&&e.attr("aria-multiselectable","true"),this.$results=e},s.prototype.clear=function(){this.$results.empty()},s.prototype.displayMessage=function(e){var t=this.options.get("escapeMarkup");this.clear(),this.hideLoading();var n=d('<li role="alert" aria-live="assertive" class="select2-results__option"></li>'),s=this.options.get("translations").get(e.message);n.append(t(s(e.args))),n[0].className+=" select2-results__message",this.$results.append(n)},s.prototype.hideMessages=function(){this.$results.find(".select2-results__message").remove()},s.prototype.append=function(e){this.hideLoading();var t=[];if(null!=e.results&&0!==e.results.length){e.results=this.sort(e.results);for(var n=0;n<e.results.length;n++){var s=e.results[n],s=this.option(s);t.push(s)}this.$results.append(t)}else 0===this.$results.children().length&&this.trigger("results:message",{message:"noResults"})},s.prototype.position=function(e,t){t.find(".select2-results").append(e)},s.prototype.sort=function(e){return this.options.get("sorter")(e)},s.prototype.highlightFirstItem=function(){var e=this.$results.find(".select2-results__option--selectable"),t=e.filter(".select2-results__option--selected");(0<t.length?t:e).first().trigger("mouseenter"),this.ensureHighlightVisible()},s.prototype.setClasses=function(){var t=this;this.data.current(function(e){var s=e.map(function(e){return e.id.toString()});t.$results.find(".select2-results__option--selectable").each(function(){var e=d(this),t=p.GetData(this,"data"),n=""+t.id;null!=t.element&&t.element.selected||null==t.element&&-1<s.indexOf(n)?(this.classList.add("select2-results__option--selected"),e.attr("aria-selected","true")):(this.classList.remove("select2-results__option--selected"),e.attr("aria-selected","false"))})})},s.prototype.showLoading=function(e){this.hideLoading();e={disabled:!0,loading:!0,text:this.options.get("translations").get("searching")(e)},e=this.option(e);e.className+=" loading-results",this.$results.prepend(e)},s.prototype.hideLoading=function(){this.$results.find(".loading-results").remove()},s.prototype.option=function(e){var t=document.createElement("li");t.classList.add("select2-results__option"),t.classList.add("select2-results__option--selectable");var n,s={role:"option"},i=window.Element.prototype.matches||window.Element.prototype.msMatchesSelector||window.Element.prototype.webkitMatchesSelector;for(n in(null!=e.element&&i.call(e.element,":disabled")||null==e.element&&e.disabled)&&(s["aria-disabled"]="true",t.classList.remove("select2-results__option--selectable"),t.classList.add("select2-results__option--disabled")),null==e.id&&t.classList.remove("select2-results__option--selectable"),null!=e._resultId&&(t.id=e._resultId),e.title&&(t.title=e.title),e.children&&(s.role="group",s["aria-label"]=e.text,t.classList.remove("select2-results__option--selectable"),t.classList.add("select2-results__option--group")),s){var r=s[n];t.setAttribute(n,r)}if(e.children){var o=d(t),a=document.createElement("strong");a.className="select2-results__group",this.template(e,a);for(var l=[],c=0;c<e.children.length;c++){var u=e.children[c],u=this.option(u);l.push(u)}i=d("<ul></ul>",{class:"select2-results__options select2-results__options--nested",role:"none"});i.append(l),o.append(a),o.append(i)}else this.template(e,t);return p.StoreData(t,"data",e),t},s.prototype.bind=function(t,e){var i=this,n=t.id+"-results";this.$results.attr("id",n),t.on("results:all",function(e){i.clear(),i.append(e.data),t.isOpen()&&(i.setClasses(),i.highlightFirstItem())}),t.on("results:append",function(e){i.append(e.data),t.isOpen()&&i.setClasses()}),t.on("query",function(e){i.hideMessages(),i.showLoading(e)}),t.on("select",function(){t.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())}),t.on("unselect",function(){t.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())}),t.on("open",function(){i.$results.attr("aria-expanded","true"),i.$results.attr("aria-hidden","false"),i.setClasses(),i.ensureHighlightVisible()}),t.on("close",function(){i.$results.attr("aria-expanded","false"),i.$results.attr("aria-hidden","true"),i.$results.removeAttr("aria-activedescendant")}),t.on("results:toggle",function(){var e=i.getHighlightedResults();0!==e.length&&e.trigger("mouseup")}),t.on("results:select",function(){var e,t=i.getHighlightedResults();0!==t.length&&(e=p.GetData(t[0],"data"),t.hasClass("select2-results__option--selected")?i.trigger("close",{}):i.trigger("select",{data:e}))}),t.on("results:previous",function(){var e,t=i.getHighlightedResults(),n=i.$results.find(".select2-results__option--selectable"),s=n.index(t);s<=0||(e=s-1,0===t.length&&(e=0),(s=n.eq(e)).trigger("mouseenter"),t=i.$results.offset().top,n=s.offset().top,s=i.$results.scrollTop()+(n-t),0===e?i.$results.scrollTop(0):n-t<0&&i.$results.scrollTop(s))}),t.on("results:next",function(){var e,t=i.getHighlightedResults(),n=i.$results.find(".select2-results__option--selectable"),s=n.index(t)+1;s>=n.length||((e=n.eq(s)).trigger("mouseenter"),t=i.$results.offset().top+i.$results.outerHeight(!1),n=e.offset().top+e.outerHeight(!1),e=i.$results.scrollTop()+n-t,0===s?i.$results.scrollTop(0):t<n&&i.$results.scrollTop(e))}),t.on("results:focus",function(e){e.element[0].classList.add("select2-results__option--highlighted"),e.element[0].setAttribute("aria-selected","true")}),t.on("results:message",function(e){i.displayMessage(e)}),d.fn.mousewheel&&this.$results.on("mousewheel",function(e){var t=i.$results.scrollTop(),n=i.$results.get(0).scrollHeight-t+e.deltaY,t=0<e.deltaY&&t-e.deltaY<=0,n=e.deltaY<0&&n<=i.$results.height();t?(i.$results.scrollTop(0),e.preventDefault(),e.stopPropagation()):n&&(i.$results.scrollTop(i.$results.get(0).scrollHeight-i.$results.height()),e.preventDefault(),e.stopPropagation())}),this.$results.on("mouseup",".select2-results__option--selectable",function(e){var t=d(this),n=p.GetData(this,"data");t.hasClass("select2-results__option--selected")?i.options.get("multiple")?i.trigger("unselect",{originalEvent:e,data:n}):i.trigger("close",{}):i.trigger("select",{originalEvent:e,data:n})}),this.$results.on("mouseenter",".select2-results__option--selectable",function(e){var t=p.GetData(this,"data");i.getHighlightedResults().removeClass("select2-results__option--highlighted").attr("aria-selected","false"),i.trigger("results:focus",{data:t,element:d(this)})})},s.prototype.getHighlightedResults=function(){return this.$results.find(".select2-results__option--highlighted")},s.prototype.destroy=function(){this.$results.remove()},s.prototype.ensureHighlightVisible=function(){var e,t,n,s,i=this.getHighlightedResults();0!==i.length&&(e=this.$results.find(".select2-results__option--selectable").index(i),s=this.$results.offset().top,t=i.offset().top,n=this.$results.scrollTop()+(t-s),s=t-s,n-=2*i.outerHeight(!1),e<=2?this.$results.scrollTop(0):(s>this.$results.outerHeight()||s<0)&&this.$results.scrollTop(n))},s.prototype.template=function(e,t){var n=this.options.get("templateResult"),s=this.options.get("escapeMarkup"),e=n(e,t);null==e?t.style.display="none":"string"==typeof e?t.innerHTML=s(e):d(t).append(e)},s}),u.define("select2/keys",[],function(){return{BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46}}),u.define("select2/selection/base",["jquery","../utils","../keys"],function(n,s,i){function r(e,t){this.$element=e,this.options=t,r.__super__.constructor.call(this)}return s.Extend(r,s.Observable),r.prototype.render=function(){var e=n('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');return this._tabindex=0,null!=s.GetData(this.$element[0],"old-tabindex")?this._tabindex=s.GetData(this.$element[0],"old-tabindex"):null!=this.$element.attr("tabindex")&&(this._tabindex=this.$element.attr("tabindex")),e.attr("title",this.$element.attr("title")),e.attr("tabindex",this._tabindex),e.attr("aria-disabled","false"),this.$selection=e},r.prototype.bind=function(e,t){var n=this,s=e.id+"-results";this.container=e,this.$selection.on("focus",function(e){n.trigger("focus",e)}),this.$selection.on("blur",function(e){n._handleBlur(e)}),this.$selection.on("keydown",function(e){n.trigger("keypress",e),e.which===i.SPACE&&e.preventDefault()}),e.on("results:focus",function(e){n.$selection.attr("aria-activedescendant",e.data._resultId)}),e.on("selection:update",function(e){n.update(e.data)}),e.on("open",function(){n.$selection.attr("aria-expanded","true"),n.$selection.attr("aria-owns",s),n._attachCloseHandler(e)}),e.on("close",function(){n.$selection.attr("aria-expanded","false"),n.$selection.removeAttr("aria-activedescendant"),n.$selection.removeAttr("aria-owns"),n.$selection.trigger("focus"),n._detachCloseHandler(e)}),e.on("enable",function(){n.$selection.attr("tabindex",n._tabindex),n.$selection.attr("aria-disabled","false")}),e.on("disable",function(){n.$selection.attr("tabindex","-1"),n.$selection.attr("aria-disabled","true")})},r.prototype._handleBlur=function(e){var t=this;window.setTimeout(function(){document.activeElement==t.$selection[0]||n.contains(t.$selection[0],document.activeElement)||t.trigger("blur",e)},1)},r.prototype._attachCloseHandler=function(e){n(document.body).on("mousedown.select2."+e.id,function(e){var t=n(e.target).closest(".select2");n(".select2.select2-container--open").each(function(){this!=t[0]&&s.GetData(this,"element").select2("close")})})},r.prototype._detachCloseHandler=function(e){n(document.body).off("mousedown.select2."+e.id)},r.prototype.position=function(e,t){t.find(".selection").append(e)},r.prototype.destroy=function(){this._detachCloseHandler(this.container)},r.prototype.update=function(e){throw new Error("The `update` method must be defined in child classes.")},r.prototype.isEnabled=function(){return!this.isDisabled()},r.prototype.isDisabled=function(){return this.options.get("disabled")},r}),u.define("select2/selection/single",["jquery","./base","../utils","../keys"],function(e,t,n,s){function i(){i.__super__.constructor.apply(this,arguments)}return n.Extend(i,t),i.prototype.render=function(){var e=i.__super__.render.call(this);return e[0].classList.add("select2-selection--single"),e.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'),e},i.prototype.bind=function(t,e){var n=this;i.__super__.bind.apply(this,arguments);var s=t.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",s).attr("role","textbox").attr("aria-readonly","true"),this.$selection.attr("aria-labelledby",s),this.$selection.attr("aria-controls",s),this.$selection.on("mousedown",function(e){1===e.which&&n.trigger("toggle",{originalEvent:e})}),this.$selection.on("focus",function(e){}),this.$selection.on("blur",function(e){}),t.on("focus",function(e){t.isOpen()||n.$selection.trigger("focus")})},i.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},i.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},i.prototype.selectionContainer=function(){return e("<span></span>")},i.prototype.update=function(e){var t,n;0!==e.length?(n=e[0],t=this.$selection.find(".select2-selection__rendered"),e=this.display(n,t),t.empty().append(e),(n=n.title||n.text)?t.attr("title",n):t.removeAttr("title")):this.clear()},i}),u.define("select2/selection/multiple",["jquery","./base","../utils"],function(i,e,c){function r(e,t){r.__super__.constructor.apply(this,arguments)}return c.Extend(r,e),r.prototype.render=function(){var e=r.__super__.render.call(this);return e[0].classList.add("select2-selection--multiple"),e.html('<ul class="select2-selection__rendered"></ul>'),e},r.prototype.bind=function(e,t){var n=this;r.__super__.bind.apply(this,arguments);var s=e.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",s),this.$selection.on("click",function(e){n.trigger("toggle",{originalEvent:e})}),this.$selection.on("click",".select2-selection__choice__remove",function(e){var t;n.isDisabled()||(t=i(this).parent(),t=c.GetData(t[0],"data"),n.trigger("unselect",{originalEvent:e,data:t}))}),this.$selection.on("keydown",".select2-selection__choice__remove",function(e){n.isDisabled()||e.stopPropagation()})},r.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},r.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},r.prototype.selectionContainer=function(){return i('<li class="select2-selection__choice"><button type="button" class="select2-selection__choice__remove" tabindex="-1"><span aria-hidden="true">&times;</span></button><span class="select2-selection__choice__display"></span></li>')},r.prototype.update=function(e){if(this.clear(),0!==e.length){for(var t=[],n=this.$selection.find(".select2-selection__rendered").attr("id")+"-choice-",s=0;s<e.length;s++){var i=e[s],r=this.selectionContainer(),o=this.display(i,r),a=n+c.generateChars(4)+"-";i.id?a+=i.id:a+=c.generateChars(4),r.find(".select2-selection__choice__display").append(o).attr("id",a);var l=i.title||i.text;l&&r.attr("title",l);o=this.options.get("translations").get("removeItem"),l=r.find(".select2-selection__choice__remove");l.attr("title",o()),l.attr("aria-label",o()),l.attr("aria-describedby",a),c.StoreData(r[0],"data",i),t.push(r)}this.$selection.find(".select2-selection__rendered").append(t)}},r}),u.define("select2/selection/placeholder",[],function(){function e(e,t,n){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n)}return e.prototype.normalizePlaceholder=function(e,t){return t="string"==typeof t?{id:"",text:t}:t},e.prototype.createPlaceholder=function(e,t){var n=this.selectionContainer();n.html(this.display(t)),n[0].classList.add("select2-selection__placeholder"),n[0].classList.remove("select2-selection__choice");t=t.title||t.text||n.text();return this.$selection.find(".select2-selection__rendered").attr("title",t),n},e.prototype.update=function(e,t){var n=1==t.length&&t[0].id!=this.placeholder.id;if(1<t.length||n)return e.call(this,t);this.clear();t=this.createPlaceholder(this.placeholder);this.$selection.find(".select2-selection__rendered").append(t)},e}),u.define("select2/selection/allowClear",["jquery","../keys","../utils"],function(i,s,a){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),null==this.placeholder&&this.options.get("debug")&&window.console&&console.error&&console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."),this.$selection.on("mousedown",".select2-selection__clear",function(e){s._handleClear(e)}),t.on("keypress",function(e){s._handleKeyboardClear(e,t)})},e.prototype._handleClear=function(e,t){if(!this.isDisabled()){var n=this.$selection.find(".select2-selection__clear");if(0!==n.length){t.stopPropagation();var s=a.GetData(n[0],"data"),i=this.$element.val();this.$element.val(this.placeholder.id);var r={data:s};if(this.trigger("clear",r),r.prevented)this.$element.val(i);else{for(var o=0;o<s.length;o++)if(r={data:s[o]},this.trigger("unselect",r),r.prevented)return void this.$element.val(i);this.$element.trigger("input").trigger("change"),this.trigger("toggle",{})}}}},e.prototype._handleKeyboardClear=function(e,t,n){n.isOpen()||t.which!=s.DELETE&&t.which!=s.BACKSPACE||this._handleClear(t)},e.prototype.update=function(e,t){var n,s;e.call(this,t),this.$selection.find(".select2-selection__clear").remove(),this.$selection[0].classList.remove("select2-selection--clearable"),0<this.$selection.find(".select2-selection__placeholder").length||0===t.length||(n=this.$selection.find(".select2-selection__rendered").attr("id"),s=this.options.get("translations").get("removeAllItems"),(e=i('<button type="button" class="select2-selection__clear" tabindex="-1"><span aria-hidden="true">&times;</span></button>')).attr("title",s()),e.attr("aria-label",s()),e.attr("aria-describedby",n),a.StoreData(e[0],"data",t),this.$selection.prepend(e),this.$selection[0].classList.add("select2-selection--clearable"))},e}),u.define("select2/selection/search",["jquery","../utils","../keys"],function(s,a,l){function e(e,t,n){e.call(this,t,n)}return e.prototype.render=function(e){var t=this.options.get("translations").get("search"),n=s('<span class="select2-search select2-search--inline"><textarea class="select2-search__field" type="search" tabindex="-1" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" ></textarea></span>');this.$searchContainer=n,this.$search=n.find("textarea"),this.$search.prop("autocomplete",this.options.get("autocomplete")),this.$search.attr("aria-label",t());e=e.call(this);return this._transferTabIndex(),e.append(this.$searchContainer),e},e.prototype.bind=function(e,t,n){var s=this,i=t.id+"-results",r=t.id+"-container";e.call(this,t,n),s.$search.attr("aria-describedby",r),t.on("open",function(){s.$search.attr("aria-controls",i),s.$search.trigger("focus")}),t.on("close",function(){s.$search.val(""),s.resizeSearch(),s.$search.removeAttr("aria-controls"),s.$search.removeAttr("aria-activedescendant"),s.$search.trigger("focus")}),t.on("enable",function(){s.$search.prop("disabled",!1),s._transferTabIndex()}),t.on("disable",function(){s.$search.prop("disabled",!0)}),t.on("focus",function(e){s.$search.trigger("focus")}),t.on("results:focus",function(e){e.data._resultId?s.$search.attr("aria-activedescendant",e.data._resultId):s.$search.removeAttr("aria-activedescendant")}),this.$selection.on("focusin",".select2-search--inline",function(e){s.trigger("focus",e)}),this.$selection.on("focusout",".select2-search--inline",function(e){s._handleBlur(e)}),this.$selection.on("keydown",".select2-search--inline",function(e){var t;e.stopPropagation(),s.trigger("keypress",e),s._keyUpPrevented=e.isDefaultPrevented(),e.which!==l.BACKSPACE||""!==s.$search.val()||0<(t=s.$selection.find(".select2-selection__choice").last()).length&&(t=a.GetData(t[0],"data"),s.searchRemoveChoice(t),e.preventDefault())}),this.$selection.on("click",".select2-search--inline",function(e){s.$search.val()&&e.stopPropagation()});var t=document.documentMode,o=t&&t<=11;this.$selection.on("input.searchcheck",".select2-search--inline",function(e){o?s.$selection.off("input.search input.searchcheck"):s.$selection.off("keyup.search")}),this.$selection.on("keyup.search input.search",".select2-search--inline",function(e){var t;o&&"input"===e.type?s.$selection.off("input.search input.searchcheck"):(t=e.which)!=l.SHIFT&&t!=l.CTRL&&t!=l.ALT&&t!=l.TAB&&s.handleSearch(e)})},e.prototype._transferTabIndex=function(e){this.$search.attr("tabindex",this.$selection.attr("tabindex")),this.$selection.attr("tabindex","-1")},e.prototype.createPlaceholder=function(e,t){this.$search.attr("placeholder",t.text)},e.prototype.update=function(e,t){var n=this.$search[0]==document.activeElement;this.$search.attr("placeholder",""),e.call(this,t),this.resizeSearch(),n&&this.$search.trigger("focus")},e.prototype.handleSearch=function(){var e;this.resizeSearch(),this._keyUpPrevented||(e=this.$search.val(),this.trigger("query",{term:e})),this._keyUpPrevented=!1},e.prototype.searchRemoveChoice=function(e,t){this.trigger("unselect",{data:t}),this.$search.val(t.text),this.handleSearch()},e.prototype.resizeSearch=function(){this.$search.css("width","25px");var e="100%";""===this.$search.attr("placeholder")&&(e=.75*(this.$search.val().length+1)+"em"),this.$search.css("width",e)},e}),u.define("select2/selection/selectionCss",["../utils"],function(n){function e(){}return e.prototype.render=function(e){var t=e.call(this),e=this.options.get("selectionCssClass")||"";return-1!==e.indexOf(":all:")&&(e=e.replace(":all:",""),n.copyNonInternalCssClasses(t[0],this.$element[0])),t.addClass(e),t},e}),u.define("select2/selection/eventRelay",["jquery"],function(o){function e(){}return e.prototype.bind=function(e,t,n){var s=this,i=["open","opening","close","closing","select","selecting","unselect","unselecting","clear","clearing"],r=["opening","closing","selecting","unselecting","clearing"];e.call(this,t,n),t.on("*",function(e,t){var n;-1!==i.indexOf(e)&&(t=t||{},n=o.Event("select2:"+e,{params:t}),s.$element.trigger(n),-1!==r.indexOf(e)&&(t.prevented=n.isDefaultPrevented()))})},e}),u.define("select2/translation",["jquery","require"],function(t,n){function s(e){this.dict=e||{}}return s.prototype.all=function(){return this.dict},s.prototype.get=function(e){return this.dict[e]},s.prototype.extend=function(e){this.dict=t.extend({},e.all(),this.dict)},s._cache={},s.loadPath=function(e){var t;return e in s._cache||(t=n(e),s._cache[e]=t),new s(s._cache[e])},s}),u.define("select2/diacritics",[],function(){return{"Ⓐ":"A","Ａ":"A","À":"A","Á":"A","Â":"A","Ầ":"A","Ấ":"A","Ẫ":"A","Ẩ":"A","Ã":"A","Ā":"A","Ă":"A","Ằ":"A","Ắ":"A","Ẵ":"A","Ẳ":"A","Ȧ":"A","Ǡ":"A","Ä":"A","Ǟ":"A","Ả":"A","Å":"A","Ǻ":"A","Ǎ":"A","Ȁ":"A","Ȃ":"A","Ạ":"A","Ậ":"A","Ặ":"A","Ḁ":"A","Ą":"A","Ⱥ":"A","Ɐ":"A","Ꜳ":"AA","Æ":"AE","Ǽ":"AE","Ǣ":"AE","Ꜵ":"AO","Ꜷ":"AU","Ꜹ":"AV","Ꜻ":"AV","Ꜽ":"AY","Ⓑ":"B","Ｂ":"B","Ḃ":"B","Ḅ":"B","Ḇ":"B","Ƀ":"B","Ƃ":"B","Ɓ":"B","Ⓒ":"C","Ｃ":"C","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","Ç":"C","Ḉ":"C","Ƈ":"C","Ȼ":"C","Ꜿ":"C","Ⓓ":"D","Ｄ":"D","Ḋ":"D","Ď":"D","Ḍ":"D","Ḑ":"D","Ḓ":"D","Ḏ":"D","Đ":"D","Ƌ":"D","Ɗ":"D","Ɖ":"D","Ꝺ":"D","Ǳ":"DZ","Ǆ":"DZ","ǲ":"Dz","ǅ":"Dz","Ⓔ":"E","Ｅ":"E","È":"E","É":"E","Ê":"E","Ề":"E","Ế":"E","Ễ":"E","Ể":"E","Ẽ":"E","Ē":"E","Ḕ":"E","Ḗ":"E","Ĕ":"E","Ė":"E","Ë":"E","Ẻ":"E","Ě":"E","Ȅ":"E","Ȇ":"E","Ẹ":"E","Ệ":"E","Ȩ":"E","Ḝ":"E","Ę":"E","Ḙ":"E","Ḛ":"E","Ɛ":"E","Ǝ":"E","Ⓕ":"F","Ｆ":"F","Ḟ":"F","Ƒ":"F","Ꝼ":"F","Ⓖ":"G","Ｇ":"G","Ǵ":"G","Ĝ":"G","Ḡ":"G","Ğ":"G","Ġ":"G","Ǧ":"G","Ģ":"G","Ǥ":"G","Ɠ":"G","Ꞡ":"G","Ᵹ":"G","Ꝿ":"G","Ⓗ":"H","Ｈ":"H","Ĥ":"H","Ḣ":"H","Ḧ":"H","Ȟ":"H","Ḥ":"H","Ḩ":"H","Ḫ":"H","Ħ":"H","Ⱨ":"H","Ⱶ":"H","Ɥ":"H","Ⓘ":"I","Ｉ":"I","Ì":"I","Í":"I","Î":"I","Ĩ":"I","Ī":"I","Ĭ":"I","İ":"I","Ï":"I","Ḯ":"I","Ỉ":"I","Ǐ":"I","Ȉ":"I","Ȋ":"I","Ị":"I","Į":"I","Ḭ":"I","Ɨ":"I","Ⓙ":"J","Ｊ":"J","Ĵ":"J","Ɉ":"J","Ⓚ":"K","Ｋ":"K","Ḱ":"K","Ǩ":"K","Ḳ":"K","Ķ":"K","Ḵ":"K","Ƙ":"K","Ⱪ":"K","Ꝁ":"K","Ꝃ":"K","Ꝅ":"K","Ꞣ":"K","Ⓛ":"L","Ｌ":"L","Ŀ":"L","Ĺ":"L","Ľ":"L","Ḷ":"L","Ḹ":"L","Ļ":"L","Ḽ":"L","Ḻ":"L","Ł":"L","Ƚ":"L","Ɫ":"L","Ⱡ":"L","Ꝉ":"L","Ꝇ":"L","Ꞁ":"L","Ǉ":"LJ","ǈ":"Lj","Ⓜ":"M","Ｍ":"M","Ḿ":"M","Ṁ":"M","Ṃ":"M","Ɱ":"M","Ɯ":"M","Ⓝ":"N","Ｎ":"N","Ǹ":"N","Ń":"N","Ñ":"N","Ṅ":"N","Ň":"N","Ṇ":"N","Ņ":"N","Ṋ":"N","Ṉ":"N","Ƞ":"N","Ɲ":"N","Ꞑ":"N","Ꞥ":"N","Ǌ":"NJ","ǋ":"Nj","Ⓞ":"O","Ｏ":"O","Ò":"O","Ó":"O","Ô":"O","Ồ":"O","Ố":"O","Ỗ":"O","Ổ":"O","Õ":"O","Ṍ":"O","Ȭ":"O","Ṏ":"O","Ō":"O","Ṑ":"O","Ṓ":"O","Ŏ":"O","Ȯ":"O","Ȱ":"O","Ö":"O","Ȫ":"O","Ỏ":"O","Ő":"O","Ǒ":"O","Ȍ":"O","Ȏ":"O","Ơ":"O","Ờ":"O","Ớ":"O","Ỡ":"O","Ở":"O","Ợ":"O","Ọ":"O","Ộ":"O","Ǫ":"O","Ǭ":"O","Ø":"O","Ǿ":"O","Ɔ":"O","Ɵ":"O","Ꝋ":"O","Ꝍ":"O","Œ":"OE","Ƣ":"OI","Ꝏ":"OO","Ȣ":"OU","Ⓟ":"P","Ｐ":"P","Ṕ":"P","Ṗ":"P","Ƥ":"P","Ᵽ":"P","Ꝑ":"P","Ꝓ":"P","Ꝕ":"P","Ⓠ":"Q","Ｑ":"Q","Ꝗ":"Q","Ꝙ":"Q","Ɋ":"Q","Ⓡ":"R","Ｒ":"R","Ŕ":"R","Ṙ":"R","Ř":"R","Ȑ":"R","Ȓ":"R","Ṛ":"R","Ṝ":"R","Ŗ":"R","Ṟ":"R","Ɍ":"R","Ɽ":"R","Ꝛ":"R","Ꞧ":"R","Ꞃ":"R","Ⓢ":"S","Ｓ":"S","ẞ":"S","Ś":"S","Ṥ":"S","Ŝ":"S","Ṡ":"S","Š":"S","Ṧ":"S","Ṣ":"S","Ṩ":"S","Ș":"S","Ş":"S","Ȿ":"S","Ꞩ":"S","Ꞅ":"S","Ⓣ":"T","Ｔ":"T","Ṫ":"T","Ť":"T","Ṭ":"T","Ț":"T","Ţ":"T","Ṱ":"T","Ṯ":"T","Ŧ":"T","Ƭ":"T","Ʈ":"T","Ⱦ":"T","Ꞇ":"T","Ꜩ":"TZ","Ⓤ":"U","Ｕ":"U","Ù":"U","Ú":"U","Û":"U","Ũ":"U","Ṹ":"U","Ū":"U","Ṻ":"U","Ŭ":"U","Ü":"U","Ǜ":"U","Ǘ":"U","Ǖ":"U","Ǚ":"U","Ủ":"U","Ů":"U","Ű":"U","Ǔ":"U","Ȕ":"U","Ȗ":"U","Ư":"U","Ừ":"U","Ứ":"U","Ữ":"U","Ử":"U","Ự":"U","Ụ":"U","Ṳ":"U","Ų":"U","Ṷ":"U","Ṵ":"U","Ʉ":"U","Ⓥ":"V","Ｖ":"V","Ṽ":"V","Ṿ":"V","Ʋ":"V","Ꝟ":"V","Ʌ":"V","Ꝡ":"VY","Ⓦ":"W","Ｗ":"W","Ẁ":"W","Ẃ":"W","Ŵ":"W","Ẇ":"W","Ẅ":"W","Ẉ":"W","Ⱳ":"W","Ⓧ":"X","Ｘ":"X","Ẋ":"X","Ẍ":"X","Ⓨ":"Y","Ｙ":"Y","Ỳ":"Y","Ý":"Y","Ŷ":"Y","Ỹ":"Y","Ȳ":"Y","Ẏ":"Y","Ÿ":"Y","Ỷ":"Y","Ỵ":"Y","Ƴ":"Y","Ɏ":"Y","Ỿ":"Y","Ⓩ":"Z","Ｚ":"Z","Ź":"Z","Ẑ":"Z","Ż":"Z","Ž":"Z","Ẓ":"Z","Ẕ":"Z","Ƶ":"Z","Ȥ":"Z","Ɀ":"Z","Ⱬ":"Z","Ꝣ":"Z","ⓐ":"a","ａ":"a","ẚ":"a","à":"a","á":"a","â":"a","ầ":"a","ấ":"a","ẫ":"a","ẩ":"a","ã":"a","ā":"a","ă":"a","ằ":"a","ắ":"a","ẵ":"a","ẳ":"a","ȧ":"a","ǡ":"a","ä":"a","ǟ":"a","ả":"a","å":"a","ǻ":"a","ǎ":"a","ȁ":"a","ȃ":"a","ạ":"a","ậ":"a","ặ":"a","ḁ":"a","ą":"a","ⱥ":"a","ɐ":"a","ꜳ":"aa","æ":"ae","ǽ":"ae","ǣ":"ae","ꜵ":"ao","ꜷ":"au","ꜹ":"av","ꜻ":"av","ꜽ":"ay","ⓑ":"b","ｂ":"b","ḃ":"b","ḅ":"b","ḇ":"b","ƀ":"b","ƃ":"b","ɓ":"b","ⓒ":"c","ｃ":"c","ć":"c","ĉ":"c","ċ":"c","č":"c","ç":"c","ḉ":"c","ƈ":"c","ȼ":"c","ꜿ":"c","ↄ":"c","ⓓ":"d","ｄ":"d","ḋ":"d","ď":"d","ḍ":"d","ḑ":"d","ḓ":"d","ḏ":"d","đ":"d","ƌ":"d","ɖ":"d","ɗ":"d","ꝺ":"d","ǳ":"dz","ǆ":"dz","ⓔ":"e","ｅ":"e","è":"e","é":"e","ê":"e","ề":"e","ế":"e","ễ":"e","ể":"e","ẽ":"e","ē":"e","ḕ":"e","ḗ":"e","ĕ":"e","ė":"e","ë":"e","ẻ":"e","ě":"e","ȅ":"e","ȇ":"e","ẹ":"e","ệ":"e","ȩ":"e","ḝ":"e","ę":"e","ḙ":"e","ḛ":"e","ɇ":"e","ɛ":"e","ǝ":"e","ⓕ":"f","ｆ":"f","ḟ":"f","ƒ":"f","ꝼ":"f","ⓖ":"g","ｇ":"g","ǵ":"g","ĝ":"g","ḡ":"g","ğ":"g","ġ":"g","ǧ":"g","ģ":"g","ǥ":"g","ɠ":"g","ꞡ":"g","ᵹ":"g","ꝿ":"g","ⓗ":"h","ｈ":"h","ĥ":"h","ḣ":"h","ḧ":"h","ȟ":"h","ḥ":"h","ḩ":"h","ḫ":"h","ẖ":"h","ħ":"h","ⱨ":"h","ⱶ":"h","ɥ":"h","ƕ":"hv","ⓘ":"i","ｉ":"i","ì":"i","í":"i","î":"i","ĩ":"i","ī":"i","ĭ":"i","ï":"i","ḯ":"i","ỉ":"i","ǐ":"i","ȉ":"i","ȋ":"i","ị":"i","į":"i","ḭ":"i","ɨ":"i","ı":"i","ⓙ":"j","ｊ":"j","ĵ":"j","ǰ":"j","ɉ":"j","ⓚ":"k","ｋ":"k","ḱ":"k","ǩ":"k","ḳ":"k","ķ":"k","ḵ":"k","ƙ":"k","ⱪ":"k","ꝁ":"k","ꝃ":"k","ꝅ":"k","ꞣ":"k","ⓛ":"l","ｌ":"l","ŀ":"l","ĺ":"l","ľ":"l","ḷ":"l","ḹ":"l","ļ":"l","ḽ":"l","ḻ":"l","ſ":"l","ł":"l","ƚ":"l","ɫ":"l","ⱡ":"l","ꝉ":"l","ꞁ":"l","ꝇ":"l","ǉ":"lj","ⓜ":"m","ｍ":"m","ḿ":"m","ṁ":"m","ṃ":"m","ɱ":"m","ɯ":"m","ⓝ":"n","ｎ":"n","ǹ":"n","ń":"n","ñ":"n","ṅ":"n","ň":"n","ṇ":"n","ņ":"n","ṋ":"n","ṉ":"n","ƞ":"n","ɲ":"n","ŉ":"n","ꞑ":"n","ꞥ":"n","ǌ":"nj","ⓞ":"o","ｏ":"o","ò":"o","ó":"o","ô":"o","ồ":"o","ố":"o","ỗ":"o","ổ":"o","õ":"o","ṍ":"o","ȭ":"o","ṏ":"o","ō":"o","ṑ":"o","ṓ":"o","ŏ":"o","ȯ":"o","ȱ":"o","ö":"o","ȫ":"o","ỏ":"o","ő":"o","ǒ":"o","ȍ":"o","ȏ":"o","ơ":"o","ờ":"o","ớ":"o","ỡ":"o","ở":"o","ợ":"o","ọ":"o","ộ":"o","ǫ":"o","ǭ":"o","ø":"o","ǿ":"o","ɔ":"o","ꝋ":"o","ꝍ":"o","ɵ":"o","œ":"oe","ƣ":"oi","ȣ":"ou","ꝏ":"oo","ⓟ":"p","ｐ":"p","ṕ":"p","ṗ":"p","ƥ":"p","ᵽ":"p","ꝑ":"p","ꝓ":"p","ꝕ":"p","ⓠ":"q","ｑ":"q","ɋ":"q","ꝗ":"q","ꝙ":"q","ⓡ":"r","ｒ":"r","ŕ":"r","ṙ":"r","ř":"r","ȑ":"r","ȓ":"r","ṛ":"r","ṝ":"r","ŗ":"r","ṟ":"r","ɍ":"r","ɽ":"r","ꝛ":"r","ꞧ":"r","ꞃ":"r","ⓢ":"s","ｓ":"s","ß":"s","ś":"s","ṥ":"s","ŝ":"s","ṡ":"s","š":"s","ṧ":"s","ṣ":"s","ṩ":"s","ș":"s","ş":"s","ȿ":"s","ꞩ":"s","ꞅ":"s","ẛ":"s","ⓣ":"t","ｔ":"t","ṫ":"t","ẗ":"t","ť":"t","ṭ":"t","ț":"t","ţ":"t","ṱ":"t","ṯ":"t","ŧ":"t","ƭ":"t","ʈ":"t","ⱦ":"t","ꞇ":"t","ꜩ":"tz","ⓤ":"u","ｕ":"u","ù":"u","ú":"u","û":"u","ũ":"u","ṹ":"u","ū":"u","ṻ":"u","ŭ":"u","ü":"u","ǜ":"u","ǘ":"u","ǖ":"u","ǚ":"u","ủ":"u","ů":"u","ű":"u","ǔ":"u","ȕ":"u","ȗ":"u","ư":"u","ừ":"u","ứ":"u","ữ":"u","ử":"u","ự":"u","ụ":"u","ṳ":"u","ų":"u","ṷ":"u","ṵ":"u","ʉ":"u","ⓥ":"v","ｖ":"v","ṽ":"v","ṿ":"v","ʋ":"v","ꝟ":"v","ʌ":"v","ꝡ":"vy","ⓦ":"w","ｗ":"w","ẁ":"w","ẃ":"w","ŵ":"w","ẇ":"w","ẅ":"w","ẘ":"w","ẉ":"w","ⱳ":"w","ⓧ":"x","ｘ":"x","ẋ":"x","ẍ":"x","ⓨ":"y","ｙ":"y","ỳ":"y","ý":"y","ŷ":"y","ỹ":"y","ȳ":"y","ẏ":"y","ÿ":"y","ỷ":"y","ẙ":"y","ỵ":"y","ƴ":"y","ɏ":"y","ỿ":"y","ⓩ":"z","ｚ":"z","ź":"z","ẑ":"z","ż":"z","ž":"z","ẓ":"z","ẕ":"z","ƶ":"z","ȥ":"z","ɀ":"z","ⱬ":"z","ꝣ":"z","Ά":"Α","Έ":"Ε","Ή":"Η","Ί":"Ι","Ϊ":"Ι","Ό":"Ο","Ύ":"Υ","Ϋ":"Υ","Ώ":"Ω","ά":"α","έ":"ε","ή":"η","ί":"ι","ϊ":"ι","ΐ":"ι","ό":"ο","ύ":"υ","ϋ":"υ","ΰ":"υ","ώ":"ω","ς":"σ","’":"'"}}),u.define("select2/data/base",["../utils"],function(n){function s(e,t){s.__super__.constructor.call(this)}return n.Extend(s,n.Observable),s.prototype.current=function(e){throw new Error("The `current` method must be defined in child classes.")},s.prototype.query=function(e,t){throw new Error("The `query` method must be defined in child classes.")},s.prototype.bind=function(e,t){},s.prototype.destroy=function(){},s.prototype.generateResultId=function(e,t){e=e.id+"-result-";return e+=n.generateChars(4),null!=t.id?e+="-"+t.id.toString():e+="-"+n.generateChars(4),e},s}),u.define("select2/data/select",["./base","../utils","jquery"],function(e,a,l){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return a.Extend(n,e),n.prototype.current=function(e){var t=this;e(Array.prototype.map.call(this.$element[0].querySelectorAll(":checked"),function(e){return t.item(l(e))}))},n.prototype.select=function(i){var e,r=this;if(i.selected=!0,null!=i.element&&"option"===i.element.tagName.toLowerCase())return i.element.selected=!0,void this.$element.trigger("input").trigger("change");this.$element.prop("multiple")?this.current(function(e){var t=[];(i=[i]).push.apply(i,e);for(var n=0;n<i.length;n++){var s=i[n].id;-1===t.indexOf(s)&&t.push(s)}r.$element.val(t),r.$element.trigger("input").trigger("change")}):(e=i.id,this.$element.val(e),this.$element.trigger("input").trigger("change"))},n.prototype.unselect=function(i){var r=this;if(this.$element.prop("multiple")){if(i.selected=!1,null!=i.element&&"option"===i.element.tagName.toLowerCase())return i.element.selected=!1,void this.$element.trigger("input").trigger("change");this.current(function(e){for(var t=[],n=0;n<e.length;n++){var s=e[n].id;s!==i.id&&-1===t.indexOf(s)&&t.push(s)}r.$element.val(t),r.$element.trigger("input").trigger("change")})}},n.prototype.bind=function(e,t){var n=this;(this.container=e).on("select",function(e){n.select(e.data)}),e.on("unselect",function(e){n.unselect(e.data)})},n.prototype.destroy=function(){this.$element.find("*").each(function(){a.RemoveData(this)})},n.prototype.query=function(t,e){var n=[],s=this;this.$element.children().each(function(){var e;"option"!==this.tagName.toLowerCase()&&"optgroup"!==this.tagName.toLowerCase()||(e=l(this),e=s.item(e),null!==(e=s.matches(t,e))&&n.push(e))}),e({results:n})},n.prototype.addOptions=function(e){this.$element.append(e)},n.prototype.option=function(e){var t;e.children?(t=document.createElement("optgroup")).label=e.text:void 0!==(t=document.createElement("option")).textContent?t.textContent=e.text:t.innerText=e.text,void 0!==e.id&&(t.value=e.id),e.disabled&&(t.disabled=!0),e.selected&&(t.selected=!0),e.title&&(t.title=e.title);e=this._normalizeItem(e);return e.element=t,a.StoreData(t,"data",e),l(t)},n.prototype.item=function(e){var t={};if(null!=(t=a.GetData(e[0],"data")))return t;var n=e[0];if("option"===n.tagName.toLowerCase())t={id:e.val(),text:e.text(),disabled:e.prop("disabled"),selected:e.prop("selected"),title:e.prop("title")};else if("optgroup"===n.tagName.toLowerCase()){t={text:e.prop("label"),children:[],title:e.prop("title")};for(var s=e.children("option"),i=[],r=0;r<s.length;r++){var o=l(s[r]),o=this.item(o);i.push(o)}t.children=i}return(t=this._normalizeItem(t)).element=e[0],a.StoreData(e[0],"data",t),t},n.prototype._normalizeItem=function(e){e!==Object(e)&&(e={id:e,text:e});return null!=(e=l.extend({},{text:""},e)).id&&(e.id=e.id.toString()),null!=e.text&&(e.text=e.text.toString()),null==e._resultId&&e.id&&null!=this.container&&(e._resultId=this.generateResultId(this.container,e)),l.extend({},{selected:!1,disabled:!1},e)},n.prototype.matches=function(e,t){return this.options.get("matcher")(e,t)},n}),u.define("select2/data/array",["./select","../utils","jquery"],function(e,t,c){function s(e,t){this._dataToConvert=t.get("data")||[],s.__super__.constructor.call(this,e,t)}return t.Extend(s,e),s.prototype.bind=function(e,t){s.__super__.bind.call(this,e,t),this.addOptions(this.convertToOptions(this._dataToConvert))},s.prototype.select=function(n){var e=this.$element.find("option").filter(function(e,t){return t.value==n.id.toString()});0===e.length&&(e=this.option(n),this.addOptions(e)),s.__super__.select.call(this,n)},s.prototype.convertToOptions=function(e){var t=this,n=this.$element.find("option"),s=n.map(function(){return t.item(c(this)).id}).get(),i=[];for(var r=0;r<e.length;r++){var o,a,l=this._normalizeItem(e[r]);0<=s.indexOf(l.id)?(o=n.filter(function(e){return function(){return c(this).val()==e.id}}(l)),a=this.item(o),a=c.extend(!0,{},l,a),a=this.option(a),o.replaceWith(a)):(a=this.option(l),l.children&&(l=this.convertToOptions(l.children),a.append(l)),i.push(a))}return i},s}),u.define("select2/data/ajax",["./array","../utils","jquery"],function(e,t,r){function n(e,t){this.ajaxOptions=this._applyDefaults(t.get("ajax")),null!=this.ajaxOptions.processResults&&(this.processResults=this.ajaxOptions.processResults),n.__super__.constructor.call(this,e,t)}return t.Extend(n,e),n.prototype._applyDefaults=function(e){var t={data:function(e){return r.extend({},e,{q:e.term})},transport:function(e,t,n){e=r.ajax(e);return e.then(t),e.fail(n),e}};return r.extend({},t,e,!0)},n.prototype.processResults=function(e){return e},n.prototype.query=function(t,n){var s=this;null!=this._request&&("function"==typeof this._request.abort&&this._request.abort(),this._request=null);var i=r.extend({type:"GET"},this.ajaxOptions);function e(){var e=i.transport(i,function(e){e=s.processResults(e,t);s.options.get("debug")&&window.console&&console.error&&(e&&e.results&&Array.isArray(e.results)||console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")),n(e)},function(){"status"in e&&(0===e.status||"0"===e.status)||s.trigger("results:message",{message:"errorLoading"})});s._request=e}"function"==typeof i.url&&(i.url=i.url.call(this.$element,t)),"function"==typeof i.data&&(i.data=i.data.call(this.$element,t)),this.ajaxOptions.delay&&null!=t.term?(this._queryTimeout&&window.clearTimeout(this._queryTimeout),this._queryTimeout=window.setTimeout(e,this.ajaxOptions.delay)):e()},n}),u.define("select2/data/tags",["jquery"],function(t){function e(e,t,n){var s=n.get("tags"),i=n.get("createTag");void 0!==i&&(this.createTag=i);i=n.get("insertTag");if(void 0!==i&&(this.insertTag=i),e.call(this,t,n),Array.isArray(s))for(var r=0;r<s.length;r++){var o=s[r],o=this._normalizeItem(o),o=this.option(o);this.$element.append(o)}}return e.prototype.query=function(e,c,u){var d=this;this._removeOldTags(),null!=c.term&&null==c.page?e.call(this,c,function e(t,n){for(var s=t.results,i=0;i<s.length;i++){var r=s[i],o=null!=r.children&&!e({results:r.children},!0);if((r.text||"").toUpperCase()===(c.term||"").toUpperCase()||o)return!n&&(t.data=s,void u(t))}if(n)return!0;var a,l=d.createTag(c);null!=l&&((a=d.option(l)).attr("data-select2-tag","true"),d.addOptions([a]),d.insertTag(s,l)),t.results=s,u(t)}):e.call(this,c,u)},e.prototype.createTag=function(e,t){if(null==t.term)return null;t=t.term.trim();return""===t?null:{id:t,text:t}},e.prototype.insertTag=function(e,t,n){t.unshift(n)},e.prototype._removeOldTags=function(e){this.$element.find("option[data-select2-tag]").each(function(){this.selected||t(this).remove()})},e}),u.define("select2/data/tokenizer",["jquery"],function(c){function e(e,t,n){var s=n.get("tokenizer");void 0!==s&&(this.tokenizer=s),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){e.call(this,t,n),this.$search=t.dropdown.$search||t.selection.$search||n.find(".select2-search__field")},e.prototype.query=function(e,t,n){var s=this;t.term=t.term||"";var i=this.tokenizer(t,this.options,function(e){var t,n=s._normalizeItem(e);s.$element.find("option").filter(function(){return c(this).val()===n.id}).length||((t=s.option(n)).attr("data-select2-tag",!0),s._removeOldTags(),s.addOptions([t])),t=n,s.trigger("select",{data:t})});i.term!==t.term&&(this.$search.length&&(this.$search.val(i.term),this.$search.trigger("focus")),t.term=i.term),e.call(this,t,n)},e.prototype.tokenizer=function(e,t,n,s){for(var i=n.get("tokenSeparators")||[],r=t.term,o=0,a=this.createTag||function(e){return{id:e.term,text:e.term}};o<r.length;){var l=r[o];-1!==i.indexOf(l)?(l=r.substr(0,o),null!=(l=a(c.extend({},t,{term:l})))?(s(l),r=r.substr(o+1)||"",o=0):o++):o++}return{term:r}},e}),u.define("select2/data/minimumInputLength",[],function(){function e(e,t,n){this.minimumInputLength=n.get("minimumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",t.term.length<this.minimumInputLength?this.trigger("results:message",{message:"inputTooShort",args:{minimum:this.minimumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),u.define("select2/data/maximumInputLength",[],function(){function e(e,t,n){this.maximumInputLength=n.get("maximumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",0<this.maximumInputLength&&t.term.length>this.maximumInputLength?this.trigger("results:message",{message:"inputTooLong",args:{maximum:this.maximumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),u.define("select2/data/maximumSelectionLength",[],function(){function e(e,t,n){this.maximumSelectionLength=n.get("maximumSelectionLength"),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("select",function(){s._checkIfMaximumSelected()})},e.prototype.query=function(e,t,n){var s=this;this._checkIfMaximumSelected(function(){e.call(s,t,n)})},e.prototype._checkIfMaximumSelected=function(e,t){var n=this;this.current(function(e){e=null!=e?e.length:0;0<n.maximumSelectionLength&&e>=n.maximumSelectionLength?n.trigger("results:message",{message:"maximumSelected",args:{maximum:n.maximumSelectionLength}}):t&&t()})},e}),u.define("select2/dropdown",["jquery","./utils"],function(t,e){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return e.Extend(n,e.Observable),n.prototype.render=function(){var e=t('<span class="select2-dropdown"><span class="select2-results"></span></span>');return e.attr("dir",this.options.get("dir")),this.$dropdown=e},n.prototype.bind=function(){},n.prototype.position=function(e,t){},n.prototype.destroy=function(){this.$dropdown.remove()},n}),u.define("select2/dropdown/search",["jquery"],function(r){function e(){}return e.prototype.render=function(e){var t=e.call(this),n=this.options.get("translations").get("search"),e=r('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></span>');return this.$searchContainer=e,this.$search=e.find("input"),this.$search.prop("autocomplete",this.options.get("autocomplete")),this.$search.attr("aria-label",n()),t.prepend(e),t},e.prototype.bind=function(e,t,n){var s=this,i=t.id+"-results";e.call(this,t,n),this.$search.on("keydown",function(e){s.trigger("keypress",e),s._keyUpPrevented=e.isDefaultPrevented()}),this.$search.on("input",function(e){r(this).off("keyup")}),this.$search.on("keyup input",function(e){s.handleSearch(e)}),t.on("open",function(){s.$search.attr("tabindex",0),s.$search.attr("aria-controls",i),s.$search.trigger("focus"),window.setTimeout(function(){s.$search.trigger("focus")},0)}),t.on("close",function(){s.$search.attr("tabindex",-1),s.$search.removeAttr("aria-controls"),s.$search.removeAttr("aria-activedescendant"),s.$search.val(""),s.$search.trigger("blur")}),t.on("focus",function(){t.isOpen()||s.$search.trigger("focus")}),t.on("results:all",function(e){null!=e.query.term&&""!==e.query.term||(s.showSearch(e)?s.$searchContainer[0].classList.remove("select2-search--hide"):s.$searchContainer[0].classList.add("select2-search--hide"))}),t.on("results:focus",function(e){e.data._resultId?s.$search.attr("aria-activedescendant",e.data._resultId):s.$search.removeAttr("aria-activedescendant")})},e.prototype.handleSearch=function(e){var t;this._keyUpPrevented||(t=this.$search.val(),this.trigger("query",{term:t})),this._keyUpPrevented=!1},e.prototype.showSearch=function(e,t){return!0},e}),u.define("select2/dropdown/hidePlaceholder",[],function(){function e(e,t,n,s){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n,s)}return e.prototype.append=function(e,t){t.results=this.removePlaceholder(t.results),e.call(this,t)},e.prototype.normalizePlaceholder=function(e,t){return t="string"==typeof t?{id:"",text:t}:t},e.prototype.removePlaceholder=function(e,t){for(var n=t.slice(0),s=t.length-1;0<=s;s--){var i=t[s];this.placeholder.id===i.id&&n.splice(s,1)}return n},e}),u.define("select2/dropdown/infiniteScroll",["jquery"],function(n){function e(e,t,n,s){this.lastParams={},e.call(this,t,n,s),this.$loadingMore=this.createLoadingMore(),this.loading=!1}return e.prototype.append=function(e,t){this.$loadingMore.remove(),this.loading=!1,e.call(this,t),this.showLoadingMore(t)&&(this.$results.append(this.$loadingMore),this.loadMoreIfNeeded())},e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("query",function(e){s.lastParams=e,s.loading=!0}),t.on("query:append",function(e){s.lastParams=e,s.loading=!0}),this.$results.on("scroll",this.loadMoreIfNeeded.bind(this))},e.prototype.loadMoreIfNeeded=function(){var e=n.contains(document.documentElement,this.$loadingMore[0]);!this.loading&&e&&(e=this.$results.offset().top+this.$results.outerHeight(!1),this.$loadingMore.offset().top+this.$loadingMore.outerHeight(!1)<=e+50&&this.loadMore())},e.prototype.loadMore=function(){this.loading=!0;var e=n.extend({},{page:1},this.lastParams);e.page++,this.trigger("query:append",e)},e.prototype.showLoadingMore=function(e,t){return t.pagination&&t.pagination.more},e.prototype.createLoadingMore=function(){var e=n('<li class="select2-results__option select2-results__option--load-more"role="option" aria-disabled="true"></li>'),t=this.options.get("translations").get("loadingMore");return e.html(t(this.lastParams)),e},e}),u.define("select2/dropdown/attachBody",["jquery","../utils"],function(u,o){function e(e,t,n){this.$dropdownParent=u(n.get("dropdownParent")||document.body),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("open",function(){s._showDropdown(),s._attachPositioningHandler(t),s._bindContainerResultHandlers(t)}),t.on("close",function(){s._hideDropdown(),s._detachPositioningHandler(t)}),this.$dropdownContainer.on("mousedown",function(e){e.stopPropagation()})},e.prototype.destroy=function(e){e.call(this),this.$dropdownContainer.remove()},e.prototype.position=function(e,t,n){t.attr("class",n.attr("class")),t[0].classList.remove("select2"),t[0].classList.add("select2-container--open"),t.css({position:"absolute",top:-999999}),this.$container=n},e.prototype.render=function(e){var t=u("<span></span>"),e=e.call(this);return t.append(e),this.$dropdownContainer=t},e.prototype._hideDropdown=function(e){this.$dropdownContainer.detach()},e.prototype._bindContainerResultHandlers=function(e,t){var n;this._containerResultsHandlersBound||(n=this,t.on("results:all",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:append",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:message",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("select",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("unselect",function(){n._positionDropdown(),n._resizeDropdown()}),this._containerResultsHandlersBound=!0)},e.prototype._attachPositioningHandler=function(e,t){var n=this,s="scroll.select2."+t.id,i="resize.select2."+t.id,r="orientationchange.select2."+t.id,t=this.$container.parents().filter(o.hasScroll);t.each(function(){o.StoreData(this,"select2-scroll-position",{x:u(this).scrollLeft(),y:u(this).scrollTop()})}),t.on(s,function(e){var t=o.GetData(this,"select2-scroll-position");u(this).scrollTop(t.y)}),u(window).on(s+" "+i+" "+r,function(e){n._positionDropdown(),n._resizeDropdown()})},e.prototype._detachPositioningHandler=function(e,t){var n="scroll.select2."+t.id,s="resize.select2."+t.id,t="orientationchange.select2."+t.id;this.$container.parents().filter(o.hasScroll).off(n),u(window).off(n+" "+s+" "+t)},e.prototype._positionDropdown=function(){var e=u(window),t=this.$dropdown[0].classList.contains("select2-dropdown--above"),n=this.$dropdown[0].classList.contains("select2-dropdown--below"),s=null,i=this.$container.offset();i.bottom=i.top+this.$container.outerHeight(!1);var r={height:this.$container.outerHeight(!1)};r.top=i.top,r.bottom=i.top+r.height;var o=this.$dropdown.outerHeight(!1),a=e.scrollTop(),l=e.scrollTop()+e.height(),c=a<i.top-o,e=l>i.bottom+o,a={left:i.left,top:r.bottom},l=this.$dropdownParent;"static"===l.css("position")&&(l=l.offsetParent());i={top:0,left:0};(u.contains(document.body,l[0])||l[0].isConnected)&&(i=l.offset()),a.top-=i.top,a.left-=i.left,t||n||(s="below"),e||!c||t?!c&&e&&t&&(s="below"):s="above",("above"==s||t&&"below"!==s)&&(a.top=r.top-i.top-o),null!=s&&(this.$dropdown[0].classList.remove("select2-dropdown--below"),this.$dropdown[0].classList.remove("select2-dropdown--above"),this.$dropdown[0].classList.add("select2-dropdown--"+s),this.$container[0].classList.remove("select2-container--below"),this.$container[0].classList.remove("select2-container--above"),this.$container[0].classList.add("select2-container--"+s)),this.$dropdownContainer.css(a)},e.prototype._resizeDropdown=function(){var e={width:this.$container.outerWidth(!1)+"px"};this.options.get("dropdownAutoWidth")&&(e.minWidth=e.width,e.position="relative",e.width="auto"),this.$dropdown.css(e)},e.prototype._showDropdown=function(e){this.$dropdownContainer.appendTo(this.$dropdownParent),this._positionDropdown(),this._resizeDropdown()},e}),u.define("select2/dropdown/minimumResultsForSearch",[],function(){function e(e,t,n,s){this.minimumResultsForSearch=n.get("minimumResultsForSearch"),this.minimumResultsForSearch<0&&(this.minimumResultsForSearch=1/0),e.call(this,t,n,s)}return e.prototype.showSearch=function(e,t){return!(function e(t){for(var n=0,s=0;s<t.length;s++){var i=t[s];i.children?n+=e(i.children):n++}return n}(t.data.results)<this.minimumResultsForSearch)&&e.call(this,t)},e}),u.define("select2/dropdown/selectOnClose",["../utils"],function(s){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("close",function(e){s._handleSelectOnClose(e)})},e.prototype._handleSelectOnClose=function(e,t){if(t&&null!=t.originalSelect2Event){var n=t.originalSelect2Event;if("select"===n._type||"unselect"===n._type)return}n=this.getHighlightedResults();n.length<1||(null!=(n=s.GetData(n[0],"data")).element&&n.element.selected||null==n.element&&n.selected||this.trigger("select",{data:n}))},e}),u.define("select2/dropdown/closeOnSelect",[],function(){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("select",function(e){s._selectTriggered(e)}),t.on("unselect",function(e){s._selectTriggered(e)})},e.prototype._selectTriggered=function(e,t){var n=t.originalEvent;n&&(n.ctrlKey||n.metaKey)||this.trigger("close",{originalEvent:n,originalSelect2Event:t})},e}),u.define("select2/dropdown/dropdownCss",["../utils"],function(n){function e(){}return e.prototype.render=function(e){var t=e.call(this),e=this.options.get("dropdownCssClass")||"";return-1!==e.indexOf(":all:")&&(e=e.replace(":all:",""),n.copyNonInternalCssClasses(t[0],this.$element[0])),t.addClass(e),t},e}),u.define("select2/dropdown/tagsSearchHighlight",["../utils"],function(s){function e(){}return e.prototype.highlightFirstItem=function(e){var t=this.$results.find(".select2-results__option--selectable:not(.select2-results__option--selected)");if(0<t.length){var n=t.first(),t=s.GetData(n[0],"data").element;if(t&&t.getAttribute&&"true"===t.getAttribute("data-select2-tag"))return void n.trigger("mouseenter")}e.call(this)},e}),u.define("select2/i18n/en",[],function(){return{errorLoading:function(){return"The results could not be loaded."},inputTooLong:function(e){var t=e.input.length-e.maximum,e="Please delete "+t+" character";return 1!=t&&(e+="s"),e},inputTooShort:function(e){return"Please enter "+(e.minimum-e.input.length)+" or more characters"},loadingMore:function(){return"Loading more results…"},maximumSelected:function(e){var t="You can only select "+e.maximum+" item";return 1!=e.maximum&&(t+="s"),t},noResults:function(){return"No results found"},searching:function(){return"Searching…"},removeAllItems:function(){return"Remove all items"},removeItem:function(){return"Remove item"},search:function(){return"Search"}}}),u.define("select2/defaults",["jquery","./results","./selection/single","./selection/multiple","./selection/placeholder","./selection/allowClear","./selection/search","./selection/selectionCss","./selection/eventRelay","./utils","./translation","./diacritics","./data/select","./data/array","./data/ajax","./data/tags","./data/tokenizer","./data/minimumInputLength","./data/maximumInputLength","./data/maximumSelectionLength","./dropdown","./dropdown/search","./dropdown/hidePlaceholder","./dropdown/infiniteScroll","./dropdown/attachBody","./dropdown/minimumResultsForSearch","./dropdown/selectOnClose","./dropdown/closeOnSelect","./dropdown/dropdownCss","./dropdown/tagsSearchHighlight","./i18n/en"],function(l,r,o,a,c,u,d,p,h,f,g,t,m,y,v,_,b,$,w,x,A,D,S,E,O,C,L,T,q,I,e){function n(){this.reset()}return n.prototype.apply=function(e){var t;null==(e=l.extend(!0,{},this.defaults,e)).dataAdapter&&(null!=e.ajax?e.dataAdapter=v:null!=e.data?e.dataAdapter=y:e.dataAdapter=m,0<e.minimumInputLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,$)),0<e.maximumInputLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,w)),0<e.maximumSelectionLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,x)),e.tags&&(e.dataAdapter=f.Decorate(e.dataAdapter,_)),null==e.tokenSeparators&&null==e.tokenizer||(e.dataAdapter=f.Decorate(e.dataAdapter,b))),null==e.resultsAdapter&&(e.resultsAdapter=r,null!=e.ajax&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,E)),null!=e.placeholder&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,S)),e.selectOnClose&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,L)),e.tags&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,I))),null==e.dropdownAdapter&&(e.multiple?e.dropdownAdapter=A:(t=f.Decorate(A,D),e.dropdownAdapter=t),0!==e.minimumResultsForSearch&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,C)),e.closeOnSelect&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,T)),null!=e.dropdownCssClass&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,q)),e.dropdownAdapter=f.Decorate(e.dropdownAdapter,O)),null==e.selectionAdapter&&(e.multiple?e.selectionAdapter=a:e.selectionAdapter=o,null!=e.placeholder&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,c)),e.allowClear&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,u)),e.multiple&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,d)),null!=e.selectionCssClass&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,p)),e.selectionAdapter=f.Decorate(e.selectionAdapter,h)),e.language=this._resolveLanguage(e.language),e.language.push("en");for(var n=[],s=0;s<e.language.length;s++){var i=e.language[s];-1===n.indexOf(i)&&n.push(i)}return e.language=n,e.translations=this._processTranslations(e.language,e.debug),e},n.prototype.reset=function(){function a(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return t[e]||e})}this.defaults={amdLanguageBase:"./i18n/",autocomplete:"off",closeOnSelect:!0,debug:!1,dropdownAutoWidth:!1,escapeMarkup:f.escapeMarkup,language:{},matcher:function e(t,n){if(null==t.term||""===t.term.trim())return n;if(n.children&&0<n.children.length){for(var s=l.extend(!0,{},n),i=n.children.length-1;0<=i;i--)null==e(t,n.children[i])&&s.children.splice(i,1);return 0<s.children.length?s:e(t,s)}var r=a(n.text).toUpperCase(),o=a(t.term).toUpperCase();return-1<r.indexOf(o)?n:null},minimumInputLength:0,maximumInputLength:0,maximumSelectionLength:0,minimumResultsForSearch:0,selectOnClose:!1,scrollAfterSelect:!1,sorter:function(e){return e},templateResult:function(e){return e.text},templateSelection:function(e){return e.text},theme:"default",width:"resolve"}},n.prototype.applyFromElement=function(e,t){var n=e.language,s=this.defaults.language,i=t.prop("lang"),t=t.closest("[lang]").prop("lang"),t=Array.prototype.concat.call(this._resolveLanguage(i),this._resolveLanguage(n),this._resolveLanguage(s),this._resolveLanguage(t));return e.language=t,e},n.prototype._resolveLanguage=function(e){if(!e)return[];if(l.isEmptyObject(e))return[];if(l.isPlainObject(e))return[e];for(var t,n=Array.isArray(e)?e:[e],s=[],i=0;i<n.length;i++)s.push(n[i]),"string"==typeof n[i]&&0<n[i].indexOf("-")&&(t=n[i].split("-")[0],s.push(t));return s},n.prototype._processTranslations=function(e,t){for(var n=new g,s=0;s<e.length;s++){var i=new g,r=e[s];if("string"==typeof r)try{i=g.loadPath(r)}catch(e){try{r=this.defaults.amdLanguageBase+r,i=g.loadPath(r)}catch(e){t&&window.console&&console.warn&&console.warn('Select2: The language file for "'+r+'" could not be automatically loaded. A fallback will be used instead.')}}else i=l.isPlainObject(r)?new g(r):r;n.extend(i)}return n},n.prototype.set=function(e,t){var n={};n[l.camelCase(e)]=t;n=f._convertData(n);l.extend(!0,this.defaults,n)},new n}),u.define("select2/options",["jquery","./defaults","./utils"],function(c,n,u){function e(e,t){this.options=e,null!=t&&this.fromElement(t),null!=t&&(this.options=n.applyFromElement(this.options,t)),this.options=n.apply(this.options)}return e.prototype.fromElement=function(e){var t=["select2"];null==this.options.multiple&&(this.options.multiple=e.prop("multiple")),null==this.options.disabled&&(this.options.disabled=e.prop("disabled")),null==this.options.autocomplete&&e.prop("autocomplete")&&(this.options.autocomplete=e.prop("autocomplete")),null==this.options.dir&&(e.prop("dir")?this.options.dir=e.prop("dir"):e.closest("[dir]").prop("dir")?this.options.dir=e.closest("[dir]").prop("dir"):this.options.dir="ltr"),e.prop("disabled",this.options.disabled),e.prop("multiple",this.options.multiple),u.GetData(e[0],"select2Tags")&&(this.options.debug&&window.console&&console.warn&&console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'),u.StoreData(e[0],"data",u.GetData(e[0],"select2Tags")),u.StoreData(e[0],"tags",!0)),u.GetData(e[0],"ajaxUrl")&&(this.options.debug&&window.console&&console.warn&&console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."),e.attr("ajax--url",u.GetData(e[0],"ajaxUrl")),u.StoreData(e[0],"ajax-Url",u.GetData(e[0],"ajaxUrl")));var n={};function s(e,t){return t.toUpperCase()}for(var i=0;i<e[0].attributes.length;i++){var r=e[0].attributes[i].name,o="data-";r.substr(0,o.length)==o&&(r=r.substring(o.length),o=u.GetData(e[0],r),n[r.replace(/-([a-z])/g,s)]=o)}c.fn.jquery&&"1."==c.fn.jquery.substr(0,2)&&e[0].dataset&&(n=c.extend(!0,{},e[0].dataset,n));var a,l=c.extend(!0,{},u.GetData(e[0]),n);for(a in l=u._convertData(l))-1<t.indexOf(a)||(c.isPlainObject(this.options[a])?c.extend(this.options[a],l[a]):this.options[a]=l[a]);return this},e.prototype.get=function(e){return this.options[e]},e.prototype.set=function(e,t){this.options[e]=t},e}),u.define("select2/core",["jquery","./options","./utils","./keys"],function(t,i,r,s){var o=function(e,t){null!=r.GetData(e[0],"select2")&&r.GetData(e[0],"select2").destroy(),this.$element=e,this.id=this._generateId(e),t=t||{},this.options=new i(t,e),o.__super__.constructor.call(this);var n=e.attr("tabindex")||0;r.StoreData(e[0],"old-tabindex",n),e.attr("tabindex","-1");t=this.options.get("dataAdapter");this.dataAdapter=new t(e,this.options);n=this.render();this._placeContainer(n);t=this.options.get("selectionAdapter");this.selection=new t(e,this.options),this.$selection=this.selection.render(),this.selection.position(this.$selection,n);t=this.options.get("dropdownAdapter");this.dropdown=new t(e,this.options),this.$dropdown=this.dropdown.render(),this.dropdown.position(this.$dropdown,n);n=this.options.get("resultsAdapter");this.results=new n(e,this.options,this.dataAdapter),this.$results=this.results.render(),this.results.position(this.$results,this.$dropdown);var s=this;this._bindAdapters(),this._registerDomEvents(),this._registerDataEvents(),this._registerSelectionEvents(),this._registerDropdownEvents(),this._registerResultsEvents(),this._registerEvents(),this.dataAdapter.current(function(e){s.trigger("selection:update",{data:e})}),e[0].classList.add("select2-hidden-accessible"),e.attr("aria-hidden","true"),this._syncAttributes(),r.StoreData(e[0],"select2",this),e.data("select2",this)};return r.Extend(o,r.Observable),o.prototype._generateId=function(e){return"select2-"+(null!=e.attr("id")?e.attr("id"):null!=e.attr("name")?e.attr("name")+"-"+r.generateChars(2):r.generateChars(4)).replace(/(:|\.|\[|\]|,)/g,"")},o.prototype._placeContainer=function(e){e.insertAfter(this.$element);var t=this._resolveWidth(this.$element,this.options.get("width"));null!=t&&e.css("width",t)},o.prototype._resolveWidth=function(e,t){var n=/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;if("resolve"==t){var s=this._resolveWidth(e,"style");return null!=s?s:this._resolveWidth(e,"element")}if("element"==t){s=e.outerWidth(!1);return s<=0?"auto":s+"px"}if("style"!=t)return"computedstyle"!=t?t:window.getComputedStyle(e[0]).width;e=e.attr("style");if("string"!=typeof e)return null;for(var i=e.split(";"),r=0,o=i.length;r<o;r+=1){var a=i[r].replace(/\s/g,"").match(n);if(null!==a&&1<=a.length)return a[1]}return null},o.prototype._bindAdapters=function(){this.dataAdapter.bind(this,this.$container),this.selection.bind(this,this.$container),this.dropdown.bind(this,this.$container),this.results.bind(this,this.$container)},o.prototype._registerDomEvents=function(){var t=this;this.$element.on("change.select2",function(){t.dataAdapter.current(function(e){t.trigger("selection:update",{data:e})})}),this.$element.on("focus.select2",function(e){t.trigger("focus",e)}),this._syncA=r.bind(this._syncAttributes,this),this._syncS=r.bind(this._syncSubtree,this),this._observer=new window.MutationObserver(function(e){t._syncA(),t._syncS(e)}),this._observer.observe(this.$element[0],{attributes:!0,childList:!0,subtree:!1})},o.prototype._registerDataEvents=function(){var n=this;this.dataAdapter.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerSelectionEvents=function(){var n=this,s=["toggle","focus"];this.selection.on("toggle",function(){n.toggleDropdown()}),this.selection.on("focus",function(e){n.focus(e)}),this.selection.on("*",function(e,t){-1===s.indexOf(e)&&n.trigger(e,t)})},o.prototype._registerDropdownEvents=function(){var n=this;this.dropdown.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerResultsEvents=function(){var n=this;this.results.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerEvents=function(){var n=this;this.on("open",function(){n.$container[0].classList.add("select2-container--open")}),this.on("close",function(){n.$container[0].classList.remove("select2-container--open")}),this.on("enable",function(){n.$container[0].classList.remove("select2-container--disabled")}),this.on("disable",function(){n.$container[0].classList.add("select2-container--disabled")}),this.on("blur",function(){n.$container[0].classList.remove("select2-container--focus")}),this.on("query",function(t){n.isOpen()||n.trigger("open",{}),this.dataAdapter.query(t,function(e){n.trigger("results:all",{data:e,query:t})})}),this.on("query:append",function(t){this.dataAdapter.query(t,function(e){n.trigger("results:append",{data:e,query:t})})}),this.on("keypress",function(e){var t=e.which;n.isOpen()?t===s.ESC||t===s.UP&&e.altKey?(n.close(e),e.preventDefault()):t===s.ENTER||t===s.TAB?(n.trigger("results:select",{}),e.preventDefault()):t===s.SPACE&&e.ctrlKey?(n.trigger("results:toggle",{}),e.preventDefault()):t===s.UP?(n.trigger("results:previous",{}),e.preventDefault()):t===s.DOWN&&(n.trigger("results:next",{}),e.preventDefault()):(t===s.ENTER||t===s.SPACE||t===s.DOWN&&e.altKey)&&(n.open(),e.preventDefault())})},o.prototype._syncAttributes=function(){this.options.set("disabled",this.$element.prop("disabled")),this.isDisabled()?(this.isOpen()&&this.close(),this.trigger("disable",{})):this.trigger("enable",{})},o.prototype._isChangeMutation=function(e){var t=this;if(e.addedNodes&&0<e.addedNodes.length){for(var n=0;n<e.addedNodes.length;n++)if(e.addedNodes[n].selected)return!0}else{if(e.removedNodes&&0<e.removedNodes.length)return!0;if(Array.isArray(e))return e.some(function(e){return t._isChangeMutation(e)})}return!1},o.prototype._syncSubtree=function(e){var e=this._isChangeMutation(e),t=this;e&&this.dataAdapter.current(function(e){t.trigger("selection:update",{data:e})})},o.prototype.trigger=function(e,t){var n=o.__super__.trigger,s={open:"opening",close:"closing",select:"selecting",unselect:"unselecting",clear:"clearing"};if(void 0===t&&(t={}),e in s){var i=s[e],s={prevented:!1,name:e,args:t};if(n.call(this,i,s),s.prevented)return void(t.prevented=!0)}n.call(this,e,t)},o.prototype.toggleDropdown=function(){this.isDisabled()||(this.isOpen()?this.close():this.open())},o.prototype.open=function(){this.isOpen()||this.isDisabled()||this.trigger("query",{})},o.prototype.close=function(e){this.isOpen()&&this.trigger("close",{originalEvent:e})},o.prototype.isEnabled=function(){return!this.isDisabled()},o.prototype.isDisabled=function(){return this.options.get("disabled")},o.prototype.isOpen=function(){return this.$container[0].classList.contains("select2-container--open")},o.prototype.hasFocus=function(){return this.$container[0].classList.contains("select2-container--focus")},o.prototype.focus=function(e){this.hasFocus()||(this.$container[0].classList.add("select2-container--focus"),this.trigger("focus",{}))},o.prototype.enable=function(e){this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.');e=!(e=null==e||0===e.length?[!0]:e)[0];this.$element.prop("disabled",e)},o.prototype.data=function(){this.options.get("debug")&&0<arguments.length&&window.console&&console.warn&&console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');var t=[];return this.dataAdapter.current(function(e){t=e}),t},o.prototype.val=function(e){if(this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'),null==e||0===e.length)return this.$element.val();e=e[0];Array.isArray(e)&&(e=e.map(function(e){return e.toString()})),this.$element.val(e).trigger("input").trigger("change")},o.prototype.destroy=function(){r.RemoveData(this.$container[0]),this.$container.remove(),this._observer.disconnect(),this._observer=null,this._syncA=null,this._syncS=null,this.$element.off(".select2"),this.$element.attr("tabindex",r.GetData(this.$element[0],"old-tabindex")),this.$element[0].classList.remove("select2-hidden-accessible"),this.$element.attr("aria-hidden","false"),r.RemoveData(this.$element[0]),this.$element.removeData("select2"),this.dataAdapter.destroy(),this.selection.destroy(),this.dropdown.destroy(),this.results.destroy(),this.dataAdapter=null,this.selection=null,this.dropdown=null,this.results=null},o.prototype.render=function(){var e=t('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');return e.attr("dir",this.options.get("dir")),this.$container=e,this.$container[0].classList.add("select2-container--"+this.options.get("theme")),r.StoreData(e[0],"element",this.$element),e},o}),u.define("jquery-mousewheel",["jquery"],function(e){return e}),u.define("jquery.select2",["jquery","jquery-mousewheel","./select2/core","./select2/defaults","./select2/utils"],function(i,e,r,t,o){var a;return null==i.fn.select2&&(a=["open","close","destroy"],i.fn.select2=function(t){if("object"==typeof(t=t||{}))return this.each(function(){var e=i.extend(!0,{},t);new r(i(this),e)}),this;if("string"!=typeof t)throw new Error("Invalid arguments for Select2: "+t);var n,s=Array.prototype.slice.call(arguments,1);return this.each(function(){var e=o.GetData(this,"select2");null==e&&window.console&&console.error&&console.error("The select2('"+t+"') method was called on an element that is not using Select2."),n=e[t].apply(e,s)}),-1<a.indexOf(t)?this:n}),null==i.fn.select2.defaults&&(i.fn.select2.defaults=t),r}),{define:u.define,require:u.require});function b(e,t){return i.call(e,t)}function l(e,t){var n,s,i,r,o,a,l,c,u,d,p=t&&t.split("/"),h=y.map,f=h&&h["*"]||{};if(e){for(t=(e=e.split("/")).length-1,y.nodeIdCompat&&_.test(e[t])&&(e[t]=e[t].replace(_,"")),"."===e[0].charAt(0)&&p&&(e=p.slice(0,p.length-1).concat(e)),c=0;c<e.length;c++)"."===(d=e[c])?(e.splice(c,1),--c):".."===d&&(0===c||1===c&&".."===e[2]||".."===e[c-1]||0<c&&(e.splice(c-1,2),c-=2));e=e.join("/")}if((p||f)&&h){for(c=(n=e.split("/")).length;0<c;--c){if(s=n.slice(0,c).join("/"),p)for(u=p.length;0<u;--u)if(i=h[p.slice(0,u).join("/")],i=i&&i[s]){r=i,o=c;break}if(r)break;!a&&f&&f[s]&&(a=f[s],l=c)}!r&&a&&(r=a,o=l),r&&(n.splice(0,o,r),e=n.join("/"))}return e}function w(t,n){return function(){var e=a.call(arguments,0);return"string"!=typeof e[0]&&1===e.length&&e.push(null),o.apply(p,e.concat([t,n]))}}function x(e){var t;if(b(m,e)&&(t=m[e],delete m[e],v[e]=!0,r.apply(p,t)),!b(g,e)&&!b(v,e))throw new Error("No "+e);return g[e]}function c(e){var t,n=e?e.indexOf("!"):-1;return-1<n&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function A(e){return e?c(e):[]}var u=s.require("jquery.select2");return t.fn.select2.amd=s,u});</script>
    <script>
        jQuery(document).ready(function($) {
            $('.js-example-basic-single').select2();
        });
    </script>
    <style>.select2-container{box-sizing:border-box;display:inline-block;margin:0;position:relative;vertical-align:middle}.select2-container .select2-selection--single{box-sizing:border-box;cursor:pointer;display:block;height:28px;user-select:none;-webkit-user-select:none}.select2-container .select2-selection--single .select2-selection__rendered{display:block;padding-left:8px;padding-right:20px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.select2-container .select2-selection--single .select2-selection__clear{background-color:transparent;border:none;font-size:1em}.select2-container[dir="rtl"] .select2-selection--single .select2-selection__rendered{padding-right:8px;padding-left:20px}.select2-container .select2-selection--multiple{box-sizing:border-box;cursor:pointer;display:block;min-height:32px;user-select:none;-webkit-user-select:none}.select2-container .select2-selection--multiple .select2-selection__rendered{display:block;list-style:none;padding:0}.select2-container .select2-selection--multiple .select2-selection__clear{background-color:transparent;border:none;font-size:1em}.select2-container .select2-search--inline .select2-search__field{box-sizing:border-box;border:none;font-size:100%;margin-top:5px;margin-left:5px;padding:0;max-width:100%;resize:none;height:18px;vertical-align:bottom;font-family:sans-serif;overflow:hidden;word-break:keep-all}.select2-container .select2-search--inline .select2-search__field::-webkit-search-cancel-button{-webkit-appearance:none}.select2-dropdown{background-color:white;border:1px solid #aaa;border-radius:4px;box-sizing:border-box;display:block;position:absolute;left:-100000px;width:100%;z-index:1051}.select2-results{display:block}.select2-results__options{list-style:none;margin:0;padding:0}.select2-results__option{padding:6px;user-select:none;-webkit-user-select:none}.select2-results__option--selectable{cursor:pointer}.select2-container--open .select2-dropdown{left:0}.select2-container--open .select2-dropdown--above{border-bottom:none;border-bottom-left-radius:0;border-bottom-right-radius:0}.select2-container--open .select2-dropdown--below{border-top:none;border-top-left-radius:0;border-top-right-radius:0}.select2-search--dropdown{display:block;padding:4px}.select2-search--dropdown .select2-search__field{padding:4px;width:100%;box-sizing:border-box}.select2-search--dropdown .select2-search__field::-webkit-search-cancel-button{-webkit-appearance:none}.select2-search--dropdown.select2-search--hide{display:none}.select2-close-mask{border:0;margin:0;padding:0;display:block;position:fixed;left:0;top:0;min-height:100%;min-width:100%;height:auto;width:auto;opacity:0;z-index:99;background-color:#fff;filter:alpha(opacity=0)}.select2-hidden-accessible{border:0 !important;clip:rect(0 0 0 0) !important;-webkit-clip-path:inset(50%) !important;clip-path:inset(50%) !important;height:1px !important;overflow:hidden !important;padding:0 !important;position:absolute !important;width:1px !important;white-space:nowrap !important}.select2-container--default .select2-selection--single{background-color:#fff;border:1px solid #aaa;border-radius:4px}.select2-container--default .select2-selection--single .select2-selection__rendered{color:#444;line-height:28px}.select2-container--default .select2-selection--single .select2-selection__clear{cursor:pointer;float:right;font-weight:bold;height:26px;margin-right:20px;padding-right:0px}.select2-container--default .select2-selection--single .select2-selection__placeholder{color:#999}.select2-container--default .select2-selection--single .select2-selection__arrow{height:26px;position:absolute;top:1px;right:1px;width:20px}.select2-container--default .select2-selection--single .select2-selection__arrow b{border-color:#888 transparent transparent transparent;border-style:solid;border-width:5px 4px 0 4px;height:0;left:50%;margin-left:-4px;margin-top:-2px;position:absolute;top:50%;width:0}.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__clear{float:left}.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__arrow{left:1px;right:auto}.select2-container--default.select2-container--disabled .select2-selection--single{background-color:#eee;cursor:default}.select2-container--default.select2-container--disabled .select2-selection--single .select2-selection__clear{display:none}.select2-container--default.select2-container--open .select2-selection--single .select2-selection__arrow b{border-color:transparent transparent #888 transparent;border-width:0 4px 5px 4px}.select2-container--default .select2-selection--multiple{background-color:white;border:1px solid #aaa;border-radius:4px;cursor:text;padding-bottom:5px;padding-right:5px;position:relative}.select2-container--default .select2-selection--multiple.select2-selection--clearable{padding-right:25px}.select2-container--default .select2-selection--multiple .select2-selection__clear{cursor:pointer;font-weight:bold;height:20px;margin-right:10px;margin-top:5px;position:absolute;right:0;padding:1px}.select2-container--default .select2-selection--multiple .select2-selection__choice{background-color:#e4e4e4;border:1px solid #aaa;border-radius:4px;box-sizing:border-box;display:inline-block;margin-left:5px;margin-top:5px;padding:0;padding-left:20px;position:relative;max-width:100%;overflow:hidden;text-overflow:ellipsis;vertical-align:bottom;white-space:nowrap}.select2-container--default .select2-selection--multiple .select2-selection__choice__display{cursor:default;padding-left:2px;padding-right:5px}.select2-container--default .select2-selection--multiple .select2-selection__choice__remove{background-color:transparent;border:none;border-right:1px solid #aaa;border-top-left-radius:4px;border-bottom-left-radius:4px;color:#999;cursor:pointer;font-size:1em;font-weight:bold;padding:0 4px;position:absolute;left:0;top:0}.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover,.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:focus{background-color:#f1f1f1;color:#333;outline:none}.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice{margin-left:5px;margin-right:auto}.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice__display{padding-left:5px;padding-right:2px}.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice__remove{border-left:1px solid #aaa;border-right:none;border-top-left-radius:0;border-bottom-left-radius:0;border-top-right-radius:4px;border-bottom-right-radius:4px}.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__clear{float:left;margin-left:10px;margin-right:auto}.select2-container--default.select2-container--focus .select2-selection--multiple{border:solid black 1px;outline:0}.select2-container--default.select2-container--disabled .select2-selection--multiple{background-color:#eee;cursor:default}.select2-container--default.select2-container--disabled .select2-selection__choice__remove{display:none}.select2-container--default.select2-container--open.select2-container--above .select2-selection--single,.select2-container--default.select2-container--open.select2-container--above .select2-selection--multiple{border-top-left-radius:0;border-top-right-radius:0}.select2-container--default.select2-container--open.select2-container--below .select2-selection--single,.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple{border-bottom-left-radius:0;border-bottom-right-radius:0}.select2-container--default .select2-search--dropdown .select2-search__field{border:1px solid #aaa}.select2-container--default .select2-search--inline .select2-search__field{background:transparent;border:none;outline:0;box-shadow:none;-webkit-appearance:textfield}.select2-container--default .select2-results>.select2-results__options{max-height:200px;overflow-y:auto}.select2-container--default .select2-results__option .select2-results__option{padding-left:1em}.select2-container--default .select2-results__option .select2-results__option .select2-results__group{padding-left:0}.select2-container--default .select2-results__option .select2-results__option .select2-results__option{margin-left:-1em;padding-left:2em}.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option{margin-left:-2em;padding-left:3em}.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option{margin-left:-3em;padding-left:4em}.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option{margin-left:-4em;padding-left:5em}.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option{margin-left:-5em;padding-left:6em}.select2-container--default .select2-results__option--group{padding:0}.select2-container--default .select2-results__option--disabled{color:#999}.select2-container--default .select2-results__option--selected{background-color:#ddd}.select2-container--default .select2-results__option--highlighted.select2-results__option--selectable{background-color:#5897fb;color:white}.select2-container--default .select2-results__group{cursor:default;display:block;padding:6px}.select2-container--classic .select2-selection--single{background-color:#f7f7f7;border:1px solid #aaa;border-radius:4px;outline:0;background-image:-webkit-linear-gradient(top, #fff 50%, #eee 100%);background-image:-o-linear-gradient(top, #fff 50%, #eee 100%);background-image:linear-gradient(to bottom, #fff 50%, #eee 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFFFFFFF', endColorstr='#FFEEEEEE', GradientType=0)}.select2-container--classic .select2-selection--single:focus{border:1px solid #5897fb}.select2-container--classic .select2-selection--single .select2-selection__rendered{color:#444;line-height:28px}.select2-container--classic .select2-selection--single .select2-selection__clear{cursor:pointer;float:right;font-weight:bold;height:26px;margin-right:20px}.select2-container--classic .select2-selection--single .select2-selection__placeholder{color:#999}.select2-container--classic .select2-selection--single .select2-selection__arrow{background-color:#ddd;border:none;border-left:1px solid #aaa;border-top-right-radius:4px;border-bottom-right-radius:4px;height:26px;position:absolute;top:1px;right:1px;width:20px;background-image:-webkit-linear-gradient(top, #eee 50%, #ccc 100%);background-image:-o-linear-gradient(top, #eee 50%, #ccc 100%);background-image:linear-gradient(to bottom, #eee 50%, #ccc 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFEEEEEE', endColorstr='#FFCCCCCC', GradientType=0)}.select2-container--classic .select2-selection--single .select2-selection__arrow b{border-color:#888 transparent transparent transparent;border-style:solid;border-width:5px 4px 0 4px;height:0;left:50%;margin-left:-4px;margin-top:-2px;position:absolute;top:50%;width:0}.select2-container--classic[dir="rtl"] .select2-selection--single .select2-selection__clear{float:left}.select2-container--classic[dir="rtl"] .select2-selection--single .select2-selection__arrow{border:none;border-right:1px solid #aaa;border-radius:0;border-top-left-radius:4px;border-bottom-left-radius:4px;left:1px;right:auto}.select2-container--classic.select2-container--open .select2-selection--single{border:1px solid #5897fb}.select2-container--classic.select2-container--open .select2-selection--single .select2-selection__arrow{background:transparent;border:none}.select2-container--classic.select2-container--open .select2-selection--single .select2-selection__arrow b{border-color:transparent transparent #888 transparent;border-width:0 4px 5px 4px}.select2-container--classic.select2-container--open.select2-container--above .select2-selection--single{border-top:none;border-top-left-radius:0;border-top-right-radius:0;background-image:-webkit-linear-gradient(top, #fff 0%, #eee 50%);background-image:-o-linear-gradient(top, #fff 0%, #eee 50%);background-image:linear-gradient(to bottom, #fff 0%, #eee 50%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFFFFFFF', endColorstr='#FFEEEEEE', GradientType=0)}.select2-container--classic.select2-container--open.select2-container--below .select2-selection--single{border-bottom:none;border-bottom-left-radius:0;border-bottom-right-radius:0;background-image:-webkit-linear-gradient(top, #eee 50%, #fff 100%);background-image:-o-linear-gradient(top, #eee 50%, #fff 100%);background-image:linear-gradient(to bottom, #eee 50%, #fff 100%);background-repeat:repeat-x;filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFEEEEEE', endColorstr='#FFFFFFFF', GradientType=0)}.select2-container--classic .select2-selection--multiple{background-color:white;border:1px solid #aaa;border-radius:4px;cursor:text;outline:0;padding-bottom:5px;padding-right:5px}.select2-container--classic .select2-selection--multiple:focus{border:1px solid #5897fb}.select2-container--classic .select2-selection--multiple .select2-selection__clear{display:none}.select2-container--classic .select2-selection--multiple .select2-selection__choice{background-color:#e4e4e4;border:1px solid #aaa;border-radius:4px;display:inline-block;margin-left:5px;margin-top:5px;padding:0}.select2-container--classic .select2-selection--multiple .select2-selection__choice__display{cursor:default;padding-left:2px;padding-right:5px}.select2-container--classic .select2-selection--multiple .select2-selection__choice__remove{background-color:transparent;border:none;border-top-left-radius:4px;border-bottom-left-radius:4px;color:#888;cursor:pointer;font-size:1em;font-weight:bold;padding:0 4px}.select2-container--classic .select2-selection--multiple .select2-selection__choice__remove:hover{color:#555;outline:none}.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice{margin-left:5px;margin-right:auto}.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice__display{padding-left:5px;padding-right:2px}.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice__remove{border-top-left-radius:0;border-bottom-left-radius:0;border-top-right-radius:4px;border-bottom-right-radius:4px}.select2-container--classic.select2-container--open .select2-selection--multiple{border:1px solid #5897fb}.select2-container--classic.select2-container--open.select2-container--above .select2-selection--multiple{border-top:none;border-top-left-radius:0;border-top-right-radius:0}.select2-container--classic.select2-container--open.select2-container--below .select2-selection--multiple{border-bottom:none;border-bottom-left-radius:0;border-bottom-right-radius:0}.select2-container--classic .select2-search--dropdown .select2-search__field{border:1px solid #aaa;outline:0}.select2-container--classic .select2-search--inline .select2-search__field{outline:0;box-shadow:none}.select2-container--classic .select2-dropdown{background-color:#fff;border:1px solid transparent}.select2-container--classic .select2-dropdown--above{border-bottom:none}.select2-container--classic .select2-dropdown--below{border-top:none}.select2-container--classic .select2-results>.select2-results__options{max-height:200px;overflow-y:auto}.select2-container--classic .select2-results__option--group{padding:0}.select2-container--classic .select2-results__option--disabled{color:grey}.select2-container--classic .select2-results__option--highlighted.select2-results__option--selectable{background-color:#3875d7;color:#fff}.select2-container--classic .select2-results__group{cursor:default;display:block;padding:6px}.select2-container--classic.select2-container--open .select2-dropdown{border-color:#5897fb}.select2-selection__rendered{display: block;}</style>

    <tr class="form-field">
        <th scope="row" valign="top"><label for="rooms_cat_elite">انتخاب اتاق فرارها</label></th>
        <td>
            <select class="js-example-basic-single" name="rooms_cat_elite[]" multiple="multiple" >
                <?php
                while ($query->have_posts()) : $query->the_post(); ?>
                    <option <?php echo in_array(get_the_ID(), (array)get_term_meta($term_id, 'rooms_cat_elite', true)) ? 'selected="selected"' : ''; ?> value="<?php echo get_the_ID(); ?>"><?php echo get_the_title(); ?></option>
                <?php
                endwhile;
                wp_reset_postdata(); ?>
            </select>
        </td>
    </tr>

    <tr class="form-field">
        <th scope="row" valign="top"><label for="short_text">متن کوتاه</label></th>
        <td>
            <textarea name="short_text"><?php echo get_term_meta($term_id, 'short_text', true) ?></textarea>
        </td>
    </tr>
    <?php
}
/*=======================*/
add_action('edited_product_tag', 'save_fields_to_product_tag', 10, 1);
add_action('create_product_tag', 'save_fields_to_product_tag', 10, 1);
function save_fields_to_product_tag($term_id) {
    update_term_meta($term_id, 'rooms_cat_elite', $_POST['rooms_cat_elite']);
}
/****************************************************************************************************************************************/
add_filter('wpseo_sitemap_entry', 'convert_sitemap_url_from_lower_to_upper', 10, 1);
function convert_sitemap_url_from_lower_to_upper ($url) {

    $temp                   = explode('/', $url['loc']);
    $lowercase_url_value    = $temp[count($temp) - 2];
    $url['loc']             = str_replace($lowercase_url_value, strtoupper($lowercase_url_value), $url['loc']);

    if ( !empty($url['loc']) ) return $url;
}
/****************************************************************************************************************************************/
add_action('add_meta_boxes', 'reservation_info_metabox');
function reservation_info_metabox() {
    add_meta_box(
        'reservation_info',
        'اطلاعات رزرواسیون',
        'reservation_info_callback',
        'product',
        'normal',
        'high'
    );
}
/*=========================================================================================*/
function reservation_info_callback($post) {

    $pish_pardakht_per_person   = get_post_meta($post->ID, 'pish_pardakht_per_person', true);
    $auto_disable               = get_post_meta($post->ID, 'auto_disable', true);
    $schedule_normals           = get_post_meta($post->ID, 'schedule_normals', true);
    $schedule_holidays          = get_post_meta($post->ID, 'schedule_holidays', true); ?>

    <div class="reservation_info_section_wrapper">
        <label style="width: 120px;display: inline-block;">تعداد بیعانه: </label>
        <select style="width: 100px;" name="pish_pardakht_per_person">
            <?php
            $ppl = [1, 2, 3, 4];
            foreach ( $ppl as $val ) : ?>
                <option value="<?php echo $val ?>" <?php echo esc_attr($pish_pardakht_per_person) == $val ? 'selected' : ''; ?>><?php echo $val ?></option>
            <?php
            endforeach; ?>
        </select>
    </div>
    <hr>

    <div class="reservation_info_section_wrapper">
        <label style="width: 120px;display: inline-block;">زمان غیرفعال شدن: </label>
        <input type="text" name="auto_disable" style="width: 100px;" value="<?php echo $auto_disable; ?>" >
    </div>
    <hr>

    <div class="reservation_info_section_wrapper" id="reservation_info_normals_schedule">
        <h3 class="panel-title">سانس های عادی</h3>

        <div class="list_wrapper">

            <?php
            foreach ( $schedule_normals as $key => $normal_day ) : ?>

                <div class="reservation_info_schedule_wrapper">
                    <div class="form-group">
                        <label>ساعت : </label>
                        <input name="schedule_normals[<?php echo $key ?>][time]" type="time" value="<?php echo $normal_day['time'] ?>" class="schedule_sans_time"/>
                    </div>

                    <div class="form-group">
                        <label>قیمت عادی : </label>
                        <input autocomplete="off" name="schedule_normals[<?php echo $key ?>][price]" type="text" value="<?php echo $normal_day['price'] ?>" class="schedule_sans_price"/>
                    </div>

                    <div class="form-group">
                        <label>قیمت تخفیف دار : </label>
                        <input autocomplete="off" name="schedule_normals[<?php echo $key ?>][off_price]" type="text" value="<?php echo $normal_day['off_price'] ?>" class="schedule_sans_off_price"/>
                    </div>

                    <div class="form-group">
                        <button class="list_remove_button" type="button">-</button>
                    </div>
                </div>

            <?php
            endforeach; ?>

        </div>
        <button class="list_add_button" type="button">+</button>

    </div>
    <hr>

    <div class="reservation_info_section_wrapper" id="reservation_info_holidays_schedule">
        <h3 class="panel-title">سانس های تعطیل</h3>

        <div class="list_wrapper">

            <?php
            foreach ( $schedule_holidays as $key => $holidays_day ) : ?>

                <div class="reservation_info_schedule_wrapper">
                    <div class="form-group">
                        <label>ساعت : </label>
                        <input name="schedule_holidays[<?php echo $key ?>][time]" type="time" class="schedule_sans_time" value="<?php echo $holidays_day['time'] ?>"/>
                    </div>

                    <div class="form-group">
                        <label>قیمت عادی : </label>
                        <input autocomplete="off" name="schedule_holidays[<?php echo $key ?>][price]" type="text" class="schedule_sans_price" value="<?php echo $holidays_day['price'] ?>"/>
                    </div>

                    <div class="form-group">
                        <label>قیمت تخفیف دار : </label>
                        <input autocomplete="off" name="schedule_holidays[<?php echo $key ?>][off_price]" type="text" class="schedule_sans_off_price" value="<?php echo $holidays_day['off_price'] ?>"/>
                    </div>

                    <div class="form-group">
                        <button class="list_remove_button" type="button">-</button>
                    </div>
                </div>

            <?php
            endforeach; ?>

        </div>
        <button class="list_add_button" type="button">+</button>
    </div>

    <style>
        .schedule_sans_time, .schedule_sans_price, .schedule_sans_off_price, .reservation_info_section_wrapper input, .reservation_info_section_wrapper select {
            border: 1px solid #ccc !important;
            border-radius: 4px !important;
            -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075) !important;
            box-shadow: inset 0 1px 1px rgba(0,0,0,.075) !important;
            -webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s !important;
            -o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s !important;
            transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s !important;
        }
        .schedule_sans_time {
            width: 120px;
            display: inline-block;
        }
        .schedule_sans_price {
            width: 150px;
            display: inline-block;
        }
        .schedule_sans_off_price {
            width: 150px;
            display: inline-block;
        }
        .reservation_info_section_wrapper {
            margin: 20px 0;
        }
        .list_add_button {
            border: none;
            background: green;
            width: 50px;
            height: 50px;
            color: #fff;
            font-size: 35px;
            border-radius: 50px;
            margin: 20px auto 0 25px;
            cursor: pointer;
            padding: 0;
            display: block;
        }
        .list_remove_button {
            border: none;
            background: red;
            width: 30px;
            height: 30px;
            color: #fff;
            font-size: 20px;
            border-radius: 50px;
            margin: 0 0 0 10px;
            cursor: pointer;
        }
        .reservation_info_schedule_wrapper {
            display: flex;
            flex-wrap: wrap;
            margin: 3px 0;
            background: #eee;
            padding: 10px;
            border-radius: 8px;
        }
        .form-group {
            margin: 0 15px;
        }
        .form-group:last-of-type {
            margin-right: auto;
        }
    </style>

    <script>
        jQuery(document).ready(function($) {
            var x = <?php echo !empty($schedule_normals) ? count($schedule_normals) : 0; ?>;
            $('body').on('click', '#reservation_info_normals_schedule .list_add_button', function() { x++;

                var html = '';
                html += '<div class="reservation_info_schedule_wrapper">';
                html += '<div class="form-group"><label>ساعت : </label><input name="schedule_normals['+x+'][time]" type="time" class="schedule_sans_time"/></div>';
                html += '<div class="form-group"><label>قیمت عادی : </label><input autocomplete="off" name="schedule_normals['+x+'][price]" type="text" class="schedule_sans_price"/></div>';
                html += '<div class="form-group"><label>قیمت تخفیف دار : </label><input autocomplete="off" name="schedule_normals['+x+'][off_price]" type="text" class="schedule_sans_off_price"/></div>';
                html += '<div class="form-group"><button class="list_remove_button" type="button">-</button></div>';
                html += '</div>';

                $(this).siblings('#reservation_info_normals_schedule .list_wrapper').append(html);
            });
            $('body').on('click', '#reservation_info_normals_schedule .list_remove_button', function() {
                $(this).closest('.reservation_info_schedule_wrapper').remove();
                x--;
            });

            var y = <?php echo !empty($schedule_holidays) ? count($schedule_holidays) : 0; ?>;
            $('body').on('click', '#reservation_info_holidays_schedule .list_add_button', function() { y++;

                var html = '';
                html += '<div class="reservation_info_schedule_wrapper">';
                html += '<div class="form-group"><label>ساعت : </label><input name="schedule_holidays['+y+'][time]" type="time" class="schedule_sans_time"/></div>';
                html += '<div class="form-group"><label>قیمت عادی : </label><input autocomplete="off" name="schedule_holidays['+y+'][price]" type="text" class="schedule_sans_price"/></div>';
                html += '<div class="form-group"><label>قیمت تخفیف دار : </label><input autocomplete="off" name="schedule_holidays['+y+'][off_price]" type="text" class="schedule_sans_off_price"/></div>';
                html += '<div class="form-group"><button class="list_remove_button" type="button">-</button></div>';
                html += '</div>';

                $(this).siblings('#reservation_info_holidays_schedule .list_wrapper').append(html);
            });
            $('body').on('click', '#reservation_info_holidays_schedule .list_remove_button', function() {
                $(this).closest('.reservation_info_schedule_wrapper').remove();
                y--;
            });
        });
    </script>

    <?php
}
/*=========================================================================================*/
add_action('save_post', 'save_reservation_info', 10, 3);
function save_reservation_info($product_id, $post, $update) {

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $product_id)) return;

    if (isset($_POST['pish_pardakht_per_person']))
        update_post_meta($product_id, 'pish_pardakht_per_person', sanitize_text_field($_POST['pish_pardakht_per_person']));

    if (isset($_POST['auto_disable']))
        update_post_meta($product_id, 'auto_disable', sanitize_text_field($_POST['auto_disable']));

    if (isset($_POST['schedule_normals'])) {

        $temp = [];
        foreach ( $_POST['schedule_normals'] as $val )
            $temp[] = $val;

        update_post_meta($product_id, 'schedule_normals', $temp);
    }

    if (isset($_POST['schedule_holidays'])) {

        $temp = [];
        foreach ( $_POST['schedule_holidays'] as $val )
            $temp[] = $val;

        update_post_meta($product_id, 'schedule_holidays', $temp);
    }

    if ( $post->post_type == 'product' && $update ) {

        $last_price = [];

        $sanses = get_sanses($product_id);
        foreach ( $sanses as $sans_by_type )
            foreach ( $sans_by_type as $sans )
                $last_price[] = $sans['off_price'] ? $sans['off_price'] : $sans['price'];

        if ( !empty($last_price) )
            update_post_meta($product_id, 'min_price', min($last_price));

        ez_reservation( array('type' => 'update_product_sub_data', 'data' => array('room_id' => $product_id, 'schedule' => $sanses, 'pish_person' => $_POST['pish_pardakht_per_person'])) );
    }
}
/****************************************************************************************************************************************/
add_action('add_meta_boxes', 'product_options_metabox');
function product_options_metabox() {

    add_meta_box(
        'product_options',
        'امکانات',
        'product_options_callback',
        'product',
        'normal',
        'high'
    );
}
/*=========================================================================================*/
function product_options_callback($post) {

    $product_types_name = [
        'escaperoom'    => 'اتاق فرار',
        'cinema'        => 'سینما ترس',
        'lasertag'      => 'لیزرتگ',
        'rageroom'      => 'اتاق خشم',
    ];

    $products_options = [
        'escaperoom'=> [
            'easy_park'     => 'جای پارک آسان', // نام های انگلیسی صرفا برای مدیریت آیتم ها استفاده شده تا یونیک باشند
            'cafe'          => 'کافه',
            'surprise'      => 'سورپرایز تولد',
            'transport'     => 'مترو یا BRT',
            'waiting_room'  => 'اتاق انتظار همراه',
            'wc'            => 'سرویس بهداشتی',
            'ventilation'   => 'تهویه مناسب',
        ],
        'cinema'    => [
            'easy_park'     => 'جای پارک آسان',
            'cafe'          => 'کافه',
            'surprise'      => 'سورپرایز تولد',
            'transport'     => 'مترو یا BRT',
            'waiting_room'  => 'اتاق انتظار همراه',
            'wc'            => 'سرویس بهداشتی',
            'ventilation'   => 'تهویه مناسب',
        ],
        'lasertag'  => [
            'easy_park'     => 'جای پارک آسان',
            'cafe'          => 'کافه',
            'surprise'      => 'سورپرایز تولد',
            'transport'     => 'مترو یا BRT',
            'waiting_room'  => 'اتاق انتظار همراه',
            'wc'            => 'سرویس بهداشتی',
            'ventilation'   => 'تهویه مناسب',
        ],
        'rageroom'  => [
            'easy_park'     => 'جای پارک آسان',
            'cafe'          => 'کافه',
            'surprise'      => 'سورپرایز تولد',
            'transport'     => 'مترو یا BRT',
            'waiting_room'  => 'اتاق انتظار همراه',
            'wc'            => 'سرویس بهداشتی',
            'ventilation'   => 'تهویه مناسب',
        ],
    ];

    $product_options = $products_options[array_search( ez_get_product_meta($post->ID)->product_type, $product_types_name ) ? : null];

    $selected_product_options = get_post_meta($post->ID, 'product_options', true) ? : []; ?>

    <script>!function(n){"function"==typeof define&&define.amd?define(["jquery"],n):"object"==typeof module&&module.exports?module.exports=function(e,t){return void 0===t&&(t="undefined"!=typeof window?require("jquery"):require("jquery")(e)),n(t),t}:n(jQuery)}(function(t){var e,n,s,p,r,o,h,f,g,m,y,v,i,a,_,s=((u=t&&t.fn&&t.fn.select2&&t.fn.select2.amd?t.fn.select2.amd:u)&&u.requirejs||(u?n=u:u={},g={},m={},y={},v={},i=Object.prototype.hasOwnProperty,a=[].slice,_=/\.js$/,h=function(e,t){var n,s,i=c(e),r=i[0],t=t[1];return e=i[1],r&&(n=x(r=l(r,t))),r?e=n&&n.normalize?n.normalize(e,(s=t,function(e){return l(e,s)})):l(e,t):(r=(i=c(e=l(e,t)))[0],e=i[1],r&&(n=x(r))),{f:r?r+"!"+e:e,n:e,pr:r,p:n}},f={require:function(e){return w(e)},exports:function(e){var t=g[e];return void 0!==t?t:g[e]={}},module:function(e){return{id:e,uri:"",exports:g[e],config:(t=e,function(){return y&&y.config&&y.config[t]||{}})};var t}},r=function(e,t,n,s){var i,r,o,a,l,c=[],u=typeof n,d=A(s=s||e);if("undefined"==u||"function"==u){for(t=!t.length&&n.length?["require","exports","module"]:t,a=0;a<t.length;a+=1)if("require"===(r=(o=h(t[a],d)).f))c[a]=f.require(e);else if("exports"===r)c[a]=f.exports(e),l=!0;else if("module"===r)i=c[a]=f.module(e);else if(b(g,r)||b(m,r)||b(v,r))c[a]=x(r);else{if(!o.p)throw new Error(e+" missing "+r);o.p.load(o.n,w(s,!0),function(t){return function(e){g[t]=e}}(r),{}),c[a]=g[r]}u=n?n.apply(g[e],c):void 0,e&&(i&&i.exports!==p&&i.exports!==g[e]?g[e]=i.exports:u===p&&l||(g[e]=u))}else e&&(g[e]=n)},e=n=o=function(e,t,n,s,i){if("string"==typeof e)return f[e]?f[e](t):x(h(e,A(t)).f);if(!e.splice){if((y=e).deps&&o(y.deps,y.callback),!t)return;t.splice?(e=t,t=n,n=null):e=p}return t=t||function(){},"function"==typeof n&&(n=s,s=i),s?r(p,e,t,n):setTimeout(function(){r(p,e,t,n)},4),o},o.config=function(e){return o(e)},e._defined=g,(s=function(e,t,n){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(n=t,t=[]),b(g,e)||b(m,e)||(m[e]=[e,t,n])}).amd={jQuery:!0},u.requirejs=e,u.require=n,u.define=s),u.define("almond",function(){}),u.define("jquery",[],function(){var e=t||$;return null==e&&console&&console.error&&console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."),e}),u.define("select2/utils",["jquery"],function(r){var s={};function c(e){var t,n=e.prototype,s=[];for(t in n)"function"==typeof n[t]&&"constructor"!==t&&s.push(t);return s}s.Extend=function(e,t){var n,s={}.hasOwnProperty;function i(){this.constructor=e}for(n in t)s.call(t,n)&&(e[n]=t[n]);return i.prototype=t.prototype,e.prototype=new i,e.__super__=t.prototype,e},s.Decorate=function(s,i){var e=c(i),t=c(s);function r(){var e=Array.prototype.unshift,t=i.prototype.constructor.length,n=s.prototype.constructor;0<t&&(e.call(arguments,s.prototype.constructor),n=i.prototype.constructor),n.apply(this,arguments)}i.displayName=s.displayName,r.prototype=new function(){this.constructor=r};for(var n=0;n<t.length;n++){var o=t[n];r.prototype[o]=s.prototype[o]}for(var a=0;a<e.length;a++){var l=e[a];r.prototype[l]=function(e){var t=function(){};e in r.prototype&&(t=r.prototype[e]);var n=i.prototype[e];return function(){return Array.prototype.unshift.call(arguments,t),n.apply(this,arguments)}}(l)}return r};function e(){this.listeners={}}e.prototype.on=function(e,t){this.listeners=this.listeners||{},e in this.listeners?this.listeners[e].push(t):this.listeners[e]=[t]},e.prototype.trigger=function(e){var t=Array.prototype.slice,n=t.call(arguments,1);this.listeners=this.listeners||{},0===(n=null==n?[]:n).length&&n.push({}),(n[0]._type=e)in this.listeners&&this.invoke(this.listeners[e],t.call(arguments,1)),"*"in this.listeners&&this.invoke(this.listeners["*"],arguments)},e.prototype.invoke=function(e,t){for(var n=0,s=e.length;n<s;n++)e[n].apply(this,t)},s.Observable=e,s.generateChars=function(e){for(var t="",n=0;n<e;n++)t+=Math.floor(36*Math.random()).toString(36);return t},s.bind=function(e,t){return function(){e.apply(t,arguments)}},s._convertData=function(e){for(var t in e){var n=t.split("-"),s=e;if(1!==n.length){for(var i=0;i<n.length;i++){var r=n[i];(r=r.substring(0,1).toLowerCase()+r.substring(1))in s||(s[r]={}),i==n.length-1&&(s[r]=e[t]),s=s[r]}delete e[t]}}return e},s.hasScroll=function(e,t){var n=r(t),s=t.style.overflowX,i=t.style.overflowY;return(s!==i||"hidden"!==i&&"visible"!==i)&&("scroll"===s||"scroll"===i||(n.innerHeight()<t.scrollHeight||n.innerWidth()<t.scrollWidth))},s.escapeMarkup=function(e){var t={"\\":"&#92;","&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#47;"};return"string"!=typeof e?e:String(e).replace(/[&<>"'\/\\]/g,function(e){return t[e]})},s.__cache={};var n=0;return s.GetUniqueElementId=function(e){var t=e.getAttribute("data-select2-id");return null!=t||(t=e.id?"select2-data-"+e.id:"select2-data-"+(++n).toString()+"-"+s.generateChars(4),e.setAttribute("data-select2-id",t)),t},s.StoreData=function(e,t,n){e=s.GetUniqueElementId(e);s.__cache[e]||(s.__cache[e]={}),s.__cache[e][t]=n},s.GetData=function(e,t){var n=s.GetUniqueElementId(e);return t?s.__cache[n]&&null!=s.__cache[n][t]?s.__cache[n][t]:r(e).data(t):s.__cache[n]},s.RemoveData=function(e){var t=s.GetUniqueElementId(e);null!=s.__cache[t]&&delete s.__cache[t],e.removeAttribute("data-select2-id")},s.copyNonInternalCssClasses=function(e,t){var n=(n=e.getAttribute("class").trim().split(/\s+/)).filter(function(e){return 0===e.indexOf("select2-")}),t=(t=t.getAttribute("class").trim().split(/\s+/)).filter(function(e){return 0!==e.indexOf("select2-")}),t=n.concat(t);e.setAttribute("class",t.join(" "))},s}),u.define("select2/results",["jquery","./utils"],function(d,p){function s(e,t,n){this.$element=e,this.data=n,this.options=t,s.__super__.constructor.call(this)}return p.Extend(s,p.Observable),s.prototype.render=function(){var e=d('<ul class="select2-results__options" role="listbox"></ul>');return this.options.get("multiple")&&e.attr("aria-multiselectable","true"),this.$results=e},s.prototype.clear=function(){this.$results.empty()},s.prototype.displayMessage=function(e){var t=this.options.get("escapeMarkup");this.clear(),this.hideLoading();var n=d('<li role="alert" aria-live="assertive" class="select2-results__option"></li>'),s=this.options.get("translations").get(e.message);n.append(t(s(e.args))),n[0].className+=" select2-results__message",this.$results.append(n)},s.prototype.hideMessages=function(){this.$results.find(".select2-results__message").remove()},s.prototype.append=function(e){this.hideLoading();var t=[];if(null!=e.results&&0!==e.results.length){e.results=this.sort(e.results);for(var n=0;n<e.results.length;n++){var s=e.results[n],s=this.option(s);t.push(s)}this.$results.append(t)}else 0===this.$results.children().length&&this.trigger("results:message",{message:"noResults"})},s.prototype.position=function(e,t){t.find(".select2-results").append(e)},s.prototype.sort=function(e){return this.options.get("sorter")(e)},s.prototype.highlightFirstItem=function(){var e=this.$results.find(".select2-results__option--selectable"),t=e.filter(".select2-results__option--selected");(0<t.length?t:e).first().trigger("mouseenter"),this.ensureHighlightVisible()},s.prototype.setClasses=function(){var t=this;this.data.current(function(e){var s=e.map(function(e){return e.id.toString()});t.$results.find(".select2-results__option--selectable").each(function(){var e=d(this),t=p.GetData(this,"data"),n=""+t.id;null!=t.element&&t.element.selected||null==t.element&&-1<s.indexOf(n)?(this.classList.add("select2-results__option--selected"),e.attr("aria-selected","true")):(this.classList.remove("select2-results__option--selected"),e.attr("aria-selected","false"))})})},s.prototype.showLoading=function(e){this.hideLoading();e={disabled:!0,loading:!0,text:this.options.get("translations").get("searching")(e)},e=this.option(e);e.className+=" loading-results",this.$results.prepend(e)},s.prototype.hideLoading=function(){this.$results.find(".loading-results").remove()},s.prototype.option=function(e){var t=document.createElement("li");t.classList.add("select2-results__option"),t.classList.add("select2-results__option--selectable");var n,s={role:"option"},i=window.Element.prototype.matches||window.Element.prototype.msMatchesSelector||window.Element.prototype.webkitMatchesSelector;for(n in(null!=e.element&&i.call(e.element,":disabled")||null==e.element&&e.disabled)&&(s["aria-disabled"]="true",t.classList.remove("select2-results__option--selectable"),t.classList.add("select2-results__option--disabled")),null==e.id&&t.classList.remove("select2-results__option--selectable"),null!=e._resultId&&(t.id=e._resultId),e.title&&(t.title=e.title),e.children&&(s.role="group",s["aria-label"]=e.text,t.classList.remove("select2-results__option--selectable"),t.classList.add("select2-results__option--group")),s){var r=s[n];t.setAttribute(n,r)}if(e.children){var o=d(t),a=document.createElement("strong");a.className="select2-results__group",this.template(e,a);for(var l=[],c=0;c<e.children.length;c++){var u=e.children[c],u=this.option(u);l.push(u)}i=d("<ul></ul>",{class:"select2-results__options select2-results__options--nested",role:"none"});i.append(l),o.append(a),o.append(i)}else this.template(e,t);return p.StoreData(t,"data",e),t},s.prototype.bind=function(t,e){var i=this,n=t.id+"-results";this.$results.attr("id",n),t.on("results:all",function(e){i.clear(),i.append(e.data),t.isOpen()&&(i.setClasses(),i.highlightFirstItem())}),t.on("results:append",function(e){i.append(e.data),t.isOpen()&&i.setClasses()}),t.on("query",function(e){i.hideMessages(),i.showLoading(e)}),t.on("select",function(){t.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())}),t.on("unselect",function(){t.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())}),t.on("open",function(){i.$results.attr("aria-expanded","true"),i.$results.attr("aria-hidden","false"),i.setClasses(),i.ensureHighlightVisible()}),t.on("close",function(){i.$results.attr("aria-expanded","false"),i.$results.attr("aria-hidden","true"),i.$results.removeAttr("aria-activedescendant")}),t.on("results:toggle",function(){var e=i.getHighlightedResults();0!==e.length&&e.trigger("mouseup")}),t.on("results:select",function(){var e,t=i.getHighlightedResults();0!==t.length&&(e=p.GetData(t[0],"data"),t.hasClass("select2-results__option--selected")?i.trigger("close",{}):i.trigger("select",{data:e}))}),t.on("results:previous",function(){var e,t=i.getHighlightedResults(),n=i.$results.find(".select2-results__option--selectable"),s=n.index(t);s<=0||(e=s-1,0===t.length&&(e=0),(s=n.eq(e)).trigger("mouseenter"),t=i.$results.offset().top,n=s.offset().top,s=i.$results.scrollTop()+(n-t),0===e?i.$results.scrollTop(0):n-t<0&&i.$results.scrollTop(s))}),t.on("results:next",function(){var e,t=i.getHighlightedResults(),n=i.$results.find(".select2-results__option--selectable"),s=n.index(t)+1;s>=n.length||((e=n.eq(s)).trigger("mouseenter"),t=i.$results.offset().top+i.$results.outerHeight(!1),n=e.offset().top+e.outerHeight(!1),e=i.$results.scrollTop()+n-t,0===s?i.$results.scrollTop(0):t<n&&i.$results.scrollTop(e))}),t.on("results:focus",function(e){e.element[0].classList.add("select2-results__option--highlighted"),e.element[0].setAttribute("aria-selected","true")}),t.on("results:message",function(e){i.displayMessage(e)}),d.fn.mousewheel&&this.$results.on("mousewheel",function(e){var t=i.$results.scrollTop(),n=i.$results.get(0).scrollHeight-t+e.deltaY,t=0<e.deltaY&&t-e.deltaY<=0,n=e.deltaY<0&&n<=i.$results.height();t?(i.$results.scrollTop(0),e.preventDefault(),e.stopPropagation()):n&&(i.$results.scrollTop(i.$results.get(0).scrollHeight-i.$results.height()),e.preventDefault(),e.stopPropagation())}),this.$results.on("mouseup",".select2-results__option--selectable",function(e){var t=d(this),n=p.GetData(this,"data");t.hasClass("select2-results__option--selected")?i.options.get("multiple")?i.trigger("unselect",{originalEvent:e,data:n}):i.trigger("close",{}):i.trigger("select",{originalEvent:e,data:n})}),this.$results.on("mouseenter",".select2-results__option--selectable",function(e){var t=p.GetData(this,"data");i.getHighlightedResults().removeClass("select2-results__option--highlighted").attr("aria-selected","false"),i.trigger("results:focus",{data:t,element:d(this)})})},s.prototype.getHighlightedResults=function(){return this.$results.find(".select2-results__option--highlighted")},s.prototype.destroy=function(){this.$results.remove()},s.prototype.ensureHighlightVisible=function(){var e,t,n,s,i=this.getHighlightedResults();0!==i.length&&(e=this.$results.find(".select2-results__option--selectable").index(i),s=this.$results.offset().top,t=i.offset().top,n=this.$results.scrollTop()+(t-s),s=t-s,n-=2*i.outerHeight(!1),e<=2?this.$results.scrollTop(0):(s>this.$results.outerHeight()||s<0)&&this.$results.scrollTop(n))},s.prototype.template=function(e,t){var n=this.options.get("templateResult"),s=this.options.get("escapeMarkup"),e=n(e,t);null==e?t.style.display="none":"string"==typeof e?t.innerHTML=s(e):d(t).append(e)},s}),u.define("select2/keys",[],function(){return{BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46}}),u.define("select2/selection/base",["jquery","../utils","../keys"],function(n,s,i){function r(e,t){this.$element=e,this.options=t,r.__super__.constructor.call(this)}return s.Extend(r,s.Observable),r.prototype.render=function(){var e=n('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');return this._tabindex=0,null!=s.GetData(this.$element[0],"old-tabindex")?this._tabindex=s.GetData(this.$element[0],"old-tabindex"):null!=this.$element.attr("tabindex")&&(this._tabindex=this.$element.attr("tabindex")),e.attr("title",this.$element.attr("title")),e.attr("tabindex",this._tabindex),e.attr("aria-disabled","false"),this.$selection=e},r.prototype.bind=function(e,t){var n=this,s=e.id+"-results";this.container=e,this.$selection.on("focus",function(e){n.trigger("focus",e)}),this.$selection.on("blur",function(e){n._handleBlur(e)}),this.$selection.on("keydown",function(e){n.trigger("keypress",e),e.which===i.SPACE&&e.preventDefault()}),e.on("results:focus",function(e){n.$selection.attr("aria-activedescendant",e.data._resultId)}),e.on("selection:update",function(e){n.update(e.data)}),e.on("open",function(){n.$selection.attr("aria-expanded","true"),n.$selection.attr("aria-owns",s),n._attachCloseHandler(e)}),e.on("close",function(){n.$selection.attr("aria-expanded","false"),n.$selection.removeAttr("aria-activedescendant"),n.$selection.removeAttr("aria-owns"),n.$selection.trigger("focus"),n._detachCloseHandler(e)}),e.on("enable",function(){n.$selection.attr("tabindex",n._tabindex),n.$selection.attr("aria-disabled","false")}),e.on("disable",function(){n.$selection.attr("tabindex","-1"),n.$selection.attr("aria-disabled","true")})},r.prototype._handleBlur=function(e){var t=this;window.setTimeout(function(){document.activeElement==t.$selection[0]||n.contains(t.$selection[0],document.activeElement)||t.trigger("blur",e)},1)},r.prototype._attachCloseHandler=function(e){n(document.body).on("mousedown.select2."+e.id,function(e){var t=n(e.target).closest(".select2");n(".select2.select2-container--open").each(function(){this!=t[0]&&s.GetData(this,"element").select2("close")})})},r.prototype._detachCloseHandler=function(e){n(document.body).off("mousedown.select2."+e.id)},r.prototype.position=function(e,t){t.find(".selection").append(e)},r.prototype.destroy=function(){this._detachCloseHandler(this.container)},r.prototype.update=function(e){throw new Error("The `update` method must be defined in child classes.")},r.prototype.isEnabled=function(){return!this.isDisabled()},r.prototype.isDisabled=function(){return this.options.get("disabled")},r}),u.define("select2/selection/single",["jquery","./base","../utils","../keys"],function(e,t,n,s){function i(){i.__super__.constructor.apply(this,arguments)}return n.Extend(i,t),i.prototype.render=function(){var e=i.__super__.render.call(this);return e[0].classList.add("select2-selection--single"),e.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'),e},i.prototype.bind=function(t,e){var n=this;i.__super__.bind.apply(this,arguments);var s=t.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",s).attr("role","textbox").attr("aria-readonly","true"),this.$selection.attr("aria-labelledby",s),this.$selection.attr("aria-controls",s),this.$selection.on("mousedown",function(e){1===e.which&&n.trigger("toggle",{originalEvent:e})}),this.$selection.on("focus",function(e){}),this.$selection.on("blur",function(e){}),t.on("focus",function(e){t.isOpen()||n.$selection.trigger("focus")})},i.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},i.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},i.prototype.selectionContainer=function(){return e("<span></span>")},i.prototype.update=function(e){var t,n;0!==e.length?(n=e[0],t=this.$selection.find(".select2-selection__rendered"),e=this.display(n,t),t.empty().append(e),(n=n.title||n.text)?t.attr("title",n):t.removeAttr("title")):this.clear()},i}),u.define("select2/selection/multiple",["jquery","./base","../utils"],function(i,e,c){function r(e,t){r.__super__.constructor.apply(this,arguments)}return c.Extend(r,e),r.prototype.render=function(){var e=r.__super__.render.call(this);return e[0].classList.add("select2-selection--multiple"),e.html('<ul class="select2-selection__rendered"></ul>'),e},r.prototype.bind=function(e,t){var n=this;r.__super__.bind.apply(this,arguments);var s=e.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",s),this.$selection.on("click",function(e){n.trigger("toggle",{originalEvent:e})}),this.$selection.on("click",".select2-selection__choice__remove",function(e){var t;n.isDisabled()||(t=i(this).parent(),t=c.GetData(t[0],"data"),n.trigger("unselect",{originalEvent:e,data:t}))}),this.$selection.on("keydown",".select2-selection__choice__remove",function(e){n.isDisabled()||e.stopPropagation()})},r.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},r.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},r.prototype.selectionContainer=function(){return i('<li class="select2-selection__choice"><button type="button" class="select2-selection__choice__remove" tabindex="-1"><span aria-hidden="true">&times;</span></button><span class="select2-selection__choice__display"></span></li>')},r.prototype.update=function(e){if(this.clear(),0!==e.length){for(var t=[],n=this.$selection.find(".select2-selection__rendered").attr("id")+"-choice-",s=0;s<e.length;s++){var i=e[s],r=this.selectionContainer(),o=this.display(i,r),a=n+c.generateChars(4)+"-";i.id?a+=i.id:a+=c.generateChars(4),r.find(".select2-selection__choice__display").append(o).attr("id",a);var l=i.title||i.text;l&&r.attr("title",l);o=this.options.get("translations").get("removeItem"),l=r.find(".select2-selection__choice__remove");l.attr("title",o()),l.attr("aria-label",o()),l.attr("aria-describedby",a),c.StoreData(r[0],"data",i),t.push(r)}this.$selection.find(".select2-selection__rendered").append(t)}},r}),u.define("select2/selection/placeholder",[],function(){function e(e,t,n){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n)}return e.prototype.normalizePlaceholder=function(e,t){return t="string"==typeof t?{id:"",text:t}:t},e.prototype.createPlaceholder=function(e,t){var n=this.selectionContainer();n.html(this.display(t)),n[0].classList.add("select2-selection__placeholder"),n[0].classList.remove("select2-selection__choice");t=t.title||t.text||n.text();return this.$selection.find(".select2-selection__rendered").attr("title",t),n},e.prototype.update=function(e,t){var n=1==t.length&&t[0].id!=this.placeholder.id;if(1<t.length||n)return e.call(this,t);this.clear();t=this.createPlaceholder(this.placeholder);this.$selection.find(".select2-selection__rendered").append(t)},e}),u.define("select2/selection/allowClear",["jquery","../keys","../utils"],function(i,s,a){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),null==this.placeholder&&this.options.get("debug")&&window.console&&console.error&&console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."),this.$selection.on("mousedown",".select2-selection__clear",function(e){s._handleClear(e)}),t.on("keypress",function(e){s._handleKeyboardClear(e,t)})},e.prototype._handleClear=function(e,t){if(!this.isDisabled()){var n=this.$selection.find(".select2-selection__clear");if(0!==n.length){t.stopPropagation();var s=a.GetData(n[0],"data"),i=this.$element.val();this.$element.val(this.placeholder.id);var r={data:s};if(this.trigger("clear",r),r.prevented)this.$element.val(i);else{for(var o=0;o<s.length;o++)if(r={data:s[o]},this.trigger("unselect",r),r.prevented)return void this.$element.val(i);this.$element.trigger("input").trigger("change"),this.trigger("toggle",{})}}}},e.prototype._handleKeyboardClear=function(e,t,n){n.isOpen()||t.which!=s.DELETE&&t.which!=s.BACKSPACE||this._handleClear(t)},e.prototype.update=function(e,t){var n,s;e.call(this,t),this.$selection.find(".select2-selection__clear").remove(),this.$selection[0].classList.remove("select2-selection--clearable"),0<this.$selection.find(".select2-selection__placeholder").length||0===t.length||(n=this.$selection.find(".select2-selection__rendered").attr("id"),s=this.options.get("translations").get("removeAllItems"),(e=i('<button type="button" class="select2-selection__clear" tabindex="-1"><span aria-hidden="true">&times;</span></button>')).attr("title",s()),e.attr("aria-label",s()),e.attr("aria-describedby",n),a.StoreData(e[0],"data",t),this.$selection.prepend(e),this.$selection[0].classList.add("select2-selection--clearable"))},e}),u.define("select2/selection/search",["jquery","../utils","../keys"],function(s,a,l){function e(e,t,n){e.call(this,t,n)}return e.prototype.render=function(e){var t=this.options.get("translations").get("search"),n=s('<span class="select2-search select2-search--inline"><textarea class="select2-search__field" type="search" tabindex="-1" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" ></textarea></span>');this.$searchContainer=n,this.$search=n.find("textarea"),this.$search.prop("autocomplete",this.options.get("autocomplete")),this.$search.attr("aria-label",t());e=e.call(this);return this._transferTabIndex(),e.append(this.$searchContainer),e},e.prototype.bind=function(e,t,n){var s=this,i=t.id+"-results",r=t.id+"-container";e.call(this,t,n),s.$search.attr("aria-describedby",r),t.on("open",function(){s.$search.attr("aria-controls",i),s.$search.trigger("focus")}),t.on("close",function(){s.$search.val(""),s.resizeSearch(),s.$search.removeAttr("aria-controls"),s.$search.removeAttr("aria-activedescendant"),s.$search.trigger("focus")}),t.on("enable",function(){s.$search.prop("disabled",!1),s._transferTabIndex()}),t.on("disable",function(){s.$search.prop("disabled",!0)}),t.on("focus",function(e){s.$search.trigger("focus")}),t.on("results:focus",function(e){e.data._resultId?s.$search.attr("aria-activedescendant",e.data._resultId):s.$search.removeAttr("aria-activedescendant")}),this.$selection.on("focusin",".select2-search--inline",function(e){s.trigger("focus",e)}),this.$selection.on("focusout",".select2-search--inline",function(e){s._handleBlur(e)}),this.$selection.on("keydown",".select2-search--inline",function(e){var t;e.stopPropagation(),s.trigger("keypress",e),s._keyUpPrevented=e.isDefaultPrevented(),e.which!==l.BACKSPACE||""!==s.$search.val()||0<(t=s.$selection.find(".select2-selection__choice").last()).length&&(t=a.GetData(t[0],"data"),s.searchRemoveChoice(t),e.preventDefault())}),this.$selection.on("click",".select2-search--inline",function(e){s.$search.val()&&e.stopPropagation()});var t=document.documentMode,o=t&&t<=11;this.$selection.on("input.searchcheck",".select2-search--inline",function(e){o?s.$selection.off("input.search input.searchcheck"):s.$selection.off("keyup.search")}),this.$selection.on("keyup.search input.search",".select2-search--inline",function(e){var t;o&&"input"===e.type?s.$selection.off("input.search input.searchcheck"):(t=e.which)!=l.SHIFT&&t!=l.CTRL&&t!=l.ALT&&t!=l.TAB&&s.handleSearch(e)})},e.prototype._transferTabIndex=function(e){this.$search.attr("tabindex",this.$selection.attr("tabindex")),this.$selection.attr("tabindex","-1")},e.prototype.createPlaceholder=function(e,t){this.$search.attr("placeholder",t.text)},e.prototype.update=function(e,t){var n=this.$search[0]==document.activeElement;this.$search.attr("placeholder",""),e.call(this,t),this.resizeSearch(),n&&this.$search.trigger("focus")},e.prototype.handleSearch=function(){var e;this.resizeSearch(),this._keyUpPrevented||(e=this.$search.val(),this.trigger("query",{term:e})),this._keyUpPrevented=!1},e.prototype.searchRemoveChoice=function(e,t){this.trigger("unselect",{data:t}),this.$search.val(t.text),this.handleSearch()},e.prototype.resizeSearch=function(){this.$search.css("width","25px");var e="100%";""===this.$search.attr("placeholder")&&(e=.75*(this.$search.val().length+1)+"em"),this.$search.css("width",e)},e}),u.define("select2/selection/selectionCss",["../utils"],function(n){function e(){}return e.prototype.render=function(e){var t=e.call(this),e=this.options.get("selectionCssClass")||"";return-1!==e.indexOf(":all:")&&(e=e.replace(":all:",""),n.copyNonInternalCssClasses(t[0],this.$element[0])),t.addClass(e),t},e}),u.define("select2/selection/eventRelay",["jquery"],function(o){function e(){}return e.prototype.bind=function(e,t,n){var s=this,i=["open","opening","close","closing","select","selecting","unselect","unselecting","clear","clearing"],r=["opening","closing","selecting","unselecting","clearing"];e.call(this,t,n),t.on("*",function(e,t){var n;-1!==i.indexOf(e)&&(t=t||{},n=o.Event("select2:"+e,{params:t}),s.$element.trigger(n),-1!==r.indexOf(e)&&(t.prevented=n.isDefaultPrevented()))})},e}),u.define("select2/translation",["jquery","require"],function(t,n){function s(e){this.dict=e||{}}return s.prototype.all=function(){return this.dict},s.prototype.get=function(e){return this.dict[e]},s.prototype.extend=function(e){this.dict=t.extend({},e.all(),this.dict)},s._cache={},s.loadPath=function(e){var t;return e in s._cache||(t=n(e),s._cache[e]=t),new s(s._cache[e])},s}),u.define("select2/diacritics",[],function(){return{"Ⓐ":"A","Ａ":"A","À":"A","Á":"A","Â":"A","Ầ":"A","Ấ":"A","Ẫ":"A","Ẩ":"A","Ã":"A","Ā":"A","Ă":"A","Ằ":"A","Ắ":"A","Ẵ":"A","Ẳ":"A","Ȧ":"A","Ǡ":"A","Ä":"A","Ǟ":"A","Ả":"A","Å":"A","Ǻ":"A","Ǎ":"A","Ȁ":"A","Ȃ":"A","Ạ":"A","Ậ":"A","Ặ":"A","Ḁ":"A","Ą":"A","Ⱥ":"A","Ɐ":"A","Ꜳ":"AA","Æ":"AE","Ǽ":"AE","Ǣ":"AE","Ꜵ":"AO","Ꜷ":"AU","Ꜹ":"AV","Ꜻ":"AV","Ꜽ":"AY","Ⓑ":"B","Ｂ":"B","Ḃ":"B","Ḅ":"B","Ḇ":"B","Ƀ":"B","Ƃ":"B","Ɓ":"B","Ⓒ":"C","Ｃ":"C","Ć":"C","Ĉ":"C","Ċ":"C","Č":"C","Ç":"C","Ḉ":"C","Ƈ":"C","Ȼ":"C","Ꜿ":"C","Ⓓ":"D","Ｄ":"D","Ḋ":"D","Ď":"D","Ḍ":"D","Ḑ":"D","Ḓ":"D","Ḏ":"D","Đ":"D","Ƌ":"D","Ɗ":"D","Ɖ":"D","Ꝺ":"D","Ǳ":"DZ","Ǆ":"DZ","ǲ":"Dz","ǅ":"Dz","Ⓔ":"E","Ｅ":"E","È":"E","É":"E","Ê":"E","Ề":"E","Ế":"E","Ễ":"E","Ể":"E","Ẽ":"E","Ē":"E","Ḕ":"E","Ḗ":"E","Ĕ":"E","Ė":"E","Ë":"E","Ẻ":"E","Ě":"E","Ȅ":"E","Ȇ":"E","Ẹ":"E","Ệ":"E","Ȩ":"E","Ḝ":"E","Ę":"E","Ḙ":"E","Ḛ":"E","Ɛ":"E","Ǝ":"E","Ⓕ":"F","Ｆ":"F","Ḟ":"F","Ƒ":"F","Ꝼ":"F","Ⓖ":"G","Ｇ":"G","Ǵ":"G","Ĝ":"G","Ḡ":"G","Ğ":"G","Ġ":"G","Ǧ":"G","Ģ":"G","Ǥ":"G","Ɠ":"G","Ꞡ":"G","Ᵹ":"G","Ꝿ":"G","Ⓗ":"H","Ｈ":"H","Ĥ":"H","Ḣ":"H","Ḧ":"H","Ȟ":"H","Ḥ":"H","Ḩ":"H","Ḫ":"H","Ħ":"H","Ⱨ":"H","Ⱶ":"H","Ɥ":"H","Ⓘ":"I","Ｉ":"I","Ì":"I","Í":"I","Î":"I","Ĩ":"I","Ī":"I","Ĭ":"I","İ":"I","Ï":"I","Ḯ":"I","Ỉ":"I","Ǐ":"I","Ȉ":"I","Ȋ":"I","Ị":"I","Į":"I","Ḭ":"I","Ɨ":"I","Ⓙ":"J","Ｊ":"J","Ĵ":"J","Ɉ":"J","Ⓚ":"K","Ｋ":"K","Ḱ":"K","Ǩ":"K","Ḳ":"K","Ķ":"K","Ḵ":"K","Ƙ":"K","Ⱪ":"K","Ꝁ":"K","Ꝃ":"K","Ꝅ":"K","Ꞣ":"K","Ⓛ":"L","Ｌ":"L","Ŀ":"L","Ĺ":"L","Ľ":"L","Ḷ":"L","Ḹ":"L","Ļ":"L","Ḽ":"L","Ḻ":"L","Ł":"L","Ƚ":"L","Ɫ":"L","Ⱡ":"L","Ꝉ":"L","Ꝇ":"L","Ꞁ":"L","Ǉ":"LJ","ǈ":"Lj","Ⓜ":"M","Ｍ":"M","Ḿ":"M","Ṁ":"M","Ṃ":"M","Ɱ":"M","Ɯ":"M","Ⓝ":"N","Ｎ":"N","Ǹ":"N","Ń":"N","Ñ":"N","Ṅ":"N","Ň":"N","Ṇ":"N","Ņ":"N","Ṋ":"N","Ṉ":"N","Ƞ":"N","Ɲ":"N","Ꞑ":"N","Ꞥ":"N","Ǌ":"NJ","ǋ":"Nj","Ⓞ":"O","Ｏ":"O","Ò":"O","Ó":"O","Ô":"O","Ồ":"O","Ố":"O","Ỗ":"O","Ổ":"O","Õ":"O","Ṍ":"O","Ȭ":"O","Ṏ":"O","Ō":"O","Ṑ":"O","Ṓ":"O","Ŏ":"O","Ȯ":"O","Ȱ":"O","Ö":"O","Ȫ":"O","Ỏ":"O","Ő":"O","Ǒ":"O","Ȍ":"O","Ȏ":"O","Ơ":"O","Ờ":"O","Ớ":"O","Ỡ":"O","Ở":"O","Ợ":"O","Ọ":"O","Ộ":"O","Ǫ":"O","Ǭ":"O","Ø":"O","Ǿ":"O","Ɔ":"O","Ɵ":"O","Ꝋ":"O","Ꝍ":"O","Œ":"OE","Ƣ":"OI","Ꝏ":"OO","Ȣ":"OU","Ⓟ":"P","Ｐ":"P","Ṕ":"P","Ṗ":"P","Ƥ":"P","Ᵽ":"P","Ꝑ":"P","Ꝓ":"P","Ꝕ":"P","Ⓠ":"Q","Ｑ":"Q","Ꝗ":"Q","Ꝙ":"Q","Ɋ":"Q","Ⓡ":"R","Ｒ":"R","Ŕ":"R","Ṙ":"R","Ř":"R","Ȑ":"R","Ȓ":"R","Ṛ":"R","Ṝ":"R","Ŗ":"R","Ṟ":"R","Ɍ":"R","Ɽ":"R","Ꝛ":"R","Ꞧ":"R","Ꞃ":"R","Ⓢ":"S","Ｓ":"S","ẞ":"S","Ś":"S","Ṥ":"S","Ŝ":"S","Ṡ":"S","Š":"S","Ṧ":"S","Ṣ":"S","Ṩ":"S","Ș":"S","Ş":"S","Ȿ":"S","Ꞩ":"S","Ꞅ":"S","Ⓣ":"T","Ｔ":"T","Ṫ":"T","Ť":"T","Ṭ":"T","Ț":"T","Ţ":"T","Ṱ":"T","Ṯ":"T","Ŧ":"T","Ƭ":"T","Ʈ":"T","Ⱦ":"T","Ꞇ":"T","Ꜩ":"TZ","Ⓤ":"U","Ｕ":"U","Ù":"U","Ú":"U","Û":"U","Ũ":"U","Ṹ":"U","Ū":"U","Ṻ":"U","Ŭ":"U","Ü":"U","Ǜ":"U","Ǘ":"U","Ǖ":"U","Ǚ":"U","Ủ":"U","Ů":"U","Ű":"U","Ǔ":"U","Ȕ":"U","Ȗ":"U","Ư":"U","Ừ":"U","Ứ":"U","Ữ":"U","Ử":"U","Ự":"U","Ụ":"U","Ṳ":"U","Ų":"U","Ṷ":"U","Ṵ":"U","Ʉ":"U","Ⓥ":"V","Ｖ":"V","Ṽ":"V","Ṿ":"V","Ʋ":"V","Ꝟ":"V","Ʌ":"V","Ꝡ":"VY","Ⓦ":"W","Ｗ":"W","Ẁ":"W","Ẃ":"W","Ŵ":"W","Ẇ":"W","Ẅ":"W","Ẉ":"W","Ⱳ":"W","Ⓧ":"X","Ｘ":"X","Ẋ":"X","Ẍ":"X","Ⓨ":"Y","Ｙ":"Y","Ỳ":"Y","Ý":"Y","Ŷ":"Y","Ỹ":"Y","Ȳ":"Y","Ẏ":"Y","Ÿ":"Y","Ỷ":"Y","Ỵ":"Y","Ƴ":"Y","Ɏ":"Y","Ỿ":"Y","Ⓩ":"Z","Ｚ":"Z","Ź":"Z","Ẑ":"Z","Ż":"Z","Ž":"Z","Ẓ":"Z","Ẕ":"Z","Ƶ":"Z","Ȥ":"Z","Ɀ":"Z","Ⱬ":"Z","Ꝣ":"Z","ⓐ":"a","ａ":"a","ẚ":"a","à":"a","á":"a","â":"a","ầ":"a","ấ":"a","ẫ":"a","ẩ":"a","ã":"a","ā":"a","ă":"a","ằ":"a","ắ":"a","ẵ":"a","ẳ":"a","ȧ":"a","ǡ":"a","ä":"a","ǟ":"a","ả":"a","å":"a","ǻ":"a","ǎ":"a","ȁ":"a","ȃ":"a","ạ":"a","ậ":"a","ặ":"a","ḁ":"a","ą":"a","ⱥ":"a","ɐ":"a","ꜳ":"aa","æ":"ae","ǽ":"ae","ǣ":"ae","ꜵ":"ao","ꜷ":"au","ꜹ":"av","ꜻ":"av","ꜽ":"ay","ⓑ":"b","ｂ":"b","ḃ":"b","ḅ":"b","ḇ":"b","ƀ":"b","ƃ":"b","ɓ":"b","ⓒ":"c","ｃ":"c","ć":"c","ĉ":"c","ċ":"c","č":"c","ç":"c","ḉ":"c","ƈ":"c","ȼ":"c","ꜿ":"c","ↄ":"c","ⓓ":"d","ｄ":"d","ḋ":"d","ď":"d","ḍ":"d","ḑ":"d","ḓ":"d","ḏ":"d","đ":"d","ƌ":"d","ɖ":"d","ɗ":"d","ꝺ":"d","ǳ":"dz","ǆ":"dz","ⓔ":"e","ｅ":"e","è":"e","é":"e","ê":"e","ề":"e","ế":"e","ễ":"e","ể":"e","ẽ":"e","ē":"e","ḕ":"e","ḗ":"e","ĕ":"e","ė":"e","ë":"e","ẻ":"e","ě":"e","ȅ":"e","ȇ":"e","ẹ":"e","ệ":"e","ȩ":"e","ḝ":"e","ę":"e","ḙ":"e","ḛ":"e","ɇ":"e","ɛ":"e","ǝ":"e","ⓕ":"f","ｆ":"f","ḟ":"f","ƒ":"f","ꝼ":"f","ⓖ":"g","ｇ":"g","ǵ":"g","ĝ":"g","ḡ":"g","ğ":"g","ġ":"g","ǧ":"g","ģ":"g","ǥ":"g","ɠ":"g","ꞡ":"g","ᵹ":"g","ꝿ":"g","ⓗ":"h","ｈ":"h","ĥ":"h","ḣ":"h","ḧ":"h","ȟ":"h","ḥ":"h","ḩ":"h","ḫ":"h","ẖ":"h","ħ":"h","ⱨ":"h","ⱶ":"h","ɥ":"h","ƕ":"hv","ⓘ":"i","ｉ":"i","ì":"i","í":"i","î":"i","ĩ":"i","ī":"i","ĭ":"i","ï":"i","ḯ":"i","ỉ":"i","ǐ":"i","ȉ":"i","ȋ":"i","ị":"i","į":"i","ḭ":"i","ɨ":"i","ı":"i","ⓙ":"j","ｊ":"j","ĵ":"j","ǰ":"j","ɉ":"j","ⓚ":"k","ｋ":"k","ḱ":"k","ǩ":"k","ḳ":"k","ķ":"k","ḵ":"k","ƙ":"k","ⱪ":"k","ꝁ":"k","ꝃ":"k","ꝅ":"k","ꞣ":"k","ⓛ":"l","ｌ":"l","ŀ":"l","ĺ":"l","ľ":"l","ḷ":"l","ḹ":"l","ļ":"l","ḽ":"l","ḻ":"l","ſ":"l","ł":"l","ƚ":"l","ɫ":"l","ⱡ":"l","ꝉ":"l","ꞁ":"l","ꝇ":"l","ǉ":"lj","ⓜ":"m","ｍ":"m","ḿ":"m","ṁ":"m","ṃ":"m","ɱ":"m","ɯ":"m","ⓝ":"n","ｎ":"n","ǹ":"n","ń":"n","ñ":"n","ṅ":"n","ň":"n","ṇ":"n","ņ":"n","ṋ":"n","ṉ":"n","ƞ":"n","ɲ":"n","ŉ":"n","ꞑ":"n","ꞥ":"n","ǌ":"nj","ⓞ":"o","ｏ":"o","ò":"o","ó":"o","ô":"o","ồ":"o","ố":"o","ỗ":"o","ổ":"o","õ":"o","ṍ":"o","ȭ":"o","ṏ":"o","ō":"o","ṑ":"o","ṓ":"o","ŏ":"o","ȯ":"o","ȱ":"o","ö":"o","ȫ":"o","ỏ":"o","ő":"o","ǒ":"o","ȍ":"o","ȏ":"o","ơ":"o","ờ":"o","ớ":"o","ỡ":"o","ở":"o","ợ":"o","ọ":"o","ộ":"o","ǫ":"o","ǭ":"o","ø":"o","ǿ":"o","ɔ":"o","ꝋ":"o","ꝍ":"o","ɵ":"o","œ":"oe","ƣ":"oi","ȣ":"ou","ꝏ":"oo","ⓟ":"p","ｐ":"p","ṕ":"p","ṗ":"p","ƥ":"p","ᵽ":"p","ꝑ":"p","ꝓ":"p","ꝕ":"p","ⓠ":"q","ｑ":"q","ɋ":"q","ꝗ":"q","ꝙ":"q","ⓡ":"r","ｒ":"r","ŕ":"r","ṙ":"r","ř":"r","ȑ":"r","ȓ":"r","ṛ":"r","ṝ":"r","ŗ":"r","ṟ":"r","ɍ":"r","ɽ":"r","ꝛ":"r","ꞧ":"r","ꞃ":"r","ⓢ":"s","ｓ":"s","ß":"s","ś":"s","ṥ":"s","ŝ":"s","ṡ":"s","š":"s","ṧ":"s","ṣ":"s","ṩ":"s","ș":"s","ş":"s","ȿ":"s","ꞩ":"s","ꞅ":"s","ẛ":"s","ⓣ":"t","ｔ":"t","ṫ":"t","ẗ":"t","ť":"t","ṭ":"t","ț":"t","ţ":"t","ṱ":"t","ṯ":"t","ŧ":"t","ƭ":"t","ʈ":"t","ⱦ":"t","ꞇ":"t","ꜩ":"tz","ⓤ":"u","ｕ":"u","ù":"u","ú":"u","û":"u","ũ":"u","ṹ":"u","ū":"u","ṻ":"u","ŭ":"u","ü":"u","ǜ":"u","ǘ":"u","ǖ":"u","ǚ":"u","ủ":"u","ů":"u","ű":"u","ǔ":"u","ȕ":"u","ȗ":"u","ư":"u","ừ":"u","ứ":"u","ữ":"u","ử":"u","ự":"u","ụ":"u","ṳ":"u","ų":"u","ṷ":"u","ṵ":"u","ʉ":"u","ⓥ":"v","ｖ":"v","ṽ":"v","ṿ":"v","ʋ":"v","ꝟ":"v","ʌ":"v","ꝡ":"vy","ⓦ":"w","ｗ":"w","ẁ":"w","ẃ":"w","ŵ":"w","ẇ":"w","ẅ":"w","ẘ":"w","ẉ":"w","ⱳ":"w","ⓧ":"x","ｘ":"x","ẋ":"x","ẍ":"x","ⓨ":"y","ｙ":"y","ỳ":"y","ý":"y","ŷ":"y","ỹ":"y","ȳ":"y","ẏ":"y","ÿ":"y","ỷ":"y","ẙ":"y","ỵ":"y","ƴ":"y","ɏ":"y","ỿ":"y","ⓩ":"z","ｚ":"z","ź":"z","ẑ":"z","ż":"z","ž":"z","ẓ":"z","ẕ":"z","ƶ":"z","ȥ":"z","ɀ":"z","ⱬ":"z","ꝣ":"z","Ά":"Α","Έ":"Ε","Ή":"Η","Ί":"Ι","Ϊ":"Ι","Ό":"Ο","Ύ":"Υ","Ϋ":"Υ","Ώ":"Ω","ά":"α","έ":"ε","ή":"η","ί":"ι","ϊ":"ι","ΐ":"ι","ό":"ο","ύ":"υ","ϋ":"υ","ΰ":"υ","ώ":"ω","ς":"σ","’":"'"}}),u.define("select2/data/base",["../utils"],function(n){function s(e,t){s.__super__.constructor.call(this)}return n.Extend(s,n.Observable),s.prototype.current=function(e){throw new Error("The `current` method must be defined in child classes.")},s.prototype.query=function(e,t){throw new Error("The `query` method must be defined in child classes.")},s.prototype.bind=function(e,t){},s.prototype.destroy=function(){},s.prototype.generateResultId=function(e,t){e=e.id+"-result-";return e+=n.generateChars(4),null!=t.id?e+="-"+t.id.toString():e+="-"+n.generateChars(4),e},s}),u.define("select2/data/select",["./base","../utils","jquery"],function(e,a,l){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return a.Extend(n,e),n.prototype.current=function(e){var t=this;e(Array.prototype.map.call(this.$element[0].querySelectorAll(":checked"),function(e){return t.item(l(e))}))},n.prototype.select=function(i){var e,r=this;if(i.selected=!0,null!=i.element&&"option"===i.element.tagName.toLowerCase())return i.element.selected=!0,void this.$element.trigger("input").trigger("change");this.$element.prop("multiple")?this.current(function(e){var t=[];(i=[i]).push.apply(i,e);for(var n=0;n<i.length;n++){var s=i[n].id;-1===t.indexOf(s)&&t.push(s)}r.$element.val(t),r.$element.trigger("input").trigger("change")}):(e=i.id,this.$element.val(e),this.$element.trigger("input").trigger("change"))},n.prototype.unselect=function(i){var r=this;if(this.$element.prop("multiple")){if(i.selected=!1,null!=i.element&&"option"===i.element.tagName.toLowerCase())return i.element.selected=!1,void this.$element.trigger("input").trigger("change");this.current(function(e){for(var t=[],n=0;n<e.length;n++){var s=e[n].id;s!==i.id&&-1===t.indexOf(s)&&t.push(s)}r.$element.val(t),r.$element.trigger("input").trigger("change")})}},n.prototype.bind=function(e,t){var n=this;(this.container=e).on("select",function(e){n.select(e.data)}),e.on("unselect",function(e){n.unselect(e.data)})},n.prototype.destroy=function(){this.$element.find("*").each(function(){a.RemoveData(this)})},n.prototype.query=function(t,e){var n=[],s=this;this.$element.children().each(function(){var e;"option"!==this.tagName.toLowerCase()&&"optgroup"!==this.tagName.toLowerCase()||(e=l(this),e=s.item(e),null!==(e=s.matches(t,e))&&n.push(e))}),e({results:n})},n.prototype.addOptions=function(e){this.$element.append(e)},n.prototype.option=function(e){var t;e.children?(t=document.createElement("optgroup")).label=e.text:void 0!==(t=document.createElement("option")).textContent?t.textContent=e.text:t.innerText=e.text,void 0!==e.id&&(t.value=e.id),e.disabled&&(t.disabled=!0),e.selected&&(t.selected=!0),e.title&&(t.title=e.title);e=this._normalizeItem(e);return e.element=t,a.StoreData(t,"data",e),l(t)},n.prototype.item=function(e){var t={};if(null!=(t=a.GetData(e[0],"data")))return t;var n=e[0];if("option"===n.tagName.toLowerCase())t={id:e.val(),text:e.text(),disabled:e.prop("disabled"),selected:e.prop("selected"),title:e.prop("title")};else if("optgroup"===n.tagName.toLowerCase()){t={text:e.prop("label"),children:[],title:e.prop("title")};for(var s=e.children("option"),i=[],r=0;r<s.length;r++){var o=l(s[r]),o=this.item(o);i.push(o)}t.children=i}return(t=this._normalizeItem(t)).element=e[0],a.StoreData(e[0],"data",t),t},n.prototype._normalizeItem=function(e){e!==Object(e)&&(e={id:e,text:e});return null!=(e=l.extend({},{text:""},e)).id&&(e.id=e.id.toString()),null!=e.text&&(e.text=e.text.toString()),null==e._resultId&&e.id&&null!=this.container&&(e._resultId=this.generateResultId(this.container,e)),l.extend({},{selected:!1,disabled:!1},e)},n.prototype.matches=function(e,t){return this.options.get("matcher")(e,t)},n}),u.define("select2/data/array",["./select","../utils","jquery"],function(e,t,c){function s(e,t){this._dataToConvert=t.get("data")||[],s.__super__.constructor.call(this,e,t)}return t.Extend(s,e),s.prototype.bind=function(e,t){s.__super__.bind.call(this,e,t),this.addOptions(this.convertToOptions(this._dataToConvert))},s.prototype.select=function(n){var e=this.$element.find("option").filter(function(e,t){return t.value==n.id.toString()});0===e.length&&(e=this.option(n),this.addOptions(e)),s.__super__.select.call(this,n)},s.prototype.convertToOptions=function(e){var t=this,n=this.$element.find("option"),s=n.map(function(){return t.item(c(this)).id}).get(),i=[];for(var r=0;r<e.length;r++){var o,a,l=this._normalizeItem(e[r]);0<=s.indexOf(l.id)?(o=n.filter(function(e){return function(){return c(this).val()==e.id}}(l)),a=this.item(o),a=c.extend(!0,{},l,a),a=this.option(a),o.replaceWith(a)):(a=this.option(l),l.children&&(l=this.convertToOptions(l.children),a.append(l)),i.push(a))}return i},s}),u.define("select2/data/ajax",["./array","../utils","jquery"],function(e,t,r){function n(e,t){this.ajaxOptions=this._applyDefaults(t.get("ajax")),null!=this.ajaxOptions.processResults&&(this.processResults=this.ajaxOptions.processResults),n.__super__.constructor.call(this,e,t)}return t.Extend(n,e),n.prototype._applyDefaults=function(e){var t={data:function(e){return r.extend({},e,{q:e.term})},transport:function(e,t,n){e=r.ajax(e);return e.then(t),e.fail(n),e}};return r.extend({},t,e,!0)},n.prototype.processResults=function(e){return e},n.prototype.query=function(t,n){var s=this;null!=this._request&&("function"==typeof this._request.abort&&this._request.abort(),this._request=null);var i=r.extend({type:"GET"},this.ajaxOptions);function e(){var e=i.transport(i,function(e){e=s.processResults(e,t);s.options.get("debug")&&window.console&&console.error&&(e&&e.results&&Array.isArray(e.results)||console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")),n(e)},function(){"status"in e&&(0===e.status||"0"===e.status)||s.trigger("results:message",{message:"errorLoading"})});s._request=e}"function"==typeof i.url&&(i.url=i.url.call(this.$element,t)),"function"==typeof i.data&&(i.data=i.data.call(this.$element,t)),this.ajaxOptions.delay&&null!=t.term?(this._queryTimeout&&window.clearTimeout(this._queryTimeout),this._queryTimeout=window.setTimeout(e,this.ajaxOptions.delay)):e()},n}),u.define("select2/data/tags",["jquery"],function(t){function e(e,t,n){var s=n.get("tags"),i=n.get("createTag");void 0!==i&&(this.createTag=i);i=n.get("insertTag");if(void 0!==i&&(this.insertTag=i),e.call(this,t,n),Array.isArray(s))for(var r=0;r<s.length;r++){var o=s[r],o=this._normalizeItem(o),o=this.option(o);this.$element.append(o)}}return e.prototype.query=function(e,c,u){var d=this;this._removeOldTags(),null!=c.term&&null==c.page?e.call(this,c,function e(t,n){for(var s=t.results,i=0;i<s.length;i++){var r=s[i],o=null!=r.children&&!e({results:r.children},!0);if((r.text||"").toUpperCase()===(c.term||"").toUpperCase()||o)return!n&&(t.data=s,void u(t))}if(n)return!0;var a,l=d.createTag(c);null!=l&&((a=d.option(l)).attr("data-select2-tag","true"),d.addOptions([a]),d.insertTag(s,l)),t.results=s,u(t)}):e.call(this,c,u)},e.prototype.createTag=function(e,t){if(null==t.term)return null;t=t.term.trim();return""===t?null:{id:t,text:t}},e.prototype.insertTag=function(e,t,n){t.unshift(n)},e.prototype._removeOldTags=function(e){this.$element.find("option[data-select2-tag]").each(function(){this.selected||t(this).remove()})},e}),u.define("select2/data/tokenizer",["jquery"],function(c){function e(e,t,n){var s=n.get("tokenizer");void 0!==s&&(this.tokenizer=s),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){e.call(this,t,n),this.$search=t.dropdown.$search||t.selection.$search||n.find(".select2-search__field")},e.prototype.query=function(e,t,n){var s=this;t.term=t.term||"";var i=this.tokenizer(t,this.options,function(e){var t,n=s._normalizeItem(e);s.$element.find("option").filter(function(){return c(this).val()===n.id}).length||((t=s.option(n)).attr("data-select2-tag",!0),s._removeOldTags(),s.addOptions([t])),t=n,s.trigger("select",{data:t})});i.term!==t.term&&(this.$search.length&&(this.$search.val(i.term),this.$search.trigger("focus")),t.term=i.term),e.call(this,t,n)},e.prototype.tokenizer=function(e,t,n,s){for(var i=n.get("tokenSeparators")||[],r=t.term,o=0,a=this.createTag||function(e){return{id:e.term,text:e.term}};o<r.length;){var l=r[o];-1!==i.indexOf(l)?(l=r.substr(0,o),null!=(l=a(c.extend({},t,{term:l})))?(s(l),r=r.substr(o+1)||"",o=0):o++):o++}return{term:r}},e}),u.define("select2/data/minimumInputLength",[],function(){function e(e,t,n){this.minimumInputLength=n.get("minimumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",t.term.length<this.minimumInputLength?this.trigger("results:message",{message:"inputTooShort",args:{minimum:this.minimumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),u.define("select2/data/maximumInputLength",[],function(){function e(e,t,n){this.maximumInputLength=n.get("maximumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",0<this.maximumInputLength&&t.term.length>this.maximumInputLength?this.trigger("results:message",{message:"inputTooLong",args:{maximum:this.maximumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e}),u.define("select2/data/maximumSelectionLength",[],function(){function e(e,t,n){this.maximumSelectionLength=n.get("maximumSelectionLength"),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("select",function(){s._checkIfMaximumSelected()})},e.prototype.query=function(e,t,n){var s=this;this._checkIfMaximumSelected(function(){e.call(s,t,n)})},e.prototype._checkIfMaximumSelected=function(e,t){var n=this;this.current(function(e){e=null!=e?e.length:0;0<n.maximumSelectionLength&&e>=n.maximumSelectionLength?n.trigger("results:message",{message:"maximumSelected",args:{maximum:n.maximumSelectionLength}}):t&&t()})},e}),u.define("select2/dropdown",["jquery","./utils"],function(t,e){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return e.Extend(n,e.Observable),n.prototype.render=function(){var e=t('<span class="select2-dropdown"><span class="select2-results"></span></span>');return e.attr("dir",this.options.get("dir")),this.$dropdown=e},n.prototype.bind=function(){},n.prototype.position=function(e,t){},n.prototype.destroy=function(){this.$dropdown.remove()},n}),u.define("select2/dropdown/search",["jquery"],function(r){function e(){}return e.prototype.render=function(e){var t=e.call(this),n=this.options.get("translations").get("search"),e=r('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></span>');return this.$searchContainer=e,this.$search=e.find("input"),this.$search.prop("autocomplete",this.options.get("autocomplete")),this.$search.attr("aria-label",n()),t.prepend(e),t},e.prototype.bind=function(e,t,n){var s=this,i=t.id+"-results";e.call(this,t,n),this.$search.on("keydown",function(e){s.trigger("keypress",e),s._keyUpPrevented=e.isDefaultPrevented()}),this.$search.on("input",function(e){r(this).off("keyup")}),this.$search.on("keyup input",function(e){s.handleSearch(e)}),t.on("open",function(){s.$search.attr("tabindex",0),s.$search.attr("aria-controls",i),s.$search.trigger("focus"),window.setTimeout(function(){s.$search.trigger("focus")},0)}),t.on("close",function(){s.$search.attr("tabindex",-1),s.$search.removeAttr("aria-controls"),s.$search.removeAttr("aria-activedescendant"),s.$search.val(""),s.$search.trigger("blur")}),t.on("focus",function(){t.isOpen()||s.$search.trigger("focus")}),t.on("results:all",function(e){null!=e.query.term&&""!==e.query.term||(s.showSearch(e)?s.$searchContainer[0].classList.remove("select2-search--hide"):s.$searchContainer[0].classList.add("select2-search--hide"))}),t.on("results:focus",function(e){e.data._resultId?s.$search.attr("aria-activedescendant",e.data._resultId):s.$search.removeAttr("aria-activedescendant")})},e.prototype.handleSearch=function(e){var t;this._keyUpPrevented||(t=this.$search.val(),this.trigger("query",{term:t})),this._keyUpPrevented=!1},e.prototype.showSearch=function(e,t){return!0},e}),u.define("select2/dropdown/hidePlaceholder",[],function(){function e(e,t,n,s){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n,s)}return e.prototype.append=function(e,t){t.results=this.removePlaceholder(t.results),e.call(this,t)},e.prototype.normalizePlaceholder=function(e,t){return t="string"==typeof t?{id:"",text:t}:t},e.prototype.removePlaceholder=function(e,t){for(var n=t.slice(0),s=t.length-1;0<=s;s--){var i=t[s];this.placeholder.id===i.id&&n.splice(s,1)}return n},e}),u.define("select2/dropdown/infiniteScroll",["jquery"],function(n){function e(e,t,n,s){this.lastParams={},e.call(this,t,n,s),this.$loadingMore=this.createLoadingMore(),this.loading=!1}return e.prototype.append=function(e,t){this.$loadingMore.remove(),this.loading=!1,e.call(this,t),this.showLoadingMore(t)&&(this.$results.append(this.$loadingMore),this.loadMoreIfNeeded())},e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("query",function(e){s.lastParams=e,s.loading=!0}),t.on("query:append",function(e){s.lastParams=e,s.loading=!0}),this.$results.on("scroll",this.loadMoreIfNeeded.bind(this))},e.prototype.loadMoreIfNeeded=function(){var e=n.contains(document.documentElement,this.$loadingMore[0]);!this.loading&&e&&(e=this.$results.offset().top+this.$results.outerHeight(!1),this.$loadingMore.offset().top+this.$loadingMore.outerHeight(!1)<=e+50&&this.loadMore())},e.prototype.loadMore=function(){this.loading=!0;var e=n.extend({},{page:1},this.lastParams);e.page++,this.trigger("query:append",e)},e.prototype.showLoadingMore=function(e,t){return t.pagination&&t.pagination.more},e.prototype.createLoadingMore=function(){var e=n('<li class="select2-results__option select2-results__option--load-more"role="option" aria-disabled="true"></li>'),t=this.options.get("translations").get("loadingMore");return e.html(t(this.lastParams)),e},e}),u.define("select2/dropdown/attachBody",["jquery","../utils"],function(u,o){function e(e,t,n){this.$dropdownParent=u(n.get("dropdownParent")||document.body),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("open",function(){s._showDropdown(),s._attachPositioningHandler(t),s._bindContainerResultHandlers(t)}),t.on("close",function(){s._hideDropdown(),s._detachPositioningHandler(t)}),this.$dropdownContainer.on("mousedown",function(e){e.stopPropagation()})},e.prototype.destroy=function(e){e.call(this),this.$dropdownContainer.remove()},e.prototype.position=function(e,t,n){t.attr("class",n.attr("class")),t[0].classList.remove("select2"),t[0].classList.add("select2-container--open"),t.css({position:"absolute",top:-999999}),this.$container=n},e.prototype.render=function(e){var t=u("<span></span>"),e=e.call(this);return t.append(e),this.$dropdownContainer=t},e.prototype._hideDropdown=function(e){this.$dropdownContainer.detach()},e.prototype._bindContainerResultHandlers=function(e,t){var n;this._containerResultsHandlersBound||(n=this,t.on("results:all",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:append",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("results:message",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("select",function(){n._positionDropdown(),n._resizeDropdown()}),t.on("unselect",function(){n._positionDropdown(),n._resizeDropdown()}),this._containerResultsHandlersBound=!0)},e.prototype._attachPositioningHandler=function(e,t){var n=this,s="scroll.select2."+t.id,i="resize.select2."+t.id,r="orientationchange.select2."+t.id,t=this.$container.parents().filter(o.hasScroll);t.each(function(){o.StoreData(this,"select2-scroll-position",{x:u(this).scrollLeft(),y:u(this).scrollTop()})}),t.on(s,function(e){var t=o.GetData(this,"select2-scroll-position");u(this).scrollTop(t.y)}),u(window).on(s+" "+i+" "+r,function(e){n._positionDropdown(),n._resizeDropdown()})},e.prototype._detachPositioningHandler=function(e,t){var n="scroll.select2."+t.id,s="resize.select2."+t.id,t="orientationchange.select2."+t.id;this.$container.parents().filter(o.hasScroll).off(n),u(window).off(n+" "+s+" "+t)},e.prototype._positionDropdown=function(){var e=u(window),t=this.$dropdown[0].classList.contains("select2-dropdown--above"),n=this.$dropdown[0].classList.contains("select2-dropdown--below"),s=null,i=this.$container.offset();i.bottom=i.top+this.$container.outerHeight(!1);var r={height:this.$container.outerHeight(!1)};r.top=i.top,r.bottom=i.top+r.height;var o=this.$dropdown.outerHeight(!1),a=e.scrollTop(),l=e.scrollTop()+e.height(),c=a<i.top-o,e=l>i.bottom+o,a={left:i.left,top:r.bottom},l=this.$dropdownParent;"static"===l.css("position")&&(l=l.offsetParent());i={top:0,left:0};(u.contains(document.body,l[0])||l[0].isConnected)&&(i=l.offset()),a.top-=i.top,a.left-=i.left,t||n||(s="below"),e||!c||t?!c&&e&&t&&(s="below"):s="above",("above"==s||t&&"below"!==s)&&(a.top=r.top-i.top-o),null!=s&&(this.$dropdown[0].classList.remove("select2-dropdown--below"),this.$dropdown[0].classList.remove("select2-dropdown--above"),this.$dropdown[0].classList.add("select2-dropdown--"+s),this.$container[0].classList.remove("select2-container--below"),this.$container[0].classList.remove("select2-container--above"),this.$container[0].classList.add("select2-container--"+s)),this.$dropdownContainer.css(a)},e.prototype._resizeDropdown=function(){var e={width:this.$container.outerWidth(!1)+"px"};this.options.get("dropdownAutoWidth")&&(e.minWidth=e.width,e.position="relative",e.width="auto"),this.$dropdown.css(e)},e.prototype._showDropdown=function(e){this.$dropdownContainer.appendTo(this.$dropdownParent),this._positionDropdown(),this._resizeDropdown()},e}),u.define("select2/dropdown/minimumResultsForSearch",[],function(){function e(e,t,n,s){this.minimumResultsForSearch=n.get("minimumResultsForSearch"),this.minimumResultsForSearch<0&&(this.minimumResultsForSearch=1/0),e.call(this,t,n,s)}return e.prototype.showSearch=function(e,t){return!(function e(t){for(var n=0,s=0;s<t.length;s++){var i=t[s];i.children?n+=e(i.children):n++}return n}(t.data.results)<this.minimumResultsForSearch)&&e.call(this,t)},e}),u.define("select2/dropdown/selectOnClose",["../utils"],function(s){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("close",function(e){s._handleSelectOnClose(e)})},e.prototype._handleSelectOnClose=function(e,t){if(t&&null!=t.originalSelect2Event){var n=t.originalSelect2Event;if("select"===n._type||"unselect"===n._type)return}n=this.getHighlightedResults();n.length<1||(null!=(n=s.GetData(n[0],"data")).element&&n.element.selected||null==n.element&&n.selected||this.trigger("select",{data:n}))},e}),u.define("select2/dropdown/closeOnSelect",[],function(){function e(){}return e.prototype.bind=function(e,t,n){var s=this;e.call(this,t,n),t.on("select",function(e){s._selectTriggered(e)}),t.on("unselect",function(e){s._selectTriggered(e)})},e.prototype._selectTriggered=function(e,t){var n=t.originalEvent;n&&(n.ctrlKey||n.metaKey)||this.trigger("close",{originalEvent:n,originalSelect2Event:t})},e}),u.define("select2/dropdown/dropdownCss",["../utils"],function(n){function e(){}return e.prototype.render=function(e){var t=e.call(this),e=this.options.get("dropdownCssClass")||"";return-1!==e.indexOf(":all:")&&(e=e.replace(":all:",""),n.copyNonInternalCssClasses(t[0],this.$element[0])),t.addClass(e),t},e}),u.define("select2/dropdown/tagsSearchHighlight",["../utils"],function(s){function e(){}return e.prototype.highlightFirstItem=function(e){var t=this.$results.find(".select2-results__option--selectable:not(.select2-results__option--selected)");if(0<t.length){var n=t.first(),t=s.GetData(n[0],"data").element;if(t&&t.getAttribute&&"true"===t.getAttribute("data-select2-tag"))return void n.trigger("mouseenter")}e.call(this)},e}),u.define("select2/i18n/en",[],function(){return{errorLoading:function(){return"The results could not be loaded."},inputTooLong:function(e){var t=e.input.length-e.maximum,e="Please delete "+t+" character";return 1!=t&&(e+="s"),e},inputTooShort:function(e){return"Please enter "+(e.minimum-e.input.length)+" or more characters"},loadingMore:function(){return"Loading more results…"},maximumSelected:function(e){var t="You can only select "+e.maximum+" item";return 1!=e.maximum&&(t+="s"),t},noResults:function(){return"No results found"},searching:function(){return"Searching…"},removeAllItems:function(){return"Remove all items"},removeItem:function(){return"Remove item"},search:function(){return"Search"}}}),u.define("select2/defaults",["jquery","./results","./selection/single","./selection/multiple","./selection/placeholder","./selection/allowClear","./selection/search","./selection/selectionCss","./selection/eventRelay","./utils","./translation","./diacritics","./data/select","./data/array","./data/ajax","./data/tags","./data/tokenizer","./data/minimumInputLength","./data/maximumInputLength","./data/maximumSelectionLength","./dropdown","./dropdown/search","./dropdown/hidePlaceholder","./dropdown/infiniteScroll","./dropdown/attachBody","./dropdown/minimumResultsForSearch","./dropdown/selectOnClose","./dropdown/closeOnSelect","./dropdown/dropdownCss","./dropdown/tagsSearchHighlight","./i18n/en"],function(l,r,o,a,c,u,d,p,h,f,g,t,m,y,v,_,b,$,w,x,A,D,S,E,O,C,L,T,q,I,e){function n(){this.reset()}return n.prototype.apply=function(e){var t;null==(e=l.extend(!0,{},this.defaults,e)).dataAdapter&&(null!=e.ajax?e.dataAdapter=v:null!=e.data?e.dataAdapter=y:e.dataAdapter=m,0<e.minimumInputLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,$)),0<e.maximumInputLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,w)),0<e.maximumSelectionLength&&(e.dataAdapter=f.Decorate(e.dataAdapter,x)),e.tags&&(e.dataAdapter=f.Decorate(e.dataAdapter,_)),null==e.tokenSeparators&&null==e.tokenizer||(e.dataAdapter=f.Decorate(e.dataAdapter,b))),null==e.resultsAdapter&&(e.resultsAdapter=r,null!=e.ajax&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,E)),null!=e.placeholder&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,S)),e.selectOnClose&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,L)),e.tags&&(e.resultsAdapter=f.Decorate(e.resultsAdapter,I))),null==e.dropdownAdapter&&(e.multiple?e.dropdownAdapter=A:(t=f.Decorate(A,D),e.dropdownAdapter=t),0!==e.minimumResultsForSearch&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,C)),e.closeOnSelect&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,T)),null!=e.dropdownCssClass&&(e.dropdownAdapter=f.Decorate(e.dropdownAdapter,q)),e.dropdownAdapter=f.Decorate(e.dropdownAdapter,O)),null==e.selectionAdapter&&(e.multiple?e.selectionAdapter=a:e.selectionAdapter=o,null!=e.placeholder&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,c)),e.allowClear&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,u)),e.multiple&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,d)),null!=e.selectionCssClass&&(e.selectionAdapter=f.Decorate(e.selectionAdapter,p)),e.selectionAdapter=f.Decorate(e.selectionAdapter,h)),e.language=this._resolveLanguage(e.language),e.language.push("en");for(var n=[],s=0;s<e.language.length;s++){var i=e.language[s];-1===n.indexOf(i)&&n.push(i)}return e.language=n,e.translations=this._processTranslations(e.language,e.debug),e},n.prototype.reset=function(){function a(e){return e.replace(/[^\u0000-\u007E]/g,function(e){return t[e]||e})}this.defaults={amdLanguageBase:"./i18n/",autocomplete:"off",closeOnSelect:!0,debug:!1,dropdownAutoWidth:!1,escapeMarkup:f.escapeMarkup,language:{},matcher:function e(t,n){if(null==t.term||""===t.term.trim())return n;if(n.children&&0<n.children.length){for(var s=l.extend(!0,{},n),i=n.children.length-1;0<=i;i--)null==e(t,n.children[i])&&s.children.splice(i,1);return 0<s.children.length?s:e(t,s)}var r=a(n.text).toUpperCase(),o=a(t.term).toUpperCase();return-1<r.indexOf(o)?n:null},minimumInputLength:0,maximumInputLength:0,maximumSelectionLength:0,minimumResultsForSearch:0,selectOnClose:!1,scrollAfterSelect:!1,sorter:function(e){return e},templateResult:function(e){return e.text},templateSelection:function(e){return e.text},theme:"default",width:"resolve"}},n.prototype.applyFromElement=function(e,t){var n=e.language,s=this.defaults.language,i=t.prop("lang"),t=t.closest("[lang]").prop("lang"),t=Array.prototype.concat.call(this._resolveLanguage(i),this._resolveLanguage(n),this._resolveLanguage(s),this._resolveLanguage(t));return e.language=t,e},n.prototype._resolveLanguage=function(e){if(!e)return[];if(l.isEmptyObject(e))return[];if(l.isPlainObject(e))return[e];for(var t,n=Array.isArray(e)?e:[e],s=[],i=0;i<n.length;i++)s.push(n[i]),"string"==typeof n[i]&&0<n[i].indexOf("-")&&(t=n[i].split("-")[0],s.push(t));return s},n.prototype._processTranslations=function(e,t){for(var n=new g,s=0;s<e.length;s++){var i=new g,r=e[s];if("string"==typeof r)try{i=g.loadPath(r)}catch(e){try{r=this.defaults.amdLanguageBase+r,i=g.loadPath(r)}catch(e){t&&window.console&&console.warn&&console.warn('Select2: The language file for "'+r+'" could not be automatically loaded. A fallback will be used instead.')}}else i=l.isPlainObject(r)?new g(r):r;n.extend(i)}return n},n.prototype.set=function(e,t){var n={};n[l.camelCase(e)]=t;n=f._convertData(n);l.extend(!0,this.defaults,n)},new n}),u.define("select2/options",["jquery","./defaults","./utils"],function(c,n,u){function e(e,t){this.options=e,null!=t&&this.fromElement(t),null!=t&&(this.options=n.applyFromElement(this.options,t)),this.options=n.apply(this.options)}return e.prototype.fromElement=function(e){var t=["select2"];null==this.options.multiple&&(this.options.multiple=e.prop("multiple")),null==this.options.disabled&&(this.options.disabled=e.prop("disabled")),null==this.options.autocomplete&&e.prop("autocomplete")&&(this.options.autocomplete=e.prop("autocomplete")),null==this.options.dir&&(e.prop("dir")?this.options.dir=e.prop("dir"):e.closest("[dir]").prop("dir")?this.options.dir=e.closest("[dir]").prop("dir"):this.options.dir="ltr"),e.prop("disabled",this.options.disabled),e.prop("multiple",this.options.multiple),u.GetData(e[0],"select2Tags")&&(this.options.debug&&window.console&&console.warn&&console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'),u.StoreData(e[0],"data",u.GetData(e[0],"select2Tags")),u.StoreData(e[0],"tags",!0)),u.GetData(e[0],"ajaxUrl")&&(this.options.debug&&window.console&&console.warn&&console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."),e.attr("ajax--url",u.GetData(e[0],"ajaxUrl")),u.StoreData(e[0],"ajax-Url",u.GetData(e[0],"ajaxUrl")));var n={};function s(e,t){return t.toUpperCase()}for(var i=0;i<e[0].attributes.length;i++){var r=e[0].attributes[i].name,o="data-";r.substr(0,o.length)==o&&(r=r.substring(o.length),o=u.GetData(e[0],r),n[r.replace(/-([a-z])/g,s)]=o)}c.fn.jquery&&"1."==c.fn.jquery.substr(0,2)&&e[0].dataset&&(n=c.extend(!0,{},e[0].dataset,n));var a,l=c.extend(!0,{},u.GetData(e[0]),n);for(a in l=u._convertData(l))-1<t.indexOf(a)||(c.isPlainObject(this.options[a])?c.extend(this.options[a],l[a]):this.options[a]=l[a]);return this},e.prototype.get=function(e){return this.options[e]},e.prototype.set=function(e,t){this.options[e]=t},e}),u.define("select2/core",["jquery","./options","./utils","./keys"],function(t,i,r,s){var o=function(e,t){null!=r.GetData(e[0],"select2")&&r.GetData(e[0],"select2").destroy(),this.$element=e,this.id=this._generateId(e),t=t||{},this.options=new i(t,e),o.__super__.constructor.call(this);var n=e.attr("tabindex")||0;r.StoreData(e[0],"old-tabindex",n),e.attr("tabindex","-1");t=this.options.get("dataAdapter");this.dataAdapter=new t(e,this.options);n=this.render();this._placeContainer(n);t=this.options.get("selectionAdapter");this.selection=new t(e,this.options),this.$selection=this.selection.render(),this.selection.position(this.$selection,n);t=this.options.get("dropdownAdapter");this.dropdown=new t(e,this.options),this.$dropdown=this.dropdown.render(),this.dropdown.position(this.$dropdown,n);n=this.options.get("resultsAdapter");this.results=new n(e,this.options,this.dataAdapter),this.$results=this.results.render(),this.results.position(this.$results,this.$dropdown);var s=this;this._bindAdapters(),this._registerDomEvents(),this._registerDataEvents(),this._registerSelectionEvents(),this._registerDropdownEvents(),this._registerResultsEvents(),this._registerEvents(),this.dataAdapter.current(function(e){s.trigger("selection:update",{data:e})}),e[0].classList.add("select2-hidden-accessible"),e.attr("aria-hidden","true"),this._syncAttributes(),r.StoreData(e[0],"select2",this),e.data("select2",this)};return r.Extend(o,r.Observable),o.prototype._generateId=function(e){return"select2-"+(null!=e.attr("id")?e.attr("id"):null!=e.attr("name")?e.attr("name")+"-"+r.generateChars(2):r.generateChars(4)).replace(/(:|\.|\[|\]|,)/g,"")},o.prototype._placeContainer=function(e){e.insertAfter(this.$element);var t=this._resolveWidth(this.$element,this.options.get("width"));null!=t&&e.css("width",t)},o.prototype._resolveWidth=function(e,t){var n=/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;if("resolve"==t){var s=this._resolveWidth(e,"style");return null!=s?s:this._resolveWidth(e,"element")}if("element"==t){s=e.outerWidth(!1);return s<=0?"auto":s+"px"}if("style"!=t)return"computedstyle"!=t?t:window.getComputedStyle(e[0]).width;e=e.attr("style");if("string"!=typeof e)return null;for(var i=e.split(";"),r=0,o=i.length;r<o;r+=1){var a=i[r].replace(/\s/g,"").match(n);if(null!==a&&1<=a.length)return a[1]}return null},o.prototype._bindAdapters=function(){this.dataAdapter.bind(this,this.$container),this.selection.bind(this,this.$container),this.dropdown.bind(this,this.$container),this.results.bind(this,this.$container)},o.prototype._registerDomEvents=function(){var t=this;this.$element.on("change.select2",function(){t.dataAdapter.current(function(e){t.trigger("selection:update",{data:e})})}),this.$element.on("focus.select2",function(e){t.trigger("focus",e)}),this._syncA=r.bind(this._syncAttributes,this),this._syncS=r.bind(this._syncSubtree,this),this._observer=new window.MutationObserver(function(e){t._syncA(),t._syncS(e)}),this._observer.observe(this.$element[0],{attributes:!0,childList:!0,subtree:!1})},o.prototype._registerDataEvents=function(){var n=this;this.dataAdapter.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerSelectionEvents=function(){var n=this,s=["toggle","focus"];this.selection.on("toggle",function(){n.toggleDropdown()}),this.selection.on("focus",function(e){n.focus(e)}),this.selection.on("*",function(e,t){-1===s.indexOf(e)&&n.trigger(e,t)})},o.prototype._registerDropdownEvents=function(){var n=this;this.dropdown.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerResultsEvents=function(){var n=this;this.results.on("*",function(e,t){n.trigger(e,t)})},o.prototype._registerEvents=function(){var n=this;this.on("open",function(){n.$container[0].classList.add("select2-container--open")}),this.on("close",function(){n.$container[0].classList.remove("select2-container--open")}),this.on("enable",function(){n.$container[0].classList.remove("select2-container--disabled")}),this.on("disable",function(){n.$container[0].classList.add("select2-container--disabled")}),this.on("blur",function(){n.$container[0].classList.remove("select2-container--focus")}),this.on("query",function(t){n.isOpen()||n.trigger("open",{}),this.dataAdapter.query(t,function(e){n.trigger("results:all",{data:e,query:t})})}),this.on("query:append",function(t){this.dataAdapter.query(t,function(e){n.trigger("results:append",{data:e,query:t})})}),this.on("keypress",function(e){var t=e.which;n.isOpen()?t===s.ESC||t===s.UP&&e.altKey?(n.close(e),e.preventDefault()):t===s.ENTER||t===s.TAB?(n.trigger("results:select",{}),e.preventDefault()):t===s.SPACE&&e.ctrlKey?(n.trigger("results:toggle",{}),e.preventDefault()):t===s.UP?(n.trigger("results:previous",{}),e.preventDefault()):t===s.DOWN&&(n.trigger("results:next",{}),e.preventDefault()):(t===s.ENTER||t===s.SPACE||t===s.DOWN&&e.altKey)&&(n.open(),e.preventDefault())})},o.prototype._syncAttributes=function(){this.options.set("disabled",this.$element.prop("disabled")),this.isDisabled()?(this.isOpen()&&this.close(),this.trigger("disable",{})):this.trigger("enable",{})},o.prototype._isChangeMutation=function(e){var t=this;if(e.addedNodes&&0<e.addedNodes.length){for(var n=0;n<e.addedNodes.length;n++)if(e.addedNodes[n].selected)return!0}else{if(e.removedNodes&&0<e.removedNodes.length)return!0;if(Array.isArray(e))return e.some(function(e){return t._isChangeMutation(e)})}return!1},o.prototype._syncSubtree=function(e){var e=this._isChangeMutation(e),t=this;e&&this.dataAdapter.current(function(e){t.trigger("selection:update",{data:e})})},o.prototype.trigger=function(e,t){var n=o.__super__.trigger,s={open:"opening",close:"closing",select:"selecting",unselect:"unselecting",clear:"clearing"};if(void 0===t&&(t={}),e in s){var i=s[e],s={prevented:!1,name:e,args:t};if(n.call(this,i,s),s.prevented)return void(t.prevented=!0)}n.call(this,e,t)},o.prototype.toggleDropdown=function(){this.isDisabled()||(this.isOpen()?this.close():this.open())},o.prototype.open=function(){this.isOpen()||this.isDisabled()||this.trigger("query",{})},o.prototype.close=function(e){this.isOpen()&&this.trigger("close",{originalEvent:e})},o.prototype.isEnabled=function(){return!this.isDisabled()},o.prototype.isDisabled=function(){return this.options.get("disabled")},o.prototype.isOpen=function(){return this.$container[0].classList.contains("select2-container--open")},o.prototype.hasFocus=function(){return this.$container[0].classList.contains("select2-container--focus")},o.prototype.focus=function(e){this.hasFocus()||(this.$container[0].classList.add("select2-container--focus"),this.trigger("focus",{}))},o.prototype.enable=function(e){this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.');e=!(e=null==e||0===e.length?[!0]:e)[0];this.$element.prop("disabled",e)},o.prototype.data=function(){this.options.get("debug")&&0<arguments.length&&window.console&&console.warn&&console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');var t=[];return this.dataAdapter.current(function(e){t=e}),t},o.prototype.val=function(e){if(this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'),null==e||0===e.length)return this.$element.val();e=e[0];Array.isArray(e)&&(e=e.map(function(e){return e.toString()})),this.$element.val(e).trigger("input").trigger("change")},o.prototype.destroy=function(){r.RemoveData(this.$container[0]),this.$container.remove(),this._observer.disconnect(),this._observer=null,this._syncA=null,this._syncS=null,this.$element.off(".select2"),this.$element.attr("tabindex",r.GetData(this.$element[0],"old-tabindex")),this.$element[0].classList.remove("select2-hidden-accessible"),this.$element.attr("aria-hidden","false"),r.RemoveData(this.$element[0]),this.$element.removeData("select2"),this.dataAdapter.destroy(),this.selection.destroy(),this.dropdown.destroy(),this.results.destroy(),this.dataAdapter=null,this.selection=null,this.dropdown=null,this.results=null},o.prototype.render=function(){var e=t('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');return e.attr("dir",this.options.get("dir")),this.$container=e,this.$container[0].classList.add("select2-container--"+this.options.get("theme")),r.StoreData(e[0],"element",this.$element),e},o}),u.define("jquery-mousewheel",["jquery"],function(e){return e}),u.define("jquery.select2",["jquery","jquery-mousewheel","./select2/core","./select2/defaults","./select2/utils"],function(i,e,r,t,o){var a;return null==i.fn.select2&&(a=["open","close","destroy"],i.fn.select2=function(t){if("object"==typeof(t=t||{}))return this.each(function(){var e=i.extend(!0,{},t);new r(i(this),e)}),this;if("string"!=typeof t)throw new Error("Invalid arguments for Select2: "+t);var n,s=Array.prototype.slice.call(arguments,1);return this.each(function(){var e=o.GetData(this,"select2");null==e&&window.console&&console.error&&console.error("The select2('"+t+"') method was called on an element that is not using Select2."),n=e[t].apply(e,s)}),-1<a.indexOf(t)?this:n}),null==i.fn.select2.defaults&&(i.fn.select2.defaults=t),r}),{define:u.define,require:u.require});function b(e,t){return i.call(e,t)}function l(e,t){var n,s,i,r,o,a,l,c,u,d,p=t&&t.split("/"),h=y.map,f=h&&h["*"]||{};if(e){for(t=(e=e.split("/")).length-1,y.nodeIdCompat&&_.test(e[t])&&(e[t]=e[t].replace(_,"")),"."===e[0].charAt(0)&&p&&(e=p.slice(0,p.length-1).concat(e)),c=0;c<e.length;c++)"."===(d=e[c])?(e.splice(c,1),--c):".."===d&&(0===c||1===c&&".."===e[2]||".."===e[c-1]||0<c&&(e.splice(c-1,2),c-=2));e=e.join("/")}if((p||f)&&h){for(c=(n=e.split("/")).length;0<c;--c){if(s=n.slice(0,c).join("/"),p)for(u=p.length;0<u;--u)if(i=h[p.slice(0,u).join("/")],i=i&&i[s]){r=i,o=c;break}if(r)break;!a&&f&&f[s]&&(a=f[s],l=c)}!r&&a&&(r=a,o=l),r&&(n.splice(0,o,r),e=n.join("/"))}return e}function w(t,n){return function(){var e=a.call(arguments,0);return"string"!=typeof e[0]&&1===e.length&&e.push(null),o.apply(p,e.concat([t,n]))}}function x(e){var t;if(b(m,e)&&(t=m[e],delete m[e],v[e]=!0,r.apply(p,t)),!b(g,e)&&!b(v,e))throw new Error("No "+e);return g[e]}function c(e){var t,n=e?e.indexOf("!"):-1;return-1<n&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function A(e){return e?c(e):[]}var u=s.require("jquery.select2");return t.fn.select2.amd=s,u});</script>
    <script>
        jQuery(document).ready(function($) {
            $('.js-example-basic-single').select2();
        });
    </script>
    <style>.product_options_section_wrapper .select2-container{width:100% !important;} </style>

    <div class="product_options_section_wrapper">
        <select class="js-example-basic-single" name="product_options[]" multiple="multiple" >
            <?php
            foreach ( $product_options as $key => $option ) : ?>
                <option <?php echo in_array($key, $selected_product_options) ? 'selected="selected"' : ''; ?> value="<?php echo $key ?>"><?php echo $option; ?></option>
            <?php
            endforeach; ?>
        </select>
    </div>
    <hr>

    <?php
}
/*=========================================================================================*/
add_action('save_post', 'save_product_options', 10, 3);
function save_product_options($product_id, $post, $update) {

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $product_id)) return;

    if (isset($_POST['product_options']))
        update_post_meta($product_id, 'product_options', $_POST['product_options']);
}
/****************************************************************************************************************************************/
function get_day_type($day) {

    $calendar_data = get_option('ez_calendar');

    foreach ( explode( ',', $calendar_data['holidays']) as $calendar_day ) {
        $calendar_day = (int)$calendar_day - 12600; // to convert to local time. calendar time is based GMT+3:30
        if ( $calendar_day < $day && $day < $calendar_day + 86399 )
            return 'holidays';
    }

    foreach ( explode( ',', $calendar_data['closed_days']) as $calendar_day ) {
        $calendar_day = (int)$calendar_day - 12600; // to convert to local time. calendar time is based GMT+3:30
        if ( $calendar_day < $day && $day < $calendar_day + 86399 )
            return 'closed';
    }

    return 'normals';
}
/****************************************************************************************************************************************/
function get_sanses($product_id) {
    return ['normals' => get_post_meta($product_id, 'schedule_normals', true), 'holidays' => get_post_meta($product_id, 'schedule_holidays', true)];
}
/****************************************************************************************************************************************/
add_action( 'woocommerce_before_save_order_items', 'custom_checkout_create_order_line_item', 10, 2 );
function custom_checkout_create_order_line_item( $order_id, $items ) {
    global $wpdb;

    foreach ( $items['order_item_qty'] as $temp )
        $quantity = $temp;

    $wpdb->update('held_orders_list', array('count' => $quantity ), array('order_id' => $order_id));
    ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "UPDATE `wp_zb_booking_history` SET `quantity` = {$quantity} WHERE `wc_order_id` = {$order_id};"]));
}
/****************************************************************************************************************************************/
function add_to_sms_queue ($phone, $text, $order_id, $type) {
    global $wpdb;

    $query_time = time();

    if ( $phone )
        $wpdb->query( "INSERT INTO sms_sending_queue (phone, text, order_id, type, query_time, sent_time) VALUES ('{$phone}', '{$text}', '{$order_id}', '{$type}', '{$query_time}', NULL);" );
}
/****************************************************************************************************************************************/
add_action('admin_init', function(){

    if ( $_GET['comment_status'] == 'trash' ) {?>

        <style>
            #delete_all {
                display: none;
            }
        </style>

        <?php
    }
});
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
/****************************************************************************************************************************************/
if ( isset($_GET['put_cms_blacklist']) ) {

    $args = array(
        'post_type'         => 'product',
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
        'meta_query' => array (
            array(
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $loop = new WP_Query( $args );

    while ( $loop->have_posts() ) : $loop->the_post();
        global $product;

        $product_id = get_the_ID();

        $args = array (
            'post__in' => $product_id,
        );
        $comments_query = new WP_Comment_Query;
        $comments       = $comments_query->query($args);

        if ($comments) {
            foreach ($comments as $comment) {
                $phone = $comment->comment_author;

                if ( !empty( $phone ) ) {
                    $temp1 = get_post_meta($product_id, 'comments_blacklist', true);
                    $comments_blacklist = !empty($temp1) ? $temp1 : [];

                    if ( !in_array($phone, $comments_blacklist) )
                        $comments_blacklist[] = $phone;

                    update_post_meta($product_id, 'comments_blacklist', $comments_blacklist);
                }
            }
        }
    endwhile;
}
/****************************************************************************************************************************************/
add_action('init', 'saeedxxx');
function saeedxxx() {
    if ( isset($_GET['fill_table_with_order_info'] ) && 0) {

        global $wpdb;

        $orders = $wpdb->get_results( "
            SELECT wp_posts.ID
            FROM wp_zb_booking_history
            INNER JOIN wp_posts ON wp_posts.ID = wp_zb_booking_history.wc_order_id
            AND wp_zb_booking_history.booking_time > 1701140000
            AND wp_zb_booking_history.status LIKE 1;
        ", ARRAY_A );

        foreach ( $orders as $order_id ) {
            $order = wc_get_order( $order_id['ID'] );

            if ( !empty( $order ) ) {
                $player_name    = $order->get_billing_first_name() . " " . $order->get_billing_last_name();
                $player_phone   = $order->get_billing_phone();
                foreach ($order->get_items() as $item)
                    $item_quantity = $item->get_quantity();

                $wpdb->update('wp_zb_booking_history', array('name' => $player_name, 'phone' => $player_phone, 'quantity' => $item_quantity ), array('wc_order_id' => $order_id['ID']));
            }
        }
    }
}
/****************************************************************************************************************************************/
if ( isset( $_GET['update_comment_stars'] ) ) {

    $args = array (
        'post_type'         => 'product',
        'posts_per_page'    => -1,
//        'post__in'          => [531587],
        'meta_query'        => array (
            array (
                'key'     => 'sale_active',
                'value'   => 1,
                'compare' => 'LIKE',
            ),
        ),
    );
    $loop = new WP_Query( $args );

    $comment_rates = [];
    while ( $loop->have_posts() ) : $loop->the_post();

        $args = array (
            'post__in'      => get_the_ID(),
            'date_query'    => array (
                array(
                    'after'     => '2023/04/15',
                    'inclusive' => true,
                ),
            ),
        );
        $comments_query = new WP_Comment_Query;
        $comments       = $comments_query->query($args);

        $comment_count      = 0;
        $comment_rating_1   = $comment_rating_2 = $comment_rating_3 = $comment_rating_4 = $comment_rating_5 = 0;

        if ($comments) {
            foreach ($comments as $comment) {
                $comment_rating = get_comment_meta($comment->comment_ID, "comment_rating", true);

                if ( !empty ( $comment_rating ) ) {
                    if ( $comment->comment_type == 'review' && $comment->comment_approved == 1 ) {
                        $comment_count++;

                        $comment_ids[] = [
                            $comment->comment_ID,
                            ( $comment_rating[1098] + $comment_rating[1097] + $comment_rating[1096] + $comment_rating[1095] + $comment_rating[1094] ) / 100
                        ];

                        $comment_rating_1 += $comment_rating[1098];
                        $comment_rating_2 += $comment_rating[1097];
                        $comment_rating_3 += $comment_rating[1096];
                        $comment_rating_4 += $comment_rating[1095];
                        $comment_rating_5 += $comment_rating[1094];
                    }
                }
            }
        }
        wp_reset_query();

        $comment_rates[1098] = $comment_rating_1;
        $comment_rates[1097] = $comment_rating_2;
        $comment_rates[1096] = $comment_rating_3;
        $comment_rates[1095] = $comment_rating_4;
        $comment_rates[1094] = $comment_rating_5;

        update_post_meta(get_the_ID(), 'product_rates', $comment_rates);
        update_post_meta(get_the_ID(), 'comments_count_new', $comment_count);

    endwhile;
}
/****************************************************************************************************************************************/
add_action('init', 'get_completed_and_partial_orders_phone');
function get_completed_and_partial_orders_phone() {
    if ( isset( $_GET['get_completed_and_partial_orders_phone'] ) ) {
        global $wpdb;

//    $orders = $wpdb->get_results( "SELECT ID FROM wp_posts WHERE post_type = 'shop_order' AND (post_status = 'wc-partially-paid' OR post_status = 'wc-completed')", ARRAY_A );
//
//    $products_phones = [];
//    $products_phones = get_option('1703946962134', true);
//
//    foreach ( $orders as $order_id ) {
//        $order_id = $order_id['ID'];
//
//        $product_id = get_post_meta($order_id, 'code_otagh', true);
//
//        if ( !$product_id ) {
//            $order = wc_get_order( $order_id );
//            if ( !empty( $order ) )
//                foreach ($order->get_items() as $item)
//                    $product_id = $item['product_id'];
//        }
//
//        $players_phone  = get_post_meta($order_id, 'players_phone', true);
//
//        if ( empty( $players_phone ) )
//            $players_phone = [get_post_meta($order_id, '_billing_phone', true)];
//
//        foreach ( $players_phone as $player_phone ) {
//
//            $persian        = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
//            $english        = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
//            $player_phone   = str_replace($persian, $english, $player_phone);
//            $player_phone   = preg_replace('/^\+?98|\|98|\D/', '', ($player_phone));
//            $player_phone   = ltrim($player_phone, '0');
//
//            if( !in_array($player_phone, (array)$products_phones[$product_id]) )
//                if (strlen((int)$player_phone) == 10)
//                    $products_phones[$product_id][] = $player_phone;
//        }
//    }
//
//    saeed_store($products_phones);

        /************************************************************************************************/

//    $products_phones = get_option('1703946962135', true);
//
//    foreach ( $products_phones as $product_id => $product_phones ) {
//        $product_phones = implode(',', $product_phones);
//
//        $comments = $wpdb->get_results( "SELECT comment_ID  FROM `wp_comments` WHERE `comment_post_ID` = {$product_id} AND comment_author NOT IN ({$product_phones}) AND comment_approved LIKE 1 AND comment_type = 'review' AND comment_date > '2023-06-01 00:00:00';", ARRAY_A );
//
//        foreach ( $comments as $comment )
//            $comments_arr[] = $comment['comment_ID'];
//    }
//
//
//    saeed_store($comments_arr);

        /************************************************************************************************/

//    $args_query = array (
//        'post_type'         => 'product',
//        'post_status'       => 'publish',
//        'posts_per_page'    => -1,
//        'orderby'           => 'ID',
//        'order'             =>'ASC',
//    );
//    $the_query = new WP_Query( $args_query );
//
//    if ( $the_query->have_posts() ) :
//        while ( $the_query->have_posts() ) : $the_query->the_post();
//        global $product;
//
        //        $product_id = $product->get_id();
        //
        ////        $comments = $wpdb->get_results( "SELECT comment_ID  FROM `wp_comments` WHERE `comment_post_ID` = {$product_id} AND comment_approved LIKE 1 AND comment_type = 'review'", ARRAY_A );
        ////
        ////        $comments_count[$product_id] = 0;
        ////
        ////        foreach ( $comments as $comment )
        ////            $comments_count[$product_id]++;
        //            ;
        //            $comments_count[$product_id] = get_the_terms($product_id, 'product_cat')[0]->name;
        //
//
//        endwhile;
//    endif;
//
//
//    saeed_store($comments_count);

        /************************************************************************************************/
        $args_query = array (
            'post_type'         => 'product',
            'post_status'       => 'publish',
            'posts_per_page'    => -1,
            'orderby'           => 'ID',
            'order'             => 'ASC',
//        'post__in'          => array(2762),
        );
        $the_query = new WP_Query( $args_query );

        if ( $the_query->have_posts() ) :
            while ( $the_query->have_posts() ) : $the_query->the_post();
                global $product;

                $product_id = $product->get_id();

                $comments = $wpdb->get_results( "SELECT *  FROM `wp_comments` WHERE `comment_post_ID` = {$product_id} AND comment_approved LIKE 1 AND comment_type = 'review' AND comment_date > '2023-05-01 17:06:53'", ARRAY_A );

                foreach ( $comments as $comment )
                    if ( $comment['comment_author'] && is_numeric ( $comment['comment_author'] ) )
                        $comments_phones[$product_id][$comment['comment_author']][] = $comment['comment_ID'];

                foreach ( $comments_phones as $product_id => $phones )
                    foreach ( $phones as $phone => $comment_ids )
                        if ( count( $comment_ids ) > 1 )
                            $comments_phones2[$product_id][$phone] = $comment_ids;

            endwhile;
        endif;

        foreach ( $comments_phones2 as $product_id => $phones )
            foreach ( $phones as $phone => $comment_ids )
                foreach ( $comment_ids as $key => $comment_id )
                    if ( $key > 0 )
                        $comments_arr[] = $comment_id;

    }
}
/************************************************************************************************/
function generate_jwt_token($user) {

    $secret_key = defined('JWT_AUTH_SECRET_KEY') ? JWT_AUTH_SECRET_KEY : false;
    $issuedAt   = time();
    $notBefore  = apply_filters('jwt_auth_not_before', $issuedAt, $issuedAt);
    $expire     = apply_filters('jwt_auth_expire', $issuedAt + (DAY_IN_SECONDS * 10000), $issuedAt);

    $token = array(
        'iss' => get_bloginfo('url'),
        'iat' => $issuedAt,
        'nbf' => $notBefore,
        'exp' => $expire,
        'data' => array(
            'user' => array(
                'id' => $user->ID,
            ),
        ),
    );

    $token = \Firebase\JWT\JWT::encode(apply_filters('jwt_auth_token_before_sign', $token, $user), $secret_key);

    return array ( 'token' => $token );
}
/********************************************************************************************************************************/
function ez_authorization( $required ) {

    if ( strpos( $_SERVER['REQUEST_URI'], 'api/v1' ) ) {
        $token = Jwt_Auth_Public::validate_token(false, $required);

        if ( $required )
            if ( is_wp_error($token) )
                wp_send_json_error( array('error' => $token->get_error_message()), $token->error_data[$token->get_error_code()]['status'] );

        return $token;
    }

    return false;
}
/********************************************************************************************************************************/
function get_user_id_by_token ( $token ) {

    if ( !empty ( $token ) )
        return $token->data->user->id;

    return false;
}
/********************************************************************************************************************************/
function get_token_from_header (){

    $auth = isset($_SERVER['HTTP_AUTHORIZATION']) ? $_SERVER['HTTP_AUTHORIZATION'] : false;

    if (!$auth)
        $auth = isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION']) ? $_SERVER['REDIRECT_HTTP_AUTHORIZATION'] : false;

    if (!$auth) {
        return new WP_Error(
            'jwt_auth_no_auth_header',
            'Authorization header not found.',
            array(
                'status' => 401,
            )
        );
    }

    list($token) = sscanf($auth, 'Bearer %s');
    if (!$token) {
        return new WP_Error(
            'jwt_auth_bad_auth_header',
            'Authorization header malformed.',
            array(
                'status' => 401,
            )
        );
    }

    return $token;
}
/********************************************************************************************************************************/
add_action( 'init', 'contact_us_declare' );
function contact_us_declare() {
    $args = array(
        'public' => true,
        'labels' => array (
            'name'          => 'تماس با',
            'singular_name' => 'contacting',
            'search_items'  => 'جستجوی تماس با',
            'edit_item'     => 'پاسخ به تماس با ما',
        ),
        'supports' => array( 'title', 'editor', 'thumbnail' ),
        'rewrite'               => array('slug' => 'contacting'),
        'publicly_queryable'    => false,
        'query_var'             => false,
        'has_archive'           => false,
        'map_meta_cap'          => true,
        'capabilities'          => array (
            'edit_post'             => 'edit_contacting',
            'edit_posts'            => 'edit_contactings',
            'edit_others_posts'     => 'edit_other_contactings',
            'publish_posts'         => 'publish_contactings',
            'read_post'             => 'read_contacting',
            'read_private_posts'    => 'read_private_contactings',
            'delete_post'           => 'delete_contacting',
            'create_posts'          => false,
        ),
        'menu_position'         => 2,
        'menu_icon'             => get_template_directory_uri() . '/img/admin-icon.png',
    );
    register_post_type( 'contacting', $args );
}
/********************************************************************************************************************************/
add_action( 'init', 'ticketing_declare' );
function ticketing_declare() {
    register_post_type( 'ticketing',
        array (
            'labels' => array (
                'name'          => 'تیکت ها',
                'singular_name' => 'ticketing',
                'search_items'  => 'جستجوی تیکت ها',
                'edit_item'     => 'پاسخ به تیکت',
            ),
            'rewrite'               => array('slug' => 'ticketing'), // rewrite url
            'supports'              => array( 'title' ),
            'publicly_queryable'    => false,
            'query_var'             => false,
            'public'                => true,
            'has_archive'           => false,
            'map_meta_cap'          => true,
            'capabilities'          => array (
                'edit_post'             => 'edit_ticket',
                'edit_posts'            => 'edit_tickets',
                'edit_others_posts'     => 'edit_other_tickets',
                'publish_posts'         => 'publish_tickets',
                'read_post'             => 'read_ticket',
                'read_private_posts'    => 'read_private_tickets',
                'delete_post'           => 'delete_ticket',
                'create_posts'          => false,
            ),
            'menu_position'         => 3,
            'menu_icon'             => get_template_directory_uri() . '/img/admin-icon.png',

        )
    );
}
//===================================================//
//add_action( 'admin_init', 'ticketing_submenu_setting' );
//function ticketing_submenu_setting() {
//    register_setting( 'ticketing_submenu_option', 'sz_template_brands_optionsx', 'template_validate_options' );
//}
/********************************************************************************************************************************/
add_action( 'admin_menu', function () { // remove publish button
    remove_meta_box( 'submitdiv', 'ticketing', 'side' );
    remove_meta_box( 'rmp-rate-id', 'ticketing', 'side' );
    remove_meta_box( 'litespeed_meta_boxes', 'ticketing', 'side' );
} );
/********************************************************************************************************************************/
add_action('admin_menu', 'add_submenu_to_ticketing', 10);
function add_submenu_to_ticketing(){
    add_submenu_page(
        'edit.php?post_type=ticketing',
        'مانیتورینگ',
        'مانیتورینگ',
        'manage_options',
        'monitoring',
        'ticket_monitoring_callback_func',
        2
    );
}
/********************************************************************************************************************************/
function ticket_monitoring_callback_func () { ?>

    <div id="tav_wallet_admin_main_wrapper">
        <div id="tav_wallet_admin_main_transaction_table_wrapper">

            <?php
            $departments = [
                "financial" => "مالی",
                "technical" => "فنی",
                "support"   => "پشتیبانی",
            ];

            foreach ( $departments as $key => $department )
                $rates[$key]['rate'] = [];

            $query = new WP_Query(array(
                'post_type'         => 'ticketing',
                'posts_per_page'    => -1
            ));

            if ( $query->have_posts() ) :
                while ($query->have_posts()) : $query->the_post();

                    $ticket_type = get_the_content();
                    $ticket_type = array_search ($ticket_type, $departments);
                    $ticket_rate = get_post_meta(get_the_ID(), 'ticket_rate', true);

                    $rates[$ticket_type]['rate'][] = (int)$ticket_rate;

                endwhile;
                wp_reset_query();  ?>

                <table id="tav_wallet_table">
                    <tr>
                        <th>دپارتمان</th>
                        <th>میانگین امتیاز</th>
                    </tr>

                    <?php
                    foreach ( $rates as $key => $rate ) : ?>

                        <tr>
                            <td><?php echo $departments[$key]; ?></td>
                            <td><?php echo array_sum($rate['rate']) / count($rate['rate']); ?></td>
                        </tr>

                    <?php
                    endforeach; ?>
                </table>

            <?php
            else: ?>
                <p id="tav_wallet_no_transactions"><?php echo 'تیکتی وجود ندارد!' ?></p>
            <?php
            endif; ?>

        </div>
    </div>

    <?php
}
/********************************************************************************************************************************/
add_action( 'add_meta_boxes', 'ticketing_messages_metabox_function' ); // add meta box to specific post type
function ticketing_messages_metabox_function() {
    add_meta_box(
        'ticketing_messages_metabox_function',
        'پیام',
        'ticketing_messages_metabox_content_function',
        'ticketing',
        'normal',
        'high'
    );
    add_meta_box(
        'ticket_messages_metabox_function',
        'وضعیت تیکت',
        'ticket_status_function',
        'ticketing',
        'side',
        'high'
    );
    add_meta_box(
        'ticket_user_info_metabox_function',
        'اطلاعات کاربر',
        'user_info_function',
        'ticketing',
        'side',
        'high'
    );
}
/**********************************/
function ticketing_messages_metabox_content_function( $post ) { // function of content of added metabox
    wp_nonce_field( plugin_basename( __FILE__ ), 'program_price_box_content_nonce' );

    $ticket_id  = $post->ID;
    $messages   = get_post_meta($ticket_id, 'messages', true); ?>

    <div class="chat_content scrollbar" data-simplebar>

        <?php
        foreach ( $messages as $message ) :  ?>

            <div class="chat_date"><span><?php echo jdate("Y/m/d", $message['date']) ?></span></div>

            <div class="chat_message <?php echo $message['user_type']; ?>">
                <div class="msg_content">
                    <div class="bordered_content">
                        <?php
                        foreach ( explode(PHP_EOL, $message['body']) as $msg ) { ?>
                            <p><?php echo !empty($msg) ? $msg : '<br/>' ?></p>
                            <?php
                        } ?>
                    </div>
                    <div class="date"><?php echo date("H:i", $message['date']); ?></div>
                </div>
            </div>

        <?php
        endforeach; ?>

    </div>
    <?php
    $user = wp_get_current_user(); ?>

    <div class="send_message">
        <input type="hidden" id="ticket_id" value="<?php echo $ticket_id ?>">
        <input type="hidden" id="today" value="<?php echo parsidate("Y-m-d", 'now', "eng") ?>">
        <input type="hidden" id="admin_name" value="<?php echo $user->display_name ?>">

        <div class="input_group">
            <textarea id="new_message" cols="10" rows="1" placeholder="پیام مدنظر خودتون رو بنویسید .."></textarea>
        </div>

        <div class="button_group">
            <button type="button" id="new_message_submit" class="button green mb-0">ارسال</button>
        </div>

    </div>

    <style>
        .chat_date {
            position       : relative;
            display        : flex;
            align-items    : center;
            justify-content: center;
            margin         : 20px 0;
        }
        .chat_date:first-child {
            margin-top: 0;
        }
        .chat_date span {
            background: #fff;
            padding   : 0 10px;
            z-index   : 1;
            color     : #b2b3be;
        }
        .chat_date:before {
            content   : "";
            background: #d3d4d9;
            height    : 1px;
            width     : 100%;
            position  : absolute;
            right     : 0;
            top       : 0;
            bottom    : 0;
            margin    : auto;
            z-index   : 0;
        }
        .chat_message {
            display: flex;
            margin : 0 0 5px 0;
        }
        .chat_message.user {
            justify-content: flex-start;
        }
        .chat_message.admin {
            justify-content: flex-end;
        }
        .chat_message .msg_content {
            max-width: 80%;
        }
        .chat_message .msg_content img:not(:last-child) {
            margin: 0 0 5px 0;
        }
        .chat_message .msg_content img {
            border-radius: 15px;
            overflow     : hidden;
        }
        .chat_message .msg_content .bordered_content {
            padding  : 15px;
            font-size: 11pt;
        }
        .chat_message.user .msg_content .bordered_content {
            border       : 1px solid #e5ebf8;
            border-radius: 20px 20px 0 20px;
            background   : #fff;
        }
        .chat_message.admin .msg_content .bordered_content {
            background: #0040ff;
            border-radius: 20px 20px 20px 0;
            color: #fff;
        }
        .chat_message .msg_content .bordered_content p {
            margin: 0 0 5px 0;
        }

        .chat_message .msg_content .date {
            font-size: 9pt;
            color: #acaeb9;
            padding: 3px 15px 0;
        }
        .chat_message.user .msg_content .date {
            text-align: left;
        }
        .send_message {
            display      : flex;
            align-items  : flex-start;
            background   : #F2F2FB;
            padding      : 20px;
            border-radius: 20px;
        }
        .send_message .button_group {
            display: flex;

        }
        .send_message .button_group button {
            padding: 0;
            width: 61px;
            height: 61px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f9700c;
            border: none;
            color: #fff;
            font-weight: bold;
        }
        .send_message .button_group button:hover {
            background: #ff9548;
        }
        .send_message .input_group {
            background-color: #fff;
            display         : flex;
            align-items     : flex-start;
            margin-left     : 15px;
            flex-grow       : 1;
            padding         : 3px 10px;
            border-radius   : 10px;
            overflow        : hidden;
            width: 100%;
        }
        .send_message .input_group .attachment {
            cursor         : pointer;
            display        : flex;
            align-items    : center;
            justify-content: center;
        }
        .send_message .input_group .attachment svg {
            width      : 30px;
            height     : 30px;
            margin-left: 10px;
        }
        .send_message .input_group textarea {
            height    : 55px;
            border    : 0 none !important;
            box-shadow: none !important;
            background: transparent;
            margin    : 0;
            padding   : 10px 0;
            resize    : vertical;
            width: 100%;
        }
        .admin_ticket_last_msg_preview {
            width: 30px;
        }
    </style>

    <script>
        jQuery(document).ready(function($) {
            $('body').on('click', '#new_message_submit', function () {

                var new_message = $("#new_message").val();
                var today       = $("#today").val();
                var last_date   = $('.chat_date:last span').text();

                if ( new_message ) {
                    $("#new_message").val('');

                    var dt      = new Date();
                    var time    = dt.getHours() + ":" + dt.getMinutes();

                    var msg_html = '';
                    if ( last_date !== today ) {
                        msg_html += '<div class="chat_date">';
                        msg_html +=     '<span>' + today + '</span>';
                        msg_html += '</div>';
                    }

                    msg_html += '<div class="chat_message admin">';
                    msg_html +=     '<div class="msg_content">';
                    msg_html +=         '<div class="bordered_content">';
                    msg_html +=             '<p>' + new_message + '</p>';
                    msg_html +=         '</div>';
                    msg_html +=         '<div class="date">' + time + '</div>';
                    msg_html +=     '</div>';
                    msg_html += '</div>';

                    $('.chat_content').append(msg_html);

                    $.ajax({
                        type    : 'POST',
                        url     : "<?php echo admin_url('admin-ajax.php') ?>",
                        data    : {
                            'action'        : 'ez_site_ajax_handler',
                            'nonce'         : "<?php echo wp_create_nonce('ajax-nonce') ?>",
                            '_new_msg_'     : true,
                            'msg_content'   : new_message,
                            'ticket_id'     : $("#ticket_id").val(),
                            'admin_name'    : $("#admin_name").val(),
                        },
                        dataType: "json",
                        success: function(data) {
                        },
                    });
                }
            });
            /********************************************************************************************************************************/
            $('body').on('change', '#ticket_closed', function () {

                $.ajax({
                    type    : 'POST',
                    url     : "<?php echo admin_url('admin-ajax.php') ?>",
                    data    : {
                        'action'                : 'ez_site_ajax_handler',
                        'nonce'                 : "<?php echo wp_create_nonce('ajax-nonce') ?>",
                        '_ticket_closed_'       : true,
                        'ticket_id'             : $("#ticket_id").val(),
                        'ticket_closing_state'  : $(this).prop('checked') ? true : false,
                    },
                    dataType: "json",
                    success: function(data) {

                    },
                });
            });
        });
    </script>

    <?php
}
/**********************************/
function ticket_status_function ( $post ) {
    wp_nonce_field( plugin_basename( __FILE__ ), 'program_price_box_content_nonce' );

    $ticket_id      = $post->ID;
    $ticked_closed  = get_post_meta($ticket_id, 'ticket_closed', true); ?>

    <label for="ticket_closed">بستن تیکت </label>
    <input type="checkbox" id="ticket_closed" name="ticket_closed" value="1" <?php echo checked( 1, $ticked_closed, false ) ?> />
    <?php
}
/**********************************/
function user_info_function ( $post ) {

    $user_id = get_post_field( 'post_author', $post_id );

    $user_phone     = "0" . get_userdata($user_id)->data->display_name;
    $order_list_url = home_url() . "/wp-admin/edit.php?post_status=all&post_type=shop_order&_customer_user=$user_id";
    $user_name      = get_user_meta( $user_id, 'first_name', true ) . ' ' . get_user_meta( $user_id, 'last_name', true ); ?>

    <p>نام: <?php echo $user_name ?></p>
    <p>موبایل: <?php echo $user_phone ?></p>
    <p><a href="<?php echo $order_list_url; ?>">لیست سفارشات</a></p>
    <?php
}
/**********************************/
add_action( 'save_post', 'program_date_box_save' );
function program_date_box_save( $ticket_id ) {

    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )  return;
    if ( !wp_verify_nonce( $_POST['program_price_box_content_nonce'], plugin_basename( __FILE__ ) ) ) return; // CSRD token validation

    if ( 'page' == $_POST['post_type'] )  // whether we are in related post_type page or not
        if ( !current_user_can( 'edit_page', $ticket_id ) ) return;
        else
            if ( !current_user_can( 'edit_post', $ticket_id ) ) return;

    $data_pack['ticket_closed'] = $_POST['ticket_closed']; // get posted data of meta box fields

    foreach ($data_pack as $key => $value)
        update_post_meta( $ticket_id, $key, $value );

}
/**********************************/
add_action( 'admin_head', 'ticketing_admin_seen' );
function ticketing_admin_seen() {
    global $post;

    if ( isset( $post ) && $post->post_type === 'ticketing' && is_admin() && $_GET['action'] === 'edit' )
        update_post_meta($post->ID, 'admin_seen', 1);
}
/**********************************/
add_filter( 'manage_ticketing_posts_columns', 'set_custom_edit_teacher_columns' );
function set_custom_edit_teacher_columns($columns) {
    unset($columns['date']);

    $columns['type']                = 'نوع';
    $columns['status']              = 'وضعیت';
    $columns['last_message']        = 'آخرین پیام';
    $columns['last_message_date']   = 'تاریخ آخرین پیام';
    $columns['date']                = 'تاریخ ایجاد';

    return $columns;
}
/**********************************/
add_action( 'manage_ticketing_posts_custom_column' , 'custom_ticket_column', 10, 2 );// Add the data to the custom columns for the teacher post type:
function custom_ticket_column( $column, $ticket_id ) {

    $messages = get_post_meta($ticket_id, 'messages', true);

    switch ( $column ) {

        case 'type' :
            $ticket_type = get_the_content($ticket_id);
            echo $ticket_type;
            break;

        case 'status' :

            if ( get_post_meta($ticket_id, 'ticket_closed', true) ): ?>
                <span class="ticket_status" style="background: #0a0a0a;color: #fff;padding: 5px 20px;border-radius: 4px;width: 110px;display: flex;justify-content: center;align-items: center;">بسته شده</span>

            <?php
            else :
                if ( get_post_meta($ticket_id, 'respond_user_role', true) == "admin" ) { ?>
                    <span class="ticket_status" style="background: #02ae02;color: #fff;padding: 5px 20px;border-radius: 4px;width: 110px;display: flex;justify-content: center;align-items: center;">پاسخ داده شده</span>

                    <?php
                } elseif ( get_post_meta($ticket_id, 'respond_user_role', true) == "user" && get_post_meta($ticket_id, 'admin_seen', true) ) { ?>

                    <span class="ticket_status" style="background: #ffb326;color: #fff;padding: 5px 20px;border-radius: 4px;width: 110px;display: flex;justify-content: center;align-items: center;">در حال بررسی</span>

                    <?php
                } else { ?>
                    <span class="ticket_status" style="background: #c90303;color: #fff;padding: 5px 20px;border-radius: 4px;width: 110px;display: flex;justify-content: center;align-items: center;">باز</span>
                    <?php
                }

            endif;

            break;

        case 'last_message' :
            $last_msg = end($messages)['body'];

            foreach (explode(PHP_EOL, $last_msg) as $msg)
                echo !empty($msg) ? $msg : '<br/>';

            break;

        case 'last_message_date' :

            $date = end($messages)['date'];
            echo date("H:i", $date) . " | " . jdate("Y/m/d", $date);
            break;
    }
}
/**********************************/
add_filter( 'manage_edit-ticketing_sortable_columns', 'ws_sortable_manufacturer_column' );
function ws_sortable_manufacturer_column( $columns )    {

    $columns['last_message']    = 'last_message';
    $columns['type']            = 'type';

    return $columns;
}
/**********************************/
add_action( 'admin_menu', 'pending_posts_bubble_wpse_89028', 999 );
function pending_posts_bubble_wpse_89028() {
    global $menu;

    $args = array( 'public' => true );
    $post_types = get_post_types( $args );

    foreach( $post_types as $pt ) {
        if ( $pt == 'ticketing' ) {
            $cpt_count = wp_count_posts( $pt );

            if ( $cpt_count->pending ) {
                $suffix = ( 'post' == $pt ) ? '' : "?post_type=$pt";
                $key = recursive_array_search_php_91365( "edit.php$suffix", $menu );

                if ( !$key ) return;

                $menu[$key][0] .= sprintf(
                    '<span class="update-plugins count-%1$s" style="background-color:#d63638;color:white"><span class="plugin-count">%1$s</span></span>',
                    $cpt_count->pending
                );
            }
        }
    }
}
//********************************************************/
function recursive_array_search_php_91365( $needle, $haystack ) {
    foreach( $haystack as $key => $value ) {
        $current_key = $key;
        if( $needle === $value OR ( is_array( $value ) && recursive_array_search_php_91365( $needle, $value ) !== false ) ) {
            return $current_key;
        }
    }
    return false;
}
//********************************************************/
add_filter( 'views_edit-ticketing', 'wpse246143_add_admin_quick_link' );
function wpse246143_add_admin_quick_link( $views ) {
    $post_type = 'ticketing';

    if ( ! isset( $_GET['post_type'] ) || $post_type !== $_GET['post_type'] )
        return $views;

    $link_class = false;
    if ( isset( $_GET['waiting'] ) && 'true' === $_GET['waiting'] )
        $link_class = 'current';

    $cpt_count = wp_count_posts( $post_type );

    $result = new WP_Query( [
        'post_type'  => $post_type,
        'orderby'    => 'date',
        'order'      => 'DESC',
        'meta_key'   => 'ticket_type',
        'meta_value' => 'اعلام مغایرت',
    ] );

    // Generate the link for our filter.
    $views['ticketing_waiting'] = sprintf( '<a href="%s" class="%s">%s<span class="count">(%d)</span></a>',
        admin_url( "edit.php?post_type={$post_type}&waiting=true" ),
        $link_class,
        'در انتظار',
        $result->found_posts
    );

    return $views;
}
/*=========================================*/
add_action( 'init', 'wpse246143_register_waiting' );
function wpse246143_register_waiting() {
    global $wp;

    $wp->add_query_var( 'waiting' );
}
/*=========================================*/
add_action( 'parse_query', 'wpse246143_map_waiting' );
function wpse246143_map_waiting( $wp_query ) {
    $meta_value = $wp_query->get( 'waiting' );

    if ( true == $meta_value ) {
        $wp_query->set( 'meta_key', 'waiting' );
        $wp_query->set( 'meta_value', $meta_value );
    }
}
/********************************************************************************************************************************/
function change_default_upload_dir_for_customer_files ( $dirs ) {

    $dirs['subdir'] = '/customer_files';
    $dirs['path']   = $dirs['basedir'] . '/customer_files';
    $dirs['url']    = $dirs['baseurl'] . '/customer_files';

    return $dirs;
}
/********************************************************************************************************************************/
function change_default_upload_dir_for_customer_files_self_destruct ( $dirs ) {

    $dirs['subdir'] = '/customer_files_sd';
    $dirs['path']   = $dirs['basedir'] . '/customer_files_sd';
    $dirs['url']    = $dirs['baseurl'] . '/customer_files_sd';

    return $dirs;
}
/********************************************************************************************************************************/
function customer_files_name ($dir, $name, $ext){
    return floor(microtime(true) * 1000) . $ext;
}
/********************************************************************************************************************************/
function customer_files_self_destruct_function() {
    $directory = wp_upload_dir()['basedir'] . '/customer_files_sd/';

    foreach (scandir($directory) as $file)
        if (is_file($directory . $file))
            if ($file < time() - (10 * 24 * 60 * 60))
                unlink($directory . $file);
}
/****************************************************************************************************************************************/
add_action('add_meta_boxes', 'special_discount');
function special_discount() {
    add_meta_box(
        'special_discount',
        'تخفیف ویژه',
        'special_discount_func',
        'product',
        'normal',
        'high'
    );
}
/*============================================================*/
function special_discount_func ($post) {

    $special_discount_enable        = get_post_meta($post->ID, 'special_discount_enable', true);
    $special_discount_percentage    = get_post_meta($post->ID, 'special_discount_percentage', true);
    $special_discount_date          = get_post_meta($post->ID, 'special_discount_date', true); ?>

    <div class="reservation_info_section_wrapper">
        <label style="width: 120px;display: inline-block;">فعال: </label>
        <input type="checkbox" name="special_discount_enable" <?php echo checked( 1, $special_discount_enable, false ); ?> >
    </div>

    <div class="reservation_info_section_wrapper">
        <label style="width: 120px;display: inline-block;">درصد: </label>
        <input type="text" name="special_discount_percentage" style="width: 210px;" value="<?php echo $special_discount_percentage; ?>" >
    </div>

    <div class="reservation_info_section_wrapper">
        <label style="width: 120px;display: inline-block;">تا تاریخ: </label>
        <input type="datetime-local" name="special_discount_date" style="width: 210px;" value="<?php echo $special_discount_date ? date('Y-m-d\TH:i', $special_discount_date) : ''; ?>" >
    </div>

    <?php
}
/*============================================================*/
add_action('save_post', 'special_discount_save_func', 10, 1);
function special_discount_save_func($product_id) {

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $product_id)) return;

    if (isset($_POST['special_discount_enable']))
        update_post_meta($product_id, 'special_discount_enable', 1);
    else
        update_post_meta($product_id, 'special_discount_enable', 0);

    if (isset($_POST['special_discount_percentage']))
        update_post_meta($product_id, 'special_discount_percentage', sanitize_text_field($_POST['special_discount_percentage']));

    if (isset($_POST['special_discount_date']))
        update_post_meta($product_id, 'special_discount_date', sanitize_text_field(strtotime( $_POST['special_discount_date'] )));

    if (isset($_POST['special_discount_enable']))
        $discount_data = [
            'special_discount_percentage'   => $_POST['special_discount_percentage'],
            'special_discount_date'         => strtotime( $_POST['special_discount_date'] ),
        ];
    else
        $discount_data = [];

    ez_webservice( array('type' => 'update_product_discount_data', 'data' => array('product_id' => $product_id, 'discount_data' => $discount_data)) );

    if (isset($_POST['tax_input']['yith_product_brand']))
        update_post_meta($product_id, 'product_brand', sanitize_text_field($_POST['tax_input']['yith_product_brand'][1]));
}
/********************************************************************************************************************************/
add_role(
    'sans_manager',
    'مدیر سانس',
    array(
        'read'          => true,  // true allows this capability
        'edit_posts'    => false,
    )
);
/********************************************************************************************************************************/
add_filter('admin_footer_text', 'remove_footer_admin');
function remove_footer_admin () {
    echo '<span id="footer-thankyou"></a></span>';
}
/********************************************************************************************************************************/
function prevent_submission_by_refresh() { ?>
    <script type="text/javascript">
        if ( window.history.replaceState )
            window.history.replaceState( null, null, window.location.href );
    </script>
    <?php
}
/********************************************************************************************************************************/
function trim_home_url($url) {
    return str_replace(home_url(), '', $url);
}
/********************************************************************************************************************************/
$admin_role = get_role( 'shopist' );
$admin_role->add_cap( 'shopist_cap', true );
/********************************************************************************************************************************/
add_action('add_meta_boxes', 'product_videos_metabox');
function product_videos_metabox() {
    add_meta_box(
        'product_videos_metabox',
        'ویدئوها',
        'product_videos_metabox_frontend',
        'product',
        'side',
        'high'
    );
}
/*-----------------------------------------------------------------------*/
function product_videos_metabox_frontend($post) {
    $introduction   = get_post_meta($post->ID, 'introduction', true);
    $teaser         = get_post_meta($post->ID, 'teaser', true);

    if (!$introduction) $introduction = [];
    if (!$teaser) $teaser = [];

    wp_nonce_field('product_videos_metabox_action', 'product_videos_metabox'); ?>

    <div id="product_videos_metabox">
        <h3>ویدئو معرفی</h3>
        <input type="text" name="introduction[title]" value="<?php echo esc_attr($introduction['title'] ?? ''); ?>" placeholder="عنوان" />
        <input type="text" name="introduction[video_id]" value="<?php echo esc_attr($introduction['video_id'] ?? ''); ?>" placeholder="آی دی ویدئو" />
        <br /><hr>

        <h3>ویدئو تیزر</h3>
        <input type="text" name="teaser[title]" value="<?php echo esc_attr($teaser['title'] ?? ''); ?>" placeholder="عنوان" />
        <input type="text" name="teaser[video_id]" value="<?php echo esc_attr($teaser['video_id'] ?? ''); ?>" placeholder="آی دی ویدئو" />
        <br />
    </div>

    <?php
}
/*-----------------------------------------------------------------------*/
add_action('save_post_product', 'save_product_videos_metabox_data');
function save_product_videos_metabox_data($post_id) {
    global $wpdb;

    if (!isset($_POST['product_videos_metabox']) || !wp_verify_nonce($_POST['product_videos_metabox'], 'product_videos_metabox_action')) return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    $terms = get_the_terms($post_id, 'product_cat');
    if ( count( $terms ) > 1 ) {
        foreach ( $terms as $term )
            if ( $term->parent == 0 )
                $product_type = $term->name;
    } else
        $product_type = get_term($terms[0]->parent)->name;

    if (isset($_POST['introduction'])) {
        update_post_meta($post_id, 'introduction', $_POST['introduction']);

        $video_id       = $_POST['introduction']['video_id'];
        $video_title    = $_POST['introduction']['title'];
        $video_tag      = 'ویدئو معرفی ' . $product_type;
        $created_at     = time();

        if ( !empty($video_title) || !empty($video_id) ) :

            $existing_record = $wpdb->get_row($wpdb->prepare("SELECT video_id, video_title FROM escapezoom_videos WHERE video_tag = %s AND post_id = %d", $video_tag, $post_id));
            if ($existing_record) {
                if ($existing_record->video_id !== $video_id || $existing_record->video_title !== $video_title) {
                    $wpdb->update(
                        'escapezoom_videos',
                        [
                            'video_id'    => $video_id,
                            'video_title' => $video_title,
                            'created_at'  => $created_at,
                        ],
                        [
                            'video_tag' => $video_tag,
                            'post_id'   => $post_id,
                        ]
                    );
                }

            } else {
                $wpdb->insert(
                    'escapezoom_videos',
                    [
                        'post_id'     => $post_id,
                        'video_id'    => $video_id,
                        'video_title' => $video_title,
                        'video_tag'   => $video_tag,
                        'created_at'  => $created_at,
                    ]
                );
            }

        endif;
    }

    if (isset($_POST['teaser'])) {
        update_post_meta($post_id, 'teaser', $_POST['teaser']);

        $video_id       = $_POST['teaser']['video_id'];
        $video_title    = $_POST['teaser']['title'];
        $video_tag      = 'تیزر ' . $product_type;
        $created_at     = time();

        if ( !empty($video_title) || !empty($video_id) ) :

            $existing_record = $wpdb->get_row($wpdb->prepare("SELECT video_id, video_title FROM escapezoom_videos WHERE video_tag = %s AND post_id = %d", $video_tag, $post_id));
            if ($existing_record) {
                if ($existing_record->video_id !== $video_id || $existing_record->video_title !== $video_title) {
                    $wpdb->update(
                        'escapezoom_videos',
                        [
                            'video_id'    => $video_id,
                            'video_title' => $video_title,
                            'created_at'  => $created_at,
                        ],
                        [
                            'video_tag' => $video_tag,
                            'post_id'   => $post_id,
                        ]
                    );
                }

            } else {
                $wpdb->insert(
                    'escapezoom_videos',
                    [
                        'post_id'     => $post_id,
                        'video_id'    => $video_id,
                        'video_title' => $video_title,
                        'video_tag'   => $video_tag,
                        'created_at'  => $created_at,
                    ]
                );
            }

        endif;
    }
}
/********************************************************************************************************************************/
add_action('add_meta_boxes', 'monopoly_metabox');
function monopoly_metabox() {
    add_meta_box(
        'monopoly_metabox',
        'زوم کلاب',
        'monopoly_metabox_frontend',
        'product',
        'side',
        'high'
    );
}
/*-----------------------------------------------------------------------*/
function monopoly_metabox_frontend($post) {
    $monopoly = get_post_meta($post->ID, 'monopoly', true);

    wp_nonce_field('monopoly_metabox_action', 'monopoly_metabox'); ?>

    <div id="monopoly_metabox">
        <h3>زوم کلاب؟</h3>
        <input type="checkbox" name="monopoly_product" value="1" <?php echo checked( 1, $monopoly, false ) ?>>
    </div>

    <?php
}
/*-----------------------------------------------------------------------*/
add_action('save_post_product', 'save_monopoly_metabox_data');
function save_monopoly_metabox_data($post_id) {

    if (!isset($_POST['monopoly_metabox']) || !wp_verify_nonce($_POST['monopoly_metabox'], 'monopoly_metabox_action')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    update_post_meta($post_id, 'monopoly', isset($_POST['monopoly_product']) ? 1 : 0);
}
/********************************************************************************************************************************/
add_action('show_user_profile', 'withdrawal_owner_profile_fields');
add_action('edit_user_profile', 'withdrawal_owner_profile_fields');
function withdrawal_owner_profile_fields($user) { ?>
    <h3>اطلاعات حساب کاربر</h3>

    <table class="form-table">
        <tr>
            <th><label for="withdrawal_owner_name">نام مالک حساب</label></th>
            <td><input type="text" name="withdrawal_owner_name" id="withdrawal_owner_name" value="<?php echo esc_attr(get_the_author_meta('withdrawal_owner_name', $user->ID)); ?>" class="regular-text" /></td>
        </tr>
        <tr>
            <th><label for="withdrawal_owner_shaba">شبا مالک حساب</label></th>
            <td><input type="text" name="withdrawal_owner_shaba" id="withdrawal_owner_shaba" value="<?php echo esc_attr(get_the_author_meta('withdrawal_owner_shaba', $user->ID)); ?>" class="regular-text" /></td>
        </tr>
        <tr>
            <th><label for="withdrawal_owner_shaba">کدملی مالک حساب</label></th>
            <td><input type="text" name="withdrawal_owner_identity_card" id="withdrawal_owner_identity_card" value="<?php echo esc_attr(get_the_author_meta('withdrawal_owner_identity_card', $user->ID)); ?>" class="regular-text" /></td>
        </tr>
    </table>
    <?php
}
/*-----------------------------------------------------------------------------------------------*/
add_action('personal_options_update', 'save_withdrawal_owner_profile_fields');
add_action('edit_user_profile_update', 'save_withdrawal_owner_profile_fields');
function save_withdrawal_owner_profile_fields($user_id) {
    if ( !current_user_can('edit_user', $user_id) )
        return false;

    update_user_meta($user_id, 'withdrawal_owner_name', sanitize_text_field($_POST['withdrawal_owner_name']));
    update_user_meta($user_id, 'withdrawal_owner_shaba', sanitize_text_field($_POST['withdrawal_owner_shaba']));
    update_user_meta($user_id, 'withdrawal_owner_identity_card', sanitize_text_field($_POST['withdrawal_owner_identity_card']));
}

/********************************************************************************************************************************/
add_action('add_meta_boxes', 'product_content_metabox');
function product_content_metabox() {
    add_meta_box('product_introduction_text_metabox', 'چکیده معرفی', 'product_introduction_text_metabox_frontend', 'product', 'normal', 'low');
    add_meta_box('product_scenario_metabox', 'سناریو', 'product_scenario_metabox_frontend', 'product', 'normal', 'low');
    add_meta_box('product_rules_metabox','قوانین','product_rules_metabox_frontend','product','normal','low');
    add_meta_box('product_introduction_video_metabox', 'ویدیو معرفی', 'product_introduction_video_metabox_frontend', 'product', 'normal', 'low');
}
/*-----------------------------------------------------------------------*/
function product_introduction_text_metabox_frontend($post) {
    $product_introduction_text = get_post_meta($post->ID, 'product_introduction_text', true);

    wp_editor($product_introduction_text, 'product_introduction_text_editor', array(
        'textarea_name' => 'product_introduction_text',
        'media_buttons' => true,
        'textarea_rows' => 5,
    ));
}
/*-----------------------------------------------------------------------*/
function product_scenario_metabox_frontend($post) {
    $product_scenario = get_post_meta($post->ID, 'product_scenario', true);

    wp_editor($product_scenario, 'product_scenario_editor', array(
        'textarea_name' => 'product_scenario',
        'media_buttons' => true,
        'textarea_rows' => 5,
    ));
}
/*-----------------------------------------------------------------------*/
function product_rules_metabox_frontend($post) {
    $product_rules = get_post_meta($post->ID, 'product_rules', true);

    wp_editor($product_rules, 'product_rules_editor', array(
        'textarea_name' => 'product_rules',
        'media_buttons' => true,
        'textarea_rows' => 5,
    ));
}
/*-----------------------------------------------------------------------*/
function product_introduction_video_metabox_frontend($post) {
    $product_introduction_video = get_post_meta($post->ID, 'product_introduction_video', true);

    wp_editor($product_introduction_video, 'product_introduction_video_editor', array(
        'textarea_name' => 'product_introduction_video',
        'media_buttons' => false,
        'textarea_rows' => 5,
    ));
}
/*-----------------------------------------------------------------------*/
add_action('save_post_product', 'save_product_content_metabox_data');
function save_product_content_metabox_data($post_id) {

    update_post_meta($post_id, 'product_introduction_text', $_POST['product_introduction_text']);
    update_post_meta($post_id, 'product_scenario', $_POST['product_scenario']);
    update_post_meta($post_id, 'product_rules', $_POST['product_rules']);
    update_post_meta($post_id, 'product_introduction_video', $_POST['product_introduction_video']);
}
/********************************************************************************************************************************/
function persianToEnglish($number) {
    return str_replace(['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'], ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], $number);
}
/********************************************************************************************************************************/
function englishToPersian($number) {
    return str_replace(['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'], ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'], $number);
}
/********************************************************************************************************************************/
function normalizePhoneNumber($number) {
    $number = preg_replace('/\D/', '', persianToEnglish($number));

    if (strpos($number, '98') === 0)
        $number = substr($number, 2);
    elseif (strpos($number, '0') === 0)
        $number = substr($number, 1);
    elseif (strpos($number, '+98') === 0)
        $number = substr($number, 3);

    if (strlen($number) == 10)
        return '0' . $number;
    elseif (strlen($number) == 11 && $number[0] === '9')
        return $number;

    return false;
}
/********************************************************************************************************************************/
function isValidIranianMobileNumber($number) {
    return preg_match('/^09\d{9}$/', $number) === 1;
}
/********************************************************************************************************************************/
function ez_login_automatically($user) {

    try {
        if (is_user_logged_in())
            wp_logout();

        if ( !is_wp_error($user) ) {

            if ( $user ) {

                $user_id = $user->ID;

                wp_clear_auth_cookie();
                wp_set_current_user($user_id);
                wp_set_auth_cookie($user_id);
//
//                if ( isset( $_GET['ref'] ) && $_GET['ref'] == 'checkout' )
//                    wp_redirect( home_url('checkout') );
//                else
//                    wp_redirect( home_url('my-account') );
            }

            if (is_user_logged_in())
                return true;
        }

    } catch (Exception $e) {
        echo $e->getMessage();
        return false;
    }

    return false;
}
/********************************************************************************************************************************/
function ez_get_product_meta($product_id) {

    $terms = get_the_terms($product_id, 'product_cat') ? : [];
    if ( count( $terms ) > 1 ) {

        foreach ( $terms as $term ) {
            if ( $term->parent == 0 )
                $product_type = $term->name;

            else {
                $city_name  = $term->name;
                $city_id    = $term->term_id;
            }
        }

    } else {
        $product_type   = get_term($terms[0]->parent)->name;
        $city_name      = $terms[0]->name;
        $city_id        = $terms[0]->term_id;
    }

    $data = new stdClass();

    $data->product_type = $product_type;
    $data->city_name    = $city_name;
    $data->city_id      = $city_id;

    return $data;
}
/********************************************************************************************************************************/
add_filter( 'gettext', 'change_product_short_description_title', 20, 3 );
function change_product_short_description_title( $translated_text, $text, $domain ) {
    if ( 'woocommerce' === $domain && 'Product short description' === $text ) {
        $translated_text = 'نقد';
    }
    return $translated_text;
}
/********************************************************************************************************************************/
add_filter('woocommerce_coupon_is_valid', 'restrict_coupon_to_user_ids', 10, 2);
function restrict_coupon_to_user_ids($valid, $coupon) {

    $allowed_user_ids = get_post_meta($coupon->get_id(), 'user_ids', true);
    if ( empty( $allowed_user_ids ) )
        return $valid;

    if ( !in_array(get_current_user_id(), explode(',', $allowed_user_ids)) ) {
        $valid = false;

        add_action('woocommerce_coupon_error', function () {return;}); // suppress all coupon errors if there is a user ids restriction error

        wc_add_notice('شما در لیست کاربران این کدتخفیف نیستید!', 'error');
    }

    return $valid;
}
/********************************************************************************************************************************/
add_filter('woocommerce_coupon_is_valid', 'first_bought_coupon', 10, 2);
function first_bought_coupon($valid, $coupon) {

    $first_bought = get_post_meta($coupon->get_id(), 'first_bought', true); // if this coupon checked as the coupon for first bought users
    if ( !isset($first_bought) || empty($first_bought) )
        return $valid;

    if ( if_user_has_bought(get_current_user_id()) ) {
        $valid = false;

        add_action('woocommerce_coupon_error', function () {return;}); // suppress all coupon errors if there is a user ids restriction error

        wc_add_notice('این کد مخصوص خرید اولی هاست!', 'error');
    }

    return $valid;
}
/********************************************************************************************************************************/
add_action('woocommerce_coupon_options_usage_restriction', 'add_usage_restriction_user_ids'); // افزودن محدودیت کاربران برای استفاده از یک کدتخفیف
function add_usage_restriction_user_ids() {
    woocommerce_wp_textarea_input([
        'id'          => 'usage_restriction_text',
        'label'       => 'لیست کاربران (user_ids)',
        'desc_tip'    => true,
        'description' => 'لیست user id ها را اینجا بنویسید و با کاما جدا کنید',
        'value'       => get_post_meta(get_the_ID(), 'user_ids', true)
    ]);

    woocommerce_wp_checkbox([
        'id'            => 'usage_restriction_checkbox',
        'label'         => 'فقط خرید اولی ها',
        'description'   => 'از این آپشن فقط زمانی استفاده کنید که قصد دارید کدتخفیفی را برای خرید اولی ها اختصاص بدهید.',
        'value'         => get_post_meta(get_the_ID(), 'first_bought', true) ? 'yes' : ''
    ]);
}
/******************************/
add_action('woocommerce_coupon_options_save', 'save_coupon_usage_restriction');
function save_coupon_usage_restriction($post_id) {

    if (isset($_POST['usage_restriction_text']) and !empty($_POST['usage_restriction_text']))
        update_post_meta($post_id, 'user_ids', sanitize_textarea_field($_POST['usage_restriction_text']));
    else
        delete_post_meta($post_id, 'user_ids');

    if (isset($_POST['usage_restriction_checkbox']))
        update_post_meta($post_id, 'first_bought', ($_POST['usage_restriction_checkbox'] === 'yes') ? 'yes' : 'no');
    else
        delete_post_meta($post_id, 'first_bought');
}
/********************************************************************************************************************************/
function if_user_has_bought($user_id) {

    $customer_orders = get_posts( array(
        'numberposts' => -1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $user_id,
        'post_type'   => 'shop_order',
//        'post_status' => array('wc-partially-paid', 'wc-walletx', 'wc-completed')
        'post_status' => array('wc-completed', 'wc-in-progress', 'in-progress')
    ));

    return count( $customer_orders ) > 0 ? true : false;
}
/********************************************************************************************************************************/
add_action('wp', 'emergency_phones_change');
function emergency_phones_change() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['numberonecontact']) && isset($_POST['numbertwocontact']) && isset($_POST['numberthreecontact'])) {
        $number_one = sanitize_text_field($_POST['numberonecontact']);
        $number_two = sanitize_text_field($_POST['numbertwocontact']);
        $number_three = sanitize_text_field($_POST['numberthreecontact']);

        update_option('numberonecontact', $number_one);
        update_option('numbertwocontact', $number_two);
        update_option('numberthreecontact', $number_three);
    }
}
/********************************************************************************************************************************/
function get_product_type_equivalent($product_type) {
    $product_types = [
        'escaperoom'    => 'اتاق فرار',
        'cinema'        => 'سینما ترس',
        'lasertag'      => 'لیزرتگ',
        'rageroom'      => 'اتاق خشم',
    ];

    if (array_key_exists($product_type, $product_types)) // if parameter is English
        return $product_types[$product_type];

    return array_search($product_type, $product_types);
}
/********************************************************************************************************************************/
add_filter('use_block_editor_for_post_type', 'disable_gutenberg_for_pages', 10, 2);
function disable_gutenberg_for_pages($use_block_editor, $post_type) {
    if ($post_type === 'page')
        return false;

    return $use_block_editor;
}
/********************************************************************************************************************************/
add_action('add_meta_boxes', 'city_page_product_categories_meta_box');
function city_page_product_categories_meta_box() {
    add_meta_box(
        'city_page_product_categories',
        'صفحه شهر',
        'display_city_page_product_categories_meta_box',
        'page',
        'side',
    );
}
/****************/
function display_city_page_product_categories_meta_box($post) {
    $selected_categories = get_post_meta($post->ID, 'city_page_product_categories', true);
    $selected_categories = !empty($selected_categories) ? (array) $selected_categories : [];

    $assign_as_city_page = get_post_meta($post->ID, 'assign_as_city_page', true);

    $categories = get_terms([
        'taxonomy'   => 'product_cat',
        'hide_empty' => false,
    ]); ?>

    <label for="assign_as_city_page" style="margin: 20px 0;display: inline-block;cursor:pointer;">
        <input type="checkbox" id="assign_as_city_page" name="assign_as_city_page" value="1" <?php checked($assign_as_city_page, '1'); ?>>
        اختصاص به عنوان صفحه شهر
    </label>

    <select name="city_page_product_categories[]" multiple="multiple" style="width:100%; height: 150px;" class="city_page_product_categories">
        <?php foreach ($categories as $category):
            $selected = in_array($category->term_id, $selected_categories) ? 'selected="selected"' : ''; ?>
            <option value="<?php echo esc_attr($category->term_id); ?>" <?php echo $selected; ?>><?php echo $category->name . ' (' . get_parent_category_name_by_child_id($category->term_id) . ')'; ?></option>
        <?php endforeach; ?>
    </select>

    <?php
    if ( !$assign_as_city_page ) : ?>
        <style>
            .city_page_product_categories + .select2 {
                display: none;
            }
        </style>
    <?php
    endif; ?>

    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('.city_page_product_categories').select2({
                placeholder: "انتخاب کنید...",
                allowClear: true
            });

            $('body').on('change', '#assign_as_city_page', function(){
                if($(this).is(':checked'))
                    $('.city_page_product_categories').siblings('.select2').show();
                else
                    $('.city_page_product_categories').siblings('.select2').hide();
            });

        });
    </script>
    <?php
}
/****************/
add_action('save_post', 'save_city_page_product_categories_meta_box');
function save_city_page_product_categories_meta_box($post_id) {
    if (isset($_POST['city_page_product_categories']))
        update_post_meta($post_id, 'city_page_product_categories', $_POST['city_page_product_categories']);
    else
        delete_post_meta($post_id, 'city_page_product_categories');

    if (isset($_POST['assign_as_city_page']))
        update_post_meta($post_id, 'assign_as_city_page', '1');
    else
        delete_post_meta($post_id, 'assign_as_city_page');
}
/********************************************************************************************************************************/
function get_parent_category_name_by_child_id($child_term_id) {
    $child_term = get_term($child_term_id, 'product_cat');

    if ($child_term && !is_wp_error($child_term) && $child_term->parent) {
        $parent_term = get_term($child_term->parent, 'product_cat');

        if ($parent_term && !is_wp_error($parent_term))
            return  $parent_term->name;
    }

    return '';
}
/********************************************************************************************************************************/
add_filter('comment_form_default_fields', function ($fields) {
    if(isset($fields['email'])){
        unset($fields['email']);
    }
    if(isset($fields['cookies'])){
        unset($fields['cookies']);
    }
    return $fields;
});
/********************************************************************************************************************************/
if ( isset( $_GET['total_income'] ) ) {

    add_action('init', function() {

        $args = array (
            'post_type'         => 'product',
            'posts_per_page'    => -1,
            'meta_query'        => array (
                array(
                    'key'     => 'sale_active',
                    'value'   => 1,
                    'compare' => 'LIKE',
                ),
            ),
            'post__in' => [5104],
            'post__not_in' => array(336907,335012,
                336796,
                559480,
                569898,
                571867,
                571892,
                571909,
                571931,
                339346,
                337994,
                334025,
                340744,
                343323,
                343362,
                343501,
                333842,
                7878,
                345947,
                346334,
                346356,
                336417,
                353935,
                354307,
                354862,
                355123,
                342044,
                365195,
                365808,
                334139,
                366766,
                368021,
                2108,
                368764,
                1322,
                371273,
                373449,
                375947,
                378387,
                380685,
                380811,
                380818,
                380897,
                381813,
                381857,
                382454,
                383915,
                404211,
                570305,
                385758,
                166363,
                387776,
                387917,
                388349,
                388357,
                389393,
                390007,
                390782,
                2048,
                392887,
                393056,
                395598,
                401740,
                403561,
                403881,
                91070,
                405670,
                344615,
                408583,
                408701,
                409393,
                415193,
                415202,
                2063,
                415200,
                416772,
                418306,
                73114,
                420707,
                423249,
                423655,
                425891,
                425904,
                427014,
                431286,
                434106,
                434173,
                434183,
                436455,
                436461,
                1836,
                70591,
                438905,
                438939,
                438986,
                439951,
                439899,
                440233,
                440264,
                440282,
                440306,
                440644,
                441008,
                441662,
                441697,
                442825,
                443258,
                443952,
                444939,
                445620,
                446144,
                446260,
                440966,
                447595,
                447851,
                447862,
                447890,
                455070,
                457309,
                52537,
                13260,
                462946,
                463454,
                35043,
                464782,
                465393,
                465606,
                465643,
                465881,
                466813,
                466829,
                464817,
                468476,
                1461,
                469271,
                469478,
                1512,
                3720,
                70653,
                471992,
                1848,
                472070,
                472094,
                472130,
                472428,
                472441,
                474463,
                474742,
                474755,
                475732,
                1649,
                479745,
                480335,
                481097,
                481623,
                482084,
                482102,
                482367,
                482354,
                482465,
                482176,
                483708,
                485312,
                486773,
                488019,
                488078,
                488213,
                488633,
                488731,
                489211,
                489206,
                490096,
                491931,
                491990,
                492865,
                496053,
                496526,
                498283,
                498398,
                499441,
                499528,
                500030,
                501677,
                503500,
                443595,
                507937,
                508099,
                510362,
                510400,
                511033,
                511359,
                512498,
                514059,
                514198,
                514467,
                514476,
                516040,
                517286,
                519646,
                520886,
                520909,
                521030,
                521994,
                522070,
                2150,
                523765,
                526417,
                526462,
                526533,
                527026,
                529037,
                529069,
                529114,
                529174,
                529497,
                529528,
                530286,
                530358,
                530424,
                530513,
                530474,
                531587,
                532638,
                533504,
                533541,
                533611,
                536881,
                536897,
                537164,
                537433,
                537519,
                538155,
                538135,
                539299,
                1897,
                539509,
                539512,
                539564,
                539608,
                539626,
                539644,
                540523,
                541302,
                542432,
                542937,
                490170,
                543509,
                543526,
                545575,
                545551,
                545857,
                545907,
                547098,
                547107,
                547651,
                547858,
                547884,
                547917,
                549492,
                550112,
                550336,
                550362,
                550798,
                552205,
                552234,
                552282,
                552818,
                552832,
                553048,
                553064,
                553078,
                553178,
                553456,
                553555,
                553892,
                553932,
                553972,
                554002,
                554726,
                554746,
                549467,
                555000,
                555557,
                555640,
                555929,
                557147,
                557202,
                557545,
                557556,
                557614,
                557627,
                557806,
                558538,
                558564,
                559430,
                559446,
                559461,
                560245,
                560272,
                561000,
                560621,
                559903,
                560596,
                560327,
                560230,
                561020,
                561050,
                561118,
                561173,
                561265,
                562039,
                562085,
                562523,
                562546,
                562579,
                562624,
                562825,
                563170,
                563319,
                564585,
                565108,
                565355,
                565432,
                565593,
                565611,
                565647,
                565661,
                565684,
                565834,
                567154,
                567760,
                567776,
                567828,
                568026,
                568356,
                568692,
                569212,
                569550,
                569649,
                569861,
                570278,
                570316,
                570352,
                570740,
                570822,)
        );
        $loop = new WP_Query( $args );

        while ( $loop->have_posts() ) : $loop->the_post();
            $product_id = get_the_ID();

            $total_income = 0;

            $orders_id = get_orders_ids_by_product_id([$product_id], ['wc-walletx', 'wc-completed']);

            foreach ( $orders_id as $order_id ) {
                $order = wc_get_order($order_id);

                $args = [
                    "single_value"  => true,
                    "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id",
                ];
                $row = (array)json_decode(ez_reservation( array ('type' => 'query_execution', 'data' => $args) ));

                if ( !$row['booked_time'] ) // order has a bug (sans didn't issue for it)
                    continue;

                foreach ($order->get_items() as $item) {
                    $product_id = $item->get_product_id();
                    $quantity   = $item->get_quantity();
                }

                $pish_per_person    = get_post_meta( $order_id, 'ticket_tedad', true );
                $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : get_post_meta( $product_id, 'pish_pardakht_per_person', true );
                $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;

                $pish       = get_post_meta( $order_id, "_order_total_2", true );
                $pish_final = $pish ? : get_post_meta( $order_id, "_order_total", true );

                $total_income += $pish_final / $pish_per_person * $quantity;
            }

            update_post_meta($product_id, 'total_income', $total_income);

        endwhile;
        wp_reset_postdata();
    });
}
/********************************************************************************************************************************/

if ( isset( $_GET['upload_file_test'] ) ) { ?>

    <form method="post" action="https://escapezoom.ir/api/v1/user/upload_self_destruct/" enctype="multipart/form-data">
        <input type="file" name="fileToUpload" id="fileToUpload" multiple>
        <input type="submit" value="Upload Image" name="submit">
    </form>
    <form method="post" action="https://escapezoom.ir/api/v1/user/upload/" enctype="multipart/form-data">
        <input type="file" name="fileToUpload" id="fileToUpload">
        <input type="submit" value="Upload Image" name="submit">
    </form>

    <?php
}

//add_filter('get_the_terms', 'custom_modify_tag_title', 10, 3);
function custom_modify_tag_title($terms, $post_id, $taxonomy) {
    if ($taxonomy === 'product_tag' && is_array($terms))
        foreach ($terms as $key => $term)
            if (str_contains($term->name, '|||||'))
                $terms[$key]->name = str_replace('|||||', '', $term->name);

    return $terms;
}

if ( isset( $_GET['get_duplicate_transactions'] ) ) {
    global $wpdb, $wldb;

    $transactions = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `wallet_transactions` WHERE `created_at` > '1710719999';" ) );

    foreach ( $transactions as $transaction )
        if ( str_contains($transaction->description, 'سفارش:') )
            $duplicates[$transaction->user_id][] = $transaction->description;

    $new = [];
    foreach ( $duplicates as $user_id => $orders ) {

        if ( !empty( $duplicated_orders = array_unique(array_diff_assoc($orders, array_unique($orders))) ) ) {

            $amendment_orders = [];
            foreach ($duplicated_orders as $desc) {
                $order_id = explode('سفارش: ', $desc)[1];

                foreach ( $transactions as $transaction )
                    if ( str_contains($transaction->description, $order_id) && str_contains($transaction->description, 'اصلاحیه') )
                        $amendment_orders[] = $order_id;

            }

            // حذف اصلاحیه خورده ها از لیست تکراری ها
            foreach ($amendment_orders as $amendment_order)
                foreach ($duplicated_orders as $key => $value)
                    if (strpos($value, (string)$amendment_order) !== false)
                        unset($duplicated_orders[$key]);

            if ( !empty( $duplicated_orders ) )
                $new[$user_id] = array_values($duplicated_orders);
        }
    }

    saeed_store($new);
}

if ( isset( $_GET['1402_topsales'] ) ) {

    add_action('woocommerce_after_register_post_type', function () {

        global $wpdb;

        $partially_orders = [];
        $temp = $wpdb->get_results( "SELECT wp_posts.ID FROM wp_posts WHERE post_status = 'wc-partially-paid' OR post_status = 'wc-held' OR post_status = 'wc-completed' OR post_status = 'wc-walletx'", ARRAY_A );
        foreach ( $temp as $order_arr )
            $partially_orders[] = $order_arr['ID'];
        $partially_orders = implode(',', $partially_orders);

        $rows = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => "SELECT wc_order_id as ID, booking_time as booking_time FROM wp_zb_booking_history WHERE `wc_order_id` IN ($partially_orders) AND `room_id` IN (403881,333821,309692,335012,145024,2762,4134,334025,154030,38163,6292,40875,300206,21755)"])), true);

        foreach ( $rows as $row ) {

            if ( $row['booking_time'] < time() - 4 * 3600 && time() - 365 * 24 * 3600 < $row['booking_time']  ) {
                $order_id = $row['ID'];

                $order = wc_get_order($order_id);
                foreach ($order->get_items() as $item) {
                    $product_id = $item->get_product_id();
                    $quantity   = $item->get_quantity();
                }

                $all[] = array(
                    'room_id'   => $product_id,
                    'order_id'  => $order_id,
                    'count'     => $quantity,
                    'held_time' => $row['booking_time']
                );
            }
        }

        $topsale = [];
        foreach ( $all as $order ) {
            $topsale[$order['room_id']] += $order['count'];
        }
        saeed_store($topsale);

    });
}

if ( isset( $_GET['bak_test'] ) ) {
    $posts_per_page = 1;
    $args = [
        'image_type'        => 'url',
        'limit'             => $posts_per_page,
        'page'              => 1,
        'max_num_pages'     => true,
        "format"            => 'html_slider',
        'is_mobile'         => wp_is_mobile(),
        'sort_type'         => 'trend',
        'only_ads'          => false,
        'show_more'         => 0,
        'badge_ads'         => false,
        'random'            => true
    ];
//    $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) );

    $data = array('type' => 'sort_products_get', 'data' => $args);
    $response = wp_remote_post( 'https://' . $_SERVER['HTTP_HOST'] . '/web-service/web-service.php', array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => $data,
        'cookies'       => array()
    ) );

    saeed_print($response);
}

if ( isset( $_GET['update_product_brand'] ) ) {

    add_action('init', function() {

        $args = array (
            'post_type'         => 'product',
            'post_status'       => 'publish',
            'posts_per_page'    => -1,
            'meta_query'        => array (
                array(
                    'key'     => 'sale_active',
                    'value'   => 1,
                    'compare' => 'LIKE',
                ),
            ),
        );
        $query = new WP_Query($args);

        while ($query->have_posts()) : $query->the_post();
            global $product;

            $brand_data = get_the_terms(get_the_ID(), 'yith_product_brand')[0];

            update_post_meta(get_the_ID(), 'product_brand', $brand_data->term_id);

        endwhile;
        wp_reset_postdata();

    });
}

if ( isset( $_GET['get_list_of_all_products'] ) ) {

    add_action('woocommerce_after_register_post_type', function() {

        $args = array (
            'post_type'         => 'product',
            'posts_per_page'    => -1,
        );
        $query = new WP_Query($args);

        while ($query->have_posts()) : $query->the_post();
            $id = get_the_ID();

            $data[] = [
                'id'        => $id,
                'title'     => get_the_title(),
                'date'      => get_the_date('Y - m - d'),
                'statue'    => get_post_status(),
                'city'      => (get_the_terms($id, 'product_cat')[0])->name,
            ];

        endwhile;
        wp_reset_postdata();

        saeed_store($data);

    });
}

if ( isset( $_GET['redirect_to_payment_url'] ) ) {
    header('Location: ' . 'https://escapezoom.ir/checkout/order-pay/474181/?key=wc_order_O06V2Rlrnda5G');
    exit;
}

if ( isset( $_GET['reservation_webservice_test'] ) ) {

    $query = "INSERT INTO `wp_zb_booking_history` (`booking_id`, `customer_id`, `wc_order_id`, `status`, `room_id`, `booking_time`, `booked_time`, `name`, `phone`, `quantity`) 
                    VALUES (NULL, 1, 1, 1, 1, 1, 1, 1, 1, 1);";
    $data = [
        'query'         => $query,
        'single_value'  => false,
    ];

    $response = wp_remote_post( 'https://escapezoom.ir/web-service/reservation.php', array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => array('type' => 'query_execution2', 'data' => $data),
        'cookies'       => array()
    ) );

//    $res = $response['body'];
    $res = $response;

    saeed_store($res);
}

if ( isset( $_GET['get_jwt_token_by_user'] ) ) {

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_URL, "https://api.neshan.org/v4/direction?type=car&destination=35.72056383837348,51.43225866699049&avoidTrafficZone=false&avoidOddEvenZone=false&alternative=false&bearing=");
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        "api-key: service.b745e9cdd9ec4f2f9d65acdcedff3ca6"
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    echo $response;
}

if ( isset( $_GET['lat'] ) ) { ?>

    <a href="geo:35.745775,51.212623">35.745775,51.212623</a>

    <?php
}

if ( isset( $_GET['ashoora'] ) ) {
//    ez_reservation( array('type' => 'close_all_sanses_of_all_products') );
}

if ( isset( $_GET['data_products_set2'] ) ) {

    $response = wp_remote_post( 'https://dev-api.escapezoom.ir/web-service/web-service.php', array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => array('type' => 'data_products_set', 'data' => $product_data),
        'cookies'       => array()
    ) );

    $res = $response['body'];

//    echo '<pre>'; print_r($res); echo '</pre>';
}

if ( isset( $_GET['update_user_shaba'] ) ) {

    $text = "491,3370104598,IR930620000000301907391007,البرز آقایی
        478,,IR890560083488800577817001,سینا غلامیان
    ";

    $lines = explode("\n", $text);
    $desired_array = [];

    foreach ($lines as $line) {
        $parts = explode(',', $line);
        if (count($parts) >= 4) {
            $user_id = trim($parts[0]);
            $withdrawal_owner_shaba = trim($parts[2]);
            $withdrawal_owner_identity_card = trim($parts[1]);
            $withdrawal_owner_name = trim($parts[3]);

            update_user_meta($user_id, 'withdrawal_owner_name', sanitize_text_field( $withdrawal_owner_name));
            update_user_meta($user_id, 'withdrawal_owner_shaba', sanitize_text_field($withdrawal_owner_shaba));
            update_user_meta($user_id, 'withdrawal_owner_identity_card', sanitize_text_field($withdrawal_owner_identity_card ));
        }
    }
}


if ( isset( $_GET['get_single_product'] ) ) {

    $response = wp_remote_post( 'https://escapezoom.ir/api/v1/product/get/395598', array(
        'method'        => 'POST',
        'timeout'       => 45,
        'redirection'   => 5,
        'httpversion'   => '1.0',
        'blocking'      => true,
        'headers'       => array(),
        'body'          => $data,
        'cookies'       => array()
    ) );

    saeed_print( $response['body'] );

}

/*===============================================================================*/
if(!class_exists('WC_Filter_Orders_By_Coupon')){
    class WC_Filter_Orders_By_Coupon {
        const VERSION = '1.0.0';

        protected static $instance;

        public function __construct() {
            if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
                add_filter( 'post_row_actions', [ $this, 'coupons_row_actions' ], 10, 2 );
                add_action( 'restrict_manage_posts', [ $this, 'filter_orders_by_coupon_used' ] );
                add_filter( 'posts_join', [ $this, 'add_order_items_join' ] );
                add_filter( 'posts_where', [ $this, 'add_filterable_where' ] );
            }
        }

        public function coupons_row_actions( $actions, $post ) {
            if ( $post->post_type == 'shop_coupon' ) {

                $url = admin_url( 'edit.php?post_type=shop_order&_coupons_used=' . $post->post_title );

                $actions = array_merge( $actions, [
                    'orders' => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', esc_url( $url ), 'گزارش سفارشات' ),
                ] );

            }

            return $actions;
        }

        public function filter_orders_by_coupon_used() {
            global $typenow;

            if ( 'shop_order' === $typenow ) {
                $args = [
                    'posts_per_page' => - 1,
                    'orderby'        => 'title',
                    'order'          => 'asc',
                    'post_type'      => 'shop_coupon',
                    'post_status'    => 'publish',
                ];

                $coupons = get_posts( $args );

                if ( ! empty( $coupons ) ) : ?>
                    <select name="_coupons_used" id="dropdown_coupons_used">
                        <option value="">
                            فیلتر بر اساس کد تخفیف
                        </option>
                        <?php foreach ( $coupons as $coupon ) : ?>
                            <option value="<?php echo esc_attr( $coupon->post_title ); ?>" <?php echo esc_attr( isset( $_GET['_coupons_used'] ) ? selected( $coupon->post_title, $_GET['_coupons_used'], false ) : '' ); ?>>
                                <?php echo esc_html( $coupon->post_title ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <script>
                        jQuery(document).ready(function ($) {
                            $("#dropdown_coupons_used").select2()
                        })
                    </script>
                <?php endif;
            }
        }

        public function add_order_items_join( $join ) {
            global $typenow, $wpdb;

            if ( 'shop_order' === $typenow && isset( $_GET['_coupons_used'] ) && ! empty( $_GET['_coupons_used'] ) ) {
                $join .= "LEFT JOIN {$wpdb->prefix}woocommerce_order_items woi ON {$wpdb->posts}.ID = woi.order_id";
            }

            return $join;
        }

        public function add_filterable_where( $where ) {
            global $typenow, $wpdb;

            if ( 'shop_order' === $typenow && isset( $_GET['_coupons_used'] ) && ! empty( $_GET['_coupons_used'] ) ) {
                $where .= $wpdb->prepare( " AND woi.order_item_type='coupon' AND woi.order_item_name='%s'", wc_clean( $_GET['_coupons_used'] ) );
            }

            return $where;
        }

        public static function instance(): ?WC_Filter_Orders_By_Coupon {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }

    WC_Filter_Orders_By_Coupon::instance();
}


add_action('init', function(){
    $role = get_role( 'shopist' );

    if ( $role ){
        $role->add_cap( 'edit_job');
        $role->add_cap( 'edit_jobs');
        $role->add_cap( 'edit_other_jobs');
        $role->add_cap( 'publish_jobs');
        $role->add_cap( 'read_job');
        $role->add_cap( 'read_private_jobs');
        $role->add_cap( 'delete_job');

        $role->add_cap( 'edit_shop_coupon' );
        $role->add_cap( 'read_shop_coupon' );
        $role->add_cap( 'delete_shop_coupon' );
        $role->add_cap( 'edit_shop_coupons' );
        $role->add_cap( 'edit_others_shop_coupons' );
        $role->add_cap( 'publish_shop_coupons' );
        $role->add_cap( 'read_private_shop_coupons' );
        $role->add_cap( 'delete_shop_coupons' );
        $role->add_cap( 'delete_private_shop_coupons' );
        $role->add_cap( 'delete_published_shop_coupons' );
        $role->add_cap( 'delete_others_shop_coupons' );
        $role->add_cap( 'edit_private_shop_coupons' );
        $role->add_cap( 'edit_published_shop_coupons' );
    }
});

if( isset($_GET['_coupons_used']) ){

    add_filter( 'manage_edit-shop_order_columns', function ( $columns ) {
        $columns['city']    = 'شهر';
        $columns['income']  = 'درآمد';

        return $columns;
    } );

    add_action( 'manage_shop_order_posts_custom_column', function ( $column ) {
        global $post;

        $order = wc_get_order( $post->ID );

        if ( $column == 'city' ) {
            foreach( $order->get_items() as $item ){
                $product = $item->get_product();
                $id      = $product->get_id();
                $meta    = ez_get_product_meta( $id );

                echo $meta->city_name;
            }
        }

        if ( $column == 'income' ) {

            foreach ($order->get_items() as $item) {
                $order_id = $post->ID;
                $product_id = $item->get_product_id();
                $item_quantity = $item->get_quantity();
            }

            $pish_per_person = get_post_meta( $order_id, 'ticket_tedad', true );
            $pish_per_person = !empty( $pish_per_person ) ? $pish_per_person : get_post_meta( $product_id, 'pish_pardakht_per_person', true );
            $pish_per_person = !empty( $pish_per_person ) ? $pish_per_person : 1;

            $pish = get_post_meta( $order_id, "_order_total_2", true );

            $pish_final = $pish ? : get_post_meta( $order_id, "_order_total", true );
            $item_total = $pish_final / $pish_per_person * $item_quantity;
            $tax = 10;
            $commission = 10;
            if (get_post_meta($product_id, "darsad", true)){
                $commission = get_post_meta($product_id, "darsad", true);
            }
            $porsant = $item_total * ($commission / 100);

            echo number_format($porsant) . ' تومان';
        }
    } );
}


add_action('init', function (){
    if( isset($_GET['brands_list']) ) {
        $brands = get_terms([
            'taxonomy'      => 'yith_product_brand',
            'hide_empty'    => true,
        ]);

        foreach ( $brands as $brand ) {

            $brand_id = $brand->term_id;

            $items[] = [
                'id'    => $brand_id,
                'title' => $brand->name,
                'url'   => get_term_link($brand),
                'count' => $brand->count
            ];
        }

        $output = "id, title, url, count\n"; // Initial line for the header

        foreach ($items as $item) {
            $output .= "{$item['id']}, {$item['title']}, {$item['url']}, {$item['count']}\n";
        }

        saeed_store($output);
    }


    if( isset($_GET['gettt']) ) {

        $posts_per_page = 100;
        $params = [
            'city_id' => -1,
        ];

        $args = [
            'params'        => $params,
            'image_type'    => 'url',
            'limit'         => $posts_per_page,
            'page'          => 1,
            'max_num_pages' => true,
            "format"        => 'api',
            'is_mobile'     => wp_is_mobile(),
            'sort_type'     => 'popular',
            'only_ads'      => true,
            'show_more'     => 0,
        ];
        $products = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) );

        saeed_print($products);
        exit();
    }

    if( isset($_GET['telegramxxx']) ) {

        $url = 'https://impec.ir/?chat_id=OTc3MjA1ODk=&message=hi';


        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);

        file_get_contents("https://impec.ir/?chat_id=OTc3MjA1ODk=&message=hi");
    }
});



