<?php
$city_list  = [
    15  => 'تهران',
    162 => 'کرج',
    122 => 'اصفهان',
    121 => 'مشهد',
    293 => 'کرمانشاه',
    270 => 'قزوین',
    187 => 'قم',
    304 => 'کاشان',
    285 => 'رشت',
    289 => 'کیش',
    580 => 'اراک',
    746 => 'یزد',
    416 => 'تبریز',
    482 => 'رامسر',
    570 => 'شهرکرد',
    321 => 'ایلام',
    495 => 'سنندج',
    544 => 'لاهیجان',
];
$tag_list   = [
    124  => 'ترسناک',
    346 => 'اکشن',
    342 => 'درام',
    126 => 'دلهره آور',
    125 => 'غیرترسناک',
    178 => 'هیجانی',
    127 => 'جنایی',
]; ?>

<div id="ez_cat_filter_wrapper">
    <?php
    if ( wp_is_mobile() ) { ?>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="بستن"></button>
    <?php
    } ?>

    <button style="display:none" type="button" id="ez_cat_filter_submit">مشاهده نتایج</button>

    <span id="ez_cat_filter_title">سانس‌یاب</span>

    <div class="ez_cat_filter_item" id="ez_cat_filter_item_schedule_days_wrapper">
        <span class="ez_cat_filter_item_title">سانس‌های موجود </span>

        <div class="ez_cat_filter_item_body" >

            <div id="ez_cat_filter_item_schedule_days">
                <span class="ez_cat_filter_item_schedule_days_item" id="ez_cat_filter_item_schedule_days_today">امروز</span>
                <span class="ez_cat_filter_item_schedule_days_item" id="ez_cat_filter_item_schedule_days_tomorrow">فردا</span>
                <span class="ez_cat_filter_item_schedule_days_item" id="ez_cat_filter_item_schedule_days_overmorrow">پس‌فردا</span>
            </div>

            <div id="ez_cat_filter_item_schedule_today_slider_wrapper" class="ez_cat_filter_item_schedule_slider_wrapper">
                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">از ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_today_min" class="ez_cat_filter_item_schedule_slider_input" value="" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>

                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">تا ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_today_max" class="ez_cat_filter_item_schedule_slider_input" value="24" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>
            </div>

            <div id="ez_cat_filter_item_schedule_tomorrow_slider_wrapper" class="ez_cat_filter_item_schedule_slider_wrapper">
                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">از ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_tomorrow_min" class="ez_cat_filter_item_schedule_slider_input" value="10" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>

                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">تا ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_tomorrow_max" class="ez_cat_filter_item_schedule_slider_input" value="24" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>
            </div>

            <div id="ez_cat_filter_item_schedule_overmorrow_slider_wrapper" class="ez_cat_filter_item_schedule_slider_wrapper">
                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">از ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_overmorrow_min" class="ez_cat_filter_item_schedule_slider_input" value="10" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>

                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                    <span class="ez_cat_filter_item_schedule_slider_input_title">تا ساعت</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                    <input type="text" id="ez_cat_filter_item_schedule_overmorrow_max" class="ez_cat_filter_item_schedule_slider_input" value="24" disabled>
                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                </div>
            </div>

        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading2">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="true" aria-controls="collapse2">
                    <span class="ez_cat_filter_item_title">تعداد نفرات </span>
                </button>
            </h2>
            <div id="collapse2" class="accordion-collapse collapse" aria-labelledby="heading2" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item" id="ez_cat_filter_item_count_wrapper">
                        <div class="ez_cat_filter_item_body">
                            <div id="ez_cat_filter_item_schedule_count_slider_wrapper" class="ez_cat_filter_item_schedule_slider_wrapper">
                                <div class="ez_cat_filter_item_schedule_slider_input_wrapper">
                                    <span class="ez_cat_filter_item_schedule_slider_input_up_arrow">+</span>
                                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_line"></span>
                                    <span class="ez_cat_filter_item_schedule_slider_input_arrow_border"></span>
                                    <input type="text" id="ez_cat_filter_item_count" class="ez_cat_filter_item_schedule_slider_input" value="همه" disabled>
                                    <span class="ez_cat_filter_item_schedule_slider_input_down_arrow">-</span>
                                    <span class="ez_cat_filter_item_schedule_slider_input_title">نفر</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading3">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="true" aria-controls="collapse3">
                    <span class="ez_cat_filter_item_title">قیمت </span>
                </button>
            </h2>
            <div id="collapse3" class="accordion-collapse collapse" aria-labelledby="heading3" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item" id="ez_cat_filter_item_price_wrapper">
                        <div class="ez_cat_filter_item_body">
                            <span id="ez_cat_filter_item_price_min" class="ez_cat_filter_item_slider_min"></span>
                            <span id="ez_cat_filter_item_price_min_title">حداقل</span>
                            <div id="ez_cat_filter_item_price_slider"></div>
                            <span id="ez_cat_filter_item_price_max" class="ez_cat_filter_item_slider_max"></span>
                            <span id="ez_cat_filter_item_price_max_title">حداکثر</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading4">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="true" aria-controls="collapse4">
                    <span class="ez_cat_filter_item_title">شهر </span>
                </button>
            </h2>
            <div id="collapse4" class="accordion-collapse collapse" aria-labelledby="heading4" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item">
                        <div class="ez_cat_filter_item_body ez_2clmns">
                            <?php
                            foreach ( $city_list as $id => $name ) : ?>
                                <div class="ez_cat_filter_item_city_list_item">
                                    <input type="checkbox" id="ez_cat_filter_item_city_list_<?php echo $id ?>" class="ez_cat_filter_item_city_list" value="<?php echo $id ?>">
                                    <label for="ez_cat_filter_item_city_list_<?php echo $id ?>"><?php echo $name ?></label>
                                </div>
                            <?php
                            endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading5">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse5" aria-expanded="true" aria-controls="collapse5">
                    <span class="ez_cat_filter_item_title">ژانر </span>
                </button>
            </h2>
            <div id="collapse5" class="accordion-collapse collapse" aria-labelledby="heading5" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item">
                        <div class="ez_cat_filter_item_body ez_2clmns">
                            <?php
                            foreach ( $tag_list as $id => $name ) : ?>
                                <div class="ez_cat_filter_item_tag_list_item">
                                    <input type="checkbox" id="ez_cat_filter_item_tag_list_<?php echo $id ?>" class="ez_cat_filter_item_tag_list" value="<?php echo $id ?>">
                                    <label for="ez_cat_filter_item_tag_list_<?php echo $id ?>"><?php echo $name ?></label>
                                </div>
                            <?php
                            endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading6">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse6" aria-expanded="true" aria-controls="collapse6">
                    <span class="ez_cat_filter_item_title">رده سنی </span>
                </button>
            </h2>
            <div id="collapse6" class="accordion-collapse collapse" aria-labelledby="heading6" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item">
                        <div class="ez_cat_filter_item_body">
                            <select id="ez_cat_filter_item_age">
                                <option value="-1">همه</option>
                                <option value="12">12+</option>
                                <option value="13">13+</option>
                                <option value="14">14+</option>
                                <option value="15">15+</option>
                                <option value="16">16+</option>
                                <option value="17">17+</option>
                                <option value="18">18+</option>
                            </select>
                            سال
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading7">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse7" aria-expanded="true" aria-controls="collapse7">
                    <span class="ez_cat_filter_item_title">زمان بازی</span>
                </button>
            </h2>
            <div id="collapse7" class="accordion-collapse collapse" aria-labelledby="heading7" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item">
                        <div class="ez_cat_filter_item_body">
                            <select id="ez_cat_filter_item_duration">
                                <option value="-1">همه</option>
                                <option value="60">60</option>
                                <option value="70">70</option>
                                <option value="80">80</option>
                                <option value="90">90</option>
                                <option value="100">100</option>
                                <option value="110">110</option>
                                <option value="120">120</option>
                                <option value="130">130</option>
                                <option value="140">140</option>
                                <option value="150">150</option>
                                <option value="160">160</option>
                                <option value="170">170</option>
                                <option value="180">180</option>
                                <option value="190">190</option>
                                <option value="200">200</option>
                            </select>
                            دقیقه
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion" id="product_filter_item_accordion_wrapper">
        <div class="accordion-item">
            <h2 class="accordion-header" id="heading8">
                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse8" aria-expanded="true" aria-controls="collapse8">
                    <span class="ez_cat_filter_item_title">سطح سختی </span>
                </button>
            </h2>
            <div id="collapse8" class="accordion-collapse collapse" aria-labelledby="heading8" data-bs-parent="#product_filter_item_accordion_wrapper">
                <div class="accordion-body">
                    <div class="ez_cat_filter_item">
                        <div class="ez_cat_filter_item_body">
                            <select id="ez_cat_filter_item_level">
                                <option value="-1">همه</option>
                                <option value="4">1 از 4</option>
                                <option value="3">2 از 4</option>
                                <option value="2">3 از 4</option>
                                <option value="1">4 از 4</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <span id="product_list_mobile_get_res_btn">مشاهده نتایج</span>
</div>

