const sidebarMenu = document.querySelector('#sidebar'),
    sidebarStyle = document.querySelector('#sidebar-style'),
    accountingSection = document.querySelector('#accounting-section'),
    accountingMenu = document.querySelector('#accounting-menu');

sidebarStyle.addEventListener('click', ()=>{
  sidebarMenu.classList.toggle('close');
})
accountingMenu.addEventListener('click', ()=> {
  accountingSection.classList.toggle('show');
})

jQuery(document).ready(function($) {
  var table = $('#accountingTable').DataTable({
    "oLanguage": {
      "sSearch": "جستجو: ",
      "oPaginate": {
        "sFirst":    "اولین صفحه",
        "sLast":    "آخرین صفحه",
        "sNext":    "بعدی",
        "sPrevious": "قبلی"
      },
      "sProcessing":    "",
      "sLengthMenu":    "_MENU_ ردیف",
      "sZeroRecords":   "",
      "sEmptyTable":    "",
      "sInfo":          "",
      "sInfoEmpty":     "",
      "sInfoFiltered":  "",
      "sInfoPostFix":   "",
      "sUrl":           "",
      "sInfoThousands":  ",",
      "sLoadingRecords": "",
    },
    responsive: true,
  })
      .columns.adjust()
      .responsive.recalc();
});

// wallet script

const gameTab = document.querySelectorAll('.game-tab'),
    timeButtonTab = document.querySelectorAll('.time-button-tab');

let gameTabActive = function () {
  gameTab.forEach((element) => {
    element.classList.remove("active");
  });
}
if (gameTab) {
  gameTab.forEach((element) => {
    element.addEventListener('click', function (){
      gameTabActive();
      this.classList.add('active');
    })
  });
}

let timeButtonTabActive = function () {
  timeButtonTab.forEach((element) => {
    element.classList.remove("active");
  });
}

if (timeButtonTab) {
  timeButtonTab.forEach((element) => {
    element.addEventListener('click', function (){
      timeButtonTabActive();
      this.classList.add('active');
    })
  });
}

// TimeSection Slider
document.addEventListener("DOMContentLoaded", () => {
  const time_section = new Swiper(".time_slider", {
    slidesPerView: "auto",
    spaceBetween: 30,
    breakpoints: {
      498: {
        slidesPerView: "auto",
        spaceBetween: 20,
      },
      768: {
        slidesPerView: "auto",
        spaceBetween: 30,
      },
      1024: {
        slidesPerView: "auto",
        spaceBetween: 35,
      },
    }
  });
});