const socket = new WebSocket('ws://escapezoom.ir:3032');  

socket.onopen = function() {  
    console.log('Connected to the WebSocket server');  
};  

socket.onmessage = function(event) {  

	console.log(event.data);

	const commentCount = event.data;  
    const commentMenuLink = document.querySelector('a[href="edit-comments.php"]');  

    if (commentMenuLink) {
        let badge = commentMenuLink.querySelector('.awaiting-mod');  

        if (!badge) {
            badge = document.createElement('span');
            badge.className = 'awaiting-mod';
            commentMenuLink.appendChild(badge); 

        } else {

    		badge.textContent = commentCount > 0 ? commentCount : '';    

		    badge.classList.forEach(cls => {  
		        if (cls.startsWith('count-')) {  
		            badge.classList.remove(cls);  
		        }  
		    });  

		    badge.classList.add(`count-${commentCount}`);

		    const showNotificationButton = document.getElementById('showNotification');  

            const notification = document.createElement('div');  
            notification.id = 'notification';  
            notification.className = 'notification hidden';  
            notification.textContent = 'یک کامنت جدید دارید';  
            
            document.body.appendChild(notification);  

            notification.classList.remove('hidden');  
            notification.classList.add('visible');  
            
            setTimeout(() => {  
                notification.classList.remove('visible');  
                notification.classList.add('hidden');  
                
                setTimeout(() => {  
                    document.body.removeChild(notification);  
                }, 300); 

            }, 3000);  
    	}
    } 
};

socket.onclose = function() {  
    console.log('Disconnected from the WebSocket server--');  
};  

socket.onerror = function(error) {  
    console.error('WebSocket error: ' + error.message);  
};  