document.addEventListener("DOMContentLoaded", () => {
    const swiper_horizontalSlider = new Swiper(".horizontal-slider", {
        slidesPerView: "auto",
        spaceBetween: 10,
        breakpoints: {
            768: {
                slidesPerView: "auto",
                spaceBetween: 26,
            },
        },
    });
    const swiper_gallerySlider = new Swiper(".gallery-slider", {
        slidesPerView: "auto",
        spaceBetween: 10,
        breakpoints: {
            768: {
                slidesPerView: "auto",
                spaceBetween: 26,
            },
        },
        navigation: {
            nextEl: "#galleryButton",
        },
    });
    const swiper_offerSlider = new Swiper(".offer-slider", {
        slidesPerView: "auto",
        spaceBetween: 20,
        breakpoints: {
            768: {
                slidesPerView: "auto",
                spaceBetween: 50,
            },
        },
        navigation: {
            nextEl: "#offerButton",
        },
    });
    // show teaser
    const teaserJeegh = document.querySelectorAll(".teaser-jeegh"),
        videoContainerCloseIcon = document.querySelector('#videoContainerCloseIcon'),
        videoItem = document.querySelector('#videoItem'),
        videoIframe = document.querySelector('#videoIframe'),
        overlay = document.querySelector("#overlay");
    let overlayFunc = function ($type) {
        if ($type) {
            overlay.style.display = 'block'
            setTimeout(() => {
                overlay.style.transform = 'scale(1)';
            }, 100);
        }
        if (!$type) {
            overlay.style.transform = 'scale(0)';
            setTimeout(() => {
                overlay.style.display = 'none'
            }, 300);
        }
    };
    teaserJeegh.forEach((element) => {
        element.addEventListener("click", function () {
            let videoName = this.getAttribute('data-video-name');
            let videoConfig = this.getAttribute('data-video-config');
            overlayFunc("open");
            videoItem.classList.add('active');
            videoContainerCloseIcon.classList.add('active');
            videoIframe.classList.add('active');
            videoIframe.setAttribute('src', `https://player.arvancloud.ir/index.html?config=${videoConfig}&skin=shaka`);
            videoIframe.setAttribute('name', videoName);
        });
    });
    // gallery box show
    const galleryBoxSection=document.querySelector('#gallery-box-section'),
        galleryImageBox=document.querySelector('#gallery-image-box'),
        fullScreenGallery = document.querySelectorAll('.full-screen-gallery');
    fullScreenGallery.forEach((element)=>{
        element.addEventListener('click', function (){
            let boxSrc = this.getAttribute('data-src');
            galleryImageBox.setAttribute('src', boxSrc);
            overlayFunc("open");
            videoContainerCloseIcon.classList.add('active');
            galleryBoxSection.style.display = 'flex'
            setTimeout(() => {
                galleryBoxSection.style.transform = 'scale(1)';
            }, 100);
        })
    })
    // closed
    videoContainerCloseIcon.addEventListener('click', ()=>{
        overlayFunc();
        videoItem.classList.remove('active');
        videoContainerCloseIcon.classList.remove('active');
        videoIframe.classList.remove('active');
        videoIframe.setAttribute('src', '');
        videoIframe.setAttribute('name', '');
        galleryBoxSection.style.transform = 'scale(0)';
        setTimeout(() => {
            galleryBoxSection.style.display = 'none';
            galleryImageBox.setAttribute('src', '');
        }, 100);
    })
    overlay.addEventListener('click', ()=>{
        overlayFunc();
        videoItem.classList.remove('active');
        videoContainerCloseIcon.classList.remove('active');
        videoIframe.classList.remove('active');
        videoIframe.setAttribute('src', '');
        videoIframe.setAttribute('name', '');
        galleryBoxSection.style.transform = 'scale(0)';
        setTimeout(() => {
            galleryBoxSection.style.display = 'none';
            galleryImageBox.setAttribute('src', '');
        }, 100);
    })
    // acc
    let jeeghAcc = document.querySelectorAll(".jeegh-acc");
    jeeghAcc.forEach((element) => {
        element.addEventListener("click", function (e) {
            let parentElement = this.parentElement.parentElement.parentElement;
            parentElement.classList.toggle("h-[235px]");
        });
    });

    // faq
    const questionBtn = document.querySelectorAll(".question-btn"),
        answerContent = document.querySelectorAll(".answer-content");

    function answerContentActive() {
        answerContent.forEach((element) => {
            element.style.height = "0px";
        });
    }
    questionBtn.forEach((element) => {
        element.addEventListener("click", function () {
            let answerID = this.getAttribute("data-target-content");
            let btnID = this.getAttribute("data-question-btn");
            let answerContent = document.getElementById(answerID);
            let questionBtn = document.getElementById(btnID);
            answerContentActive();
            if (answerContent.clientHeight > 0) {
                answerContent.style.height = "0px";
                questionBtn.style.transform = "rotate(0deg)";
            } else {
                answerContent.style.height = answerContent.scrollHeight + "px";
                questionBtn.style.transform = "rotate(90deg)";
            }
        });
    });
});
