<?php
$showcase_metaboxes = new_cmb2_box(
    array(
        'id' => 'showcase_metaboxes',
        'title' => __('ویترین', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'بک گراند دسکتاپ',
        'id' => 'lg_background_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'بک گراند موبایل',
        'id' => 'sm_background_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'پوستر دسکتاپ',
        'id' => 'lg_poster_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'پوستر موبایل',
        'id' => 'sm_poster_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'عنوان اصلی',
        'id' => 'title_meta',
        'type' => 'text',
    )
);
$showcase_metaboxes->add_field(
    array(
        'name' => 'خلاصه',
        'id' => 'expert_meta',
        'type'    => 'wysiwyg',
    )
);

$detail_metaboxes = new_cmb2_box(
    array(
        'id' => 'detail_metaboxes',
        'title' => __('توضیحات بازی', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'ژانر',
        'id' => 'game_genre_meta',
        'type'    => 'text_medium'
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'تم بازی',
        'id' => 'game_theme_meta',
        'type'    => 'text_medium'
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'مدت زمان هر اپیزود',
        'id' => 'game_time_meta',
        'type'    => 'text_medium'
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'مناسب سن',
        'id' => 'game_age_meta',
        'type'    => 'text_medium'
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'میزان سختی',
        'id' => 'game_hard_meta',
        'type'    => 'text_medium'
    )
);
$detail_metaboxes->add_field(
    array(
        'name' => 'معرفی مختصر بازی',
        'id' => 'game_expert_meta',
        'type'    => 'wysiwyg',
    )
);
$adv_metaboxes = new_cmb2_box(
    array(
        'id' => 'adv_metaboxes',
        'title' => __('رسانه بازی', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$teaser_section = $adv_metaboxes->add_field( array(
    'id'          => 'teaser_game_repeat_group',
    'type'        => 'group',
    'description' => 'تیزرهای بازی',
    'repeatable'  => true,
    'options'     => array(
        'group_title'       => 'تیزر {#}',
        'add_button'        => 'تیزر جدید',
        'remove_button'     => 'حذف تیزر',
        'sortable'          => true,
        'closed'         => true,
        'remove_confirm' => 'آیا از حذف این تیزر مطمئن هستید؟'
    ),
) );
$adv_metaboxes->add_group_field( $teaser_section, array(
    'name' => 'نام ویدئو (در ابرآروان)',
    'id'   => 'teaser_game_name',
    'type' => 'text',
) );
$adv_metaboxes->add_group_field( $teaser_section, array(
    'name' => 'لینک config ویدئو (در ابرآروان)',
    'id'   => 'teaser_game_config',
    'type' => 'text',
) );
$adv_metaboxes->add_group_field( $teaser_section, array(
    'name' => 'پوستر تیزر',
    'id'   => 'teaser_game_poster',
    'type' => 'file',
    'query_args' => array(
        'type' => array(
            'image/gif',
            'image/jpeg',
            'image/png',
        ),)
) );
$gallery_section = $adv_metaboxes->add_field( array(
    'id'          => 'gallery_game_repeat_group',
    'type'        => 'group',
    'description' => 'تصاویر بازی',
    'repeatable'  => true,
    'options'     => array(
        'group_title'       => 'تصویر {#}',
        'add_button'        => 'تصویر جدید',
        'remove_button'     => 'حذف تصویر',
        'sortable'          => true,
        'closed'         => true,
        'remove_confirm' => 'آیا از حذف این تصویر مطمئن هستید؟'
    ),
) );
$adv_metaboxes->add_group_field( $gallery_section, array(
    'name' => 'تصویر بند انگشتی',
    'id'   => 'gallery_game_thumbnail',
    'type' => 'file',
    'query_args' => array(
        'type' => array(
            'image/gif',
            'image/jpeg',
            'image/png',
        ),)
) );
$adv_metaboxes->add_group_field( $gallery_section, array(
    'name' => 'تصویر سایز بزرگ',
    'id'   => 'gallery_game_full',
    'type' => 'file',
    'query_args' => array(
        'type' => array(
            'image/gif',
            'image/jpeg',
            'image/png',
        ),)
) );
$cast_section = $adv_metaboxes->add_field( array(
    'id'          => 'cast_game_repeat_group',
    'type'        => 'group',
    'description' => 'عوامل بازی',
    'repeatable'  => true,
    'options'     => array(
        'group_title'       => 'نفر {#}',
        'add_button'        => 'نفر جدید',
        'remove_button'     => 'حذف نفر',
        'sortable'          => true,
        'closed'         => true,
        'remove_confirm' => 'آیا از حذف این نفر مطمئن هستید؟'
    ),
) );
$adv_metaboxes->add_group_field( $cast_section, array(
    'name' => 'عکس',
    'id'   => 'cast_pic',
    'type' => 'file',
    'query_args' => array(
        'type' => array(
            'image/gif',
            'image/jpeg',
            'image/png',
        ),)
) );
$adv_metaboxes->add_group_field( $cast_section, array(
    'name' => 'نام',
    'id'   => 'cast_name',
    'type'    => 'text_medium'
) );
$adv_metaboxes->add_group_field( $cast_section, array(
    'name' => 'سمت',
    'id'   => 'cast_work',
    'type'    => 'text_medium'
) );

$content_metaboxes = new_cmb2_box(
    array(
        'id' => 'content_metaboxes',
        'title' => __('محتوای توضیحات بیشتر بازی', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عنوان',
        'id' => 'game_title_content_meta',
        'type'    => 'text_medium'
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'خلاصه',
        'id' => 'game_expert_content_meta',
        'type'    => 'wysiwyg',
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عکس کارت اول',
        'id' => 'game_img_cart1_content_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عنوان کارت اول',
        'id' => 'game_title_cart1_content_meta',
        'type'    => 'text_medium'
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'توضیحات کارت اول',
        'id' => 'game_content_cart1_content_meta',
        'type'    => 'wysiwyg',
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عکس کارت دوم',
        'id' => 'game_img_cart2_content_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عنوان کارت دوم',
        'id' => 'game_title_cart2_content_meta',
        'type'    => 'text_medium'
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'توضیحات کارت دوم',
        'id' => 'game_content_cart2_content_meta',
        'type'    => 'wysiwyg',
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عکس کارت سوم',
        'id' => 'game_img_cart3_content_meta',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'عنوان کارت سوم',
        'id' => 'game_title_cart3_content_meta',
        'type'    => 'text_medium'
    )
);
$content_metaboxes->add_field(
    array(
        'name' => 'توضیحات کارت سوم',
        'id' => 'game_content_cart3_content_meta',
        'type'    => 'wysiwyg',
    )
);
$feather1_metaboxes = new_cmb2_box(
    array(
        'id' => 'feather1_metaboxes',
        'title' => __('بخش ویژه اول', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$feather1_metaboxes->add_field(
    array(
        'name' => 'وضعیت بخش ویژه 1',
        'id' => 'feather1_active',
        'type'             => 'radio',
        'default' => 'active',
        'options'          => array(
            'active' => __( 'فعال', 'cmb2' ),
            'inactive'   => __( 'غیرفعال', 'cmb2' ),
        ),
    )
);
$feather1_metaboxes->add_field(
    array(
        'name' => 'بک گراند دسکتاپ',
        'id' => 'feather1_back_lg',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$feather1_metaboxes->add_field(
    array(
        'name' => 'بک گراند موبایل',
        'id' => 'feather1_back_sm',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$feather1_metaboxes->add_field(
    array(
        'name' => 'عنوان',
        'id' => 'feather1_title',
        'type' => 'text_medium',
    )
);
$feather1_metaboxes->add_field(
    array(
        'name' => 'توضیحات',
        'id' => 'feather1_content',
        'type'    => 'wysiwyg',
    )
);

$feather2_metaboxes = new_cmb2_box(
    array(
        'id' => 'feather2_metaboxes',
        'title' => __('بخش ویژه دوم', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$feather2_metaboxes->add_field(
    array(
        'name' => 'وضعیت بخش ویژه 2',
        'id' => 'feather2_active',
        'type'             => 'radio',
        'default' => 'active',
        'options'          => array(
            'active' => __( 'فعال', 'cmb2' ),
            'inactive'   => __( 'غیرفعال', 'cmb2' ),
        ),
    )
);
$feather2_metaboxes->add_field(
    array(
        'name' => 'پوستر ویژه',
        'id' => 'feather2_poster',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$feather2_metaboxes->add_field(
    array(
        'name' => 'عنوان',
        'id' => 'feather2_title',
        'type' => 'text_medium',
    )
);
$feather2_metaboxes->add_field(
    array(
        'name' => 'توضیحات',
        'id' => 'feather2_content',
        'type'    => 'wysiwyg',
    )
);
$feather2_metaboxes->add_field(
    array(
        'name' => 'لینک دکمه مشاهده',
        'id' => 'feather2_btn_link',
        'type' => 'text_url',
    )
);
$feather3_metaboxes = new_cmb2_box(
    array(
        'id' => 'feather3_metaboxes',
        'title' => __('بخش ویژه سوم', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$feather3_metaboxes->add_field(
    array(
        'name' => 'وضعیت بخش ویژه 3',
        'id' => 'feather3_active',
        'type'             => 'radio',
        'default' => 'active',
        'options'          => array(
            'active' => __( 'فعال', 'cmb2' ),
            'inactive'   => __( 'غیرفعال', 'cmb2' ),
        ),
    )
);
$feather3_metaboxes->add_field(
    array(
        'name' => 'پوستر ویژه',
        'id' => 'feather3_poster',
        'type' => 'file',
        'query_args' => array(
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),)
    )
);
$feather3_metaboxes->add_field(
    array(
        'name' => 'عنوان',
        'id' => 'feather3_title',
        'type' => 'text_medium',
    )
);
$feather3_metaboxes->add_field(
    array(
        'name' => 'توضیحات',
        'id' => 'feather3_content',
        'type'    => 'wysiwyg',
    )
);
$feather3_metaboxes->add_field(
    array(
        'name' => 'لینک دکمه مشاهده',
        'id' => 'feather3_btn_link',
        'type' => 'text_url',
    )
);
$offer_game_metaboxes = new_cmb2_box(
    array(
        'id' => 'offer_game_metaboxes',
        'title' => __('بازی‌های مشابه', 'cmb2'),
        'object_types' => array('page'),
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
    )
);
$game_offer_escape = $offer_game_metaboxes->add_field( array(
    'id'          => 'game_offer_escape_repeat_group',
    'type'        => 'group',
    'description' => 'بازی‌‌های پیشنهادی',
    'repeatable'  => true,
    'options'     => array(
        'group_title'       => 'بازی',
        'add_button'        => 'بازی جدید',
        'remove_button'     => 'حذف بازی',
        'sortable'          => true,
        'closed'         => true,
        'remove_confirm' => 'آیا از حذف این بازی مطمئن هستید؟'
    ),
) );
$offer_game_metaboxes->add_group_field( $game_offer_escape, array(
    'name'             => 'بازی پیشنهادی',
    'desc'             => 'لطفا بازی که می‌خواهید پیشنهاد دهید را انتخاب بفرمائید. با خلوص نیت',
    'id'               => 'game_offer_escape_select',
    'type'             => 'select',
    'show_option_none' => true,
    'default'          => '',
    'options'          => postOffertOption(),
) );
$game_metabox_faq = new_cmb2_box( array(
    'id'               => 'game_metabox_faq_id',
    'title'            => 'سوالات متداول',
    'object_types'     => array('page'),
    'show_names'       => true,
) );
$faq_game_fields = $game_metabox_faq->add_field( array(
    'id'          => 'faq_game_fields_group',
    'type'        => 'group',
    'repeatable'  => true,
    'options'     => array(
        'group_title'       => 'سوال متداول {#}',
        'add_button'        => 'افزودن سوال جدید',
        'remove_button'     => 'حذف سوال',
        'sortable'          => true,
        'closed'         => true,
        'remove_confirm' => 'آیا از حذف سوال مطمئن هستید؟',
    ),
) );
$game_metabox_faq->add_group_field( $faq_game_fields, array(
    'name' => 'سوال',
    'id'   => 'game_faq_question',
    'type' => 'text',
) );
$game_metabox_faq->add_group_field( $faq_game_fields, array(
    'name' => 'جواب',
    'id'   => 'game_faq_answer',
    'type'    => 'wysiwyg',
) );
function postOffertOption()
{
    $args = array(
        'post_type' => 'product',
        'orderby'   => 'date',
        'order'     => 'DESC',
        'posts_per_page' => -1
    );
    $courses = get_posts( $args );
    $options = [];
    foreach ( $courses as $course ) {
        $options += [$course->ID => $course->post_title];
    }
    return $options;
}