<?php
/* Template Name: test*/
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

if (check__user() == "poshtiban" || check__user() == 'administrator' || check__user() == 'shop_manager' || check__user() == 'shopist' || check__user() == 'contentist') {

    get_header();

// 'test test test '.do_shortcode('[spoil]Content[/spoil]').'test test test ';
    ?>


    <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

    <link rel="stylesheet" type="text/css"
          href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css">

    <script type="text/javascript" src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>

    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


    <script type="text/javascript">

        $(document).ready(function () {
            $('#example').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'
                }
                ,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel'
                ],
                "pageLength": 50
            });


            $('#example2').DataTable({
                "order": [[1, "desc"]],
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'
                }
                ,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel'
                ]
            });


        });

    </script>

<?php 
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$args_query = array(
    'post_type'      => 'product',
    'post_status'    => 'publish',
    'paged'          => $paged, 
    'posts_per_page' => 400,
);
$the_query = new WP_Query($args_query);
?>

    <div class="container main-warp">

        <main id="main" class="other-pages" role="main">

            <header class="entry-header mb-5">
                <a href="?view=rooms" class="btn btn-secondary">اتاق فرارها</a>
                <a href="?view=orders" class="btn btn-secondary">مشخصات رزرو ها</a>
                <a href="?view=sans" class="btn btn-secondary">سانس های موجود</a>
                    
                <?php if ($the_query->max_num_pages > 1): ?>
                    <select class="btn btn-secondary" onchange="ChangeLocation(this.value)">
                        <?php for($i = 1; $i <= $the_query->max_num_pages; $i++): ?>
                            <option value="<?php echo $i;?>" <?php if($paged == $i) echo 'selected="selected"';?>><?php echo $i;?></option>
                        <?php endfor;?>
                    </select>
                    <script>
                        function ChangeLocation(value){
                            window.location.assign(`?paged=${value}`)
                        }
                    </script>
                <?php endif;?>
                
                

            </header><!-- .entry-header -->

            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <section class="other-pages-content">

                    <div class="entry-content">


                        <table id="example" class="display" style="width:100%">
                            <thead>
                            <tr>
                                <th>ID</th>
                                <th>بازی</th>
                                <th>مجموعه</th>
                                <th>بازدید</th>
                                <th>تعداد فروش</th>
                                <th>موبایل</th>
                                <th>شماره اپراتور</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php if ($the_query->have_posts()) : ?>

                                <!-- pagination here -->

                                <!-- the loop -->
                                <?php while ($the_query->have_posts()) : $the_query->the_post();
                                    global $product;

                                    $product_brands = get_the_terms($product->get_id(), 'yith_product_brand');

                                    $sale_active = get_field('sale_active');
                                    $ez_sale_price = get_field('price_asli');
                                    $special_room = get_field('special_room');
                                    $_featured = get_field('featured');
                                    $product = wc_get_product(get_the_ID());
                                    $featured = $product->get_featured();
                                    $zardkooh_product_views = get_field('zardkooh_product_views'); ?>

                                    <tr>
                                        <td><?php the_ID(); ?></td>
                                        <td><?php $category = get_the_category();
                                            the_title();
                                            echo single_cat_title('', true); ?> - <?php global $post, $product;
                                            $categ = $product->get_categories();
                                            echo strip_tags($categ); ?></td>
                                        <td><?php echo $product_brands[0]->name; ?>  </td>
                                        <td><?= $zardkooh_product_views; ?></td>
                                        <td><?php echo get_post_meta(get_the_ID(), 'total_sales', true); ?></td>
                                        <td><?php the_field('room_phone'); ?></td>
                                        <td dir="ltr"><?php $user_info = get_field('user_ebtal');
                                            $myuser_info = get_userdata($user_info);
                                            echo $myuser_info->user_login; ?></td>
                                        <td><a target="_blank" href="<?php the_permalink() ?>">مشاهده</a> |
                                            <a target="_blank"
                                               href="https://escapezoom.ir/wp-admin/post.php?post=<?php the_ID(); ?>&action=edit">ویرایش</a>
                                            |
                                            <a target="_blank"
                                               href="https://escapezoom.ir/wp-admin/term.php?taxonomy=yith_product_brand&tag_ID=<?php the_ID(); ?>&post_type=product">ویرایش
                                                برند</a>

                                        </td>
                                    </tr>
                                <?php endwhile; ?>
                                <?php wp_reset_postdata(); ?>
                            <?php else : ?>
                                <p><?php _e('Sorry, no posts matched your criteria.'); ?></p>
                            <?php endif; ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th>ID</th>
                                <th>بازی</th>
                                <th>مجموعه</th>
                                <th>بازدید</th>
                                <th>تعداد فروش</th>
                                <th>موبایل</th>
                                <th>شماره اپراتور</th>
                                <th>عملیات</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>
                </section>

            </article>
        </main><!-- #main -->

    </div><!-- .container main -->

    <?php get_footer();
}
?>