<?php get_header(); ?>

    <h1 style="font-weight: 600; font-size: 24px; margin-top: 10px; color: #F21543;display: flex;align-items: center; gap:8px;">
    <span style="filter: drop-shadow(0px 1px 2px rgba(0, 0, 0, 0.25));transform: rotate(180deg); position: relative;width: 41px;height: 41px;margin-left: 10px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 32 32" fill="none"
                             style="position: absolute;left: 0;top: 0;transform:translate(6px,8px);z-index: 1;">
      <path fill-rule="evenodd" clip-rule="evenodd"
            d="M26.4221 10.7605C26.6894 10.5553 26.863 10.2506 26.9047 9.91351C26.9464 9.57639 26.8527 9.23442 26.6443 8.96281L24.4212 6.06587C24.2105 5.80088 23.9059 5.628 23.5729 5.58446C23.2399 5.54092 22.9051 5.63021 22.6407 5.83309C22.3764 6.03598 22.2035 6.33622 22.1594 6.66917C22.1153 7.00211 22.2035 7.34111 22.405 7.61316L23.8422 9.48602L22.2937 10.6744L20.8565 8.80152C20.6458 8.53653 20.3412 8.36365 20.0081 8.32011C19.6751 8.27657 19.3404 8.36586 19.076 8.56874C18.8116 8.77162 18.6388 9.07187 18.5947 9.40482C18.5506 9.73776 18.6388 10.0768 18.8402 10.3488L20.2775 12.2217L12.4009 18.2647C11.4146 17.4875 10.1852 17.0939 8.94331 17.1577C7.70138 17.2215 6.53213 17.7383 5.65473 18.6112C4.77733 19.4842 4.25203 20.6533 4.17729 21.8995C4.10255 23.1457 4.48351 24.3834 5.24874 25.3806C6.01398 26.3777 7.11097 27.0659 8.33407 27.3161C9.55717 27.5663 10.8224 27.3614 11.8926 26.7397C12.9628 26.118 13.7645 25.1223 14.1475 23.9391C14.5304 22.756 14.4682 21.4666 13.9727 20.3128L26.4221 10.7605ZM8.96694 24.8287C9.63992 24.9226 10.3184 24.7448 10.8533 24.3344C11.3881 23.9239 11.7354 23.3145 11.8187 22.6401C11.9021 21.9658 11.7147 21.2817 11.2978 20.7384C10.8809 20.1951 10.2686 19.8371 9.59559 19.7432C8.92261 19.6493 8.24408 19.8271 7.70927 20.2375C7.17445 20.6479 6.82716 21.2573 6.7438 21.9317C6.66044 22.6061 6.84783 23.2902 7.26475 23.8334C7.68167 24.3767 8.29396 24.7347 8.96694 24.8287Z"
            fill="#ffffff"/>
      <circle cx="9.8806" cy="6.0847" r="3.08665" fill="#ffffff"/>
      <circle cx="26.9128" cy="24.9719" r="3.08665" fill="#ffffff"/>
    </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none"
                             style="position: absolute;left: 0;right: 0;bottom: 0;top: 0;">
  <path d="M39.9221 24.4033C38.5688 22.0621 38.5698 19.1755 39.9241 16.8349C40.1873 16.3796 40.2589 15.8384 40.1231 15.3304C39.9874 14.8223 39.6554 14.389 39.2002 14.1256C36.8624 12.7744 35.412 10.2729 35.412 7.57269C35.412 7.04668 35.2031 6.54221 34.8311 6.17026C34.4592 5.79831 33.9547 5.58935 33.4287 5.58935C30.7297 5.58935 28.2299 4.14009 26.8797 1.80317C26.6168 1.34766 26.1837 1.01521 25.6758 0.878932C25.4241 0.811502 25.1617 0.794312 24.9034 0.828342C24.6451 0.862373 24.396 0.946958 24.1704 1.07727C21.8268 2.43191 18.9372 2.43084 16.594 1.07528C16.1385 0.812288 15.5972 0.741017 15.0891 0.877149C14.581 1.01328 14.1478 1.34567 13.8848 1.80118C12.5341 4.13795 10.0328 5.58935 7.33381 5.58935C6.80779 5.58935 6.30332 5.79831 5.93137 6.17026C5.55942 6.54221 5.35046 7.04668 5.35046 7.57269C5.35046 10.2717 3.89903 12.773 1.56227 14.1236C1.33663 14.254 1.13889 14.4276 0.980369 14.6345C0.821848 14.8414 0.705651 15.0774 0.63842 15.3292C0.571188 15.581 0.554242 15.8436 0.588547 16.1019C0.622853 16.3603 0.70774 16.6093 0.838354 16.8349C2.19289 19.1758 2.19289 22.0623 0.838354 24.4033C0.57653 24.859 0.505493 25.3997 0.64073 25.9076C0.775967 26.4155 1.10651 26.8493 1.56029 27.1145C3.89705 28.4652 5.34848 30.9664 5.34848 33.6654C5.34848 34.1915 5.55744 34.6959 5.92939 35.0679C6.30134 35.4398 6.80581 35.6488 7.33183 35.6488C10.0321 35.6488 12.5335 37.0991 13.8848 39.437C14.0604 39.7371 14.3111 39.9864 14.6122 40.1603C14.9134 40.3341 15.2546 40.4266 15.6024 40.4286C15.9475 40.4286 16.2906 40.3374 16.596 40.1609C18.9372 38.8062 21.8267 38.8073 24.1684 40.1609C24.6237 40.424 25.1649 40.4956 25.6729 40.3598C26.181 40.2241 26.6143 39.8921 26.8777 39.437C28.2274 37.0998 30.7278 35.6488 33.4267 35.6488C33.9527 35.6488 34.4572 35.4398 34.8291 35.0679C35.2011 34.6959 35.41 34.1915 35.41 33.6654C35.41 30.9664 36.8615 28.4652 39.1982 27.1145C39.4239 26.9841 39.6216 26.8105 39.7801 26.6036C39.9386 26.3968 40.0548 26.1607 40.1221 25.9089C40.1893 25.6571 40.2063 25.3945 40.172 25.1362C40.1376 24.8778 40.0528 24.6288 39.9221 24.4033Z"
        fill="url(#paint0_linear_279_28)"/>
  <defs>
    <linearGradient id="paint0_linear_279_28" x1="30" y1="22" x2="46.5" y2="67.5" gradientUnits="userSpaceOnUse">
      <stop stop-color="#F21543"/>
      <stop offset="1" stop-color="#8C0C27"/>
    </linearGradient>
  </defs>
</svg>
                    </span>
        <?= 'تفریحات با تخفیف ویژه!' ?></h1>
    <p style="margin-top: 20px; text-align: justify;">
        توی این صفحه همۀ بازی‌های گروهی پرطرف‌دار از اتاق فرار گرفته تا سینما ترس، لیزرتگ و اتاق خشم که تخفیف ویژه دارند
        رو براتون یه‌جا جمع کردیم. حالا می‌تونید با بهترین قیمت، هیجان رو تجربه کنید!
    </p>
<?php


$posts_per_page = 100;

$params = [
    'product_type' => 'اتاق فرار',
];

$args = [
    'params'        => $params,
    'image_type'    => 'url',
    'limit'         => $posts_per_page,
    'page'          => 1,
    'max_num_pages' => true,
    "format"        => 'html_slider',
    'is_mobile'     => wp_is_mobile(),
    'sort_type'     => 'popular',
    'show_more'     => 0,
    'only_events'   => true,
    'event_type'    => "discount",
    'random'        => true,
    'badge_ads'     => false,
];
$products2 = json_decode ( ez_webservice( array('type' => 'sort_products_get', 'data' => $args) ) )->products;


if ( !empty( $products2 ) ) : ?>

   

    <div id="adsx_wrapper" class="elite_rooms_wrapper" style="position: relative;z-index: 2; background: #f3f3f3; padding: 10px; border: 1px solid #e3e2e2; border-radius: 8px; margin: 20px 0;">

        <div class="slider-container-header" style="margin-bottom: 30px">
            <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;font-weight: 600;color: #F21543;">
                تخفیف اتاق فرار
            </h2>
            <div class="select-container"
                 style="display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 2rem;">
                <div class="container-list">
                    <div class="dropdown">
                        <input type="text" placeholder="شهر..." class="search-input" id="searchInputRooms">
                        <div class="list-container" id="listContainerRooms">
                            <div class="list-item-rooms" data-name="تهران">تهران</div>
                            <div class="list-item-rooms" data-name="کرج">کرج</div>
                            <div class="list-item-rooms" data-name="اراک">اراک</div>
                            <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                            <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                            <div class="list-item-rooms" data-name="قم">قم</div>
                            <div class="list-item-rooms" data-name="تهران">تهران</div>
                            <div class="list-item-rooms" data-name="کرج">کرج</div>
                            <div class="list-item-rooms" data-name="اراک">اراک</div>
                            <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                            <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                            <div class="list-item-rooms" data-name="قم">قم</div>
                            <div class="list-item-rooms" data-name="تهران">تهران</div>
                            <div class="list-item-rooms" data-name="کرج">کرج</div>
                            <div class="list-item-rooms" data-name="اراک">اراک</div>
                            <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                            <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                            <div class="list-item-rooms" data-name="قم">قم</div>
                            <div class="list-item-rooms" data-name="تهران">تهران</div>
                            <div class="list-item-rooms" data-name="کرج">کرج</div>
                            <div class="list-item-rooms" data-name="اراک">اراک</div>
                            <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                            <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                            <div class="list-item-rooms" data-name="قم">قم</div>
                            <div class="list-item-rooms" data-name="تهران">تهران</div>
                            <div class="list-item-rooms" data-name="کرج">کرج</div>
                            <div class="list-item-rooms" data-name="اراک">اراک</div>
                            <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                            <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                            <div class="list-item-rooms" data-name="قم">قم</div>
                        </div>
                    </div>
                </div>
                <select name="" id="">
                    <option class="list-selection sort-select" data-source="all">همه</option>
                    <option class="list-selection sort-select" data-source="1">امروز</option>
                    <option class="list-selection sort-select" data-source="2">فردا</option>
                    <option class="list-selection sort-select" data-source="3">پس‌فردا</option>
                </select>
            </div>
        </div>

        <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom" style="align-items: stretch;display: flex;">
            
            <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                <?php echo $products2; ?>
            </div>
        </div>
    </div>

<?php
endif;

$args = [
    "source" => "home_discounts_event",
];
$products = json_decode(ez_webservice(array('type' => 'sort_products_get', 'data' => $args)));


?>

    <style>
        button.list-btn {
            background: #ffffff;
            border-radius: 10px;
            padding: 0px 10px;
            color: #cbcbcb;
            border: 1px solid;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        button.list-btn.active {
            color: #FB7017;
        }

        button.swiper-slide.city-btn {
            background: #ffffff;
            border-radius: 10px;
            padding: 0px 10px;
            color: #cbcbcb;
            border: 1px solid;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            width: 100px !important;
        }

        button.swiper-slide.city-btn.swiper-slide-active {
            color: #FB7017;
        }

        div.slide-swiper-container {
            max-width: 700px;
        }

        button.slider-btn-city {
            background: #fff;
            border: 1px solid;
            border-color: inherit;
            border-radius: 12px;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            left: 0px;
            z-index: 999;
            top: 3.5px;
            color: #cbcbcb;
        }

        button.slider-btn-city:hover {
            color: #FB7017;
        }

        .slider-container-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding-left: 40px;
        }

        .slider-container-header h2 {
            margin-bottom: unset;
        }

        .slider-container-header select {
            min-width: 200px;
            padding: 5px 10px;
            border: 1px solid #FC7013;
            border-radius: 10px;
            box-shadow: unset;
        }

        @media screen and (max-width: 768px) {
            .slider-container-header {
                align-items: start;
                flex-direction: column;
            }

            .slider-container-header h2 {
                margin-bottom: 30px;
            }

            .slider-container-header .select-container {
                width: 100%;
            }

            .slider-container-header .select-container select {
                min-width: unset;
                width: 100%;
            }

            .container-list {
                width: 100% !important;
            }
        }

        .container-list {
            width: 200px;
            margin: 0 auto;
        }

        .dropdown {
            position: relative;
        }

        .search-input {
            width: 100%;
            padding: 5px 10px;
            height: 40px;
            box-sizing: border-box;
            border: 1px solid #FC7013;
            border-radius: 10px;
            cursor: pointer;
        }

        .list-container {
            max-height: 50vh;
            overflow-y: auto;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
            display: none; /* Initially hidden */
            position: absolute;
            width: 100%;
            background-color: white;
            z-index: 9; /* To keep it above other elements */
        }

        .list-item {
            padding: 10px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
        }

        .list-item:hover {
            background-color: #f2f2f2;
        }
    </style>




    <main>
        <?php if ($products): ?>
            <div id="adsx_wrapper" class="elite_rooms_wrapper"
                 style="position: relative;z-index: 2; background: #EFF3F7; padding: 38px 40px 38px 0; border-radius: 20px; margin: 20px 0; min-height: 400px;">
                <div class="slider-container-header" style="margin-bottom: 30px">
                    <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;font-weight: 600;color: #F21543;">
                        تخفیف اتاق فرار
                    </h2>
                    <div class="select-container"
                         style="display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 2rem;">
                        <div class="container-list">
                            <div class="dropdown">
                                <input type="text" placeholder="شهر..." class="search-input" id="searchInputRooms">
                                <div class="list-container" id="listContainerRooms">
                                    <div class="list-item-rooms" data-name="تهران">تهران</div>
                                    <div class="list-item-rooms" data-name="کرج">کرج</div>
                                    <div class="list-item-rooms" data-name="اراک">اراک</div>
                                    <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                                    <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-rooms" data-name="قم">قم</div>
                                    <div class="list-item-rooms" data-name="تهران">تهران</div>
                                    <div class="list-item-rooms" data-name="کرج">کرج</div>
                                    <div class="list-item-rooms" data-name="اراک">اراک</div>
                                    <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                                    <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-rooms" data-name="قم">قم</div>
                                    <div class="list-item-rooms" data-name="تهران">تهران</div>
                                    <div class="list-item-rooms" data-name="کرج">کرج</div>
                                    <div class="list-item-rooms" data-name="اراک">اراک</div>
                                    <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                                    <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-rooms" data-name="قم">قم</div>
                                    <div class="list-item-rooms" data-name="تهران">تهران</div>
                                    <div class="list-item-rooms" data-name="کرج">کرج</div>
                                    <div class="list-item-rooms" data-name="اراک">اراک</div>
                                    <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                                    <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-rooms" data-name="قم">قم</div>
                                    <div class="list-item-rooms" data-name="تهران">تهران</div>
                                    <div class="list-item-rooms" data-name="کرج">کرج</div>
                                    <div class="list-item-rooms" data-name="اراک">اراک</div>
                                    <div class="list-item-rooms" data-name="مشهد">مشهد</div>
                                    <div class="list-item-rooms" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-rooms" data-name="قم">قم</div>
                                </div>
                            </div>
                        </div>
                        <select name="" id="">
                            <option class="list-selection sort-select" data-source="all">همه</option>
                            <option class="list-selection sort-select" data-source="1">امروز</option>
                            <option class="list-selection sort-select" data-source="2">فردا</option>
                            <option class="list-selection sort-select" data-source="3">پس‌فردا</option>
                        </select>
                    </div>
                </div>
                <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom"
                     style="align-items: stretch;display: flex; height: 360px !important;">
                    <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                        <?php foreach ($products->products as $product): ?>
                            <article class="swiper-slide desktop-cart-product"
                                     style="height: 350px !important; width: 210px !important;">
                                <figure>
                                    <img src="<?= $product->image; ?>"
                                         alt="<?= $product->type . ' ' . $product->title ?>"
                                         style="width: 100%!important;height: 184px;object-fit: cover; object-position: top;"/>
                                    <?php if ($product->event): ?>
                                        <div style="position: absolute; z-index: 999; background: red; top: 5px; left: 5px; font-size: 11px; color: white; width: 30px; height: 30px; border-radius: 100%; display: flex; align-items: center; justify-content: center; font-weight: 400; text-shadow: 1px 1px 8px black;">
                                            <span style="margin-top: 2px">%</span>
                                            <span style="margin-top: 2px"><?= $product->event->off_percentage ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                    if ($product->ads and 0): ?>
                                        <div class="desktop-cart-product-ads">AD</div>
                                    <?php
                                    endif ?>
                                    <div class="flex-full desktop-cart-product-rated">
                                        <span><?= $product->rate ?></span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                             viewBox="0 0 16 16" fill="none">
                                            <path d="M14.6431 7.17815L11.8306 9.60502L12.6875 13.2344C12.7347 13.4314 12.7226 13.638 12.6525 13.8281C12.5824 14.0182 12.4575 14.1833 12.2937 14.3025C12.1298 14.4217 11.9343 14.4896 11.7319 14.4977C11.5294 14.5059 11.3291 14.4538 11.1562 14.3481L7.99996 12.4056L4.84184 14.3481C4.66898 14.4532 4.4689 14.5048 4.2668 14.4963C4.06469 14.4879 3.8696 14.4199 3.70609 14.3008C3.54257 14.1817 3.41795 14.0169 3.3479 13.8272C3.27786 13.6374 3.26553 13.4312 3.31246 13.2344L4.17246 9.60502L1.35996 7.17815C1.20702 7.04596 1.09641 6.87166 1.04195 6.67699C0.987486 6.48232 0.99158 6.27592 1.05372 6.08356C1.11586 5.89121 1.23329 5.72142 1.39135 5.59541C1.54941 5.4694 1.7411 5.39274 1.94246 5.37502L5.62996 5.07752L7.05246 1.63502C7.12946 1.44741 7.2605 1.28693 7.42894 1.17398C7.59738 1.06104 7.7956 1.00073 7.9984 1.00073C8.2012 1.00073 8.39942 1.06104 8.56785 1.17398C8.73629 1.28693 8.86734 1.44741 8.94434 1.63502L10.3662 5.07752L14.0537 5.37502C14.2555 5.39208 14.4477 5.46831 14.6064 5.59415C14.765 5.71999 14.883 5.88984 14.9455 6.08243C15.008 6.27502 15.0123 6.48178 14.9579 6.6768C14.9034 6.87182 14.7926 7.04644 14.6393 7.17877L14.6431 7.17815Z"
                                                  fill="#FFAE00"/>
                                        </svg>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-footer-hover">
                                        <div><?= get_product_type_equivalent($product->type) ?></div>
                                        <div class="flex-full">
                                            <span><?= $product->number_min ?></span>
                                            <span>تا</span>
                                            <span><?= $product->number_max ?></span>
                                            <span>نفر</span>
                                        </div>
                                        <div>
                                            <?php if ($product->free_sanses): ?>
                                                <div style="color: #fff;background: #FD7114;padding: 2px 10px;border-radius: 8px;">
                                                    <span style="font-size: 15px"><?= $product->free_sanses ?></span>
                                                    <span style="font-size: 12px">سانس </span>
                                                </div>
                                            <?php else: ?>
                                                <span style="font-size: font-size: 14px;color: #fff;background: #dc3545;padding: 2px 10px;border-radius: 8px;">تکمیل</span>
                                            <?php endif ?>
                                        </div>
                                        <div class="desktop-cart-product-footer-hover-link">
                                            <span>از</span>
                                            <span><?= number_format($product->price) ?></span>
                                            <span>تومان</span>
                                        </div>
                                    </a>
                                </figure>
                                <div class="desktop-cart-product-header">
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>">
                                        <h3 class="text-clamp-1"><?= $product->title ?></h3>
                                    </a>
                                </div>
                                <div class="flex-full" style="align-items: start;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14"
                                         fill="none">
                                        <path d="M5.63158 7.9C6.18386 7.9 6.63158 8.34772 6.63158 8.9V11.7C6.63158 12.2523 6.18386 12.7 5.63158 12.7H3C2.44772 12.7 2 12.2523 2 11.7V8.9C2 8.34771 2.44772 7.9 3 7.9H5.63158ZM6.34913 2.46081C6.736 1.80473 7.68505 1.80473 8.07192 2.46081L9.50555 4.89206C9.89864 5.55869 9.41805 6.4 8.64416 6.4H5.77689C5.003 6.4 4.52241 5.55869 4.9155 4.89206L6.34913 2.46081ZM10.3947 7.6C11.8421 7.6 13 8.8 13 10.3C13 11.8 11.8421 13 10.3947 13C8.94737 13 7.78947 11.8 7.78947 10.3C7.78947 8.8 8.94737 7.6 10.3947 7.6Z"
                                              fill="#9C9C9C"/>
                                    </svg>
                                    <div class="flex-full desktop-cart-product-detail-tags">
                                        <?php
                                        if ($product->genres):
                                            for ($i = 0; $i < min(3, count($product->genres)); $i++) {
                                                echo '<div>' . $product->genres[$i]->title . '</div>';
                                            }
                                        endif;
                                        ?>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: center; justify-content: space-between;">
                                    <div class="desktop-cart-product-location">
                                        <div class="flex-full">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                 viewBox="0 0 14 14" fill="none">
                                                <path d="M7 0.875C8.39239 0.875 9.72775 1.40616 10.7123 2.35164C11.6969 3.29712 12.25 4.57946 12.25 5.91657C12.25 8.04695 10.6912 10.3687 7.61385 12.9065C7.44274 13.0477 7.22457 13.1252 6.99899 13.125C6.77341 13.1248 6.55539 13.0469 6.38454 12.9055L6.181 12.7359C3.23992 10.2642 1.75 7.99938 1.75 5.91657C1.75 4.57946 2.30312 3.29712 3.28769 2.35164C4.27226 1.40616 5.60761 0.875 7 0.875ZM7 3.9775C6.46447 3.9775 5.95087 4.1818 5.57219 4.54544C5.19351 4.90909 4.98077 5.4023 4.98077 5.91657C4.98077 6.43084 5.19351 6.92405 5.57219 7.28769C5.95087 7.65134 6.46447 7.85563 7 7.85563C7.53553 7.85563 8.04913 7.65134 8.42781 7.28769C8.80649 6.92405 9.01923 6.43084 9.01923 5.91657C9.01923 5.4023 8.80649 4.90909 8.42781 4.54544C8.04913 4.1818 7.53553 3.9775 7 3.9775Z"
                                                      fill="#9C9C9C"/>
                                            </svg>
                                            <span><?php echo $product->city_name . ', ' . $product->hood_name ?></span>
                                        </div>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-link" style="position: static !important;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"
                                             viewBox="0 0 16 12" fill="none">
                                            <path d="M0.365566 5.08126C0.131482 5.31563 -2.75235e-07 5.63334 -2.60756e-07 5.96459C-2.46276e-07 6.29584 0.131482 6.61355 0.365567 6.84793L5.0789 11.5638C5.3134 11.7983 5.63144 11.93 5.96307 11.93C6.29469 11.93 6.61274 11.7983 6.84723 11.5638C7.08173 11.3293 7.21347 11.0112 7.21347 10.6796C7.21347 10.348 7.08173 10.0299 6.84723 9.79543L4.26723 7.21459L13.8797 7.21459C14.2113 7.21459 14.5292 7.0829 14.7636 6.84847C14.998 6.61405 15.1297 6.29611 15.1297 5.96459C15.1297 5.63307 14.998 5.31513 14.7636 5.08071C14.5292 4.84629 14.2113 4.71459 13.8797 4.71459L4.26723 4.71459L6.84723 2.13459C6.96334 2.01848 7.05545 1.88064 7.11828 1.72893C7.18112 1.57723 7.21347 1.41463 7.21347 1.25043C7.21347 1.08622 7.18112 0.923623 7.11828 0.771917C7.05545 0.620211 6.96334 0.482368 6.84723 0.366257C6.73112 0.250148 6.59328 0.158045 6.44157 0.095206C6.28987 0.0323674 6.12727 2.45277e-05 5.96307 2.45349e-05C5.79886 2.45421e-05 5.63626 0.0323675 5.48456 0.095206C5.33285 0.158045 5.19501 0.250148 5.0789 0.366257L0.365566 5.08126Z"
                                                  fill="white"/>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <style>
                .timer-box-container {
                    display: flex;
                    gap: 2px;
                }

                .box-time-character {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    color: white;
                    font-size: 20px;
                    font-weight: 900;
                    border-radius: 6px;
                    text-shadow: 0px 4px 4px rgba(0, 0, 0, 0.25);
                    width: 30px;
                    height: 30px;
                    background: linear-gradient(161deg, #F21543 65.74%, #8C0C27 167.69%);
                    box-shadow: 0px 4px 4px 0px rgba(0, 0, 0, 0.25);
                }

                @media screen and (max-width: 768px) {
                    .event-products-header {
                        flex-direction: column;
                        gap: 10px;
                        align-items: stretch;
                    }
                }
            </style>
        <?php endif; ?>
        <?php if ($products): ?>
            <div id="adsx_wrapper" class="elite_rooms_wrapper"
                 style="position: relative;z-index: 2; background: #EFF3F7; padding: 38px 40px 38px 0; border-radius: 20px; margin: 20px 0; min-height: 400px;">
                <div class="slider-container-header" style="margin-bottom: 30px">
                    <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;font-weight: 600;color: #F21543;">
                        تخفیف لیزرتک
                    </h2>
                    <div class="select-container"
                         style="display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 2rem;">
                        <div class="container-list">
                            <div class="dropdown">
                                <input type="text" placeholder="شهر..." class="search-input" id="searchInputLaizer">
                                <div class="list-container" id="listContainerLaizer">
                                    <div class="list-item-laizer" data-name="تهران">تهران</div>
                                    <div class="list-item-laizer" data-name="کرج">کرج</div>
                                    <div class="list-item-laizer" data-name="اراک">اراک</div>
                                    <div class="list-item-laizer" data-name="مشهد">مشهد</div>
                                    <div class="list-item-laizer" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-laizer" data-name="قم">قم</div>
                                    <div class="list-item-laizer" data-name="تهران">تهران</div>
                                    <div class="list-item-laizer" data-name="کرج">کرج</div>
                                    <div class="list-item-laizer" data-name="اراک">اراک</div>
                                    <div class="list-item-laizer" data-name="مشهد">مشهد</div>
                                    <div class="list-item-laizer" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-laizer" data-name="قم">قم</div>
                                    <div class="list-item-laizer" data-name="تهران">تهران</div>
                                    <div class="list-item-laizer" data-name="کرج">کرج</div>
                                    <div class="list-item-laizer" data-name="اراک">اراک</div>
                                    <div class="list-item-laizer" data-name="مشهد">مشهد</div>
                                    <div class="list-item-laizer" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-laizer" data-name="قم">قم</div>
                                    <div class="list-item-laizer" data-name="تهران">تهران</div>
                                    <div class="list-item-laizer" data-name="کرج">کرج</div>
                                    <div class="list-item-laizer" data-name="اراک">اراک</div>
                                    <div class="list-item-laizer" data-name="مشهد">مشهد</div>
                                    <div class="list-item-laizer" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-laizer" data-name="قم">قم</div>
                                    <div class="list-item-laizer" data-name="تهران">تهران</div>
                                    <div class="list-item-laizer" data-name="کرج">کرج</div>
                                    <div class="list-item-laizer" data-name="اراک">اراک</div>
                                    <div class="list-item-laizer" data-name="مشهد">مشهد</div>
                                    <div class="list-item-laizer" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-laizer" data-name="قم">قم</div>
                                </div>
                            </div>
                        </div>
                        <select name="" id="">
                            <option class="list-selection sort-select" data-source="all">همه</option>
                            <option class="list-selection sort-select" data-source="1">امروز</option>
                            <option class="list-selection sort-select" data-source="2">فردا</option>
                            <option class="list-selection sort-select" data-source="3">پس‌فردا</option>
                        </select>
                    </div>
                </div>
                <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom"
                     style="align-items: stretch;display: flex; height: 360px !important;">
                    <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                        <?php foreach ($products->products as $product): ?>
                            <article class="swiper-slide desktop-cart-product"
                                     style="height: 350px !important; width: 210px !important;">
                                <figure>
                                    <img src="<?= $product->image; ?>"
                                         alt="<?= $product->type . ' ' . $product->title ?>"
                                         style="width: 100%!important;height: 184px;object-fit: cover; object-position: top;"/>
                                    <?php if ($product->event): ?>
                                        <div style="position: absolute; z-index: 999; background: red; top: 5px; left: 5px; font-size: 11px; color: white; width: 30px; height: 30px; border-radius: 100%; display: flex; align-items: center; justify-content: center; font-weight: 400; text-shadow: 1px 1px 8px black;">
                                            <span style="margin-top: 2px">%</span>
                                            <span style="margin-top: 2px"><?= $product->event->off_percentage ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                    if ($product->ads and 0): ?>
                                        <div class="desktop-cart-product-ads">AD</div>
                                    <?php
                                    endif ?>
                                    <div class="flex-full desktop-cart-product-rated">
                                        <span><?= $product->rate ?></span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                             viewBox="0 0 16 16" fill="none">
                                            <path d="M14.6431 7.17815L11.8306 9.60502L12.6875 13.2344C12.7347 13.4314 12.7226 13.638 12.6525 13.8281C12.5824 14.0182 12.4575 14.1833 12.2937 14.3025C12.1298 14.4217 11.9343 14.4896 11.7319 14.4977C11.5294 14.5059 11.3291 14.4538 11.1562 14.3481L7.99996 12.4056L4.84184 14.3481C4.66898 14.4532 4.4689 14.5048 4.2668 14.4963C4.06469 14.4879 3.8696 14.4199 3.70609 14.3008C3.54257 14.1817 3.41795 14.0169 3.3479 13.8272C3.27786 13.6374 3.26553 13.4312 3.31246 13.2344L4.17246 9.60502L1.35996 7.17815C1.20702 7.04596 1.09641 6.87166 1.04195 6.67699C0.987486 6.48232 0.99158 6.27592 1.05372 6.08356C1.11586 5.89121 1.23329 5.72142 1.39135 5.59541C1.54941 5.4694 1.7411 5.39274 1.94246 5.37502L5.62996 5.07752L7.05246 1.63502C7.12946 1.44741 7.2605 1.28693 7.42894 1.17398C7.59738 1.06104 7.7956 1.00073 7.9984 1.00073C8.2012 1.00073 8.39942 1.06104 8.56785 1.17398C8.73629 1.28693 8.86734 1.44741 8.94434 1.63502L10.3662 5.07752L14.0537 5.37502C14.2555 5.39208 14.4477 5.46831 14.6064 5.59415C14.765 5.71999 14.883 5.88984 14.9455 6.08243C15.008 6.27502 15.0123 6.48178 14.9579 6.6768C14.9034 6.87182 14.7926 7.04644 14.6393 7.17877L14.6431 7.17815Z"
                                                  fill="#FFAE00"/>
                                        </svg>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-footer-hover">
                                        <div><?= get_product_type_equivalent($product->type) ?></div>
                                        <div class="flex-full">
                                            <span><?= $product->number_min ?></span>
                                            <span>تا</span>
                                            <span><?= $product->number_max ?></span>
                                            <span>نفر</span>
                                        </div>
                                        <div>
                                            <?php if ($product->free_sanses): ?>
                                                <div style="color: #fff;background: #FD7114;padding: 2px 10px;border-radius: 8px;">
                                                    <span style="font-size: 15px"><?= $product->free_sanses ?></span>
                                                    <span style="font-size: 12px">سانس </span>
                                                </div>
                                            <?php else: ?>
                                                <span style="font-size: font-size: 14px;color: #fff;background: #dc3545;padding: 2px 10px;border-radius: 8px;">تکمیل</span>
                                            <?php endif ?>
                                        </div>
                                        <div class="desktop-cart-product-footer-hover-link">
                                            <span>از</span>
                                            <span><?= number_format($product->price) ?></span>
                                            <span>تومان</span>
                                        </div>
                                    </a>
                                </figure>
                                <div class="desktop-cart-product-header">
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>">
                                        <h3 class="text-clamp-1"><?= $product->title ?></h3>
                                    </a>
                                </div>
                                <div class="flex-full" style="align-items: start;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14"
                                         fill="none">
                                        <path d="M5.63158 7.9C6.18386 7.9 6.63158 8.34772 6.63158 8.9V11.7C6.63158 12.2523 6.18386 12.7 5.63158 12.7H3C2.44772 12.7 2 12.2523 2 11.7V8.9C2 8.34771 2.44772 7.9 3 7.9H5.63158ZM6.34913 2.46081C6.736 1.80473 7.68505 1.80473 8.07192 2.46081L9.50555 4.89206C9.89864 5.55869 9.41805 6.4 8.64416 6.4H5.77689C5.003 6.4 4.52241 5.55869 4.9155 4.89206L6.34913 2.46081ZM10.3947 7.6C11.8421 7.6 13 8.8 13 10.3C13 11.8 11.8421 13 10.3947 13C8.94737 13 7.78947 11.8 7.78947 10.3C7.78947 8.8 8.94737 7.6 10.3947 7.6Z"
                                              fill="#9C9C9C"/>
                                    </svg>
                                    <div class="flex-full desktop-cart-product-detail-tags">
                                        <?php
                                        if ($product->genres):
                                            for ($i = 0; $i < min(3, count($product->genres)); $i++) {
                                                echo '<div>' . $product->genres[$i]->title . '</div>';
                                            }
                                        endif;
                                        ?>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: center; justify-content: space-between;">
                                    <div class="desktop-cart-product-location">
                                        <div class="flex-full">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                 viewBox="0 0 14 14" fill="none">
                                                <path d="M7 0.875C8.39239 0.875 9.72775 1.40616 10.7123 2.35164C11.6969 3.29712 12.25 4.57946 12.25 5.91657C12.25 8.04695 10.6912 10.3687 7.61385 12.9065C7.44274 13.0477 7.22457 13.1252 6.99899 13.125C6.77341 13.1248 6.55539 13.0469 6.38454 12.9055L6.181 12.7359C3.23992 10.2642 1.75 7.99938 1.75 5.91657C1.75 4.57946 2.30312 3.29712 3.28769 2.35164C4.27226 1.40616 5.60761 0.875 7 0.875ZM7 3.9775C6.46447 3.9775 5.95087 4.1818 5.57219 4.54544C5.19351 4.90909 4.98077 5.4023 4.98077 5.91657C4.98077 6.43084 5.19351 6.92405 5.57219 7.28769C5.95087 7.65134 6.46447 7.85563 7 7.85563C7.53553 7.85563 8.04913 7.65134 8.42781 7.28769C8.80649 6.92405 9.01923 6.43084 9.01923 5.91657C9.01923 5.4023 8.80649 4.90909 8.42781 4.54544C8.04913 4.1818 7.53553 3.9775 7 3.9775Z"
                                                      fill="#9C9C9C"/>
                                            </svg>
                                            <span><?php echo $product->city_name . ', ' . $product->hood_name ?></span>
                                        </div>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-link" style="position: static !important;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"
                                             viewBox="0 0 16 12" fill="none">
                                            <path d="M0.365566 5.08126C0.131482 5.31563 -2.75235e-07 5.63334 -2.60756e-07 5.96459C-2.46276e-07 6.29584 0.131482 6.61355 0.365567 6.84793L5.0789 11.5638C5.3134 11.7983 5.63144 11.93 5.96307 11.93C6.29469 11.93 6.61274 11.7983 6.84723 11.5638C7.08173 11.3293 7.21347 11.0112 7.21347 10.6796C7.21347 10.348 7.08173 10.0299 6.84723 9.79543L4.26723 7.21459L13.8797 7.21459C14.2113 7.21459 14.5292 7.0829 14.7636 6.84847C14.998 6.61405 15.1297 6.29611 15.1297 5.96459C15.1297 5.63307 14.998 5.31513 14.7636 5.08071C14.5292 4.84629 14.2113 4.71459 13.8797 4.71459L4.26723 4.71459L6.84723 2.13459C6.96334 2.01848 7.05545 1.88064 7.11828 1.72893C7.18112 1.57723 7.21347 1.41463 7.21347 1.25043C7.21347 1.08622 7.18112 0.923623 7.11828 0.771917C7.05545 0.620211 6.96334 0.482368 6.84723 0.366257C6.73112 0.250148 6.59328 0.158045 6.44157 0.095206C6.28987 0.0323674 6.12727 2.45277e-05 5.96307 2.45349e-05C5.79886 2.45421e-05 5.63626 0.0323675 5.48456 0.095206C5.33285 0.158045 5.19501 0.250148 5.0789 0.366257L0.365566 5.08126Z"
                                                  fill="white"/>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <style>
                .timer-box-container {
                    display: flex;
                    gap: 2px;
                }

                .box-time-character {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    color: white;
                    font-size: 20px;
                    font-weight: 900;
                    border-radius: 6px;
                    text-shadow: 0px 4px 4px rgba(0, 0, 0, 0.25);
                    width: 30px;
                    height: 30px;
                    background: linear-gradient(161deg, #F21543 65.74%, #8C0C27 167.69%);
                    box-shadow: 0px 4px 4px 0px rgba(0, 0, 0, 0.25);
                }

                @media screen and (max-width: 768px) {
                    .event-products-header {
                        flex-direction: column;
                        gap: 10px;
                        align-items: stretch;
                    }
                }
            </style>
        <?php endif; ?>
        <?php if ($products): ?>
            <div id="adsx_wrapper" class="elite_rooms_wrapper"
                 style="position: relative;z-index: 2; background: #EFF3F7; padding: 38px 40px 38px 0; border-radius: 20px; margin: 20px 0; min-height: 400px;">
                <div class="slider-container-header" style="margin-bottom: 30px">
                    <h2 style="font-size: 22px;display: flex;align-items: center; gap:4px;font-weight: 600;color: #F21543;">
                        تخفیف لیزرتگ
                    </h2>
                    <div class="select-container"
                         style="display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 2rem;">
                        <div class="container-list">
                            <div class="dropdown">
                                <input type="text" placeholder="شهر..." class="search-input" id="searchInputCinema">
                                <div class="list-container" id="listContainerCinema">
                                    <div class="list-item-cinema" data-name="تهران">تهران</div>
                                    <div class="list-item-cinema" data-name="کرج">کرج</div>
                                    <div class="list-item-cinema" data-name="اراک">اراک</div>
                                    <div class="list-item-cinema" data-name="مشهد">مشهد</div>
                                    <div class="list-item-cinema" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-cinema" data-name="قم">قم</div>
                                    <div class="list-item-cinema" data-name="تهران">تهران</div>
                                    <div class="list-item-cinema" data-name="کرج">کرج</div>
                                    <div class="list-item-cinema" data-name="اراک">اراک</div>
                                    <div class="list-item-cinema" data-name="مشهد">مشهد</div>
                                    <div class="list-item-cinema" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-cinema" data-name="قم">قم</div>
                                    <div class="list-item-cinema" data-name="تهران">تهران</div>
                                    <div class="list-item-cinema" data-name="کرج">کرج</div>
                                    <div class="list-item-cinema" data-name="اراک">اراک</div>
                                    <div class="list-item-cinema" data-name="مشهد">مشهد</div>
                                    <div class="list-item-cinema" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-cinema" data-name="قم">قم</div>
                                    <div class="list-item-cinema" data-name="تهران">تهران</div>
                                    <div class="list-item-cinema" data-name="کرج">کرج</div>
                                    <div class="list-item-cinema" data-name="اراک">اراک</div>
                                    <div class="list-item-cinema" data-name="مشهد">مشهد</div>
                                    <div class="list-item-cinema" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-cinema" data-name="قم">قم</div>
                                    <div class="list-item-cinema" data-name="تهران">تهران</div>
                                    <div class="list-item-cinema" data-name="کرج">کرج</div>
                                    <div class="list-item-cinema" data-name="اراک">اراک</div>
                                    <div class="list-item-cinema" data-name="مشهد">مشهد</div>
                                    <div class="list-item-cinema" data-name="کرمانشاه">کرمانشاه</div>
                                    <div class="list-item-cinema" data-name="قم">قم</div>
                                </div>
                            </div>
                        </div>
                        <select name="" id="">
                            <option class="list-selection sort-select" data-source="all">همه</option>
                            <option class="list-selection sort-select" data-source="1">امروز</option>
                            <option class="list-selection sort-select" data-source="2">فردا</option>
                            <option class="list-selection sort-select" data-source="3">پس‌فردا</option>
                        </select>
                    </div>
                </div>
                <div dir="rtl" id="swiper_adsx" data-id="1" class="swiper topescaperoom"
                     style="align-items: stretch;display: flex; height: 360px !important;">
                    <div class="swiper-wrapper" style="padding: 5px 0 !important;">
                        <?php foreach ($products->products as $product): ?>
                            <article class="swiper-slide desktop-cart-product"
                                     style="height: 350px !important; width: 210px !important;">
                                <figure>
                                    <img src="<?= $product->image; ?>"
                                         alt="<?= $product->type . ' ' . $product->title ?>"
                                         style="width: 100%!important;height: 184px;object-fit: cover; object-position: top;"/>
                                    <?php if ($product->event): ?>
                                        <div style="position: absolute; z-index: 999; background: red; top: 5px; left: 5px; font-size: 11px; color: white; width: 30px; height: 30px; border-radius: 100%; display: flex; align-items: center; justify-content: center; font-weight: 400; text-shadow: 1px 1px 8px black;">
                                            <span style="margin-top: 2px">%</span>
                                            <span style="margin-top: 2px"><?= $product->event->off_percentage ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                    if ($product->ads and 0): ?>
                                        <div class="desktop-cart-product-ads">AD</div>
                                    <?php
                                    endif ?>
                                    <div class="flex-full desktop-cart-product-rated">
                                        <span><?= $product->rate ?></span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                             viewBox="0 0 16 16" fill="none">
                                            <path d="M14.6431 7.17815L11.8306 9.60502L12.6875 13.2344C12.7347 13.4314 12.7226 13.638 12.6525 13.8281C12.5824 14.0182 12.4575 14.1833 12.2937 14.3025C12.1298 14.4217 11.9343 14.4896 11.7319 14.4977C11.5294 14.5059 11.3291 14.4538 11.1562 14.3481L7.99996 12.4056L4.84184 14.3481C4.66898 14.4532 4.4689 14.5048 4.2668 14.4963C4.06469 14.4879 3.8696 14.4199 3.70609 14.3008C3.54257 14.1817 3.41795 14.0169 3.3479 13.8272C3.27786 13.6374 3.26553 13.4312 3.31246 13.2344L4.17246 9.60502L1.35996 7.17815C1.20702 7.04596 1.09641 6.87166 1.04195 6.67699C0.987486 6.48232 0.99158 6.27592 1.05372 6.08356C1.11586 5.89121 1.23329 5.72142 1.39135 5.59541C1.54941 5.4694 1.7411 5.39274 1.94246 5.37502L5.62996 5.07752L7.05246 1.63502C7.12946 1.44741 7.2605 1.28693 7.42894 1.17398C7.59738 1.06104 7.7956 1.00073 7.9984 1.00073C8.2012 1.00073 8.39942 1.06104 8.56785 1.17398C8.73629 1.28693 8.86734 1.44741 8.94434 1.63502L10.3662 5.07752L14.0537 5.37502C14.2555 5.39208 14.4477 5.46831 14.6064 5.59415C14.765 5.71999 14.883 5.88984 14.9455 6.08243C15.008 6.27502 15.0123 6.48178 14.9579 6.6768C14.9034 6.87182 14.7926 7.04644 14.6393 7.17877L14.6431 7.17815Z"
                                                  fill="#FFAE00"/>
                                        </svg>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-footer-hover">
                                        <div><?= get_product_type_equivalent($product->type) ?></div>
                                        <div class="flex-full">
                                            <span><?= $product->number_min ?></span>
                                            <span>تا</span>
                                            <span><?= $product->number_max ?></span>
                                            <span>نفر</span>
                                        </div>
                                        <div>
                                            <?php if ($product->free_sanses): ?>
                                                <div style="color: #fff;background: #FD7114;padding: 2px 10px;border-radius: 8px;">
                                                    <span style="font-size: 15px"><?= $product->free_sanses ?></span>
                                                    <span style="font-size: 12px">سانس </span>
                                                </div>
                                            <?php else: ?>
                                                <span style="font-size: font-size: 14px;color: #fff;background: #dc3545;padding: 2px 10px;border-radius: 8px;">تکمیل</span>
                                            <?php endif ?>
                                        </div>
                                        <div class="desktop-cart-product-footer-hover-link">
                                            <span>از</span>
                                            <span><?= number_format($product->price) ?></span>
                                            <span>تومان</span>
                                        </div>
                                    </a>
                                </figure>
                                <div class="desktop-cart-product-header">
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>">
                                        <h3 class="text-clamp-1"><?= $product->title ?></h3>
                                    </a>
                                </div>
                                <div class="flex-full" style="align-items: start;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14"
                                         fill="none">
                                        <path d="M5.63158 7.9C6.18386 7.9 6.63158 8.34772 6.63158 8.9V11.7C6.63158 12.2523 6.18386 12.7 5.63158 12.7H3C2.44772 12.7 2 12.2523 2 11.7V8.9C2 8.34771 2.44772 7.9 3 7.9H5.63158ZM6.34913 2.46081C6.736 1.80473 7.68505 1.80473 8.07192 2.46081L9.50555 4.89206C9.89864 5.55869 9.41805 6.4 8.64416 6.4H5.77689C5.003 6.4 4.52241 5.55869 4.9155 4.89206L6.34913 2.46081ZM10.3947 7.6C11.8421 7.6 13 8.8 13 10.3C13 11.8 11.8421 13 10.3947 13C8.94737 13 7.78947 11.8 7.78947 10.3C7.78947 8.8 8.94737 7.6 10.3947 7.6Z"
                                              fill="#9C9C9C"/>
                                    </svg>
                                    <div class="flex-full desktop-cart-product-detail-tags">
                                        <?php
                                        if ($product->genres):
                                            for ($i = 0; $i < min(3, count($product->genres)); $i++) {
                                                echo '<div>' . $product->genres[$i]->title . '</div>';
                                            }
                                        endif;
                                        ?>
                                    </div>
                                </div>
                                <div style="display: flex; align-items: center; justify-content: space-between;">
                                    <div class="desktop-cart-product-location">
                                        <div class="flex-full">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                 viewBox="0 0 14 14" fill="none">
                                                <path d="M7 0.875C8.39239 0.875 9.72775 1.40616 10.7123 2.35164C11.6969 3.29712 12.25 4.57946 12.25 5.91657C12.25 8.04695 10.6912 10.3687 7.61385 12.9065C7.44274 13.0477 7.22457 13.1252 6.99899 13.125C6.77341 13.1248 6.55539 13.0469 6.38454 12.9055L6.181 12.7359C3.23992 10.2642 1.75 7.99938 1.75 5.91657C1.75 4.57946 2.30312 3.29712 3.28769 2.35164C4.27226 1.40616 5.60761 0.875 7 0.875ZM7 3.9775C6.46447 3.9775 5.95087 4.1818 5.57219 4.54544C5.19351 4.90909 4.98077 5.4023 4.98077 5.91657C4.98077 6.43084 5.19351 6.92405 5.57219 7.28769C5.95087 7.65134 6.46447 7.85563 7 7.85563C7.53553 7.85563 8.04913 7.65134 8.42781 7.28769C8.80649 6.92405 9.01923 6.43084 9.01923 5.91657C9.01923 5.4023 8.80649 4.90909 8.42781 4.54544C8.04913 4.1818 7.53553 3.9775 7 3.9775Z"
                                                      fill="#9C9C9C"/>
                                            </svg>
                                            <span><?php echo $product->city_name . ', ' . $product->hood_name ?></span>
                                        </div>
                                    </div>
                                    <a href="<?= 'https://escapezoom.ir/room/' . $product->url ?>"
                                       class="desktop-cart-product-link" style="position: static !important;">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"
                                             viewBox="0 0 16 12" fill="none">
                                            <path d="M0.365566 5.08126C0.131482 5.31563 -2.75235e-07 5.63334 -2.60756e-07 5.96459C-2.46276e-07 6.29584 0.131482 6.61355 0.365567 6.84793L5.0789 11.5638C5.3134 11.7983 5.63144 11.93 5.96307 11.93C6.29469 11.93 6.61274 11.7983 6.84723 11.5638C7.08173 11.3293 7.21347 11.0112 7.21347 10.6796C7.21347 10.348 7.08173 10.0299 6.84723 9.79543L4.26723 7.21459L13.8797 7.21459C14.2113 7.21459 14.5292 7.0829 14.7636 6.84847C14.998 6.61405 15.1297 6.29611 15.1297 5.96459C15.1297 5.63307 14.998 5.31513 14.7636 5.08071C14.5292 4.84629 14.2113 4.71459 13.8797 4.71459L4.26723 4.71459L6.84723 2.13459C6.96334 2.01848 7.05545 1.88064 7.11828 1.72893C7.18112 1.57723 7.21347 1.41463 7.21347 1.25043C7.21347 1.08622 7.18112 0.923623 7.11828 0.771917C7.05545 0.620211 6.96334 0.482368 6.84723 0.366257C6.73112 0.250148 6.59328 0.158045 6.44157 0.095206C6.28987 0.0323674 6.12727 2.45277e-05 5.96307 2.45349e-05C5.79886 2.45421e-05 5.63626 0.0323675 5.48456 0.095206C5.33285 0.158045 5.19501 0.250148 5.0789 0.366257L0.365566 5.08126Z"
                                                  fill="white"/>
                                        </svg>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <style>
                .timer-box-container {
                    display: flex;
                    gap: 2px;
                }

                .box-time-character {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    color: white;
                    font-size: 20px;
                    font-weight: 900;
                    border-radius: 6px;
                    text-shadow: 0px 4px 4px rgba(0, 0, 0, 0.25);
                    width: 30px;
                    height: 30px;
                    background: linear-gradient(161deg, #F21543 65.74%, #8C0C27 167.69%);
                    box-shadow: 0px 4px 4px 0px rgba(0, 0, 0, 0.25);
                }

                @media screen and (max-width: 768px) {
                    .event-products-header {
                        flex-direction: column;
                        gap: 10px;
                        align-items: stretch;
                    }
                }
            </style>
        <?php endif; ?>
        <h2 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;display: flex;align-items: center; gap:8px;">
    <span style="filter: drop-shadow(0px 1px 2px rgba(0, 0, 0, 0.25));transform: rotate(180deg); position: relative;width: 41px;height: 41px;margin-left: 10px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 32 32" fill="none"
                             style="position: absolute;left: 0;top: 0;transform:translate(6px,8px);z-index: 1;">
      <path fill-rule="evenodd" clip-rule="evenodd"
            d="M26.4221 10.7605C26.6894 10.5553 26.863 10.2506 26.9047 9.91351C26.9464 9.57639 26.8527 9.23442 26.6443 8.96281L24.4212 6.06587C24.2105 5.80088 23.9059 5.628 23.5729 5.58446C23.2399 5.54092 22.9051 5.63021 22.6407 5.83309C22.3764 6.03598 22.2035 6.33622 22.1594 6.66917C22.1153 7.00211 22.2035 7.34111 22.405 7.61316L23.8422 9.48602L22.2937 10.6744L20.8565 8.80152C20.6458 8.53653 20.3412 8.36365 20.0081 8.32011C19.6751 8.27657 19.3404 8.36586 19.076 8.56874C18.8116 8.77162 18.6388 9.07187 18.5947 9.40482C18.5506 9.73776 18.6388 10.0768 18.8402 10.3488L20.2775 12.2217L12.4009 18.2647C11.4146 17.4875 10.1852 17.0939 8.94331 17.1577C7.70138 17.2215 6.53213 17.7383 5.65473 18.6112C4.77733 19.4842 4.25203 20.6533 4.17729 21.8995C4.10255 23.1457 4.48351 24.3834 5.24874 25.3806C6.01398 26.3777 7.11097 27.0659 8.33407 27.3161C9.55717 27.5663 10.8224 27.3614 11.8926 26.7397C12.9628 26.118 13.7645 25.1223 14.1475 23.9391C14.5304 22.756 14.4682 21.4666 13.9727 20.3128L26.4221 10.7605ZM8.96694 24.8287C9.63992 24.9226 10.3184 24.7448 10.8533 24.3344C11.3881 23.9239 11.7354 23.3145 11.8187 22.6401C11.9021 21.9658 11.7147 21.2817 11.2978 20.7384C10.8809 20.1951 10.2686 19.8371 9.59559 19.7432C8.92261 19.6493 8.24408 19.8271 7.70927 20.2375C7.17445 20.6479 6.82716 21.2573 6.7438 21.9317C6.66044 22.6061 6.84783 23.2902 7.26475 23.8334C7.68167 24.3767 8.29396 24.7347 8.96694 24.8287Z"
            fill="#ffffff"/>
      <circle cx="9.8806" cy="6.0847" r="3.08665" fill="#ffffff"/>
      <circle cx="26.9128" cy="24.9719" r="3.08665" fill="#ffffff"/>
    </svg>
                        <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none"
                             style="position: absolute;left: 0;right: 0;bottom: 0;top: 0;">
  <path d="M39.9221 24.4033C38.5688 22.0621 38.5698 19.1755 39.9241 16.8349C40.1873 16.3796 40.2589 15.8384 40.1231 15.3304C39.9874 14.8223 39.6554 14.389 39.2002 14.1256C36.8624 12.7744 35.412 10.2729 35.412 7.57269C35.412 7.04668 35.2031 6.54221 34.8311 6.17026C34.4592 5.79831 33.9547 5.58935 33.4287 5.58935C30.7297 5.58935 28.2299 4.14009 26.8797 1.80317C26.6168 1.34766 26.1837 1.01521 25.6758 0.878932C25.4241 0.811502 25.1617 0.794312 24.9034 0.828342C24.6451 0.862373 24.396 0.946958 24.1704 1.07727C21.8268 2.43191 18.9372 2.43084 16.594 1.07528C16.1385 0.812288 15.5972 0.741017 15.0891 0.877149C14.581 1.01328 14.1478 1.34567 13.8848 1.80118C12.5341 4.13795 10.0328 5.58935 7.33381 5.58935C6.80779 5.58935 6.30332 5.79831 5.93137 6.17026C5.55942 6.54221 5.35046 7.04668 5.35046 7.57269C5.35046 10.2717 3.89903 12.773 1.56227 14.1236C1.33663 14.254 1.13889 14.4276 0.980369 14.6345C0.821848 14.8414 0.705651 15.0774 0.63842 15.3292C0.571188 15.581 0.554242 15.8436 0.588547 16.1019C0.622853 16.3603 0.70774 16.6093 0.838354 16.8349C2.19289 19.1758 2.19289 22.0623 0.838354 24.4033C0.57653 24.859 0.505493 25.3997 0.64073 25.9076C0.775967 26.4155 1.10651 26.8493 1.56029 27.1145C3.89705 28.4652 5.34848 30.9664 5.34848 33.6654C5.34848 34.1915 5.55744 34.6959 5.92939 35.0679C6.30134 35.4398 6.80581 35.6488 7.33183 35.6488C10.0321 35.6488 12.5335 37.0991 13.8848 39.437C14.0604 39.7371 14.3111 39.9864 14.6122 40.1603C14.9134 40.3341 15.2546 40.4266 15.6024 40.4286C15.9475 40.4286 16.2906 40.3374 16.596 40.1609C18.9372 38.8062 21.8267 38.8073 24.1684 40.1609C24.6237 40.424 25.1649 40.4956 25.6729 40.3598C26.181 40.2241 26.6143 39.8921 26.8777 39.437C28.2274 37.0998 30.7278 35.6488 33.4267 35.6488C33.9527 35.6488 34.4572 35.4398 34.8291 35.0679C35.2011 34.6959 35.41 34.1915 35.41 33.6654C35.41 30.9664 36.8615 28.4652 39.1982 27.1145C39.4239 26.9841 39.6216 26.8105 39.7801 26.6036C39.9386 26.3968 40.0548 26.1607 40.1221 25.9089C40.1893 25.6571 40.2063 25.3945 40.172 25.1362C40.1376 24.8778 40.0528 24.6288 39.9221 24.4033Z"
        fill="url(#paint0_linear_279_28)"/>
  <defs>
    <linearGradient id="paint0_linear_279_28" x1="30" y1="22" x2="46.5" y2="67.5" gradientUnits="userSpaceOnUse">
      <stop stop-color="#F21543"/>
      <stop offset="1" stop-color="#8C0C27"/>
    </linearGradient>
  </defs>
</svg>
                    </span>
            <?= 'تخفیف بازی‌های گروهی؛ تجربۀ بهترین تفریحات با قیمت مناسب!' ?></h2>
        <p style="margin-top: 20px; text-align: justify;">
            اگه دنبال هیجان، سرگرمی و تفریحات گروهی هستید اما دوست دارید که با کم‌ترین قیمت بازی کنید، باید بهتون بگم که
            جای درستی اومدید! حتی بعضی از کاربرها، اون‌قدرها هم عاشق بازی‌های گروهی نیستند ولی اگه یه تخفیف خوب داشته
            باشند، ممکنه تجربه کنند. اینجا تمام بازی‌های گروهی که تخفیف ویژه دارند، یه‌جا جمع شدند. از اتاق فرار گرفته
            تا لیزرتگ، سینما ترس و اتاق خشم‌های تخفیف‌خورده؛ همه رو می‌تونید با ارزون‌ترین قیمت‌ تجربه‌ کنید.
        </p>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            چه تفریحات با تخفیفی توی این صفحه وجود داره؟
        </h3>
        <ul>
            <li>اتاق فرار</li>
            <li>سینما ترس</li>
            <li>لیزرتگ</li>
            <li>اتاق خشم</li>
        </ul>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            چرا این صفحه برای عاشقان تفریح مهمه؟
        </h3>
        <ol>
            <li>تجربۀ هیجان با هزینۀ کمتر: تفریحات گروهی معمولا پرهزینه هستند، ولی اینجا می‌تونید بازی‌های مورد
                علاقه‌تون رو با قیمت‌های تخفیف‌خورده و به‌صرفه رزرو کنید.
            </li>
            <li>جمع شدن همۀ تخفیف‌های داغ توی یه صفحه: دیگه نیازی نیست صفحه‌های مختلف سایت رو بگردید تا این بازی‌ها رو
                پیدا کنید، توی همین صفحه تمام بازی‌هایی که تخفیف دارند، هستند.
            </li>
            <li>تنوع نوع تفریحات تخفیف‌دار: فرقی نمی‌کنه دنبال تخفیف اتاق فرار باشید یا بازی‌های هیجانی دیگه مثل لیزرتگ،
                سینما ترس و اتاق خشم، اینجا همیشه پیشنهادهای جذابی براتون وجود داره.
            </li>
            <li>به‌روزرسانی مداوم: ما همیشه این صفحه رو با جدیدترین تخفیف‌ها آپدیت می‌کنیم، پس می‌تونید برای اینکه فرصت‌
                تجربۀ بازی‌های گروهی تخفیف‌دار جدید رو از دست ندید، به این صفحه سر بزنید.
            </li>
        </ol>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            چطور تفریح با تخفیف‌تون رو سریع‌ پیدا کنید؟
        </h3>
        <p style="margin-top: 20px; text-align: justify;">
            برای اینکه سریع‌تر و راحت‌تر به تفریح مورد علاقتون برسید، می‌تونید از فیلترهای سانس‌یاب و جست‌وجو استفاده
            کنید. اگه دنبال تخفیف اتاق فرار هستید، فقط کافیه این گزینه رو انتخاب کنید. همین‌طور برای تخفیف لیزرتگ، تخفیف
            سینما ترس و تخفیف اتاق خشم هم می‌تونید دسته‌بندی مخصوص‌شون رو انتخاب کنید و سریع‌تر تصمیم بگیرید. علاوه‌بر
            این، با بررسی امتیاز و نظرات کاربران می‌شه، بهترین گزینه رو برای خود و دوستاتون پیدا و با خیال راحت رزرو
            کنید!
        </p>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            چطور مطمئن بشید که بهترین بازی گروهی تخفیف‌دار رو انتخاب کردید؟
        </h3>
        <p style="margin-top: 20px; text-align: justify;">
            قبل‌از رزرو، حتما به درصد تخفیف، امتیاز کاربران و نظرات بقیۀ پلیرها دقت کنید. اگه دنبال تجربه‌ای خاص هستید،
            بهتره تفریحاتی رو انتخاب کنید که امتیاز بالاتری دارند و بقیۀ پلیرها ازشون راضی بودند. همین‌طور پیشنهاد
            می‌کنیم اطلاعات هر بازی رو بخونید تا مطمئن بشید اون بازی با سلیقه و هیجان مورد نظرتون هماهنگه. خلاصه، اینجا
            همه‌چیز شفافه و شما می‌تونید با اطلاعات کامل، یه انتخاب عالی داشته باشید!
        </p>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            این تخفیف‌ها همیشگی نیستند!
        </h3>
        <p style="margin-top: 20px; text-align: justify;">
            چیزی که این صفحه رو خاص می‌کنه اینه که این تخفیف‌ها دائمی نیستند! ممکنه یه بازی فقط امروز تخفیف داشته باشه
            یا ظرفیتش خیلی زود پر بشه پس اگه می‌خواید یه تجربۀ هیجان‌انگیز رو با تخفیف ویژه داشته باشید، نباید معطل
            کنید! علاوه‌بر این، اگه می‌خواید همیشه جزو نفراتی باشید که از بهترین تخفیف‌های اتاق فرار، لیزرتگ، سینما ترس
            و اتاق خشم استفاده می‌کنند، حتما به‌طور پیوسته به این صفحه سر بزنید. اینطوری هیچ فرصت خوبی رو از دست نمی‌دید
            و همیشه ارزون‌ترین قیمت‌ نصیب‌تون می‌شه!
        </p>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            چطور از تخفیف بازی های گروهی استفاده کنیم؟
        </h3>
        <p style="margin-top: 20px; text-align: justify;">
            خیلی ساده! تفریح مورد علاقتون رو انتخاب کنید، روی گزینۀ «ثبت رزرو» بزنید و با بهترین قیمت، لحظاتی پر از
            هیجان رو تجربه کنید.
        </p>
        <h3 style="font-weight: 600; font-size: 20px; margin-top: 10px; color: #F21543;">
            با کمترین هزینه، بیشترین هیجان رو تجربه کنید!
        </h3>
        <p style="margin-top: 20px; text-align: justify;">
            چرا توی خونه بمونید وقتی می‌تونید با یه هزینۀ کمتر از یه رستوران یا کافه، یه خاطرۀ مهیج و خاص رو با
            دوست‌هاتون بسازید؟ اینجا بیشترین تخفیف‌ها، روی جذاب‌ترین تفریحات گروهی قرار گرفته تا بتونید بدون نگرانی و
            داشتن دغدغۀ قیمت، بهترین تجربه رو داشته باشید. اتاق فرار، لیزرتگ، سینما ترس یا حتی اتاق خشم! هرچی که انتخاب
            کنید، با یه تخفیف عالی روبه‌رو می‌شید که شاید دیگه تکرار نشه!
        </p>
    </main>
    <script>
        jQuery(document).ready(function ($) {
            var swiper = new Swiper(".city-slide-rooms", {
                slidesPerView: 'auto',
                spaceBetween: 10,
                freeMode: true,
                navigation: {
                    nextEl: "#rooms-slide-btn",
                },
            });
            var swiper = new Swiper("#swiper_adsx", {
                slidesPerView: "auto",
                spaceBetween: 10,
                loop: false,
                paginationClickable: true,
                freeMode: true,
            });
        });
        $('#searchInputRooms').on('focus', function () {
            $('#listContainerRooms').show();
        });
        $('#searchInputRooms').on('input', function () {
            var filter = $(this).val().toLowerCase();
            $('.list-item-rooms').each(function () {
                var name = $(this).data('name').toLowerCase();
                if (name.includes(filter) || filter === "") {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $('.list-item-rooms').on('click', function () {
            $('#searchInputRooms').val($(this).text());
            $('#listContainerRooms').hide();
        });
        $(document).on('click', function (event) {
            if (!$(event.target).closest('.dropdown').length) {
                $('#listContainerRooms').hide();
            }
        });
        $('#searchInputCinema').on('focus', function () {
            $('#listContainerCinema').show();
        });
        $('#searchInputCinema').on('input', function () {
            var filter = $(this).val().toLowerCase();
            $('.list-item-cinema').each(function () {
                var name = $(this).data('name').toLowerCase();
                if (name.includes(filter) || filter === "") {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $('.list-item-cinema').on('click', function () {
            $('#searchInputCinema').val($(this).text());
            $('#listContainerCinema').hide();
        });
        $(document).on('click', function (event) {
            if (!$(event.target).closest('.dropdown').length) {
                $('#listContainerCinema').hide();
            }
        });
        $('#searchInputLaizer').on('focus', function () {
            $('#listContainerLaizer').show();
        });
        $('#searchInputLaizer').on('input', function () {
            var filter = $(this).val().toLowerCase();
            $('.list-item-laizer').each(function () {
                var name = $(this).data('name').toLowerCase();
                if (name.includes(filter) || filter === "") {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
        $('.list-item-laizer').on('click', function () {
            $('#searchInputLaizer').val($(this).text());
            $('#listContainerLaizer').hide();
        });
        $(document).on('click', function (event) {
            if (!$(event.target).closest('.dropdown').length) {
                $('#listContainerLaizer').hide();
            }
        });
    </script>

<?php get_footer(); ?>