<?php
/* Template Name: complex */
?>

<!doctype html>
<html lang="fa">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<?php
	// noIndex ParkDomain
	if ( $_SERVER['SERVER_NAME'] == 'escapezoom.co' ) {
		add_filter( 'wp_robots', function ( $robots ) {
			$robots['noindex']  = true;
			$robots['nofollow'] = true;

			return $robots;
		} );
	} else {
		add_filter( 'wp_robots', function ( $robots ) {
			$robots['index']  = true;
			$robots['follow'] = true;

			return $robots;
		} );
	}
	?>

    <title>ورود مجموعه داران</title>
</head>
<body>

<?php
if ( get_current_user_id() > 0 ) {
	header( 'Location: https://escapezoom.ir/panel' );
	exit;
} ?>

<style>


    footer, header.zardkooh-header, .top-header, .second-menu, #topfooter {
        display: none !important;
    }

    body {
        font-size: 16px;
        font-family: 'dana';
    }

    .zero-raduis {
        border-radius: 0px !important;
    }

    a {
        color: #92badd;
        display: inline-block;
        text-decoration: none;
        font-weight: 400;
    }

    h1 {
        text-align: center;
        font-size: 3rem;
        font-weight: 600;
        display: inline-block;
        color: #56baed;
    }

    h2 {
        font-size: 1.5rem;
        font-weight: 400;
    }

    input[type=button]:hover, input[type=submit]:hover, input[type=reset]:hover {
        background-color: #ff4500 !important;
    }


    /* STRUCTURE */

    .wrapper {
        display: flex;
        align-items: center;
        flex-direction: column;
        justify-content: center;
        width: 100%;
        min-height: 100%;
        padding: 20px;
    }

    #formContent {
        -webkit-border-radius: 10px 10px 10px 10px;
        border-radius: 10px 10px 10px 10px;
        background: #fff;
        padding: 30px;
        width: 90%;
        max-width: 450px;
        max-height: 430px;
        padding: 0px;
        -webkit-box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.3);
        box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.3);
        text-align: center;

        margin-top: 120px;
        margin-bottom: 10px;
    }

    #formFooter {
        padding: 2px;
        margin: 4px 0;
        text-align: center;
    }

    /* FORM TYPOGRAPHY*/
    input[type=button], input[type=submit], input[type=reset] {
        background-color: #56baed;
        border: none;
        color: white;
        width: 85%;
        padding: 10px 25px;
        text-decoration: none;
        display: inline-block;
        text-transform: uppercase;
        font-size: 16px;
        cursor: pointer;
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
        margin: 5px 20px 40px 20px;
        -webkit-transition: all 0.3s ease-in-out;
        -moz-transition: all 0.3s ease-in-out;
        -ms-transition: all 0.3s ease-in-out;
        -o-transition: all 0.3s ease-in-out;
        transition: all 0.3s ease-in-out;
    }

    input[type=button]:hover, input[type=submit]:hover, input[type=reset]:hover {
        background-color: #39ace7;
    }

    input[type=text], input[type=email], input[type=password] {
        background-color: #f6f6f6;
        border: none;
        color: #0d0d0d;
        padding: 10px 25px;
        text-align: center;
        text-decoration: none;
        display: inline-block;
        font-size: 16px;
        margin: 5px;
        width: 85%;
        border: 2px solid #f6f6f6;
        -webkit-transition: all 0.5s ease-in-out;
        -moz-transition: all 0.5s ease-in-out;
        -ms-transition: all 0.5s ease-in-out;
        -o-transition: all 0.5s ease-in-out;
        transition: all 0.5s ease-in-out;
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
    }

    input[type=text]:focus, input[type=email]:focus {
        background-color: #fff;
        border-bottom: 2px solid #5fbae9;
    }

    input[type=text]:placeholder, input[type=email]:placeholder {
        color: #cccccc;
    }

    *:focus {
        outline: none;
    }

    #icon {
        width: 30%;
    }


    /************************************** din edite **********************/
    .h-title {
        font-size: 1.5rem;
        font-weight: 400;
        padding-top: 40px;
        text-align: right;
        padding-right: 50px;
    }


    .p-title {
        margin-top: 0;
        margin-bottom: 1rem;
        text-align: right;
        padding-right: 50px;
        padding-top: 20px;
    }


    input[type=button], input[type=submit], input[type=reset] {
        background-color: #f5731f;
        border: none;
        color: white;
        width: 85%;
        padding: 10px 25px;
        text-decoration: none;
        display: inline-block;
        text-transform: uppercase;
        font-size: 16px;
        cursor: pointer;
        -webkit-border-radius: 5px 5px 5px 5px;
        border-radius: 5px 5px 5px 5px;
        margin: 5px 20px 40px 20px;
        -webkit-transition: all 0.3s ease-in-out;
        -moz-transition: all 0.3s ease-in-out;
        -ms-transition: all 0.3s ease-in-out;
        -o-transition: all 0.3s ease-in-out;
        transition: all 0.3s ease-in-out;
        margin-top: 40px;
    }

    <
    style >
    .zero-raduis {
        border-radius: 10px !important;
    }


    input[type=button]:hover, input[type=submit]:hover, input[type=reset]:hover {
        background-color: #f5731f !important;
    }

    .zero-raduis {
        border-radius: 10px !important;
    }

    input[type=button]:hover, input[type=submit]:hover, input[type=reset]:hover {
        background-color: #f5731f !important;
        border-radius: 10px !important;
    }

    .first {
        margin-top: 23px;
    }

    a.ramz2 {
        padding-top: 13px;
        text-align: left !important;
        color: #586D89 !important;
        padding-left: 200px;

        font-size: medium;
    }


    .msg {
        color: #ff0000;
    }

    div#formContent {
        margin: 109px auto;
        padding: 9px 8px 0 0;
    }

</style>


<!--                                   //////////////////////////////////////////////////////////////////////////////////                                -->


<form class="form" id="loginmaj" method="post" action="<?php echo home_url( 'login' ) ?>">
    <div class="container mt-5">
        <div class="d-flex justify-content-center h-100">
            <div id="formContent">
                <!-- Icon -->
                <div class="first">
                    <a href="https://escapezoom.ir"><img
                                src="https://escapezoom.ir/wp-content/uploads/2020/11/logo-1.png"
                                class="logo-login"></a>

                </div>
                <!-- Login Form -->


                <input type="text" id="code_u" class="second zero-raduis" name="user" placeholder="نام کاربری">

                <input type="password" id="code_p" class="second zero-raduis" name="pass" placeholder="رمز عبور">
                <div id="formFooter">
                    <!--   <a class="underlineHover" href="#">Forgot Password?</a> -->
                </div>

				<?php if ( isset( $_POST['submit'] ) ) {
					$username = htmlspecialchars( $_POST["user"] );
					$password = htmlspecialchars( $_POST["pass"] );

					if ( substr( $username, 0, 1 ) === '0' ) {
						$username = substr( $username, 1 );
					}

					$user = get_user_by( 'login', $username );
					if ( ! $user ) {
						$user = get_user_by( 'login', '0' . $username );
					}

					if ( $user ) {
						if ( ! wp_check_password( $password, $user->user_pass, $user->ID ) ) {
							echo '<p class="msg">نام کاربری یا رمز عبور اشتباه است.</p>';
						} else {

							wp_signon( array(
								'user_login'    => $username,
								'user_password' => $password,
								'remember'      => true
							) );

							if ( is_user_logged_in() ) {
								wp_safe_redirect( 'Location: https://escapezoom.ir/panel' );
							}

						}
					} else {
						echo '<p class="msg">نام کاربری یا رمز عبور اشتباه است.</p>';
					}
				} ?>

                <input type="submit" name="submit" class="fourth zero-raduis pc" value=" ورود">
            </div>
        </div>
    </div>
</form>


</body>
</html>