<?php
prevent_submission_by_refresh();

if (! is_user_logged_in()){
    $redirect = $home_url . 'login-complex';
    wp_redirect( $redirect );
    exit;
}

get_header(); ?>
    <style>
        .time_slider > .swiper-wrapper {
            max-width: 500px;
        }
        @media (max-width: 768px){
            #main > div.container {
                margin: unset !important;
                padding: unset !important;
                width: 100% !important;
                max-width: 100% !important;
            }
            #main .panel-section {
                width: 100% !important;
                padding: 0 20px;
            }
            #footer {
                display: none;
            }
            .panel-title {
                color: white;
                background-color: #0b2c3b !important;
                position: absolute;
                top: 130px;
                left: 0;
                right: 0;
                text-align: center;
                font-size: 20px;
            }
            #mobile-icons-top {
                display: none !important;
            }

        }
        table.dataTable thead .sorting, table.dataTable tbody td {
            text-align: center;
        }
        body{
            font-family: Arial, Helvetica, sans-serif;
            font-size: 13px;
        }
        .error, {
            border: 1px solid;
            margin: 10px 0px;
            padding: 15px 10px 15px 50px;
            background-repeat: no-repeat;
            background-position: 10px center;
        }
        .error{
            color: #D8000C;
            background-color: #FFBABA;
            background-image: url('https://i.imgur.com/GnyDvKN.png');
        }
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .pagination a {
            text-decoration: none;
            color: #f97316;
            padding: 8px 12px;
            border: 1px solid #f97316;
            border-radius: 5px;
            margin: 0 5px;
            transition: background-color 0.3s, color 0.3s;
        }
        .pagination a:hover {
            background-color: #f97316;
            color: #fff;
        }
        .pagination .dots {
            padding: 8px 12px;
        }
        .pagination .prev, .pagination .next {
            font-weight: bold;
        }
        .pagination .current {
            font-weight: bold;
            color: #fff;
            background-color: #f97316;
            padding: 8px 12px;
            border-radius: 5px;
            margin: 0 5px;
        }
        .pagination {
            width: 100%;
            margin-top: 50px;
        }
    </style>

    <svg class="hidden">
        <symbol id="sans-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6v6h4.5m4.5 0a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
        </symbol>
        <symbol id="wallet-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 18.75a60.07 60.07 0 0 1 15.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 0 1 3 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 0 0-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 0 1-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 0 0 3 15h-.75M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm3 0h.008v.008H18V10.5Zm-12 0h.008v.008H6V10.5Z" />
        </symbol>
        <symbol id="my-game-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z" />
        </symbol>
        <symbol id="support-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M8.625 9.75a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H8.25m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0H12m4.125 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 0 1 .778-.332 48.294 48.294 0 0 0 5.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0 0 12 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018Z" />
        </symbol>
        <symbol id="my-sale-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3v11.25A2.25 2.25 0 0 0 6 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0 1 18 16.5h-2.25m-7.5 0h7.5m-7.5 0-1 3m8.5-3 1 3m0 0 .5 1.5m-.5-1.5h-9.5m0 0-.5 1.5m.75-9 3-3 2.148 2.148A12.061 12.061 0 0 1 16.5 7.605" />
        </symbol>
        <symbol id="profile-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
        </symbol>
        <symbol id="sidebar-show-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
        </symbol>
        <symbol id="sidebar-close-show" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
        </symbol>
        <symbol id="accounting-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 8.25h19.5M2.25 9h19.5m-16.5 5.25h6m-6 2.25h3m-3.75 3h15a2.25 2.25 0 0 0 2.25-2.25V6.75A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25v10.5A2.25 2.25 0 0 0 4.5 19.5Z" />
        </symbol>

    </svg>

<?php
global $wpdb, $wldb;

$tabs = $_GET['ez_panel_nav'];

$user       = wp_get_current_user();
$user_id    = $user->ID;
$user_role  = ($user->roles)[0];

$withdrawal_owner_name_value    = get_user_meta($user_id, 'withdrawal_owner_name', true);
$withdrawal_owner_shaba_value   = get_user_meta($user_id, 'withdrawal_owner_shaba', true);

if ($user_role == 'sans_manager')
    $user_products = $wpdb->get_results( "SELECT *  FROM `wp_postmeta` WHERE `meta_key` LIKE 'sans_manager' AND `meta_value` LIKE {$user_id}", ARRAY_A );

if ($user_role == 'compiler')
    $user_products = $wpdb->get_results( "SELECT *  FROM `wp_postmeta` WHERE `meta_key` LIKE 'user_ebtal' AND `meta_value` LIKE {$user_id}", ARRAY_A ); ?>

    <!-- main content start -->
    <div class="panel-section my-8">
        <div class="panel-title md:hidden p-2 font-medium">پنل کاربری</div>
        <div class="md:hidden p-2 font-semibold text-[#0b2c3b]">
            <?php
            if($tabs == 'sans' || !$tabs)
                echo 'سانس‌ها';

            if($tabs == 'wallet')
                echo 'کیف پول';

            if($tabs == 'my-sale')
                echo 'فروش‌های من';

            if($tabs == 'ticket')
                echo 'پشتیبانی';

            if($tabs == 'profile')
                echo 'پروفایل'; ?>
        </div>

        <div class="flex items-start gap-4 relative mb-36">
            <div id="sidebar" class="hidden overflow-hidden md:block w-[220px] sticky top-20 bg-slate-50 rounded-md shadow py-6 px-2.5 transition-all duration-500">
                <ul class="space-y-4">

                    <div id="sidebar-style" class="w-fit">
                        <button id="sidebar-close" class="px-2"><svg class="w-5 h-5"><use href="#sidebar-close-show"></use></svg></button>
                        <button id="sidebar-show" class="px-2"><svg class="w-5 h-5"><use href="#sidebar-show-icon"></use></svg></button>
                    </div>

                    <li class="menu-sidebar <?= ($tabs == 'sans' || !$tabs) ? 'active' : '' ?>">
                        <a href="/panel/?ez_panel_nav=sans">
                            <svg class="w-5 h-5"><use href="#sans-icon"></use></svg>
                            <span class="menu-sidebar-title">سانس‌ها</span>
                        </a>
                    </li>

                    <?php
                    if ($user_role != 'sans_manager') : ?>

                        <li class="menu-sidebar <?= ($tabs == 'wallet') ? 'active' : '' ?>">
                            <a href="/panel/?ez_panel_nav=wallet">
                                <svg class="w-5 h-5"><use href="#wallet-icon"></use></svg>
                                <span class="menu-sidebar-title">کیف پول</span>
                            </a>
                        </li>

                    <?php
                    endif; ?>

                    <?php
                    if ($user_role != 'sans_manager') : ?>

                        <li class="menu-sidebar <?= ($tabs == 'my-sale') ? 'active' : '' ?>">
                            <a href="/panel/?ez_panel_nav=my-sale">
                                <svg class="w-5 h-5"><use href="#my-sale-icon"></use></svg>
                                <span class="menu-sidebar-title">فروش‌های من</span>
                            </a>
                        </li>

                    <?php
                    endif; ?>

                    <li class="menu-sidebar <?= ($tabs == 'ticket') ? 'active' : '' ?>">
                        <a href="/panel/?ez_panel_nav=ticket">
                            <svg class="w-5 h-5"><use href="#support-icon"></use></svg>
                            <span class="menu-sidebar-title">درخواست پشتیبانی</span>
                        </a>
                    </li>

                    <li class="menu-sidebar <?= ($tabs == 'profile') ? 'active' : '' ?>">
                        <a href="/panel/?ez_panel_nav=profile">
                            <svg class="w-5 h-5"><use href="#profile-icon"></use></svg>
                            <span class="menu-sidebar-title">پروفایل</span>
                        </a>
                    </li>

                </ul>
            </div>

            <div class="w-full">
                <?php

                /************************************************************************************************************/
                // section: سانس ها

                if($tabs == 'sans' || !$tabs) :

                    $active_products = [];
                    foreach ( $user_products as $user_product ) {
                        $is_active = get_post_meta($user_product['post_id'], 'sale_active', true);
                        $post_type = get_post_type($user_product['post_id']);

                        if ( $is_active && $post_type == 'product' )
                            $active_products[] = $user_product['post_id'];
                    }

                    if ( empty( $user_products ) || empty( $active_products ) ) :
                        echo 'شما هیچ اتاق فعالی برای نمایش ندارید. ';
                        
                    else : ?>

                        <script>

                            var ezb = {
                                "o900"  : "<?php echo base64_encode(get_current_user_ID()); ?>",
                                "o985"  : "<?php echo base64_encode($user_role); ?>",
                            };

                            jQuery(document).ready(function ($){
    
                                setTimeout(function() {
                                    $('#panel_sans_box_today').click();
                                }, 25);
    
                                /******************************************************************************************/
                                $('body').on('click', '.game-tab', function () {
                                    var $this = $(this);
                                    $('#product_title').html($this.html());
                                    $('#panel_sans_product_id').val($this.data('product'));
                                    $('#panel_sans_auto_disable').val($this.data('auto_dis'));
                                    $('#product_see_all').attr('href', '');
                                    $('#panel_sans_box_today').click();
                                });
                                /******************************************************************************************/
                                $('body').on('click', '.time-button-tab', function () {
                                    var $this = $(this);
    
                                    $('#panel_sans_time_box_wrapper').empty();
    
                                    $.ajax({
                                        type: 'POST',
                                        url: 'https://' + location.hostname + '/web-service/reservation.php',
                                        data: {
                                            "async" : false,
                                            "type"  : "panel_sanses_display",
                                            "data"  : {
                                                'time_res'      : $this.data("time"),
                                                'ezservice'     : $('#panel_sans_product_id').val(),
                                                'auto_disable'  : $('#panel_sans_auto_disable').val(),
                                                'o985'          : ezb.o985,
                                                'o900'          : ezb.o900,
                                            }
                                        },
    
                                        dataType: "json",
                                        success: function(data) {
                                            $('#panel_sans_time_box_wrapper').html(data);
                                        },
                                    });
                                });
                                /******************************************************************************************/
                                $('body').on('click', '.hazf_kon', function () {
                                    var $this = $(this);
    
                                    $.ajax({
                                        type: 'POST',
                                        url: 'https://' + location.hostname + '/web-service/reservation.php',
                                        data: {
                                            "async" : false,
                                            "type"  : "hazf_kon",
                                            "data"  : {
                                                'start'     : $this.data('start'),
                                                'service'   : $('#panel_sans_product_id').val(),
                                                'o900'      : <?php echo $user_id; ?>,
                                            }
                                        },
    
                                        dataType: "json",
                                        success: function(res2) {
    
                                            if (res2.trim()) {
                                                $this.val('باز کن');
                                                $this.removeClass('red-bg').addClass('green-bg');
                                                $this.removeClass('hazf_kon').addClass('baz_kon');
                                            }
                                        },
                                    });
                                });
                                /******************************************************************************************/
                                $('body').on('click', '.baz_kon', function () {
                                    var $this = $(this);
    
                                    $.ajax({
                                        type: 'POST',
                                        url: 'https://' + location.hostname + '/web-service/reservation.php',
                                        data: {
                                            "async" : false,
                                            "type"  : "baz_kon",
                                            "data"  : {
                                                'start'     : $this.data('start'),
                                                'service'   : $('#panel_sans_product_id').val(),
                                            }
                                        },
    
                                        dataType: "json",
                                        success: function(res2) {
    
                                            if (res2.trim()) {
                                                $this.val('حذف کن');
                                                $this.removeClass('green-bg').addClass('red-bg');
                                                $this.removeClass('baz_kon').addClass('hazf_kon');
                                            }
                                        },
                                    });
                                });
                                /******************************************************************************************/
    
                            });
                        </script>
    
                        <div class="mt-4">
                            <!-- tabs -->
                            <div class="overflow-x-auto scrollbar-hide md:max-w-[500px] lg:max-w-full relative z-20">
                                <div class="flex items-center mr-2 ml-2">
                                    <?php
                                    $first_product = '';
                                    foreach ( $active_products as $key => $user_product ) :
                                        $product = wc_get_product($user_product);

                                        if ( $key == 0 )
                                            $first_product = $product;

                                        $auto_disable = get_post_meta($product->get_id(), 'auto_disable', true); ?>
    
                                        <button class="game-tab <?php echo $key == 0 ? 'active' : '' ?>" data-auto_dis="<?php echo $auto_disable ?>" data-product="<?php echo $product->get_id() ?>"><?php echo $product->get_title() ?></button>
                                    <?php
                                    endforeach; ?>
                                </div>
                            </div>
                            <!-- content -->
                            <input type="hidden" id="panel_sans_product_id" value="<?php echo $first_product->get_id(); ?>">
                            <input type="hidden" id="panel_sans_auto_disable" value="<?php echo get_post_meta($first_product->get_id(), 'auto_disable', true); ?>">
    
                            <div class="border-2 border-b-0 p-4 rounded-md content-game-time">
                                <div class="game-content" id="game-1">
                                    <!-- time -->
                                    <div>
                                        <div class="text-center my-8">
                                            <span id="product_title" class="text-xl font-semibold"><?php echo $first_product->get_title() ?></span>
                                            <a href="<?php echo $first_product->get_permalink() ?>" id="product_see_all" class="bg-[#0b2c3b] px-2 py-1.5 text-white font-semibold rounded-md text-sm mr-2">مشاهده</a>
                                        </div>
    
                                        <div class="swiper time_slider">
                                            <div class="swiper-wrapper">
                                                <button id="panel_sans_box_today" class="swiper-slide time-button-tab active" data-time="<?php echo strtotime(date('Y-m-d ') . ' ' . 'Asia/Tehran'); ?>">امروز</button>
    
                                                <?php
                                                $get_time = strtotime(date('Y-m-d ') . ' ' . 'Asia/Tehran');
    
                                                $x = 1;
                                                while ($x <= 21) {
                                                    if ($x == 1)
                                                        $get_d = $get_time;
    
                                                    if ($x != 1) { ?>
                                                        <button class="swiper-slide time-button-tab" data-time="<?php echo $get_d; ?>">
                                                            <div><?= jdate('l', $get_d) ?></div>
                                                            <div><?= jdate('j', $get_d) ?></div>
                                                            <div><?= jdate('F', $get_d) ?></div>
                                                        </button>
                                                    <?php
                                                    }
                                                    $get_d = $get_d + 86400;
                                                    $x++;
                                                } ?>
                                            </div>
                                        </div>
    
                                    </div>
                                    <!-- reserveTime -->
                                    <div>
                                        <div class="time-reserve" id="day-1">
                                            <div id="panel_sans_time_box_wrapper" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-5 my-8 gap-4 md:gap-6 lg:gap-8"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                    endif;
                endif;

                /************************************************************************************************************/
                // section: کیف پول

                if($tabs == 'wallet') :

                    if ($user_role == 'sans_manager')
                        wp_redirect(home_url('panel/?ez_panel_nav=sans'));

                    $user_phone         = $user->user_login;
                    $current_balance    = $wldb->get_balance($user_id);
                    $withdrawal_min     = 1000000;
                    $withdrawal_max     = $current_balance;

                    $active_products = [];
                    foreach ( $user_products as $user_product ) {
                        $is_active = get_post_meta($user_product['post_id'], 'sale_active', true);
                        $post_type = get_post_type($user_product['post_id']);

                        if ( $is_active && $post_type == 'product' )
                            $active_products[] = $user_product['post_id'];
                    }

                    $brand_data         = get_the_terms($active_products[0], 'yith_product_brand')[0];
                    $brand_name         = $brand_data->name;
                    $brand_thumb_id     = get_term_meta($brand_data->term_id, 'thumbnail_id', true);
                    $brand_thumb_url    = wp_get_attachment_url($brand_thumb_id);

                    if ( isset( $_POST['requestAmount'] ) ) {

                        if ( !empty(  $wldb->get( array( 'user_id' => $user_id, 'type' => 'withdraw', 'status' => 'در حال پردازش' ), -1 ) ) ) { ?>
                            <div class="error">شما یک درخواست تسویه فعال دارید. لطفا تا تسویه کامل آن درخواست دیگری انجام ندهید.</div>

                        <?php
                        } else {
                            $withdrawal_amount = $_POST['requestAmount'];
                            if ( $withdrawal_amount >= $withdrawal_min && $withdrawal_amount <= $withdrawal_max ) {

                                $current_balance    = $wldb->get_balance($user_id);
                                $withdrawal_amount  = $withdrawal_amount * (-1);
                                $balance            = $current_balance + $withdrawal_amount;
                                $description        = 'درخواست تسویه حساب';

                                $new_transaction = array (
                                    'user_id'       => $user_id,
                                    'amount'        => $withdrawal_amount,
                                    'balance'       => $balance,
                                    'description'   => $description,
                                    'type'          => 'withdraw',
                                    'status'        => 'در حال پردازش',
                                    'origin'        => 1,
                                );
                                $res = $wldb->insert($new_transaction);
                            }
                        }

                        $current_balance= $wldb->get_balance($user_id);
                    } ?>

                    <div class="mt-4">
                        <div class="flex flex-col lg:flex-row items-center justify-center gap-8">
                            <div class="card relative w-80 h-48 bg-[#040d15] cursor-default" style="border-radius: 1rem !important;">
                                <div class="absolute top-0 left-0 w-full h-full">
                                    <div class="text-lg text-slate-50 font-bold text-center mt-2">کیف پول اعتباری</div>
                                </div>

                                <div class="w-full h-full absolute">
                                    <div class="card-name text-right right-4"><?php echo $withdrawal_owner_name_value ?></div>
                                    <div class="card-name-foil text-right right-4"><?php echo $withdrawal_owner_name_value ?></div>
                                    <div class="card-name-foil-second text-right right-4"><?php echo $withdrawal_owner_name_value ?></div>
                                </div>

                                <div class="w-full h-full absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
                                    <div class="absolute block left-4 font-light text-lg text-center text-slate-50" style="top: 57px;color: gold;">
                                        <span class="font-medium"><?php echo number_format( $current_balance ); ?></span>
                                        <span>تومان</span>
                                    </div>
                                </div>

                                <div class="w-full h-full absolute">
                                    <div class="absolute font-medium text-sm text-left leading-4 top-[67%] text-slate-100 inline-block" style="left: 16px;top: 100px;">
                                        <span class="text-xs"><?php echo $withdrawal_owner_shaba_value ?></span>
                                    </div>
                                </div>

                                <div class="card-flag">
                                    <div class="card-security">
                                        <div class="card-security-foil"></div>
                                    </div>
                                </div>

                                <div class="w-8 h-8 absolute left-2 bottom-2">
                                    <img src="<?php echo $brand_thumb_url ?>" alt="">
                                </div>

                                <div class="absolute left-1/2 -translate-x-1/2" style="left: 100px;bottom: 14px !important;">
                                    <div class="text-slate-100 shadow"><?php echo $brand_name ?></div>
                                </div>
                            </div>
                            <div class="min-w-80 max-w-[360px] relative">
                                <div class="border rounded-lg p-4 shadow">
                                    <div class="flex items-center justify-between mb-6">
                                        <div class="text-sm font-semibold ">درخواست تسویه حساب</div>
                                        <button id="fullAmount" class="font-medium text-sm bg-[#0b2c3b] px-2 py-1.5 rounded-md text-white">کل مبلغ</button>
                                    </div>
                                    <div>
                                        <form id="requestCashBack" method="POST" action="" class="space-y-4 child:w-full w-full child:text-sm child:p-2">
                                            <input type="number" class="focus:outline-none border rounded-md shadow appearance-none text-left placeholder:text-right" data-min="<?php echo $withdrawal_min ?>" data-max="<?php echo $current_balance ?>"  name="requestAmount" id="requestAmount" required placeholder="مبلغ(تومان)">
                                            <input class="focus:outline-none bg-orange-500 hover:bg-primary-600 text-white rounded-md shadow cursor-pointer font-medium" type="submit" name="" id="" value="ثبت درخواست">
                                        </form>
                                    </div>
                                </div>
                                <div id="requestCashBackErr" class="absolute w-full bg-yellow-50 py-1.5 px-2 text-center rounded-md mt-2 font-medium shadow hidden z-20"></div>
                            </div>
                        </div>
                        <div class="mt-8">
                            <div class="text-lg font-semibold mb-3">تراکنش‌های کیف پول</div>
                            <div class="container w-full mx-auto px-2">
                                <div id='recipients' class="p-8 mt-6 lg:mt-0 rounded shadow bg-white">

                                    <table id="accountingTable" class="stripe hover row-border" style="width:100%; padding-top: 1em;  padding-bottom: 1em;">

                                        <thead>
                                        <tr>
                                            <th data-priority="1">ردیف</th>
                                            <th data-priority="4">شماره تراکنش</th>
                                            <th data-priority="3">مقدار</th>
                                            <th data-priority="6">موجودی قبل</th>
                                            <th data-priority="7">موجودی</th>
                                            <th data-priority="5">تاریخ درخواست</th>
                                            <th data-priority="2">عنوان</th>
                                            <th data-priority="8">وضعیت</th>
                                        </tr>
                                        </thead>

                                        <tbody>
                                            <?php
                                            $transactions = $wldb->get( array( 'user_id' => $user_id ), 5000 );
                                            if ( !empty($transactions) ) :
                                                foreach ( $transactions as $key => $trans ) :

                                                    $row_background = '';
                                                    if ( (int)$trans->amount > 0  )
                                                        $row_background = 'deposit-info';
                                                    else
                                                        if ( $trans->status == 'انجام شد' )
                                                            $row_background = 'complete-info';
                                                        else
                                                            $row_background = 'cashback-info'; ?>

                                                    <tr class="<?php echo $row_background ?>">
                                                        <td><?php echo $key + 1 ?></td>
                                                        <td><?php echo (int)$trans->ID ?></td>
                                                        <td><?php echo number_format( abs((int)$trans->amount )); ?></td>
                                                        <td><?php echo number_format( (int)$trans->balance - $trans->amount ); ?></td>
                                                        <td><?php echo number_format( (int)$trans->balance ); ?></td>
                                                        <td><?php echo date("H:i", (int)$trans->created_at) . " | " . jdate("Y/m/d", (int)$trans->created_at) ?></td>
                                                        <td class="font-medium"><?php echo $trans->description ?></td>
                                                        <td><?php echo $trans->status ? $trans->status : '-' ?></td>
                                                    </tr>

                                                <?php
                                                endforeach;
                                            endif; ?>
                                        </tbody>

                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                
                    <script>
                        const requestCashBack = document.querySelector('#requestCashBack'),
                            requestAmount = document.querySelector('#requestAmount'),
                            fullAmount = document.querySelector('#fullAmount'),
                            maxAmount = Number(requestAmount.getAttribute('data-max')),
                            minAmount = Number(requestAmount.getAttribute('data-min'));
                        if (requestCashBack) {
                            requestCashBack.addEventListener('submit', function (e) {
                                e.preventDefault();
                                let valueAmount = Number(requestAmount.value);
                                let requestCashBackErr = document.querySelector('#requestCashBackErr');
                                if (maxAmount < minAmount) {
                                    requestCashBackErr.classList.remove('hidden');
                                    requestCashBackErr.innerText = 'مبلغ وارد شده کمتر از حد مجاز است. حداقل مبلغ 1 میلیون تومان می‌باشد.'
                                    setTimeout(() => {
                                        requestCashBackErr.classList.add("hidden");
                                        requestCashBackErr.innerText = '';
                                    }, 5000);
                                } else if (valueAmount < minAmount) {
                                    requestCashBackErr.classList.remove('hidden');
                                    requestCashBackErr.innerText = 'مبلغ وارد شده کمتر از حد مجاز است. حداقل مبلغ 1 میلیون تومان می‌باشد.'
                                    setTimeout(() => {
                                        requestCashBackErr.classList.add("hidden");
                                        requestCashBackErr.innerText = '';
                                    }, 5000);
                                } else if (valueAmount > maxAmount) {
                                    requestCashBackErr.classList.remove('hidden');
                                    requestCashBackErr.innerText = 'مبلغ وارد شده بیشتر از حد مجاز می‌باشد.'
                                    setTimeout(() => {
                                        requestCashBackErr.classList.add("hidden");
                                        requestCashBackErr.innerText = '';
                                    }, 5000);
                                } else {
                                    requestCashBack.submit();
                                }
                            })
                        }
                        if (fullAmount) {
                            fullAmount.addEventListener('click', () => {
                                requestAmount.value = maxAmount;
                            })
                        }
                    </script>

                <?php
                endif;

                /************************************************************************************************************/
                // section: پشتیبانی

                if($tabs == 'ticket') :
                    echo 'به زودی تکمیل می شود.';
                endif;

                /************************************************************************************************************/
                // section: فروش های من

                if($tabs == 'my-sale') : ?>

                    <script type="text/javascript">
                        $(document).ready(function () {
                            $('#panel_mysells_table').DataTable({
                                "order"     : [],
                                "ordering"  : false,
                                "pageLength": -1,
                                "paging"    : false,
                                "language"  : {url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'},
                                "dom"       : 'Bfrt',
                                "buttons"   : [],
                                "searching" : false,
                            });
                        });
                    </script>

                    <?php
                    if ($user_role == 'sans_manager')
                        wp_redirect(home_url('panel/?ez_panel_nav=sans'));

                    $items_per_page = 15;
                    $page_num       = isset($_GET['page_num']) ? $_GET['page_num'] : 1;

                    foreach ( $user_products as $user_product )
                        $products_id[] = $user_product['post_id'];

                    $orders_id = get_orders_ids_by_product_id($products_id, ['wc-completed', 'wc-partially-paid', 'wc-walletx']);

                    $max_page_num = round ( count( $orders_id ) / $items_per_page );

                    $orders_id = array_slice($orders_id, ($page_num - 1) * $items_per_page, $items_per_page);

                    foreach ( $orders_id as $order_id ) {
                        $order = wc_get_order($order_id);

                        foreach ($order->get_items() as $item) {
                            $product_id = $item->get_product_id();
                            $quantity   = $item->get_quantity();
                        }

                        $pish_per_person    = get_post_meta( $order_id, 'ticket_tedad', true );
                        $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : get_post_meta( $product_id, 'pish_pardakht_per_person', true );
                        $pish_per_person    = !empty( $pish_per_person ) ? $pish_per_person : 1;

                        $pish       = get_post_meta( $order_id, "_order_total_2", true );
                        $pish_final = $pish ? : get_post_meta( $order_id, "_order_total", true );

                        $item_total = $pish_final / $pish_per_person * $quantity;

                        $args = [
                            "single_value"  => true,
                            "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id",
                        ];
                        $response = ez_reservation( array('type' => 'query_execution', 'data' => $args) );
                        $row = (array)json_decode($response);

                        if ( !empty( $row['booking_time'] ) )
                            $orders[] = [
                                'order_id'      => (int)$order_id,
                                'product_title' => get_the_title($product_id),
                                'tickets_count' => $quantity,
                                'purchase_time' => (int)$row['booked_time'],
                                'holding_time'  => (int)$row['booking_time'],
                                'total_payment' => (int)$item_total,
                                'prepaid'       => (int)$pish_final,
                                'status'        => time() > $row['booking_time'] ? 'بازی کرده اند' : 'در راه شروع بازی',
                                'url'           => get_permalink($product_id),
                            ];
                    } ?>

                    <div class="text-lg font-semibold mb-3">فروش های من</div>
                    <div class="container w-full mx-auto px-2">
                        <div id='recipients' class="p-8 mt-6 lg:mt-0 rounded shadow bg-white">

                            <table id="panel_mysells_table" class="stripe hover row-border" style="width:100%; padding-top: 1em;  padding-bottom: 1em;">
                                <thead>
                                    <tr>
                                        <th data-priority="1">ردیف</th>
                                        <th data-priority="8">شماره سفارش</th>
                                        <th data-priority="2">اتاق</th>
                                        <th data-priority="3">تعداد</th>
                                        <th data-priority="8">تاریخ خرید</th>
                                        <th data-priority="2">تاریخ بازی</th>
                                        <th data-priority="8">مبلغ کل</th>
                                        <th data-priority="2">پیش پرداخت</th>
                                        <th data-priority="8">مانده پرداخت</th>
                                        <th data-priority="8">وضعیت</th>
                                    </tr>
                                </thead>

                                <tbody>

                                <?php
                                if ( !empty($orders) ) :
                                    foreach ( $orders as $key => $order ) : ?>

                                        <tr>
                                            <td><?php echo $key + 1 ?></td>
                                            <td><?php echo $order['order_id'] ?></td>
                                            <td><?php echo $order['product_title'] ?></td>
                                            <td><?php echo $order['tickets_count'] ?></td>
                                            <td><?php echo jdate("Y/m/d", (int)$order['purchase_time'] ) . " | " . date("H:i", (int)$order['purchase_time'] ); ?></td>
                                            <td><?php echo jdate("Y/m/d", $order['holding_time'] ) . " | " . date("H:i", $order['holding_time'] ); ?></td>
                                            <td><?php echo number_format( (int)$order['total_payment'] )?></td>
                                            <td><?php echo number_format( (int)$order['prepaid'] )?></td>
                                            <td><?php echo number_format( (int)$order['total_payment'] - (int)$order['prepaid'] )?></td>
                                            <td><?php echo $order['status'] ?></td>
                                        </tr>

                                    <?php
                                    endforeach;
                                endif; ?>

                                </tbody>
                            </table>

                            <?php
                            $current_page   = max(1, min($page_num, $max_page_num));
                            $adjacent_pages = 2; ?>

                            <div class="pagination">
                                <?php
                                if ($current_page > 1) : ?>
                                    <a href="?ez_panel_nav=my-sale&page_num=<?php echo $current_page - 1; ?>" class="prev">قبلی</a>
                                <?php endif; ?>

                                <?php
                                for ($i = 1; $i <= $max_page_num; $i++):

                                    if ($i == $current_page): ?>
                                        <span class="page-number current"><?php echo $i; ?></span>
                                    <?php
                                    elseif ($i <= $adjacent_pages || $i > $max_page_num - $adjacent_pages || ($i >= $current_page - $adjacent_pages && $i <= $current_page + $adjacent_pages)): ?>
                                        <a href="?ez_panel_nav=my-sale&page_num=<?php echo $i; ?>" class="page-number"><?php echo $i; ?></a>
                                    <?php
                                    elseif ($i == $adjacent_pages + 1 || $i == $max_page_num - $adjacent_pages) : ?>
                                        <span class="dots">...</span>
                                    <?php
                                    endif; ?>
                                <?php
                                endfor; ?>

                                <?php
                                if ($current_page < $max_page_num): ?>
                                    <a href="?ez_panel_nav=my-sale&page_num=<?php echo $current_page + 1; ?>" class="next">بعدی</a>
                                <?php
                                endif; ?>
                            </div>

                        </div>
                    </div>

                <?php
                endif;

                /************************************************************************************************************/
                // section: پروفایل

                if($tabs == 'profile') :
                    echo 'به زودی تکمیل می شود.';
                endif;

                /************************************************************************************************************/ ?>

            </div>
        </div>
    </div>
    <!-- main content end -->

    <!-- bottom navigation start -->
    <div class="md:hidden fixed bottom-0 w-full bg-[#0b2c3b] text-white rounded-md shadow py-6 px-2.5 transition-all duration-500 z-20">
        <div class="container flex items-center justify-between">
            <div><a href="/panel/?ez_panel_nav=my-games" class="button-menu <?= ($tabs == 'my-games') ? 'active' : '' ?>"><svg class="w-7 h-7"><use href="#my-game-icon"></use></svg></a></div>
            <div><a href="/panel/?ez_panel_nav=sans" class="button-menu <?= ($tabs == 'sans' || !$tabs) ? 'active' : '' ?>"><svg class="w-7 h-7"><use href="#sans-icon"></use></svg></a></div>
            <div class="relative" id="accounting-menu">
                <button class="button-menu <?= ($tabs == 'wallet' || $tabs == 'my-sale') ? 'active' : '' ?>"><svg class="w-7 h-7"><use href="#accounting-icon"></use></svg></button>
                <div id="accounting-section">
                    <ul class="space-y-2">
                        <li><a class="hover:bg-slate-100 text-[#0b2c3b] hover:shadow rounded font-medium px-2 py-1 inline-flex items-center gap-1 w-max" href="/panel/?ez_panel_nav=wallet">
                                <svg class="w-5 h-5"><use href="#wallet-icon"></use></svg>
                                <span class="menu-sidebar-title">
                کیف پول
                </span>
                            </a></li>
                        <li><a class="hover:bg-slate-100 text-[#0b2c3b] hover:shadow rounded font-medium px-2 py-1 inline-flex items-center gap-1 w-max" href="/panel/?ez_panel_nav=my-sale">
                                <svg class="w-5 h-5"><use href="#my-sale-icon"></use></svg>
                                <span class="menu-sidebar-title">
                فروش‌های من
                </span>
                            </a></li>
                    </ul>
                </div>
            </div>
            <div><a href="/panel/?ez_panel_nav=ticket" class="button-menu <?= ($tabs == 'ticket') ? 'active' : '' ?>"><svg class="w-7 h-7"><use href="#support-icon"></use></svg></a></div>
        </div>
    </div>
    <!-- bottom navigation end -->
<?php get_footer(); ?>