<?php
if ( !(current_user_can('administrator') || current_user_can('shopist') || current_user_can('accounting') || current_user_can('poshtiban') ) ) {
    global $wp_query;
    $wp_query->set_404();
    status_header( 404 );
    get_template_part( 404 ); exit();
}

if ( current_user_can('administrator') )    $role = 'administrator';
if ( current_user_can('shopist') )          $role = 'shopist';
if ( current_user_can('accounting') )       $role = 'accounting';
if ( current_user_can('poshtiban') )        $role = 'poshtiban';

global $wpdb;

function search_orders_by_order_id($order_id = '', $page = 1, $limit = 25 ) {
    global $wpdb;

    $order_id = '%' . esc_sql($wpdb->esc_like($order_id)) . '%';

    $query = $wpdb->prepare("
        SELECT DISTINCT posts.ID FROM wp_posts AS posts
        WHERE posts.post_type = 'shop_order'
        AND posts.ID LIKE %s
        ORDER BY posts.ID DESC
        LIMIT %d OFFSET %d 
    ", $order_id, $limit, ($page - 1) * $limit);

    $results = $wpdb->get_col( $query );
    return $results;
}

function search_orders_by_user_name($first_name = '', $page = 1, $limit = 25 ) {
    global $wpdb;

    $first_name = '%' . esc_sql($wpdb->esc_like($first_name)) . '%';

    $query = $wpdb->prepare("
        SELECT DISTINCT post_id FROM wp_postmeta  
        WHERE (meta_key = '_billing_address_index' AND meta_value LIKE %s)
        ORDER BY post_id DESC
        LIMIT %d OFFSET %d 
    ", $first_name, $limit, ($page - 1) * $limit);

    $results = $wpdb->get_col( $query );
    return $results;
}

function search_orders_by_user_phone($user_phone = '', $page = 1, $limit = 25 ) {
    global $wpdb;

    $user_phone = '%' . esc_sql($wpdb->esc_like($user_phone)) . '%';

    $query = $wpdb->prepare("
        SELECT DISTINCT post_id FROM wp_postmeta  
        WHERE (meta_key = '_billing_phone' AND meta_value LIKE %s)
        ORDER BY post_id DESC
        LIMIT %d OFFSET %d 
    ", $user_phone, $limit, ($page - 1) * $limit);

    $results = $wpdb->get_col( $query );
    return $results;
}

function search_orders_by_product_title($product_title = '', $page = 1, $limit = 25 ) {
    global $wpdb;

    $product_title = '%' . esc_sql($wpdb->esc_like($product_title)) . '%';

    $query = $wpdb->prepare("
        SELECT DISTINCT posts.ID FROM wp_posts AS posts 
        INNER JOIN wp_woocommerce_order_items AS order_items ON posts.ID = order_items.order_id 
        INNER JOIN wp_woocommerce_order_itemmeta AS item_meta ON order_items.order_item_id = item_meta.order_item_id
        WHERE posts.post_type = 'shop_order'  AND item_meta.meta_key = '_product_id' AND item_meta.order_item_id IN (  
            SELECT order_item_id   
            FROM wp_woocommerce_order_itemmeta   
            WHERE meta_key = '_product_id'   
            AND order_item_id IN (  
                SELECT order_item_id   
                FROM wp_woocommerce_order_items   
                WHERE order_id = posts.ID  
            )  
            AND meta_value IN (  
                SELECT ID   
                FROM wp_posts   
                WHERE post_title LIKE %s  
            )  
        )
        ORDER BY order_items.order_id DESC 
        LIMIT %d OFFSET %d 
    ", $product_title, $limit, ($page - 1) * $limit);

    $results = $wpdb->get_col( $query );
    return $results;
}

get_header();

global $wpdb; ?>

<link rel="stylesheet" type="text/css" href="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css">
<script type="text/javascript" src="//cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
<script type="text/javascript">
    jQuery(document).ready(function ($) {
        $('#supporting_table').DataTable({
            "order"     : [],
            "ordering"  : false,
            "pageLength": -1,
            "paging"    : false,
            "language"  : {url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'},
            "dom"       : 'Bfrt',
            "buttons"   : [],
            "searching" : false,
        });

        $('#zibal_table').DataTable({
            "order"     : [],
            "ordering"  : false,
            "pageLength": -1,
            "paging"    : false,
            "language"  : {url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'},
            "dom"       : 'Bfrt',
            "buttons"   : [],
            "searching" : false,
        });

        $('body').on("click", ".supporting_admin_control", function () {
            let $this = $(this);

            if ( confirm('مطمئن هستید؟') ) {

                $('#loading').show();

                $.ajax({
                    type    : 'POST',
                    url     : "<?php echo admin_url('admin-ajax.php') ?>",
                    data    : {
                        'action'                : 'ez_site_ajax_handler',
                        'nonce'                 : "<?php echo wp_create_nonce('ajax-nonce') ?>",
                        '_supporting_control_'  : true,
                        'order_id'              : $this.closest('tr').attr('order-id'),
                        'status'                : $this.attr('control-status'),
                    },
                    dataType: "json",
                    success: function(data) {
                        location.reload();
                    },
                });

            } else
                return false;
        });

        $('body').on('click', '#supporting_table td.quantity', function () {
            const $this = $(this);
            const $old_quantity = $this.text();

            $this.attr('contenteditable', 'true').addClass('editable').focus();

            $this.on('blur', function () {
                const $new_quantity = $this.text();

                if ( $old_quantity == $new_quantity )
                    return;

                $this.attr('contenteditable', 'false').removeClass('editable');

                $('.quantity').removeClass('quantity').addClass('quantity_dis');

                $('#loading').show();

                $.ajax({
                    type    : 'POST',
                    url     : "<?php echo admin_url('admin-ajax.php') ?>",
                    data    : {
                        'action'                        : 'ez_site_ajax_handler',
                        'nonce'                         : "<?php echo wp_create_nonce('ajax-nonce') ?>",
                        '_supporting_change_quantity_'  : true,
                        'order_id'                      : $this.closest('tr').attr('order-id'),
                        'new_quantity'                  : $new_quantity,
                    },
                    dataType: "json",
                    success: function(data) {
                        $('#loading').hide();
                        $('.quantity_dis').removeClass('quantity_dis').addClass('quantity');
                    },
                });
            });

            $this.on('keypress', function (e) {
                if (e.which === 13)
                    $this.blur();
            });

            $this.on('keydown', function (e) {
                if (e.which === 27) {
                    $this.text($old_quantity);
                    $this.blur();
                }
            });
        });

        $('body').on('change', '#supporting_table .happycall', function () {
            const $this = $(this);

            $('#loading').show();

            $.ajax({
                type    : 'POST',
                url     : "<?php echo admin_url('admin-ajax.php') ?>",
                data    : {
                    'action'                    : 'ez_site_ajax_handler',
                    'nonce'                     : "<?php echo wp_create_nonce('ajax-nonce') ?>",
                    '_supporting_happycall_'    : true,
                    'order_id'                  : $this.closest('tr').attr('order-id'),
                    'state'                     : $this.is(':checked'),
                },
                dataType: "json",
                success: function(data) {
                    $('#loading').hide();
                    $('.quantity_dis').removeClass('quantity_dis').addClass('quantity');
                },
            });
        });
    });
</script>
<style>
    .supporting_admin_control_admin_cancel {
        background: red;
        color: #fff;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 14px;
    }
    .supporting_admin_control_admin_cancel:hover {
        background: #ff5900;
        color: #fff;
    }
    .supporting_admin_control_refund {
        background: #6200ff;
        color: #fff;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 14px;
    }
    .supporting_admin_control_refund:hover {
        background: #904bff;
        color: #fff;
    }
    .supporting_admin_control_wallet {
        background: #a7a200;
        color: #fff;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 14px;
    }
    .supporting_admin_control_wallet:hover {
        background: #d3cd00;
        color: #fff;
    }
    .supporting_admin_control_trash {
        background: #898989;
        color: #fff;
        padding: 5px 10px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 14px;
    }
    .supporting_admin_control_trash:hover {
        background: #adadad;
        color: #fff;
    }
    #supporting_table {
        font-size: 14px;
        margin-top: 50px;
        display: inline-block;
    }
    #supporting_table td {
        text-align: center;
        position: relative;
        text-wrap: nowrap;
    }
    input.supporting_search_fields {
        display: flex;
        border: 1px solid #d3d3d3;
        height: 35px;
        border-radius: 8px;
        position: absolute;
        top: -40px;
        width: calc(100% - 1px);
    }
    input#supporting_search_submit_btn {
        display: flex;
        border: none;
        height: 35px;
        border-radius: 8px;
        position: absolute;
        top: -40px;
        width: calc(100% - 20px);
        background: #ff8100;
        color: #fff;
    }
    .order_status_td span {
        display: block;
        border-radius: 4px;
        margin: 0px 0px;
        border-bottom: 1px solid rgba(0, 0, 0, .05);
        padding: 3px 5px;
    }
    #page_num {
        display: flex;
        justify-content: left;
        align-items: center;
    }
    #page_num input[type=text] {
        display: flex;
        border: 1px solid #d3d3d3;
        height: 35px;
        border-radius: 8px;
        padding: 0 10px;
        width: 70px;
    }
    #page_num input[type=submit] {
        display: flex;
        border: none;
        height: 35px;
        border-radius: 8px;
        background: #ff8100;
        color: #fff;
        margin: 0 3px 0 0;
        width: 50px;
    }
    .loading {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background-color: rgba(0, 0, 0, 0.7);
        color: #fff;
        padding: 20px;
        border-radius: 5px;
        z-index: 1000;
        display: none;
    }
    .quantity {
        direction: ltr;
    }
    td.editable:focus {
        outline: none;
    }
    .button-container {
        display: flex;
        gap: 20px;
        margin-bottom: 50px;
    }
    .btn {
        padding: 15px 25px;
        font-size: 16px;
        color: white;
        text-decoration: none;
        border-radius: 5px;
        transition: background-color 0.3s ease;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    .btn:nth-child(1) {
        background-color: #4caf50;
    }
    .btn:nth-child(2) {
        background-color: #008cba;
    }
    .btn:nth-child(3) {
        background-color: #f44336;
    }
    .btn:nth-child(4) {
        background-color: #ffbe00;
    }
    .btn:nth-child(5) {
        background-color: #da00ff;
    }
    .btn:hover {
        opacity: 0.8;
        transform: translateY(-2px);
        border: none;
    }
</style>

<div class="container main-warp">

    <div class="button-container">
        <a href="https://escapezoom.ir/supporting/" class="btn">همه سفارشات</a>
        <a href="https://escapezoom.ir/supporting/?tab=zibal" class="btn">زیبال</a>
        <a href="https://escapezoom.ir/supporting/?tab=bad_orders" class="btn">سفارشات بد</a>

        <?php
        if ( get_current_user_id() == 3325 || get_current_user_id() == 6289 ) : ?>
            <a href="https://escapezoom.ir/supporting/?tab=phone_change" class="btn">تغییر شماره</a>
        <?php
        endif; ?>

        <a href="https://escapezoom.ir/test" class="btn">اطلاعات بازی ها(تست)</a>

    </div>

    <?php
    $tab = $_GET['tab'];

    if ( !isset( $tab ) or empty( $tab ) or $tab == 'orders' ) : // همه سفارشات
        $posts_per_page = 25;

        if ( isset($_GET['page_num']) and !empty($_GET['page_num']) )
            $page_num = $_GET['page_num'];
        else
            $page_num = 1;

        $args = [
            'post_type'     => 'shop_order',
            'post_status'   => 'any',
        ];

        if ( isset($_GET['order_id']) and !empty($_GET['order_id']) ) {
            $order_id = $_GET['order_id'];
            $args['post__in'] = search_orders_by_order_id($order_id, $page_num, $posts_per_page) ? : [-1];

        } elseif ( isset($_GET['first_name']) and !empty($_GET['first_name']) ) {
            $first_name = $_GET['first_name'];
            $args['post__in'] = search_orders_by_user_name($first_name, $page_num, $posts_per_page) ? : [-1];

        } elseif ( isset($_GET['user_phone']) and !empty($_GET['user_phone']) ) {
            $user_phone = $_GET['user_phone'];
            $args['post__in'] = search_orders_by_user_phone($user_phone, $page_num, $posts_per_page) ? : [-1];

        } elseif ( isset($_GET['product_title']) and !empty($_GET['product_title']) ) {
            $product_title = $_GET['product_title'];
            $args['post__in'] = search_orders_by_product_title($product_title, $page_num, $posts_per_page) ? : [-1];

        } else {
            $args['posts_per_page'] = $posts_per_page;
            $args['paged']          = $page_num;
        } ?>

        <form method="get" action="">
            <div id="loading" class="loading" style="display: none;">ذخیره کردن...</div>

            <table id="supporting_table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td><input type="text" class="supporting_search_fields" name="order_id" value="<?php echo $order_id; ?>" style="text-align: left;direction: ltr;">سفارش</td>
                        <td>تاریخ</td>
                        <td>وضعیت</td>
                        <td><input type="text" class="supporting_search_fields" name="first_name" value="<?php echo $first_name; ?>">نام</td>
                        <td><input type="text" class="supporting_search_fields" name="user_phone" value="<?php echo $user_phone; ?>" style="text-align: left;direction: ltr;">همراه</td>
                        <td><input type="text" class="supporting_search_fields" name="product_title" value="<?php echo $product_title; ?>">محصول</td>
                        <td>سپرده</td>
                        <td>تعداد</td>
                        <td>سانس</td>
                        <td>هپی کال</td>
                        <td><input type="submit" id="supporting_search_submit_btn" value="جستجو...">عملیات</td>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    $quantity_all = 0;

                    $the_query = new WP_Query($args);
                    if ($the_query->have_posts()) :
                        while ($the_query->have_posts()) : $the_query->the_post();
                            $order_id = get_the_ID();

                            $is_completed_order = false;

                            $order = wc_get_order($order_id);

                            if ( $order->get_billing_first_name() || $order->get_billing_last_name() )
                                $buyer = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $order->get_billing_first_name(), $order->get_billing_last_name() ) );

                            $order_date = human_time_diff(strtotime($order->get_date_created()), current_time('timestamp')) . ' قبل';

                            $order_status = $order->get_status();
                            if ( $order_status == 'pending' )               $order_status_color = "color: #777;background: #e5e5e5;";
                            elseif ( $order_status == 'cancelled' )         $order_status_color = "color: #777;background: #e5e5e5;";
                            elseif ( $order_status == 'refunded' )          $order_status_color = "color: #616161;background: #fcd9d9;";
                            elseif ( $order_status == 'conflict' )          $order_status_color = "color: #000000;background: #ecc63c;";
                            elseif ( $order_status == 'admin-cancelled' )   $order_status_color = "color: #ffffff;background: #800000;";

                            elseif ( $order_status == 'completed' ) {
                                $order_status_color = "color: #ffffff;background: #0f9e02;";
                                $is_completed_order = true;
                            }

                            elseif ( $order_status == 'partially-paid' ) {
                                $order_status_color = "color: #ffffff;background: #ff6200;";
                                $is_completed_order = true;
                            }

                            elseif ( $order_status == 'walletx' ) {
                                $order_status_color = "color: #ffffff;background: #135964;";
                                $is_completed_order = true;
                            }

                            foreach ($order->get_items() as $item_id => $item) {
                                $product_name   = $item->get_name();
                                $quantity       = $item->get_quantity();
                            }

                            if ( $is_completed_order )
                                $quantity_all += $quantity;

                            echo $prepaid = get_post_meta( $order_id, "prepaid", true ) . 'saeed';

                            $pish_final = $prepaid ? : (get_post_meta( $order_id, "_order_total_2", true ) ? : get_post_meta( $order_id, "_order_total", true ));

                            $sans_args = [
                                "single_value"  => true,
                                "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id ORDER BY `booking_id` DESC",
                            ];
                            $sans_time = ((array)json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $sans_args) )))['booking_time']; ?>

                            <tr order-id="<?php echo $order_id ?>">
                                <td><a href="<?php echo home_url('/supporting?order_id=' . $order_id) ?>" title="جستجوی <?php echo $order_id ?>"><?php echo $order_id ?></td>
                                <td><?php echo $order_date ?></td>
                                <td class="order_status_td"><span style="<?php echo $order_status_color ?>"><?php echo wc_get_order_status_name( $order->get_status() ) ?></span></td>
                                <td><a href="<?php echo home_url('/supporting?first_name=' . $buyer) ?>" title="جستجوی <?php echo $buyer ?>"><?php echo $buyer ?></td>
                                <td><a href="<?php echo home_url('/supporting?user_phone=' . $order->billing_phone) ?>" title="جستجوی <?php echo $order->billing_phone ?>"><?php echo $order->billing_phone ?></a></td>
                                <td style="font-size: 12px;"><a href="<?php echo home_url('/supporting?product_title=' . $product_name) ?>" title="جستجوی <?php echo $product_name ?>"><?php echo $product_name ?></a></td>
                                <td><?php echo number_format( $pish_final ) . ' تومان'; ?></td>
                                <td <?php echo $role != 'poshtiban' ?  'class="quantity"' : '' ?>><?php echo $quantity ?></td>
                                <td style="color: #00a500;font-weight: bold;font-size: 13px;text-wrap: nowrap;"><?php echo $sans_time ? wp_date('H:i ..... Y-m-d', $sans_time) : '----------------' ?></td>
                                <td><input type="checkbox" class="happycall" style="appearance: auto;cursor: pointer" value="1" <?php echo get_post_meta( $order_id, "supporting_happycall", true ) == 1 ? 'checked' : ''; ?>></td>
                                <td>
                                    <?php
                                    if ( $role != 'poshtiban' ) : ?>

                                        <?php
                                        if ( $role == 'administrator' || $role == 'shopist' || $role == 'accounting' ) {?>
                                            <a href="javascript:;" class="supporting_admin_control supporting_admin_control_admin_cancel" control-status="admin-cancelled">لغو ادمین</a>
                                        <?php
                                        }

                                        if ( $role == 'administrator' || $role == 'shopist' ) { ?>
                                            <a href="javascript:;" class="supporting_admin_control supporting_admin_control_refund" control-status="refunded">مسترد</a>
                                        <?php
                                        }

                                        if ( $role == 'administrator' || $role == 'accounting' ) { ?>
                                            <a href="javascript:;" class="supporting_admin_control supporting_admin_control_wallet" control-status="walletx">کیف پول</a>
                                        <?php
                                        } ?>

                                    <?php
                                    else: ?>

                                    ----------

                                    <?php
                                    endif; ?>
                                </td>
                            </tr>

                        <?php
                        endwhile;
                        wp_reset_postdata();
                    endif; ?>
                </tbody>

                <tfooter>
                    <tr>
                        <td>سفارش</td>
                        <td>تاریخ</td>
                        <td>وضعیت</td>
                        <td>نام</td>
                        <td>همراه</td>
                        <td>محصول</td>
                        <td>سپرده</td>
                        <td>تعداد</td>
                        <td>سانس</td>
                        <td>هپی کال</td>
                        <td>عملیات</td>
                    </tr>
                </tfooter>
            </table>

            <div id="page_num" >

                <span style="float: left;display: inline-block;width: 100%;font-size: 20px;font-weight: bold;color: #9b0000;">تعداد بلیط های فروخته شده: <?php echo $quantity_all ?></span>

                <span>صفحه:</span>
                <input type="text"name="page_num" value="<?php echo $page_num ? : 1 ?>">
                <input type="submit" value="برو">
            </div>

        </form>

    <?php
    elseif( $tab == 'zibal' ) :
        $transactions_per_page = 500;

        if ( isset($_GET['page_num']) and !empty($_GET['page_num']) )
            $page_num = $_GET['page_num'];
        else
            $page_num = 1;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.zibal.ir/v1/gateway/report/transaction');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 45);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer 453addf8358f4140ac087308f14c6d45',
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
            'size'          => $transactions_per_page,
            'page'          => $page_num,
            'merchantId'    => '64859eefcbbc27001c8510e0',
            'verbose'       => true
        ]));
        $transactions = json_decode( curl_exec($ch) )->data;
        if (curl_errno($ch))
            echo 'Error:' . curl_error($ch);
        curl_close($ch); ?>

        <form method="get" action="">
            <table id="zibal_table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>سفارش</td>
                        <td>تاریخ</td>
                        <td>مبلغ</td>
                        <td>نام</td>
                        <td>همراه</td>
                        <td>شماره کارت</td>
                    </tr>
                </thead>

                <tbody>
                    <?php
                    foreach ( $transactions as $transaction ) : ?>

                        <tr>
                            <td><?php echo $transaction->orderId ?></td>
                            <td><?php echo $transaction->paidAtPretty ?></td>
                            <td><?php echo number_format( $transaction->amount ) ?></td>
                            <td><?php echo preg_replace('/.*?خریدار :\s*(.*)/u', '$1', $transaction->description) ?></td>
                            <td><?php echo $transaction->mobile ?></td>
                            <td><?php echo $transaction->cardNumber ?></td>
                        </tr>

                    <?php
                    endforeach; ?>
                </tbody>

                <tfooter>
                    <tr>
                        <td>سفارش</td>
                        <td>تاریخ</td>
                        <td>مبلغ</td>
                        <td>نام</td>
                        <td>همراه</td>
                        <td>شماره کارت</td>
                    </tr>
                </tfooter>

            </table>

            <div id="page_num" >
                <span>صفحه:</span>
                <input type="hidden" name="tab" value="zibal">
                <input type="text" name="page_num" value="<?php echo $page_num ?>">
                <input type="submit" value="برو">
            </div>

        </form>

    <?php
    elseif( $tab == 'bad_orders' ) : ?>

        <form method="get" action="">
            <div id="loading" class="loading" style="display: none;">ذخیره کردن...</div>

            <table id="supporting_table" class="display" style="width:100%">
                <thead>
                <tr>
                    <td>سفارش</td>
                    <td>تاریخ</td>
                    <td>وضعیت</td>
                    <td>نام</td>
                    <td>همراه</td>
                    <td>محصول</td>
                    <td>سپرده</td>
                    <td>تعداد</td>
                    <td>سانس</td>
                    <td>عملیات</td>
                </tr>
                </thead>

                <tbody>
                <?php
                $orders_obj = $wpdb->get_results($wpdb->prepare("SELECT ID, post_status FROM `wp_posts` WHERE `post_type` LIKE 'shop_order' ORDER BY `wp_posts`.`ID` DESC LIMIT 2000"));
                $orders_id_list = implode(',', array_map(function($item) {return $item->ID;}, $orders_obj));
                $bad_orders_id  = [];

                $sans_args = [
                    "single_value"  => false,
                    "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` IN ($orders_id_list) ORDER BY `wc_order_id` DESC",
                ];
                $sanses_time = (array)json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $sans_args) ));

                foreach ( $orders_obj as $order_obj ) :

                    $sans_time = false;
                    foreach ($sanses_time as $object)
                        if (isset($object->wc_order_id) && $object->wc_order_id == $order_obj->ID)
                            $sans_time = $object;

                    if ( $sans_time )
                        continue;

                    if ( $order_obj->post_status != 'wc-partially-paid' )
                        continue;

                    $bad_orders_id[] = $order_obj;
                endforeach;

                $bad_orders_id_list = array_map(function($item) {return $item->ID;}, $bad_orders_id);
                $args = [
                    'post_type'     => 'shop_order',
                    'post_status'   => 'any',
                    'post__in'      => $bad_orders_id_list,
                ];
                $the_query = new WP_Query($args);
                if ($the_query->have_posts()) :
                    while ($the_query->have_posts()) : $the_query->the_post();
                        $order_id = get_the_ID();

                        $status = $wpdb->get_var( $wpdb->prepare(
                            "SELECT post_status FROM $wpdb->posts WHERE ID = %d AND post_type = 'shop_order'",
                            $order_id
                        ) );

                        $sans_args = [
                            "single_value"  => true,
                            "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `wc_order_id` = $order_id ORDER BY `booking_id` DESC",
                        ];
                        $sans_time = ((array)json_decode(ez_reservation( array('type' => 'query_execution', 'data' => $sans_args) )))['booking_time'];

                        if ( $sans_time )
                            continue;

                        if ( $status != 'wc-partially-paid' )
                            continue;

                        $order = wc_get_order($order_id);

                        if ( $order->get_billing_first_name() || $order->get_billing_last_name() )
                            $buyer = trim( sprintf( _x( '%1$s %2$s', 'full name', 'woocommerce' ), $order->get_billing_first_name(), $order->get_billing_last_name() ) );

                        $order_date = human_time_diff(strtotime($order->get_date_created()), current_time('timestamp')) . ' قبل';

                        $order_status = $order->get_status();
                        if ( $order_status == 'pending' )               $order_status_color = "color: #777;background: #e5e5e5;";
                        elseif ( $order_status == 'completed' )         $order_status_color = "color: #ffffff;background: #0f9e02;";
                        elseif ( $order_status == 'cancelled' )         $order_status_color = "color: #777;background: #e5e5e5;";
                        elseif ( $order_status == 'refunded' )          $order_status_color = "color: #616161;background: #fcd9d9;";
                        elseif ( $order_status == 'conflict' )          $order_status_color = "color: #000000;background: #ecc63c;";
                        elseif ( $order_status == 'walletx' )           $order_status_color = "color: #ffffff;background: #135964;";
                        elseif ( $order_status == 'partially-paid' )    $order_status_color = "color: #ffffff;background: #ff6200;";
                        elseif ( $order_status == 'admin-cancelled' )   $order_status_color = "color: #ffffff;background: #800000;";

                        foreach ($order->get_items() as $item_id => $item) {
                            $product_name   = $item->get_name();
                            $quantity       = $item->get_quantity();
                        }

                        $pish_final = get_post_meta( $order_id, "_order_total_2", true ) ? : get_post_meta( $order_id, "_order_total", true ); ?>

                        <tr order-id="<?php echo $order_id ?>">
                            <td><?php echo $order_id ?></td>
                            <td><?php echo $order_date ?></td>
                            <td class="order_status_td"><span style="<?php echo $order_status_color ?>"><?php echo wc_get_order_status_name( $order->get_status() ) ?></span></td>
                            <td><?php echo $buyer ?></td>
                            <td><?php echo $order->billing_phone ?></td>
                            <td style="font-size: 12px;"><?php echo $product_name ?></td>
                            <td><?php echo number_format( $pish_final ) . ' تومان'; ?></td>
                            <td <?php echo $role != 'poshtiban' ?  'class="quantity"' : '' ?>><?php echo $quantity ?></td>
                            <td style="color: #00a500;font-weight: bold;font-size: 13px;text-wrap: nowrap;"><?php echo $sans_time ? wp_date('H:i ..... Y-m-d', $sans_time) : '----------------' ?></td>
                            <td>
                                <?php
                                if ( $role == 'administrator' ) : ?>
                                    <a href="javascript:;" class="supporting_admin_control supporting_admin_control_trash" control-status="trash">زباله</a>

                                <?php
                                else: ?>

                                    ----------

                                <?php
                                endif; ?>
                            </td>
                        </tr>

                    <?php
                    endwhile;
                    wp_reset_postdata();
                endif; ?>
                </tbody>

                <tfooter>
                    <tr>
                        <td>سفارش</td>
                        <td>تاریخ</td>
                        <td>وضعیت</td>
                        <td>نام</td>
                        <td>همراه</td>
                        <td>محصول</td>
                        <td>سپرده</td>
                        <td>تعداد</td>
                        <td>سانس</td>
                        <td>عملیات</td>
                    </tr>
                </tfooter>

            </table>

            <div id="page_num" >
                <span>صفحه:</span>
                <input type="hidden" name="tab" value="bad_orders">
                <input type="text" name="page_num" value="<?php echo $page_num ?>">
                <input type="submit" value="برو">
            </div>

        </form>

    <?php
    elseif( $tab == 'phone_change' && (get_current_user_id() == 3325 || get_current_user_id() == 6289) ) : ?>

        <style>
            .main-warp form {
                background-color: #ffffff;
                border-radius: 8px;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                padding: 20px;
                max-width: 400px;
                margin: auto;
            }
            span {
                font-weight: bolder;
                color: #f96f0c;
                display: block;
                margin-bottom: 15px;
                font-size: 18px;
                text-align: center;
            }
            p {
                margin-bottom: 15px;
            }
            strong {
                display: block;
                margin-bottom: 5px;
                font-size: 16px;
            }
            input[type="tel"] {
                width: 100%;
                padding: 10px;
                border: 1px solid #ddd;
                border-radius: 4px;
                font-size: 16px;
                transition: border-color 0.3s;
            }
            input[type="tel"]:focus {
                border-color: #f96f0c;
                outline: none;
            }
            button {
                background-color: #f96f0c;
                color: #ffffff;
                border: none;
                border-radius: 4px;
                padding: 10px 15px;
                font-size: 16px;
                cursor: pointer;
                display: block;
                width: 100%;
                transition: background-color 0.3s;
                margin-top: 10px;
            }
            button:hover {
                background-color: #e67e22;
            }
        </style>

        <form method="post" action="" style="margin-top:20px;">
            <span style="font-weight:bolder;color:#f96f0c;">مدیریت شماره تماس های اسکیپ زوم:</span>
            <p>
                <strong>شماره اول :</strong><br />
                <input id="numberonecontact" type="tel" name="numberonecontact" size="12" value="<?php echo get_option('numberonecontact'); ?>" />
            </p>

            <p>
                <strong>شماره دوم :</strong><br />
                <input id="numbertwocontact" type="tel" name="numbertwocontact" size="12" value="<?php echo get_option('numbertwocontact'); ?>" />
            </p>

            <p>
                <strong>شماره سوم :</strong><br />
                <input id="numberthreecontact" type="tel" name="numberthreecontact" size="12" value="<?php echo get_option('numberthreecontact'); ?>" />
            </p>

            <button type="submit">ثبت</button>
        </form>

    <?php
    endif; ?>
</div>

<?php get_footer();