<?php
/* Template Name: top30 */

if (check__user() == "poshtiban" || check__user() == 'administrator' || check__user() == 'shop_manager' || check__user() == 'shopist') { ?>

<!DOCTYPE html>
<html>
<head>
    <title></title>
    <meta name="robots" content="noindex"/>
    <link rel="stylesheet" type="text/css" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/assets/cando.css">
    <link rel="stylesheet" type="text/css" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/assets/bootstrap-rtl.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedheader/3.2.0/css/fixedHeader.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js" integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.2.0/js/dataTables.fixedHeader.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.2.0/js/dataTables.fixedHeader.min.js"></script>

    <style>
        thead input {
            width: 100%;
        }
        .but {
            margin: 10px 0;
            padding: 10px;
            border: 1px solid #ccc;
        }
        #example_length {
            display: none;
        }
        div#example_filter {
            display: none;
        }
        label, input {
            cursor: pointer;
        }
        tr, td{
            text-align: center;
        }
    </style>

    <script>
        $(document).ready(function () {

            $('#example thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#example thead');

            var table = $('#example').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Persian.json'
                },
                "pageLength": 9999,
                orderCellsTop: true,
                fixedHeader: true,
                initComplete: function () {
                    var api = this.api();

                    api
                        .columns()
                        .eq(0)
                        .each(function (colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');
                            console.log(title);
                            // On every keypress in this input
                            $('input',$('.filters th').eq($(api.column(colIdx).header()).index()))
                                .off('keyup change')
                                .on('keyup change', function (e) {
                                    e.stopPropagation();

                                    $(this).attr('title', $(this).val());
                                    var regexr = '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != ''
                                                ? regexr.replace('{search}', '(((' + this.value + ')))')
                                                : '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();

                                    $(this)
                                        .focus()[0]
                                        .setSelectionRange(cursorPosition, cursorPosition);
                                });
                        });
                },
            });
        });
    </script>

</head>
<body>

<div style="margin:10px">

    <?php
    $now = strtotime("now");

    $products_obj = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => 'SELECT * FROM `products_data`'])));

    foreach ( $products_obj as $product_obj) {

        $products[$product_obj->product_id]['title']        = $product_obj->title;
        $products[$product_obj->product_id]['notable']      = $product_obj->notable;
        $products[$product_obj->product_id]['special']      = $product_obj->special;
        $products[$product_obj->product_id]['city_name']    = $product_obj->city_name;
        $products[$product_obj->product_id]['hood']         = $product_obj->hood;
        $products[$product_obj->product_id]['tags_title']   = json_decode(json_encode(unserialize($product_obj->tags_title)), true);
        $products[$product_obj->product_id]['schedule']     = json_decode(json_encode(unserialize($product_obj->schedule)), true);
    }

    $bookings = json_decode(ez_reservation(array('type' => 'query_execution', 'data' => ['query' => 'SELECT `room_id`, `booking_time` FROM wp_zb_booking_history'])));
    $room_booked = [];
    foreach ( $bookings as $booking )
        if ( date('U') <= $booking->booking_time )
            $room_booked[$booking->room_id][] = $booking->booking_time; // سانس های پر شده

    if ( !isset($_POST["entekhab"]) || $_POST["entekhab"] == "emrooz" ) {

        $today      = $now + 0; // today
        $day_type   = get_day_type($today);

        foreach ( $products as $product_id => $data ) :

            $schedule_list = [];
            foreach ( $data['schedule'][$day_type] as $sans ) {
                $sans_unix = strtotime(date("Y-m-d", $today) . ' ' . $sans['time'] . ' Asia/Tehran');

                if ( $sans_unix > $today )
                    if ( !in_array($sans_unix, (array)$room_booked[$product_id]) )
                        $schedule_list[] = $sans_unix;
            }

            $products[$product_id]['schedule'] = $schedule_list;
        endforeach;
    }

    if ($_POST["entekhab"] == "farda") {

        $tomorrow = strtotime('tomorrow 00:00'); // tomorrow
        $day_type = get_day_type($tomorrow);

        foreach ( $products as $product_id => $data ) :

            $schedule_list = [];
            foreach ( $data['schedule'][$day_type] as $sans ) {
                $sans_unix = strtotime(date("Y-m-d", $tomorrow) . ' ' . $sans['time'] . ' Asia/Tehran');

                if ( $sans_unix > $tomorrow ) {
                    if (!in_array($sans_unix, (array)$room_booked[$product_id])) {
                        $schedule_list[] = $sans_unix;
                    }
                }
            }

            $products[$product_id]['schedule'] = $schedule_list;
        endforeach;
    }


    ?>

    <form method="post" name="form1" action="https://escapezoom.ir/top-30-day/">
        <div class="but">
            <input type="radio" id="emrooz" name="entekhab" value="emrooz" <?php if (!isset($_POST["entekhab"]) || $_POST['entekhab'] == 'emrooz'): ?> checked <?php endif ?> >
            <label for="emrooz">امروز</label>&nbsp&nbsp
            <input type="radio" id="farda" name="entekhab" value="farda" <?php if ($_POST['entekhab'] == 'farda'): ?> checked <?php endif ?>>
            <label for="farda">فردا</label>&nbsp&nbsp
            <input type="submit" value="اعمال" name="save" style="background: #fe812c;color: #fff;font-weight: bold;">
        </div>

        <table id="example" class="display" style="width:100%">
            <thead>
            <tr>
                <th>اسم اتاق</th>
                <th>تبلیغ</th>
                <th>شهر</th>
                <th>سانس ها</th>
                <th>برچسب</th>
                <th>ژانر</th>
                <th>لوکیشن</th>
            </tr>
            </thead>
            <tbody>
            <?php
            foreach ($products as $product_id => $data) { ?>

                <tr>
                    <td><a target='_blank' href="https://escapezoom.ir/<?php echo $product_id; ?>"><?php echo $data['title']; ?></a></td>
                    <td>
                        <?php
                        if ($data['notable'] == 1 | $data['special'] > 0)
                            echo "✔️";
                        else
                            echo "❌"; ?>
                    </td>
                    <td><?php echo $data['city_name']; ?></td>
                    <td>
                        <?php
                        if ( !empty( $data['schedule'] ) )
                            foreach ($data['schedule'] as $sans)
                                echo date('H:i', $sans) . '<br>';
                        else
                            echo '❌'; ?>
                    </td>
                    <td>
                        <?php
                        foreach ( $data['tags_title'] as $tag)
                            echo "#$tag "; ?>
                    </td>
                    <td>
                        <?php
                        foreach ( $data['tags_title'] as $tag)
                            echo "#$tag "; ?>
                    </td>
                    <td><?php echo $data['hood']; ?></td>
                </tr>

                <?php
            } ?>

            </tbody>
            <tfoot>
            <tr>
                <th>اسم اتاق</th>
                <th>تبلیغ</th>
                <th>شهر</th>
                <th>سانس ها</th>
                <th>برچسب</th>
                <th>ژانر</th>
                <th>لوکیشن</th>
            </tr>
            </tfoot>
        </table>
    </form>
</div>

<?php
} ?>

</body>
</html>