<?php

get_header();

global $wpdb;
$user_id        = get_user_id_by_token( ez_authorization( false ) );
$product_id     = get_the_ID();
$product_obj    = get_post( $product_id );
$brand_data     = get_the_terms( $product_id, 'yith_product_brand' )[0];

$brand_id = $brand_data->term_id ? : 0;

$params = [
    'brand_id'          => $brand_id,
    'exclude_products'  => [$product_id]
];
$args = [
    'params'        => $params,
    'image_type'    => 'url',
    'limit'         => 10,
    'page'          => 1,
    'max_num_pages' => false,
    "format"        => 'html_swiper',
    'sort_type'     => 'popular',
    'unpin_ads'     => false,
    'badge_ads'     => false,
    'random'        => true,
    'random_memory' => '',
    'show_more'     => 0,
];
$brand_products = json_decode( ez_webservice( [ 'type' => 'sort_products_get', 'data' => $args ] ) );

$terms = get_the_terms( $product_id, 'product_cat' );
if ( count( $terms ) > 1 ) {
    foreach ( $terms as $term ) {
        if ( $term->parent == 0 ) {
            $product_type           = $term->name;
            $product_parent_cat_url = get_term_link( $term->term_id, "product_cat" );
        } else {
            $city_name       = $term->name;
            $city_id         = $term->term_id;
            $product_cat_url = get_term_link( $term->term_id, "product_cat" );
        }
    }
} else {
    $product_type           = get_term( $terms[0]->parent )->name;
    $city_name              = $terms[0]->name;
    $city_id                = $terms[0]->term_id;
    $product_parent_cat_url = get_term_link( $terms[0]->parent, "product_cat" );
    $product_cat_url        = get_term_link( $terms[0]->term_id, "product_cat" );
}
foreach ( get_the_terms( $product_id, 'product_tag' ) as $product_tag ) {
    if ( str_contains( $product_tag->name, '|||||' ) ) {
        $genres[] = [
            'title' => str_replace( '|||||', '', $product_tag->name ),
            'id'    => $product_tag->term_id,
            'url'   => get_term_link( $product_tag->term_id ),
        ];
    } else {
        $tags[] = [
            'title' => $product_tag->name,
            'id'    => $product_tag->term_id,
            'url'   => get_term_link( $product_tag->term_id ),
        ];
    }
}
$product           = wc_get_product( $product_id );
$gallery           = $product->get_gallery_image_ids();
$product_rates     = get_post_meta( $product_id, 'clone_product_rates', true );
$comments_count    = get_post_meta( $product_id, 'clone_comments_count_new', true );
$comments_count_meta = get_comments(array(
    'post_id' => $product_id,
    'status' => 'approve',
    'parent'    => 0,
));
$comments_count_meta_number = count($comments_count_meta);
$decor             = (int) $comments_count !== 0 ? $product_rates[1094] / $comments_count / 20 : 0;
$moaama            = (int) $comments_count !== 0 ? $product_rates[1095] / $comments_count / 20 : 0;
$tazegi            = (int) $comments_count !== 0 ? $product_rates[1098] / $comments_count / 20 : 0;
$act               = (int) $comments_count !== 0 ? $product_rates[1096] / $comments_count / 20 : 0;
$barkhord          = (int) $comments_count !== 0 ? $product_rates[1097] / $comments_count / 20 : 0;
$comments_per_page = 10;
$total_pages       = ( $comments_count_meta_number > 0 ) ? ceil( $comments_count_meta_number / $comments_per_page ) : 1;
$args              = [
    'post_type' => 'product',
    'post_id'   => $product_id,
    'status'    => 'approve',
    'number'    => $comments_per_page,
    'parent'    => 0,
    'comment_approved' => 'approve',
];
$comments_query    = new WP_Comment_Query;
$comments          = $comments_query->query( $args );
if ( $comments ) {
    foreach ( $comments as $comment ) {
        $comment_id   = $comment->comment_ID;
        $replies_args = [
            'parent' => $comment_id,
            'status' => 'approve',
            'type'   => 'comment',
        ];
        
        $author_title = '';
        $user = get_user_by('id', $comment->user_id);
        
        if($user->user_firstname){
            $author_title = $user->user_firstname;
            if($user->user_lastname){
                $author_title .= ' ' . $user->user_lastname;
            }
        } elseif ( ctype_digit( $comment->comment_author ) ) {
            $author_title = str_replace( substr( $comment->comment_author, 3, 5 ), "×××××", $comment->comment_author );
        }

        foreach ( get_comment_meta( $comment_id, 'comment_rating', true ) as $key => $comment_rating ) {
            $comment_ratings[ $key ] = intval($comment_rating) / 20;
        }

        $comment_items[] = [
            'id'           => (int) $comment_id,
            'author_id'    => $comment->user_id,
            'author_title' => $author_title,
            'author_image' => get_user_meta( $comment->user_id, 'user_avatar', true ) ?: 'http://escapezoom.ir/wp-content/uploads/2024/04/male_avatar_level_1.png',
            'author_level' => 1,
            'content'      => $comment->comment_content,
            'date'         => strtotime( $comment->comment_date ),
            'reply'        => ( get_comments( $replies_args )[0] )->comment_content,
            'votes_count'  => ( (int) get_comment_meta( $comment_id, 'cld_like_count', true ) - (int) get_comment_meta( $comment_id, 'cld_dislike_count', true ) ),
            'rating_items' => $comment_ratings,
            'user_feeling' => get_comment_meta( $comment_id, "rating", true ),
        ];
    }
}
$number_min     = ! empty( $numbers[0] ) ? (int) min( $numbers[0] ) : 0;
$number_max     = ! empty( $numbers[0] ) ? (int) max( $numbers[0] ) : 0;
$options        = get_post_meta( $product_id, 'product_options', true );
$tickets_sold   = get_post_meta( $product_id, 'tickets_sold', true );

if ( $product_type == 'اتاق فرار' ) {
    $properties = [
        [
            'id'    => 'genre',
            'value' => $genres,
        ],
        [
            'id'    => 'capacity',
            'value' => $number_min . ' تا ' . $number_max . ' کاربر ',
        ],
        [
            'id'    => 'duration',
            'value' => (int) get_post_meta( $product_id, "room_duration", true ),
        ],
        [
            'id'    => 'age',
            'value' => (int) get_post_meta( $product_id, "room_age_limit", true ),
        ],
        [
            'id'    => 'tickets_sold',
            'value' => $tickets_sold,
        ],
        [
            'id'    => 'level',
            'value' => (int) get_post_meta( $product_id, "room_level", true ),
        ],
    ];
} elseif ( $product_type == 'سینما ترس' ) {
    $properties = [
        [
            'id'    => 'display_type',
            'value' => get_post_meta( $product_id, "display_type", true ),
        ],
        [
            'id'    => 'capacity',
            'value' => $number_min . ' تا ' . $number_max . ' کاربر ',
        ],
        [
            'id'    => 'duration',
            'value' => (int) get_post_meta( $product_id, "room_duration", true ),
        ],
        [
            'id'    => 'chair_type',
            'value' => get_post_meta( $product_id, "chair_type", true ),
        ],
        [
            'id'    => 'age',
            'value' => (int) get_post_meta( $product_id, "room_age_limit", true ),
        ],
        [
            'id'    => 'tickets_sold',
            'value' => $tickets_sold,
        ],
    ];
} elseif ( $product_type == 'لیزرتگ' ) {
    $properties = [
        [
            'id'    => 'capacity',
            'value' => $number_min . ' تا ' . $number_max . 'کاربر',
        ],
        [
            'id'    => 'duration',
            'value' => (int) get_post_meta( $product_id, "room_duration", true ),
        ],
        [
            'id'    => 'age',
            'value' => (int) get_post_meta( $product_id, "room_age_limit", true ),
        ],
        [
            'id'    => 'tickets_sold',
            'value' => $tickets_sold,
        ],
    ];
} elseif ( $product_type == 'اتاق خشم' ) {
    $properties = [
        [
            'id'    => 'capacity',
            'value' => $number_min . ' تا ' . $number_max . 'کاربر',
        ],
        [
            'id'    => 'duration',
            'value' => (int) get_post_meta( $product_id, "room_duration", true ),
        ],
        [
            'id'    => 'age',
            'value' => (int) get_post_meta( $product_id, "room_age_limit", true ),
        ],
        [
            'id'    => 'tickets_sold',
            'value' => $tickets_sold,
        ],
        [
            'id'    => 'safety',
            'value' => (int) get_post_meta( $product_id, "safety", true ),
        ],
    ];
}
preg_match_all( '/\d+/', get_field( "room_tedad", $product_id ), $numbers );
$data = [
    'product_id'         => $product_id,
    'type'               => get_product_type_equivalent( $product_type ),
    'title'              => $product->get_title(),
    'price'              => ! empty( get_post_meta( $product_id, 'min_price', true ) ) ? (int) get_post_meta( $product_id, 'min_price', true ) : (int) get_field( "price_asli", $product_id ),
    'ads'                => get_field( "special_room", $product_id ) ? true : false,
    'image'              => wp_get_attachment_url( get_post_thumbnail_id( $product_id ) ),
    'age'                => (int) get_post_meta( $product_id, "room_age_limit", true ),
    'tickets_sold'       => $tickets_sold,
    'level'              => (int) get_field( "room_level", $product_id ),
    'duration'           => (int) get_post_meta( $product_id, "room_duration", true ),
    'active'             => get_field( 'sale_active', $product_id ) ? true : false,
    'city_id'            => $city_id,
    'city_name'          => $city_name,
    'hood_name'          => get_field( "room_loc", $product_id ),
    'nearest_subway'     => 'میدان کتاب',
    'nearest_brt'        => 'شهید دادمان',
    'genres'             => $genres,
    'tags'               => $tags,
    'number_min'         => ! empty( $numbers[0] ) ? (int) min( $numbers[0] ) : 0,
    'number_max'         => ! empty( $numbers[0] ) ? (int) max( $numbers[0] ) : 0,
    'count_down'         => null,
    'brand'              => [
        'title' => $brand_data->name,
        'image' => wp_get_attachment_url( get_term_meta( $brand_id, 'thumbnail_id', true ) ),
        'url'   => get_term_link( $brand_id ),
    ],
    'properties'         => $properties,
    'options'            => $options,
    'introduction_text'  => get_post_meta( $product_id, 'product_introduction_text', true ),
    'scenario'           => get_post_meta( $product_id, 'product_scenario', true ),
    'rules'              => get_post_meta( $product_id, 'product_rules', true ),
    'trailer_video'      => get_field( 'room_video_embed', $product_id ),
    'introduction_video' => get_post_meta( $product_id, 'product_introduction_video', true ),
    'criticism'          => $product_obj->post_excerpt,
    'address_info'       => [
        'address' => get_field( 'room_address', $product_id ),
        'lat'     => get_field( 'room_lat', $product_id ),
        'long'    => get_field( 'room_long', $product_id ),
    ],
    'gallery'            => $gallery,
    'comments'           => [
        'rate'           => number_format( round( ( $decor + $moaama + $tazegi + $act + $barkhord ) / 5, 2 ), 3, '.', '' ),
        'comments_count' => $comments_count_meta_number,
        'rating_items'   => [
            1 => number_format( $decor, 2, '.', '' ),
            2 => number_format( $moaama, 2, '.', '' ),
            3 => number_format( $tazegi, 2, '.', '' ),
            4 => number_format( $act, 2, '.', '' ),
            5 => number_format( $barkhord, 2, '.', '' ),
        ],
        'items'          => $comment_items,
        'total_pages'    => $total_pages,
    ],
    'breadcrumb'         => [
        [
            'title' => 'صفحه اصلی',
            'url'   => '/',
        ],
        [
            'title' => $product_type,
            'url'   => $product_parent_cat_url,
        ],
        [
            'title' => $city_name,
            'url'   => $product_cat_url,
        ],
        [
            'title' => $product->get_title(),
            'url'   => '',
        ],
    ],
    'brand_products'     => $brand_products,
];

$data['comments']['rate'] = $product_type !== 'اتاق فرار' ? $data['comments']['rate'] * 5 : $data['comments']['rate'];

$increments = [5, 10, 20, 50, 100, 300, 500, 1000, 1500, 2000, 2500, 3000, 5000];
$nearest_increment = 0;
foreach ($increments as $increment)
    if ($data['tickets_sold'] >= $increment)
        $nearest_increment = $increment;
$tickets_sold = $nearest_increment . '+';

wp_enqueue_script( 'persian-date' );
wp_enqueue_style( 'lightbox-css' );
wp_enqueue_script( 'lightbox-js' ); 

?>
    <section>
        <div class="pt-8">
            <div class="mb-7 flex items-center justify-between lg:hidden">
                <!--breadcrumb-->
                <nav class="flex max-lg:mb-2" aria-label="Breadcrumb">
                    <ol class="inline-flex items-center">
                        <?php foreach ( $data['breadcrumb'] as $index => $item ): ?>
                            <li class="group">
                                <div class="flex items-center">
                                    <?= ( $index !== 0 && $index < count( $data['breadcrumb'] ) ) ? '<div class="mx-5 h-2 w-px bg-slate-110"></div>' : '' ?>
                                    <a class="text-2xs font-medium text-slate-310 hover:text-primary-600"
                                       href="<?= $item['url'] ?>"><?= $item['title'] ?></a>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ol>
                </nav>
            </div>
            <h1 class="lg:hidden text-2xl mb-4"><?= $product_type ?> <?= $data['title']; ?></h1>
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-12 pb-4">
                <div class="lg:col-span-1">
                    <div class="flex gap-3.5 lg:mb-4">
                        <div class="relative w-full">
                            <img alt="<?= $product_type ?> <?= $data['title']; ?>" loading="lazy" width="300" height="380" decoding="async" data-nimg="1" class="h-full w-full rounded-2xl object-cover lg:rounded-3xl lg:shadow-11" src="<?= $data['image'] ?>" style="color: transparent;">
                            <div class="absolute right-2 top-2 h-12 w-12 rounded-lg border border-yellow-300/20 bg-yellow-300/10 px-1 py-px text-center lg:hidden">
                                <div class="text-nowrap rounded-md bg-yellow-400 px-1 py-px text-sm" dir="ltr"><?= $data['comments']['rate'] ?></div>
                                <div class="mt-px text-center text-3xs font-medium leading-3 text-white">
                                    <span class="text-sm"><?= $data['comments']['comments_count'] ?> </span>
                                    رای
                                </div>
                            </div>
                            <button data-state="closed" class="share absolute border border-white flex p-2 rounded-xl" style="bottom: 12px; left: 12px" data-title="<?= $product_type . ' ' . $data['title']; ?>" data-content="<?= strip_tags( $data['introduction_text'] ) ?>" data-url="<?= get_the_permalink( $data['product_id'] ); ?>">
                            <span class="inline-flex items-center gap-4 text-sm font-bold text-white ">
                                <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M11.1202 15.0232L6.92121 12.7332C6.373 13.3193 5.66119 13.7269 4.87828 13.9031C4.09537 14.0793 3.27756 14.0159 2.53113 13.7212C1.7847 13.4266 1.14417 12.9142 0.692774 12.2506C0.241381 11.5871 0 10.8032 0 10.0007C0 9.19821 0.241381 8.41427 0.692774 7.75076C1.14417 7.08725 1.7847 6.57486 2.53113 6.28017C3.27756 5.98548 4.09537 5.92211 4.87828 6.09832C5.66119 6.27452 6.373 6.68214 6.92121 7.2682L11.1212 4.97821C10.8831 4.03417 10.9975 3.0357 11.4429 2.16997C11.8884 1.30424 12.6342 0.630692 13.5408 0.275574C14.4473 -0.0795433 15.4522 -0.0918428 16.3671 0.240981C17.2821 0.573805 18.0442 1.2289 18.5107 2.08347C18.9772 2.93804 19.116 3.9334 18.9011 4.88299C18.6862 5.83257 18.1323 6.67116 17.3433 7.24158C16.5543 7.81199 15.5843 8.07506 14.6152 7.98147C13.6462 7.88789 12.7445 7.44406 12.0792 6.7332L7.87921 9.0232C8.04074 9.66452 8.04074 10.3359 7.87921 10.9772L12.0792 13.2672C12.7448 12.5567 13.6467 12.1133 14.6158 12.0202C15.5849 11.9271 16.5547 12.1906 17.3434 12.7614C18.1322 13.3322 18.6856 14.171 18.9001 15.1207C19.1146 16.0703 18.9754 17.0656 18.5085 17.9199C18.0417 18.7743 17.2793 19.429 16.3642 19.7615C15.4491 20.0939 14.4442 20.0812 13.5379 19.7257C12.6315 19.3702 11.8859 18.6964 11.4408 17.8305C10.9958 16.9646 10.8818 15.9661 11.1202 15.0222M4.00021 12.0002C4.53064 12.0002 5.03935 11.7895 5.41442 11.4144C5.78949 11.0393 6.00021 10.5306 6.00021 10.0002C6.00021 9.46977 5.78949 8.96106 5.41442 8.58599C5.03935 8.21092 4.53064 8.00021 4.00021 8.00021C3.46977 8.00021 2.96107 8.21092 2.58599 8.58599C2.21092 8.96106 2.00021 9.46977 2.00021 10.0002C2.00021 10.5306 2.21092 11.0393 2.58599 11.4144C2.96107 11.7895 3.46977 12.0002 4.00021 12.0002ZM15.0002 6.00021C15.5306 6.00021 16.0393 5.78949 16.4144 5.41442C16.7895 5.03935 17.0002 4.53064 17.0002 4.00021C17.0002 3.46977 16.7895 2.96107 16.4144 2.58599C16.0393 2.21092 15.5306 2.00021 15.0002 2.00021C14.4698 2.00021 13.9611 2.21092 13.586 2.58599C13.2109 2.96107 13.0002 3.46977 13.0002 4.00021C13.0002 4.53064 13.2109 5.03935 13.586 5.41442C13.9611 5.78949 14.4698 6.00021 15.0002 6.00021ZM15.0002 18.0002C15.5306 18.0002 16.0393 17.7895 16.4144 17.4144C16.7895 17.0393 17.0002 16.5306 17.0002 16.0002C17.0002 15.4698 16.7895 14.9611 16.4144 14.586C16.0393 14.2109 15.5306 14.0002 15.0002 14.0002C14.4698 14.0002 13.9611 14.2109 13.586 14.586C13.2109 14.9611 13.0002 15.4698 13.0002 16.0002C13.0002 16.5306 13.2109 17.0393 13.586 17.4144C13.9611 17.7895 14.4698 18.0002 15.0002 18.0002Z" fill="#FFFFFF" fill-opacity="0.8"></path>
                                </svg>
                            </span>
                            </button>
                        </div>
                        <div class="w-61 flex flex-col lg:hidden">
                            <div class="flex flex-col justify-center rounded-lg border border-slate-110 px-2.5 py-5 text-center shadow-13">
                                <div class="mb-5 flex w-full items-center justify-center gap-x-2 border-b border-slate-110 pb-5 flex-col">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="m-0 shrink-0 text-primary-500 w-5">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M17.294 7.291A5.274 5.274 0 0 1 12 12.583a5.275 5.275 0 0 1-5.294-5.292A5.274 5.274 0 0 1 12 2a5.273 5.273 0 0 1 5.294 5.291ZM12 22c-4.338 0-8-.705-8-3.425 0-2.721 3.685-3.401 8-3.401 4.339 0 8 .705 8 3.425C20 21.32 16.315 22 12 22Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="text-nowrap text-2xs"><?= $data['number_min'] ?>
                                    تا <?= $data['number_max'] ?>
                                    <span class="max-lg:hidden">نفر</span>
                                </span>
                                </div>
                                <div class="mb-5 flex w-full items-center justify-center gap-x-2 border-b border-slate-110 pb-5 flex-col">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="m-0 shrink-0 text-primary-500 max-lg:mt-1.5 w-5">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M12 22C6.48 22 2 17.53 2 12 2 6.48 6.48 2 12 2c5.53 0 10 4.48 10 10 0 5.53-4.47 10-10 10Zm3.19-6.29a.742.742 0 0 0 1.03-.26c.21-.35.1-.81-.26-1.03L12.4 12.3V7.68a.749.749 0 1 0-1.5 0v5.05c0 .26.14.5.37.64l3.92 2.34Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="mt-2 text-nowrap text-2xs">
                                    <span dir="ltr"><?= $data['duration'] ?></span>
                                    دقیقه
                                </span>
                                </div>
                                <div class="mb-5 flex w-full items-center justify-center gap-x-2 border-b border-slate-110 pb-5 flex-col">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="m-0 shrink-0 text-primary-500 max-lg:mt-1.5 w-5">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M21.787 10.539a.735.735 0 0 1-.512.207c-.716 0-1.296.563-1.296 1.25 0 .69.573 1.25 1.282 1.258.4.004.739.275.739.663v2.41C22 18.354 20.308 20 18.219 20h-3.153a.582.582 0 0 1-.59-.573v-2.03a.708.708 0 0 0-.726-.704.714.714 0 0 0-.725.704v2.03a.581.581 0 0 1-.589.573H5.781C3.702 20 2 18.356 2 16.326v-2.41c0-.387.34-.658.739-.662.71-.007 1.282-.568 1.282-1.259 0-.667-.56-1.174-1.296-1.174a.736.736 0 0 1-.512-.207.694.694 0 0 1-.213-.498V7.683C2 5.657 3.706 4 5.791 4h6.645c.325 0 .59.256.59.573v2.405a.72.72 0 0 0 .725.705c.406 0 .725-.32.725-.705V4.573c0-.317.264-.573.59-.573h3.153C20.307 4 22 5.644 22 7.674v2.367a.694.694 0 0 1-.213.498Zm-8.036 4.331c.406 0 .725-.32.725-.704v-3.758a.714.714 0 0 0-.726-.705.72.72 0 0 0-.725.705v3.758a.72.72 0 0 0 .726.704Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="mt-2 text-nowrap text-2xs">
                                    <span><?= $tickets_sold; ?> نفر</span>
<!--                                    <span class="text-4xs">در حال محاسبه</span>-->
                                </span>
                                </div>
                                <div class="flex w-full items-center justify-center gap-x-2 flex-col">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="m-0 shrink-0 text-primary-500 max-lg:mt-1.5 w-5">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M9.803 15.253a3.924 3.924 0 0 0 2.196.679c2.146 0 3.893-1.762 3.893-3.928 0-.817-.254-1.585-.673-2.215l-1.064 1.073c.176.334.273.728.273 1.142 0 1.348-1.093 2.451-2.43 2.451-.41 0-.8-.098-1.131-.275l-1.064 1.073ZM18.43 6.55c1.415 1.3 2.615 3.051 3.513 5.158a.75.75 0 0 1 0 .581c-2.089 4.903-5.806 7.837-9.943 7.837h-.01c-1.883 0-3.688-.62-5.279-1.753l-1.893 1.91a.72.72 0 0 1-.517.217.705.705 0 0 1-.517-.217.736.736 0 0 1-.088-.925l.03-.04 14.43-14.56c.02-.02.04-.04.05-.06.019-.02.038-.039.048-.058l.917-.926a.731.731 0 0 1 1.035 0 .73.73 0 0 1 0 1.044L18.429 6.55ZM8.1 12.008c0 .256.029.512.068.748l-3.61 3.642c-.976-1.142-1.825-2.52-2.498-4.105a.75.75 0 0 1 0-.58c2.088-4.904 5.805-7.828 9.933-7.828h.01c1.395 0 2.75.335 4 .965l-3.26 3.288a4.515 4.515 0 0 0-.74-.069c-2.157 0-3.904 1.763-3.904 3.938Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="mt-2 text-nowrap text-2xs">
                                    <span dir="ltr">+<?= $data['age'] ?></span>
                                    سال
                                </span>
                                </div>
                            </div>
                            <div class="mt-auto flex flex-col justify-center rounded-lg border border-slate-110 px-2.5 py-4 text-center shadow-13">
                                <div class="flex w-full items-center justify-center gap-x-2 lg:flex-col">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="m-0 w-3 shrink-0 text-primary-500 max-lg:mt-1.5 lg:w-5">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M17.523 7.396v1.533c1.722.538 2.977 2.097 2.977 3.96v4.936c0 2.306-1.911 4.175-4.268 4.175H7.77c-2.36 0-4.27-1.87-4.27-4.175v-4.937c0-1.862 1.256-3.421 2.977-3.959V7.396C6.487 4.415 8.957 2 11.985 2c3.069 0 5.538 2.415 5.538 5.396Zm-5.518-3.657c2.063 0 3.74 1.64 3.74 3.657v1.318h-7.49V7.376c.01-2.007 1.687-3.637 3.75-3.637Zm.884 12.716a.88.88 0 0 1-.894.874.877.877 0 0 1-.884-.874v-2.206c0-.477.396-.865.884-.865.498 0 .894.388.894.865v2.206Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="mt-2 text-nowrap text-2xs">
                                    <span dir="ltr"><?= 5 - intval($data['level']) ?></span>
                                    از 4
                                </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="my-5.5 flex items-center gap-6 text-[#889BAD] lg:hidden">
                        <div class="flex items-center text-nowrap text-2xs">
                            <?= $data['city_name'] . ' ، ' . $data['hood_name'] ?>
                            <?php if ( $data['genres'] ) { ?>
                                <div class="mx-2 h-2 w-px bg-slate-110"></div>
                                <?php foreach ( $data['genres'] as $index => $genre ) { ?>
                                    <?php if ( $index !== 0 ) { ?>
                                        ،
                                    <?php } ?>
                                    <a href="<?php echo get_term_link( $genre['id'] ); ?>" class="mx-2">
                                        <?php echo $genre['title']; ?>
                                    </a>
                                <?php }
                            } ?>
                        </div>
                    </div>
                    <div class="sticky top-4">
                        <?php if ( $data['active'] ) { ?>
                            <div class="mb-6 flex items-center justify-between">
                                <h2 class="text-2xl lg:text-h2">رزرو
                                    <span class="mx-3 text-sm"><?= $data['title'] ?></span>
                                </h2>
                                <a href="<?php echo site_url('/r/' . $data['product_id'] );?>" class="flex cursor-pointer items-center text-2xs underline decoration-slate-110 underline-offset-4">
                                    مشاهده تقویم
                                    <span class="-mt-1 mr-2.5 text-blue">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="18" viewBox="0 0 24 24">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="m16.41 2.769.002.75c2.755.215 4.574 2.092 4.577 4.97L21 16.917c.004 3.138-1.968 5.069-5.128 5.074l-7.72.01c-3.14.004-5.137-1.973-5.141-5.12L3 8.553c-.004-2.898 1.752-4.77 4.506-5.023v-.75a.746.746 0 0 1 .758-.77.747.747 0 0 1 .762.769v.7l5.865-.009v-.7A.747.747 0 0 1 15.65 2a.753.753 0 0 1 .76.769ZM4.522 8.862l14.949-.02v-.35c-.043-2.15-1.121-3.277-3.056-3.445v.77c0 .43-.334.77-.758.77a.752.752 0 0 1-.762-.768v-.81l-5.865.008v.81c0 .43-.324.77-.759.77a.752.752 0 0 1-.76-.769l-.002-.77c-1.925.193-2.99 1.325-2.988 3.493l.001.31Zm10.719 4.542v.011c.01.46.385.809.84.799a.823.823 0 0 0 .789-.852.83.83 0 0 0-.82-.797.828.828 0 0 0-.81.84Zm.815 4.488a.848.848 0 0 1-.821-.848.833.833 0 0 1 .809-.852h.01c.463 0 .84.379.84.849a.844.844 0 0 1-.838.851Zm-4.883-4.472c.02.46.396.819.85.799a.823.823 0 0 0 .78-.86.816.816 0 0 0-.821-.8.854.854 0 0 0-.809.861Zm.854 4.427a.823.823 0 0 1-.85-.799c0-.46.354-.84.809-.86a.815.815 0 0 1 .82.797.824.824 0 0 1-.779.862Zm-4.922-4.392c.02.46.396.82.85.799.445-.02.8-.4.778-.86a.815.815 0 0 0-.82-.8.852.852 0 0 0-.808.861Zm.854 4.397a.822.822 0 0 1-.85-.799.853.853 0 0 1 .809-.86.815.815 0 0 1 .82.798.82.82 0 0 1-.779.861Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                                </a>
                            </div>
                            
                            <?php // echo do_shortcode('[esi single-product-days cache="no" ttl="0"]'); ?>
                            
                            <div class="relative w-full" dir="rtl">
                                <div class="h-full w-full overflow-hidden px-0">
                                    <div class="flex h-full touch-pan-y -ml-1" style="transform: translate3d(0px, 0px, 0px);">
                                        <div class="relative min-w-0 shrink-0 grow-0 basis-13 pl-1">
                                            <button type="button" class="yesterday border-gray-120 flex h-15 w-full cursor-pointer flex-col items-center justify-center rounded-[10px] border text-lg leading-none shadow-13 transition-all duration-300">
                                                <span class="mt-0.2 text-3xs">روز قبل</span>
                                            </button>
                                        </div>
                                        <?php $current_date = strtotime( date( 'Y-m-d 00:00:00' ) );
                                        $dates              = [];
                                        for ( $i = 1; $i <= 15; $i ++ ) {
                                            $dates[] = $current_date + ( 60 * 60 * 24 * $i );
                                        } ?>
                                        <div class="swiper select-day">
                                            <div class="swiper-wrapper pb-1">
                                                <div class="swiper-slide">
                                                    <div class="relative min-w-0 shrink-0 grow-0 basis-13 pl-1">
                                                        <button type="button" data-reserve-timestamp="<?php echo esc_attr( $current_date ); ?>" class="active border-blue bg-blue text-white flex h-15 w-full cursor-pointer flex-col items-center justify-center rounded-[10px] border text-lg leading-none shadow-13 transition-all duration-300">
                                                            امروز
                                                        </button>
                                                    </div>
                                                </div>
                                                <?php foreach ( $dates as $date ) { ?>
                                                    <div class="swiper-slide">
                                                        <div class="relative min-w-0 shrink-0 grow-0 basis-13 pl-1">
                                                            <button type="button" data-reserve-timestamp="<?php echo esc_attr( $date ); ?>" class="border-gray-120 flex h-15 w-full cursor-pointer flex-col items-center justify-center rounded-[10px] border text-lg leading-none shadow-13 transition-all duration-300">
                                                                <?php echo esc_html( jdate( 'd', $date ) ) ?>
                                                                <div class="mt-0.2 text-3xs"><?php echo esc_html( jdate( 'l', $date ) ) ?></div>
                                                            </button>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="relative min-w-0 shrink-0 grow-0 basis-13 pl-1">
                                            <button type="button" class="tomorrow border-gray-120 flex h-15 w-full cursor-pointer flex-col items-center justify-center rounded-[10px] border text-lg leading-none shadow-13 transition-all duration-300">
                                                <span class="mt-0.2 text-3xs">روز بعد</span>
                                            </button>
                                        </div>
                            
                                    </div>
                            
                                </div>
                            </div>
                            
                            <div class="mb-4 mt-9 flex items-center">
                                <div class="text-xs text-blue">سانس های قابل رزرو</div>
                                <span class="mx-3.5 text-3xs text-slate-310">یک سانس را انتخاب نمایید</span>
                            </div>
                            <div>
                                <div id="product-sans-list" data-min="<?php echo $data['number_min'] ?>" data-max="<?php echo $data['number_max']; ?>"></div>
                                <div id="review-order" class="hidden w-full rounded-2xl border border-slate-120 px-8 py-4 shadow-12 flex flex-col gap-2 mb-6 mt-4"></div>
                                <a id="go-to-checkout" href="#" class="hidden bg-accent-550 flex rounded-2xl items-center justify-center text-white p-3 gap-3">
                                    پرداخت و ثبت رزرو
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14" viewBox="0 0 16 14" fill="none" class="mx-0">
                                        <path d="M0.509545 6.0725C0.252053 6.31859 0.107422 6.65219 0.107422 7C0.107422 7.34782 0.252053 7.68141 0.509545 7.9275L5.69421 12.8791C5.95216 13.1253 6.30201 13.2637 6.6668 13.2637C7.03158 13.2637 7.38143 13.1253 7.63938 12.8791C7.89732 12.6329 8.04224 12.299 8.04224 11.9508C8.04224 11.6025 7.89732 11.2686 7.63938 11.0224L4.80138 8.3125L13.9085 8.3125C14.2731 8.3125 14.6229 8.17422 14.8807 7.92808C15.1386 7.68194 15.2835 7.3481 15.2835 7C15.2835 6.6519 15.1386 6.31807 14.8807 6.07192C14.6229 5.82578 14.2731 5.6875 13.9085 5.6875L4.80138 5.6875L7.63938 2.9785C7.7671 2.85658 7.86841 2.71185 7.93754 2.55256C8.00666 2.39327 8.04224 2.22254 8.04224 2.05013C8.04224 1.87771 8.00666 1.70698 7.93754 1.54769C7.86841 1.3884 7.7671 1.24367 7.63938 1.12175C7.51166 0.999835 7.36003 0.903128 7.19315 0.837148C7.02628 0.771167 6.84742 0.737207 6.6668 0.737207C6.48617 0.737207 6.30731 0.771167 6.14044 0.837148C5.97356 0.903128 5.82193 0.999835 5.69421 1.12175L0.509545 6.0725Z" fill="white"/>
                                    </svg>
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="bg-[#EDF2F5] border py-15 px-[80px] rounded-xl shadow-12 flex flex-col justify-center items-center gap-2 text-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28" fill="none">
                                    <rect width="28" height="28" rx="14" fill="white"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M13.9997 2.3335C20.4432 2.3335 25.6663 7.55666 25.6663 14.0002C25.6663 20.4437 20.4432 25.6668 13.9997 25.6668C7.55618 25.6668 2.33301 20.4437 2.33301 14.0002C2.33301 7.55666 7.55618 2.3335 13.9997 2.3335ZM13.9997 4.66683C11.5243 4.66683 9.15035 5.65016 7.40001 7.4005C5.64967 9.15084 4.66634 11.5248 4.66634 14.0002C4.66634 16.4755 5.64967 18.8495 7.40001 20.5998C9.15035 22.3502 11.5243 23.3335 13.9997 23.3335C16.475 23.3335 18.849 22.3502 20.5993 20.5998C22.3497 18.8495 23.333 16.4755 23.333 14.0002C23.333 11.5248 22.3497 9.15084 20.5993 7.4005C18.849 5.65016 16.475 4.66683 13.9997 4.66683ZM9.91634 9.3335C10.3805 9.3335 10.8256 9.51787 11.1538 9.84606C11.482 10.1742 11.6663 10.6194 11.6663 11.0835C11.6663 11.5476 11.482 11.9927 11.1538 12.3209C10.8256 12.6491 10.3805 12.8335 9.91634 12.8335C9.45221 12.8335 9.00709 12.6491 8.6789 12.3209C8.35072 11.9927 8.16634 11.5476 8.16634 11.0835C8.16634 10.6194 8.35072 10.1742 8.6789 9.84606C9.00709 9.51787 9.45221 9.3335 9.91634 9.3335ZM18.083 9.3335C18.5471 9.3335 18.9923 9.51787 19.3204 9.84606C19.6486 10.1742 19.833 10.6194 19.833 11.0835C19.833 11.5476 19.6486 11.9927 19.3204 12.3209C18.9923 12.6491 18.5471 12.8335 18.083 12.8335C17.6189 12.8335 17.1738 12.6491 16.8456 12.3209C16.5174 11.9927 16.333 11.5476 16.333 11.0835C16.333 10.6194 16.5174 10.1742 16.8456 9.84606C17.1738 9.51787 17.6189 9.3335 18.083 9.3335Z" fill="#889BAD"/>
                                    <path d="M17.8605 16.6253C16.8327 15.7188 15.4793 15.167 14.0012 15.167C12.5804 15.167 11.2086 15.6856 10.143 16.6253C10.0281 16.7267 9.93429 16.8497 9.86691 16.9873C9.79953 17.1249 9.75992 17.2744 9.75033 17.4273C9.74075 17.5802 9.76137 17.7335 9.81103 17.8785C9.86069 18.0234 9.93841 18.1572 10.0398 18.2721C10.1411 18.387 10.2641 18.4808 10.4017 18.5482C10.5393 18.6156 10.6888 18.6552 10.8418 18.6648C10.9947 18.6743 11.148 18.6537 11.2929 18.6041C11.4379 18.5544 11.5716 18.4767 11.6865 18.3753C12.3037 17.8293 13.1133 17.5003 14.0012 17.5003C14.8535 17.5004 15.6766 17.8115 16.3158 18.3753C16.5479 18.5802 16.8518 18.6844 17.1608 18.6652C17.4697 18.6459 17.7583 18.5047 17.9632 18.2727C18.168 18.0406 18.2723 17.7367 18.253 17.4277C18.2338 17.1188 18.0926 16.8302 17.8605 16.6253Z" fill="#889BAD"/>
                                </svg>
                                <span class="text-lg" style="color: #889BAD">
                                این بازی غیر فعال شده
                                <br>
                                و قابل رزرو نمی باشد.
                            </span>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="lg:col-span-3 flex flex-col relative">

                    <div class="mb-13 mt-0.5 flex items-center justify-between max-lg:hidden">
                        <!--breadcrumb-->
                        <nav class="flex" aria-label="Breadcrumb">
                            <ol class="inline-flex items-center">
                                <?php foreach ( $data['breadcrumb'] as $index => $item ): ?>
                                    <li class="group">
                                        <div class="flex items-center">
                                            <?= ( $index !== 0 && $index < count( $data['breadcrumb'] ) ) ? '<div class="mx-5 h-2 w-px bg-slate-110"></div>' : '' ?>
                                            <a class="text-2xs font-medium text-slate-310 hover:text-primary-600"
                                               href="<?= $item['url'] ?>"><?= $item['title'] ?></a>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ol>
                        </nav>
                        <button data-state="closed" class="share" data-title="<?= $product_type . ' ' . $data['title']; ?>" data-content="<?= strip_tags( $data['introduction_text'] ) ?>" data-url="<?= get_the_permalink( $data['product_id'] ); ?>">
                        <span class="inline-flex items-center gap-4 text-sm font-bold text-[#09192d]">اشتراک با
                            دوستان
                            <svg
                                width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.1202 15.0232L6.92121 12.7332C6.373 13.3193 5.66119 13.7269 4.87828 13.9031C4.09537 14.0793 3.27756 14.0159 2.53113 13.7212C1.7847 13.4266 1.14417 12.9142 0.692774 12.2506C0.241381 11.5871 0 10.8032 0 10.0007C0 9.19821 0.241381 8.41427 0.692774 7.75076C1.14417 7.08725 1.7847 6.57486 2.53113 6.28017C3.27756 5.98548 4.09537 5.92211 4.87828 6.09832C5.66119 6.27452 6.373 6.68214 6.92121 7.2682L11.1212 4.97821C10.8831 4.03417 10.9975 3.0357 11.4429 2.16997C11.8884 1.30424 12.6342 0.630692 13.5408 0.275574C14.4473 -0.0795433 15.4522 -0.0918428 16.3671 0.240981C17.2821 0.573805 18.0442 1.2289 18.5107 2.08347C18.9772 2.93804 19.116 3.9334 18.9011 4.88299C18.6862 5.83257 18.1323 6.67116 17.3433 7.24158C16.5543 7.81199 15.5843 8.07506 14.6152 7.98147C13.6462 7.88789 12.7445 7.44406 12.0792 6.7332L7.87921 9.0232C8.04074 9.66452 8.04074 10.3359 7.87921 10.9772L12.0792 13.2672C12.7448 12.5567 13.6467 12.1133 14.6158 12.0202C15.5849 11.9271 16.5547 12.1906 17.3434 12.7614C18.1322 13.3322 18.6856 14.171 18.9001 15.1207C19.1146 16.0703 18.9754 17.0656 18.5085 17.9199C18.0417 18.7743 17.2793 19.429 16.3642 19.7615C15.4491 20.0939 14.4442 20.0812 13.5379 19.7257C12.6315 19.3702 11.8859 18.6964 11.4408 17.8305C10.9958 16.9646 10.8818 15.9661 11.1202 15.0222M4.00021 12.0002C4.53064 12.0002 5.03935 11.7895 5.41442 11.4144C5.78949 11.0393 6.00021 10.5306 6.00021 10.0002C6.00021 9.46977 5.78949 8.96106 5.41442 8.58599C5.03935 8.21092 4.53064 8.00021 4.00021 8.00021C3.46977 8.00021 2.96107 8.21092 2.58599 8.58599C2.21092 8.96106 2.00021 9.46977 2.00021 10.0002C2.00021 10.5306 2.21092 11.0393 2.58599 11.4144C2.96107 11.7895 3.46977 12.0002 4.00021 12.0002ZM15.0002 6.00021C15.5306 6.00021 16.0393 5.78949 16.4144 5.41442C16.7895 5.03935 17.0002 4.53064 17.0002 4.00021C17.0002 3.46977 16.7895 2.96107 16.4144 2.58599C16.0393 2.21092 15.5306 2.00021 15.0002 2.00021C14.4698 2.00021 13.9611 2.21092 13.586 2.58599C13.2109 2.96107 13.0002 3.46977 13.0002 4.00021C13.0002 4.53064 13.2109 5.03935 13.586 5.41442C13.9611 5.78949 14.4698 6.00021 15.0002 6.00021ZM15.0002 18.0002C15.5306 18.0002 16.0393 17.7895 16.4144 17.4144C16.7895 17.0393 17.0002 16.5306 17.0002 16.0002C17.0002 15.4698 16.7895 14.9611 16.4144 14.586C16.0393 14.2109 15.5306 14.0002 15.0002 14.0002C14.4698 14.0002 13.9611 14.2109 13.586 14.586C13.2109 14.9611 13.0002 15.4698 13.0002 16.0002C13.0002 16.5306 13.2109 17.0393 13.586 17.4144C13.9611 17.7895 14.4698 18.0002 15.0002 18.0002Z"
                                      fill="#09192D" fill-opacity="0.8"></path>
                            </svg>
                        </span>
                        </button>
                    </div>

                    <div class="mb-15 flex items-center justify-between max-lg:hidden">
                        <div class="flex items-center gap-9">
                            <div class="inline-block overflow-hidden rounded-2xl shadow-2">
                                <?php if ( $data['brand']['image'] ): ?>
                                    <img alt="<?= $data['brand']['title'] ?>" loading="lazy" width="68" height="68" decoding="async"
                                         data-nimg="1" src="<?= $data['brand']['image'] ?>"
                                         style="color: transparent; width: 68px; height: 68px;">
                                <?php else: ?>
                                    <img alt="<?= $data['brand']['title'] ?>" loading="lazy" width="68" height="68" decoding="async"
                                         data-nimg="1" src="<?php bloginfo('template_url');?>/assets/images/brand-default-icon.svg"
                                         style="color: transparent; width: 68px; height: 68px;">
                                <?php endif; ?>
                            </div>
                            <div class="">
                                <ol class="inline-flex items-center">

                                    <?php if ( $data['brand']['title'] !== null ): ?>
                                        <li class="inline-flex items-center">
                                            <a class="inline-flex items-center text-2xs font-medium hover:text-primary-600"
                                               href="<?= $data['brand']['url'] ?>"><?= $data['brand']['title'] ?></a>
                                        </li>
                                    <?php endif; ?>

                                    <li aria-current="page">
                                        <div class="flex items-center">
                                            <div class="ms-4 text-slate-130">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="6"
                                                     viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"
                                                     stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M15.5 19l-7-7 7-7" vector-effect="non-scaling-stroke"></path>
                                                </svg>
                                            </div>
                                            <span class="ms-4 text-2xs font-medium"><?= $data['title'] ?></span>
                                        </div>
                                    </li>
                                </ol>
                                <div class="mt-3 text-2xl"><?= $product_type ?> <?= $data['title'] ?></div>
                            </div>
                        </div>
                        <div>
                            <div class="text-lg" dir="ltr">
                                <span class="rounded-lg bg-yellow-400 px-1 py-px text-xl"><?= $data['comments']['rate'] ?></span>
                            </div>
                            <h3 class="mt-3.5 text-left text-2xs font-medium text-slate-350">میانگین
                                امتیاز <?= $product_type; ?>
                                <?= $data['title'] ?>
                                <span class="mr-2 text-base"> <?= $data['comments']['comments_count'] ?> </span>
                                رای
                            </h3>
                        </div>
                    </div>

                    <div class="rounded-2xl bg-gray-50 p-3 max-md:-mx-4 max-md:rounded-none max-md:px-4">
                        <div class="flex flex-nowrap items-center gap-2.5 max-lg:hidden">
                            <div class="w-full items-center justify-around rounded-lg bg-white shadow-13 max-lg:px-6 max-lg:py-8 lg:flex">
                                <?php if ( $data['genres'] ) { ?>
                                    <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8 lg:last-of-type:hidden">
                                        <div class="items-center gap-3 max-lg:flex">
                                            <div class="text-primary-500">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                     viewBox="0 0 20 20">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                          d="M15.01 12.601a.75.75 0 00.75-.75V10a.75.75 0 00-.75-.75H9.32A2.596 2.596 0 006.84 7.4a2.604 2.604 0 00-2.601 2.6 2.604 2.604 0 002.6 2.602A2.596 2.596 0 009.32 10.75h2.112v1.102a.75.75 0 001.5 0V10.75h1.33v1.102c0 .414.336.75.75.75zM5.667 0h8.669C17.723 0 20 2.377 20 5.916v8.167C20 17.623 17.723 20 14.334 20H5.666C2.276 20 0 17.622 0 14.083V5.916C0 2.377 2.277 0 5.666 0zM5.739 10c0-.608.495-1.102 1.102-1.102.607 0 1.102.494 1.102 1.102a1.103 1.103 0 01-2.204 0z"
                                                          fill="currentColor"></path>
                                                </svg>
                                            </div>
                                            <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">ژانـــر</div>
                                        </div>
                                        <div class="mt-2 inline-flex w-full items-center justify-center text-base max-lg:justify-end max-lg:text-sm">
                                            <?php foreach ( array_slice( $data['genres'], 0, 2 ) as $index => $genre ) { ?>
                                                <?php echo ( $index !== 0 ) ? '<span class="mx-2">|</span>' : '' ?>
                                                <a href="<?php echo $genre['url']; ?>" class="text-nowrap">
                                                    <?php echo $genre['title']; ?>
                                                </a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="h-20 min-h-full w-px max-w-full bg-slate-120 max-lg:hidden"></div>
                                <?php } ?>

                                <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8 lg:last-of-type:hidden">
                                    <div class="items-center gap-3 max-lg:flex">
                                        <div class="text-primary-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                 viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                      d="M21.787 10.539a.735.735 0 0 1-.512.207c-.716 0-1.296.563-1.296 1.25 0 .69.573 1.25 1.282 1.258.4.004.739.275.739.663v2.41C22 18.354 20.308 20 18.219 20h-3.153a.582.582 0 0 1-.59-.573v-2.03a.708.708 0 0 0-.726-.704.714.714 0 0 0-.725.704v2.03a.581.581 0 0 1-.589.573H5.781C3.702 20 2 18.356 2 16.326v-2.41c0-.387.34-.658.739-.662.71-.007 1.282-.568 1.282-1.259 0-.667-.56-1.174-1.296-1.174a.736.736 0 0 1-.512-.207.694.694 0 0 1-.213-.498V7.683C2 5.657 3.706 4 5.791 4h6.645c.325 0 .59.256.59.573v2.405a.72.72 0 0 0 .725.705c.406 0 .725-.32.725-.705V4.573c0-.317.264-.573.59-.573h3.153C20.307 4 22 5.644 22 7.674v2.367a.694.694 0 0 1-.213.498Zm-8.036 4.331c.406 0 .725-.32.725-.704v-3.758a.714.714 0 0 0-.726-.705.72.72 0 0 0-.725.705v3.758a.72.72 0 0 0 .726.704Z"
                                                      clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">
                                            فروش کل
                                        </div>
                                    </div>
                                    <div class="mt-2 inline-flex w-full items-center justify-center overflow-hidden text-ellipsis whitespace-nowrap text-base max-lg:justify-end max-lg:text-sm">
                                    <span class="ml-1"><?= $tickets_sold ?> نفر
<!--                                        در حال محاسبه-->
                                    </span>
                                        <!--کاربر-->
                                    </div>
                                </div>
                                
                                <div class="h-20 min-h-full w-px max-w-full bg-slate-120 max-lg:hidden"></div>
                                <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8 lg:last-of-type:hidden">
                                    <div class="items-center gap-3 max-lg:flex">
                                        <div class="text-primary-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                 viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                      d="M17.294 7.291A5.274 5.274 0 0 1 12 12.583a5.275 5.275 0 0 1-5.294-5.292A5.274 5.274 0 0 1 12 2a5.273 5.273 0 0 1 5.294 5.291ZM12 22c-4.338 0-8-.705-8-3.425 0-2.721 3.685-3.401 8-3.401 4.339 0 8 .705 8 3.425C20 21.32 16.315 22 12 22Z"
                                                      clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">ظرفیت هر سانس</div>
                                    </div>
                                    <div class="mt-2 inline-flex w-full items-center justify-center overflow-hidden text-ellipsis whitespace-nowrap text-base max-lg:justify-end max-lg:text-sm">
                                    <span class="ml-1"><?= $data['number_min'] ?>
                                        تا <?= $data['number_max'] ?></span>
                                        نفر
                                    </div>
                                </div>
                                
                                <div class="h-20 min-h-full w-px max-w-full bg-slate-120 max-lg:hidden"></div>
                                <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8 lg:last-of-type:hidden">
                                    <div class="items-center gap-3 max-lg:flex">
                                        <div class="text-primary-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                 viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                      d="M12 22C6.48 22 2 17.53 2 12 2 6.48 6.48 2 12 2c5.53 0 10 4.48 10 10 0 5.53-4.47 10-10 10Zm3.19-6.29a.742.742 0 0 0 1.03-.26c.21-.35.1-.81-.26-1.03L12.4 12.3V7.68a.749.749 0 1 0-1.5 0v5.05c0 .26.14.5.37.64l3.92 2.34Z"
                                                      clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">مدت هر سانس</div>
                                    </div>
                                    <div class="mt-2 inline-flex w-full items-center justify-center overflow-hidden text-ellipsis whitespace-nowrap text-base max-lg:justify-end max-lg:text-sm">
                                    <span class="ml-1" dir="ltr"><?= $data['duration'] ?>
                                        <span class="italic">'</span>
                                    </span>
                                        دقیقه
                                    </div>
                                </div>
                                
                                <div class="h-20 min-h-full w-px max-w-full bg-slate-120 max-lg:hidden"></div>
                                <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8 lg:last-of-type:hidden">
                                    <div class="items-center gap-3 max-lg:flex">
                                        <div class="text-primary-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                 viewBox="0 0 24 24">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                      d="M9.803 15.253a3.924 3.924 0 0 0 2.196.679c2.146 0 3.893-1.762 3.893-3.928 0-.817-.254-1.585-.673-2.215l-1.064 1.073c.176.334.273.728.273 1.142 0 1.348-1.093 2.451-2.43 2.451-.41 0-.8-.098-1.131-.275l-1.064 1.073ZM18.43 6.55c1.415 1.3 2.615 3.051 3.513 5.158a.75.75 0 0 1 0 .581c-2.089 4.903-5.806 7.837-9.943 7.837h-.01c-1.883 0-3.688-.62-5.279-1.753l-1.893 1.91a.72.72 0 0 1-.517.217.705.705 0 0 1-.517-.217.736.736 0 0 1-.088-.925l.03-.04 14.43-14.56c.02-.02.04-.04.05-.06.019-.02.038-.039.048-.058l.917-.926a.731.731 0 0 1 1.035 0 .73.73 0 0 1 0 1.044L18.429 6.55ZM8.1 12.008c0 .256.029.512.068.748l-3.61 3.642c-.976-1.142-1.825-2.52-2.498-4.105a.75.75 0 0 1 0-.58c2.088-4.904 5.805-7.828 9.933-7.828h.01c1.395 0 2.75.335 4 .965l-3.26 3.288a4.515 4.515 0 0 0-.74-.069c-2.157 0-3.904 1.763-3.904 3.938Z"
                                                      clip-rule="evenodd"></path>
                                            </svg>
                                        </div>
                                        <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">مناسب سن</div>
                                    </div>
                                    <div class="mt-2 inline-flex w-full items-center justify-center overflow-hidden text-ellipsis whitespace-nowrap text-base max-lg:justify-end max-lg:text-sm">
                                        <span dir="ltr">+<?= $data['age'] ?></span>
                                    </div>
                                </div>
                                
                                <?php if ( $product_type == 'اتاق فرار' ) { ?>
                                    <div class="h-20 min-h-full w-px max-w-full bg-slate-120 max-lg:hidden"></div>
                                    <div class="items-center justify-between gap-3 text-center max-lg:flex lg:max-w-[20%] lg:p-8">
                                        <div class="items-center gap-3 max-lg:flex">
                                            <div class="text-primary-500">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20"
                                                     viewBox="0 0 24 24">
                                                    <path fill="currentColor" fill-rule="evenodd"
                                                          d="M17.523 7.396v1.533c1.722.538 2.977 2.097 2.977 3.96v4.936c0 2.306-1.911 4.175-4.268 4.175H7.77c-2.36 0-4.27-1.87-4.27-4.175v-4.937c0-1.862 1.256-3.421 2.977-3.959V7.396C6.487 4.415 8.957 2 11.985 2c3.069 0 5.538 2.415 5.538 5.396Zm-5.518-3.657c2.063 0 3.74 1.64 3.74 3.657v1.318h-7.49V7.376c.01-2.007 1.687-3.637 3.75-3.637Zm.884 12.716a.88.88 0 0 1-.894.874.877.877 0 0 1-.884-.874v-2.206c0-.477.396-.865.884-.865.498 0 .894.388.894.865v2.206Z"
                                                          clip-rule="evenodd"></path>
                                                </svg>
                                            </div>
                                            <div class="text-nowrap text-2xs lg:mt-5.5 lg:text-slate-350">میزان سختی</div>
                                        </div>
                                        <div class="mt-2 inline-flex w-full items-center justify-center overflow-hidden text-ellipsis whitespace-nowrap text-base max-lg:justify-end max-lg:text-sm">
                                            <?= 5 - intval($data['level']) ?> از 4
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                            
                        </div>
                        <?php if ( $data['options'] ) { ?>
                            <div class="mt-2 flex flex-wrap items-center justify-around gap-4 py-4 max-lg:overflow-x-auto lg:py-8">
                                <?php printOptions( $data['options'] ); ?>
                            </div>
                        <?php } ?>
                    </div>

                    <section class="product-navigator rounded-2xl border border-slate-120 px-8 py-4 shadow-12 sticky top-0 z-10 mt-6 flex items-center gap-4 overflow-x-auto bg-background shadow-[0_-20px_0_0_#fff] max-lg:!rounded-lg max-lg:!border max-md:-mx-4 max-md:rounded-none md:mb-5 lg:top-1 lg:gap-10 lg:!py-6 max-lg:rounded-none" style="top: 0px; z-index: 4;">

                        <?php if ( $data['introduction_text'] ): ?>
                            <a href="#introduction_text" class="text-nowrap text-2xs lg:text-xs text-slate-350">
                                چکیده معرفی
                            </a>
                        <?php endif; ?>

                        <?php if ( $data['scenario'] ): ?>
                            <a href="#scenario" class="text-nowrap text-2xs lg:text-xs text-slate-350">سناریو</a>
                        <?php endif; ?>

                        <?php if ( $data['rules'] ): ?>
                            <a href="#rules" class="text-nowrap text-2xs lg:text-xs text-slate-350">قوانین</a>
                        <?php endif; ?>

                        <?php if ( $data['trailer_video'] ): ?>
                            <a href="#teaser" class="text-nowrap text-2xs lg:text-xs text-slate-350">تیزر</a>
                        <?php endif; ?>

                        <?php if ( $data['gallery'] ): ?>
                            <a href="#gallery" class="text-nowrap text-2xs lg:text-xs text-slate-350">تصاویر</a>
                        <?php endif; ?>

                        <?php if ( $data['criticism'] ): ?>
                            <a href="#criticism" class="text-nowrap text-2xs lg:text-xs text-slate-350">نقد</a>
                        <?php endif; ?>

                        <a href="#comments" class="text-nowrap text-2xs lg:text-xs text-slate-350">کامنت‌ها</a>

                    </section>

                    <section class="space-y-10">
                        <?php if ( $data['introduction_text'] ): ?>
                            <section
                                class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none post-content scroll-mt-25 max-lg:border-0 max-lg:py-0 max-lg:pt-8"
                                id="introduction_text">
                                <div class="relative">
                                    <div class="transition-all delay-0 duration-[2000ms] ease-in-out ">
                                        <div>
                                            <h2 class="!my-3 !text-2xl">معرفی بازی</h2>
                                            <div class="font-medium leading-[38px]">
                                                <?= $data['introduction_text'] ?>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button"
                                            class="hidden flex gap-4 items-center text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:cursor-not-allowed disabled:shadow-none disabled:bg-transparent disabled:opacity-30 disabled:text-gray-900 bottom-0 left-0 bg-white relative p-0 pt-3 mt-5 w-full lg:w-3/4 border-t border-slate-110 justify-start">
                                        <span class="truncate">مشاهده بیشتر</span>
                                        <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="14" viewBox="0 0 24 24"
                                             class="rounded-md bg-white text-[#09192d]">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                  d="m19 8.5-7 7-7-7" vector-effect="non-scaling-stroke"></path>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                            </section>
                        <?php endif; ?>

                        <?php if ( $data['scenario'] ): ?>
                            <section class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none post-content scroll-mt-25 max-lg:border-0 max-lg:py-0" id="scenario">
                                <div class="relative">
                                    <div class=" transition-all delay-0 duration-[2000ms] ease-in-out ">
                                        <div>
                                            <h2 class="!my-3 !text-2xl">سناریو</h2>
                                            <div class="font-medium leading-[38px]">
                                                <?= $data['scenario'] ?>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="hidden flex gap-4 items-center text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:cursor-not-allowed disabled:shadow-none disabled:bg-transparent disabled:opacity-30 disabled:text-gray-900 bottom-0 left-0 bg-white relative p-0 pt-3 mt-5 w-full lg:w-3/4 border-t border-slate-110 justify-start">
                                        <span class="truncate">مشاهده بیشتر</span>
                                        <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="14" viewBox="0 0 24 24"
                                             class="rounded-md bg-white text-[#09192d]">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                  d="m19 8.5-7 7-7-7" vector-effect="non-scaling-stroke"></path>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                            </section>
                        <?php endif; ?>

                        <?php if ( $data['rules'] ): ?>
                            <section
                                class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none post-content scroll-mt-25 max-lg:border-0 max-lg:py-0"
                                id="rules">
                                <div class="relative">
                                    <div class=" transition-all delay-0 duration-[2000ms] ease-in-out ">
                                        <div>
                                            <h2 class="!my-3 !text-2xl">توضیحات لازم به مطالعه قبل از رزرو</h2>
                                            <div class="font-medium leading-[38px]">
                                                <?= $data['rules'] ?>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button"
                                            class="hidden flex gap-4 items-center text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:cursor-not-allowed disabled:shadow-none disabled:bg-transparent disabled:opacity-30 disabled:text-gray-900 bottom-0 left-0 bg-white relative p-0 pt-3 mt-5 w-full lg:w-3/4 border-t border-slate-110 justify-start">
                                        <span class="truncate">مشاهده بیشتر</span>
                                        <span>
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="14" viewBox="0 0 24 24"
                                             class="rounded-md bg-white text-[#09192d]">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                  d="m19 8.5-7 7-7-7" vector-effect="non-scaling-stroke"></path>
                                        </svg>
                                    </span>
                                    </button>
                                </div>
                            </section>
                        <?php endif; ?>
                    </section>
                    <div id="address" class="flex items-stretch gap-2 max-lg:flex-col lg:mt-10 lg:gap-7 max-lg:my-8">
                        <section class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none flex w-full flex-col items-center justify-center max-lg:border-0 max-lg:py-0 lg:h-[31rem]">
                            <div class="w-[31rem] max-w-full">
                                <div class="flex flex-row-reverse max-w-full items-center justify-end gap-6">
                                    <?php if ( $data['brand']['title'] !== null ): ?>
                                        <div>
                                            <!--                                            <span>میــزبان</span>-->
                                            <h3 class="text-base lg:text-xl">
                                                <?= $data['brand']['title'] ?>
                                            </h3>
                                        </div>
                                        <div class="h-10.5 w-10.5 overflow-hidden rounded-md shadow-2 lg:h-17 lg:w-17 lg:rounded-2xl">
                                            <?php
                                            $image_url = Theme_URL . 'assets/images/brand-default-icon.png';
                                            if ( $data['brand']['image'] ) {
                                                $image_url = $data['brand']['image'];
                                            }
                                            ?>
                                            <img src="<?= $image_url ?>" alt="اسکیپ‌زوم - <?= $data['brand']['title'] ?>" loading="lazy" width="68" height="68" decoding="async"
                                                 data-nimg="1" style="color: transparent;">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="line my-2 max-lg:border-transparent lg:my-10"></div>
                                <div class="flex justify-between items-center gap-6 max-lg:text-2xs">
                                    <div class="flex gap-4 items-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24" height="30">
                                            <path clip-rule="evenodd" d="M8.27 14.952l1.593-5.09 5.089-1.592-1.593 5.09-5.089 1.592z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" vector-effect="non-scaling-stroke"></path>
                                            <circle cx="11.611" cy="11.611" r="9.611" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" vector-effect="non-scaling-stroke"></circle>
                                        </svg>
                                        آدرس
                                    </div>
                                    <span><?= $data['city_name']; ?>، <?= $data['address_info']['address'] ?></span>
                                </div>
                                <div class="line my-2 lg:my-10"></div>
                            </div>
                        </section>
                        <div class="relative h-60 overflow-hidden rounded-lg lg:h-[31rem] lg:min-w-[25rem] lg:rounded-2xl">
                            <div id="map" class="relative h-full w-full" style="max-width: 512px; height: 768px;z-index: 3;"></div>
                            <script>
                                var map = L.map('map').setView([<?= round( (float)$data['address_info']['lat'], 3 ) ?>, <?= round( (float)$data['address_info']['long'], 3 ) ?>], 16);
                                L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
                                let primaryIcon = L.icon({
                                    iconUrl: "<?= Theme_URL ?>assets/images/escapezoom-marker-icon.png",
                                    iconSize: [28, 34]
                                });
                                L.marker({lat: <?= round( (float)$data['address_info']['lat'], 3 ) ?>, lon: <?= round( (float)$data['address_info']['long'], 3 ) ?>}, {icon: primaryIcon}).addTo(map)
                                    .bindPopup("لوکیشن اتاق فرار <br> <?= $data['title'] ?>")
                            </script>
                            <div class="absolute bottom-0 left-0 flex w-full gap-4 p-6" style="z-index: 3;">
                                <button type="button" id="go_map_ez"
                                        data-title="<?= $product_type . ' ' . $data['title']; ?>" data-url="https://maps.google.com/?q=<?= (float) $data['address_info']['lat'] ?>,<?= (float)$data['address_info']['long'] ?>"
                                        class="share flex gap-4 items-center justify-center relative font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:bg-slate-110 disabled:text-[#ccc] disabled:cursor-not-allowed disabled:shadow-none w-full bg-slate-800 text-white shadow-17 hover:bg-slate-900 hover:text-white focus-visible:outline-slate-900 min-w-9 px-3 py-1 text-2xs rounded-lg h-12 max-lg:bg-white max-lg:text-slate-700 max-lg:shadow-none" style="z-index: 400">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                                 class="max-lg:text-primary-500">
                                                <path fill="currentColor"
                                                      d="M21.435 2.582a1.933 1.933 0 0 0-1.93-.503L3.408 6.759a1.92 1.92 0 0 0-1.384 1.522c-.142.75.355 1.704 1.003 2.102l5.033 3.094a1.304 1.304 0 0 0 1.61-.194l5.763-5.799a.734.734 0 0 1 1.06 0c.29.292.29.765 0 1.067l-5.773 5.8c-.428.43-.508 1.1-.193 1.62l3.075 5.083c.36.604.98.946 1.66.946.08 0 .17 0 .251-.01.78-.1 1.4-.634 1.63-1.39l4.773-16.075c.21-.685.02-1.43-.48-1.943Z"></path>
                                            </svg>
                                        </span>
                                    <span class="truncate">اشتراک آدرس با دوستان</span>
                                </button>
                                <a href="https://escapezoom.ir/geo.php?g=<?= $data['address_info']['lat'] ?>,<?= $data['address_info']['long'] ?>"
                                   class="flex lg:hidden gap-4 items-center justify-center relative font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:bg-slate-110 disabled:text-[#ccc] disabled:cursor-not-allowed disabled:shadow-none bg-slate-800 text-white shadow-17 hover:bg-slate-900 hover:text-white focus-visible:outline-slate-900 min-w-9 px-3 py-1 text-2xs rounded-lg h-12 w-[60%] max-lg:bg-white max-lg:text-slate-700 max-lg:shadow-none" style="z-index: 400">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24"
                                         class="max-lg:text-primary-500">
                                        <path fill="currentColor" fill-rule="evenodd"
                                              d="M2 12C2 6.48 6.47 2 12 2c5.52 0 10 4.48 10 10 0 5.53-4.48 10-10 10-5.53 0-10-4.47-10-10Zm12.23 1.83 1.62-5.12a.45.45 0 0 0-.56-.57l-5.12 1.6c-.21.07-.38.23-.44.44l-1.6 5.13c-.11.34.22.67.56.56l5.1-1.6c.21-.06.38-.23.44-.44Z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                </span>
                                    <span class="truncate">مسیریابی</span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <?php if ( $data['trailer_video'] ): ?>
                        <section id="teaser" class="scroll-mt-25">
                            <h3 class="mb-4 text-base lg:hidden">تیزر بازی <?php the_title() ?></h3>
                            <section class="overflow-hidden rounded-lg p-0 lg:mt-10 lg:rounded-2xl">
                                <?= $data['trailer_video'] ?>
                            </section>
                        </section>
                    <?php endif; ?>

                    <?php if ( $data['gallery'] ): ?>
                        <section class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:shadow-none max-lg:border-0 max-lg:p-0 lg:mt-10" id="gallery">
                            <div class="flex items-center justify-between lg:mt-3">
                                <div class="flex items-center gap-7">
                                    <h2 class="text-base lg:text-xl">تصـــاویر</h2>
                                    <span>
                                    <span class="text-base"><?= count( $data['gallery'] ) ?></span>
                                    تصویر
                                </span>
                                </div>
                            </div>
                            <div class="pt-7 max-lg:pb-7 lg:pt-10">
                                <div class="pb-4 w-full">
                                    <div class="swiper product-gallery">
                                        <div class="swiper-wrapper">
                                            <?php foreach ( $data['gallery'] as $item ): ?>
                                                <div class="swiper-slide">
                                                    <a href="<?php echo wp_get_attachment_url( $item ); ?>" data-lightbox="image-1" data-title="<?php echo get_post_meta( $item, '_wp_attachment_image_alt', true ) ?>">
                                                        <?php echo wp_get_attachment_image( $item, 'large', '', [
                                                            'class'    => 'h-full w-full object-cover rounded-xl',
                                                            'loading'  => 'lazy',
                                                            'decoding' => 'async',
                                                        ] ) ?>
                                                    </a>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <button class="products-gallery-prev absolute right-0 max-lg:hidden top-1/2 -translate-y-1/2 rotate-180 z-50 cursor-pointer touch-manipulation appearance-none -mr-0.5" type="button">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="30" fill="none" viewBox="0 0 30 113">
                                                <g clip-path="url(#arrow_aa)">
                                                    <path fill="#BFCBD9" fill-rule="evenodd" d="M0 3.75c0 28.814 30 32.928 30 52.823 0 21.023-30 26.414-30 56.595V3.75Z" clip-rule="evenodd"></path>
                                                    <path fill="#fff" fill-rule="evenodd" d="M0 1c0 28.814 27 33.679 27 53.573 0 21.022-27 23.914-27 54.094V1Z" clip-rule="evenodd"></path>
                                                    <path fill="#9FB3CB" fill-rule="evenodd" d="m13.815 50.977.125.142c.387.51.334 1.232-.124 1.677l-3.098 3.037 3.098 3.037.125.141a1.273 1.273 0 0 1-.128 1.68 1.286 1.286 0 0 1-1.804-.003l-4.025-3.946-.126-.142a1.276 1.276 0 0 1 .126-1.676l4.025-3.946.147-.124a1.29 1.29 0 0 1 1.659.123Z" clip-rule="evenodd"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="arrow_aa">
                                                        <path fill="#fff" d="M0 0h30v113H0z"></path>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </button>
                                        <button class="products-gallery-next absolute left-0 max-lg:hidden top-1/2 -translate-y-1/2 z-50 cursor-pointer touch-manipulation appearance-none -ml-0.5" type="button">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="30" fill="none" viewBox="0 0 30 113">
                                                <g clip-path="url(#arrow_aa)">
                                                    <path fill="#BFCBD9" fill-rule="evenodd" d="M0 3.75c0 28.814 30 32.928 30 52.823 0 21.023-30 26.414-30 56.595V3.75Z" clip-rule="evenodd"></path>
                                                    <path fill="#fff" fill-rule="evenodd" d="M0 1c0 28.814 27 33.679 27 53.573 0 21.022-27 23.914-27 54.094V1Z" clip-rule="evenodd"></path>
                                                    <path fill="#9FB3CB" fill-rule="evenodd" d="m13.815 50.977.125.142c.387.51.334 1.232-.124 1.677l-3.098 3.037 3.098 3.037.125.141a1.273 1.273 0 0 1-.128 1.68 1.286 1.286 0 0 1-1.804-.003l-4.025-3.946-.126-.142a1.276 1.276 0 0 1 .126-1.676l4.025-3.946.147-.124a1.29 1.29 0 0 1 1.659.123Z" clip-rule="evenodd"></path>
                                                </g>
                                                <defs>
                                                    <clipPath id="arrow_aa">
                                                        <path fill="#fff" d="M0 0h30v113H0z"></path>
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </section>
                    <?php endif; ?>

                    <?php if ( $data['introduction_video'] ): ?>
                        <section id="teaser" class="scroll-mt-25">
                            <h3 class="mb-4 text-base lg:hidden">معرفی اتاق فرار</h3>
                            <section class="overflow-hidden rounded-lg p-0 lg:mt-10 lg:rounded-2xl">
                                <?= $data['introduction_video'] ?>
                            </section>
                        </section>
                    <?php endif; ?>

                    <?php if ( $data['criticism'] ): ?>
                        <section
                            class="rounded-2xl border border-slate-120 px-8 py-4 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none post-content mt-12 scroll-mt-25 max-lg:border-0 max-lg:pb-0 max-lg:pt-8"
                            id="criticism">
                            <div class="relative">
                                <div class=" transition-all delay-0 duration-[2000ms] ease-in-out ">
                                    <div>
                                        <h2 class="!my-3 !text-2xl">نقد و بررسی</h2>
                                        <div class="font-medium leading-[38px] line-clamp-4 text-justify">&nbsp;
                                            <?= $data['criticism'] ?>
                                        </div>
                                        <button type="button" class="criticism-read-more border-t w-full pt-4 text-right mt-4">
                                            مشاهده بیشتر
                                        </button>
                                    </div>
                                </div>
                                <button type="button"
                                        class="hidden flex gap-4 items-center text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:cursor-not-allowed disabled:shadow-none disabled:bg-transparent disabled:opacity-30 disabled:text-gray-900 bottom-0 left-0 bg-white relative p-0 pt-3 mt-5 w-full lg:w-3/4 border-t border-slate-110 justify-start">
                                    <span class="truncate">مشاهده بیشتر</span>
                                    <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="14" viewBox="0 0 24 24"
                                         class="rounded-md bg-white text-[#09192d]">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                              d="m19 8.5-7 7-7-7" vector-effect="non-scaling-stroke"></path>
                                    </svg>
                                </span>
                                </button>
                            </div>
                        </section>
                    <?php endif; ?>

                    <div class="mb-8">
                        <section class="rounded-2xl border border-slate-120 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none mt-10 p-0 max-lg:border-0" id="comments">
                            <div class="flex items-center justify-between lg:mt-10 lg:px-13">
                                <div class="flex items-center gap-7">
                                    <h2 class="text-base lg:text-xl"> دیدگاه شرکت کنندگان </h2>
                                    <span class="max-lg:hidden">
                                    <span class="text-base"><?php echo esc_html( $data['comments']['comments_count'] ) ?></span>
                                    دیدگاه
                                </span>
                                </div>
                                <a href="#ez-comment-form" class="<?php echo ! is_user_logged_in() ? 'need-login' : ''; ?> flex items-center gap-2 text-2xs">ارسال
                                    دیدگاه
                                    <div class="relative w-8">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="20" viewBox="0 0 24 24">
                                            <path fill="currentColor" fill-rule="evenodd" d="M2 12.015C2 6.747 6.21 2 12.02 2 17.7 2 22 6.657 22 11.985 22 18.165 16.96 22 12 22c-1.64 0-3.46-.44-4.92-1.302-.51-.31-.94-.54-1.49-.36l-2.02.6c-.51.16-.97-.24-.82-.78l.67-2.244c.11-.31.09-.641-.07-.902C2.49 15.43 2 13.697 2 12.015Zm8.7 0c0 .711.57 1.282 1.28 1.292a1.283 1.283 0 0 0 0-2.564c-.7-.01-1.28.571-1.28 1.272Zm4.61.01c0 .701.57 1.282 1.28 1.282a1.283 1.283 0 0 0 0-2.564c-.71 0-1.28.571-1.28 1.282Zm-7.94 1.282c-.7 0-1.28-.58-1.28-1.282 0-.711.57-1.282 1.28-1.282.71 0 1.28.571 1.28 1.282a1.29 1.29 0 0 1-1.28 1.282Z" clip-rule="evenodd"></path>
                                        </svg>
                                        <span class="absolute -top-1 right-0 h-4 w-4 rounded-full bg-accent-450 text-center text-lg leading-[1] text-white">
                                        +
                                    </span>
                                    </div>
                                </a>
                            </div>

                            <div class="my-10 w-full border-t border-slate-110 max-lg:hidden"></div>

                            <div class="flex items-center justify-center gap-0 max-lg:mb-5 max-lg:mt-5 max-lg:flex-col max-lg:rounded-lg max-lg:bg-accent-20 max-lg:px-8 max-lg:py-9 lg:gap-16 lg:px-13 lg:py-6">
                                <div class="max-lg:w-full lg:min-w-72">
                                    <div class="mb-6 flex items-center justify-between gap-10 lg:mb-8.5 lg:items-end">
                                        <div class="max-lg:flex max-lg:items-center">
                                            <h3 class="text-base lg:text-2xl lg:font-extrabold lg:text-accent-700">
                                                میانگین امتیاز
                                            </h3>
                                            <div class="text-2xs lg:mt-2 lg:max-w-40">
                                                <span class="max-lg:hidden"> <?php echo $data['title'] ?> از</span>
                                                <span class="mr-1 text-base max-lg:mr-3"><?php echo esc_html( $data['comments']['comments_count'] ) ?></span>
                                                رای
                                            </div>
                                        </div>
                                        <div>
                                            <div class="text-2xl lg:mb-3.5 lg:text-4xl" dir="ltr">
                                                <span class="mr-1 text-4xl lg:text-[5.5rem]"><?= (esc_html( $data['comments']['rate'] ) <= 5) ? esc_html( $data['comments']['rate'] ) : '5'  ?></span>
                                                <span class="ml-1 mr-2.5 inline-flex h-5 w-px bg-slate-120 max-lg:hidden"></span>
                                                <span class="ml-1 mr-2.5 inline-flex text-sm text-slate-120 lg:hidden">
                                                /
                                            </span>
                                                <span class="inline-flex items-baseline">5</span>
                                            </div>
                                            <div class="flex flex-row items-center justify-start gap-0.5 max-lg:hidden"
                                                 dir="ltr">
                                                <?php for ( $i = 0; $i < floor( $data['comments']['rate'] ); $i ++ ) { ?>
                                                    <span class="transition text-accent-420">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19" fill="none">
                                                        <path d="M8.57341 1.39058C9.02244 0.00861213 10.9776 0.00860999 11.4266 1.39058L12.5819 4.9463C12.7827 5.56434 13.3587 5.98278 14.0085 5.98278H17.7472C19.2003 5.98278 19.8045 7.8422 18.6289 8.6963L15.6042 10.8939C15.0785 11.2758 14.8585 11.9529 15.0593 12.5709L16.2146 16.1266C16.6637 17.5086 15.0819 18.6578 13.9064 17.8037L10.8817 15.6061C10.3559 15.2242 9.64405 15.2242 9.11832 15.6061L6.09364 17.8037C4.91807 18.6578 3.33635 17.5086 3.78538 16.1266L4.9407 12.5709C5.14151 11.9529 4.92153 11.2758 4.3958 10.8939L1.37111 8.69631C0.195544 7.8422 0.799705 5.98278 2.25279 5.98278H5.9915C6.64134 5.98278 7.21728 5.56434 7.41809 4.9463L8.57341 1.39058Z" fill="#EFC101"/>
                                                    </svg>
                                                </span>
                                                <?php }
                                                if ( $data['comments']['rate'] > floor( $data['comments']['rate'] ) + .25 ) { ?>
                                                    <span class="transition text-accent-420">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 26 26" fill="none">
                                                        <path d="M11.5734 4.39058C12.0224 3.00861 13.9776 3.00861 14.4266 4.39058L15.5819 7.9463C15.7827 8.56434 16.3587 8.98278 17.0085 8.98278H20.7472C22.2003 8.98278 22.8045 10.8422 21.6289 11.6963L18.6042 13.8939C18.0785 14.2758 17.8585 14.9529 18.0593 15.5709L19.2146 19.1266C19.6637 20.5086 18.0819 21.6578 16.9064 20.8037L13.8817 18.6061C13.3559 18.2242 12.6441 18.2242 12.1183 18.6061L9.09364 20.8037C7.91807 21.6578 6.33635 20.5086 6.78538 19.1266L7.9407 15.5709C8.14151 14.9529 7.92153 14.2758 7.3958 13.8939L4.37111 11.6963C3.19554 10.8422 3.79971 8.98278 5.25279 8.98278H8.9915C9.64134 8.98278 10.2173 8.56434 10.4181 7.9463L11.5734 4.39058Z" fill="#D5DCE1"/>
                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.0001 3.35547C12.399 3.35547 11.798 3.70096 11.5735 4.39194L10.4182 7.94767C10.2174 8.5657 9.64143 8.98414 8.99159 8.98414H5.25287C3.79979 8.98414 3.19563 10.8436 4.3712 11.6977L7.39588 13.8952C7.92161 14.2772 8.1416 14.9543 7.94079 15.5723L6.78546 19.128C6.33643 20.51 7.91815 21.6592 9.09372 20.8051L12.1184 18.6075C12.3813 18.4165 12.6907 18.321 13.0001 18.321V3.35547Z" fill="#EFC101"/>
                                                    </svg>
                                                </span>
                                                <?php }
                                                for ( $i = 0; $i < 5 - ( floor( $data['comments']['rate'] ) + 1 ); $i ++ ) { ?>
                                                    <span class="transition text-accent-420">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="19" viewBox="0 0 20 19" fill="none">
                                                        <path d="M8.57341 1.39058C9.02244 0.00861213 10.9776 0.00860999 11.4266 1.39058L12.5819 4.9463C12.7827 5.56434 13.3587 5.98278 14.0085 5.98278H17.7472C19.2003 5.98278 19.8045 7.8422 18.6289 8.6963L15.6042 10.8939C15.0785 11.2758 14.8585 11.9529 15.0593 12.5709L16.2146 16.1266C16.6637 17.5086 15.0819 18.6578 13.9064 17.8037L10.8817 15.6061C10.3559 15.2242 9.64405 15.2242 9.11832 15.6061L6.09364 17.8037C4.91807 18.6578 3.33635 17.5086 3.78538 16.1266L4.9407 12.5709C5.14151 11.9529 4.92153 11.2758 4.3958 10.8939L1.37111 8.69631C0.195544 7.8422 0.799705 5.98278 2.25279 5.98278H5.9915C6.64134 5.98278 7.21728 5.56434 7.41809 4.9463L8.57341 1.39058Z" fill="#D5DCE1"/>
                                                    </svg>
                                                </span>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="#ez-comment-form" class="<?php echo ! is_user_logged_in() ? 'need-login' : ''; ?> flex gap-4 items-center justify-center relative text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:bg-slate-110 disabled:text-[#ccc] disabled:cursor-not-allowed disabled:shadow-none w-full bg-accent-450 text-white shadow-16 hover:bg-accent-500 focus-visible:outline-accent-500 h-16 min-w-16 px-9 py-2 rounded-2xl max-lg:hidden lg:text-lg lg:shadow-23">
                                        <span class="truncate">ارســال دیـدگـــاه</span>
                                    </a>
                                </div>

                                <?php if ( $product_type == 'اتاق فرار' ) { ?>
                                    <div class="max-lg:w-full lg:w-72">
                                        <div class="mb-2 flex items-center justify-between last:mb-0 lg:mb-3.5">
                                            <span class="nowrap text-xs lg:text-sm">فضاسازی</span>
                                            <span class="min-w-36">
                                            <div class="flex items-center justify-center" dir="ltr">
                                                <span class="mr-2.5 min-w-9 text-lg"><?php echo $data['comments']['rating_items'][1] ?></span>
                                                <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-1">
                                                    <div class="rounded-full bg-accent-420 h-1" style="width: <?php echo $data['comments']['rating_items'][1] * 20 ?>%;"></div>
                                                </div>
                                            </div>
                                        </span>
                                        </div>
                                        <div class="mb-2 flex items-center justify-between last:mb-0 lg:mb-3.5">
                                            <span class="nowrap text-xs lg:text-sm">کیفیت معما</span>
                                            <span class="min-w-36">
                                            <div class="flex items-center justify-center" dir="ltr">
                                                <span class="mr-2.5 min-w-9 text-lg"><?php echo $data['comments']['rating_items'][2] ?></span>
                                                <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-1">
                                                    <div class="rounded-full bg-accent-420 h-1" style="width: <?php echo $data['comments']['rating_items'][2] * 20 ?>%;"></div>
                                                </div>
                                            </div>
                                        </span>
                                        </div>
                                        <div class="mb-2 flex items-center justify-between last:mb-0 lg:mb-3.5">
                                            <span class="nowrap text-xs lg:text-sm">تازگی و خلاقیت</span>
                                            <span class="min-w-36">
                                            <div class="flex items-center justify-center" dir="ltr">
                                                <span class="mr-2.5 min-w-9 text-lg"><?php echo $data['comments']['rating_items'][5] ?></span>
                                                <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-1">
                                                    <div class="rounded-full bg-accent-420 h-1" style="width: <?php echo $data['comments']['rating_items'][5] * 20 ?>%;"></div>
                                                </div>
                                            </div>
                                        </span>
                                        </div>
                                        <div class="mb-2 flex items-center justify-between last:mb-0 lg:mb-3.5">
                                            <span class="nowrap text-xs lg:text-sm">بازیگردانی و اکت</span>
                                            <span class="min-w-36">
                                            <div class="flex items-center justify-center" dir="ltr">
                                                <span class="mr-2.5 min-w-9 text-lg"><?php echo $data['comments']['rating_items'][3] ?></span>
                                                <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-1">
                                                    <div class="rounded-full bg-accent-420 h-1" style="width: <?php echo $data['comments']['rating_items'][3] * 20 ?>%;"></div>
                                                </div>
                                            </div>
                                        </span>
                                        </div>
                                        <div class="mb-2 flex items-center justify-between last:mb-0 lg:mb-3.5">
                                            <span class="nowrap text-xs lg:text-sm">برخورد پرسنل</span>
                                            <span class="min-w-36">
                                            <div class="flex items-center justify-center" dir="ltr">
                                                <span class="mr-2.5 min-w-9 text-lg"><?php echo $data['comments']['rating_items'][4] ?></span>
                                                <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-1">
                                                    <div class="rounded-full bg-accent-420 h-1" style="width: <?php echo $data['comments']['rating_items'][4] * 20 ?>%;"></div>
                                                </div>
                                            </div>
                                        </span>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>

                            <div class="mt-10 w-full border-t border-slate-110 max-lg:hidden"></div>

                            <div class="relative border-slate-100 border-b max-lg:hidden lg:px-13 lg:[&_button]:py-8.5">
                                <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                    <div class="flex gap-2">
                                        <button type="button" data-action="get-comments" data-sort-type="newest" class="active text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap lg:text-gray-900 lg:border-prima lg:border-accent-450 max-lg:text-white max-lg:w-full ml-5.5 rounded-none border-b-4 px-0 pb-4.5 pt-5.5 lg:text-sm">
                                            جدیدترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="best" class="hidden text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap text-slate-350 ml-5.5 rounded-none border-b-4 px-0 pb-4.5 pt-5.5 lg:text-sm">
                                            محبوب ترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="oldest" class="hidden text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap text-slate-350 ml-5.5 rounded-none border-b-4 px-0 pb-4.5 pt-5.5 lg:text-sm">
                                            قدیمی ترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="pro" class="text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap text-slate-350 ml-5.5 rounded-none border-b-4 px-0 pb-4.5 pt-5.5 lg:text-sm flex items-center gap-2">
                                            دیدگاه حرفه ای تر ها
                                            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" viewBox="0 0 15 14" fill="none">
                                                <path d="M7.00074 11.9562L3.88824 13.8312C3.75074 13.9187 3.60698 13.9562 3.45698 13.9437C3.30698 13.9312 3.17573 13.8813 3.06323 13.7938C2.95073 13.7063 2.86323 13.597 2.80073 13.466C2.73823 13.335 2.72573 13.188 2.76323 13.025L3.58823 9.48125L0.831985 7.1C0.706985 6.9875 0.628985 6.85925 0.597985 6.71525C0.566985 6.57125 0.576235 6.43075 0.625735 6.29375C0.675235 6.15675 0.750235 6.04425 0.850735 5.95625C0.951235 5.86825 1.08873 5.812 1.26323 5.7875L4.90073 5.46875L6.30698 2.13125C6.36948 1.98125 6.46649 1.86875 6.59799 1.79375C6.72949 1.71875 6.86374 1.68125 7.00074 1.68125C7.13773 1.68125 7.27199 1.71875 7.40348 1.79375C7.53498 1.86875 7.63199 1.98125 7.69449 2.13125L9.10073 5.46875L12.7382 5.7875C12.9132 5.8125 13.0507 5.86875 13.1507 5.95625C13.2507 6.04375 13.3257 6.15625 13.3757 6.29375C13.4257 6.43125 13.4352 6.572 13.4042 6.716C13.3732 6.86 13.295 6.988 13.1695 7.1L10.4132 9.48125L11.2382 13.025C11.2757 13.1875 11.2632 13.3345 11.2007 13.466C11.1382 13.5975 11.0507 13.7067 10.9382 13.7938C10.8257 13.8808 10.6945 13.9307 10.5445 13.9437C10.3945 13.9567 10.2507 13.9192 10.1132 13.8312L7.00074 11.9562ZM12.4382 3.36875L11.3132 4.025C11.2382 4.0625 11.1662 4.0595 11.0972 4.016C11.0282 3.9725 11.0065 3.90675 11.032 3.81875L11.332 2.58125L10.3382 1.75625C10.2757 1.69375 10.257 1.62825 10.282 1.55975C10.307 1.49125 10.3632 1.4505 10.4507 1.4375L11.7632 1.325L12.2695 0.14375C12.2945 0.06875 12.3507 0.03125 12.4382 0.03125C12.5257 0.03125 12.582 0.06875 12.607 0.14375L13.1132 1.325L14.4257 1.4375C14.5132 1.45 14.5695 1.49075 14.5945 1.55975C14.6195 1.62875 14.6007 1.69425 14.5382 1.75625L13.5445 2.58125L13.8445 3.81875C13.8695 3.90625 13.8477 3.972 13.7792 4.016C13.7107 4.06 13.6387 4.063 13.5632 4.025L12.4382 3.36875Z" fill="#EFC101"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="relative lg:hidden lg:px-13 lg:[&_button]:py-8.5">
                                <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                    <div class="flex border-gray-110 justify-between gap-0 overflow-hidden rounded-lg border">
                                        <button type="button" data-action="get-comments" data-sort-type="newest" class="active text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 -m-px w-full lg:text-gray-900 lg:border-accent-450 max-lg:bg-accent-450 max-lg:text-white max-lg:w-full h-9 min-w-9 md:px-5 py-1 px-0">
                                            جدیدترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="best" class="hidden text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 -m-px text-slate-350 w-full h-9 min-w-9 md:px-5 py-1 px-0">
                                            محبوب ترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="oldest" class="hidden text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 -m-px text-slate-350 w-full h-9 min-w-9 md:px-5 py-1 px-0">
                                            قدیمی ترین
                                        </button>
                                        <button type="button" data-action="get-comments" data-sort-type="pro" class="text-nowrap text-center text-xs font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 -m-px text-slate-350 w-full h-9 min-w-9 md:px-5 py-1 px-0 flex items-center justify-center gap-2">
                                            دیدگاه حرفه ای تر ها
                                            <svg xmlns="http://www.w3.org/2000/svg" width="15" height="14" viewBox="0 0 15 14" fill="none" class="mx-0">
                                                <path d="M7.00074 11.9562L3.88824 13.8312C3.75074 13.9187 3.60698 13.9562 3.45698 13.9437C3.30698 13.9312 3.17573 13.8813 3.06323 13.7938C2.95073 13.7063 2.86323 13.597 2.80073 13.466C2.73823 13.335 2.72573 13.188 2.76323 13.025L3.58823 9.48125L0.831985 7.1C0.706985 6.9875 0.628985 6.85925 0.597985 6.71525C0.566985 6.57125 0.576235 6.43075 0.625735 6.29375C0.675235 6.15675 0.750235 6.04425 0.850735 5.95625C0.951235 5.86825 1.08873 5.812 1.26323 5.7875L4.90073 5.46875L6.30698 2.13125C6.36948 1.98125 6.46649 1.86875 6.59799 1.79375C6.72949 1.71875 6.86374 1.68125 7.00074 1.68125C7.13773 1.68125 7.27199 1.71875 7.40348 1.79375C7.53498 1.86875 7.63199 1.98125 7.69449 2.13125L9.10073 5.46875L12.7382 5.7875C12.9132 5.8125 13.0507 5.86875 13.1507 5.95625C13.2507 6.04375 13.3257 6.15625 13.3757 6.29375C13.4257 6.43125 13.4352 6.572 13.4042 6.716C13.3732 6.86 13.295 6.988 13.1695 7.1L10.4132 9.48125L11.2382 13.025C11.2757 13.1875 11.2632 13.3345 11.2007 13.466C11.1382 13.5975 11.0507 13.7067 10.9382 13.7938C10.8257 13.8808 10.6945 13.9307 10.5445 13.9437C10.3945 13.9567 10.2507 13.9192 10.1132 13.8312L7.00074 11.9562ZM12.4382 3.36875L11.3132 4.025C11.2382 4.0625 11.1662 4.0595 11.0972 4.016C11.0282 3.9725 11.0065 3.90675 11.032 3.81875L11.332 2.58125L10.3382 1.75625C10.2757 1.69375 10.257 1.62825 10.282 1.55975C10.307 1.49125 10.3632 1.4505 10.4507 1.4375L11.7632 1.325L12.2695 0.14375C12.2945 0.06875 12.3507 0.03125 12.4382 0.03125C12.5257 0.03125 12.582 0.06875 12.607 0.14375L13.1132 1.325L14.4257 1.4375C14.5132 1.45 14.5695 1.49075 14.5945 1.55975C14.6195 1.62875 14.6007 1.69425 14.5382 1.75625L13.5445 2.58125L13.8445 3.81875C13.8695 3.90625 13.8477 3.972 13.7792 4.016C13.7107 4.06 13.6387 4.063 13.5632 4.025L12.4382 3.36875Z" fill="#EFC101"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="relative">
                                <div class="mt-5 lg:mt-10" id="comments-list">
                                    <?php foreach ( $data['comments']['items'] as $comment ) { ?>
                                        <section class="comment-<?php echo $comment['id']; ?> flex max-lg:mb-5 max-lg:flex-col last:mb-0 max-lg:rounded-lg max-lg:border max-lg:border-slate-110 max-lg:px-7 max-lg:py-6 lg:items-center lg:px-13 lg:mb-10 lg:border-b lg:pb-10">
                                            <div class="w-full">
                                                <div class="mb-3 flex items-center justify-between gap-2 max-lg:mb-3 lg:mb-6">
                                                    <div class="flex items-center gap-6.5">
                                                        <div class="overflow-hidden rounded-xl max-lg:hidden">
                                                            <?php echo get_avatar( $comment['author_id'], 50, null, '', [
                                                                'class' => 'h-full w-10 object-cover',
                                                            ] ) ?>
                                                        </div>
                                                        <span class="max-lg:text-base flex items-center">
														<?php if ( $comment['author_id'] ) { ?>
                                                            <a href="<?php echo site_url( "/profile/" . $comment['author_id'] ); ?>" class="text-base font-bold text-black" dir="ltr">
																<?php echo $comment['author_title']; ?>
                                                            </a>
                                                        <?php } else { ?>
                                                            <span class="text-base font-bold text-black" dir="ltr">
																<?php echo $comment['author_title']; ?>
                                                            </span>
                                                        <?php } ?>

                                                            <?php if ( $comment['author_id'] ) {
                                                                user_badge_by_level( $comment['author_id'], 'px-2 py-0.5 text-xs font-bold text-white mr-2.5 rounded-xl' );
                                                            } ?>
                                                    </span>
                                                    </div>
                                                    <div class="hidden items-center gap-6">
                                                        <div class="flex items-center gap-2">
                                                            <button type="button" data-action="like-comment" data-id="<?php echo $comment['id']; ?>" class="flex h-5 w-5 items-center justify-center rounded-md bg-accent-100 text-accent-500">
                                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="24" viewBox="0 0 24 24"
                                                                     stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                                                     stroke-width="4" class="w-3">
                                                                    <path d="M11.726 4.25v15M5.701 10.3l6.024-6.05 6.025 6.05"></path>
                                                                </svg>
                                                            </button>
                                                            <div class="min-w-4 text-center lg:min-w-8 lg:text-base" dir="ltr" data-comment-vote-id="<?php echo $comment['id']; ?>">
                                                                <?php echo $comment['votes_count']; ?>
                                                            </div>
                                                            <button type="button" data-action="dislike-comment" data-id="<?php echo $comment['id']; ?>" class="flex h-5 w-5 items-center justify-center rounded-md bg-secondary-100 text-secondary-500">
                                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="24" viewBox="0 0 24 24"
                                                                     stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                                                     stroke-width="4" class="w-3">
                                                                    <path d="M12.274 19.75v-15m6.025 8.95-6.024 6.05L6.25 13.7"></path>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="text-xs font-bold text-[#889bad]">
                                                        <?php echo human_time_diff( $comment['date'], current_time( 'U' ) ) ?>
                                                        پیش
                                                    </div>
                                                </div>
                                                <p class="text-base font-bold text-[#5d6a77] comment-content" data-continue="<?php echo $comment['content']; ?>">
                                                    <?php echo substr( $comment['content'], 0, 400 ); ?>
                                                    <?php if ( strlen( $comment['content'] ) > 400 ) {
                                                        echo '<span>... <span class="text-blue">ادامه</span></span>';
                                                    } ?>
                                                </p>

                                                <?php if ( ! wp_is_mobile() ) {
                                                    if ( $comment['reply'] ) { ?>
                                                        <div class="comment-reply">
                                                            <p class="text-md font-bold mb-2 mt-8 text-black flex items-center gap-4">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14" viewBox="0 0 16 14" fill="none" class="mx-0">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.70679 13.7072C5.89426 13.5197 5.99957 13.2654 5.99957 13.0002C5.99957 12.735 5.89426 12.4807 5.70679 12.2932L3.41379 10.0002H8.99979C10.8563 10.0002 12.6368 9.26272 13.9495 7.94996C15.2623 6.63721 15.9998 4.85673 15.9998 3.00021V1.00021C15.9998 0.734997 15.8944 0.480642 15.7069 0.293106C15.5194 0.10557 15.265 0.000213623 14.9998 0.000213623C14.7346 0.000213623 14.4802 0.10557 14.2927 0.293106C14.1051 0.480642 13.9998 0.734997 13.9998 1.00021V3.00021C13.9998 4.3263 13.473 5.59807 12.5353 6.53575C11.5976 7.47343 10.3259 8.00021 8.99979 8.00021H3.41379L5.70679 5.70721C5.8023 5.61497 5.87848 5.50462 5.93089 5.38262C5.9833 5.26061 6.01088 5.12939 6.01204 4.99661C6.01319 4.86384 5.98789 4.73216 5.93761 4.60926C5.88733 4.48636 5.81307 4.37471 5.71918 4.28082C5.62529 4.18693 5.51364 4.11267 5.39074 4.06239C5.26784 4.01211 5.13616 3.98681 5.00339 3.98796C4.87061 3.98912 4.73939 4.0167 4.61738 4.06911C4.49538 4.12152 4.38503 4.1977 4.29279 4.29321L0.292786 8.29321C0.105315 8.48074 0 8.73505 0 9.00021C0 9.26538 0.105315 9.51969 0.292786 9.70721L4.29279 13.7072C4.48031 13.8947 4.73462 14 4.99979 14C5.26495 14 5.51926 13.8947 5.70679 13.7072Z" fill="#889BAD"></path>
                                                                </svg>
                                                                پاسخ مجموعه
                                                            </p>
                                                            <div class="comment-content pr-6 py-2 border-r flex flex-col text-gray-500">
                                                                <?= $comment['reply']; ?>
                                                            </div>
                                                        </div>
                                                    <?php } else {
                                                        if (
                                                            get_current_user_id() == get_post_meta( $product_id, 'user_ebtal', true ) ||
                                                            get_current_user_id() == get_post_meta( $product_id, 'sans_manager', true )
                                                        ) {
                                                            ?>
                                                            <div class="flex justify-between">
                                                                <div class="flex">
                                                                    <p class="reply-button text-[14px] font-bold text-[#3F7FF5] cursor-pointer flex items-center gap-2" data-target-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                                        پاسخ به این دیدگاه
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="16" viewBox="0 0 15 16" fill="none">
                                                                            <path d="M5.625 10.125L2.5 7L5.625 3.875" stroke="#3F7FF5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                                            <path d="M12.5 10.75V9.5C12.5 8.83696 12.2366 8.20107 11.7678 7.73223C11.2989 7.26339 10.663 7 10 7H2.5" stroke="#3F7FF5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                                        </svg>
                                                                    </p>
                                                                    <p class="close-reply-button hidden text-[14px] font-bold  text-[#3F7FF5] cursor-pointer flex items-center gap-2" data-target-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                                        بستن
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="11" height="10" viewBox="0 0 11 10" fill="none">
                                                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.50024 6.32601L8.81462 9.64039C8.99049 9.81626 9.22902 9.91506 9.47774 9.91506C9.72646 9.91506 9.96499 9.81626 10.1409 9.64039C10.3167 9.46452 10.4155 9.22598 10.4155 8.97726C10.4155 8.72854 10.3167 8.49001 10.1409 8.31414L6.82524 4.99976L10.1402 1.68539C10.2273 1.59831 10.2963 1.49493 10.3434 1.38117C10.3905 1.2674 10.4147 1.14548 10.4147 1.02236C10.4147 0.899231 10.3904 0.777317 10.3432 0.663576C10.2961 0.549835 10.227 0.446493 10.1399 0.359451C10.0528 0.272409 9.94947 0.203372 9.83571 0.156281C9.72194 0.10919 9.60002 0.0849678 9.47689 0.0849968C9.35377 0.0850258 9.23186 0.109306 9.11812 0.15645C9.00437 0.203595 8.90103 0.272681 8.81399 0.359764L5.50024 3.67414L2.18587 0.359764C2.09943 0.270183 1.99601 0.198714 1.88166 0.149528C1.7673 0.100341 1.6443 0.0744215 1.51982 0.0732815C1.39534 0.0721415 1.27188 0.0958038 1.15664 0.142888C1.0414 0.189972 0.936696 0.259535 0.84863 0.347517C0.760565 0.4355 0.690903 0.54014 0.643711 0.655333C0.596518 0.770525 0.572739 0.893963 0.573762 1.01844C0.574785 1.14292 0.600588 1.26595 0.649667 1.38036C0.698746 1.49476 0.770117 1.59824 0.859616 1.68476L4.17524 4.99976L0.860241 8.31476C0.770742 8.40129 0.699371 8.50477 0.650292 8.61917C0.601213 8.73357 0.57541 8.8566 0.574387 8.98108C0.573364 9.10556 0.597143 9.229 0.644336 9.34419C0.691528 9.45939 0.76119 9.56403 0.849255 9.65201C0.937321 9.73999 1.04203 9.80956 1.15726 9.85664C1.2725 9.90372 1.39596 9.92739 1.52044 9.92625C1.64492 9.92511 1.76793 9.89919 1.88228 9.85C1.99664 9.80081 2.10005 9.72934 2.18649 9.63976L5.50024 6.32601Z" fill="#3F7FF5"/>
                                                                        </svg>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                            <div class="hidden mt-4" data-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                                <form method="post" class="submit-reply-form flex items-end gap-4">
                                                                    <input type="hidden" name="product" value="<?php echo esc_attr( $product_id ); ?>">
                                                                    <input type="hidden" name="comment" value="<?php echo esc_attr( $comment['id'] ); ?>">
                                                                    <textarea name="comment_content" class="w-full min-h-full rounded-[14px] border border-[#E4EBF0] p-2 resize-y" rows="1" placeholder="پاسخ خود را اینجا بنویسید..."></textarea>
                                                                    <button type="submit" class="btn rounded-2xl p-4 text-white mt-2" style="box-shadow: 0 2px 0 0 #CA5608; background: #FD7013;">
                                                                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="17" viewBox="0 0 21 17" fill="none">
                                                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.6595 4.59923C20.8815 2.59379 19.428 0.0248262 17.0788 0.0393534L3.86266 0.119491C1.33133 0.134071 -0.044711 3.08501 1.57123 5.03349L10.0046 15.21C11.5035 17.019 14.4048 16.4807 15.1565 14.2559L16.5505 10.1306L9.19314 6.69977C8.95277 6.58768 8.76678 6.3847 8.67607 6.13548C8.58536 5.88626 8.59737 5.61121 8.70945 5.37084C8.82154 5.13047 9.02452 4.94448 9.27374 4.85377C9.52296 4.76306 9.79801 4.77507 10.0384 4.88715L17.3949 8.31755L19.6595 4.59923Z" fill="white"/>
                                                                        </svg>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        <?php }
                                                    }
                                                } ?>

                                                <div class="mt-3 flex items-center justify-between lg:mt-6">
                                                    <?php
                                                    $rate = $comment['user_feeling'];

                                                    if ( $product_type !== 'اتاق فرار' ) {
                                                        $rate = max( $rate, 0.2 );
                                                        $rate = ceil( (float) $rate * 5 );
                                                    } else {
                                                        $rate = max( $rate, 1 );
                                                        $rate = ceil( (float) $rate );
                                                    }
                                                    $rate_str   = match ( (string) $rate ) {
                                                        '1' => 'خیلی بد',
                                                        '2' => 'خوب نبود',
                                                        '3' => 'معمولی بود',
                                                        '4' => 'خوب بود',
                                                        //'5' => 'عالی بود',
                                                        default => 'عالی بود',
                                                    };
                                                    $rate_color = match ( (string) $rate ) {
                                                        '1' => '#F21543',
                                                        '2' => '#FD7013',
                                                        '3' => '#BF9A00',
                                                        '4' => '#3F7FF5',
                                                        //'5' => '#049654',
                                                        default => '#049654',
                                                    };
                                                    $rate_img = match ( (string) $rate ) {
                                                        '1' => '1',
                                                        '2' => '2',
                                                        '3' => '3',
                                                        '4' => '4',
                                                        //'5' => '#049654',
                                                        default => '5',
                                                    };
                                                    ?>
                                                    <div class="flex items-center gap-3 text-sm font-bold text-[#3f7ff5]">
                                                        <img src="<?php bloginfo( 'template_url' ); ?>/assets/images/emojis/<?= $rate_img ?>.png" draggable="false" alt="<?php echo $rate; ?>" class="w-8 h-auto">
                                                        <p class="text-[14px] font-bold" style="color: <?= esc_attr( $rate_color ) ?>">
                                                            <?php echo esc_html( $rate_str ) ?>
                                                        </p>
                                                    </div>
                                                    <div class="flex-wrap items-center gap-6">
                                                        <div class="flex items-center gap-2">
                                                            <button type="button" data-action="like-comment" data-id="<?php echo $comment['id']; ?>" class="flex h-5 w-5 items-center justify-center rounded-md bg-accent-100 text-accent-500">
                                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="24" viewBox="0 0 24 24"
                                                                     stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                                                     stroke-width="4" class="w-3">
                                                                    <path d="M11.726 4.25v15M5.701 10.3l6.024-6.05 6.025 6.05"></path>
                                                                </svg>
                                                            </button>
                                                            <div class="min-w-4 text-center lg:min-w-8 lg:text-base" dir="ltr" data-comment-vote-id="<?php echo $comment['id']; ?>">
                                                                <?php echo $comment['votes_count']; ?>
                                                            </div>
                                                            <button type="button" data-action="dislike-comment" data-id="<?php echo $comment['id']; ?>" class="flex h-5 w-5 items-center justify-center rounded-md bg-secondary-100 text-secondary-500">
                                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" width="24" viewBox="0 0 24 24"
                                                                     stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                                                     stroke-width="4" class="w-3">
                                                                    <path d="M12.274 19.75v-15m6.025 8.95-6.024 6.05L6.25 13.7"></path>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                            <?php if ( $product_type == 'اتاق فرار' ) { ?>
                                                <div class="mx-10 h-36 border-l border-slate-110 max-lg:hidden"></div>
                                                <div class="min-w-48 max-lg:hidden max-lg:mt-6">
                                                    <div class="mb-0.5 flex items-center justify-between last:mb-0 lg:mb-2">
                                                        <span class="nowrap text-2xs">فضاسازی</span>
                                                        <span class="min-w-24 max-lg:min-w-37.5">
                                                        <div class="flex items-center justify-center" dir="ltr">
                                                            <span class="mr-2.5 min-w-3 text-sm"><?php echo $comment['rating_items'][1094]; ?></span>
                                                            <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-0.5">
                                                                <div class="rounded-full bg-accent-420 h-0.5" style="width: <?php echo $comment['rating_items'][1094] * 20; ?>%"></div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                    </div>
                                                    <div class="mb-0.5 flex items-center justify-between last:mb-0 lg:mb-2">
                                                        <span class="nowrap text-2xs">کیفیت معما</span>
                                                        <span class="min-w-24 max-lg:min-w-37.5">
                                                        <div class="flex items-center justify-center" dir="ltr">
                                                            <span class="mr-2.5 min-w-3 text-sm"><?php echo $comment['rating_items'][1095]; ?></span>
                                                            <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-0.5">
                                                                <div class="rounded-full bg-accent-420 h-0.5" style="width: <?php echo $comment['rating_items'][1095] * 20; ?>%;"></div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                    </div>
                                                    <div class="mb-0.5 flex items-center justify-between last:mb-0 lg:mb-2">
                                                        <span class="nowrap text-2xs">تازگی و خلاقیت</span>
                                                        <span class="min-w-24 max-lg:min-w-37.5">
                                                        <div class="flex items-center justify-center" dir="ltr">
                                                            <span class="mr-2.5 min-w-3 text-sm"><?php echo $comment['rating_items'][1098]; ?></span>
                                                            <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-0.5">
                                                                <div class="rounded-full bg-accent-420 h-0.5" style="width: <?php echo $comment['rating_items'][1098] * 20; ?>%;"></div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                    </div>
                                                    <div class="mb-0.5 flex items-center justify-between last:mb-0 lg:mb-2">
                                                        <span class="nowrap text-2xs">بازیگردانی و اکت</span>
                                                        <span class="min-w-24 max-lg:min-w-37.5">
                                                        <div class="flex items-center justify-center" dir="ltr">
                                                            <span class="mr-2.5 min-w-3 text-sm"><?php echo $comment['rating_items'][1096]; ?></span>
                                                            <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-0.5">
                                                                <div class="rounded-full bg-accent-420 h-0.5" style="width: <?php echo $comment['rating_items'][1096] * 20; ?>%;"></div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                    </div>
                                                    <div class="mb-0.5 flex items-center justify-between last:mb-0 lg:mb-2">
                                                        <span class="nowrap text-2xs">برخورد پرسنل</span>
                                                        <span class="min-w-24 max-lg:min-w-37.5">
                                                        <div class="flex items-center justify-center" dir="ltr">
                                                            <span class="mr-2.5 min-w-3 text-sm"><?php echo $comment['rating_items'][1097]; ?></span>
                                                            <div class="w-full rounded-full bg-slate-110 dark:bg-gray-700 h-0.5">
                                                                <div class="rounded-full bg-accent-420 h-0.5" style="width: <?php echo $comment['rating_items'][1097] * 20; ?>%;"></div>
                                                            </div>
                                                        </div>
                                                    </span>
                                                    </div>
                                                </div>
                                                <button class="read-more-details-button lg:hidden" style="margin-bottom: -24px;margin-inline: -28px;margin-top: 12px;background: #EDF2F5;border: 1px solid #E4EBF0;border-radius: 0 0 4px 4px;">
                                                    <span>مشاهده بیشتر</span>
                                                </button>
                                            <?php } ?>
                                        </section>

                                        <?php if ( wp_is_mobile() ) {
                                            if ( $comment['reply'] ) { ?>
                                                <section class="mb-2 mb-5 p-4 rounded" style="background: #F3f9fc">
                                                    <p class="text-md font-bold text-black flex items-center gap-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14" viewBox="0 0 16 14" fill="none" class="mx-0">
                                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M5.70679 13.7072C5.89426 13.5197 5.99957 13.2654 5.99957 13.0002C5.99957 12.735 5.89426 12.4807 5.70679 12.2932L3.41379 10.0002H8.99979C10.8563 10.0002 12.6368 9.26272 13.9495 7.94996C15.2623 6.63721 15.9998 4.85673 15.9998 3.00021V1.00021C15.9998 0.734997 15.8944 0.480642 15.7069 0.293106C15.5194 0.10557 15.265 0.000213623 14.9998 0.000213623C14.7346 0.000213623 14.4802 0.10557 14.2927 0.293106C14.1051 0.480642 13.9998 0.734997 13.9998 1.00021V3.00021C13.9998 4.3263 13.473 5.59807 12.5353 6.53575C11.5976 7.47343 10.3259 8.00021 8.99979 8.00021H3.41379L5.70679 5.70721C5.8023 5.61497 5.87848 5.50462 5.93089 5.38262C5.9833 5.26061 6.01088 5.12939 6.01204 4.99661C6.01319 4.86384 5.98789 4.73216 5.93761 4.60926C5.88733 4.48636 5.81307 4.37471 5.71918 4.28082C5.62529 4.18693 5.51364 4.11267 5.39074 4.06239C5.26784 4.01211 5.13616 3.98681 5.00339 3.98796C4.87061 3.98912 4.73939 4.0167 4.61738 4.06911C4.49538 4.12152 4.38503 4.1977 4.29279 4.29321L0.292786 8.29321C0.105315 8.48074 0 8.73505 0 9.00021C0 9.26538 0.105315 9.51969 0.292786 9.70721L4.29279 13.7072C4.48031 13.8947 4.73462 14 4.99979 14C5.26495 14 5.51926 13.8947 5.70679 13.7072Z" fill="#889BAD"></path>
                                                        </svg>
                                                        پاسخ مجموعه
                                                    </p>
                                                    <div class="comment-content pr-6 py-2 border-r flex flex-col text-gray-500">
                                                        <?= $comment['reply']; ?>
                                                    </div>
                                                </section>
                                            <?php } else {
                                                if (
                                                    get_current_user_id() == get_post_meta( $product_id, 'user_ebtal', true ) ||
                                                    get_current_user_id() == get_post_meta( $product_id, 'sans_manager', true )
                                                ) {
                                                    ?>
                                                    <div class="flex justify-center mb-5">
                                                        <div class="flex">
                                                            <p class="reply-button text-[14px] font-bold text-[#3F7FF5] cursor-pointer flex items-center gap-2" data-target-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                                پاسخ به این دیدگاه
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="16" viewBox="0 0 15 16" fill="none">
                                                                    <path d="M5.625 10.125L2.5 7L5.625 3.875" stroke="#3F7FF5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                                    <path d="M12.5 10.75V9.5C12.5 8.83696 12.2366 8.20107 11.7678 7.73223C11.2989 7.26339 10.663 7 10 7H2.5" stroke="#3F7FF5" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                                </svg>
                                                            </p>
                                                            <p class="close-reply-button hidden text-[14px] font-bold  text-[#3F7FF5] cursor-pointer flex items-center gap-2" data-target-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                                بستن
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="10" viewBox="0 0 11 10" fill="none">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.50024 6.32601L8.81462 9.64039C8.99049 9.81626 9.22902 9.91506 9.47774 9.91506C9.72646 9.91506 9.96499 9.81626 10.1409 9.64039C10.3167 9.46452 10.4155 9.22598 10.4155 8.97726C10.4155 8.72854 10.3167 8.49001 10.1409 8.31414L6.82524 4.99976L10.1402 1.68539C10.2273 1.59831 10.2963 1.49493 10.3434 1.38117C10.3905 1.2674 10.4147 1.14548 10.4147 1.02236C10.4147 0.899231 10.3904 0.777317 10.3432 0.663576C10.2961 0.549835 10.227 0.446493 10.1399 0.359451C10.0528 0.272409 9.94947 0.203372 9.83571 0.156281C9.72194 0.10919 9.60002 0.0849678 9.47689 0.0849968C9.35377 0.0850258 9.23186 0.109306 9.11812 0.15645C9.00437 0.203595 8.90103 0.272681 8.81399 0.359764L5.50024 3.67414L2.18587 0.359764C2.09943 0.270183 1.99601 0.198714 1.88166 0.149528C1.7673 0.100341 1.6443 0.0744215 1.51982 0.0732815C1.39534 0.0721415 1.27188 0.0958038 1.15664 0.142888C1.0414 0.189972 0.936696 0.259535 0.84863 0.347517C0.760565 0.4355 0.690903 0.54014 0.643711 0.655333C0.596518 0.770525 0.572739 0.893963 0.573762 1.01844C0.574785 1.14292 0.600588 1.26595 0.649667 1.38036C0.698746 1.49476 0.770117 1.59824 0.859616 1.68476L4.17524 4.99976L0.860241 8.31476C0.770742 8.40129 0.699371 8.50477 0.650292 8.61917C0.601213 8.73357 0.57541 8.8566 0.574387 8.98108C0.573364 9.10556 0.597143 9.229 0.644336 9.34419C0.691528 9.45939 0.76119 9.56403 0.849255 9.65201C0.937321 9.73999 1.04203 9.80956 1.15726 9.85664C1.2725 9.90372 1.39596 9.92739 1.52044 9.92625C1.64492 9.92511 1.76793 9.89919 1.88228 9.85C1.99664 9.80081 2.10005 9.72934 2.18649 9.63976L5.50024 6.32601Z" fill="#3F7FF5"/>
                                                                </svg>
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="hidden mb-5" data-form="<?php echo esc_attr( $comment['id'] ) ?>">
                                                        <form method="post" class="submit-reply-form flex items-end gap-4">
                                                            <input type="hidden" name="product" value="<?php echo esc_attr( $product_id ); ?>">
                                                            <input type="hidden" name="comment" value="<?php echo esc_attr( $comment['id'] ); ?>">
                                                            <textarea name="comment_content" class="w-full min-h-full rounded-[14px] border border-[#E4EBF0] p-2 resize-y" rows="1" placeholder="پاسخ خود را اینجا بنویسید..."></textarea>
                                                            <button type="submit" class="btn rounded-2xl p-4 text-white mt-2" style="box-shadow: 0 2px 0 0 #CA5608; background: #FD7013;">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="17" viewBox="0 0 21 17" fill="none">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.6595 4.59923C20.8815 2.59379 19.428 0.0248262 17.0788 0.0393534L3.86266 0.119491C1.33133 0.134071 -0.044711 3.08501 1.57123 5.03349L10.0046 15.21C11.5035 17.019 14.4048 16.4807 15.1565 14.2559L16.5505 10.1306L9.19314 6.69977C8.95277 6.58768 8.76678 6.3847 8.67607 6.13548C8.58536 5.88626 8.59737 5.61121 8.70945 5.37084C8.82154 5.13047 9.02452 4.94448 9.27374 4.85377C9.52296 4.76306 9.79801 4.77507 10.0384 4.88715L17.3949 8.31755L19.6595 4.59923Z" fill="white"/>
                                                                </svg>
                                                            </button>
                                                        </form>
                                                    </div>
                                                <?php }
                                            }
                                        } ?>

                                        <div class="extra-line lg:hidden mb-5"></div>

                                    <?php } ?>

                                    <?php if ( $total_pages > 1 ) { ?>
                                        <div class="mb-9 flex w-full items-center justify-center gap-4">
                                            <div class="flex gap-4 max-lg:gap-2 justify-start max-lg:justify-center pagination">
                                                <?php echo paginate_links( [
                                                    'mid_size'  => 1,
                                                    'base'      => get_pagenum_link( 1 ) . '%_%',
                                                    'format'    => '?comment_page=%#%',
                                                    'current'   => 1,
                                                    'total'     => $total_pages,
                                                    'prev_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="7" height="13" viewBox="0 0 7 13" fill="none" class="rotate-180 opacity-25"><path d="M5.08008 11.1602L1.51062 7.14452C1.17384 6.76563 1.17384 6.19468 1.51062 5.81579L5.08008 1.80016" stroke="#0A184A" stroke-width="2" stroke-linecap="round"></path></svg>',
                                                    'next_text' => '<svg xmlns="http://www.w3.org/2000/svg" width="7" height="13" viewBox="0 0 7 13" fill="none"><path d="M5.08008 11.1602L1.51062 7.14452C1.17384 6.76563 1.17384 6.19468 1.51062 5.81579L5.08008 1.80016" stroke="#0A184A" stroke-width="2" stroke-linecap="round"></path></svg>',
                                                ] ); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>

                        </section>

                        <div class="bg-divided lg:hidden"></div>

                        <?php if ( is_user_logged_in() ): ?>
                            <div>
                                <section class="rounded-2xl border border-slate-120 px-8 shadow-12 max-lg:mb-0 max-lg:rounded-none max-lg:px-0 max-lg:shadow-none py-12 max-lg:border-0 max-lg:py-0 lg:my-10" id="ez-comment-form">
                                    <form class="w-full" method="post" id="send-comment">
                                        <div class="flex gap-8 max-lg:flex-col lg:gap-13">
                                            <div class="w-full">
                                                <div class="mb-3 flex items-center gap-7">
                                                    <h3 class="text-xl">ارسال دیدگاه</h3>
                                                    <span class="text-xs"> برای <?php echo $data['title'] ?></span>
                                                </div>
                                                <div class="">
                                                    <div class="relative">
                                                <textarea id="content" name="content" rows="15"
                                                          class="text-gray-900 block w-full rounded-2xl border-0 p-6 text-sm shadow-13 outline-none ring-1 ring-inset ring-gray-100 placeholder:text-slate-200 focus:shadow-none focus:ring-2 focus:ring-inset focus:ring-primary-500 max-lg:max-h-58 max-lg:bg-slate-60"
                                                          placeholder="لطفا نکات مثبت و منفی بازی را در این قسمت بنویسید..."
                                                          data-path="content"
                                                          style="resize: none"></textarea>
                                                    </div>
                                                </div>
                                                <button type="submit"
                                                        class="flex gap-4 w-1/2 max-lg:w-full items-center justify-center relative text-sm font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:bg-slate-110 disabled:text-[#ccc] disabled:cursor-not-allowed disabled:shadow-none bg-accent-450 text-white shadow-16 hover:bg-accent-500 focus-visible:outline-accent-500 h-16 px-9 py-2 rounded-2xl max-lg:rounded-lg max-lg:h-12 max-lg:min-w-12 max-lg:px-6 max-lg:py-1 mt-6 min-w-[258px] max-lg:hidden max-lg:w-full lg:text-lg lg:shadow-23">
                                                    <span class="truncate">ارســـال دیدگــاه</span>
                                                </button>
                                            </div>
                                            <div class="min-w-71">
                                                <?php if ( $product_type == 'اتاق فرار' ) { ?>
                                                    <div class="mb-4 last:mb-0 max-lg:flex max-lg:items-center max-lg:justify-between lg:mb-8">
                                                        <div class="flex items-center justify-between gap-2 lg:mb-3">
                                                            <h3 class="text-xs">فضاسازی</h3>
                                                        </div>
                                                        <div class="relative max-lg:[&_.overflow-x-auto]:pb-0.75">
                                                            <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                                                <div class="flex gap-2">
                                                                    <?php for ( $j = 1; $j <= 5; $j ++ ) { ?>
                                                                        <button type="button"
                                                                                class="text-nowrap transition-all duration-150 text-center font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap rounded-2xl bg-white text-slate-350 border border-gray-50 h-9 min-w-9 px-3 md:px-5 py-1 text-lg max-lg:rounded-md max-lg:text-slate-900 max-lg:shadow-13 lg:h-10 lg:py-2 lg:leading-4"
                                                                                data-rate="<?php echo $j * 20 ?>"
                                                                                data-rating-item="1094">
                                                                            <?php echo $j; ?>
                                                                        </button>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="mb-4 last:mb-0 max-lg:flex max-lg:items-center max-lg:justify-between lg:mb-8">
                                                        <div class="flex items-center justify-between gap-2 lg:mb-3">
                                                            <h3 class="text-xs">کیفیت معما</h3>
                                                        </div>
                                                        <div class="relative max-lg:[&_.overflow-x-auto]:pb-0.75">
                                                            <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                                                <div class="flex gap-2">
                                                                    <?php for ( $j = 1; $j <= 5; $j ++ ) { ?>
                                                                        <button type="button"
                                                                                class="text-nowrap transition-all duration-150 text-center font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap rounded-2xl bg-white text-slate-350 border border-gray-50 h-9 min-w-9 px-3 md:px-5 py-1 text-lg max-lg:rounded-md max-lg:text-slate-900 max-lg:shadow-13 lg:h-10 lg:py-2 lg:leading-4"
                                                                                data-rate="<?php echo $j * 20 ?>"
                                                                                data-rating-item="1095">
                                                                            <?php echo $j; ?>
                                                                        </button>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php } ?>

                                                <div class="mb-4 last:mb-0 max-lg:flex max-lg:items-center max-lg:justify-between lg:mb-8">
                                                    <div class="flex items-center justify-between gap-2 lg:mb-3">
                                                        <h3 class="text-xs">تازگی و خلاقیت</h3>
                                                    </div>
                                                    <div class="relative max-lg:[&_.overflow-x-auto]:pb-0.75">
                                                        <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                                            <div class="flex gap-2">
                                                                <?php for ( $j = 1; $j <= 5; $j ++ ) { ?>
                                                                    <button type="button"
                                                                            class="text-nowrap transition-all duration-150 text-center font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap rounded-2xl bg-white text-slate-350 border border-gray-50 h-9 min-w-9 px-3 md:px-5 py-1 text-lg max-lg:rounded-md max-lg:text-slate-900 max-lg:shadow-13 lg:h-10 lg:py-2 lg:leading-4"
                                                                            data-rate="<?php echo $j * 20 ?>"
                                                                            data-rating-item="1098">
                                                                        <?php echo $j; ?>
                                                                    </button>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <?php if ( $product_type == 'اتاق فرار' ) { ?>
                                                    <div class="mb-4 last:mb-0 max-lg:flex max-lg:items-center max-lg:justify-between lg:mb-8">
                                                        <div class="flex items-center justify-between gap-2 lg:mb-3">
                                                            <h3 class="text-xs">بازیگردانی و اکت</h3>
                                                        </div>
                                                        <div class="relative max-lg:[&_.overflow-x-auto]:pb-0.75">
                                                            <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                                                <div class="flex gap-2">
                                                                    <?php for ( $j = 1; $j <= 5; $j ++ ) { ?>
                                                                        <button type="button"
                                                                                class="text-nowrap transition-all duration-150 text-center font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap rounded-2xl bg-white text-slate-350 border border-gray-50 h-9 min-w-9 px-3 md:px-5 py-1 text-lg max-lg:rounded-md max-lg:text-slate-900 max-lg:shadow-13 lg:h-10 lg:py-2 lg:leading-4"
                                                                                data-rate="<?php echo $j * 20 ?>"
                                                                                data-rating-item="1096">
                                                                            <?php echo $j; ?>
                                                                        </button>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="mb-4 last:mb-0 max-lg:flex max-lg:items-center max-lg:justify-between lg:mb-8">
                                                        <div class="flex items-center justify-between gap-2 lg:mb-3">
                                                            <h3 class="text-xs">برخورد پرسنل</h3>
                                                        </div>
                                                        <div class="relative max-lg:[&_.overflow-x-auto]:pb-0.75">
                                                            <div class="scrollbar-hide overflow-x-auto transition-all duration-200">
                                                                <div class="flex gap-2">
                                                                    <?php for ( $j = 1; $j <= 5; $j ++ ) { ?>
                                                                        <button type="button"
                                                                                class="text-nowrap transition-all duration-150 text-center font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 flex-shrink-0 whitespace-nowrap rounded-2xl bg-white text-slate-350 border border-gray-50 h-9 min-w-9 px-3 md:px-5 py-1 text-lg max-lg:rounded-md max-lg:text-slate-900 max-lg:shadow-13 lg:h-10 lg:py-2 lg:leading-4"
                                                                                data-rate="<?php echo $j * 20 ?>"
                                                                                data-rating-item="1097">
                                                                            <?php echo $j; ?>
                                                                        </button>
                                                                    <?php } ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <button type="submit" class="flex gap-4 items-center justify-center relative font-semibold focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 transition-all duration-300 ease-in-out disabled:bg-slate-110 disabled:text-[#ccc] disabled:cursor-not-allowed disabled:shadow-none bg-accent-450 text-white hover:bg-accent-500 focus-visible:outline-accent-500 h-16 min-w-16 px-9 py-2 rounded-2xl mt-8 w-full text-lg shadow-23 lg:hidden">
                                            <span class="truncate">ارســـال دیدگــاه</span>
                                        </button>
                                    </form>
                                </section>
                            </div>
                        <?php endif; ?>

                    </div>

                    <?php if ( $data['brand_products']->products ): ?>
                        <section class="max-w-full py-4 md:py-5 lg:py-9 md:mt-7.5">
                            <div class="mb-6 md:mb-8">
                                <div class="flex justify-between">
                                    <div class="items-center gap-6 md:flex">
                                        <div class="flex items-center gap-4">
                                            <div class="mb-1 rounded md:rounded-xl text-primaryColor bg-primaryColor aspect-square flex items-center justify-center px-0.5 md:p-2 shadow-4 max-md:w-5 max-md:h-5">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="9" viewBox="0 0 17 9"
                                                     fill="none">
                                                    <path d="M14.9168 5.56397L14.9169 4.81397L14.1669 4.81385L12.5397 4.81359L11.7897 4.81347L11.7896 5.56347L11.7892 7.4979C11.7867 7.57881 11.7531 7.65527 11.6961 7.71146C11.638 7.76865 11.5603 7.80032 11.4798 7.80031C11.3993 7.8003 11.3217 7.7686 11.2636 7.71139C11.2066 7.65518 11.1731 7.57872 11.1705 7.49782L11.1708 5.56337L11.1709 4.81337L10.4209 4.81325L8.84163 4.81299L8.26025 4.8129L8.11522 5.3759C7.90262 6.20117 7.39731 6.91985 6.6946 7.39757C5.99195 7.87526 5.14 8.07939 4.29837 7.97207C3.45672 7.86474 2.68256 7.45323 2.1212 6.81409C1.5598 6.17488 1.24986 5.35193 1.25 4.49944C1.25014 3.64695 1.56033 2.8241 2.12194 2.18508C2.6835 1.54611 3.45779 1.13485 4.29947 1.02779C5.14113 0.920743 5.99302 1.12515 6.69552 1.60305C7.39808 2.081 7.90317 2.79984 8.1155 3.62518L8.26035 4.18823L8.84173 4.18832L15.2263 4.18934C15.2263 4.18934 15.2264 4.18934 15.2264 4.18934C15.3078 4.1894 15.3862 4.22182 15.4443 4.28016L15.9755 3.75066L15.4443 4.28016C15.5026 4.33858 15.5357 4.41823 15.5357 4.50173C15.5357 4.50177 15.5357 4.5018 15.5357 4.50184L15.5352 7.4985C15.5326 7.57941 15.4991 7.65587 15.442 7.71206L15.9684 8.24633L15.442 7.71207C15.384 7.76925 15.3063 7.80092 15.2258 7.80091C15.1453 7.8009 15.0677 7.7692 15.0096 7.712C14.9526 7.65578 14.9191 7.57931 14.9165 7.49841L14.9168 5.56397ZM4.73803 1.62501C3.97643 1.62488 3.2464 1.92818 2.70842 2.46749C2.17052 3.00673 1.86864 3.73772 1.86851 4.49954C1.86839 5.26136 2.17004 5.99245 2.70777 6.53186C3.24558 7.07134 3.97551 7.37487 4.73711 7.375C5.49871 7.37512 6.22874 7.07182 6.76671 6.53251C7.30462 5.99327 7.6065 5.26228 7.60662 4.50046C7.60674 3.73864 7.30509 3.00755 6.76736 2.46814C6.22956 1.92866 5.49963 1.62513 4.73803 1.62501Z"
                                                          fill="#09192D" stroke="white" stroke-width="1.5"/>
                                                </svg>
                                            </div>
                                            <h2 class="text-base font-bold md:text-lg">
                                                سایر بازی‌های
                                                <span class="text-2xs"><?= $data['brand']['title'] ?></span>
                                            </h2>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper products-carousel relative">
                                <div class="swiper-wrapper child:min-w-[156px] child:md:min-w-[200px] first:child:before:hidden child:before:w-px child:before:absolute child:before:bg-gradient-to-t child:before:from-white child:before:via-slate-110 child:before:to-white child:before:-right-3.5 child:lg:before:-right-6 child:before:h-full min-h-[200px] child:box-content lg:min-h-[300px]">
                                    <?= $data['brand_products']->products ?>
                                </div>
                                <button class="products-carousel-prev absolute right-0 max-lg:hidden top-1/2 -translate-y-1/2 rotate-180 z-50 cursor-pointer touch-manipulation appearance-none -mr-0.5"
                                        type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" fill="none" viewBox="0 0 30 113">
                                        <g clip-path="url(#arrow_aa)">
                                            <path fill="#BFCBD9" fill-rule="evenodd" d="M0 3.75c0 28.814 30 32.928 30 52.823 0 21.023-30 26.414-30 56.595V3.75Z" clip-rule="evenodd"></path>
                                            <path fill="#fff" fill-rule="evenodd" d="M0 1c0 28.814 27 33.679 27 53.573 0 21.022-27 23.914-27 54.094V1Z" clip-rule="evenodd"></path>
                                            <path fill="#9FB3CB" fill-rule="evenodd" d="m13.815 50.977.125.142c.387.51.334 1.232-.124 1.677l-3.098 3.037 3.098 3.037.125.141a1.273 1.273 0 0 1-.128 1.68 1.286 1.286 0 0 1-1.804-.003l-4.025-3.946-.126-.142a1.276 1.276 0 0 1 .126-1.676l4.025-3.946.147-.124a1.29 1.29 0 0 1 1.659.123Z" clip-rule="evenodd"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="arrow_aa">
                                                <path fill="#fff" d="M0 0h30v113H0z"></path>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </button>
                                <button class="products-carousel-next absolute left-0 max-lg:hidden top-1/2 -translate-y-1/2 z-50 cursor-pointer touch-manipulation appearance-none -ml-0.5"
                                        type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" fill="none" viewBox="0 0 30 113">
                                        <g clip-path="url(#arrow_aa)">
                                            <path fill="#BFCBD9" fill-rule="evenodd"
                                                  d="M0 3.75c0 28.814 30 32.928 30 52.823 0 21.023-30 26.414-30 56.595V3.75Z"
                                                  clip-rule="evenodd"></path>
                                            <path fill="#fff" fill-rule="evenodd"
                                                  d="M0 1c0 28.814 27 33.679 27 53.573 0 21.022-27 23.914-27 54.094V1Z"
                                                  clip-rule="evenodd"></path>
                                            <path fill="#9FB3CB" fill-rule="evenodd"
                                                  d="m13.815 50.977.125.142c.387.51.334 1.232-.124 1.677l-3.098 3.037 3.098 3.037.125.141a1.273 1.273 0 0 1-.128 1.68 1.286 1.286 0 0 1-1.804-.003l-4.025-3.946-.126-.142a1.276 1.276 0 0 1 .126-1.676l4.025-3.946.147-.124a1.29 1.29 0 0 1 1.659.123Z"
                                                  clip-rule="evenodd"></path>
                                        </g>
                                        <defs>
                                            <clipPath id="arrow_aa">
                                                <path fill="#fff" d="M0 0h30v113H0z"></path>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </button>
                            </div>
                        </section>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </section>

<?php get_footer(); ?>