<?php
/**
 * The Template for displaying all single posts.
 */

get_template_part( 'es', 'blogheader' ); ?>

    <!-- Back to top button -->
    <button
            type="button"
            class="btn btn-danger btn-floating btn-lg"
            id="btn-back-to-top"
    >
        <i class="fas fa-arrow-up"></i>
        <span class="backtext">
      برو بالا !
  </span>
    </button>
    <style>
        #btn-back-to-top {
            position: fixed;
            bottom: 20px;
            right: 20px;
            display: none;
        }
    </style>

    <script>
        let mybutton = document.getElementById("btn-back-to-top");

        window.onscroll = function () {
            scrollFunction();
        };

        function scrollFunction() {
            if (
                document.body.scrollTop > 20 ||
                document.documentElement.scrollTop > 20
            ) {
                mybutton.style.display = "block";
            } else {
                mybutton.style.display = "none";
            }
        }
        mybutton.addEventListener("click", backToTop);

        function backToTop() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }
    </script>
    <div class="container">
        <div class="row">
            <!-- Sidebar Blog A.A -->
            <style>
                /*  ES Breaccrumb */
                .esbreadcrumb a {
                    color:#fd7013;
                    font-size:12px;
                }
                .esbreadcrumb span{
                    color:#fff;
                    font-size:12px;
                }
                .esbreadcrumb a:hover{
                    color:#fd7013;
                }
                .esbreadcrumb a:after{
                    content: '\ea97';
                    color: #fd7013;
                    font-size: 8px;
                    font-family: 'icofont';
                    margin-left:5px;
                }
                .esbreadcrumb .brcat:after{
                    content: '\ea97';
                    color: #fd7013;
                    font-size: 8px;
                    font-family: 'icofont';
                    margin-right:5px;
                }
            </style>
            <div class="cbpost col-12 col-md-9">
                <div class="cont_principal">
                    <div class="cont_breadcrumbs">
                        <div id="zardkooh_breadcrumbs" class="woocommerce-breadcrumb cont_breadcrumbs_1 breadcrumb-trail" role="navigation" aria-label="Breadcrumbs" itemprop="breadcrumb">
                            <ul class="breadcrumb trail-items" itemscope itemtype="http://schema.org/BreadcrumbList" >
                                <meta name="numberOfItems" content="3" />
                                <meta name="itemListOrder" content="Ascending" />
                                <li typeof="WebPage" itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="trail-item trail-begin">
                                    <a itemprop="item" rel="home" href="https://escapezoom.ir" title="اتاق فرار">
                                        <span itemprop="name">اتاق فرار</span>
                                    </a>
                                    <meta itemprop="position" content="1" />
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="trail-item">
                                    <a itemprop="item" typeof="WebPage" href="https://escapezoom.ir/blog" title="مجله اسکیپ زوم">
                                        <span itemprop="name">مجله اسکیپ زوم</span>
                                    </a>
                                    <meta itemprop="position" content="2" />
                                </li>
                                <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="trail-item trail-end">
                <span itemprop="name" class="cpbtitle">
                    <?php the_title(); ?>
                </span>
                                    <meta itemprop="position" content="3" />
                                </li>
                            </ul>
                            <span class="cprw"><?php echo rmp_get_visual_rating(); ?></span>

                        </div>
                    </div>
                </div>

                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();

                        get_template_part( 'content', 'single' );

                        // If comments are open or we have at least one comment, load up the comment template.
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;
                    endwhile;
                endif;

                wp_reset_postdata();

                $count_posts = wp_count_posts();

                if ( $count_posts->publish > '1' ) :
                $next_post = get_next_post();
                $prev_post = get_previous_post();
                ?>
                <link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/blogpost.css?ver=2.65">

                <hr class="mt-5">
                <div class="row post-navigation d-flex justify-content-between">
                    <?php
                    if ( $prev_post ) {
                        $prev_title = get_the_title( $prev_post->ID );
                        $prev_img = get_the_post_thumbnail($prev_post->ID, 'large');
                        ?>
                        <div class="col-sm-6 col-12 pr-3">
                            <a class="previous-post btn btn-lg btn-outline-secondary" href="<?php echo esc_url( get_permalink( $prev_post->ID ) ); ?>" title="<?php echo esc_attr( $prev_title ); ?>">
                                <?php echo $prev_img ?>
                                <span class="title"><?php echo wp_kses_post( $prev_title ); ?></span>
                            </a>
                        </div>
                        <?php
                    }
                    if ( $next_post ) {
                        $next_title = get_the_title( $next_post->ID );
                        $next_img = get_the_post_thumbnail($next_post->ID, 'large');
                        ?>
                        <div class="col-sm-6 col-12 pl-3">
                            <a class="next-post btn btn-lg btn-outline-secondary" href="<?php echo esc_url( get_permalink( $next_post->ID ) ); ?>" title="<?php echo esc_attr( $next_title ); ?>">
                                <?php echo $next_img ?>
                                <span class="title"><?php echo wp_kses_post( $next_title ); ?></span>
                            </a>
                        </div>
                        <?php
                    }
                    ?>
                </div><!-- /.post-navigation -->

            </div><!-- cbpost -->


            <?php


            get_template_part( 'es', 'sidebar' );

            ?>
        </div>
    </div><!-- container -->


<?php
endif;

get_footer();
