<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;
?>
</div>
<div class="container-fluid main-warp">
    
    
    <style type="text/css">
.room-details>span{
    color:#fff;
}	

.room-details > span.name {
    padding-top: 5px;
    padding-left: 5px;
}


.cover-single-bg {
    background-image: linear-gradient(0deg,#444f5b 0,rgba(0,0,0,.22) 100%),url(<?php if ( get_field('room_cover')): ?> <?php echo get_field('room_cover')?> <?php else: ?> https://escapezoom.ir/wp-content/uploads/2020/11/cover.jpg <?php endif ?>);
    background-repeat: no-repeat;
    background-size: cover;
    width: 100%;
    min-height: 461px;
    margin-top: -17px;
}
	.name-place{
	        padding-top: 110px;
	}
	.pre-title{
	    color:#fff;
	    font-size:2.5em;
	    width: 100%;
	}
	.name-title{
	    color:#fff;
	    font-size:4em;
	    width: 100%;
	}

.singleroom-img{
    margin-top: -64px;
    position: absolute;
    margin-left: auto;
    margin-right: auto;
    
}

.brand-singleroom-img {
    margin-top: 173px;
    position: absolute;
    margin-right: -15px;
}
	.other-pages-content p {
    font-size: 14px;
    line-height: 2.5;
    color: #4f5761;
    width: 100%;
}
.singleroom-content{
    
    margin-top: 108px;
}

.room-details {
    background: #414a54;
    width: 500px;
    padding: 8px;
    position: absolute;
    box-shadow: 7px 9px 20px -8px #f8fbff;
    margin-top: 32px;
}

.mt-100{
    margin-top:100px;
}

</style>

<div class="cover-single-bg">


<div class="container">
  <div class=" name-place">
    <div class="row">
         <h2 class="pre-title">اتاق فرار</h2>
        <h1 class="name-title"><?php the_title();?></h1>
         </div>  
   
   
         <div class="row room-details">
       <img src="https://escapezoom.ir/wp-content/uploads/2020/12/player-number.png">
        <span class="name"><?php the_field("room_tedad");?> تعداد نفرات</span>
         &nbsp
        
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/timer.png">
        <span class="name"><?php the_field("room_duration");?> دقیقه</span>
        
        &nbsp
        
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/key-on.png">
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/key-on.png">
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/key-off-1.png">
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/key-off-1.png">
       
        &nbsp
        
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/scary.png">
        <span class="name">80 درصد</span>
        
        
                &nbsp
        
               <img src="https://escapezoom.ir/wp-content/uploads/2020/12/scary.png">
        <span class="name">80 درصد</span>
        
        
       </div>  
      
         
  

        <div class="row">
            <div class="col-xs-12 col-md 2"> 
            <div class="brand-singleroom">
                <a  href="https://escapezoom.ir/product-brands/xescape/">
                   
                    <img  class="brand-singleroom-img" alt="ایکس اسکیپ" src="https://escapezoom.ir/wp-content/uploads/2020/11/xescape.png" width="160" height="160">
                </a>
                
                
                
                <?php
                $product_id  = get_the_id();
$product     = wc_get_product( $product_id );

$taxonomy    = `product_brand`;
 $brand_names = wp_get_post_terms( $product_id, $taxonomy, array( 'fields' => 'names' ) );

// Get the brand name
print_r($brand_names);

                ?>
                
                
                
            </div>
            </div>

            <div class="col-xs-12 col-md 6">  </div>

        <div class="col-xs-12 col-md 4 "> <img class="img-fluid mx-auto d-block <?php if (!wp_is_mobile()): ?>singleroom-img<?php endif ?> " src="<?php echo  get_the_post_thumbnail_url();?>"> </div>
        
        </div>
      
      </div>    
 </div>

</div>

    </div>


<div class="container mt-100">
    
<?php
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */

global $product, $zardkooh_options;

do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<?php if ( !zardkooh_is_mobile() ) { ?>	
			<div class="product-page">
				<div class="single-product-right-box">
                    <div class="single-product-right-box-content">
                        <div class="summary entry-summary white-box">
                            <?php do_action( 'zardkooh_single_product_side_header_top' ); ?>

                            <div class="product-page-header">
                                <h1>
                                    <span><?php echo get_post_meta ($product->get_id(), 'product_english_name', true); ?></span>
                                    <?php the_title(); ?>
                                </h1>

                                <?php echo zardkooh_single_product_tags(); ?>
                            </div>

                            <div class="product-page-side-cart">
                                <?php
                                    /**
                                     * Hook: woocommerce_single_product_summary.
                                     *
                                     * @hooked woocommerce_template_single_title - 5
                                     * @hooked woocommerce_template_single_rating - 10
                                     * @hooked woocommerce_template_single_price - 10
                                     * @hooked woocommerce_template_single_excerpt - 20
                                     * @hooked woocommerce_template_single_add_to_cart - 30
                                     * @hooked woocommerce_template_single_meta - 40
                                     * @hooked woocommerce_template_single_sharing - 50
                                     * @hooked WC_Structured_Data::generate_product_data() - 60
                                     */
                                    do_action( 'woocommerce_single_product_summary' );
                                ?>
                            </div>
                        </div>
                        <?php
                            /**
                             * Hook: woocommerce_single_product_summary.
                             *
                             * @hooked zardkooh_single_inventory - 5
                             * @hooked zardkooh_single_experts - 10
                             */
                            do_action( 'zardkooh_single_product_side' );
                        ?>
                    </div>
				</div>
				<div class="single-product-center-box">
					<div class="single-product-image white-box">
					<?php
						do_action( 'woocommerce_before_single_product_image' );
						/**
						 * Hook: woocommerce_before_single_product_summary.
						 *
						 * @hooked woocommerce_show_product_sale_flash - 10
						 * @hooked woocommerce_show_product_images - 20
						 */
						do_action( 'woocommerce_before_single_product_summary' );
					?>
					</div>
					
					<?php
						/**
						 * Hook: woocommerce_after_single_product_summary.
						 *
						 * @hooked woocommerce_output_product_data_tabs - 10
						 * @hooked woocommerce_upsell_display - 15
						 * @hooked woocommerce_output_related_products - 20
						 */
						do_action( 'woocommerce_after_single_product_summary' );
					?>
				</div>
				
				<?php do_action( 'zardkooh_single_product_sticky_menu' ); ?>

			</div>
		
	<?php } else { ?>

			<div class="product-page">
				<div class="single-product-right-box">
					
					<div class="summary entry-summary white-box">
						<?php do_action( 'zardkooh_single_product_side_header_top' ); ?>
					
						<div class="product-page-header">
							<h1>
								<span><?php echo get_post_meta ($product->get_id(), 'product_english_name', true); ?></span>
								<?php the_title(); ?>
							</h1>
							
							<?php
								do_action( 'woocommerce_before_single_product_image' );
								/**
								 * Hook: woocommerce_before_single_product_summary.
								 *
								 * @hooked woocommerce_show_product_sale_flash - 10
								 * @hooked woocommerce_show_product_images - 20
								 */
								do_action( 'woocommerce_before_single_product_summary' );
							?>
						
							<?php echo zardkooh_single_product_tags(); ?>
						</div>
						
						<div class="product-page-side-cart">
							<?php
								/**
								 * Hook: woocommerce_single_product_summary.
								 *
								 * @hooked woocommerce_template_single_title - 5
								 * @hooked woocommerce_template_single_rating - 10
								 * @hooked woocommerce_template_single_price - 10
								 * @hooked woocommerce_template_single_excerpt - 20
								 * @hooked woocommerce_template_single_add_to_cart - 30
								 * @hooked woocommerce_template_single_meta - 40
								 * @hooked woocommerce_template_single_sharing - 50
								 * @hooked WC_Structured_Data::generate_product_data() - 60
								 */
								do_action( 'woocommerce_single_product_summary' );
							?>
						</div>
					</div>
					
					<?php
						/**
						 * Hook: woocommerce_single_product_summary.
						 *
						 * @hooked zardkooh_single_inventory - 5
						 * @hooked zardkooh_single_experts - 10
						 */
						do_action( 'zardkooh_single_product_side' );
					?>
				</div>
				<div class="single-product-center-box">
					<?php
						/**
						 * Hook: woocommerce_after_single_product_summary.
						 *
						 * @hooked woocommerce_output_product_data_tabs - 10
						 * @hooked woocommerce_upsell_display - 15
						 * @hooked woocommerce_output_related_products - 20
						 */
						do_action( 'woocommerce_after_single_product_summary' );
					?>
				</div>
				
			</div>
	<?php } ?>
	
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>