<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<style>

.img-arc-mobile{
  height:auto;
  width:100%;
  max-width:80px!important;
}

.arc-box-mobile{
  border:1px solid #eee;
    margin:10px;
  width:100%;
  border-radius:3px
  position: relative;
}

.arc-mobile-footer{
  margin-top: -13px;
}
 


.arc-mobile-loc,.arc-mobile-price,.arc-mobile-nafar,.arc-mobile-time{
  font-size:10px;
    font-weight: 400;
  text-align: cente;
}
.arc-mobile-title{
  font-size: 1em;
  margin-right: -7px;
      font-weight: 800;
}

  
  h5 { font-size: 14px; padding: 10px; }
  .arc-mobile-btn { font-size: 10px; height: 25px; width: calc(100% - 29px); margin-left: 30px!important; }

.swiper-wrapper{height:auto!important}

 a.btn.btn-light.m-2 { width: 59px; }
 @media only screen and (max-width: 600px) {span.special-escapezooms {margin-top: 86px; right: 74px;} span.shakes { right: 63px; margin-top: 86px; } }
 
</style>
<div class="container">
    <div class="row">
              <div class="arc-box-mobile position-relative bg-fff">
           <div class="media">
             <a href="<?php echo the_permalink(get_the_ID());?>"><img class="ml-3 img-arc-mobile" src="<?php echo get_the_post_thumbnail_url();?>" />
                <?php if (get_field( "special_room" )): ?>
    			<span class="sp-esmb">AD</span>
                 <?php elseif (get_field( "shakes_room" )): ?>
    			<span class="shakes">شاخص</span>
                <?php endif ?>
             </a>
                <div class="media-body">
                    <a href="<?php echo the_permalink(get_the_ID());?>"><h2 class="mt-0 py-2 arc-mobile-title"><?php echo the_title();?></h2></a>
                    <div class="row py-1">
                        <div class="col-3 p-0 pr-2">
                            <span class="arc-mobile-time"><?php the_field( "room_duration",get_the_ID());?> دقیقه</span>
                        </div>
                        <div class="col-4 p-0 pr-2">
                            <span class="arc-mobile-nafar"><?php the_field("room_tedad");?></span>
                        </div>
                        <div class="col-4 p-0">
                            <span class="arc-mobile-loc"><?php global $post, $product; $categ = $product->get_categories(); echo strip_tags($categ); ?> - <?=get_field( "room_loc",get_the_ID());?></span>
                        </div>
                    </div>
                    <div class="row arc-mobile-footer">
                        <div class="col-6 mt-4 arc-mobile-loc px-0 pr-2">
                            <span class="arc-mobile-price">هر نفر <?php echo number_format((float)get_field("price_asli"));?> تومان</span>
                        </div>
                        <div class="col-6 mt-3">
                            <a class="btn btn-success arc-mobile-btn" href="<?php echo the_permalink(get_the_ID());?>">

                              <?php 
                                  if (get_field("sale_active")=="1") {
                                      echo 'رزرو آنلاین';
                                  } else {
                                      echo 'مشاهده';
                                  }

								?>
                              
                              
                          </a>
                          
                            <?php
$randd=rand(1 , 12); 
$shakes_room=get_field(  "shakes_room" ,$product->get_id() );
$special_room=get_field( "special_room" ,$product->get_id() );

if($shakes_room==null || $shakes_room==0){
		update_field('shakes_room', 0,$product->get_id());
}
if($shakes_room>0){
	update_field('shakes_room', $randd,$product->get_id());
}

if($special_room==null || $special_room==0){
		update_field('special_room', 0,$product->get_id());
}
if($special_room>0){
	update_field('special_room', $randd,$product->get_id());
}?>

                        </div>
                    </div>
                </div>
            </div>
                <?php if(!get_field('sale_active',$product->get_id())){ ?>
                    <div class="overview">
                        <span class="m-0">رزرو غیرفعال</span>
                    </div>
               <?php } ?>
        </div>
    
   
    </div>
</div>
