<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' ); ?>

    <link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/newstyle2.css?v=1.114">

    <style>
        .esbreadcrumb:nth-child(1) {
            display: none;
        }
        .swiper-container { background-color: transparent!important;}
        li.product { max-height: 249px; }
        woocommerce .products ul, .woocommerce ul.products {
            background-color: transparent!important;
        }
        .intro {
            font-size: 16px;
            max-width: 500px;
            margin: 0 auto
        }
        .intro p {
            margin-bottom: 0
        }
        .people {
            padding: 50px 0;
            cursor: pointer
        }
        .item-rooms {
            margin-bottom: 20px;
            border: 1px solid #bdbdbd;
            border-radius: 10px;
        }
        .item-rooms .box-rooms {
            text-align: center;
            background-repeat: no-repeat;
            background-size: 100% 100%!important;
            background-position: center;
            height: 180px;
            position: relative;
            overflow: hidden
        }
        .item-rooms .cover-room {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.75);
            transition: opacity 0.15s ease-in;
            opacity: 0;
            padding-top: 32px;
            color: #fff;
            text-shadow: 1px 1px 1px rgb(0 0 0 / 15%);
        }
        .item-rooms:hover .cover-room {
            opacity: 1
        }
        .item-rooms.zhanr {
            position: absolute;
            font-size: xx-small;
            background-color: unset!important;
            width: 157px;
            text-align: right;
            padding-right: 30px;
            opacity:0;
        }
        ul.zhanr>li {
            display: inline-block;
            width: 45%;
            font-size: x-small;
            text-align: center;
        }
        ul.zhanr>li.tedad , ul.zhanr>li.price {
            display: block;
            text-align: center;
            width: 100%;
            padding-top: 15px;
        }
        .cover-room .price {
            display: block!important;
        }
        .item-rooms.price {
            text-align: center;
        }
        .item-rooms.tedad {
            position:absolute;
            display: block;
            margin-top:-100px;
            text-align:center;
            width:162px;
            font-size:small;
            color: #101112;
        }
        .rb-title{
            color: #272727;
            padding-right:5px;
            background:#fff;
            display:block;
            padding-top:5px;
        }
        .rb-roomfooter>div{
            width:auto;
            display: block;
            min-height: 35px;
        }
        .rb-roomfooter {
            height: 41px;
            border-top:1px dotted #eee;
            padding-top: 5px;
            background:#fff;
        }
        .rb-time{
            color:#272727;
            font-size: x-small !important;
            vertical-align:middle;
            padding-right: 4px;
            padding-top: 10px;
            float: right;
            padding-right: 7px;
            color: #4a5f73;
        }
        .rb-left{
            float: left;
        }
        .rb-left>.mahal{
            color:#4a5f73;
            font-size: x-small !important;
            display: block;
            text-align:left;
            padding-left: 15px;
            font-weight: 100;
        }
        .rb-left>.shahr{
            color:#4a5f73;
            font-size: x-small !important;
            display: block;
            text-align:left;
            padding-left: 15px;
            font-weight: 100;
        }
        .product-cat-description { margin-top: 0!important; }
        .rb-roomfooter { height: 43px; border-top: 1px dotted #eee; padding-top: 5px; background: #fff;  }
        div#swiper-wrapper-461892e7cd6665b5 {
            left: 40%;
        }
        .shakes-title:before {
            content: "\E93B";
            margin-left: 10px;
            color: #fd7013;
            font-size: 8px;
            display: inline-block;
            font-family: 'Zardkooh';
        }
        .ez-tag-title,.shakes-title {
            display: inline-block;
            font-size: 14px!important;
            font-weight: 700;
            padding-bottom: 10px;
        }
        .woocommerce ul.products.columns-6 li.product, .woocommerce-page ul.products.columns-6 li.product { width: 13.5%; max-width: 160px!important; }
        .old-slider{
            display:none;
        }
        #product_list_mobile_get_res_btn {
            background: green;
            color: #fff;
            width: 100%;
            text-align: center;
            padding: 10px;
            position: fixed;
            bottom: 0;
            display: none;
        }
        @media (max-width: 768px) {
            #product_list_mobile_get_res_btn {
                display: block;
            }
        }
        div#elite_page_rooms_wrapper {
            background: #f3f3f3;
            padding: 20px 10px 0px 10px;
            border: 1px solid #e3e2e2;
            border-radius: 8px;
            margin: 20px 0;
        }
        #elite_page_rooms_wrapper .products {
            margin: 0;
        }
    </style>

    <!-- new tag and cat slider -->
<?php
$term_id = get_queried_object()->term_id;
$post_id = 'product_cat_'.$term_id;
$post_object = get_field('slider_new1', $post_id);
if( $post_object ):

    $post = $post_object ;
    echo do_shortcode($post_object); // change the shortcode here
    setup_postdata($post); ?>

    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly

endif;



//if ( str_contains($_SERVER['HTTP_REFERER'], 'google') && str_contains($_SERVER['HTTP_REFERER'], 'utm_medium') ) :
if ( str_contains($_SERVER['HTTP_REFERER'], 'google') ) : ?>

    <script>
        jQuery(document).ready(function($){

            $.getJSON("https://api.ipify.org/?format=json", function(e) {
                $('<input type="hidden" id="user_ip">').val(e.ip).appendTo('body');
            });

            var temp = setInterval(function() {
                if ($('#user_ip').length) {

                    $.ajax({
                        type: 'POST',
                        url: 'https://' + location.hostname + '/web-service/web-service.php',
                        data: {
                            "async": false,
                            "type": "cpc_tracking",
                            "data": {
                                'ip'    : $('#user_ip').val(),
                                "ref"   : '<?php echo $_SERVER['HTTP_REFERER'] ?>',
                            }
                        },
                        dataType: "json",
                        success: function(data) {

                        },
                    });
                    clearInterval(temp);
                }
            }, 10);
        });
    </script>

<?php
endif; ?>

    <!-- new tag and cat slider -->
    <div class="container">
        <div class="shop-page-row">
            <div class="shop-main-panel">
                <style>
                    @media (min-width: 768px) {
                        .shop-page-products{
                            float:left;
                        }
                        .shop-filters-panel{
                            float:right;
                        }
                    }
                    @media (max-width: 594px) {
                        .shop-main-panel{
                            margin-right: 0!important;
                        }
                    }
                </style>

                <?php
                $current_archive_obj = get_queried_object();
                $term_type = $current_archive_obj->taxonomy;

                if ( $current_archive_obj->parent == 0 )
                    $product_type = get_term( $current_archive_obj )->name;
                else
                    $product_type = get_term( $current_archive_obj->parent )->name;

                if ( $term_type == 'product_tag' ) { ?>

                    <div class="shop-filters-panel col-md-3 order-md-first col-sm-12 order-sm-last">
                        <div class="filter-panel-col">
                            <?php get_template_part('inc/template/categories_filters', '');  ?>
                        </div>
                    </div>

                    <div class="shop-page-products col-md-8 col-sm-12">
                        <div class="shop-page-breadcrumb-row">
                            <?php woocommerce_breadcrumb(); ?>
                        </div>

                        <?php
                        $elite_products = get_term_meta($current_archive_obj->term_id, 'rooms_cat_elite', true);
                        if (!empty($elite_products)) : ?>

                            <?php
                            $elite_products = get_term_meta($current_archive_obj->term_id, 'rooms_cat_elite', true);

                            $args = array (
                                'post_type' => 'product',
                                'post__in'  => $elite_products
                            );
                            $brand_products = get_posts( $args ); ?>

                            <div class="row" id="elite_page_rooms_wrapper">
                                <div class="col">
                                    <ul class="products shop-page-itemsx columns-5" >
                                        <?php
                                        foreach ( $brand_products as $product ) :
                                            $min_price = get_post_meta($product->ID, 'min_price', TRUE);

                                            preg_match_all('/\d+/', get_field("room_tedad", $product->ID), $matches); // get numbers from string
                                            $count_min  = min($matches[0]);
                                            $count_max  = max($matches[0]); ?>

                                            <li data-filter-item
                                                data-filter-name="<?php echo $product->post_title; ?>"
                                                class='<?php echo "product type-product post-$product->ID status-publish instock has-post-thumbnail shipping-taxable purchasable product-type-simple" ?>'
                                                data-id=<?php echo $product->ID; ?>>

                                                <div class=" item-rooms " onclick="location.href='<?php echo get_permalink($product->ID) ?>';" style="cursor:pointer;">
                                                    <div class="box-rooms" style="background-image:url(<?php echo wp_get_attachment_image_src( get_post_thumbnail_id( $product->ID ), 'single-post-thumbnail' )[0]; ?>)">
                                                        <span class="special-escapezooms">AD</span>

                                                        <?php
                                                        if (get_field('sale_active', $product->ID)) { ?>
                                                            <div class="cover-room">
                                                                <ul class="zhanr">
                                                                    <?php
                                                                    foreach (get_the_terms($product->ID, 'product_tag') as $product_tag) {
                                                                        if (str_contains($product_tag->name, '|||||'))
                                                                            $product_tag_name = str_replace('|||||', '', $product_tag->name); 
                                                                        else
                                                                            $product_tag_name = $product_tag->name; ?>
                                                                            
                                                                        <li><a class="c-fff" href="<?php echo get_permalink($product->ID); ?>"><?php echo $product_tag_name; ?></a></li>
                                                                    <?php
                                                                    } ?>

                                                                    <li class="tedad ">
                                                                        <a class="c-fff" href="<?php echo get_permalink($product->ID); ?>"><?php echo "$count_min تا $count_max نفر " ?></a>
                                                                    </li>
                                                                    <li class="price ">
                                                                        <a href="<?php echo get_permalink($product->ID); ?>" class="c-fff">قیمت از <?php echo number_format(!empty( $min_price ) ? $min_price : get_field("price_asli", $product->ID)); ?>تومان</a>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <?php
                                                        } ?>

                                                    </div>

                                                    <a href="<?php echo get_permalink($product->ID); ?>">
                                                        <span class="rb-title"><?php echo $product->post_title; ?></span>
                                                        <div class="rb-roomfooter">
                                                            <div class="rb-time">
                                                                <?php
                                                                $room_duration = get_field("room_duration", $product->ID);
                                                                if ($room_duration)
                                                                    echo $room_duration . ' ' . 'دقیقه';
                                                                else
                                                                    echo 'بزودی'; ?>
                                                            </div>

                                                            <div class="rb-left">
                                                                <span class="mahal"><?php echo get_field("room_loc", $product->ID); ?></span>
                                                                <span class="shahr"><?php echo get_the_terms($product->ID, 'product_cat')[0]->name; ?></span>
                                                            </div>
                                                        </div>
                                                    </a>

                                                    <?php
                                                    if (!(get_field('sale_active', $product->ID))) { ?>
                                                        <div class="overview"><span>رزرو غیرفعال</span></div>
                                                        <?php
                                                    } ?>
                                                </div>
                                            </li>

                                        <?php
                                        endforeach; ?>
                                    </ul>
                                </div>
                            </div>

                        <?php
                        endif; ?>

                        <?php elite_rooms_of_tehran_func3('complete'); ?>
                    </div>

                    <?php
                } else if ( $term_type == 'product_cat' ) { ?>

                    <div class="shop-page-products col-md-12 col-sm-12">
                        <div class="shop-page-breadcrumb-row">
                            <?php woocommerce_breadcrumb(); ?>
                        </div>

                        <?php ez_product_cat_sliders(); ?>
                    </div>

                    <?php
                    if (!wp_is_mobile()) {
                        if ( $product_type == 'اتاق فرار' ) : ?>
                            <div class="shop-page-products col-md-12 col-sm-12" id="single_product_sansyab_top_desc">
                                <p>چطور یه اتاق فرار مناسب انتخاب کنم؟</p>
                                برای رزرو یه اتاق فرار مناسب باید به سطح سختی، تعداد نفرات، ژانر، رده سنی، کامنت‌های پلیرهای قبلی و امتیاز مشتریان توجه کنید. درجه سختی یه بازی، میزان دشواری معماها و گیم‌پلی اون رو نشون می‌ده و واضحه که معیاری واسۀ سنجش ترس یه اتاق فرار نیست. اگه تجربۀ زیادی توی بازی اسکیپ روم ندارید، پیشنهاد می‌کنیم اتاق فرارهایی با سطح سختی 1 یا 2 کلید رو انتخاب کنید. برای پیدا کردن راحت و سریع بازی مناسب خودتون، می‌تونید از فیلترهای سانس‌یاب توی همین صفحه استفاده کنید.
                            </div>
                        <?php
                        elseif ( $product_type == 'سینما ترس' ) : ?>

                            <div class="shop-page-products col-md-12 col-sm-12" id="single_product_sansyab_top_desc">
                                <p>چطور یه سینما ترس مناسب انتخاب کنم؟</p>
برای رزرو یه سینما ترس یا سینما وحشت مناسب باید به تعداد نفرات، ساعت پخش فیلم، رده سنی، کامنت‌ها و امتیاز مشتریان توجه کنید. برای پیدا کردن راحت و سریع سینما ترس مناسب خودتون، می‌تونید از فیلترهای سانس‌یاب توی همین صفحه استفاده کنید.
                            </div>

                        <?php
                        endif;
                    } ?>

                    <div class="shop-filters-panel col-md-3 order-md-first col-sm-12 order-sm-last" style="margin-top: 50px">
                        <div class="filter-panel-col">
                            <?php
                            if (!wp_is_mobile())
                                get_template_part('inc/template/categories_filters', ''); ?>
                        </div>
                    </div>

                    <div id="product_list_resultof_sansyab" class="shop-page-products col-md-9 col-sm-12">
                        <?php elite_rooms_of_tehran_func3('partial'); ?>
                    </div>

                    <div class="shop-page-products col-md-12 col-sm-12" id="single_product_sansyab_top_desc">
                        <?php get_deactivated_rooms(); ?>
                    </div>

                    <?php
                } else if ( $term_type == 'yith_product_brand' ) {

                    $brand_img_id = get_term_meta($current_archive_obj->term_id, 'thumbnail_id', true);
                    if ($brand_img_id > 0)
                        $brand_img_src = wp_get_attachment_image_src($brand_img_id, 'full');
                    else
                        $brand_img_src = home_url('/wp-content/themes/escapezoom-v1/img/es-footer.png');

                    $args = array (
                        "post_type"     => "product",
                        "posts_per_page"=> -1,
                        "tax_query"     => array (
                            array (
                                "taxonomy" => "yith_product_brand",
                                "field"    => "term_id",
                                "terms"    => $current_archive_obj->term_id
                            )
                        )
                    );
                    $brand_products = get_posts( $args ); ?>

                    <style>
                        #brand_page_details_wrapper, #brand_page_rooms_wrapper {
                            background: #f2f2f2;
                            padding: 20px 10px;
                            border-radius: 20px;
                            text-align: justify;
                            display: flex;
                            box-shadow: 3px 3px 7px #ddd;
                            margin: 20px 0;
                        }
                        div#brand_page_img img {
                            border-radius: 20px;
                            width: 100% !important;
                        }
                        #brand_page_text_wrapper .term-description {
                            line-height: 35px;
                        }
                        h1#brand_page_text_title {
                            font-size: 24px;
                            font-weight: bold;
                            margin-bottom: 20px;
                        }
                        @media only screen and (max-width: 800px) {
                            #brand_page_details_wrapper {
                                display: flex;
                                flex-direction: column-reverse;
                            }
                            #brand_page_details_wrapper {
                                padding: 10px;
                            }
                            div#brand_page_img img {
                                margin-bottom: 40px;
                                margin-top: 10px;
                            }
                        }
                    </style>

                    <div class="container">
                        <div class="row" id="brand_page_details_wrapper">
                            <div class="col-md-9">
                                <div id="brand_page_text_wrapper">
                                    <h1 id="brand_page_text_title"><?php echo $current_archive_obj->name ?></h1>
                                    <p id="brand_page_text_desc"><?php do_action( 'woocommerce_archive_description' ); ?></p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div id="brand_page_img"><img src="<?php echo $brand_img_src[0] ?>"></div>
                            </div>
                        </div>
                        <div class="row" id="brand_page_rooms_wrapper">
                            <div class="col">
                                <ul class="products shop-page-items columns-5" >
                                    <?php
                                    foreach ( $brand_products as $product ) :
                                        $min_price = get_post_meta($product->ID, 'min_price', TRUE);

                                        preg_match_all('/\d+/', get_field("room_tedad", $product->ID), $matches); // get numbers from string
                                        $count_min  = min($matches[0]);
                                        $count_max  = max($matches[0]); ?>

                                        <li data-filter-item
                                            data-filter-name="<?php echo $product->post_title; ?>"
                                            class='<?php echo "product type-product post-$product->ID status-publish instock has-post-thumbnail shipping-taxable purchasable product-type-simple" ?>'
                                            data-id=<?php echo $product->ID; ?>>

                                            <div class=" item-rooms " onclick="location.href='<?php echo $product->guide ?>';" style="cursor:pointer;">
                                                <div class="box-rooms" style="background-image:url(<?php echo wp_get_attachment_image_src( get_post_thumbnail_id( $product->ID ), 'single-post-thumbnail' )[0]; ?>)">

                                                    <?php
                                                    if (get_field('sale_active', $product->ID)) { ?>
                                                        <div class="cover-room">
                                                            <ul class="zhanr">
                                                                <?php
                                                                foreach (get_the_terms($product->ID, 'product_tag') as $product_tag) { ?>
                                                                    <li><a class="c-fff" href="<?php echo get_permalink($product); ?>"><?php echo $product_tag->name; ?></a></li>
                                                                <?php } ?>

                                                                <li class="tedad ">
                                                                    <a class="c-fff" href="<?php echo get_permalink($product); ?>"><?php echo "$count_min تا $count_max نفر " ?></a>
                                                                </li>
                                                                <li class="price ">
                                                                    <a href="<?php echo get_permalink($product); ?>" class="c-fff">قیمت از <?php echo number_format(!empty( $min_price ) ? $min_price : get_field("price_asli", $product->ID)); ?>تومان</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <?php
                                                    } ?>

                                                </div>

                                                <a href="<?php echo get_permalink($product); ?>">
                                                    <span class="rb-title"><?php echo $product->post_title; ?></span>
                                                    <div class="rb-roomfooter">
                                                        <div class="rb-time">
                                                            <?php
                                                            $room_duration = get_field("room_duration", $product->ID);
                                                            if ($room_duration)
                                                                echo $room_duration . ' ' . 'دقیقه';
                                                            else
                                                                echo 'بزودی'; ?>
                                                        </div>

                                                        <div class="rb-left">
                                                            <span class="mahal"><?php echo get_field("room_loc", $product->ID); ?></span>
                                                            <span class="shahr"><?php echo get_the_terms($product->ID, 'product_cat')[0]->name; ?></span>
                                                        </div>
                                                    </div>
                                                </a>

                                                <?php
                                                if (!(get_field('sale_active', $product->ID))) { ?>
                                                    <div class="overview"><span>رزرو غیرفعال</span></div>
                                                    <?php
                                                } ?>
                                            </div>
                                        </li>

                                    <?php
                                    endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php
                } ?>

            </div>
        </div>
    </div>

<?php
if ( $term_type == 'product_cat' || $term_type == 'product_tag' ) : ?>
    <div class="container">
        <div class="product-cat-description descmo">
            <div class="description-text">
                <?php
                do_action( 'woocommerce_archive_description' ); ?>
            </div>
        </div>
    </div>
<?php
endif; ?>

<?php get_template_part( 'es', 'footeres' ); ?>

<?php
wp_footer();

