<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

if ( get_current_user_id() == 3325 && 0 ) :


do_action( 'woocommerce_before_checkout_form', $checkout );

// If checkout registration is disabled and not logged in, the user cannot checkout.
if ( ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in() ) {
    echo esc_html( apply_filters( 'woocommerce_checkout_must_be_logged_in_message', __( 'You must be logged in to checkout.', 'woocommerce' ) ) );
    return;
}

?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url( wc_get_checkout_url() ); ?>" enctype="multipart/form-data">

    <?php if ( $checkout->get_checkout_fields() ) : ?>

        <?php do_action( 'woocommerce_checkout_before_customer_details' ); ?>

        <div class="col2-set" id="customer_details">
            <div class="col-1">
                <?php do_action( 'woocommerce_checkout_billing' ); ?>
            </div>

            <div class="col-2">
                <?php do_action( 'woocommerce_checkout_shipping' ); ?>
            </div>
        </div>

        <?php do_action( 'woocommerce_checkout_after_customer_details' ); ?>

    <?php endif; ?>

    <?php do_action( 'woocommerce_checkout_before_order_review_heading' ); ?>

    <h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'woocommerce' ); ?></h3>

    <?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

    <div id="order_review" class="woocommerce-checkout-review-order">
        <?php do_action( 'woocommerce_checkout_order_review' ); ?>
    </div>

    <?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

</form>

<?php do_action( 'woocommerce_after_checkout_form', $checkout ); ?>

<?php
endif;
?>











<?php if (wp_is_mobile()) { ?>
    <link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/es-checkoutmob.css">

<?php } else { ?>
    <link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/es-checkout.css">

<?php } ?>


<link rel="stylesheet" href="https://escapezoom.ir/wp-content/themes/escapezoom-v1/css/es-checkout.css">

<style>
    .woocommerce-message {
        display: none !important;
    }
    #billing_phone {
        direction: ltr;
        text-align: left;
    }
    p.oops-res {
        width: 100%;
        text-align: center;
        font-size: 1.4em;
        padding: 1em;
    }

    img.oops-img {
        display: block;
        margin: 0 auto;
    }

    .btn-poshtibani {
        background: #f96f0c;
        color: #fff !important;
        padding: 10px;
        border-radius: 5px;
        float: left;
        width: 132px;
        margin-left: 2%;
    }

    .btn-other {
        background: #00b350;
        color: #fff !important;
        padding: 10px;
        border-radius: 5px;
        float: right;
        width: 132px;
        margin-right: 2%;
    }

    .checkout_players_phone_field label {
        display: flex !important;
    }

    h3.form-row.chkout_players_phone_desc {
        background: #eee;
        padding: 10px;
        border-radius: 8px;
        text-align: justify;
        font-family: 'dana-medium';
        line-height: 28px;
    }

    .entry-title {
        display: none !important;
    }

    .woocommerce-checkout input {
        color: #202020 !important;
    }

    #main div > div > form > div > div.zardkooh-checkout-right > p:nth-child(2) {
        display: none;
    }

    .woocommerce-checkout #payment ul.payment_methods li label {
        font-family: 'dana';
    }

    h3 {
        font-family: 'dana' !important;
    }

    @media only screen and (max-width: 600px) {
        .zardkooh-checkout-page {
            display: block;
        }

        .zardkooh-checkout-right, .zardkooh-checkout-left {
            max-width: 100%;
            padding: 0;
        }
    }
    .cart-discount td, .cart-discount th {
        color: green !important;
        font-size: 13px !important;
        font-weight: bold !important;
    }

    <?php
    $user = wp_get_current_user();

    if ( in_array( 'poshtiban', (array) $user->roles )||in_array( 'administrator', (array) $user->roles )) {
        echo "ul.wc_payment_methods.payment_methods.methods.d-none { display: block!important; }";
    } ?>
</style>

<?php
if ( get_current_user_id() == 3325 || 1 ) : ?>

<script>
    jQuery(document).ready(function ($) {

        $('#billing_phone').attr('maxlength', "11");
        $('#billing_first_name').attr('maxlength', "15");
        $('#billing_last_name').attr('maxlength', "15");

        $('<span id="checkout_phone_err_msg" style="font-size: 12px;display: block;color: #a00;"></span>').insertAfter('#billing_phone');

        setTimeout(function () { // simulation of keyup to see if preserved number is validated
            var press = jQuery.Event("keyup");
            press.ctrlKey = false;
            press.which = 40;
            $("#billing_phone").trigger(press);
        }, 1);

        var $err_flag = false;
        $('body').on('keyup', '#billing_phone', function() {
            var $this = $(this);
            var value = $this.val();

            if ( value.length != 11 ) {
                $('#checkout_phone_err_msg').html('شماره موبایل باید 11 رقم باشد!');
                $err_flag = true;

            } else if ( value.length == 11 ) {
                $('#checkout_phone_err_msg').html('');
                $err_flag = false;
            }

            if (value.indexOf('09') != 0) {
                $('#checkout_phone_err_msg').html('شماره موبایل صحیح وارد کنید، برای مثال: 09122222222');
                $err_flag = true;
            }

            if( !( value.match(/^\d+$/) ) ) {
                $('#checkout_phone_err_msg').html('شماره موبایل صحیح وارد کنید، برای مثال: 09122222222');
                $err_flag = true;
            }

            if ( $err_flag ) {
                $this.closest('#billing_phone_field').addClass('woocommerce-invalid');
                $this.closest('#billing_phone_field').removeClass('woocommerce-validated');
                $("#place_order").prop("disabled", true);

            } else {
                $this.closest('#billing_phone_field').removeClass('woocommerce-invalid');
                $this.closest('#billing_phone_field').addClass('woocommerce-validated');
                $("#place_order").prop("disabled", false);
            }

        });

        $('body').on('blur', '#billing_phone', function() {
            var $this = $(this);

            if ( $err_flag ) {
                $this.closest('#billing_phone_field').addClass('woocommerce-invalid');
                $this.closest('#billing_phone_field').removeClass('woocommerce-validated');
                $("#place_order").prop("disabled", true);

            } else {
                $this.closest('#billing_phone_field').removeClass('woocommerce-invalid');
                $this.closest('#billing_phone_field').addClass('woocommerce-validated');
                $("#place_order").prop("disabled", false);
            }
        });
    });
</script>

<?php
endif; ?>

<?php
if ( (($_GET['book'] - (((int)get_post_meta($_GET['add-to-cart'], 'auto_disable', true) * 60) + time())) < 0) && !(in_array( 'shopist', (array) $user->roles )||in_array( 'administrator', (array) $user->roles )) ) { ?>

    <div class="container">
        <div class="row mb-5">
            <div class="col-12 mb-3">
                <img src="https://escapezoom.ir/wp-content/uploads/2022/01/oops.png" class="oops-img">
                <p style=" font-size: 1.3em; text-align: center; padding-top: 16px; ">
                    زمان رزرو این سانس به پایان رسیده است.
                    <br>
                    لطفاً برای سانس های دیگر اقدام نمایید.
                </p>
            </div>

            <div class="col-6"><a href="tel:+989925101507" class="btn-poshtibani">تماس با پشتیبانی</a></div>
            <div class="col-6"><a class="btn-other" href="http://escapezoom.ir/?p=<?php echo $_GET['add-to-cart']; ?>">رزرو یک سانس دیگر</a></div>
        </div>
    </div>

    <?php
    get_footer();
    exit();
}

$room_id = htmlspecialchars($_GET['add-to-cart']);
$book_time = htmlspecialchars($_GET['book']);
if ($book_time) {
    global $wpdb;

    $args = [
        "single_value"  => true,
        "query"         => "SELECT * FROM `wp_zb_booking_history` WHERE `room_id` = {$room_id} AND `booking_time` LIKE {$book_time}",
    ];
    $response = ez_reservation( array('type' => 'query_execution', 'data' => $args) );
    $row_check = (array)json_decode($response);

    if (!empty($row_check)) { ?>

        <div class="container">
            <div class="row mb-5">
                <div class="col-12 mb-3">
                    <img src="https://escapezoom.ir/wp-content/uploads/2022/01/oops.png" class="oops-img">
                    <p style=" font-size: 1.3em; text-align: center; padding-top: 16px; ">اوه! یکی سریع تر از تو بود و
                        زودتر این سانس رو رزرو کرد!</p>
                </div>

                <div class="col-6"><a href="tel:+989925101507" class="btn-poshtibani">تماس با پشتیبانی</a></div>
                <div class="col-6"><a class="btn-other" href="<?php the_permalink("$room_id"); ?>">رزرو یک سانس دیگر</a>
                </div>
            </div>
        </div>
        <?php
        get_footer();
        exit();
    }
}

do_action('woocommerce_before_checkout_form', $checkout);


// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
    echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
    return;
}

?>
<?php
$book = htmlspecialchars($_GET['book']);
$quantity = htmlspecialchars($_GET['quantity']);
$current_timestamp = date('U');
$room__id = htmlspecialchars($_GET["add-to-cart"]);

$pish_pardakht = get_field("pish_pardakht", $room__id);
if ($pish_pardakht) {
    update_option('wc_deposits_checkout_mode_deposit_amount', "$pish_pardakht");
} else {
    update_option('wc_deposits_checkout_mode_deposit_amount', '200000');
}


$zb_date = jdate('l j F', $book);
$zb___time = jdate('H:i', $book);



if ($book < $current_timestamp || $zb_date == 'پنجشنبه ۱۱ دی' || empty($book) || empty($quantity) || empty($room__id)) {

    echo 'خطای سیستمی لطفا با شماره 09914406399 تماس بگیرد.';
    exit();
}

if ($_GET["add-to-cart"] && $_GET['book'] && $_GET['quantity']) {


    ?>
    <p style="border: 1px solid green; background: #00800030; color: green; width: 100%; padding: 10px;"> شما در حال
        رزرو
        <strong>  <?= $quantity; ?></strong> تیکت
        برای روز
        <strong> <?= $zb_date; ?></strong> ساعت
        <strong> <?= $zb___time; ?> </strong>
        اتاق فرار "<?php echo get_the_title("$room__id"); ?>" هستید.
    </p>

    <?
}
?>


<p style="border: 1px solid #a60000; background: #a6000020; color: #a60000; width: 100%; padding: 10px;margin-top:20px">
    <strong> توجه - مهم:</strong>

    پس از پرداخت صفحه درگاه بانکی را نبندید تا دوباره به سایت اسکیپ زوم برگشته و پرداخت موفقیت آمیز باشد.
</p>







<?php
if ( get_current_user_id() == 3325 || get_current_user_id() == 2 || 1 ) {

    add_action('woocommerce_review_order_after_order_total', 'ez_woocommerce_checkout_coupon_form');
    function ez_woocommerce_checkout_coupon_form() { ?>
        <div class="coupon-form" style="margin-bottom:20px; background: #E8EDF1; padding: 10px; border-radius: 8px;">
            <p>اگر کد تخفیفی دارید اینجا وارد کنید...</p>
            <div>
                <p class="form-row form-row-first woocommerce-validated" style="width: calc(100% - 100px);">
                    <input type="text" name="coupon_code" class="input-text" placeholder="کدتخفیف" id="coupon_code" value="" style="direction: ltr;">
                </p>
                <p class="form-row form-row-last" style="width: 90px;">
                    <button type="button" class="button" name="apply_coupon" value="<?php _e('Apply coupon'); ?>">ثبت کد</button>
                </p>
            </div>
            <div class="error-message" style="color: red; font-weight: bold; margin-top: 10px; display: none; font-size: 14px;">
                کد تخفیف نامعتبر است. لطفا دوباره تلاش کنید.
            </div>
            <div class="clear"></div>
        </div>

        <script type="text/javascript">
            jQuery(function($){
                $('.coupon-form input[name="coupon_code"]').on('input change', function() {
                    $('form.checkout_coupon input[name="coupon_code"]').val($(this).val());
                });

                $('.coupon-form button[name="apply_coupon"]').on('click', function() {
                    $('form.checkout_coupon').submit();
                });
            });

            $(document).ajaxSuccess(function(event, xhr, settings) {
                if (settings.url === '/?wc-ajax=apply_coupon')
                    $('.coupon-form .error-message').html($(xhr.responseText).find('li').text().trim()).show();
            });

        </script>
        <?php
    }

} ?>




<form name="checkout" method="post" class="checkout woocommerce-checkout"
      action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">

    <input type="hidden" name="booking_details" value='<?php echo(json_encode($_GET)) ?>'>

    <div class="zardkooh-checkout-page">

        <div class="zardkooh-checkout-right">

            <?php if ($checkout->get_checkout_fields()) : ?>

                <?php do_action('woocommerce_checkout_before_customer_details'); ?>

                <?php do_action('woocommerce_checkout_billing'); ?>

            <?php endif; ?>


            </p>

        </div>

        <div class="zardkooh-checkout-left">

            <?php if ($checkout->get_checkout_fields()) : ?>

                <?php do_action('woocommerce_checkout_shipping'); ?>

                <?php do_action('woocommerce_checkout_after_customer_details'); ?>

            <?php endif; ?>

            <?php do_action('woocommerce_checkout_before_order_review_heading'); ?>


            <h3 id="order_review_heading"><?php esc_html_e('Your order', 'woocommerce'); ?></h3>

            <?php do_action('woocommerce_checkout_before_order_review'); ?>

            <div id="order_review" class="woocommerce-checkout-review-order">
                <?php do_action('woocommerce_checkout_order_review'); ?>
            </div>

            <?php do_action('woocommerce_checkout_after_order_review'); ?>

        </div>

    </div>

</form>

<p>
