<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.7.0
 */

defined( 'ABSPATH' ) || exit;
?>

<?php
//var_dump($_SESSION);

?>
<style>.entry-title { display:none; } section.woocommerce-order-details, .woocommerce_deposits_parent_order_summary, #content > div > div > div > section.woocommerce-checkout-details > div > div:nth-child(2) > p { display: none; }</style>
<div class="woocommerce-order">

	<?php if ( $order ) :

		do_action( 'woocommerce_before_thankyou', $order->get_id() ); ?>

		<?php if ( $order->has_status( 'failed' ) ) : ?>
		
			<section class="woocommerce-checkout-alert">
				<div class="woocommerce-checkout-alert-icon failed"><i></i></div>
				<div class="woocommerce-checkout-alert-title">
					<h4><?php _e( 'Order Number ', 'zardkooh' ) ?><span class="woocommerce-checkout-alert-highlighted failed"><?php echo $order->get_order_number(); ?></span> <?php _e( ' Submitted But pay is failed.', 'zardkooh' ) ?></h4>
				</div>
				<div class="woocommerce-checkout-alert-content">
					<p><?php _e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>
					
					<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
						<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html_e( 'Pay', 'woocommerce' ) ?></a>
						<?php if ( is_user_logged_in() ) : ?>
							<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button account"><?php esc_html_e( 'My account', 'woocommerce' ); ?></a>
						<?php endif; ?>
					</p>
				</div>
			</section>

		<?php else : ?>

			<section class="woocommerce-checkout-details">
				<div class="woocommerce-checkout-details-title">
					<div class="woocommerce-checkout-details-row">
						<div class="woocommerce-checkout-details-col-table">
							<div class="woocommerce-checkout-details-table">
								<div class="woocommerce-checkout-details-table-row">
									<div class="woocommerce-checkout-details-table-col">
										<?php _e( 'Deliverer Name: ', 'zardkooh' ) ?><span class="col-value"><?php echo $order->get_formatted_billing_full_name(); ?></span>
									</div>
									<div class="woocommerce-checkout-details-table-col">
										<?php _e( 'Phone Number: ', 'zardkooh' ) ?><span class="col-value"><?php echo $order->get_billing_phone(); ?></span>
									</div>
								</div>
								<div class="woocommerce-checkout-details-table-row">
									<div class="woocommerce-checkout-details-table-col">
										<?php _e( 'Mobile: ', 'zardkooh' ) ?><span class="col-value"><?php echo get_user_meta($order->get_customer_id(),'billing_mobile',true); ?></span>
									</div>
									<div class="woocommerce-checkout-details-table-col">
										<?php _e( 'Email: ', 'zardkooh' ) ?><span class="col-value"><?php echo $order->get_billing_email(); ?></span>
									</div>
								</div>
								<?php
								$order_item_totals = $order->get_order_item_totals();
								$order_item_totals = array_chunk($order_item_totals,2);
								foreach ( $order_item_totals as $order_item_total ) {
									echo '<div class="woocommerce-checkout-details-table-row">';
									foreach ( $order_item_total as $key => $total ) {
										echo '<div class="woocommerce-checkout-details-table-col">'.$total['label'].' <span class="col-value">'.$total['value'].'</span></div>';
									}
									echo '</div>';
								}
								?>
								<div class="woocommerce-checkout-details-table-row">
									<div class="woocommerce-checkout-details-table-col full-col">
										<?php _e ( 'Address: ','zardkooh' ); ?>
										<span class="col-value">
											<?php 
											$country	= $order->get_billing_country();
											$state		= $order->get_billing_state();
											$allstates	= WC()->countries->get_states( $country );
											if ( !empty( $allstates ) && is_array( $allstates ) && isset( $allstates[$state] ) ) {
												$state = $allstates[$state];
											}
											$city		= $order->get_billing_city();
											$address	= $order->get_billing_address_1();
											$postalcode	= $order->get_billing_postcode();
											?>
											<span><?php _e( 'State ', 'zardkooh' ) ?><?php echo $state;?></span>،
											<span><?php _e( 'City ', 'zardkooh' ) ?> <?php echo $city; ?></span>،
											<span><?php echo $address; ?></span> 
											(<span><?php echo $postalcode; ?></span>)
										</span>
									</div>
								</div>
								<?php if ( $order->get_customer_note() && $order->get_customer_note() !== '' ) { ?>
								<div class="woocommerce-checkout-details-table-row">
									<div class="woocommerce-checkout-details-table-col full-col">
										<?php _e( 'Note:', 'woocommerce' ); ?><span class="col-value"><?php echo $order->get_customer_note(); ?></span>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>
						
						<?php do_action( 'woocommerce_thankyou', $order->get_id() ); ?>
					</div>
				</div>
			</section>

		<?php endif; ?>

		<?php //do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'woocommerce' ), null ); ?></p>

	<?php endif; ?>

</div>
