<?php
/**
 * Shop breadcrumb
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/breadcrumb.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     2.3.0
 * @see         woocommerce_breadcrumb()
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! empty( $breadcrumb ) ) {

	echo $wrap_before;

	foreach ( $breadcrumb as $key => $crumb ) {

		echo $before;
        $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

        $product_type = get_term( $term->parent )->name;


        if ( ! empty( $crumb[1] ) && sizeof( $breadcrumb ) !== $key + 1 ) {
		    $current_term_name = '<li class="crterm"> ' . $product_type . ' ' . esc_html(  $term->name ) . '</li>';

            if ( $term->parent ) : ?>

                <div id="zardkooh_breadcrumbs" class="woocommerce-breadcrumb esbreadcrumb">
                    <ul class="breadcrumb">
                        <li><a href="<?php echo get_term_link($term->parent, "product_cat") ?>" title="<?php echo $product_type ?>"><?php echo $product_type ?></a></li>
                        <?php echo $current_term_name; ?>
                    </ul>
                </div>

            <?php
            endif;

		} else {
			echo
			'<h1 class="ez-tag-title">'. $product_type . ' ' . esc_html( str_replace('|||||', '', $term->name) ).'</h1>';
		}
?>
    <style>
    /*  ES Breaccrumb */
    .esbreadcrumb a {
        color:#fd7013!important;
        font-size:12px!important;
        margin-left: unset !important;
        padding: unset !important;
    }
    .esbreadcrumb span{
        color:#fff!important;
         font-size:12px!important;
    }
    .esbreadcrumb a:hover{
        color:#fd7013!important;
    }
    .esbreadcrumb a:after{
        content: '\ea97' !important;
        color: #fd7013 !important;
        font-size: 8px !important;
        font-family: 'icofont' !important;
        margin-left:5px !important;
        position:unset !important;

    }
    .esbreadcrumb .brcat:after{
        content: '\ea97'!important;
        color: #fd7013!important;
        font-size: 8px!important;
        font-family: 'icofont'!important;
        margin-right:5px!important;
    }
    .single-product-section h2:before, .single-product-section h3:before, .woocommerce .woocommerce-breadcrumb:before, .woocommerce-breadcrumb:before {
        display:none;
    }

    </style>

<?php
		echo $after;

		if ( sizeof( $breadcrumb ) !== $key + 1 ) {
			//echo $delimiter;
		}
	}

	echo $wrap_after;

}