<?php
/**
 * Order Item Details
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-details-item.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
	return;
}
?>
<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">

	<td class="woocommerce-table__product-name product-name">
		<?php
		$is_visible			= $product && $product->is_visible();
		$product_permalink	= apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );
		$product_thumb		= zardkooh_get_product_img($product);

		echo '<a class="product-image-thumb" href="'.$product_permalink.'"><img src="'.$product_thumb.'"></a>';
		
		echo '<div class="product-title-meta">';
		
		echo apply_filters( 'woocommerce_order_item_name', $product_permalink ? sprintf( '<a href="%s">%s</a>', $product_permalink, $item->get_name() ) : $item->get_name(), $item, $is_visible ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

		do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );

		wc_display_item_meta( $item );

		do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
		
		echo '</div>';
		?>
	</td>
	
	<td class="woocommerce-table__product-qty product-qty" data-title="<?php esc_html_e( 'Quantity', 'woocommerce' ); ?>">
		<?php 
		$qty          = $item->get_quantity();
		$refunded_qty = $order->get_qty_refunded_for_item( $item_id );

		if ( $refunded_qty ) {
			$qty_display = '<del>' . esc_html( $qty ) . '</del> <ins>' . esc_html( $qty - ( $refunded_qty * -1 ) ) . '</ins>';
		} else {
			$qty_display = esc_html( $qty );
		}
		
		echo apply_filters( 'woocommerce_order_item_quantity_html', ' <span class="product-quantity">' . sprintf( '%s', $qty_display ) . '</span>', $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
		?>
	</td>
	
	<td class="woocommerce-table__product-price product-price" data-title="<?php esc_html_e( 'Price', 'woocommerce' ); ?>">
		<?php echo wc_price($product->get_regular_price()); ?>
	</td>
	
	<td class="woocommerce-table__product-discount product-discount" data-title="<?php esc_html_e( 'Discount', 'zardkooh' ); ?>">
		<?php
			if ( $product->is_on_sale() ) {
				echo wc_price( ($product->get_regular_price() - $product->get_sale_price()) * $item->get_quantity() ); 
			} else {
				echo '0';
			}
		?>
	</td>

	<td class="woocommerce-table__product-total product-total" data-title="<?php esc_html_e( 'Total', 'woocommerce' ); ?>">
		<?php echo $order->get_formatted_line_subtotal( $item ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
	</td>
	
	<td class="woocommerce-table__product-actions product-actions" data-title="<?php esc_html_e( 'Actions', 'zardkooh' ); ?>">
		<a href="<?php echo $product_permalink; ?>" class="shop-btn btn-reorder "><?php _e('Buy Again','zardkooh'); ?></a>
	</td>

</tr>

<?php if ( $show_purchase_note && $purchase_note ) : ?>

<tr class="woocommerce-table__product-purchase-note product-purchase-note">

	<td colspan="2"><?php echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></td>

</tr>

<?php endif; ?>
