<?php

define( 'naga_urep_min_reqiered_php', '7.4' ); // without dot (not 7.4.0)
define( 'naga_urep_min_reqiered_ioncube', '12' ); // without dot (not 12.0.0)

add_action( 'init', function() {
	load_textdomain( 'naga-urep-notices', plugin_dir_path( __FILE__ ) . 'languages/' . 'naga-urep-notices-fa_IR.mo' );
});

require_once( plugin_dir_path( __FILE__ ) . 'includes/naga-urep-notices.php' );

// Load NagaTheme License, RTL and Persian Files
if( version_compare( PHP_VERSION, naga_urep_min_reqiered_php ) >= 0 ) {
	
	if( extension_loaded( 'ionCube Loader' ) ) {
		
		if( function_exists( 'ioncube_loader_version' ) && version_compare( ioncube_loader_version(), naga_urep_min_reqiered_ioncube ) >= 0 ) {
			
			require_once( plugin_dir_path( __FILE__ ) . 'naga-urep-ic.php' );
			
		} else {
			
			add_action( 'admin_notices', 'naga_urep_ioncube_version_notice' );
			add_action( 'admin_init', 'naga_urep_deactivate_licenses' );
			
		}
			
	} else {
		
		add_action( 'admin_notices', 'naga_urep_ioncube_notice' );
		add_action( 'admin_init', 'naga_urep_deactivate_licenses' );
		
	}
} else {
	
	add_action( 'admin_notices', 'naga_urep_php_notice' );
	add_action( 'admin_init', 'naga_urep_deactivate_licenses' );

}