<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 */

get_header();

global $zardkooh_options;

if ( isset( $zardkooh_options['img_404'] ) && strlen( $zardkooh_options['img_404']['url'] ) > 0 ) {
	$img_404 = $zardkooh_options['img_404']['url'];
} else {
	$img_404 = get_template_directory_uri().'/assets/images/error-404.svg';
}
?>
<div class="wrap">
	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<section class="page-404">
				<div class="page-404-title"><h1>ERROR 404<span><?php echo _e ('Page Not Found!','zardkooh');?></span></h1></div>
				<div class="page-404-image"><img src="<?php echo $img_404; ?>" alt="404"></div>
				<div class="page-404-links">
					<a href="<?php echo home_url('/');?>" class="page-404-link page-404-link-primary"><?php echo _e ('Return To Home Page','zardkooh');?></a>
				</div>
				<div class="search-box">
					<?php echo do_shortcode('[wcas-search-form]');?>
				</div>
			</section>
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .wrap -->

<?php get_footer();
