<?php
add_action( 'init', 'zardkooh_register_custom_menu_location');

if ( !function_exists('zardkooh_register_custom_menu_location') ) {
	function zardkooh_register_custom_menu_location() {

		global $zardkooh_options;

		$menu_array = array();

		if ( isset($zardkooh_options['department_menu']) && $zardkooh_options['department_menu'] ) {
			$menu_array['departments_menu'] = __( 'Departments Menu', 'zardkooh' );
		}

		if ( isset($zardkooh_options['diff_department_menu']) && $zardkooh_options['diff_department_menu'] ) {

			$all_categories = get_terms(array(
				'taxonomy' => 'product_cat',
				'hide_empty' => false,
				'parent' => 0,
				'orderby' => 'none'
			));

			if (is_array($all_categories) && !empty($all_categories)) {
				foreach ($all_categories as $product_category) {
					$menu_array[$product_category->slug] = $product_category->name;
					if ( isset($zardkooh_options['diff_department_menu_mobile']) && $zardkooh_options['diff_department_menu_mobile'] ) {
						$menu_array[$product_category->slug . '_mob'] = __('Mobile Menu', 'zardkooh') . ' ' . $product_category->name;
					}
				}
			}
		}
		
		register_nav_menus($menu_array);

	}
}

if ( !function_exists('zardkooh_check_current_cat_is_sub_of') ) {
	function zardkooh_check_current_cat_is_sub_of( $parent ) {

		global $wp_query;
		$cat = $wp_query->get_queried_object();

		if ( isset( $wp_query ) && is_object($cat) && isset($cat->parent) ) {
			if ( $cat->parent !=0 && $cat->parent == $parent ) {
				return true;
			} else {
				return false;
			}
		}
	}
}

if ( !function_exists('zardkooh_check_menu_category') ) {
	function zardkooh_check_menu_category ( $name ) {

		if ( strpos($_SERVER['REQUEST_URI'], $name ) !== false ) {
			return true;
		}

		if ( is_product() && has_term( $name, 'product_cat' ) ) {
			return true;
		}

		if ( is_product_category( $name ) ) {
			return true;
		}

		if ( zardkooh_check_current_cat_is_sub_of( $name ) ) {
			return true;
		}

		return false;

	}
}

if ( !function_exists('zardkooh_main_menu') ) {
	function zardkooh_main_menu() {

		$theme_location = false;

		$all_categories = get_terms( array(
			'taxonomy'		=> 'product_cat',
			'hide_empty'	=> false,
			'parent'		=> 0,
			'orderby'		=> 'none'
		) );

		if ( is_array($all_categories) && !empty($all_categories) ) {
			foreach ( $all_categories as $product_category ) {
				$cat_slug = $product_category->slug;
				if ( has_nav_menu( $cat_slug ) && ( strpos($_SERVER['REQUEST_URI'], $cat_slug) !== false || zardkooh_check_menu_category( $cat_slug ) ) ) {
					$theme_location = $cat_slug;
				}
			}
		}
		if ( !$theme_location ) {
			if ( has_nav_menu( 'main' ) ) {
				$theme_location = 'main';
			}
		}

		if ( $theme_location ) {
			wp_nav_menu(
				array(
					'theme_location'=> $theme_location,
					'container'		=> false,
					'menu_class'	=> 'zardkooh-menu-list-items-item',
				)
			);
		}

	}
}

if ( !function_exists('zardkooh_department_menu') ) {
	function zardkooh_department_menu() {

		global $zardkooh_options;

		if ( isset($zardkooh_options['department_menu']) && $zardkooh_options['department_menu'] ) {

			$dep_nav = false;

			if ( has_nav_menu( 'departments_menu' ) ) {

				$dep_nav_slug = get_term(get_nav_menu_locations()['departments_menu'], 'nav_menu')->slug;
				if ( $dep_nav_slug ) {
					$dep_nav = wp_get_nav_menu_items ($dep_nav_slug);
				}
			}
			if ( $dep_nav ) { ?>
				<div class="zardkooh-departments-menu">
					<span class="departments-anchor"><?php echo _e('Categories','zardkooh');?></span>
					<div class="dep-mega-menu">
						<ul>
							<?php
							foreach ( $dep_nav as $sinlge_menu ) {
								if ( $sinlge_menu->menu_item_parent == '0' ) {
									$link = $sinlge_menu->url;
									$icon = false;
									if ( $sinlge_menu->thumbnail_id > 0 ) {
										$icon = $sinlge_menu->thumbnail_id;
										$icon = wp_get_attachment_image_src($icon,'full');
									}
									$title= $sinlge_menu->title;
									if ( $sinlge_menu->object == 'product_cat' ) {
										$category_id = $sinlge_menu->object_id;
									} else {
										$category_id = $sinlge_menu->attr_title;
									}
									$mega_center_class = 'class="dep-mega-menu-center center-full-width"';
									if ( $category_id > 0 && isset($zardkooh_options['department_menu_products']) && $zardkooh_options['department_menu_products'] ) {
										$mega_center_class = 'class="dep-mega-menu-center"';
									}
									$submenus = array();
									foreach ( $dep_nav as $sinlge_submenu ) {
										if ( $sinlge_submenu->menu_item_parent == $sinlge_menu->ID ) {
											$submenus[] = $sinlge_submenu->ID;
										}
									}
									$is_coming_soon  = get_term_meta($category_id, 'coming_soon', true) == 1 ? ' coming-soon' : '';
									if ( !$icon ) {
										$icon_id = get_term_meta($category_id, 'category-icon-id', true);
										$icon = wp_get_attachment_image_src($icon_id,'full');
									}
									?>
									<li class="<?php echo $is_coming_soon; ?>">
										<a href="<?php echo $link; ?>">
											<?php
											if ( $icon ) {
												echo '<img src="'.$icon[0].'" alt="'.$title.'">';
											}
											?>
											<span><?php echo $title; ?></span>
										</a>
										<div <?php echo $mega_center_class; ?>>
											<?php
											wp_nav_menu(
												array(
													'theme_location'=> 'departments_menu',
													'container'		=> false,
													'menu_class'	=> 'zardkooh-department-menu-list-item',
													'walker'        => new zardkooh_department_nav_walker($submenus),
												)
											);
											?>
										</div>
										<?php
										if ( $category_id > 0 && isset($zardkooh_options['department_menu_products']) && $zardkooh_options['department_menu_products'] ) {
											$args['post_type']		= 'product';
											$args['meta_query']		= array( array( 'key' => '_stock_status', 'value' => 'instock', 'compare' => '=' ) );
											$args['tax_query']		= array( 'relation' => 'OR', array( 'taxonomy' => 'product_cat', 'field' => 'id', 'terms' => $category_id ) );
											$args['orderby']		= 'rand';
											$args['posts_per_page'] = $zardkooh_options['department_products_count'] ? $zardkooh_options['department_products_count'] : 8;

											$dep_mega_query = new WP_Query();
											$dep_mega_query->query($args);

											if($dep_mega_query->have_posts()) { ?>
												<div class="dep-mega-products">
													<div class="dep-mega-products-header">
														<span><?php echo _e('Products','zardkooh');?></span>
														<a href="<?php echo $link; ?>"><?php echo _e('View All','zardkooh');?></a>
													</div>
													<div class="dep-mega-products-main">
														<?php
														while ($dep_mega_query->have_posts()):
															$dep_mega_query->the_post();
															global $post;
															$product = wc_get_product( $post->ID );
															?>
															<a href="<?php the_permalink(); ?>" class="dep-mega-product-box">
																<div class="dep-mega-product-image">
																	<img alt="<?php the_title(); ?>" src="<?php echo zardkooh_get_product_img($product,array(80,80)); ?>" width="80" height="80">
																</div>
																<span><?php echo wp_trim_words( get_the_title(), 2 ); ?></span>
															</a>
														<?php endwhile; wp_reset_query(); ?>
													</div>
												</div>
												<?php
											}
										}
										?>
									</li>
									<?php
								}
							}
							?>
						</ul>
					</div>
				</div>
				<?php
			}
		}
	}
}

add_filter( 'walker_nav_menu_start_el', 'zardkooh_add_description_to_menu', 10, 4 );

if ( !function_exists('zardkooh_add_description_to_menu') ) {
	function zardkooh_add_description_to_menu($item_output, $item, $depth, $args) {
		if (strlen($item->description) > 0 ) {
			// append description after link
			$item_output .= sprintf('<span class="description">%s</span>', esc_html($item->description));
		}

		return $item_output;
	}
}