<?php
/**
 * Cando Brands Template
 */
 
?>
<section class="brands-container">
	<div class="brands-sidebar">
        <h2><?php echo $title; ?></h2>
        <?php if ( $description ) { ?>
            <p><?php echo $description; ?></p>
        <?php } ?>
	</div>
	
	<div class="brands-box">
        <?php
        foreach ( $terms as $term ) {
            $term_name		= $term->name;
            $term_link		= get_term_link( $term );
            $thumbnail_id	= absint( get_term_meta( $term->term_id, 'thumbnail_id', true ) );
            $image			= false;
            if ( $thumbnail_id ) {
                $image = wp_get_attachment_image_src( $thumbnail_id, array(100,100) );
            }
            if ($image) {
            ?>
            <div class="brand-box">
                <a class="brand-img" href="<?php echo $term_link; ?>">
                    <img alt="<?php echo $term_name; ?>" src="<?php echo $image[0]; ?>" width="100" height="100">
                </a>
            </div>
        <?php } } ?>
	</div>
</section>