<?php
/**
 * Cando Contact Info Widget Template
 */
 
global $zardkooh_options;

?>
<div class="zardkooh-contact">
	<div class="contact-top-section">
		<ul class="contact-informations">
			<?php if ( $address ) { ?>
				<li class="contact-address">
					<div class="contact-value">
						<span class="contact-value-title"><?php echo _e('Address', 'zardkooh'); ?></span>
						<span class="contact-value-data"><?php echo $address; ?></span>
					</div>
				</li>
			<?php } ?>
			<?php if ( $phone || $hours ) { ?>
				<li class="contact-phone">
					<div class="contact-value">
						<span class="contact-value-title"><?php echo _e('Phone', 'zardkooh'); ?></span>
						<div class="contact-value-data">
							<span class="phone-number"><span class="city-code"><?php echo $city; ?></span><?php echo $phone; ?></span>
							<span class="work-hours">
								<span><?php echo _e('Work Hours', 'zardkooh'); ?></span>
								<span><?php echo $hours; ?></span>
							</span>
						</div>
					</div>
				</li>
			<?php } ?>
			<?php if ( $email ) { ?>
				<li class="contact-email">
					<div class="contact-value">
						<span class="contact-value-title"><?php echo _e('Support Email', 'zardkooh'); ?></span>
						<?php
						$email = explode(',',$email);
						if ( is_array($email) ) {
							echo '<span class="contact-value-data-email">';
							foreach ( $email as $value ) {
								echo '<span class="contact-value-data">'.$value.'</span>';
							}
							echo '</span>';
						}
						?>
					</div>
				</li>
			<?php } ?>
			<?php if ( $socials ) { ?>
				<li class="contact-socials">
					<div class="contact-value">
						<span class="contact-value-title"><?php echo _e('Socials', 'zardkooh'); ?></span>
						<span class="contact-value-data">
							<ul class="social-networks">
									<?php if ( isset($zardkooh_options['social-telegram']) && $zardkooh_options['social-telegram'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-telegram']; ?>">
											<li><i class="social-icon social-telegram"></i><span><?php echo _e('Telegram','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-whatsapp']) && $zardkooh_options['social-whatsapp'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-whatsapp']; ?>">
											<li><i class="social-icon social-whatsapp"></i><span><?php echo _e('Whatsapp','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-gmail']) && $zardkooh_options['social-gmail'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-gmail']; ?>">
											<li><i class="social-icon social-gmail"></i><span><?php echo _e('Google Plus','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-twitter']) && $zardkooh_options['social-twitter'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-twitter']; ?>">
											<li><i class="social-icon social-twitter"></i><span><?php echo _e('Twitter','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-instagram']) && $zardkooh_options['social-instagram'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-instagram']; ?>">
											<li><i class="social-icon social-instagram"></i><span><?php echo _e('Instagram','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-linkedin']) && $zardkooh_options['social-linkedin'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-linkedin']; ?>">
											<li><i class="social-icon social-linkedin"></i><span><?php echo _e('Linkedin','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
									
									<?php if ( isset($zardkooh_options['social-facebook']) && $zardkooh_options['social-facebook'] ) { ?>
										<a href="<?php echo $zardkooh_options['social-facebook']; ?>">
											<li><i class="social-icon social-facebook"></i><span><?php echo _e('Facebook','zardkooh'); ?><span></li>
										</a>
									<?php } ?>
								</ul>
						</span>
					</div>
				</li>
			<?php } ?>
		</ul>
		<?php if ( $form ) { ?>
			<div class="contact-form white-box">
				<span class="contact-form-title"><?php echo _e('Contact Us','zardkooh'); ?></span>
				<?php echo do_shortcode('[contact-form-7 id="'.$form.'"]'); ?>
			</div>
		<?php } ?>
	</div>
	
</div>