<?php
/**
 * Cando Product Slider Template
 */
 ?>
<section class="products-slider-container <?php if ( $style ) { echo 'style2'; } else { echo 'style1'; } ?>">
	<div class="products-slider-header">
		<div class="products-slider-header-title">
			<?php if ( $image ) { ?>
				<img src="<?php echo $image; ?>" alt="<?php echo $title; ?>">
			<?php } ?>
			<?php if ( $style && $subtitle ) { ?>
				<div class="header-title">
					<span><?php echo $title; ?></span>
					<h2><?php echo $subtitle; ?></h2>
				</div>
			<?php } else { ?>							
				<h2><?php echo $title; ?></h2>
			<?php } ?>
		</div>
		<?php if ( $category && $category_link) { ?>
			<a href="<?php echo $cat_link; ?>" class="products-slider-header-more"><?php echo _e('Show More','zardkooh');?></a>
		<?php } ?>
	</div>
	
	<div class="zardkooh-products-row">
		<div class="products-row">
			<?php
			while ($nikan_carousel_query->have_posts()):
			$nikan_carousel_query->the_post();
			global $product, $post, $zardkooh_options;
			$product = wc_get_product( $post->ID );
			?>
			<div class="products-swiper-p-box">
				<a href="<?php the_permalink(); ?>" class="products-swiper-link">
					<div class="products-swiper-img">
						<img alt="<?php the_title(); ?>" class="swiper-lazy" data-src="<?php echo zardkooh_get_product_img($product); ?>" src="<?php echo zardkooh_get_product_img($product); ?>" width="205" height="205">
					</div>
					<div class="products-swiper-title"><?php echo get_the_title(); ?></div>
					<div class="products-swiper-footer">
						<span class="products-swiper-button"><?php echo _e('View','zardkooh');?></span>
						<div class="products-swiper-price">
							<?php echo $product->get_price_html(); ?>
						</div>
					</div>
				</a>
			</div>
			<?php endwhile; ?>
		</div>
	</div>
</section>