<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.5.2
 */

defined( 'ABSPATH' ) || exit;

global $zardkooh_options;

if ( isset( $zardkooh_options['logo'] ) && strlen( $zardkooh_options['logo']['url'] ) > 0 ) {
	$logo_href = $zardkooh_options['logo']['url'];
} else {
	$logo_href = get_template_directory_uri().'/assets/images/logo.svg';
}
?>
<div class="account-page-layout">
	<a href="<?php echo home_url('/');?>" class="account-page-logo"><img src="<?php echo $logo_href; ?>" alt="<?php echo get_bloginfo();?>"></a>
	<div class="account-box-main">
		<div class="account-box-top">
			<h3><?php esc_attr_e( 'Reset password', 'woocommerce' ); ?></h3>
			<div class="account-box-content">
				
				<?php do_action( 'woocommerce_before_lost_password_form' ); ?>
				
				<form method="post" class="woocommerce-ResetPassword lost_reset_password">

					<p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'woocommerce' ) ); ?></p><?php // @codingStandardsIgnoreLine ?>

					<p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
						<label for="user_login"><?php esc_html_e( 'Username or email', 'woocommerce' ); ?></label>
						<input class="woocommerce-Input woocommerce-Input--text input-text" type="text" name="user_login" id="user_login" autocomplete="username" />
					</p>

					<div class="clear"></div>

					<?php do_action( 'woocommerce_lostpassword_form' ); ?>

					<p class="woocommerce-form-row form-row zardkooh-login-row">
						<input type="hidden" name="wc_reset_password" value="true" />
						<button type="submit" class="woocommerce-Button button" value="<?php esc_attr_e( 'Reset password', 'woocommerce' ); ?>"><?php esc_html_e( 'Reset password', 'woocommerce' ); ?></button>
					</p>

					<?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

				</form>
				
				<?php do_action( 'woocommerce_after_lost_password_form' ); ?>
			</div>
		</div>
		<div class="account-box-footer">
			<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="btn-link-border"><?php echo _e ('Login To Site','zardkooh');?></a>
		</div>
	</div>
	<a href="<?php echo home_url('/');?>" class="account-page-return"><?php echo _e ('Return To Homepage','zardkooh');?></a>
</div>