<?php
/**
 * Product attributes
 *
 * Used by list_attributes() in the products class.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-attributes.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! $product_attributes ) {
	return;
}

global $product, $zardkooh_options;

$together_title = isset($zardkooh_options['together_items_title']) && $zardkooh_options['together_items_title'] !== '' ? $zardkooh_options['together_items_title'] : __('Together Items', 'zardkooh');
$garanty_title = isset($zardkooh_options['product_garanty_title']) && $zardkooh_options['product_garanty_title'] !== '' ? $zardkooh_options['product_garanty_title'] : __('Product Garanty', 'zardkooh');

$together_items		= get_post_meta($product->get_id(), 'together_items', true);
$product_garanty	= get_post_meta($product->get_id(), 'product_garanty', true);
?>
<div class="woocommerce-tabs wc-tabs-wrapper">
	<ul class="tabs wc-tabs" role="tablist">
		<li class="features_tab" id="tab-title-features" role="tab" aria-controls="tab-features">
			<a href="#tab-features"><?php echo _e( 'Specification','zardkooh' ); ?></a>
		</li>
		<?php if ( $together_items ) { ?>
			<li class="together_tab" id="tab-title-together" role="tab" aria-controls="tab-together">
				<a href="#tab-together"><?php echo $together_title; ?></a>
			</li>
		<?php } ?>
		<?php if ( $product_garanty ) { ?>
			<li class="garanty_tab" id="tab-title-garanty" role="tab" aria-controls="tab-garanty">
				<a href="#tab-garanty"><?php echo $garanty_title; ?></a>
			</li>
		<?php } ?>
	</ul>
	
	<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--features panel entry-content wc-tab" id="tab-features" role="tabpanel" aria-labelledby="tab-title-features">
		<table class="zardkooh-attributes-table">
			<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
                <tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--<?php echo esc_attr( $product_attribute_key ); ?>">
                    <th class="zardkooh-attributes-table-name"><?php echo wp_kses_post( $product_attribute['label'] ); ?></th>
                    <td class="zardkooh-attributes-table-value"><?php echo wp_kses_post( $product_attribute['value'] ); ?></td>
                </tr>
			<?php endforeach; ?>
		</table>
	</div>
	
	<?php if ( $together_items ) { ?>
		<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--together panel entry-content wc-tab" id="tab-together" role="tabpanel" aria-labelledby="tab-title-together">
			<?php echo $together_items; ?>
		</div>
	<?php } ?>
	<?php if ( $product_garanty ) { ?>
		<div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--garanty panel entry-content wc-tab" id="tab-garanty" role="tabpanel" aria-labelledby="tab-title-garanty">
			<?php echo $product_garanty; ?>
		</div>
	<?php } ?>
</div>