<?php
	
	if($_SERVER["REMOTE_ADDR"]!='94.139.167.81'){
die("site is under construction");
}

/**
 *
 * This is the template that displays all of the <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"> section and everything up until <div id="content">
 *
 */
global $zardkooh_options, $wp, $current_user;

if ( isset( $zardkooh_options['favicon'] ) && strlen( $zardkooh_options['favicon']['url'] ) > 0 ) {
	$favicon_href = $zardkooh_options['favicon']['url'];
} else {
	$favicon_href = get_template_directory_uri().'/assets/images/favicon.png';
}

if ( isset( $zardkooh_options['logo'] ) && strlen( $zardkooh_options['logo']['url'] ) > 0 ) {
	$logo_href		= $zardkooh_options['logo']['url'];
	$logo_width		= $zardkooh_options['logo']['width'];
	$logo_height	= $zardkooh_options['logo']['height'];
} else {
	$logo_href		= get_template_directory_uri().'/assets/images/logo.svg';
	$logo_width		= 119;
	$logo_height	= 33;
}

$wishlist_count = 0;
$user_wishlist = get_user_meta( $current_user->ID, 'zardkooh_wishlist', true);
if ( is_array($user_wishlist) && !empty($user_wishlist) ) {
	$wishlist_count = count($user_wishlist);
}

$user_name = ( $current_user->first_name ) ? $current_user->first_name .' '.$current_user->last_name : $current_user->display_name;

$cart_count = WC()->cart->get_cart_contents_count();

$header_diff = false;
if ( isset( $zardkooh_options['header_diff'] ) && $zardkooh_options['header_diff'] == 'one' && !is_page_template('template-categories.php') && !zardkooh_is_mobile() ) {
    $header_diff = true;
}

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="shortcut icon" href="<?php echo $favicon_href; ?>"/>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php 

	
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	?>
	
	<?php if ( !is_login_register_lostpassword() ) { ?>
	<header class="zardkooh-header">
		
		<?php if ( isset($zardkooh_options['top_bar']) && $zardkooh_options['top_bar'] && ( isset($zardkooh_options['top_bar_link']) || isset($zardkooh_options['top_bar_text']) ) ) { ?>
		<div class="top-header-banner">
			<?php if ( isset($zardkooh_options['top_bar_link']) && $zardkooh_options['top_bar_link'] ) { echo '<a href="'.$zardkooh_options['top_bar_link'].'" target="_blank">'; } ?>
				<?php if ( isset($zardkooh_options['top_bar_text']) && $zardkooh_options['top_bar_text'] ) { echo $zardkooh_options['top_bar_text']; }?>
			<?php if ( isset($zardkooh_options['top_bar_link']) && $zardkooh_options['top_bar_link'] ) { echo '</a>'; } ?>
		</div>
		<?php } ?>

        <?php if ( $header_diff ) { ?>
            <div class="zardkooh-header-row header-diff">
                <section class="header">
                    <div class="header-top-row">

                        <div class="logo">
                            <a href="<?php echo home_url('/');?>" class="header-logo-img">
                                <img src="<?php echo $logo_href; ?>" alt="<?php echo get_bloginfo();?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>">
                            </a>
                        </div>
                        <div class="search-box">
                            <?php echo do_shortcode('[wcas-search-form]');?>
                        </div>

                        <div class="top-menu">
                            <?php
                            if ( has_nav_menu( 'top' ) ) {
                                wp_nav_menu( array(
                                    'theme_location'=> 'top',
                                    'container'		=> false,
                                ) );
                            } ?>
                        </div>

                    </div>

                    <div class="header-bottom-row">

                        <?php if( !is_page_template('template-categories.php') ) { ?>
                            <?php if ( !zardkooh_is_mobile() ) { ?>
                                <div class="main-menu">
                                    <?php echo zardkooh_department_menu(); ?>
                                    <?php zardkooh_main_menu(); ?>
                                </div>
                            <?php } ?>
                        <?php } ?>

                        <div class="header-side">

                            <div class="header-actions">
                                <div class="actions-box">
                                    <?php if ( zardkooh_is_mobile() ) { zardkooh_mobile_menu_walker(); ?>
                                        <div class="main-menu">
                                            <button class="header-menu-icon"><span class="divider"></span></button>
                                        </div>
                                    <?php } ?>
                                    <ul class="top-icons">
                                        <li class="header-wishlist">
                                            <a class="header-wish-container-btn" href="<?php echo wc_get_endpoint_url( 'mywishlist', '', wc_get_page_permalink( 'myaccount' ) ); ?>">
                                                <span class="wishlist-count"><?php echo $wishlist_count; ?></span>
                                            </a>
                                        </li>
                                        <li class="header-cart">
                                            <a class="header-cart-container-btn" id="cart-toggle">
                                                <?php if ( $cart_count > 0 ) { ?>
                                                    <span class="header-cart-count"><?php echo $cart_count;?></span>
                                                <?php } ?>
                                                <?php echo _e('Cart','zardkooh');?>
                                            </a>

                                            <?php if ( $cart_count > 0 ) { ?>
                                                <div class="header-list-dropdown-basket" id="cart-menu">
                                                    <ul class="header-basket-list">
                                                        <?php
                                                        foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                                            $cart_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                                            $product_id		= apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                                                            if ( $cart_product && $cart_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

                                                                $product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $cart_product->is_visible() ? $cart_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
                                                                $thumbnail = get_the_post_thumbnail_url($product_id);
                                                                ?>
                                                                <li class="header-basket-list-item-box">
                                                                    <a href="<?php echo esc_url( $product_permalink ); ?>" class="header-basket-list-item">
                                                                        <div class="header-basket-list-item-content">
                                                                            <div class="header-basket-list-item-image">
                                                                                <img alt="<?php echo $cart_product->get_name(); ?>" src="<?php echo $thumbnail; ?>">
                                                                            </div>
                                                                            <div class="header-basket-list-item-details">
                                                                                <div class="header-basket-list-item-title"><?php echo $cart_product->get_name(); ?></div>
                                                                                <div class="header-basket-list-item-params">
                                                                                    <span class="single-p-box-colors"><?php echo zardkooh_display_cart_product_color($cart_product);?></span>
                                                                                    <span class="cart-item-count"><?php echo $cart_item['quantity']; ?> <?php echo _e('Item','zardkooh');?></span>
                                                                                    <button class="header-basket-list-item-remove" data-key="<?php echo $cart_item_key; ?>"></button>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </a>
                                                                </li>
                                                            <?php } } ?>
                                                    </ul>
                                                    <div class="header-cart-total">
                                                        <span class="header-cart-total-text"><?php echo _e('Total Buy Amount:','zardkooh');?></span>
                                                        <p class="header-cart-total-amount">
                                                            <?php echo number_format(WC()->cart->get_cart_contents_total()); ?>
                                                            <span class="cart-woocommerce-currency"><?php echo get_woocommerce_currency_symbol();?></span>
                                                        </p>
                                                    </div>
                                                    <div class="header-cart-buttons">
                                                        <a href="<?php echo wc_get_cart_url(); ?>" class="header-list-dropdown-basket-link"><?php echo _e('View Cart','zardkooh');?></a>
                                                        <a href="<?php echo esc_url( wc_get_checkout_url() );?>" class="header-basket-submit"><?php echo _e('Submit Order','zardkooh');?></a>
                                                    </div>
                                                </div>
                                            <?php } else { ?>
                                                <div class="header-list-dropdown-basket is-empty" id="cart-menu">
                                                    <div class="header-list-dropdown-empty"></div>
                                                    <span><?php echo _e('Your cart is empty','zardkooh');?></span>
                                                </div>
                                            <?php } ?>
                                        </li>
                                        <li class="header-user">
                                            <?php if ( is_user_logged_in() ) { ?>
                                                <a class="header-user-container-btn" id="user-toggle">
                                                    <span><?php echo $user_name; ?></span>
                                                </a>

                                                <div class="header-profile-dropdown" id="user-menu">
                                                    <div class="header-profile-dropdown-account-container">
                                                        <div class="header-profile-dropdown-user">
                                                            <div class="header-profile-dropdown-avatar"></div>
                                                            <div class="header-profile-dropdown-user-info">
                                                                <p class="header-profile-dropdown-user-name">
                                                                    <?php echo $user_name; ?>
                                                                </p>
                                                                <span class="header-profile-dropdown-user-profile-link"><?php echo _e('View Account','zardkooh');?></span>
                                                            </div>
                                                        </div>
                                                        <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="header-profile-dropdown-user-profile-full-link"></a>
                                                    </div>

                                                    <div class="header-profile-dropdown-actions">
                                                        <a href="<?php echo wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) ); ?>" class="profile-action-orders"><?php echo _e('My Orders','zardkooh');?></a>
                                                        <a href="<?php echo wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) ); ?>" class="profile-action-info"><?php echo _e('Personal Information','zardkooh');?></a>
                                                    </div>
                                                    <a href="<?php echo wp_logout_url( home_url( $wp->request ) ) ?>" class="header-profile-dropdown-logout"><?php echo _e('Logout From Account','zardkooh');?></a>
                                                </div>
                                            <?php } else { ?>
                                                <a class="header-user-container-btn not-logged-in" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><?php echo _e('Login','zardkooh');?></a>
                                            <?php } ?>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                        </div>

                    </div>
                </section>
            </div>
        <?php } else { ?>
		<div class="zardkooh-header-row">
			<section class="header">
				<div class="logo">
					<a href="<?php echo home_url('/');?>" class="header-logo-img">
                        <img src="<?php echo $logo_href; ?>" alt="<?php echo get_bloginfo();?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>">
                    </a>
                </div>
				<div class="header-side">
					<div class="top-menu">
						<?php
						if ( has_nav_menu( 'top' ) ) {
							wp_nav_menu( array(
								'theme_location'=> 'top',
								'container'		=> false,
							) );
						} ?>
					</div>
					<div class="header-actions">
						<div class="search-box">
							<?php echo do_shortcode('[wcas-search-form]');?>
						</div>

						<div class="actions-box">
							<?php if ( zardkooh_is_mobile() ) { zardkooh_mobile_menu_walker(); ?>
								<div class="main-menu">
									<button class="header-menu-icon"><span class="divider"></span></button>
								</div>
							<?php } ?>
							<ul class="top-icons">
								<li class="header-wishlist">
									<a class="header-wish-container-btn" href="<?php echo wc_get_endpoint_url( 'mywishlist', '', wc_get_page_permalink( 'myaccount' ) ); ?>">
                                        <span class="wishlist-count"><?php echo $wishlist_count; ?></span>
                                    </a>
                                </li>
								<li class="header-cart">
									<a class="header-cart-container-btn" id="cart-toggle">
										<?php if ( $cart_count > 0 ) { ?>
											<span class="header-cart-count"><?php echo $cart_count;?></span>
										<?php } ?>
										<?php echo _e('Cart','zardkooh');?>
									</a>

									<?php if ( $cart_count > 0 ) { ?>
										<div class="header-list-dropdown-basket" id="cart-menu">
											<ul class="header-basket-list">
												<?php
												foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
													$cart_product   = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
													$product_id		= apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

													if ( $cart_product && $cart_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

														$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $cart_product->is_visible() ? $cart_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
														$thumbnail = get_the_post_thumbnail_url($product_id);
														?>
														<li class="header-basket-list-item-box">
															<a href="<?php echo esc_url( $product_permalink ); ?>" class="header-basket-list-item">
																<div class="header-basket-list-item-content">
																	<div class="header-basket-list-item-image">
																		<img alt="<?php echo $cart_product->get_name(); ?>" src="<?php echo $thumbnail; ?>">
																	</div>
																	<div class="header-basket-list-item-details">
																		<div class="header-basket-list-item-title"><?php echo $cart_product->get_name(); ?></div>
																		<div class="header-basket-list-item-params">
																			<span class="single-p-box-colors"><?php echo zardkooh_display_cart_product_color($cart_product);?></span>
																			<span class="cart-item-count"><?php echo $cart_item['quantity']; ?> <?php echo _e('Item','zardkooh');?></span>
																			<button class="header-basket-list-item-remove" data-key="<?php echo $cart_item_key; ?>"></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </li>
                                                <?php } } ?>
                                            </ul>
											<div class="header-cart-total">
												<span class="header-cart-total-text"><?php echo _e('Total Buy Amount:','zardkooh');?></span>
												<p class="header-cart-total-amount">
													<?php echo number_format(WC()->cart->get_cart_contents_total()); ?>
													<span class="cart-woocommerce-currency"><?php echo get_woocommerce_currency_symbol();?></span>
												</p>
											</div>
											<div class="header-cart-buttons">
												<a href="<?php echo wc_get_cart_url(); ?>" class="header-list-dropdown-basket-link"><?php echo _e('View Cart','zardkooh');?></a>
												<a href="<?php echo esc_url( wc_get_checkout_url() );?>" class="header-basket-submit"><?php echo _e('Submit Order','zardkooh');?></a>
											</div>
                                        </div>
                                    <?php } else { ?>
										<div class="header-list-dropdown-basket is-empty" id="cart-menu">
											<div class="header-list-dropdown-empty"></div>
											<span><?php echo _e('Your cart is empty','zardkooh');?></span>
                                        </div>
                                    <?php } ?>
                                </li>
								<li class="header-user">
									<?php if ( is_user_logged_in() ) { ?>
										<a class="header-user-container-btn" id="user-toggle">
                                            <span><?php echo $user_name; ?></span>
                                        </a>
											
										<div class="header-profile-dropdown" id="user-menu">
											<div class="header-profile-dropdown-account-container">
												<div class="header-profile-dropdown-user">
													<div class="header-profile-dropdown-avatar"></div>
													<div class="header-profile-dropdown-user-info">
														<p class="header-profile-dropdown-user-name">
                                                            <?php echo $user_name; ?>
                                                        </p>
														<span class="header-profile-dropdown-user-profile-link"><?php echo _e('View Account','zardkooh');?></span>
                                                    </div>
                                                </div>
												<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="header-profile-dropdown-user-profile-full-link"></a>
                                            </div>
												
											<div class="header-profile-dropdown-actions">
												<a href="<?php echo wc_get_endpoint_url( 'orders', '', wc_get_page_permalink( 'myaccount' ) ); ?>" class="profile-action-orders"><?php echo _e('My Orders','zardkooh');?></a>
												<a href="<?php echo wc_get_endpoint_url( 'edit-account', '', wc_get_page_permalink( 'myaccount' ) ); ?>" class="profile-action-info"><?php echo _e('Personal Information','zardkooh');?></a>
											</div>
											<a href="<?php echo wp_logout_url( home_url( $wp->request ) ) ?>" class="header-profile-dropdown-logout"><?php echo _e('Logout From Account','zardkooh');?></a>
                                        </div>
                                    <?php } else { ?>
										<a class="header-user-container-btn not-logged-in" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>"><?php echo _e('Login','zardkooh');?></a>
									<?php } ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>
			<?php if( !is_page_template('template-categories.php') ) { ?>
				<?php if ( !zardkooh_is_mobile() ) { ?>
					<div class="main-menu">
						<?php echo zardkooh_department_menu(); ?>
						<?php zardkooh_main_menu(); ?>
                    </div>
                <?php } ?>
            <?php } ?>
		</div>
        <?php } ?>
	</header>
	<?php } ?>
	
	<div id="content" class="site-content">