<?php
/**
 * Cando Blog Widget 1 Template
 */
 ?>
 
<div class="zardkooh-blog zardkooh-dep-blog-widget">
	<div class="zardkooh-dep-blog">
		<?php
		if ( $video ) {
			$video_time = get_post_meta($video->ID, 'video_time', true);
			?>
			<a href="<?php echo get_permalink($video->ID); ?>" class="dep-blog-video">
				<div class="dep-blog-video-img">
					<span class="image-overlay"></span>
                    <div class="dep-blog-video-bg" style="background-image: url(<?php echo get_the_post_thumbnail_url($video->ID); ?>);"></div>
					<div class="dep-blog-video-title"><?php echo get_the_title($video->ID); ?></div>
					<?php if ( $video_time ) { ?>
						<span class="dep-blog-video-time"><?php echo $video_time; ?></span>
					<?php } ?>
				</div>
			</a>
		<?php } ?>
		<div class="row zardkooh-dep-blog-fix">
			<?php
				while ($dep_blog_query->have_posts()):
				$dep_blog_query->the_post();
				global $post;
				$post_id = $post->ID;
				?>
				<div class="col-md-4">
					<a href="<?php the_permalink() ?>" id="post-<?php the_ID(); ?>" class="blog-post-box" style="background-image:url('<?php echo the_post_thumbnail_url();?>');">
						<span class="image-overlay"></span>
						<div class="blog-post-box-content">
							<div class="post-title"><?php the_title(); ?></div>
							<div class="post-description"><?php echo wp_trim_words(apply_filters('the_content', get_the_content()), 18, '...'); ?></div>
							<div class="post-details">
								<span class="view-more"><?php echo _e('View More', 'zardkooh'); ?></span>
								<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
									<span class="post-rate">
										<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</div>
										<div class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></div>
									</span>
								<?php } ?>
							</div>
						</div>
					</a>
				</div>
			<?php endwhile; ?>
		</div>
	</div>
</div>