<?php
/**
 * Cando Blog Widget 2 Template
 */
 ?>
 
<?php if ( $show_videos ) { ?>
	<section class="products-slider-container video-posts-slider">
		<div class="products-slider-header">
			<h2><?php echo $title; ?></h2>
			<?php if ($categories) { ?>
				<a href="<?php echo get_category_link($categories); ?>" class="products-slider-header-more"><?php echo _e('See More','zardkooh');?></a>
			<?php } ?>
		</div>
		<?php if ( !zardkooh_is_mobile() ) { ?>
			<div class="products-swiper-box">
				<div class="swiper-container swiper-container-products4" <?php language_attributes(); ?>>
					<div class="swiper-wrapper">
						<?php
						while ($nikan_news_query->have_posts()):
						$nikan_news_query->the_post();
						global $post;
						$video_time = get_post_meta($post->ID, 'video_time', true);
						?>
						<div class="swiper-slide">
							<div class="products-swiper-video-box news-swiper">
								<a href="<?php the_permalink(); ?>" class="products-swiper-link">
									<div class="products-swiper-img" href="<?php the_permalink(); ?>">
										<img alt="<?php the_title(); ?>" class="swiper-lazy" data-src="<?php the_post_thumbnail_url('medium'); ?>" src="<?php the_post_thumbnail_url('medium'); ?>" width="270" height="175">
									</div>
									<div class="products-swiper-title"><?php the_title(); ?></div>
									<?php if ( $video_time ) { ?>
										<div class="products-swiper-time-box">
											<span class="products-swiper-time"><?php echo $video_time; ?></span>
										</div>
									<?php } ?>
								</a>
							</div>
						</div>
						<?php endwhile; ?>
					</div>
				</div>
			</div>
		<?php } else { ?>
			<div class="zardkooh-products-row zardkooh-video-row">
					<?php
					while ($nikan_news_query->have_posts()):
					$nikan_news_query->the_post();
					global $post;
					$video_time = get_post_meta($post->ID, 'video_time', true);
					?>
					<div class="products-swiper-p-box products-swiper-video-box">
						<a href="<?php the_permalink(); ?>" class="products-swiper-link">
							<div class="products-swiper-img">
								<img alt="<?php the_title(); ?>" class="swiper-lazy" data-src="<?php the_post_thumbnail_url(array(270,175)); ?>" src="<?php the_post_thumbnail_url(array(270,175)); ?>" width="270" height="175">
							</div>
							<div class="products-swiper-title"><?php echo get_the_title(); ?></div>
							<?php if ( $video_time ) { ?>
								<span class="products-swiper-time"><?php echo $video_time; ?></span>
							<?php } ?>
						</a>
					</div>
					<?php endwhile; ?>
			</div>
		<?php } ?>
	</section>
<?php } else { ?>
	<div class="zardkooh-widget white-box">
		<h2 class="widget-title"><?php echo $title; ?></h2>
		<ul id="newsItems" class="news-list">
			<?php
			while ($nikan_news_query->have_posts()):
			$nikan_news_query->the_post();
			global $post;
			?>
			<li>
				<a class="news-item" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" target="_blank">
					<div class="item-thumb">
						<img src="<?php the_post_thumbnail_url('blog-thumb'); ?>" alt="<?php the_title(); ?>" width="58">
					</div>
					<div class="item-info">
						<div class="title"><?php the_title(); ?></div>
						<div class="item-footer">
							<span><?php echo get_the_date('Y/m/d'); ?></span>
							<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating() ) { ?>
								<span class="post-rate">
									<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating()); ?></span>/5</div>
									<div class="average-stars"><?php echo rmp_get_visual_rating(); ?></div>
								</span>
							<?php } ?>
						</div>
					</div>
				</a>
			</li>
			<?php endwhile; ?>
		</ul>
		<?php if ($categories) { ?>
			<a class="news-list-more" target="_blank" href="<?php echo get_category_link($categories); ?>"><?php echo _e ('Show More','zardkooh');?></a>
		<?php } ?>
	</div>
<?php } ?>