<?php
/**
 * Cando Blog Widget 3 Template
 */
 ?>
 
<div class="zardkooh-blog">
	<h2><?php echo $title; ?></h2>
	<div class="row">
		<?php
			while ($nikan_blog_query->have_posts()):
			$nikan_blog_query->the_post();
			global $post;
			$post_id = $post->ID;
			?>
			<div class="col-md-3">
				<a href="<?php the_permalink() ?>" id="post-<?php the_ID(); ?>" class="blog-post-box" style="background-image:url('<?php echo the_post_thumbnail_url();?>');">
					<span class="image-overlay"></span>
					<div class="blog-post-box-content">
						<div class="post-title"><?php the_title(); ?></div>
						<div class="post-description"><?php echo wp_trim_words(apply_filters('the_content', get_the_content()), 18, '...'); ?></div>
						<div class="post-details">
							<span class="view-more"><?php echo _e('View More', 'zardkooh'); ?></span>
							<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
								<span class="post-rate">
									<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</div>
									<div class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></div>
								</span>
							<?php } ?>
						</div>
					</div>
				</a>
			</div>
			<?php endwhile; ?>
	</div>
	<div class="row blog-navigation">
		<div class="col-md-12">
			<?php zardkooh_vc_blog_pagination($max_num_pages); ?>
		</div>
	</div>
</div>