<?php
/**
 * Template for displaying search forms
 *
 */

?>

<?php $unique_id = esc_attr( uniqid( 'search-form-' ) ); ?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label for="<?php echo $unique_id; ?>">
		<span class="screen-reader-text"><?php echo _e( 'Search for:', 'zardkooh' ); ?></span>
	</label>
	<input type="search" id="<?php echo $unique_id; ?>" class="search-field" placeholder="<?php echo _e( 'Search &hellip;', 'zardkooh' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	<input type="hidden" name="post_type" value="post">
	<button type="submit" class="btn-default"><?php echo _e( 'Search', 'zardkooh' ); ?></button>
</form>
