<?php
/**
 * Cart item data (when outputting non-flat)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-item-data.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version 	2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $zardkooh_options;

$color_attribute = '';
if ( isset($zardkooh_options['loop_color_attribute']) && $zardkooh_options['loop_color_attribute'] !== -1 ) {
	$color_taxonomy		= wc_attribute_taxonomy_name( urldecode( $zardkooh_options['loop_color_attribute'] ) );
	$color_attribute	= wc_attribute_label($color_taxonomy);
}

?>
<dl class="variation">
	<?php foreach ( $item_data as $data ) : ?>
		<?php if ( $data['key'] !== 'seller-name' && $data['key'] !== $color_attribute ) { ?>
			<dt class="<?php echo sanitize_html_class( 'variation-' . $data['key'] ); ?>"><?php echo wp_kses_post( $data['key'] ); ?>:</dt>
		<?php } ?>
		<dd class="<?php echo sanitize_html_class( 'variation-' . $data['key'] ); ?>">
			<?php if ( $data['key'] == $color_attribute ) { ?>
				<span class="cart-item-color" style="background-color:<?php echo zardkooh_display_cart_product_color_key($data['value']); ?>"></span>
			<?php } ?>
			
			<?php echo wp_kses_post( wpautop( $data['display'] ) ); ?>
		</dd>
	<?php endforeach; ?>
</dl>
