<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$customer_id = get_current_user_id();

/*if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing'  => __( 'Billing address', 'woocommerce' ),
            'shipping' => __( 'Shipping address', 'woocommerce' ),
        ),
        $customer_id
    );
} else {*/
    $get_addresses = apply_filters(
        'woocommerce_my_account_get_addresses',
        array(
            'billing' => __( 'Billing address', 'woocommerce' ),
        ),
        $customer_id
    );
/* } */
?>

<div class="account-headline">
	<span><?php _e ( 'Addresses','zardkooh' ); ?></span>
</div>

<div class="row">
	<?php
	do_action( 'zardkooh_before_account_addresses' );

    foreach ( $get_addresses as $name => $title ) {
        $address = wc_get_account_formatted_address( $name );
        if ( $address ) {
            $address = explode ("<br/>",$address);
            if ( count($address) == 6 ) {
                $number = 1;
            } else {
                $number = 0;
            }
            $user_phone	= get_user_meta($customer_id , $name.'_phone' ,true);
		    ?>
			<div class="account-address-row">
				<div class="account-address-container">
					<div class="account-address-box-content">
					
						<h4>
                            <?php _e ( 'State ','zardkooh' ); ?><span><?php echo $address[1+$number]; ?></span><?php _e ( ' , City ','zardkooh' ); ?><span><?php echo $address[2+$number]; ?></span>، <span><?php echo $address[3+$number]; ?></span>
                        </h4>
						
						<div class="zardkooh-current-address-details">
							<span class="zardkooh-current-address-name"><?php echo $address[0]; if ( count($address) == 6 ) { echo ' ('.$address[1].')'; } ?></span>
							<span class="zardkooh-current-address-postal"><?php echo _e('Postal Code: ', 'zardkooh'); ?><?php echo $address[4+$number]; ?></span>
							<span class="zardkooh-current-address-phone"><?php echo _e('Phone Number: ', 'zardkooh'); ?><?php echo $user_phone; ?></span>
						</div>
					</div>
					<div class="account-address-box-buttons">
						<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>"><span class="zardkooh-edit-current-address"><?php echo _e('Edit Address', 'zardkooh'); ?></span></a>
					</div>
					
				</div>
				<div class="account-address-map" id="map-<?php echo $name; ?>"></div>
			</div>
        <?php } else { ?>
            <a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="zardkooh-add-new-address account-address-add">
                <?php _e ( 'Add ','zardkooh' ); ?><?php echo $title; ?>
            </a>
        <?php
        }
    }
	?>
</div>