<?php
/**
 * Description tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || exit;

global $post;

$heading = apply_filters( 'woocommerce_product_description_heading', __( 'Description', 'woocommerce' ) );

$catalog_link = get_post_meta( $post->ID, 'product_catalog', true);
?>

<?php if ( $heading || ( $catalog_link && $catalog_link !== '' )  ) : ?>
	<h2>
		<?php echo esc_html( $heading ); ?>
		<?php if ( $catalog_link ) {
			echo '<a href="'.$catalog_link.'" class="download-catalog">'.__('Download Product Catalog','zardkooh').'</a>';
		} ?>
	</h2>
<?php endif; ?>

<div class="read-more-excerpt">
    <div class="read-more-excerpt-text" style="max-height: 250px; height: unset;">
        <?php the_content(); ?>
    </div>
    <a class="read-more-excerpt-anchor hidden" ><?php _e('More','zardkooh'); ?></a>
</div>
