<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

get_header();

$section_class = 'col-sm-12';
$post_class = 'col-md-3';
if ( is_active_sidebar( 'blog-sidebar' ) ) {
    $section_class = 'col-sm-9';
    $post_class = 'col-md-4';
}
?>

<div class="container main-warp">
	<?php zardkooh_breadcrumbs(); ?>
	<div class="row">
		<section class="<?php echo $section_class; ?>">
			<?php if ( have_posts() ) : ?>
				<div class="row">
				<?php while ( have_posts() ) : the_post(); ?>
					<div class="<?php echo $post_class; ?>">
						<a href="<?php the_permalink() ?>" id="post-<?php the_ID(); ?>" class="blog-post-box" style="background-image:url('<?php echo the_post_thumbnail_url();?>');">
							<span class="image-overlay"></span>
							<div class="blog-post-box-content">
								<div class="post-title"><?php the_title(); ?></div>
								<div class="post-description"><?php echo wp_trim_words(apply_filters('the_content', get_the_content()), 18, '...'); ?></div>
								<div class="post-details">
									<span class="view-more"><?php echo _e('View More', 'zardkooh'); ?></span>
									<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating() ) { ?>
										<span class="post-rate">
											<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating()); ?></span>/5</div>
											<div class="average-stars"><?php echo rmp_get_visual_rating(); ?></div>
										</span>
									<?php } ?>
								</div>
							</div>
						</a>
					</div>
				<?php endwhile; // End of the loop.	?>
				</div>
				<div class="row blog-navigation">
					<div class="col-md-12">
						<?php zardkooh_blog_pagination(); ?>
					</div>
				</div>
				
			<?php else : ?>
				<div class="row">
					<section class="col-sm-12">
						<div class="account-empty-content"><?php echo _e('There is no items to show!', 'zardkooh'); ?></div>
					</section>
				</div>
			
			<?php endif; ?>
		</section>
			
		<?php if ( is_active_sidebar( 'blog-sidebar' ) ) { ?>
			<aside class="col-sm-3 blog-sidebar">
				<?php dynamic_sidebar( 'blog-sidebar' ); ?>
			</aside>
		<?php } ?>
	</div>
</div><!-- .container main -->

<?php get_footer();
