<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 */
global $zardkooh_options;

if ( isset( $zardkooh_options['logo-footer'] ) && strlen( $zardkooh_options['logo-footer']['url'] ) > 0 ) {
    $logo_href		= $zardkooh_options['logo-footer']['url'];
    $logo_width		= $zardkooh_options['logo-footer']['width'];
    $logo_height	= $zardkooh_options['logo-footer']['height'];
} else {
	$logo_href		= get_template_directory_uri().'/assets/images/logo-footer.svg';
	$logo_width		= 160;
	$logo_height	= 40;
}
?>
	</div>
	
	<?php if ( !is_login_register_lostpassword() ) { ?>
	<footer>
		<div class="container">
			<div class="row">
				<div class="footer-cols-row">
					<div class="footer-col">
						<div class="footer-col-top">
							<a href="<?php echo home_url('/');?>" class="header-logo-img">
								<img src="<?php echo $logo_href; ?>" alt="<?php echo get_bloginfo();?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>">
							</a>
						</div>
						
						<div class="footer-col-bottom">
							<?php if ( is_active_sidebar( 'footer-col-1' ) ) { dynamic_sidebar( 'footer-col-1' ); } ?>
						</div>
					</div>
					
					<div class="footer-col">
						<div class="footer-col-top">
							<span class="footer-icons footer-call"></span>
							<div class="footer-top-info">
								<span><?php echo _e('Phone Number','zardkooh');?></span>
								<span>
								<?php if ( isset($zardkooh_options['footer_phone']) && $zardkooh_options['footer_phone'] ) {
									echo $zardkooh_options['footer_phone'];
								} ?>
								</span>
							</div>
						</div>
						
						<?php if ( !zardkooh_is_mobile() ) { ?>
						<div class="footer-col-bottom">
							<?php if ( is_active_sidebar( 'footer-col-2' ) ) { dynamic_sidebar( 'footer-col-2' ); } ?>
						</div>
						<?php } ?>
					</div>
						
					<div class="footer-col">
						<div class="footer-col-top">
							<span class="footer-icons footer-time"></span>
							<div class="footer-top-info">
								<span><?php echo _e('Work Hours','zardkooh');?></span>
								<span>
								<?php if ( isset($zardkooh_options['footer_hours']) && $zardkooh_options['footer_hours'] ) {
									echo $zardkooh_options['footer_hours'];
								} ?>
								</span>
							</div>
						</div>
						
						<?php if ( !zardkooh_is_mobile() ) { ?>
						<div class="footer-col-bottom">
							<?php if ( is_active_sidebar( 'footer-col-3' ) ) { dynamic_sidebar( 'footer-col-3' ); } ?>
						</div>
						<?php } ?>
					</div>
					
					<div class="footer-col">
						<div class="footer-col-top">
							<span class="footer-icons footer-pin"></span>
							<div class="footer-top-info">
								<span><?php echo _e('Centeral Office','zardkooh');?></span>
								<?php if ( isset($zardkooh_options['footer_address']) && $zardkooh_options['footer_address'] ) {
									echo '<span>'.$zardkooh_options['footer_address'].'</span>';
								} ?>
							</div>
						</div>
						
						<div class="footer-col-bottom">
							<div class="footer-cols-newslater">
								<?php
								$placeholder = __('Please Enter Your Email Address','zardkooh');
								if ( isset($zardkooh_options['footernewslater_email_mobile']) && $zardkooh_options['footernewslater_email_mobile'] == 'mobile' ) {
									$placeholder = __('Please Enter Your Phone Number','zardkooh');
								}
								?>
								<form id="newslaterForm" class="newsletter-form" action="newslaterForm" method="post">
									<fieldset>
										<span><?php echo $zardkooh_options['footernewslater_title'];?></span>
										<div class="newsletter-form-row">
											<input class="newsletter-input" type="text" name="newslater_input" id="newslater_input" placeholder="<?php echo $placeholder; ?>">
											<button type="submit" class="newsletter-btn" name="newslater-submit" id="newslater-submit"></button>
										</div>
									</fieldset>
								</form>
							</div>

							<ul class="social-networks">
								<?php if ( isset($zardkooh_options['social-telegram']) && $zardkooh_options['social-telegram'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-telegram']; ?>">
										<li><i class="social-icon social-telegram"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-whatsapp']) && $zardkooh_options['social-whatsapp'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-whatsapp']; ?>">
										<li><i class="social-icon social-whatsapp"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-gmail']) && $zardkooh_options['social-gmail'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-gmail']; ?>">
										<li><i class="social-icon social-gmail"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-twitter']) && $zardkooh_options['social-twitter'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-twitter']; ?>">
										<li><i class="social-icon social-twitter"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-instagram']) && $zardkooh_options['social-instagram'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-instagram']; ?>">
										<li><i class="social-icon social-instagram"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-linkedin']) && $zardkooh_options['social-linkedin'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-linkedin']; ?>">
										<li><i class="social-icon social-linkedin"></i></li>
									</a>
								<?php } ?>
								
								<?php if ( isset($zardkooh_options['social-facebook']) && $zardkooh_options['social-facebook'] ) { ?>
									<a href="<?php echo $zardkooh_options['social-facebook']; ?>">
										<li><i class="social-icon social-facebook"></i></li>
									</a>
								<?php } ?>
							</ul>
						</div>
					</div>
				</div>

				<section class="footer">
					<?php if ( isset($zardkooh_options['copyright']) && $zardkooh_options['copyright'] ) { 
						echo '<div class="copyright">'.$zardkooh_options['copyright'].'</div>';
					} ?>
                    <?php if ( isset($zardkooh_options['rasaneh']) || isset($zardkooh_options['enamad']) ) { ?>
					<div class="footer-certificates">
                        <?php if ( isset($zardkooh_options['rasaneh']) && $zardkooh_options['rasaneh'] ) {
                            echo $zardkooh_options['rasaneh'];
                        } ?>

						<?php if ( isset($zardkooh_options['enamad']) && $zardkooh_options['enamad'] ) {
						    echo $zardkooh_options['enamad'];
                        } ?>
					</div>
                    <?php } ?>
				</section>
			</div>
		</div>
	</footer>
	<?php } ?>
	
	</div><!-- #page -->

	<?php do_action('zardkooh_footer_modals'); ?>

	<?php if ( (isset($zardkooh_options['zardkooh_custom_js_footer'])) && strlen( $zardkooh_options['zardkooh_custom_js_footer'] ) > 0 ) : ?>
		<script type="text/javascript">
			<?php echo $zardkooh_options['zardkooh_custom_js_footer']; ?>
		</script>
	<?php endif; ?>

<?php wp_footer(); ?>

</body>
</html>
